/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.elk;

import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.elk.proxy.graph.ElkBendPoint;
import net.sourceforge.plantuml.elk.proxy.graph.ElkEdge;
import net.sourceforge.plantuml.elk.proxy.graph.ElkEdgeSection;
import net.sourceforge.plantuml.elk.proxy.graph.ElkLabel;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.skin.LineParam;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactory;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryExtends;

public class ElkPath
implements UDrawable {
    private final Link link;
    private final ElkEdge edge;
    private final ICucaDiagram diagram;
    private final TextBlock centerLabel;
    private final TextBlock headLabel;
    private final TextBlock tailLabel;
    private final SName styleName;
    private final double magicY2;

    public ElkPath(ICucaDiagram diagram, SName styleName, Link link, ElkEdge edge, TextBlock centerLabel, TextBlock tailLabel, TextBlock headLabel, double magicY2) {
        this.link = link;
        this.edge = edge;
        this.diagram = diagram;
        this.centerLabel = centerLabel;
        this.tailLabel = tailLabel;
        this.headLabel = headLabel;
        this.styleName = styleName;
        this.magicY2 = magicY2;
    }

    private Style getStyle() {
        StyleSignatureBasic signature = StyleSignatureBasic.of(SName.root, SName.element, this.styleName, SName.arrow);
        return signature.getMergedStyle(this.diagram.getCurrentStyleBuilder());
    }

    @Override
    public void drawU(UGraphic ug) {
        double y;
        double x;
        if (this.link.isHidden()) {
            return;
        }
        ISkinParam skinParam = this.diagram.getSkinParam();
        HColor color = this.getStyle().value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
        if (this.link.getColors() != null) {
            HColor newColor = this.link.getColors().getColor(ColorType.ARROW, ColorType.LINE);
            if (newColor != null) {
                color = newColor;
            }
        } else if (this.link.getSpecificColor() != null) {
            color = this.link.getSpecificColor();
        }
        LinkType linkType = this.link.getType();
        UStroke stroke = linkType.getStroke3(skinParam.getThickness(LineParam.arrow, null));
        if (this.link.getColors() != null && this.link.getColors().getSpecificLineStroke() != null) {
            stroke = this.link.getColors().getSpecificLineStroke();
        }
        ug = ug.apply(stroke).apply(color);
        List<ElkEdgeSection> sections = this.edge.getSections();
        if (sections.size() == 0) {
            System.err.println("Strange: no section?");
            System.err.println("Maybe a 'Long hierarchical edge' " + this.edge.isHierarchical());
            return;
        }
        this.drawSections(ug, sections);
        UDrawable extremityFactory1 = this.getDecors(this.link.getType().getDecor1(), 1.5707963267948966, HColors.WHITE);
        UDrawable extremityFactory2 = this.getDecors(this.link.getType().getDecor2(), -1.5707963267948966, HColors.WHITE);
        if (extremityFactory1 != null) {
            x = sections.get(0).getEndX();
            y = sections.get(0).getEndY();
            extremityFactory1.drawU(ug.apply(new UTranslate(x, y)));
        }
        if (extremityFactory2 != null) {
            x = sections.get(0).getStartX();
            y = sections.get(0).getStartY();
            extremityFactory2.drawU(ug.apply(new UTranslate(x, y)));
        }
        this.drawLabels(ug);
    }

    private UDrawable getDecors(LinkDecor decors, double angle, HColor backColor) {
        if (decors == LinkDecor.EXTENDS) {
            return new ExtremityFactoryExtends(backColor).createUDrawable(new XPoint2D(), angle, null);
        }
        ExtremityFactory extremityFactory = decors.getExtremityFactory(backColor);
        if (extremityFactory == null) {
            return null;
        }
        return extremityFactory.createUDrawable(new XPoint2D(), angle, null);
    }

    private void drawLabels(UGraphic ug) {
        for (ElkLabel label : this.edge.getLabels()) {
            TextBlock labelLink;
            double x = label.getX();
            double y = label.getY();
            String type = label.getText();
            if ("X".equals(type)) {
                labelLink = this.centerLabel;
            } else if ("1".equals(type)) {
                labelLink = this.tailLabel;
            } else {
                if (!"2".equals(type)) continue;
                labelLink = this.headLabel;
            }
            labelLink.drawU(ug.apply(new UTranslate(x, y)));
        }
    }

    private void drawSections(UGraphic ug, Collection<ElkEdgeSection> sections) {
        for (ElkEdgeSection section : sections) {
            Collection<ElkBendPoint> points = section.getBendPoints();
            double x1 = section.getStartX();
            double y1 = section.getStartY();
            for (ElkBendPoint pt : points) {
                this.drawLine(ug, x1, y1, pt.getX(), pt.getY());
                x1 = pt.getX();
                y1 = pt.getY();
            }
            this.drawLine(ug, x1, y1, section.getEndX(), section.getEndY() + this.magicY2);
        }
    }

    private void drawLine(UGraphic ug, double x1, double y1, double x2, double y2) {
        ULine line = new ULine(x2 - x1, y2 - y1);
        ug.apply(new UTranslate(x1, y1)).draw(line);
    }
}

