/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.svek.extremity.Extremity;

class ExtremityCircleConnect
extends Extremity {
    private final double px;
    private final double py;
    private final XPoint2D dest;
    private final double radius = 6.0;
    private final double radius2 = 10.0;
    private final double ortho;
    private final HColor backgroundColor;

    @Override
    public XPoint2D somePoint() {
        return this.dest;
    }

    public ExtremityCircleConnect(XPoint2D p1, double ortho, HColor backgroundColor) {
        this.px = p1.getX() - 6.0;
        this.py = p1.getY() - 6.0;
        this.dest = new XPoint2D(p1.getX(), p1.getY());
        this.ortho = ortho;
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(UStroke.withThickness(1.5)).apply(this.backgroundColor.bg());
        ug.apply(new UTranslate(this.dest.getX() - 6.0, this.dest.getY() - 6.0)).draw(UEllipse.build(12.0, 12.0));
        double deg = -this.ortho * 180.0 / Math.PI + 90.0 - 45.0;
        UEllipse arc1 = new UEllipse(20.0, 20.0, deg, 90.0);
        ug.apply(new UTranslate(this.dest.getX() - 10.0, this.dest.getY() - 10.0)).draw(arc1);
    }
}

