/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AnnotatedBuilder;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.BaseFile;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.NamedOutputStream;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramSimplifierActivity;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramSimplifierState;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;

public final class CucaDiagramFileMakerSvek
implements CucaDiagramFileMaker {
    private final ICucaDiagram diagram;

    public CucaDiagramFileMakerSvek(ICucaDiagram diagram) throws IOException {
        this.diagram = diagram;
    }

    @Override
    public ImageData createFile(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        try {
            return this.createFileInternal(os, dotStrings, fileFormatOption);
        }
        catch (InterruptedException e) {
            Logme.error(e);
            throw new IOException(e);
        }
    }

    private GeneralImageBuilder createDotDataImageBuilder(DotMode dotMode, StringBounder stringBounder) {
        DotData dotData = new DotData(this.diagram.getEntityFactory().getRootGroup(), this.getOrderedLinks(), this.diagram.getLeafsvalues(), this.diagram.getUmlDiagramType(), this.diagram.getSkinParam(), this.diagram, this.diagram, this.diagram.getEntityFactory(), this.diagram.isHideEmptyDescriptionForState(), dotMode, this.diagram.getNamespaceSeparator(), this.diagram.getPragma());
        return new GeneralImageBuilder(dotData, this.diagram.getEntityFactory(), this.diagram.getSource(), this.diagram.getPragma(), stringBounder, this.diagram.getUmlDiagramType().getStyleName());
    }

    private ImageData createFileInternal(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        TextBlockBackcolored result;
        StringBounder stringBounder = fileFormatOption.getDefaultStringBounder(this.diagram.getSkinParam());
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            new CucaDiagramSimplifierActivity(this.diagram, dotStrings, stringBounder);
        } else if (this.diagram.getUmlDiagramType() == UmlDiagramType.STATE) {
            new CucaDiagramSimplifierState(this.diagram, dotStrings, stringBounder);
        }
        GeneralImageBuilder svek2 = this.createDotDataImageBuilder(DotMode.NORMAL, stringBounder);
        BaseFile basefile = null;
        if (fileFormatOption.isDebugSvek() && os instanceof NamedOutputStream) {
            basefile = ((NamedOutputStream)os).getBasefile();
        }
        if ((result = svek2.buildImage(basefile, this.diagram.getDotStringSkek())) instanceof GraphvizCrash) {
            svek2 = this.createDotDataImageBuilder(DotMode.NO_LEFT_RIGHT_AND_XLABEL, stringBounder);
            result = svek2.buildImage(basefile, this.diagram.getDotStringSkek());
        }
        AnnotatedBuilder builder = new AnnotatedBuilder(this.diagram, this.diagram.getSkinParam(), stringBounder);
        result = new AnnotatedWorker(this.diagram, this.diagram.getSkinParam(), stringBounder, builder).addAdd(result);
        String widthwarning = this.diagram.getSkinParam().getValue("widthwarning");
        String warningOrError = null;
        if (widthwarning != null && widthwarning.matches("\\d+")) {
            warningOrError = svek2.getWarningOrError(Integer.parseInt(widthwarning));
        }
        result.calculateDimension(stringBounder);
        return this.diagram.createImageBuilder(fileFormatOption).annotations(false).drawable(result).status(result instanceof GraphvizCrash ? 503 : 0).warningOrError(warningOrError).write(os);
    }

    private List<Link> getOrderedLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link l : this.diagram.getLinks()) {
            this.addLinkNew(result, l);
        }
        return result;
    }

    private void addLinkNew(List<Link> result, Link link) {
        for (int i = 0; i < result.size(); ++i) {
            Link other = result.get(i);
            if (!other.sameConnections(link)) continue;
            while (i < result.size() && result.get(i).sameConnections(link)) {
                ++i;
            }
            if (i == result.size()) {
                result.add(link);
            } else {
                result.add(i, link);
            }
            return;
        }
        result.add(link);
    }
}

