/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextGroupingElse
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextGroupingElse(ComponentType type, Display stringsToDisplay, FileFormat fileFormat) {
        this.type = type;
        this.stringsToDisplay = stringsToDisplay;
        this.fileFormat = fileFormat;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        XDimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth();
        if (this.stringsToDisplay.get(0) != null) {
            charArea.drawStringLR("[" + this.stringsToDisplay.get(0) + "]", 2, 0);
        }
        if (this.fileFormat == FileFormat.UTXT) {
            charArea.drawChar('\u2560', 0, -1);
            charArea.drawChar('\u2563', width - 1, -1);
            charArea.drawHLine('\u2550', -1, 1, width - 1, '\u2502', '\u256a');
        } else {
            charArea.drawHLine('~', -1, 1, width - 1);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return 1.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return 1.0;
    }
}

