/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.utils.BlocLines;

public class CommandArrowLong3
extends CommandMultilines2<ActivityDiagram3> {
    public CommandArrowLong3() {
        super(CommandArrowLong3.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    @Override
    public String getPatternEnd() {
        return "^(.*);$";
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandArrowLong3.class.getName(), RegexLeaf.start(), new RegexOr(new RegexLeaf("->"), new RegexLeaf("COLOR", "-\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*(?:(?:;(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)*)*)\\]->")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("LABEL", "(.*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(ActivityDiagram3 diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.removeEmptyColumns();
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        String colorString = line0.get("COLOR", 0);
        if (colorString != null) {
            Rainbow rainbow = Rainbow.build(diagram.getSkinParam(), colorString, diagram.getSkinParam().colorArrowSeparationSpace());
            diagram.setColorNextArrow(rainbow);
        }
        lines = lines.removeStartingAndEnding(line0.get("LABEL", 0), 1);
        diagram.setLabelNextArrow(lines.toDisplay());
        return CommandExecutionResult.ok();
    }

    private <CS extends CharSequence> void removeStarting(List<CS> lines, String data) {
        if (lines.size() == 0) {
            return;
        }
        lines.set(0, data);
    }

    private <CS extends CharSequence> void removeEnding(List<CS> lines) {
        if (lines.size() == 0) {
            return;
        }
        int n = lines.size() - 1;
        CharSequence s = (CharSequence)lines.get(n);
        lines.set(n, s.subSequence(0, s.length() - 1));
    }
}

