/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Control
extends AbstractTextBlock
implements TextBlock {
    private final double margin = 4.0;
    private final double radius = 12.0;
    private final SymbolContext symbolContext;

    public Control(SymbolContext symbolContext) {
        this.symbolContext = symbolContext;
    }

    @Override
    public void drawU(UGraphic ug) {
        double x = 0.0;
        double y = 0.0;
        ug = this.symbolContext.apply(ug);
        UEllipse circle = new UEllipse(24.0, 24.0);
        circle.setDeltaShadow(this.symbolContext.getDeltaShadow());
        ug.apply(new UTranslate(x += 4.0, y += 4.0)).draw(circle);
        ug = ug.apply(new UStroke());
        ug = ug.apply(this.symbolContext.getForeColor().bg());
        UPolygon polygon = new UPolygon();
        polygon.addPoint(0.0, 0.0);
        int xWing = 6;
        int yAperture = 5;
        polygon.addPoint(6.0, -5.0);
        int xContact = 4;
        polygon.addPoint(4.0, 0.0);
        polygon.addPoint(6.0, 5.0);
        polygon.addPoint(0.0, 0.0);
        ug.apply(new UTranslate(x + 12.0 - 4.0, y)).draw(polygon);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(32.0, 32.0);
    }
}

