/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class CircledCharacter
extends AbstractTextBlock
implements TextBlock {
    private final String c;
    private final UFont font;
    private final HColor spotBackColor;
    private final HColor spotBorder;
    private final HColor fontColor;
    private final double radius;

    public CircledCharacter(char c, double radius, UFont font, HColor spotBackColor, HColor spotBorder, HColor fontColor) {
        this.c = "" + c;
        this.radius = radius;
        this.font = font;
        this.spotBackColor = spotBackColor;
        this.spotBorder = spotBorder;
        this.fontColor = fontColor.getAppropriateColor(spotBackColor);
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.spotBorder != null) {
            ug = ug.apply(this.spotBorder);
        }
        ug = ug.apply(this.spotBackColor.bg());
        ug.draw(new UEllipse(this.radius * 2.0, this.radius * 2.0));
        ug = ug.apply(this.fontColor);
        ug = ug.apply(new UTranslate(this.radius, this.radius));
        ug.draw(new UCenteredCharacter(this.c.charAt(0), this.font));
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        return 2.0 * this.radius;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return 2.0 * this.radius;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(this.getPreferredWidth(stringBounder), this.getPreferredHeight(stringBounder));
    }
}

