/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.font;

import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.plantuml.klimt.SvgAttributes;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.FontPosition;
import net.sourceforge.plantuml.klimt.font.FontStyle;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.skin.SkinParamUtils;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class FontConfiguration {
    private final EnumSet<FontStyle> styles;
    private final UFont currentFont;
    private final UFont motherFont;
    private final HColor motherColor;
    private final HColor currentColor;
    private final HColor extendedColor;
    private final FontPosition fontPosition;
    private final SvgAttributes svgAttributes;
    private final UStroke hyperlinkUnderlineStroke;
    private final HColor hyperlinkColor;
    private final int tabSize;

    public String toStringDebug() {
        return this.getFont().toStringDebug() + " " + this.styles.toString();
    }

    public int hashCode() {
        return this.currentFont.hashCode() + this.styles.hashCode() + this.currentColor.hashCode() + this.hashCode(this.extendedColor) + this.hyperlinkColor.hashCode() + this.hashCode(this.hyperlinkUnderlineStroke) + this.fontPosition.hashCode() + this.tabSize;
    }

    private int hashCode(Object obj) {
        if (obj == null) {
            return 43;
        }
        return obj.hashCode();
    }

    private boolean same(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 != null && obj2 != null) {
            return obj1.equals(obj2);
        }
        return false;
    }

    public boolean equals(Object obj) {
        FontConfiguration other = (FontConfiguration)obj;
        return this.currentFont.equals(other.currentFont) && this.styles.equals(other.styles) && this.currentColor.equals(other.currentColor) && this.same(this.extendedColor, other.extendedColor) && this.hyperlinkColor.equals(other.hyperlinkColor) && this.same(this.hyperlinkUnderlineStroke, other.hyperlinkUnderlineStroke) && this.fontPosition.equals((Object)other.fontPosition) && this.tabSize == other.tabSize;
    }

    public static FontConfiguration create(UFont font, HColor color, HColor hyperlinkColor, UStroke hyperlinkUnderlineStroke) {
        return FontConfiguration.create(font, color, hyperlinkColor, hyperlinkUnderlineStroke, 8);
    }

    public static FontConfiguration create(UFont font, HColor color, HColor hyperlinkColor, UStroke hyperlinkUnderlineStroke, int tabSize) {
        return new FontConfiguration(FontConfiguration.getStyles(font), font, color, font, color, null, FontPosition.NORMAL, new SvgAttributes(), hyperlinkColor, hyperlinkUnderlineStroke, tabSize);
    }

    public static FontConfiguration blackBlueTrue(UFont font) {
        return FontConfiguration.create(font, HColors.BLACK.withDark(HColors.WHITE), HColors.BLUE, new UStroke(), 8);
    }

    public static FontConfiguration create(ISkinParam skinParam, FontParam fontParam, Stereotype stereo) {
        return FontConfiguration.create(SkinParamUtils.getFont(skinParam, fontParam, stereo), SkinParamUtils.getFontColor(skinParam, fontParam, stereo), skinParam.getHyperlinkColor(), skinParam.useUnderlineForHyperlink(), skinParam.getTabSize());
    }

    public static FontConfiguration create(ISkinParam skinParam, Style style) {
        return FontConfiguration.create(skinParam, style, null);
    }

    public static FontConfiguration create(ISkinParam skinParam, Style style, Colors colors) {
        HColor color;
        HColor hyperlinkColor = style.value(PName.HyperLinkColor).asColor(skinParam.getIHtmlColorSet());
        UStroke hyperlinkUnderlineStroke = skinParam.useUnderlineForHyperlink();
        HColor hColor = color = colors == null ? null : colors.getColor(ColorType.TEXT);
        if (color == null) {
            color = style.value(PName.FontColor).asColor(skinParam.getIHtmlColorSet());
        }
        return FontConfiguration.create(style.getUFont(), color, hyperlinkColor, hyperlinkUnderlineStroke, skinParam.getTabSize());
    }

    private static EnumSet<FontStyle> getStyles(UFont font) {
        boolean bold = font.isBold();
        boolean italic = font.isItalic();
        if (bold && italic) {
            return EnumSet.of(FontStyle.ITALIC, FontStyle.BOLD);
        }
        if (bold) {
            return EnumSet.of(FontStyle.BOLD);
        }
        if (italic) {
            return EnumSet.of(FontStyle.ITALIC);
        }
        return EnumSet.noneOf(FontStyle.class);
    }

    public String toString() {
        return this.styles.toString() + " " + this.currentColor;
    }

    private FontConfiguration(EnumSet<FontStyle> styles, UFont motherFont, HColor motherColor, UFont currentFont, HColor currentColor, HColor extendedColor, FontPosition fontPosition, SvgAttributes svgAttributes, HColor hyperlinkColor, UStroke hyperlinkUnderlineStroke, int tabSize) {
        this.styles = styles;
        this.currentFont = currentFont;
        this.motherFont = motherFont;
        this.currentColor = currentColor;
        this.motherColor = motherColor;
        this.extendedColor = extendedColor;
        this.fontPosition = fontPosition;
        this.svgAttributes = svgAttributes;
        this.hyperlinkColor = hyperlinkColor;
        this.hyperlinkUnderlineStroke = hyperlinkUnderlineStroke;
        this.tabSize = tabSize;
    }

    public FontConfiguration forceFont(UFont newFont, HColor htmlColorForStereotype) {
        if (newFont == null) {
            return this.add(FontStyle.ITALIC);
        }
        FontConfiguration result = new FontConfiguration(this.styles, newFont, this.motherColor, newFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlinkColor, this.hyperlinkUnderlineStroke, this.tabSize);
        if (htmlColorForStereotype != null) {
            result = result.changeColor(htmlColorForStereotype);
        }
        return result;
    }

    public FontConfiguration changeAttributes(SvgAttributes toBeAdded) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes.add(toBeAdded), this.hyperlinkColor, this.hyperlinkUnderlineStroke, this.tabSize);
    }

    private FontConfiguration withHyperlink() {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.hyperlinkColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlinkColor, this.hyperlinkUnderlineStroke, this.tabSize);
    }

    public FontConfiguration changeColor(HColor newHtmlColor) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, newHtmlColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlinkColor, this.hyperlinkUnderlineStroke, this.tabSize);
    }

    public FontConfiguration mute(Colors colors) {
        HColor color = Objects.requireNonNull(colors).getColor(ColorType.TEXT);
        if (color == null) {
            return this;
        }
        return this.changeColor(color);
    }

    public FontConfiguration changeExtendedColor(HColor newExtendedColor) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, newExtendedColor, this.fontPosition, this.svgAttributes, this.hyperlinkColor, this.hyperlinkUnderlineStroke, this.tabSize);
    }

    public FontConfiguration changeSize(float size) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont.withSize(size), this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlinkColor, this.hyperlinkUnderlineStroke, this.tabSize);
    }

    public FontConfiguration bigger(double delta) {
        return this.changeSize((float)((double)this.currentFont.getSize() + delta));
    }

    public FontConfiguration changeFontPosition(FontPosition fontPosition) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, fontPosition, this.svgAttributes, this.hyperlinkColor, this.hyperlinkUnderlineStroke, this.tabSize);
    }

    public FontConfiguration changeFamily(String family) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, new UFont(family, this.currentFont.getStyle(), this.currentFont.getSize()), this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlinkColor, this.hyperlinkUnderlineStroke, this.tabSize);
    }

    public FontConfiguration resetFont() {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.motherFont, this.motherColor, null, FontPosition.NORMAL, new SvgAttributes(), this.hyperlinkColor, this.hyperlinkUnderlineStroke, this.tabSize);
    }

    public FontConfiguration add(FontStyle style) {
        Object r = this.styles.clone();
        if (style == FontStyle.PLAIN) {
            ((AbstractCollection)r).clear();
        }
        ((AbstractCollection)r).add(style);
        return new FontConfiguration((EnumSet<FontStyle>)r, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlinkColor, this.hyperlinkUnderlineStroke, this.tabSize);
    }

    public FontConfiguration italic() {
        return this.add(FontStyle.ITALIC);
    }

    public FontConfiguration bold() {
        return this.add(FontStyle.BOLD);
    }

    public FontConfiguration unbold() {
        return this.remove(FontStyle.BOLD);
    }

    public FontConfiguration unitalic() {
        return this.remove(FontStyle.ITALIC);
    }

    public FontConfiguration underline() {
        return this.add(FontStyle.UNDERLINE);
    }

    public FontConfiguration wave(HColor color) {
        return this.add(FontStyle.WAVE).changeExtendedColor(color);
    }

    public FontConfiguration hyperlink() {
        if (this.hyperlinkUnderlineStroke != null) {
            return this.add(FontStyle.UNDERLINE).withHyperlink();
        }
        return this.withHyperlink();
    }

    public FontConfiguration remove(FontStyle style) {
        Object r = this.styles.clone();
        ((AbstractCollection)r).remove((Object)style);
        return new FontConfiguration((EnumSet<FontStyle>)r, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlinkColor, this.hyperlinkUnderlineStroke, this.tabSize);
    }

    public UFont getFont() {
        UFont result = this.currentFont;
        for (FontStyle style : this.styles) {
            result = style.mutateFont(result);
        }
        return this.fontPosition.mute(result);
    }

    public HColor getColor() {
        return this.currentColor;
    }

    public HColor getExtendedColor() {
        return this.extendedColor;
    }

    public boolean containsStyle(FontStyle style) {
        return this.styles.contains((Object)style);
    }

    public int getSpace() {
        return this.fontPosition.getSpace();
    }

    public Map<String, String> getAttributes() {
        return this.svgAttributes.attributes();
    }

    public double getSize2D() {
        return this.currentFont.getSize2D();
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public UStroke getUnderlineStroke() {
        return this.hyperlinkUnderlineStroke;
    }
}

