/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.help;

import java.awt.GraphicsEnvironment;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.help.Help;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandHelpFont
extends SingleLineCommand2<Help> {
    public CommandHelpFont() {
        super(CommandHelpFont.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandHelpFont.class.getName(), RegexLeaf.start(), new RegexLeaf("help"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("fonts?"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(Help diagram, LineLocation location, RegexResult arg) {
        String[] name;
        diagram.add("<b>Help on font");
        diagram.add(" ");
        diagram.add("The code of this command is located in <i>net.sourceforge.plantuml.help</i> package.");
        diagram.add("You may improve it on <i>https://github.com/plantuml/plantuml/tree/master/src/net/sourceforge/plantuml/help</i>");
        diagram.add(" ");
        diagram.add(" The possible font on your system are :");
        for (String n : name = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            diagram.add("* " + n);
        }
        return CommandExecutionResult.ok();
    }
}

