/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.utils;

import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.ProgressBar;

public abstract class Log {
    private static final long start = System.currentTimeMillis();

    public static synchronized void debug(String s) {
    }

    public static synchronized void info(String s) {
        if (OptionFlags.getInstance().isVerbose()) {
            ProgressBar.clear();
            System.err.println(Log.format(s));
        }
    }

    public static synchronized void error(String s) {
        ProgressBar.clear();
        System.err.println(s);
    }

    private static String format(String s) {
        long delta = System.currentTimeMillis() - start;
        long freeMemory = Runtime.getRuntime().freeMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long usedMemory = totalMemory - freeMemory;
        int threadActiveCount = Thread.activeCount();
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(delta / 1000L);
        sb.append(".");
        sb.append(String.format("%03d", delta % 1000L));
        sb.append(" - ");
        long total = totalMemory / 1024L / 1024L;
        long free = freeMemory / 1024L / 1024L;
        sb.append(total);
        sb.append(" Mo) ");
        sb.append(free);
        sb.append(" Mo - ");
        sb.append(s);
        return sb.toString();
    }

    public static void println(Object s) {
    }

    public static void header(String s) {
    }
}

