/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ShapeType;

public abstract class AbstractEntityImageBorder
extends AbstractEntityImage {
    public final EntityPosition entityPosition;
    protected final Cluster parent;
    protected final Bibliotekon bibliotekon;
    protected final Rankdir rankdir;

    protected abstract StyleSignatureBasic getSignature();

    protected final Style getStyle() {
        ILeaf leaf = (ILeaf)this.getEntity();
        Stereotype stereotype = leaf.getStereotype();
        return this.getSignature().withTOBECHANGED(stereotype).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    AbstractEntityImageBorder(ILeaf leaf, ISkinParam skinParam, Cluster parent, Bibliotekon bibliotekon, FontParam fontParam) {
        super(leaf, skinParam);
        this.parent = parent;
        this.bibliotekon = bibliotekon;
        this.entityPosition = leaf.getEntityPosition();
        this.rankdir = skinParam.getRankdir();
        if (this.entityPosition == EntityPosition.NORMAL) {
            throw new IllegalArgumentException();
        }
    }

    protected final TextBlock getDesc() {
        ILeaf leaf = (ILeaf)this.getEntity();
        FontConfiguration fc = FontConfiguration.create(this.getSkinParam(), this.getStyle());
        return leaf.getDisplay().create(fc, HorizontalAlignment.CENTER, this.getSkinParam());
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.entityPosition.getDimension(this.rankdir);
    }

    @Override
    public ShapeType getShapeType() {
        return this.entityPosition.getShapeType();
    }
}

