/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.baraye;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.baraye.Quark;

public class Plasma {
    private String separator;
    private final Quark root;
    private final Map<List<String>, Quark> quarks = new LinkedHashMap<List<String>, Quark>();

    public Plasma(String separator) {
        List<String> empty = Collections.emptyList();
        this.root = this.ensurePresent(empty);
        this.separator = separator;
    }

    public Quark root() {
        return this.root;
    }

    public final String getSeparator() {
        return this.separator;
    }

    public final void setSeparator(String separator) {
        if (separator == null) {
            separator = "\u0000";
        }
        this.separator = separator;
    }

    public Quark parse(Quark root, String full) {
        List<String> result = root.getSignature();
        while (true) {
            int idx;
            if ((idx = full.indexOf(this.separator)) == -1) {
                result.add(full);
                return this.ensurePresent(result);
            }
            if (idx > 0) {
                result.add(full.substring(0, idx));
                this.ensurePresent(new ArrayList<String>(result));
            }
            full = full.substring(idx + this.separator.length());
        }
    }

    Quark ensurePresent(List<String> result) {
        Quark quark = this.quarks.get(result);
        if (quark == null) {
            if (result.size() == 0) {
                quark = new Quark(this, null, result);
            } else {
                Quark parent = this.ensurePresent(result.subList(0, result.size() - 1));
                quark = new Quark(this, parent, result);
            }
            System.err.println("PUTTING " + quark);
            this.quarks.put(result, quark);
        }
        return quark;
    }

    public Collection<Quark> quarks() {
        return Collections.unmodifiableCollection(new ArrayList<Quark>(this.quarks.values()));
    }

    public Quark getIfExistsFromName(String name) {
        for (Quark quark : this.quarks.values()) {
            if (!quark.getName().equals(name)) continue;
            return quark;
        }
        return null;
    }

    public Quark getIfExistsFromFullPath(String full) {
        for (Quark quark : this.quarks.values()) {
            if (!quark.toString(this.separator).equals(full)) continue;
            return quark;
        }
        return null;
    }

    public Quark getIfExists(List<String> signature) {
        return this.quarks.get(signature);
    }

    public int countChildren(Quark parent) {
        int count = 0;
        for (Quark quark : new ArrayList<Quark>(this.quarks.values())) {
            if (quark.getParent() != parent) continue;
            ++count;
        }
        return count;
    }

    public List<Quark> getChildren(Quark parent) {
        ArrayList<Quark> result = new ArrayList<Quark>();
        for (Quark quark : new ArrayList<Quark>(this.quarks.values())) {
            if (quark.getParent() != parent) continue;
            result.add(quark);
        }
        return Collections.unmodifiableList(result);
    }

    public void moveAllTo(Quark src, Quark dest) {
        for (Quark quark : new ArrayList<Quark>(this.quarks.values())) {
            if (quark == dest || !src.containsLarge(quark)) continue;
            this.quarks.remove(quark.getSignature());
            quark.internalMove(src, dest);
            this.quarks.put(quark.getSignature(), quark);
        }
    }
}

