amends ".../snippetTest.pkl"

local listing: Listing = new { 1; 2; 3 }
local mapping: Mapping = new { ["a"] = 1; ["b"] = 2 }
local dynamic: Dynamic = new {
  1
  2
  3
  ["foo"] = 0
  ["bar"] = 1
  foo = "foo"
  bar = "bar"
}
local list: List<Int> = List(1, 2, 3)
local map: Map<String, Int> = Map("zz", 1, "yy", 2)
local intseq: IntSeq = IntSeq(0, 5).step(2)
local set: Set<Int> = Set(10, 20, 30)
local bytes: Bytes = Bytes(1, 2, 3, 4)

examples {
  ["inferred Dynamic parent"] {
    new {
      ...listing
    }
    new {
      ...mapping
      ...listing
      ...dynamic
      ...list
      ...map
      ...intseq
      ...set
      ...bytes
    }
  }
  ["explicit Dynamic type"] {
    new Dynamic {
      ...listing
    }
    new Dynamic {
      ...mapping
      ...listing
      ...dynamic
      ...list
      ...map
      ...intseq
      ...set
      ...bytes
    }
  }
  ["legacy syntax"] {
    (Dynamic) { ...dynamic }
    (Dynamic) { ...listing }
    (Dynamic) { ...list }
    (Dynamic) { ...map }
    (Dynamic) { ...intseq }
    (Dynamic) { ...set }
    (Dynamic) { ...bytes }
  }
}

facts {
  ["length"] {
    new Dynamic {
      ...mapping
      ...listing
      ...dynamic
      ...list
      ...map
      ...intseq
      ...set
    }.length() == 15
  }
  ["equality"] {
    new Dynamic { ...dynamic } == dynamic
  }
}
