amends "../snippetTest.pkl"

import "pkl:semver"
import "pkl:test"

examples {
  ["Version"] {
    semver.Version("0.0.0")
    semver.Version("1.2.3")
    semver.Version("1.2.3-beta-1")
    semver.Version("1.2.3-beta-1+340249")

    test.catch(() -> semver.Version("1"))
    test.catch(() -> semver.Version("1.2"))
    test.catch(() -> semver.Version("1.02.3"))
    test.catch(() -> semver.Version("aaa"))
  }

  ["List.sortWith()"] {
    List(
      semver.Version("100.0.0"),
      semver.Version("0.100.0"),
      semver.Version("0.0.100")
    )
      .sortWith(semver.comparator)
  }
}

facts {
  ["parseOrNull()"] {
    semver.parseOrNull("0.0.0") == semver.Version("0.0.0")
    semver.parseOrNull("1.2.3") == semver.Version("1.2.3")
    semver.parseOrNull("1.2.3-beta-1") == semver.Version("1.2.3-beta-1")
    semver.parseOrNull("1.2.3-beta-1+340249") == semver.Version("1.2.3-beta-1+340249")

    semver.parseOrNull("1") == null
    semver.parseOrNull("1.2") == null
    semver.parseOrNull("1.02.3") == null
    semver.parseOrNull("aaa") == null
  }

  ["Version.major"] {
    semver.Version("0.0.0").major == 0
    semver.Version("0.1.2").major == 0
    semver.Version("1.2.3").major == 1
    semver.Version("1.2.3-rc-1").major == 1
    semver.Version("1.2.3-rc-1+abc").major == 1
    semver.Version("1.2.3+abc").major == 1
    semver.Version("777.888.999-rc-1+abc").major == 777
  }

  ["Version.minor"] {
    semver.Version("0.0.0").minor == 0
    semver.Version("0.1.2").minor == 1
    semver.Version("1.2.3").minor == 2
    semver.Version("1.2.3-rc-1").minor == 2
    semver.Version("1.2.3-rc-1+abc").minor == 2
    semver.Version("1.2.3+abc").minor == 2
    semver.Version("777.888.999-rc-1+abc").minor == 888
  }

  ["Version.patch"] {
    semver.Version("0.0.0").patch == 0
    semver.Version("0.1.2").patch == 2
    semver.Version("1.2.3").patch == 3
    semver.Version("1.2.3-rc-1").patch == 3
    semver.Version("1.2.3-rc-1+abc").patch == 3
    semver.Version("1.2.3+abc").patch == 3
    semver.Version("777.888.999-rc-1+abc").patch == 999
  }

  ["Version.preRelease"] {
    semver.Version("0.0.0").preRelease == null
    semver.Version("0.1.2").preRelease == null
    semver.Version("1.2.3").preRelease == null
    semver.Version("1.2.3-rc-1").preRelease == "rc-1"
    semver.Version("1.2.3-rc-1+abc").preRelease == "rc-1"
    semver.Version("1.2.3+abc").preRelease == null
    semver.Version("777.888.999-rc-1+abc").preRelease == "rc-1"
  }

  ["Version.build"] {
    semver.Version("0.0.0").build == null
    semver.Version("0.1.2").build == null
    semver.Version("1.2.3").build == null
    semver.Version("1.2.3-rc-1").build == null
    semver.Version("1.2.3-rc-1+abc").build == "abc"
    semver.Version("1.2.3+abc").build == "abc"
    semver.Version("777.888.999-rc-1+abc").build == "abc"
  }

  ["Version.equals()"] {
    semver.Version("0.0.0").equals(semver.Version("0.0.0"))
    semver.Version("0.1.2").equals(semver.Version("0.1.2"))
    semver.Version("1.2.3").equals(semver.Version("1.2.3"))
    semver.Version("1.2.3-rc-1").equals(semver.Version("1.2.3-rc-1"))
    semver.Version("1.2.3+abc").equals(semver.Version("1.2.3+abc"))
    semver.Version("1.2.3+abc").equals(semver.Version("1.2.3+def"))
    semver.Version("1.2.3-rc-1+abc").equals(semver.Version("1.2.3-rc-1+abc"))
    semver.Version("1.2.3-rc-1+abc").equals(semver.Version("1.2.3-rc-1+def"))

    !semver.Version("0.0.0").equals(semver.Version("0.0.1"))
    !semver.Version("1.2.3").equals(semver.Version("2.2.3"))
    !semver.Version("1.2.3").equals(semver.Version("1.3.3"))
    !semver.Version("1.2.3").equals(semver.Version("1.2.4"))
    !semver.Version("1.2.3").equals(semver.Version("1.2.3-rc-1"))
    !semver.Version("1.2.3-rc-1").equals(semver.Version("1.2.3-rc-2"))
    !semver.Version("1.2.3-rc-1").equals(semver.Version("1.2.3-rc-2+abc"))
  }

  ["Version.isLessThan()"] {
    semver.Version("0.0.0").isLessThan(semver.Version("0.0.1"))
    semver.Version("0.0.0").isLessThan(semver.Version("0.1.0"))
    semver.Version("0.0.0").isLessThan(semver.Version("1.0.0"))
    semver.Version("1.2.3").isLessThan(semver.Version("2.2.3"))
    semver.Version("1.2.3").isLessThan(semver.Version("1.3.3"))
    semver.Version("1.2.3").isLessThan(semver.Version("1.2.4"))
    semver.Version("1.2.3-alpha").isLessThan(semver.Version("1.2.3-beta"))

    !semver.Version("0.0.1").isLessThan(semver.Version("0.0.0"))
    !semver.Version("0.1.0").isLessThan(semver.Version("0.0.0"))
    !semver.Version("1.0.0").isLessThan(semver.Version("0.0.0"))
    !semver.Version("2.2.3").isLessThan(semver.Version("1.2.3"))
    !semver.Version("1.3.3").isLessThan(semver.Version("1.2.3"))
    !semver.Version("1.2.4").isLessThan(semver.Version("1.2.3"))
    !semver.Version("1.2.3-beta").isLessThan(semver.Version("1.2.3-alpha"))

    !semver.Version("0.0.0").isLessThan(semver.Version("0.0.0"))
    !semver.Version("1.2.3").isLessThan(semver.Version("1.2.3"))
    !semver.Version("1.2.3-alpha").isLessThan(semver.Version("1.2.3-alpha"))
    !semver.Version("1.2.3-alpha+abc").isLessThan(semver.Version("1.2.3-alpha+abc"))

    !semver.Version("1.2.3-alpha+def").isLessThan(semver.Version("1.2.3-alpha+abc"))
    !semver.Version("1.2.3-alpha+abc").isLessThan(semver.Version("1.2.3-alpha+def"))

    semver.Version("1.2.3").isLessThan(semver.Version("2.0.100"))
    semver.Version("1.2.3").isLessThan(semver.Version("2.100.0"))
  }

  ["Version.isLessThanOrEquals()"] {
    semver.Version("1.2.3").isLessThanOrEquals(semver.Version("1.2.3"))
    semver.Version("1.2.3").isLessThanOrEquals(semver.Version("1.2.4"))
    semver.Version("1.2.3").isLessThanOrEquals(semver.Version("1.3.3"))
    semver.Version("1.2.3").isLessThanOrEquals(semver.Version("1.2.4"))
    semver.Version("1.2.3").isLessThanOrEquals(semver.Version("2.2.3"))
  }

  ["Version.isGreaterThan()"] {
    semver.Version("0.0.1").isGreaterThan(semver.Version("0.0.0"))
    semver.Version("0.1.0").isGreaterThan(semver.Version("0.0.0"))
    semver.Version("1.0.0").isGreaterThan(semver.Version("0.0.0"))
    semver.Version("2.2.3").isGreaterThan(semver.Version("1.2.3"))
    semver.Version("1.3.3").isGreaterThan(semver.Version("1.2.3"))
    semver.Version("1.2.4").isGreaterThan(semver.Version("1.2.3"))
    semver.Version("1.2.3-beta").isGreaterThan(semver.Version("1.2.3-alpha"))

    semver.Version("2.0.100").isGreaterThan(semver.Version("1.2.3"))
    semver.Version("2.100.0").isGreaterThan(semver.Version("1.2.3"))
    semver.Version("2.0.100").isGreaterThan(semver.Version("1.2.3"))
  }

  ["Version.isGreaterThanOrEquals()"] {
    semver.Version("1.2.3").isGreaterThanOrEquals(semver.Version("1.2.3"))
    semver.Version("1.2.4").isGreaterThanOrEquals(semver.Version("1.2.3"))
    semver.Version("1.3.3").isGreaterThanOrEquals(semver.Version("1.2.3"))
    semver.Version("1.2.4").isGreaterThanOrEquals(semver.Version("1.2.3"))
    semver.Version("2.2.3").isGreaterThanOrEquals(semver.Version("1.2.3"))
  }

  ["Version.isNormal()"] {
    semver.Version("0.0.0").isNormal()
    semver.Version("1.2.3").isNormal()

    !semver.Version("1.2.3-alpha").isNormal()
    !semver.Version("1.2.3+abc").isNormal()
    !semver.Version("1.2.3-alpha+abc").isNormal()
  }

  ["Version.isStable()"] {
    semver.Version("1.0.0").isStable()
    semver.Version("1.2.3").isStable()
    semver.Version("1.2.3+abc").isStable()

    !semver.Version("0.0.0").isStable()
    !semver.Version("0.1.2").isStable()
    !semver.Version("1.2.3-rc-1").isStable()
    !semver.Version("1.2.3-rc-1+abc").isStable()
  }

  ["Version.toString()"] {
    semver.Version("0.0.0").toString() == "0.0.0"
    semver.Version("0.1.2").toString() == "0.1.2"
    semver.Version("1.2.3").toString() == "1.2.3"
    semver.Version("1.2.3-rc-1").toString() == "1.2.3-rc-1"
    semver.Version("1.2.3-rc-1+abc").toString() == "1.2.3-rc-1+abc"
    semver.Version("1.2.3+abc").toString() == "1.2.3+abc"
    semver.Version("777.888.999-rc-1+abc").toString() == "777.888.999-rc-1+abc"
  }
}
