amends "../snippetTest.pkl"

import "pkl:release"

local current = release.current

facts {
  ["version"] {
    current.version.major == 0
    current.version.minor >= 16
    current.version.patch >= 0
  }

  ["versionInfo"] {
    current.versionInfo.contains("macOS") || current.versionInfo.contains("Linux") || current.versionInfo.contains("Windows")
  }

  ["commitId"] {
    current.commitId.matches(Regex(#"[0-9a-f]{7,40}"#))
  }

  ["sourceCode"] {
    current.sourceCode.homepage.startsWith("https://")
    current.sourceCode.homepage.endsWith("/")
  }

  ["documentation"] {
    current.documentation.homepage.startsWith("https://")
    current.documentation.homepage.endsWith("/")
  }
  
  ["standardLibrary"] {
    current.standardLibrary.modules.length > 10
    current.standardLibrary.modules.every((it) -> it.startsWith("pkl:"))
    current.standardLibrary.modules.contains("pkl:base")
    !current.standardLibrary.modules.contains("pkl:package-info")
  }
}
