amends "../snippetTest.pkl"

import "pkl:protobuf"

local renderer = new protobuf.Renderer {}

local class NestedStructures {
  plainString: String = "plain string"
  nestedListing: Listing<Listing<String>>
  nestedListing2: Listing<Listing<Listing<Listing<String>>>>
  nestedMapping: Mapping<String, Mapping<Int, Boolean>>
  listingInMapping: Mapping<String, Listing<String>>
  mappingInListing: Listing<Mapping<Int, Boolean>>
  nestedList: List<List<String>>
  nestedMap: Map<String, Map<Int, Boolean>>
}

examples {
  ["some"] {
    renderer.renderDocument(new NestedStructures {
      nestedListing {
        new {
          "foo"
          "bar"
        }
        new {
          "baz"
          "qux"
        }
      }
      nestedListing2 {
        new {
          new {
            new {
              "foo"
              "bar"
              "baz"
            }
          }
        }
      }
      nestedMapping {
        ["quux"] {
          [42] = true
          [1337] = false
        }
        ["corge"] {
          [0] = false
        }
      }
      listingInMapping {
        ["grault"] {
          "grault1"
          "grault2"
        }
        ["garply"] {
          "garply1"
        }
        ["waldo"] {}
      }
      mappingInListing {
        new {
          [-1] = false
          [1] = true
        }
        new {
          [-2] = true
          [2] = false
        }
      }
      nestedList = List(List("pigeon", "plugh"), List(), List("xyzzy"))
      nestedMap = Map("thud", Map(), "wibble", Map(1, false, 2, true), "wobble", Map(0, false))
    })
  }
}
