import "pkl:test"

class Person {
  name: String
  age: Int
}

typealias Email = String

local renderer = new PListRenderer {}

res1 = test.catch(() -> renderer.renderDocument(123))
res2 = test.catch(() -> renderer.renderDocument(1.23))
res3 = test.catch(() -> renderer.renderDocument(false))
res4 = test.catch(() -> renderer.renderDocument("pigeon"))

res6 = renderer.renderDocument(List("pigeon", "parrot"))
res7 = renderer.renderDocument(Set("pigeon", "parrot"))
res8 = renderer.renderDocument(Map("name", "pigeon", "age", 42))
res9 = renderer.renderDocument(new Listing { "pigeon"; "parrot" })
res10 = renderer.renderDocument(new Mapping { ["name"] = "pigeon"; ["age"] = 42 })
res11 = renderer.renderDocument(new Dynamic { name = "pigeon"; age = 42 })
res12 = renderer.renderDocument(new Person { name = "pigeon"; age = 42 })

res13 = test.catch(() -> renderer.renderDocument(1.min))
res14 = test.catch(() -> renderer.renderDocument(1.mb))
res15 = test.catch(() -> renderer.renderDocument(Person))
res16 = test.catch(() -> renderer.renderDocument(Email))
res17 = test.catch(() -> renderer.renderDocument((x) -> x))
res18 = test.catch(() -> renderer.renderDocument(null))
res19 = test.catch(() -> renderer.renderDocument(Pair(1, 2)))
res20 = test.catch(() -> new PListRenderer { converters { [Int] = (_) -> throw("ouch") } }.renderDocument(42))
res21 = test.catch(() -> renderer.renderDocument(IntSeq(1, 4)))
