amends "../snippetTest.pkl"

import "pkl:math"

facts {
  ["isPositive"] {
    0.min.isPositive
    0.0.min.isPositive
    1.min.isPositive
    0.1.min.isPositive

    (-0).min.isPositive
    (-0.0).min.isPositive
    !(-1).min.isPositive
    !(-0.1).min.isPositive
  }

  ["isBetween"] {
    3.min.isBetween(2.min, 4.min)
    3.min.isBetween(3.min, 4.min)
    3.min.isBetween(2.min, 3.min)
    3.min.isBetween(3.min, 3.min)
    3.min.isBetween(120.s, 180.s)
    !3.min.isBetween(1.min, 2.min)
    !3.min.isBetween(4.min, 2.min)

    3.3.min.isBetween(2.2.min, 4.4.min)
    3.3.min.isBetween(3.3.min, 4.4.min)
    3.3.min.isBetween(2.2.min, 3.3.min)
    3.3.min.isBetween(3.3.min, 3.3.min)
    3.3.min.isBetween(120.s, 210.s)
    !3.3.min.isBetween(1.1.min, 2.2.min)
    !3.3.min.isBetween(4.4.min, 2.2.min)
  }
}

examples {
  local cases = new Listing {
    1.ns
    2.2.us
    3.ms
    4.4.s
    5.min
    6.6.h
    7.d
  }
  ["value"] {
    for (c in cases) {
      c.value
    }
    List(1, 2.2, 3).map((d) -> d.mb.value)
  }

  ["unit"] {
    for (c in cases) {
      c.unit
    }
  }
  
  ["isoString"] {
    for (c in cases) {
      c.isoString
    }
    2000.5.ms.isoString
    0.h.isoString
    0.0.h.isoString
    (-0.0).h.isoString
    0.s.isoString
    0.0.s.isoString
    (-0.0).s.isoString
    0.ms.isoString
    0.0.ms.isoString
    (-0.0).ms.isoString
    100.d.isoString
    (-10.001).s.isoString
    (-3.1.h).isoString
    math.maxFiniteFloat.s.isoString
    module.catch(() -> (0/0).s.isoString)
    module.catch(() -> (1/0).s.isoString)
    module.catch(() -> (-1/0).s.isoString)
    module.catch(() -> (math.maxFiniteFloat * 1.00000000001).s.isoString)
  }

  ["toUnit()"] {
    1.d.toUnit("d")
    1.d.toUnit("h")
    1.d.toUnit("min")
    1.d.toUnit("s")
    1.d.toUnit("ms")
    1.d.toUnit("us")
    1.d.toUnit("ns")

    local ns = 1.d.toUnit("ns")
    ns.toUnit("d")
    ns.toUnit("h")
    ns.toUnit("min")
    ns.toUnit("s")
    ns.toUnit("us")
    ns.toUnit("ns")

    0.5.h.toUnit("s")
    1800.s.toUnit("h")

    module.catch(() -> 1.d.toUnit("foo"))
  }
}
