import "pkl:test"

typealias List2<E> = List<E>

res1: List2<Int> = List(1, 2, 3)

res2: List2<List2<String>> = List(List("Pigeon"), List("Barn Owl"))

typealias Map2<V, K> = Map<K, V>

res3: Map2<String, Int> = Map(42, "Pigeon", 21, "Barn Owl")

typealias StringMap<V> = Map<String, V>

res4: StringMap<Duration> = Map("Pigeon", 3.min, "Barn Owl", 5.s)

typealias MMap<X> = Map<X, X>

class Person { name: String }

res5: MMap<Person?> = Map(null, new Person { name = "Pigeon" }, new Person { name = "Barn Owl" }, null)

typealias Mixin<Object> = (Object) -> Object

local mixin: Mixin<Person> = (p: Person) -> (p) { name = "Other" }

res6 = mixin.apply(new Person { name = "Pigeon" })

open class Foo {
  value: Int = 42
}

typealias Bar = Foo

class Baz extends Bar {}

res7 = (new Baz {}).value
