@file:Suppress("UNUSED_VARIABLE")

import org.pkl.config.java.ConfigEvaluator
import org.pkl.config.kotlin.forKotlin
import org.pkl.config.kotlin.to
import org.junit.jupiter.api.Test

// the pkl/pkl-examples repo has a similar example
class KotlinConfigExample {
  @Test
  fun usage() {
    // tag::usage[]
    val evaluator = ConfigEvaluator.preconfigured().forKotlin() // <1>
    val config = evaluator.use { // <2>
      it.evaluateText("""pigeon { age = 5; diet = "Seeds" }""")
    }
    val pigeon = config["pigeon"] // <3>
    val age = pigeon["age"].to<Int>() // <4>
    val hobbies = pigeon["diet"].to<List<String>>() // <5>
    // end::usage[]
  }
  
  @Test
  fun nullable() {
    // tag::nullable[]
    val evaluator = ConfigEvaluator.preconfigured().forKotlin()
    val config = evaluator.use {
      it.evaluateText("name = null") // <1>
    }
    val name = config["name"].to<String?>() // <2>
    // end::nullable[]
  }
}
