#import "PXToolSwitcher.h"
#import "PXPencilTool.h"
#import "PXEraserTool.h"
#import "PXEyedropperTool.h"
#import "PXZoomTool.h"
#import "PXFillTool.h"
#import "PXLineTool.h"
#import "PXRectangularSelectionTool.h"
#import "PXMoveTool.h"
#import "PXRectangleTool.h"
#import "PXEllipseTool.h"
#import "PXMagicWandTool.h"
#import "PXLassoTool.h"

NSString * PXToolDidChangeNotificationName = @"PXToolDidChangeNotification";
NSMutableArray * toolNames;

@implementation PXToolSwitcher

+ toolClasses
{
	return [NSArray arrayWithObjects:[PXPencilTool class], [PXEraserTool class], [PXEyedropperTool class], [PXZoomTool class], [PXFillTool class], [PXLineTool class], [PXRectangularSelectionTool class], [PXMoveTool class], [PXRectangleTool class], [PXEllipseTool class], [PXMagicWandTool class], [PXLassoTool class], nil];
}

+ toolNames
{
	return [[self toolClasses] valueForKey:@"description"];
}

- (void)lock:(NSNotification *)aNotification
{
    locked = YES;
}

- (void)unlock:(NSNotification *)aNotification
{
    locked = NO;
}

- init
{
    [super init];
	tools = [[NSMutableArray alloc] initWithCapacity:[[[self class] toolClasses] count]];
	id enumerator = [[[self class] toolClasses] objectEnumerator];
	id current;
	while(current = [enumerator nextObject])
	{
		[tools addObject:[[current alloc] init]];
	}
    [tools makeObjectsPerformSelector:@selector(setSwitcher:) withObject:self];
    [self setColor:[NSColor blackColor]];
    [self useToolTagged:PXPencilToolTag];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(lock:) name:@"PXLockToolSwitcher" object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(unlock:) name:@"PXUnlockToolSwitcher" object:nil];
    locked = NO;
	[self checkUserDefaults];
    return self;
}

- (void)checkUserDefaults
{
	//should find a way to factor this into the tools' classes.
    id defaults = [NSDictionary dictionaryWithObjects:[NSArray arrayWithObjects:@"p", @"e", @"d", @"z", @"f", @"l", @"s", @"m", @"r", @"o", @"w", @"a", nil]
                                               forKeys:[NSArray arrayWithObjects:[NSNumber numberWithInt:PXPencilToolTag], [NSNumber numberWithInt:PXEraserToolTag], [NSNumber numberWithInt:PXEyedropperToolTag], [NSNumber numberWithInt:PXZoomToolTag], [NSNumber numberWithInt:PXFillToolTag], [NSNumber numberWithInt:PXLineToolTag], [NSNumber numberWithInt:PXRectangularSelectionToolTag], [NSNumber numberWithInt:PXMoveToolTag], [NSNumber numberWithInt:PXRectangleToolTag], [NSNumber numberWithInt:PXEllipseToolTag], [NSNumber numberWithInt:PXMagicWandToolTag], [NSNumber numberWithInt:PXLassoToolTag], nil]];
    id enumerator = [defaults keyEnumerator], current;
    while (current = [enumerator nextObject])
    {
        if ([[NSUserDefaults standardUserDefaults] objectForKey:[[[self class] toolNames] objectAtIndex:[current intValue]]] == nil)
            [[NSUserDefaults standardUserDefaults] setObject:[defaults objectForKey:current] forKey:[[[self class] toolNames] objectAtIndex:[current intValue]]];
    }
}

- (void)dealloc
{
    [tools release];
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [super dealloc];
}

- tool
{
    return tool;
}

- toolWithTag:(PXToolTag)tag
{
    return [tools objectAtIndex:tag];
}

- (PXToolTag)tagForTool:aTool
{
    return [tools indexOfObject:aTool];
}

- (void)setIcon:anImage forTool:aTool
{
    [[toolsMatrix cellWithTag:[self tagForTool:aTool]] setImage:anImage];
}

- (void)useTool:aTool
{
    [self useToolTagged:[self tagForTool:aTool]];
}

- (void)useToolTagged:(PXToolTag)tag
{
    if (locked) {
	return;
    }
    lastTool = tool;
    tool = [self toolWithTag:tag];
    [toolsMatrix selectCellWithTag:tag];
    [[NSNotificationCenter defaultCenter] postNotificationName:PXToolDidChangeNotificationName object:nil userInfo:[NSDictionary dictionaryWithObjectsAndKeys:tool, @"newTool", nil]];
}

- color
{
	return color;
}

- (void)setColor:aColor
{
    [aColor retain];
    [color release];
    color = aColor;
    id enumerator = [tools objectEnumerator];
    id current;
    while(current = [enumerator nextObject])
    {
        if([current respondsToSelector:@selector(setColor:)]) { [current setColor:color]; }
    }
	[colorWell setColor:aColor];
}

- (IBAction)colorChanged:(id)sender
{
    [self setColor:[colorWell color]];
}

- (IBAction)toolClicked:(id)sender
{
    [self useToolTagged:[[toolsMatrix selectedCell] tag]];
}

- (void)keyDown:(NSEvent *)event
{
    NSString * chars = [[event charactersIgnoringModifiers] lowercaseString];
	id enumerator = [[PXToolSwitcher toolNames] objectEnumerator], current;
	while (current = [enumerator nextObject])
	{
		if ([chars characterAtIndex:0] == [[[NSUserDefaults standardUserDefaults] objectForKey:current] characterAtIndex:0])
		{
			[self useToolTagged:[[PXToolSwitcher toolNames] indexOfObject:current]];
			break;
		}
	}
}

- (void)optionKeyDown
{
    if(![tool optionKeyDown]) { 
		[self useToolTagged:PXEyedropperToolTag];
    }
}

- (void)optionKeyUp
{
    if(![tool optionKeyUp]) { 
		[self useTool:lastTool];
    }
}
- (void)shiftKeyDown
{
	[tool shiftKeyDown];
}

- (void)shiftKeyUp
{
	[tool shiftKeyUp];
}

@end
