/* PXToolSwitcher */

#import <Cocoa/Cocoa.h>

extern NSString * PXToolDidChangeNotificationName;

typedef enum {
    PXPencilToolTag = 0,
    PXEraserToolTag,
    PXEyedropperToolTag,
    PXZoomToolTag,
    PXFillToolTag,
    PXLineToolTag,
	PXRectangularSelectionToolTag,
	PXMoveToolTag,
	PXRectangleToolTag,
	PXEllipseToolTag,
    PXMagicWandToolTag,
	PXLassoToolTag
} PXToolTag;

@class PXTool;

@interface PXToolSwitcher : NSObject
{
    IBOutlet id toolsMatrix;
    id tools;
    PXTool * tool;
    PXTool * lastTool;
	id color;
	IBOutlet NSColorWell * colorWell;
    
    BOOL locked;
}
- init;
- tool;
- toolWithTag:(PXToolTag)tag;
- (PXToolTag)tagForTool:aTool;
- (void)setIcon:anImage forTool:aTool;
- color;
- (void)setColor:aColor;
- (void)useTool:aTool;
- (void)useToolTagged:(PXToolTag)tag;
- (IBAction)toolClicked:(id)sender;
- (IBAction)colorChanged:(id)sender;
- (void)keyDown:event;
- (void)optionKeyDown;
- (void)optionKeyUp;
- (void)shiftKeyDown;
- (void)shiftKeyUp;

- (void)checkUserDefaults;
@end
