#import "PXToolPaletteController.h"
#import "PXToolSwitcher.h"

PXToolPaletteController *toolPalette = nil;

@implementation PXToolPaletteController

+ palette
{
    if(toolPalette == nil) { toolPalette = [[self alloc] init]; }
    [[NSColorPanel sharedColorPanel] setShowsAlpha:YES];
    return toolPalette;
}

- init
{
    [super initWithWindowNibName:@"PXToolPalette"];
    toolPalette = self;
    [(NSPanel *)[self window] setBecomesKeyOnlyIfNeeded:YES];
    [leftSwitcher useToolTagged:PXPencilToolTag];
    [rightSwitcher useToolTagged:PXEraserToolTag];
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(paletteControllerChoseLeftColor:) name:@"PXPaletteLeftColorChosen" object:nil];
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(paletteControllerChoseRightColor:) name:@"PXPaletteRightColorChosen" object:nil];
    if([[NSUserDefaults standardUserDefaults] boolForKey:@"PXRightToolSwitcherIsOpen"]) { [self openRightToolSwitcher]; }
	[[self window] setFrameAutosaveName:@"PXToolPaletteFrame"];
    keyMask = 0x0;
    return self;
}

- (void)dealloc
{
    [leftSwitcher release];
    [rightSwitcher release];
    [super dealloc];
}

- leftTool
{
    return [leftSwitcher tool];
}

- rightTool
{
    return [rightSwitcher tool];
}

- leftSwitcher
{
	return leftSwitcher;
}

- rightSwitcher
{
	return rightSwitcher;
}

- (void)openRightToolSwitcher
{
    [minimalView setFrameOrigin:NSMakePoint(0, [rightSwitchView frame].size.height)];
    [rightSwitchView setFrameOrigin:NSMakePoint(0, 0)];
    [[self window] setFrame:NSMakeRect([[self window] frame].origin.x, [[self window] frame].origin.y-[rightSwitchView frame].size.height, [[self window] frame].size.width, [[self window] frame].size.height+[rightSwitchView frame].size.height) display:YES animate:NO];
    [triangle setState:NSOnState];
    [[NSUserDefaults standardUserDefaults] setBool:YES forKey:@"PXRightToolSwitcherIsOpen"];
}

- (void)closeRightToolSwitcher
{
    [minimalView setFrameOrigin:NSMakePoint(0, 0)];
    [rightSwitchView setFrameOrigin:NSMakePoint(0, 0-[rightSwitchView frame].size.height)];
    [[self window] setFrame:NSMakeRect([[self window] frame].origin.x, [[self window] frame].origin.y+[rightSwitchView frame].size.height, [[self window] frame].size.width, [[self window] frame].size.height-[rightSwitchView frame].size.height) display:YES animate:NO];
    [triangle setState:NSOffState];
    [[NSUserDefaults standardUserDefaults] setBool:NO forKey:@"PXRightToolSwitcherIsOpen"];
}

- (IBAction)disclosureClicked:sender
{
    if([sender state] == NSOnState) { [self openRightToolSwitcher]; }
    else { [self closeRightToolSwitcher]; }
}

- (void)keyDown:(NSEvent *)event
{
	if([event modifierFlags] & NSControlKeyMask)
	{
		[rightSwitcher keyDown:event];
	}
	else
	{
		[leftSwitcher keyDown:event];
	}
}

- (BOOL)keyWasDown:(unsigned int)mask
{
    return (keyMask & mask) == mask;
}

- (BOOL)isMask:(unsigned int)newMask upEventForModifierMask:(unsigned int)mask
{
    return [self keyWasDown:mask] && ((newMask & mask) == 0x0000);
}

- (BOOL)isMask:(unsigned int)newMask downEventForModifierMask:(unsigned int)mask
{
    return ![self keyWasDown:mask] && ((newMask & mask) == mask);
}

- (void)flagsChanged:(NSEvent *)theEvent
{
    if([self isMask:[theEvent modifierFlags] downEventForModifierMask:NSAlternateKeyMask])
    {
        [leftSwitcher optionKeyDown];
        [rightSwitcher optionKeyDown];
        keyMask |= NSAlternateKeyMask;
    }
    else if([self isMask:[theEvent modifierFlags] upEventForModifierMask:NSAlternateKeyMask])
    {
        [leftSwitcher optionKeyUp];
        [rightSwitcher optionKeyUp];
        keyMask ^= NSAlternateKeyMask;
    }
    
    if([self isMask:[theEvent modifierFlags] downEventForModifierMask:NSShiftKeyMask])
    {
        [leftSwitcher shiftKeyDown];
        [rightSwitcher shiftKeyDown];
        keyMask |= NSShiftKeyMask;
    }
    else if([self isMask:[theEvent modifierFlags] upEventForModifierMask:NSShiftKeyMask])
    {
        [leftSwitcher shiftKeyUp];
        [rightSwitcher shiftKeyUp];
        keyMask ^= NSShiftKeyMask;
    }
}

- (void)paletteControllerChoseLeftColor:aNotification
{
	[leftSwitcher setColor:[[aNotification userInfo] objectForKey:@"color"]];
}

- (void)paletteControllerChoseRightColor:aNotification
{
	[rightSwitcher setColor:[[aNotification userInfo] objectForKey:@"color"]];
}

@end
