//
//  PXSelectionLayer.m
//  Pixen-XCode
//
//  Created by Joe Osborn on Sun Jan 04 2004.
//  Copyright (c) 2004 Open Sword Group. All rights reserved.
//

#import "PXSelectionLayer.h"
#import "PXImage.h"

@implementation PXSelectionLayer

+ selectionWithSize:(NSSize)aSize
{
	return [[[self alloc] initWithName:@"(selection)" size:aSize] autorelease];
}

- initWithName:aName size:(NSSize)aSize
{
	[super initWithName:aName size:aSize];
	return self;
}

- (void)setIsSubtracting:(BOOL)subtracting
{
	isSubtracting = subtracting;
}

- (void)checkWorkingPoints
{
	if (workingPoints == nil)
		workingPoints = [[NSMutableSet alloc] init];
}

- workingPoints
{
	return workingPoints;
}

- (void)addWorkingPoint:(NSPoint)aPoint
{
	[self checkWorkingPoints];
	[workingPoints addObject:[NSValue valueWithPoint:aPoint]];
}

- (void)removeWorkingPoint:(NSPoint)aPoint
{
	[self checkWorkingPoints];
	[workingPoints removeObject:[NSValue valueWithPoint:aPoint]];
}

- (BOOL)canDrawAtPoint:(NSPoint)point
{
	return [super canDrawAtPoint:point] && (([self colorAtPoint:point] != nil) || ([workingPoints containsObject:[NSValue valueWithPoint:point]]));
}

- (NSColor *)colorAtPoint:(NSPoint)aPoint
{
	return [image colorAtPoint:aPoint];
}

- (void)finalize
{
	[workingPoints removeAllObjects];	
}

- (void)transformedDrawRect:(NSRect)aRect fixBug:(BOOL)fix
{
	[super transformedDrawRect:NSMakeRect(aRect.origin.x-2, aRect.origin.y-2, aRect.size.width+4, aRect.size.height+4) fixBug:fix];
	int i, j;
	NSRect rect, workingRect = NSZeroRect;
	for(i = aRect.origin.x; i < NSMaxX(aRect); i++)
	{
		for(j = aRect.origin.y; j < NSMaxY(aRect); j++)
		{
			if([image colorAtPoint:NSMakePoint(i, j)] != nil)
			{
				NSRect currentRect = NSMakeRect(i, j, 1, 1);
				if(NSEqualRects(rect, NSZeroRect)) { rect = currentRect; }
				rect = NSUnionRect(rect, currentRect);
			}

		}
	}
	if ([workingPoints count] > 0)
	{
		id enumerator = [workingPoints objectEnumerator], current;
		while (current = [enumerator nextObject])
		{
			NSPoint point = [current pointValue];
			NSRect currentRect = NSMakeRect(point.x, point.y, 1, 1);
			if(NSEqualRects(rect, NSZeroRect)) { rect = currentRect; }
			rect = NSUnionRect(rect, currentRect);
			
			if(NSEqualRects(workingRect, NSZeroRect)) { workingRect = currentRect; }
			workingRect = NSUnionRect(workingRect, currentRect);
		}
	}
	
	for (j = rect.origin.y; j < rect.size.height + rect.origin.y + 1; j++)
	{
		for (i = rect.origin.x; i < rect.size.width + rect.origin.x + 1; i++)
		{
			if (![self canDrawAtPoint:NSMakePoint(i,j)]) { continue; }
			if (![self canDrawAtPoint:NSMakePoint(i-1, j)])
			{
				[self drawBezierFromPoint:NSMakePoint(i, j) toPoint:NSMakePoint(i, j + 1) color:[NSColor blackColor]];
			}
			if (![self canDrawAtPoint:NSMakePoint(i+1, j)])
			{
				[self drawBezierFromPoint:NSMakePoint(i + 1, j) toPoint:NSMakePoint(i + 1, j + 1) color:[NSColor blackColor]];
			}
			if (![self canDrawAtPoint:NSMakePoint(i, j-1)])
			{
				[self drawBezierFromPoint:NSMakePoint(i, j) toPoint:NSMakePoint(i + 1, j) color:[NSColor blackColor]];
			}
			if (![self canDrawAtPoint:NSMakePoint(i, j+1)])
			{
				[self drawBezierFromPoint:NSMakePoint(i, j + 1) toPoint:NSMakePoint(i + 1, j + 1) color:[NSColor blackColor]];
			}
		}
	}
	
	if (isSubtracting)
	{
		id enumerator = [workingPoints objectEnumerator];
		id current;
		while(current = [enumerator nextObject])
		{
			NSPoint currentPoint = [current pointValue];
			int i = currentPoint.x;
			int j = currentPoint.y;
			if (![workingPoints containsObject:[NSValue valueWithPoint:NSMakePoint(i,j)]]) { continue; }
			if (![workingPoints containsObject:[NSValue valueWithPoint:NSMakePoint(i-1,j)]])
			{
				[self drawBezierFromPoint:NSMakePoint(i, j) toPoint:NSMakePoint(i, j + 1) color:[NSColor redColor]];
			}
			if (![workingPoints containsObject:[NSValue valueWithPoint:NSMakePoint(i+1,j)]])
			{
				[self drawBezierFromPoint:NSMakePoint(i + 1, j) toPoint:NSMakePoint(i + 1, j + 1) color:[NSColor redColor]];
			}
			if (![workingPoints containsObject:[NSValue valueWithPoint:NSMakePoint(i,j-1)]])
			{
				[self drawBezierFromPoint:NSMakePoint(i, j) toPoint:NSMakePoint(i + 1, j) color:[NSColor redColor]];
			}
			if (![workingPoints containsObject:[NSValue valueWithPoint:NSMakePoint(i,j+1)]])
			{
				[self drawBezierFromPoint:NSMakePoint(i, j + 1) toPoint:NSMakePoint(i + 1, j + 1) color:[NSColor redColor]];
			}
		}
	}
}

- (void)drawSubtractionRect:(NSRect)rect
{
	id path = [NSBezierPath bezierPathWithRect:rect];
	[path setLineWidth:.1];
	const float pattern[] = { 0.5, 0.5 };
	[[NSColor colorWithCalibratedWhite:1 alpha:1] set];
	[path setLineDash:pattern count:1 phase:0];
	[path stroke];
	[[NSColor redColor] set];
	[path setLineDash:pattern count:1 phase:.5];
	[path stroke];
}

- (void)drawBezierFromPoint:(NSPoint)fromPoint toPoint:(NSPoint)toPoint color:color
{
	id path = [[[NSBezierPath alloc] init] autorelease];
	[path setLineWidth:.1];
	const float pattern[] = { 0.5, 0.5 };
	[path moveToPoint:fromPoint];
	[path lineToPoint:toPoint];
	[[NSColor colorWithCalibratedWhite:1 alpha:1] set];
	[path setLineDash:pattern count:1 phase:0];
	[path stroke];
	[color set];
	[path setLineDash:pattern count:1 phase:.5];
	[path stroke];	
}

@end