//
//  PXScaleController.m
//  Pixen-XCode
//
//  Created by Ian Henderson on Thu Jun 10 2004.
//  Copyright (c) 2004 Open Sword Group. All rights reserved.
//

#import "PXScaleController.h"
#import "PXCanvasController.h"
#import "PXNearestNeighborScaleAlgorithm.h"

@implementation PXScaleController

- init
{
	[super initWithWindowNibName:@"PXScalePrompt"];
	algorithms = [[NSArray alloc] initWithObjects:[PXNearestNeighborScaleAlgorithm algorithm], nil];
	return self;
}

- (void)scaleCanvasFromController:(PXCanvasController *)controller modalForWindow:(NSWindow *)theWindow
{
	canvasController = controller;
	NSEnumerator *algorithmEnumerator = [algorithms objectEnumerator];
	PXScaleAlgorithm *algorithm;
	while (algorithm = [algorithmEnumerator nextObject]) {
		[algorithm setCanvas:[controller canvas]];
	}
    [NSApp beginSheet:[self window] modalForWindow:theWindow modalDelegate:nil didEndSelector:NULL contextInfo:NULL];
}

- (void)awakeFromNib
{
    [algorithmButton removeAllItems];
	NSEnumerator *algorithmEnumerator = [algorithms objectEnumerator];
	PXScaleAlgorithm *algorithm;
	while (algorithm = [algorithmEnumerator nextObject]) {
		[algorithmButton addItemWithTitle:[algorithm name]];
	}
	[self setAlgorithm:algorithmButton];
}

- (PXScaleAlgorithm *)currentAlgorithm
{
	return [algorithms objectAtIndex:[algorithmButton indexOfSelectedItem]];
}

- (IBAction)setAlgorithm:sender
{
	NSSize margins = [scaleParameterView contentViewMargins];
	NSSize newBoxSize = [scaleParameterView frame].size;
	newBoxSize.height = [[[self currentAlgorithm] parameterView] frame].size.height + margins.height * 2;
	NSRect newWindowFrame = [[self window] frame];
	newWindowFrame.size.height += newBoxSize.height - [scaleParameterView frame].size.height;
	[[self window] setFrame:newWindowFrame display:YES animate:YES];
	[scaleParameterView setContentView:[[self currentAlgorithm] parameterView]]; // Don't move this to the top of the method or it breaks.  No, I don't know why.
	[scaleParameterView setFrameSize:newBoxSize];
}

- (IBAction)cancel:sender
{
    [NSApp endSheet:[self window]];
    [self close];
}

- (IBAction)scale:sender
{
	if ([[self currentAlgorithm] scale]) {
		[NSApp endSheet:[self window]];
		[canvasController updateCanvasSize];
		[self close];
	} else {
		NSBeep();
	}
}

@end
