//
//  PXNearestNeighborScaleAlgorithm.m
//  Pixen-XCode
//
//  Created by Ian Henderson on Thu Jun 10 2004.
//  Copyright (c) 2004 Open Sword Group. All rights reserved.
//

#import "PXNearestNeighborScaleAlgorithm.h"
#import "PXCanvas.h"
#import "PXLayer.h"

@implementation PXNearestNeighborScaleAlgorithm

- (NSString *)name
{
	return @"Nearest Neighbor";
}

- (NSString *)nibName
{
	return @"PXNearestNeighborScaleView";
}

- (BOOL)scale
{
	if (canvas == nil) {
		return NO;
	}
	NSEnumerator *layerEnumerator = [[canvas layers] objectEnumerator];
	PXLayer *layer, *layerCopy;
	int x, y, i, j;
	float xScale = [scaleWidthField floatValue];
	float yScale = [scaleHeightField floatValue];
	int xPixelsize, yPixelsize;
	
	if (yScale < .0001) {
		return NO;
	} else if (yScale < 1) {
		yPixelsize = 1; 
		yScale = 1.0f/(float)((int)(1.0f/yScale)); // put it into the closest 1/x
	} else {
		yPixelsize = yScale;
		yScale = yPixelsize; // as useless as this looks, this actually clamps scale to an integer value
	}
	
	if (xScale < .0001) {
		return NO;
	} else if (xScale < 1) {
		xPixelsize = 1; 
		xScale = 1.0f/(float)((int)(1.0f/xScale)); // put it into the closest 1/x
	} else {
		xPixelsize = xScale;
		xScale = xPixelsize; // as useless as this looks, this actually clamps scale to an integer value
	}
	
	NSPoint currentPoint;
	while (layer = [layerEnumerator nextObject]) {
		layerCopy = [[layer copy] autorelease];
		NSSize layerSize = [layer size];
		layerSize.width *= xScale;
		layerSize.height *= yScale;
		[layer setSize:layerSize];
		for (x=0; x<[layerCopy size].width; x++) {
			for (y=0; y<[layerCopy size].height; y++) {
				currentPoint = NSMakePoint(x,y);
				for (i=0; i<xPixelsize; i++) {
					for (j=0; j<yPixelsize; j++) {
						[layer setColor:[layerCopy colorAtPoint:currentPoint] atPoint:NSMakePoint(currentPoint.x*xScale + i, currentPoint.y*yScale + j)];
					}
				}
			}
		}
	}
	[canvas layersChanged];
    [canvas canvasShouldRedraw:nil];
	return YES;
}

@end
