//
//  PXMoveTool.m
//  Pixen-XCode
//
//  Created by Andy Matuschak on Fri Feb 27 2004.
//  Copyright (c) 2004 Open Sword Group. All rights reserved.
//

#import "PXMoveTool.h"
#import "PXCanvasController.h"
#import "PXCanvas.h"
#import "PXLayer.h"


@implementation PXMoveTool

- actionName
{
	return @"Moving";
}

- (void)mouseDownAt:(NSPoint)aPoint fromCanvasController:controller
{
	[[self undoManager] beginUndoGrouping];
	[[self undoManager] setActionName:@"Move Layer"];
	[self setLayers:[[[controller canvas] layers] deepMutableCopy] fromLayers:[[controller canvas] layers] ofCanvas:[controller canvas]];	
}

- (void)setLayers:layers fromLayers:oldLayers ofCanvas:canvas
{
	[[[self undoManager] prepareWithInvocationTarget:self] setLayers:oldLayers fromLayers:layers ofCanvas:canvas];
	[canvas setLayers:layers];
}

- (void)mouseDraggedFrom:(NSPoint)initialPoint to:(NSPoint)finalPoint fromCanvasController:controller
{
	[[[controller canvas] activeLayer] translateXBy:(finalPoint.x - initialPoint.x) yBy:(finalPoint.y - initialPoint.y)];
	[[controller canvas] changedInRect:NSMakeRect(0,0,[[controller canvas] size].width,[[controller canvas] size].height)];
}

- (void)mouseUpAt:(NSPoint)aPoint fromCanvasController:controller
{
	[[[controller canvas] activeLayer] finalizeMotion];
	[[self undoManager] endUndoGrouping];
}

@end
