//
//  PXLinearTool.m
//  Pixen-XCode
//
//  Created by Ian Henderson on Mon Mar 15 2004.
//  Copyright (c) 2004 Open Sword Group. All rights reserved.
//

#import "PXLinearTool.h"
#import "PXCanvas.h"
#import "PXCanvasController.h"


@implementation PXLinearTool
- init
{
    [super init];
    locked = FALSE;
    return self;
}

- actionName
{
    return @"Drawing Line";
}

- (BOOL)shiftKeyDown
{
    locked = TRUE;
	return YES;
}

- (BOOL)shiftKeyUp
{
    locked = FALSE;
	return YES;
}

- (void)mouseDownAt:(NSPoint)aPoint fromCanvasController:controller
{
    origin = aPoint;
    [super mouseDownAt:aPoint fromCanvasController:controller];
}

- (void)finalDrawToPoint:(NSPoint)finalPoint inCanvas:canvas
{
    // General class, no implementation.
}

- (void)drawToPoint:(NSPoint)finalPoint inCanvas:canvas
{
    // General class, no implementation.
}

- (BOOL)supportsAdditionalLocking
{
    return NO;
}

- (NSPoint)lockedPointFromUnlockedPoint:(NSPoint)unlockedPoint
{
    NSPoint modifiedFinal = unlockedPoint;
    if (locked) {
		float slope = (unlockedPoint.y - origin.y) / (unlockedPoint.x - origin.x);
		if ([self supportsAdditionalLocking]) {
			if (fabs(slope) < .25) {
				modifiedFinal.y = origin.y;
				return modifiedFinal;
			} else if (fabs(slope) < .75) {
				//x=2y ((but why do we need the +1??))
				modifiedFinal.x = origin.x + (slope > 0 ? 1 : -1) * 2 * (modifiedFinal.y-origin.y) + (unlockedPoint.x > origin.x ? 1 : -1);
				return modifiedFinal;
			} else if (fabs(slope) < 1.5) {
				//x=y
				modifiedFinal.x = origin.x + (slope > 0 ? 1 : -1) * (modifiedFinal.y - origin.y);
				return modifiedFinal;
			} else if (fabs(slope) < 3) {
				//y=2x ((but why do we need the +1??))
				modifiedFinal.y = origin.y + (slope > 0 ? 1 : -1) * 2 * (unlockedPoint.x-origin.x) + (unlockedPoint.x > origin.x ? 1 : -1);
				return modifiedFinal;
			} else {
				modifiedFinal.x = origin.x;
				return modifiedFinal;
			}
		}
		if (slope < 0) { // different diagonal
			modifiedFinal.x = origin.x - (unlockedPoint.y - origin.y);
		} else {
			modifiedFinal.x = origin.x + (unlockedPoint.y - origin.y);
		}
    }
    return modifiedFinal;
}

- (void)mouseUpAt:(NSPoint)aPoint fromCanvasController:controller
{
    [self finalDrawToPoint:[self lockedPointFromUnlockedPoint:aPoint] inCanvas:[controller canvas]];
    [super mouseUpAt:aPoint fromCanvasController:controller];
}

- (void)mouseDraggedFrom:(NSPoint)initialPoint to:(NSPoint)finalPoint fromCanvasController:controller
{
    if (!NSEqualPoints(initialPoint, finalPoint)) {
        [[self undoManager] undoNestedGroup];
        [[self undoManager] beginUndoGrouping];
		[self drawToPoint:[self lockedPointFromUnlockedPoint:finalPoint] inCanvas:[controller canvas]];
        [[self undoManager] endUndoGrouping];
    }
}
@end
