//
//  PXLayerDetailsView.m
//  Pixen-XCode
//
//  Created by Joe Osborn on Thu Feb 05 2004.
//  Copyright (c) 2004 Open Sword Group. All rights reserved.
//

#import "PXLayerDetailsView.h"
#import "PXLayer.h"
#import "PXCanvas.h"
#import "PXCanvasController.h"

@implementation PXLayerDetailsView

- initWithLayer:aLayer
{
	[super init];
	[NSBundle loadNibNamed:@"PXLayerDetailsView" owner:self];
	[self addSubview:view];
	[self setLayer:aLayer];
	[thumbnail setImage:image];
	[thumbnail setEditable:NO];
	isHidden = YES;
	changedRect = NSZeroRect;
	return self;
}

- (void)dealloc
{
	[self invalidateTimer];
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	[super dealloc];
}

- (void)setLayer:aLayer
{
	[self invalidateTimer];
	//set preview, name field, and other state
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	layer = aLayer;
	[image release];
	image = [[NSImage alloc] initWithSize:[layer size]];
	[name setStringValue:[layer name]];
	[opacity setFloatValue:[layer opacity]];
	[opacityField setFloatValue:[layer opacity]];
	[self updatePreview:nil];
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(updatePreview:) name:PXCanvasChangedNotificationName object:nil];
	timer = [[NSTimer scheduledTimerWithTimeInterval:0.8 target:self selector:@selector(shouldRedraw:) userInfo:nil repeats:YES] retain];
	[self setNeedsDisplay:YES];
}

- (void)updatePreview:notification
{
	if(((notification != nil) && (layer != [[notification userInfo] objectForKey:@"activeLayer"])) || [self isHidden]) { return; }
	changedRect = NSUnionRect(changedRect, (notification == nil) ? NSMakeRect(0,0,[layer size].width,[layer size].height) : [[[notification userInfo] objectForKey:@"changedRect"] rectValue]);
}

- (void)shouldRedraw:timer
{
	if (NSIsEmptyRect(changedRect)) { return; }
	[image lockFocus];
	BOOL oldVisibility = [layer visible];
    int oldOpacity = [layer opacity];
	[layer setVisible:YES];
    [layer setOpacity:100];
	[[NSColor clearColor] set];
	NSRectFill(changedRect);
	[layer drawRect:changedRect fixBug:YES];
	[layer setVisible:oldVisibility];
    [layer setOpacity:oldOpacity];
	[image unlockFocus];
	[thumbnail setImage:nil];
	[thumbnail setImage:image];
	[thumbnail setNeedsDisplay:YES];
	changedRect = NSZeroRect;
}

- (void)invalidateTimer
{
	if((timer != nil) && [timer isValid])
	{
		[timer invalidate];
		[timer release];
		timer = nil;
	}
}

- (BOOL)isHidden
{
	if([super respondsToSelector:@selector(isHidden)])
	{
		return [super isHidden];
	}
	return isHidden;
}

- (void)setHidden:(BOOL)newHidden
{
	if([self isHidden] == newHidden) { return; }
	if([super respondsToSelector:@selector(setHidden:)]) { [super setHidden:newHidden]; }
	isHidden = newHidden;
	[self updatePreview:nil];
}

- (IBAction)opacityDidChange:sender
{
	[opacity setFloatValue:[sender floatValue]];
	[opacityField setFloatValue:[sender floatValue]];
	[layer setOpacity:[sender floatValue]];
	[[NSNotificationCenter defaultCenter] postNotificationName:@"PXCanvasShouldRedrawNotificationName" object:layer];
}

- (IBAction)nameDidChange:sender
{
	[(PXLayer *)layer setName:[name stringValue]];
}

@end
