//
//  PXHotkeyFormatter.m
//  Pixen-XCode
//
//  Created by Andy Matuschak on Sun Apr 04 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

#import "PXHotkeyFormatter.h"


@implementation PXHotkeyFormatter

- stringForObjectValue:anObject
{
	if (![anObject isKindOfClass:[NSString class]]) { return nil; }
	if ([(NSString *)anObject length] > 0)
	{
		if([[NSScanner scannerWithString:anObject] scanInt:nil])
		{
			NSBeep();
			return @"";
		}
		return [NSString stringWithFormat:@"%c", [anObject characterAtIndex:0]];
	}
	else
		return @"";
}

- (BOOL)getObjectValue:(id *)anObject forString:string errorDescription:(NSString **)error;
{
	*anObject = [self stringForObjectValue:string];
	return YES;
}

- attributedStringForObjectValue:anObject defaultAttributes:attributes
{
	return [[NSAttributedString alloc] initWithString:[self stringForObjectValue:anObject]];
}

@end
