//  PXEyedropperTool.m
//  Pixen
//
//  Created by Joe Osborn on Mon Oct 13 2003.
//  Copyright (c) 2003 Open Sword Group. All rights reserved.
//

#import "PXEyedropperTool.h"
#import "PXCanvas.h"
#import "PXCanvasController.h"

@implementation PXEyedropperTool

- (void)eyedropAtPoint:(NSPoint)aPoint fromCanvasController:controller
{
	if (![[controller canvas] containsPoint:aPoint]) { return; }
	id image = [[NSImage alloc] initWithSize:[[controller canvas] size]];
	[image lockFocus];
	[[controller canvas] drawRect:NSMakeRect([[controller canvas] correct:aPoint].x, [[controller canvas] correct:aPoint].y, 1, 1) fixBug:YES];
	[switcher setColor:NSReadPixel([[controller canvas] correct:aPoint])];
	[image unlockFocus];
	[image release];
}

- (void)mouseDownAt:(NSPoint)aPoint fromCanvasController:controller
{
    [self eyedropAtPoint:aPoint fromCanvasController:controller];
}

- (void)mouseDraggedFrom:(NSPoint)initialPoint to:(NSPoint)finalPoint fromCanvasController:controller
{
    [self eyedropAtPoint:finalPoint fromCanvasController:controller];
}

- (void)mouseUpAt:(NSPoint)aPoint fromCanvasController:controller
{
    [self eyedropAtPoint:aPoint fromCanvasController:controller];   
}


@end
