#import "PXColorPaletteController.h"
#import "SubviewTableViewCell.h"
#import "PXColorWellCell.h"
#import "PXColorWell.h"
#import "MyDocument.h"
#import "PXCanvas.h"
#import "PXPalette.h"
#import "PXPaletteSwitcher.h"

PXColorPaletteController *colorPalette = nil;

@implementation PXColorPaletteController

+ palette
{
    if(colorPalette == nil) { colorPalette = [[self alloc] init]; }
    return colorPalette;
}

- (void)selectPaletteNamed:aName
{
	[switcher selectPaletteNamed:aName];
}

- init
{
    [super initWithWindowNibName:@"PXColorPalette"];
    colorPalette = self;
    [(NSPanel *)[self window] setBecomesKeyOnlyIfNeeded:YES];
	[[self window] setFrameAutosaveName:@"PXColorPaletteFrame"];
    return self;
}

- (void)reloadDataForCanvas:aCanvas
{
	canvas = aCanvas;
	[switcher populateMenuForCanvas:canvas];
}

- (void)windowWillClose:notification
{
	[[NSUserDefaults standardUserDefaults] setBool:NO forKey:@"PXColorPaletteIsOpen"];
}

- (void)showWindow:sender
{
	[[NSUserDefaults standardUserDefaults] setBool:YES forKey:@"PXColorPaletteIsOpen"];
	[super showWindow:sender];
}

- (void)windowDidLoad
{
    id prototype = [[PXColorWellCell alloc] init];
    [[NSColorPanel sharedColorPanel] setShowsAlpha:YES];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(colorWellSelected:) name:@"PXColorWellLeftSelected" object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(colorWellSelected:) name:@"PXColorWellRightSelected" object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(colorWellColorChanged:) name:@"PXColorWellColorChanged" object:nil];                  
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(colorAdded:) name:@"PXImageColorAddedNotification" object:nil];
    matrix = [[NSMatrix alloc] initWithFrame:NSMakeRect(0, -32*32, 33 * 8, 32*32+32) mode:NSTrackModeMatrix prototype:prototype numberOfRows:32 numberOfColumns:8];
    [matrix setSelectionByRect:NO];
    [matrix setDrawsBackground:YES];
    [matrix setDrawsCellBackground:YES];
    [matrix setAutosizesCells:YES];
    [matrix setAutoresizingMask:NSViewMaxYMargin];
    [matrix setAutosizesCells:NO];
	[scrollView setDocumentView:matrix];
}


- (void)keyDown:(NSEvent *)event
{
    int column = -1, row = 0;
    NSString * chars = [[event charactersIgnoringModifiers] lowercaseString];
    if([[NSScanner scannerWithString:chars] scanInt:&column])
    {
		column--;
		if(column < 0) { column = 9; }
    }
    else
    {
		//the characters change when shift is held down, so we can't just do a modifier check
		//this won't work for international keyboards, either, will it?
		NSArray * symbols = [NSArray arrayWithObjects:@"!", @"@", @"#", @"$", @"%", @"^", @"&", @"*", @"(", @")", nil];
		if([symbols containsObject:chars])
		{	
			column = [symbols indexOfObject:chars];
			row = 1;
			if([event modifierFlags] & (NSAlternateKeyMask))
			{
				row = 2;
			}
		}
    }
    if(column == -1) { return; }
    if([event modifierFlags] & (NSControlKeyMask))
    {
		[[matrix cellAtRow:row column:column] rightSelect];
    }
    else
    {
		[[matrix cellAtRow:row column:column] leftSelect];
    }
}

- (void)colorWellSelected:aNotification
{
    if([[aNotification name] isEqual:@"PXColorWellLeftSelected"])
    {
		[[NSNotificationCenter defaultCenter] postNotificationName:@"PXPaletteLeftColorChosen" object:self userInfo:[NSDictionary dictionaryWithObjectsAndKeys:[[aNotification object] color], @"color", nil]];
		leftMatrixWell = [aNotification object];
    }
    else
    {
		[[NSNotificationCenter defaultCenter] postNotificationName:@"PXPaletteRightColorChosen" object:self userInfo:[NSDictionary dictionaryWithObjectsAndKeys:[[aNotification object] color], @"color", nil]];
		rightMatrixWell = [aNotification object];
    }
}



- (void)colorAdded:aNotification
{
	if([canvas hasImage:[aNotification object]])
	{	
		int index = [palette addColor:[[aNotification userInfo] objectForKey:@"color"]];
		if(index != -1)
		{	
			[[[matrix cells] objectAtIndex:index] setColor:[palette colorAtIndex:index]];
		}
	}
}

- (void)replaceColor:oldColor withColor:newColor atPaletteIndex:(unsigned)index swapping:(BOOL)swap
{
	[[NSNotificationCenter defaultCenter] removeObserver:self name:@"PXImageColorAddedNotification" object:nil];
	[palette setColor:newColor atIndex:index];
	if(swap && ([oldColor alphaComponent] > .00125))
	{	
		[canvas replacePixelsOfColor:oldColor withColor:newColor]; 
	}
	[[NSNotificationCenter defaultCenter] removeObserver:self name:@"PXColorWellColorChanged" object:nil];
	[(PXColorWell *)[[[matrix cells] objectAtIndex:index] view] setColor:newColor];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(colorWellColorChanged:) name:@"PXColorWellColorChanged" object:nil];                  
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(colorAdded:) name:@"PXImageColorAddedNotification" object:nil];
}

- (void)colorWellColorChanged:aNotification
{
	if(([aNotification object] != leftMatrixWell) && ([aNotification object] != rightMatrixWell)) { return; }
	id oldColor = [[aNotification userInfo] objectForKey:@"oldColor"];
	id newColor = [[aNotification object] color];
	if(![[[matrix cells] valueForKey:@"view"] containsObject:[aNotification object]]) { return; }
	if([aNotification object] == leftMatrixWell)
	{
		[[NSNotificationCenter defaultCenter] postNotificationName:@"PXPaletteLeftColorChosen" object:self userInfo:[NSDictionary dictionaryWithObjectsAndKeys:newColor, @"color", nil]];
	}
	else
	{
		[[NSNotificationCenter defaultCenter] postNotificationName:@"PXPaletteRightColorChosen" object:self userInfo:[NSDictionary dictionaryWithObjectsAndKeys:newColor, @"color", nil]];
	}
	[self replaceColor:oldColor withColor:newColor atPaletteIndex:[[[matrix cells] valueForKey:@"view"] indexOfObject:[aNotification object]] swapping:[[NSUserDefaults standardUserDefaults] boolForKey:@"PXSmartPaletteEnabled"]];
}

- (void)palette:aPalette foundDuplicateColorsAtIndex:(unsigned)first andIndex:(unsigned)second
{
	id oldColor = [[palette colorAtIndex:first] colorUsingColorSpaceName:NSCalibratedRGBColorSpace];
	id newColor = [NSColor colorWithCalibratedRed:[oldColor redComponent] green:[oldColor greenComponent] blue:[oldColor blueComponent] alpha:[oldColor alphaComponent] - 0.000001];
	[self replaceColor:oldColor withColor:newColor atPaletteIndex:second swapping:[[NSUserDefaults standardUserDefaults] boolForKey:@"PXSmartPaletteEnabled"]];
}

- (void)setPalette:newPalette
{
	if(palette == newPalette) { return; }
	id old = palette;
	palette = [newPalette retain];
	[old autorelease];
	[palette setDelegate:self];
	int i;
	for(i = 0; ((i < [[palette colors] count]) || (i < [[old colors] count])) && (i < 256); i++)
	{
		id oldColor = (i < [[old colors] count]) ? [[old colors] objectAtIndex:i] : [NSColor clearColor];
		id newColor = (i < [[palette colors] count]) ? [[palette colors] objectAtIndex:i] : [[NSColor clearColor] colorWithAlphaComponent:.001];
		[self replaceColor:oldColor withColor:newColor atPaletteIndex:i swapping:(i < [[old colors] count]) && (![[palette name] isEqual:@"Generated Palette"] && ![[old name] isEqual:@"Generated Palette"] && [[NSUserDefaults standardUserDefaults] boolForKey:@"PXSmartPaletteEnabled"])];
	}
	//[[[matrix cells] objectAtIndex:0] leftSelect];
}

@end