//  PXCanvasController.h
//  Pixen
//
//  Created by Joe Osborn on Sat Sep 13 2003.
//  Copyright (c) 2003 Open Sword Group. All rights reserved.
//

#import <Foundation/Foundation.h>

@class PXCanvasView, PXCanvas;

@interface PXCanvasController : NSWindowController {
    PXCanvas *canvas;
    PXCanvasView *view;
    id scrollView;
    id zoomPercentageBox;
    id zoomStepper;
	id zoomView;
    id prompter;
    id resizePrompter;
	id scaleController;
    id gridSettingsPrompter;
	id toolbar;
    
    id previewController;
    id layerController;
    id backgroundController;
    NSPoint initialPoint;
    BOOL downEventOccurred;
    BOOL usingControlKey;
	
	id printView;
}

- (PXCanvasView *)view;
- (PXCanvas *)canvas;
- (void)setCanvas:aCanvas;
- (void)setColor:aColor;
- (void)setLayers:layers fromLayers:oldLayers;

- (IBAction)toggleLayersDrawer:sender;
- (IBAction)newLayer:sender;
- (IBAction)deleteLayer:sender;
- (IBAction)mergeDown:sender;
- (IBAction)promoteSelection:sender;
- (IBAction)flipLayerHorizontally:sender;
- (IBAction)flipLayerVertically:sender;
- (IBAction)duplicateLayer:sender;

- (IBAction)showBackgroundInfo:sender;
- (IBAction)showPreviewWindow:sender;
- (IBAction)togglePreviewWindow:sender;
- (IBAction)showGridSettingsPrompter:sender;
- (IBAction)resizeCanvas:sender;
- (IBAction)scaleCanvas:sender;
- (IBAction)zoomIn:sender;
- (IBAction)zoomOut:sender;
- (IBAction)zoomStandard:sender;
- (IBAction)zoomPercentageChanged:sender;
- (IBAction)zoomStepperStepped:sender;
- (IBAction)zoomToFit:sender;

- (IBAction)increaseOpacity:sender;
- (IBAction)decreaseOpacity:sender;

- (void)zoomInOnCanvasPoint:(NSPoint)point;
- (void)zoomOutOnCanvasPoint:(NSPoint)point;
- (void)layerSelectionDidChange:aNotification;
- (void)canvasSizeDidChange:aNotification;
- (void)updatePreview;
- (void)updateCanvasSize;

@end
