//
//  PXBackgroundController.h
//  Pixen-XCode
//
//  Created by Joe Osborn on Sun Oct 26 2003.
//  Copyright (c) 2003 Open Sword Group. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface NSObject(PXBackgroundControllerDelegate)
- (void)setMainBackground:aBackground;
- (void)setAlternateBackground:aBackground;
- (void)backgroundChanged:aNotification;
@end

@interface PXBackgroundController : NSWindowController {
    id delegate;
    id mainBackground;
    id alternateBackground;
    NSMutableArray * defaultBackgrounds;
    IBOutlet NSPopUpButton * mainMenu, * alternateMenu;
    IBOutlet NSView * mainConfigurator;
    IBOutlet NSView * alternateConfigurator;
	IBOutlet NSButton * alternateCheckbox;
    BOOL usesAlternateBackground;
    id namePrompter;
}
+ backgroundNamed:aName;
+ defaultBackgrounds;
- (IBAction)useAlternateBackgroundCheckboxClicked:sender;
- (IBAction)selectMainBackground:sender;
- (IBAction)selectAlternateBackground:sender;
- (void)useBackgroundsOf:aCanvas;
- (void)setDelegate:anObject;
- (IBAction)useCurrentBackgroundsAsDefaults:sender;

@end
