Thanks for your interest in contributing to pipx!

## Running pipx From Source Tree
To run the pipx executable from your source tree during development, run pipx from the src directory:

```
python src/pipx --version
```

## Running Tests

### Setup
pipx uses an automation tool called [nox](https://pypi.org/project/nox/) for development, continuous integration testing, and various tasks.

`nox` defines tasks or "sessions" in `noxfile.py` which can be run with `nox -s SESSION_NAME`. Session names can be listed with `nox -l`.

Install nox for pipx development:
```
python -m pip install --user git+https://github.com/cs01/nox.git@5ea70723e9e6 nox
```

!!! note
    A specific version of nox must be used for pipx development until [nox issue 233](https://github.com/theacodes/nox/issues/233) is resolved.

Tests are defined as `nox` sessions. You can see all nox sessions with
```
nox -l
```

At the time of this writing, the output looks like this
```
>> nox -l
Sessions defined in /home/csmith/git/pipx/noxfile.py:

* tests-3.6
* tests-3.7
* tests-3.8
- cover -> Coverage analysis
* lint
* docs
- develop-3.6
- develop-3.7
- develop-3.8
- build
- publish
- watch_docs
- publish_docs
```

### Unit Tests
To run unit tests in Python3.7, you can run
```
nox -s tests-3.7
```

!!! tip
    You can running a specific unit test by passing arguments to pytest, the test runner pipx uses:

    ```
    nox -s tests-3.8 -- -k EXPRESSION
    ```

    Expression can be a test name, such as

    ```
    nox -s tests-3.8 -- -k test_uninstall
    ```

    Coverage errors can usually be ignored when only running a subset of tests.

### Lint Tests

```
nox -s lint
```

## Testing pipx on Continuous Integration builds
When you push a new git branch, tests will automatically be run against your code as defined in `.github/workflows/on-push.yml`.

## Building Documentation

`pipx` autogenerates API documentation, and also uses templates.

When updating pipx docs, make sure you are either modifying a file in the `templates` directory, or the `docs` directory. If in the `docs` directory, make sure the file was not autogenerated from the `templates` directory. Autogenerated files have a note at the top of the file.

You can generate the documentation with
```
nox -s docs
```

This will capture CLI documentation for any pipx argument modifications, as well as generate templates to the docs directory.

To preview changes, including live reloading, open another terminal and run
```
nox -s watch_docs
```

### Publishing Doc Changes to GitHub pages
```
nox -s publish_docs
```

## Releasing New `pipx` Versions
To create a new release

* Update pipx's version in `src/pipx/version.py` and regenerate documentation.
* Make sure the changelog is updated
    * Add new version to head the latest block of changes (instead of "dev").
    * Make sure all notable changes are listed.

Finally, run
```bash
nox -s publish
nox -s publish_docs
```

and create a new release in GitHub.
