#!/bin/sh
##########################################################
#
# Download source code (do not yet compile) of some
# ham radio software packages, namely
#
# needed for piHPSDR:
# ===================
# WDSP			FFT library for SDR programs
# piHPSDR               SDR program for HPSDR and Soapy radios
#
# only needed if piHPSDR is compiled with the SOAPYSDR option:
# ============================================================
# SoapySDR core		core of the SoapySDR layer
# libiio		needed for Soapy PlutoSDR module
# PlutoSDR		SoapySDR module for Adalm Pluto
#
# if you want to run fldigi/wsjtx/freedv on the RaspPi:
# =====================================================
# hamlib		TRX control libraray
#			(needed for fldigi and wsjtx)
# fldigi		digimode program for RTTY, PSK, etc.
# wsjtx			digimode program for FT8, FT4, JT65, etc.
# freedv		digital voice program
#
##########################################################
#
# DELETE  all directories we are going to clone
#         this will delete all your personal setups there!
#
##########################################################

cd $HOME

yes | rm -rf wdsp
yes | rm -rf pihpsdr
yes | rm -rf SoapySDR
yes | rm -rf libiio
yes | rm -rf SoapyPlutoSDR
yes | rm -rf hamlib
yes | rm -rf fldigi
yes | rm -rf wsjtx

rm -f $HOME/Desktop/pihpsdr.desktop
rm -f $HOME/Desktop/fldigi.desktop
rm -f $HOME/Desktop/wsjtx.desktop
rm -f $HOME/Desktop/freedv.desktop

#
# --------------------
# Dowload WDSP library
# --------------------
#
cd $HOME
git clone https://github.com/dl1ycf/wdsp
#
# ---------------
# Dowload piHPSDR
# ---------------
#
cd $HOME
git clone https://github.com/dl1ycf/pihpsdr
#
# ----------------------
# Download SoapySDR core
# ----------------------
#
cd $HOME
git clone https://github.com/pothosware/SoapySDR.git

# ----------------------------------------
# Download libiio (needed for Soapy Pluto)
# ----------------------------------------
#
cd $HOME
git clone https://github.com/analogdevicesinc/libiio.git
#
# ----------------------------------
# Download the SoapySDR Pluto module
# ----------------------------------
#
cd $HOME
git clone https://github.com/pothosware/SoapyPlutoSDR
#
# -------------------------------------------------
# Download hamlib (use 4.4 release version)
# (needed for fldigi,GUI rig controller, and wsjtx)
# -------------------------------------------------
#
cd $HOME
git clone https://github.com/hamlib/hamlib
cd hamlib
git checkout 4.4
#
# ---------------
# Download fldigi
# ---------------
#
cd $HOME
git clone https://git.code.sf.net/p/fldigi/fldigi
#
# -----------------------------------------
# Download wsjtx. Use release version 2.5.2
# -----------------------------------------
#
cd $HOME
git clone https://git.code.sf.net/p/wsjt/wsjtx
cd wsjtx
git checkout wsjtx-2.5.2
#
# ---------------
# Download FreeDV
# ---------------
#
cd $HOME
rm -rf freedv-gui
git clone https://github.com/drowe67/freedv-gui.git

##########################################################
#
# Create Desktop Icons and startup scripts
# for piHPSDR, fldigi, wsjtx, FreeDV
#
##########################################################

cd $HOME
#
# We invoke pihpsdr through a "shell script wrapper".
# This way we can take care the HPSDR logo is found
# and combine the stdout and stderr output into a single
# log file.
#
cat > $HOME/pihpsdr/pihpsdr.sh << '#EOF'
#!/bin/sh
cd $HOME/pihpsdr
rm -f hpsdr.png
cp release/pihpsdr/hpsdr.png hpsdr.png
./pihpsdr >pihpsdr.log 2>&1
#EOF
chmod 755 $HOME/pihpsdr/pihpsdr.sh

#
# The desktop files are created "the pedestrian way"
# then we can insert the actual home dir
#
FILE=$HOME/Desktop/pihpsdr.desktop
echo "[Desktop Entry]"                                    > $FILE
echo "Name=piHPSDR"                                      >> $FILE
echo "Icon=$HOME/pihpsdr/release/pihpsdr/hpsdr_icon.png" >> $FILE
echo "Exec=$HOME/pihpsdr/pihpsdr.sh"                     >> $FILE
echo "Type=Application"                                  >> $FILE
echo "Terminal=false"                                    >> $FILE
echo "StartupNotify=false"                               >> $FILE

FILE=$HOME/Desktop/fldigi.desktop
echo "[Desktop Entry]"                                    > $FILE
echo "Name=Fldigi"                                       >> $FILE
echo "Icon=$HOME/fldigi/data/fldigi-psk.png"             >> $FILE
echo "Exec=$HOME//fldigi/src/fldigi"                     >> $FILE
echo "Type=Application"                                  >> $FILE
echo "Terminal=false"                                    >> $FILE
echo "StartupNotify=false"                               >> $FILE

FILE=$HOME/Desktop/wsjtx.desktop
echo "[Desktop Entry]"                                    > $FILE
echo "Name=wsjtx"                                        >> $FILE
echo "Icon=$HOME/wsjtx/icons/Unix/wsjtx_icon.png"        >> $FILE
echo "Exec=$HOME/wsjtx/bin/wsjtx"                        >> $FILE
echo "Type=Application"                                  >> $FILE
echo "Terminal=false"                                    >> $FILE
echo "StartupNotify=false"                               >> $FILE

FILE=$HOME/Desktop/freedv.desktop
echo "[Desktop Entry]"                                    > $FILE
echo "Name=FreeDV"                                       >> $FILE
echo "Icon=$HOME/freedv-gui/contrib/freedv128x128.png"   >> $FILE
echo "Exec=$HOME/freedv-gui/build_linux/src/freedv"      >> $FILE
echo "Type=Application"                                  >> $FILE
echo "Terminal=false"                                    >> $FILE
echo "StartupNotify=false"                               >> $FILE

