#!/bin/sh
##########################################################
#
# Load Raspian packages required to compile + run
# programs such as piHPSDR, fldigi, etc.
#
# It is recommended to start from a "minimal" Raspian
# installation. More specifically, pre-installing
# ham radio packages may cause more harm than it solves
# problems, since e.g. having two different versions of
# hamlib (one from pre-install, one compiled from sources)
# may cause problems.
#
##########################################################

cd $HOME

#
# ------------------------------------
# Install standard tools and compilers
# ------------------------------------
#
sudo apt-get --yes install build-essential
sudo apt-get --yes install module-assistant
sudo apt-get --yes install vim
sudo apt-get --yes install make
sudo apt-get --yes install gcc
sudo apt-get --yes install g++
sudo apt-get --yes install gfortran
sudo apt-get --yes install git
sudo apt-get --yes install pkg-config
sudo apt-get --yes install cmake
sudo apt-get --yes install autoconf
sudo apt-get --yes install autopoint
sudo apt-get --yes install gettext
sudo apt-get --yes install automake
sudo apt-get --yes install libtool
sudo apt-get --yes install cppcheck
sudo apt-get --yes install dos2unix
#
# ---------------------------------------
# Install libraries necessary for piHPSDR
# ---------------------------------------
#
sudo apt-get --yes install libfftw3-dev
sudo apt-get --yes install libgtk-3-dev
sudo apt-get --yes install libasound2-dev
sudo apt-get --yes install libcurl4-openssl-dev
sudo apt-get --yes install libusb-1.0-0-dev
sudo apt-get --yes install libi2c-dev
sudo apt-get --yes install libgpiod-dev
sudo apt-get --yes install libpulse-dev
sudo apt-get --yes install pulseaudio

#
# ----------------------------------------------
# Install standard libraries necessary for SOAPY
# ----------------------------------------------
#
sudo apt-get install --yes libaio-dev
sudo apt-get install --yes libavahi-client-dev
sudo apt-get install --yes libad9361-dev
sudo apt-get install --yes bison
sudo apt-get install --yes flex
sudo apt-get install --yes libxml2-dev
#
# -----------------------------------------------
# Install standard libraries necessary for FLDIGI
# -----------------------------------------------
#
sudo apt-get install --yes libfltk1.3-dev
sudo apt-get install --yes portaudio19-dev
sudo apt-get install --yes libsamplerate0-dev
sudo apt-get install --yes libsndfile1-dev
#
# ----------------------------------------------
# Install standard libraries necessary for WSJTX
# ----------------------------------------------
#
sudo apt-get install --yes libboost-dev
sudo apt-get install --yes libboost-log-dev
sudo apt-get install --yes libboost-regex-dev
# The following package is required on buster but
# does not exist on bullseye.
# The next line will cause an error message on
# bullseye which you can ignore.
sudo apt-get install --yes qt5-default
sudo apt-get install --yes qttools5-dev
sudo apt-get install --yes qttools5-dev-tools
sudo apt-get install --yes qtmultimedia5-dev
sudo apt-get install --yes libqt5multimedia5-plugins
sudo apt-get install --yes libqt5serialport5-dev
sudo apt-get install --yes libudev-dev
#
# -----------------------------------------------
# Install standard libraries necessary for FreeDV
# -----------------------------------------------
#
sudo apt-get install --yes libspeexdsp-dev
sudo apt-get install --yes sox
#
# One of the two following commands should fail but
# the other succeed. This is so because the "wxWidgets"
# package has different names with the "buster" and
# "bullseye" versions of the RaspberryPi OS
#
sudo apt-get install --yes libwxgtk3.0-dev
sudo apt-get install --yes libwxgtk3.0-gtk3-dev
sudo apt-get install --yes libao-dev
sudo apt-get install --yes libgsm-1
sudo apt-get install --yes libsndfile-dev
