#!/bin/sh
##########################################################
#
# Download source code (do not yet compile) of some
# ham radio software packages, namely
#
# needed for piHPSDR:
# ===================
# WDSP			FFT library for SDR programs
# piHPSDR               SDR program for HPSDR and Soapy radios
#
# only needed if piHPSDR is compiled with the SOAPYSDR option:
# ============================================================
# SoapySDR core		core of the SoapySDR layer
# libiio		needed for Soapy PlutoSDR module
# PlutoSDR		SoapySDR module for Adalm Pluto
#
# if you want to run fldigi/wsjtx/freedv on the RaspPi:
# ==============================================
# hamlib		TRX control libraray
#			(needed for fldigi and wsjtx)
# fldigi		digimode program for RTTY, PSK, etc.
# wsjtx			digimode program for FT8, FT4, JT65, etc.
# freedv		digital voice program
#
##########################################################
#
# DELETE  all directories we are going to clone
#         this will delete all your personal setups there!
#
##########################################################

cd $HOME

yes | rm -rf wdsp
yes | rm -rf pihpsdr
yes | rm -rf SoapySDR
yes | rm -rf libiio
yes | rm -rf SoapyPlutoSDR
yes | rm -rf hamlib
yes | rm -rf fldigi
yes | rm -rf wsjtx
#
# --------------------
# Dowload WDSP library
# --------------------
#
cd $HOME
git clone https://github.com/dl1ycf/wdsp
#
# ---------------
# Dowload piHPSDR
# ---------------
#
cd $HOME
git clone https://github.com/dl1ycf/pihpsdr
#
# ----------------------
# Download SoapySDR core
# ----------------------
#
cd $HOME
git clone https://github.com/pothosware/SoapySDR.git

# ----------------------------------------
# Download libiio (needed for Soapy Pluto)
# ----------------------------------------
#
cd $HOME
git clone https://github.com/analogdevicesinc/libiio.git
#
# ----------------------------------
# Download the SoapySDR Pluto module
# ----------------------------------
#
cd $HOME
git clone https://github.com/pothosware/SoapyPlutoSDR
#
# -------------------------------------------------
# Download hamlib (use 4.4 release version)
# (needed for fldigi,GUI rig controller, and wsjtx)
# -------------------------------------------------
#
cd $HOME
git clone https://github.com/hamlib/hamlib
cd hamlib
git checkout 4.4
#
# ---------------
# Download fldigi
# ---------------
#
cd $HOME
git clone https://git.code.sf.net/p/fldigi/fldigi
#
# --------------
# Download wsjtx
# --------------
#
cd $HOME
git clone https://git.code.sf.net/p/wsjt/wsjtx
#
# ---------------
# Download FreeDV
# ---------------
#
cd $HOME
rm -rf freedv-gui
git clone https://github.com/drowe67/freedv-gui.git
