#!/bin/sh
##########################################################
#
# Load Raspian packages required to compile + run
# programs such as piHPSDR, fldigi, etc.
#
##########################################################

cd $HOME

#
# ------------------------------------
# Install standard tools and compilers
# ------------------------------------
#
sudo apt-get --yes install build-essential
sudo apt-get --yes install module-assistant
sudo apt-get --yes install vim
sudo apt-get --yes install make
sudo apt-get --yes install gcc
sudo apt-get --yes install g++
sudo apt-get --yes install gfortran
sudo apt-get --yes install git
sudo apt-get --yes install pkg-config
sudo apt-get --yes install cmake
sudo apt-get --yes install autoconf
sudo apt-get --yes install automake
sudo apt-get --yes install libtool
sudo apt-get --yes install cppcheck
sudo apt-get --yes install dos2unix
#
# ---------------------------------------
# Install libraries necessary for piHPSDR
# ---------------------------------------
#
sudo apt-get --yes install libfftw3-dev
sudo apt-get --yes install libgtk-3-dev
sudo apt-get --yes install libasound2-dev
sudo apt-get --yes install libcurl4-openssl-dev
sudo apt-get --yes install libusb-1.0-0-dev
sudo apt-get --yes install libi2c-dev
sudo apt-get --yes install libgpiod-dev
sudo apt-get --yes install libpulse-dev
sudo apt-get --yes install pulseaudio
sudo apt-get --yes install pavucontrol

#
# ----------------------------------------------
# Install standard libraries necessary for SOAPY
# ----------------------------------------------
#
sudo apt-get install --yes libaio-dev
sudo apt-get install --yes libavahi-client-dev
sudo apt-get install --yes libad9361-dev
sudo apt-get install --yes bison
sudo apt-get install --yes flex
sudo apt-get install --yes libxml2-dev
#
# -----------------------------------------------
# Install standard libraries necessary for FLDIGI
# -----------------------------------------------
#
sudo apt-get install --yes libfltk1.3-dev
sudo apt-get install --yes portaudio19-dev
sudo apt-get install --yes libsamplerate0-dev
sudo apt-get install --yes libsndfile1-dev
#
# ----------------------------------------------
# Install standard libraries necessary for WSJTX
# ----------------------------------------------
#
sudo apt-get install --yes libboost-dev
sudo apt-get install --yes libboost-log-dev
sudo apt-get install --yes libboost-regex-dev
sudo apt-get install --yes qt5-default
sudo apt-get install --yes qttools5-dev
sudo apt-get install --yes qttools5-dev-tools
sudo apt-get install --yes qtmultimedia5-dev
sudo apt-get install --yes libqt5multimedia5-plugins
sudo apt-get install --yes libqt5serialport5-dev
sudo apt-get install --yes libudev-dev
#
# -----------------------------------------------
# Install standard libraries necessary for FreeDV
# -----------------------------------------------
#
sudo apt-get install --yes libspeexdsp-dev
sudo apt-get install --yes sox
sudo apt-get install --yes libwxgtk3.0-gtk-dev
sudo apt-get install --yes libao-dev
sudo apt-get install --yes libgsm-1
sudo apt-get install --yes libsndfile-dev
