///
/// Predicate handling.
/// Predicate parsing and interpretation.
///	@file		predicate.h - pianod2
///	@author		Perette Barella
///	@date		2015-10-12
///	@copyright	Copyright (c) 2015-2017 Devious Fish. All rights reserved.
///

#ifndef __pianod__enginepredicate__
#define __pianod__enginepredicate__

#include <config.h>

#include <memory>

#include <football.h>

#include "fundamentals.h"
#include "connection.h"
#include "filter.h"


// Standard and playlist predicates are the same, but get different
// tag names so that they can be used together on a command line.
#define PREDICATETYPETAG "type"
#define PREDICATEMANNERTAG "manner"
#define PREDICATEEXPRESSIONTAG "expression"
#define PREDICATEFULFILLMENTTAG "fulfill"

#define FULFILLMENT " [" PREDICATEFULFILLMENTTAG ":authoritative|discretionary]"
#define OPTIONALTYPE " [" PREDICATETYPETAG ":any|artist|album|song|playlist|genre]"
#define ALLMANNER " <" PREDICATEMANNERTAG ":id|name|like|where|source>"
#define LIMITEDMANNER " <" PREDICATEMANNERTAG ":id|name|like>"
#define RECURSIONMANNER " <" PREDICATEMANNERTAG ":id|name|like|where>"

#define SIMPLE_LIST_PREDICATE OPTIONALTYPE RECURSIONMANNER " {" PREDICATEEXPRESSIONTAG "} ..."
#define LIST_PREDICATE FULFILLMENT OPTIONALTYPE ALLMANNER " {" PREDICATEEXPRESSIONTAG "} ..."
#define SINGLE_PREDICATE LIMITEDMANNER " {" PREDICATEEXPRESSIONTAG "}"



#define PLAYLISTTYPETAG nullptr
#define PLAYLISTMANNERTAG "playlistmanner"
#define PLAYLISTEXPRESSIONTAG "playlist"

#define PLALLMANNER " <" PLAYLISTMANNERTAG ":id|name|like|where|source>"
#define PLLIMITEDMANNER " <" PLAYLISTMANNERTAG ":id|name|like>"
#define LIST_PLAYLIST PLALLMANNER " {" PLAYLISTEXPRESSIONTAG "} ..."
#define SINGLE_PLAYLIST PLLIMITEDMANNER " {" PLAYLISTEXPRESSIONTAG "}"



namespace Predicate {
    struct TagNames {
        const char *type;
        const char *manner;
        const char *expression;
    };
    const TagNames genericTags {
        PREDICATETYPETAG,
        PREDICATEMANNERTAG,
        PREDICATEEXPRESSIONTAG
    };

    /// Check for presence of a predicate.
    inline bool havePredicate (const PianodConnection &conn, const TagNames &tags = genericTags) {
        return conn [tags.manner];
    }
    /// Check for the presence of a playlist predicate.
    inline bool havePlaylistPredicate (const PianodConnection &conn) {
        return conn [PLAYLISTMANNERTAG];
    }
    /// Check for the presence of a song predicate
    inline bool haveSongPredicate (const PianodConnection &conn) {
        return conn [PREDICATEMANNERTAG];
    }

    std::unique_ptr <Filter> getPredicate (const PianodConnection &conn,
                                           Filter::Field field = Filter::Field::Search,
                                           const TagNames &tags = genericTags);

    // Generic Things
    ThingieList getSpecifiedThings (const PianodConnection &conn,
                                    SearchRange search_what = SearchRange::KNOWN);
    MusicThingie *getSpecifiedThing (const PianodConnection &conn);

    // Songs
    SongList getSpecifiedSongs (const PianodConnection &conn,
                                SearchRange search_what = SearchRange::KNOWN);
    PianodSong *getSpecifiedSong (const PianodConnection &conn);

    // Playlists
    PlaylistList getSpecifiedPlaylists (const PianodConnection &conn);
    PianodPlaylist *getSpecifiedPlaylist (const PianodConnection &conn);

}


#endif
