///
/// Functions that deal with all the possible sources.
///	@file		sources.h - pianod2
///	@author		Perette Barella
///	@date		2016-03-22
///	@copyright	Copyright (c) 2016-2020 Devious Fish. All rights reserved.
///

#pragma once

#include <config.h>

#include <string>
#include <vector>

class PianodService;
namespace UserData {
    class StringDictionary;
    class DataStore;
}
class User;

// Interfaces and names of specific sources
#define SOURCE_NAME_MANAGER "manager"

#ifdef WITH_PANDORA
#define SOURCE_NAME_PANDORA "pandora"
extern void register_pandora_commands (PianodService *service);
extern void restore_pandora_source (UserData::StringDictionary *params, User *user);
#endif

#ifdef WITH_TONEGENERATOR
#define SOURCE_NAME_TONEGENERATOR "tonegenerator"
extern void register_tonegenerator_commands (PianodService *service);
extern void restore_tonegenerator_source (UserData::StringDictionary *params, User *user);
#endif

#ifdef WITH_FILESYSTEM
#define SOURCE_NAME_FILESYSTEM "filesystem"
extern void register_filesystem_commands (PianodService *service);
extern void restore_filesystem_source (UserData::StringDictionary *params, User *user);
#endif

namespace UserData {
    class DataStore;
}

namespace Sources {
    const std::vector<std::string> &sourceNames ();
    bool isSource (const std::string &origin);
    void registerCommands (PianodService *service);
    void restore (UserData::DataStore *source_data, User *owner);
    void report (int verbose);
}

