/*
 *  fb_service.h
 *  Player
 *
 *  Created by Perette Barella on 2012-03-03.
 *  Copyright 2012 Devious Fish. All rights reserved.
 *
 */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdbool.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "fb_public.h"

#ifndef __FB_SERVICE__
#define __FB_SERVICE__


typedef enum fb_socket_type_t {
	FB_SOCKTYPE_SERVICE = 0x3692, /* Random numbers */
	FB_SOCKTYPE_CONNECTION = 0x5285,
	FB_SOCKTYPE_USER = 0xa9f7,
	FB_SOCKTYPE_EVENT = 0xbd53
} FB_SOCKETTYPE;

typedef enum fb_socket_state_t {
	FB_SOCKET_STATE_OPEN = 0,
	FB_SOCKET_STATE_FLUSHING,
	FB_SOCKET_STATE_CLOSING
} FB_SOCKETSTATE;


typedef struct fb_service_t {
	FB_SOCKETTYPE type;
	FB_SOCKETSTATE state;	/* Is the service open or closing? */
	in_port_t port_number;	/* Original port number; not important */
	size_t contextsize;
	int queue_size;		/* Max connections queueing; not important */
	int ip4socket;		/* Stuff about the sockets */
	struct sockaddr_in ip4addr;
	int ip6socket;
#ifdef HAVE_IPV6
	struct sockaddr_in6 ip6addr;
#endif
	size_t connection_count;	/* Number of active connections in the collection */
	size_t connections_size;	/* Total number of slots in the collection */
	struct fb_connection_t **connections;	/* Connections to services */
	struct fb_service_t *next; /* For reap queue */
} FB_SERVICE;


typedef struct fb_connection_t {
	FB_SOCKETTYPE type;
	FB_SERVICE *service;	/* Service to which connection is made */
	int socket;	
	FB_SOCKETSTATE state;	/* Are we open, flushing, or closing? */
	struct fb_outputq_t *outfirst;	/* Output queue */
	struct fb_outputq_t *outlast;
	ssize_t outpoint; /* # bytes in first message block that have already been sent. */
	int domain;
	union {
		struct sockaddr_in ip4addr;
#ifdef HAVE_IPV6
		struct sockaddr_in6 ip6addr;
#endif
		char foobar;
	} origin;
	char *filename;		/* For file connections */
	FILE *file;			/* read() on file doesn't handle canonical stuff */
	void *context;		/* For user use, if desired/needed */
} FB_CONNECTION;

/* User iterators */
typedef struct fb_iterator_t {
	FB_SERVICE *service;
	ssize_t iteration;
} FB_ITERATOR;


/* Destroy the service when all connections are closed. */
extern void fb_free_freelists ();
extern void fb_destroy_service (struct fb_service_t *service);
extern void fb_schedule_reap (FB_SERVICE *service);

/* Register/Unregister a connection with the socket manager */
extern bool fb_register (int socket, FB_SOCKETTYPE type, void *thing);
extern void fb_unregister (int socket);

/* Accept/Close & release a socket and its resources */
extern FB_CONNECTION *fb_accept_connection (FB_SERVICE *service, int domain);
extern void fb_destroy_connection (FB_CONNECTION *connection);

/* Event handling functions */
extern FB_EVENT *fb_read_input (FB_EVENT *event, FB_CONNECTION *connection);
extern FB_EVENT *fb_new_connect (FB_EVENT *event, FB_SERVICE *service);
extern FB_EVENT *fb_send_output (FB_EVENT *event, FB_CONNECTION *connection);

/* Enabling/disabling events for the socket manager */
extern void fb_set_readable (int socket, bool enable);
extern void fb_set_writable (int socket, bool enable);

/* Command line parsing */
int fb_create_argv (const char *commandline, char ***result);
void fb_destroy_argv (char **argv);

#endif
