<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2021 The s9e authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Bundles;

abstract class Fatdown extends \s9e\TextFormatter\Bundle
{
	/**
	* @var s9e\TextFormatter\Parser Singleton instance used by parse()
	*/
	protected static $parser;

	/**
	* @var s9e\TextFormatter\Renderer Singleton instance used by render()
	*/
	protected static $renderer;

	/**
	* {@inheritdoc}
	*/
	public static function getJS()
	{
		return '(function(){function ba(a){var b=0;return function(){return b<a.length?{done:!1,value:a[b++]}:{done:!0}}}
var ca=[""],da=[0,0,0],fa=["","t"],ha=["","id"],ia={flags:0},na={flags:514},oa=["","type"],pa={flags:3089},qa={flags:3201},ra=["","album_id"],sa=["","track_id"],va=[32896,257,257],wa=[32960,257,256],xa=[65519,65313,257],ya=[65477,65281,257],za=[65408,65288,257],Aa=[39819,65329,257],Ba=[65408,65280,257],Ca=[63463,65313,257],Da=[65519,65329,257],Ea=[65424,65280,257],Fa=["","playlist_id"],Ga=["","channel","clip_id"],Ha={c:[],p:!0},x={c:[],p:!1},Ia={"class":x},A={C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,
"html:code":1,"html:i":1,"html:strong":1,"html:u":1},Ja=[[/(?:open|play)\\.spotify\\.com\\/(?:user\\/[-.\\w]+\\/)?((?:album|artist|episode|playlist|show|track)(?:[:\\/][-.\\w]+)+)/,ha]];function Ka(a,b){var c={},d;for(d in b.b){var l=b.b[d],k=!1;if(d in a.b){k=l.c;var h=d,t=a.b[d];B.y=h;for(var p=0;p<k.length&&(t=k[p](t,h),!1!==t);++p);delete B.y;k=t}!1!==k?c[d]=k:l.p&&C(a)}La(a,c)}
var F=[Ka],Na=[function(a){return Ma(a,/^[-0-9A-Za-z_]+$/)}],Oa={c:[function(a){var b=/^(?=\\d)(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?$/.exec(a);return b?3600*(b[1]||0)+60*(b[2]||0)+(+b[3]||0):/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],p:!1},Va=[function(a){var b=Pa.urlConfig,c=B,d=Qa(a.replace(/^\\s+/,"").replace(/\\s+$/,""));(b=Ra(b,d))?(c&&(d.attrValue=a,c.add("err",b,d)),a=!1):a=Ua(d);return a}],Wa={c:Na,p:!0},Xa={c:[function(a){return Ma(a,/^[- +,.0-9A-Za-z_]+$/)}],p:!1},Ya={c:Va,p:!0},Za={l:A,flags:268,m:A},
$a={l:A,flags:3460,m:A},ab={d:da,b:{},h:0,c:F,f:10,e:{flags:66},g:5E3},bb={l:{C:1,EM:1,EMAIL:1,LI:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:li":1,"html:strong":1,"html:u":1},flags:264,m:A},cb={d:ya,b:{},h:0,c:F,f:10,e:ia,g:5E3},db={d:ya,b:{},h:0,c:F,f:10,e:{flags:2},g:5E3},eb={d:Da,b:{},h:0,c:F,f:10,e:{flags:512},g:5E3},fb={l:{C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:dd":1,"html:dt":1,"html:i":1,"html:strong":1,"html:u":1},flags:256,m:A},gb={l:{C:1,EM:1,EMAIL:1,
STRONG:1,TD:1,TH:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:strong":1,"html:td":1,"html:th":1,"html:u":1},flags:256,m:A},hb={d:wa,b:{id:x},h:2,c:F,f:10,e:pa,g:5E3},mb={d:va,b:{"char":Ha},h:8,c:F,f:10,e:pa,g:5E3},nb={align:{c:[function(a){return a.toLowerCase()},function(a){return Ma(a,/^(?:center|justify|left|right)$/)}],p:!1}},ob={d:ya,b:{},h:3,c:F,f:10,e:{l:A,flags:260,m:A},g:5E3},pb={d:Ea,b:{},h:1,c:F,f:10,e:$a,g:5E3},qb={d:za,b:{},h:9,c:F,f:10,e:{l:A,flags:3456,m:A},g:5E3},rb={d:[65408,
65290,257],b:{},h:1,c:F,f:10,e:$a,g:5E3},sb={d:[65408,65284,257],b:{},h:11,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,STRONG:1,TD:1,TH:1,TR:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:strong":1,"html:td":1,"html:th":1,"html:tr":1,"html:u":1},flags:3456,m:A},g:5E3},tb={d:za,b:{},h:9,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,STRONG:1,TBODY:1,TD:1,TH:1,THEAD:1,TR:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:strong":1,"html:tbody":1,"html:td":1,"html:th":1,"html:thead":1,"html:tr":1,"html:u":1},flags:3456,m:A},
g:5E3},ub=\'<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:html="urn:s9e:TextFormatter:html" exclude-result-prefixes="html"><xsl:output method="html" encoding="utf-8" indent="no"/><xsl:decimal-format decimal-separator="."/><xsl:param$pMEDIAEMBED_THEME"/><xsl:param$pTASKLISTS_EDITABLE"/>$aBANDCAMP"><$w$hbandcamp"$k$g400px"><$w$k$c100%"><$u$j"$q$x$nno"$k$f><$l$psrc">//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/<$t><$v$o@album_id">album=$d@album_id"/><$s$o@track_num">/t=$d@track_num"/></$s></$v><$r>track=$d@track_id"/></$r></$t><$s$o$MEDIAEMBED_THEME=\\\'dark\\\'">/bgcol=333333/linkcol=0f91ff</$s></$l></$u></$w></$w>$b$aC"><code>$e</code>$b$aCODE"><pre><code><$s$o@lang"><$l$pclass">language-$d@lang"/></$l></$s>$e</code></pre>$b$aDAILYMOTION"><$w$hdailymotion"$k$g640px"><$w$k$c56.25%"><$u$j"$q$x$nno"$k$f><$l$psrc">//www.dailymotion.com/embed/video/$d@id"/><$s$o@t">?start=$d@t"/></$s></$l></$u></$w></$w>$b$aDEL|EM|H1|H2|H3|H4|H5|H6|STRONG|SUB|SUP|TABLE|TBODY|THEAD|TR|html:b|html:br|html:code|html:dd|html:del|html:dl|html:dt|html:i|html:ins|html:li|html:ol|html:pre|html:rb|html:rp|html:rt|html:rtc|html:ruby|html:strong|html:sub|html:sup|html:table|html:tbody|html:tfoot|html:thead|html:tr|html:u|html:ul|p"><xsl:element$p{translate(local-name(),\\\'ABDEGHLMNOPRSTUY\\\',\\\'abdeghlmnoprstuy\\\')}">$e</xsl:element>$b$aEMAIL"><a href="mailto:{@email}">$e</a>$b$aESC">$e$b$aFACEBOOK"><$u$hfacebook"$j"$mstyle"$q$x onload="var c=new MessageChannel;c.port1.onmessage=function(e){{style.height=e.data+\\\'px\\\'}};contentWindow.postMessage(\\\'s9e:init\\\',\\\'https://s9e.github.io\\\',[c.port2])"$nno"$yhttps://s9e.github.io/$u/2/facebook.min.html#{@type}{@id}"$kborder:0;height:360px;max-width:640px;width:100%"/>$b$aFP|HE">$d@char"/>$b$aHC"><xsl:comment>$d@content"/></xsl:comment>$b$aHR"><hr/>$b$aIMG"><img$y{@src}">$ialt|@title"/></img>$b$aISPOILER"><$w class="spoiler"$mstyle" onclick="removeAttribute(\\\'style\\\')"$kbackground:#444;color:transparent">$e</$w>$b$aLI"><li><$s$oTASK"><$l$pdata-s9e-livepreview-ignore-attrs">data-task-id</$l><$l$pdata-task-id">$dTASK/@id"/></$l><$l$pdata-task-state">$dTASK/@state"/></$l></$s>$e</li>$b$aLIST"><$t><$v$onot(@type)"><ul>$e</ul></$v><$r><ol>$istart"/>$e</ol></$r></$t>$b$aLIVELEAK"><$w$hliveleak"$k$g640px"><$w$k$c56.25%"><$u$j"$q$x$nno"$y//www.liveleak.com/e/{@id}"$k$f/></$w></$w>$b$aQUOTE"><blockquote>$e</blockquote>$b$aSOUNDCLOUD"><$u$hsoundcloud"$j"$q$x$nno"><$l$psrc">https://w.soundcloud.com/player/?url=<$t><$v$o$z">https%3A//api.soundcloud.com/playlists/$d$z"/></$v><$v$o@track_id">https%3A//api.soundcloud.com/tracks/$d@track_id"/>&amp;secret_token=$d@secret_token"/></$v><$r><$s$onot(contains(@id,\\\'://\\\'))">https%3A//soundcloud.com/</$s>$d@id"/></$r></$t></$l><$l$pstyle">border:0;height:<$t><$v$o$z or contains(@id,\\\'/sets/\\\')">450</$v><$r>166</$r></$t>px;max-width:900px;width:100%</$l></$u>$b$aSPOILER"><details class="spoiler"$mopen">$e</details>$b$aSPOTIFY"><$t><$v$ostarts-with(@id,\\\'episode/\\\')or starts-with(@id,\\\'show/\\\')"><$u$hspotify" allow="encrypted-media"$j"$q$x$nno"$yhttps://open.spotify.com/embed/{@id}"$kborder:0;height:152px;max-width:900px;width:100%"/></$v><$r><$w$hspotify"$k$g320px"><$w$k$c125%;padding-bottom:calc(100% + 80px)"><$u allow="encrypted-media"$j"$q$x$nno"$yhttps://open.spotify.com/embed/{translate(@id,\\\':\\\',\\\'/\\\')}{@path}"$k$f/></$w></$w></$r></$t>$b$aTASK"><input data-task-id="{@id}"$mdata-task-id" type="checkbox"><$s$o@state=\\\'checked\\\'"><$l$pchecked"/></$s><$s$onot($TASKLISTS_EDITABLE)"><$l$pdisabled"/></$s></input>$b$aTD"><td><$s$o@align"><$l$pstyle">text-align:$d@align"/></$l></$s>$e</td>$b$aTH"><th><$s$o@align"><$l$pstyle">text-align:$d@align"/></$l></$s>$e</th>$b$aTWITCH"><$w$htwitch"$k$g640px"><$w$k$c56.25%"><$u$j"$q$x onload="contentWindow.postMessage(\\\'\\\',\\\'https://s9e.github.io\\\')"$nno"$yhttps://s9e.github.io/$u/2/twitch.min.html#channel={@channel};clip_id={@clip_id};t={@t};video_id={@video_id}"$k$f/></$w></$w>$b$aURL"><a href="{@url}">$ititle"/>$e</a>$b$aVIMEO"><$w$hvimeo"$k$g640px"><$w$k$c56.25%"><$u$j"$q$x$nno"$k$f><$l$psrc">//player.vimeo.com/video/$d@id"/><$s$o@t">#t=$d@t"/></$s></$l></$u></$w></$w>$b$aVINE"><$w$hvine"$k$g480px"><$w$k$c100%"><$u$j"$q$x$nno"$yhttps://vine.co/v/{@id}/embed/simple?audio=1"$k$f/></$w></$w>$b$aYOUTUBE"><$w$hyoutube"$k$g640px"><$w$k$c56.25%"><$u$j"$q$x$nno"$kbackground:url(https://i.ytimg.com/vi/{@id}/hqdefault.jpg) 50% 50% / cover;$f><$l$psrc">https://www.youtube.com/embed/$d@id"/><$s$o@list">?list=$d@list"/></$s><$s$o@t"><$t><$v$o@list">&amp;</$v><$r>?</$r></$t>start=$d@t"/></$s></$l></$u></$w></$w>$b$abr"><br/>$b$ae|i|s"/>$ahtml:abbr"><abbr>$ititle"/>$e</abbr>$b$ahtml:div"><div>$iclass"/>$e</div>$b$ahtml:img"><img>$ialt|@height|@src|@title|@width"/>$e</img>$b$ahtml:$w"><$w>$iclass"/>$e</$w>$b$ahtml:td"><td>$icol$w|@row$w"/>$e</td>$b$ahtml:th"><th>$icol$w|@row$w|@scope"/>$e</th>$b</xsl:stylesheet>\'.replace(/\\$[a-z]/g,
function(a){return{$a:\'<xsl:template match="\',$b:"</xsl:template>",$c:"display:block;overflow:hidden;position:relative;padding-bottom:",$d:\'<xsl:value-of select="\',$e:"<xsl:apply-templates/>",$f:\'border:0;height:100%;left:0;position:absolute;width:100%"\',$g:"display:inline-block;width:100%;max-width:",$h:\' data-s9e-mediaembed="\',$i:\'<xsl:copy-of select="@\',$j:\' allowfullscreen="\',$k:\' style="\',$l:"xsl:attribute",$m:\' data-s9e-livepreview-ignore-attrs="\',$n:\' scrolling="\',$o:\' test="\',$p:\' name="\',
$q:\' loading="\',$r:"xsl:otherwise",$s:"xsl:if",$t:"xsl:choose",$u:"iframe",$v:"xsl:when",$w:"span",$x:\'lazy"\',$y:\' src="\',$z:"@playlist_id"}[a]});function Ma(a,b){return b.test(a)?a:!1}
function Qa(a){var b=/^(?:([a-z][-+.\\w]*):)?(?:\\/\\/(?:([^:\\/?#]*)(?::([^\\/?#]*)?)?@)?(?:(\\[[a-f\\d:]+\\]|[^:\\/?#]+)(?::(\\d*))?)?(?![^\\/?#]))?([^?#]*)(\\?[^#]*)?(#.*)?$/i.exec(a),c={};"scheme user pass host port path query fragment".split(" ").forEach(function(d,l){c[d]=""<b[l+1]?b[l+1]:""});c.scheme=c.scheme.toLowerCase();c.host=c.host.replace(/[\\u3002\\uff0e\\uff61]/g,".").replace(/\\.+$/g,"");/[^\\x00-\\x7F]/.test(c.host)&&"undefined"!==typeof punycode&&(c.host=punycode.toASCII(c.host));return c}
function Ua(a){var b="";""!==a.scheme&&(b+=a.scheme+":");""!==a.host?(b+="//",""!==a.user&&(b+=vb(decodeURIComponent(a.user)),""!==a.pass&&(b+=":"+vb(decodeURIComponent(a.pass))),b+="@"),b+=a.host,""!==a.port&&(b+=":"+a.port)):"file"===a.scheme&&(b+="//");var c=a.path+a.query+a.fragment;c=c.replace(/%.?[a-f]/g,function(d){return d.toUpperCase()},c);b+=c.replace(/[^\\u0020-\\u007E]+/g,encodeURIComponent).replace(/%(?![0-9A-Fa-f]{2})|[^!#-&*-;=?-Z_a-z~]/g,escape);a.scheme||(b=b.replace(/^([^\\/]*):/,"$1%3A"));
return b}
function Ra(a,b){if(""!==b.scheme&&!a.R.test(b.scheme))return"URL scheme is not allowed";if(""!==b.host){var c;if(c=!/^(?!-)[-a-z0-9]{0,62}[a-z0-9](?:\\.(?!-)[-a-z0-9]{0,62}[a-z0-9])*$/i.test(b.host)){a:if(c=b.host,/^\\d+\\.\\d+\\.\\d+\\.\\d+$/.test(c))for(var d=4,l=c.split(".");0<=--d;){if("0"===l[d][0]||255<l[d]){c=!1;break a}}else c=!1;if(c=!c)c=b.host.replace(/^\\[(.*)\\]$/,"$1",b.host),c=!(/^([\\da-f]{0,4}:){2,7}(?:[\\da-f]{0,4}|\\d+\\.\\d+\\.\\d+\\.\\d+)$/.test(c)&&c)}if(c)return"URL host is invalid";if(a.T&&
a.T.test(b.host)||a.W&&!a.W.test(b.host))return"URL host is not allowed"}else if(/^(?:(?:f|ht)tps?)$/.test(b.scheme))return"Missing host"}function wb(a){var b=document.createElement("b");wb=function(c){b.innerHTML=c.replace(/</g,"&lt;");return b.textContent};return wb(a)}function xb(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;",\'"\':"&quot;"};return a.replace(/[<>&"]/g,function(c){return b[c]})}
function yb(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;"};return a.replace(/[<>&]/g,function(c){return b[c]})}function vb(a){return encodeURIComponent(a).replace(/[!\'()*]/g,function(b){return"%"+b.charCodeAt(0).toString(16).toUpperCase()})}function zb(){this.o={};this.q=[]}zb.prototype.add=function(a,b,c){c=c||{};"attrName"in c||!this.y||(c.attrName=this.y);"tag"in c||!this.k||(c.tag=this.k);this.o[a]&&this.o[a].forEach(function(d){d(b,c)});this.q.push([a,b,c])};zb.prototype.getLogs=function(){return this.q};
zb.prototype.on=function(a,b){this.o[a].push(b)};function Ab(a,b){B.add("debug",a,b)}function Bb(a,b,c,d,l){this.k=+a;this.name=b;this.i=+c;this.j=+d;this.q=+l||0;this.b={};this.N=[];isNaN(a+c+d)&&C(this)}Bb.prototype.o=!1;function Cb(a,b){a.N.push(b);a.o&&C(b)}function C(a){a.o||(a.o=!0,a.N.forEach(function(b){C(b)}))}function Db(a,b){Eb(a,b)?(a.z=b,b.F=a,Cb(a,b)):Eb(b,a)&&(a.F=b,b.z=a)}function Eb(a,b){return a.name===b.name&&1===a.k&&2===b.k&&a.i<=a.i}
function Fb(a){var b={},c;for(c in a.b)b[c]=a.b[c];return b}function Gb(a,b){return a.o||!Eb(b,a)||a.F&&a.F!==b||b.z&&b.z!==a?!1:!0}function La(a,b){a.b={};for(var c in b)a.b[c]=b[c]}
var Hb,Ib,G,Jb,I,Kb,B=new zb,Lb,J,K,Ob={Autoemail:{r:function(a,b){b.forEach(function(c){var d=L(1,"EMAIL",c[0][1],0,0);d.b.email=c[0][0];c=Mb("EMAIL",c[0][1]+c[0][0].length,0);Db(d,c)})},u:"@",v:/\\b[-a-z0-9_+.]+@[-a-z0-9.]*[a-z0-9]/ig,w:5E4},Autolink:{r:function(a,b){b.forEach(function(c){var d=c[0][1],l=c[0][0].replace(/(?:(?![-=)\\/_])[\\s!-.:-@[-`{-~])+$/,""),k=d+l.length,h=Mb("URL",k,0);"."===l[3]&&(l="http://"+l);c=L(1,"URL",d,0,1);c.b.url=l;Db(c,h);d=L(3,"v",d,k-d,1E3);Cb(c,d)})},u:":",v:/\\b(?:ftp|https?|mailto):(?:[^\\s()\\[\\]\\uFF01-\\uFF0F\\uFF1A-\\uFF20\\uFF3B-\\uFF40\\uFF5B-\\uFF65]|\\([^\\s()]*\\)|\\[\\w*\\])+/ig,
w:5E4},Escaper:{r:function(a,b){b.forEach(function(c){M("ESC",c[0][1],1,c[0][1]+c[0][0].length,0)})},u:"\\\\",v:/\\\\[-!#()*+.:<>@[\\\\\\]^_`{|}~]/g,w:5E4},FancyPants:{r:function(a){function b(g,n,m,w){g=L(3,r,g,n,w||0);g.b[e]=m;return g}function c(){if(!(0>a.indexOf("...")&&0>a.indexOf("--")))for(var g={"--":"\\u2013","---":"\\u2014","...":"\\u2026"},n=/---?|\\.\\.\\./g,m;m=n.exec(a);)b(m.index,m[0].length,g[m[0]])}function d(){if(!(0>a.indexOf("/")))for(var g={"0/3":"\\u2189","1/10":"\\u2152","1/2":"\\u00bd","1/3":"\\u2153",
"1/4":"\\u00bc","1/5":"\\u2155","1/6":"\\u2159","1/7":"\\u2150","1/8":"\\u215b","1/9":"\\u2151","2/3":"\\u2154","2/5":"\\u2156","3/4":"\\u00be","3/5":"\\u2157","3/8":"\\u215c","4/5":"\\u2158","5/6":"\\u215a","5/8":"\\u215d","7/8":"\\u215e"},n,m=/\\b(?:0\\/3|1\\/(?:[2-9]|10)|2\\/[35]|3\\/[458]|4\\/5|5\\/[68]|7\\/8)\\b/g;n=m.exec(a);)b(n.index,n[0].length,g[n[0]])}function l(){if(!(0>a.indexOf("<<")))for(var g,n=/<<( ?)(?! )[^\\n<>]*?[^\\n <>]\\1>>(?!>)/g;g=n.exec(a);){var m=b(g.index,2,"\\u00ab");g=b(g.index+g[0].length-2,2,
"\\u00bb");Cb(m,g)}}function k(){if(!(0>a.indexOf("!=")&&0>a.indexOf("=/=")))for(var g,n=/\\b (?:!|=\\/)=(?= \\b)/g;g=n.exec(a);)b(g.index+1,g[0].length-1,"\\u2260")}function h(g,n,m,w){for(var y;y=n.exec(a);){var D=b(y.index+y[0].indexOf(g),1,m);y=b(y.index+y[0].length-1,1,w);Cb(D,y)}}function t(){if(f)for(var g,n=/[a-z]\'|(?:^|\\s)\'(?=[a-z]|[0-9]{2})/gi;g=n.exec(a);)b(g.index+g[0].indexOf("\'"),1,"\\u2019",10)}function p(){if(f||q||!(0>a.indexOf("x")))for(var g={"\'s":"\\u2019","\'":"\\u2032","\' ":"\\u2032",
"\'x":"\\u2032",\'"\':"\\u2033",\'" \':"\\u2033",\'"x\':"\\u2033"},n,m=/[0-9](?:\'s|["\']? ?x(?= ?[0-9])|["\'])/g;n=m.exec(a);){"x"===n[0][n[0].length-1]&&b(n.index+n[0].length-1,1,"\\u00d7");var w=n[0].substr(1,2);g[w]&&b(n.index+1,1,g[w])}}function u(){if(!(0>a.indexOf("(")))for(var g={"(c)":"\\u00a9","(r)":"\\u00ae","(tm)":"\\u2122"},n=/\\((?:c|r|tm)\\)/gi,m;m=n.exec(a);)b(m.index,m[0].length,g[m[0].toLowerCase()])}var v={y:"char",J:"FP"},e=v.y,f=0<=a.indexOf("\'"),q=0<=a.indexOf(\'"\'),r=v.J;"undefined"===typeof v.aa&&
(t(),f&&h("\'",/(?:^|\\W)\'.+?\'(?!\\w)/g,"\\u2018","\\u2019"),q&&h(\'"\',/(?:^|\\W)".+?"(?!\\w)/g,"\\u201c","\\u201d"));"undefined"===typeof v.Y&&l();"undefined"===typeof v.Z&&(k(),p(),d());"undefined"===typeof v.$&&c();"undefined"===typeof v.ba&&u()}},HTMLComments:{r:function(a,b){b.forEach(function(c){var d=wb(c[0][0].substr(4,c[0][0].length-7));d=d.replace(/[<>]/g,"");d=d.replace(/-+$/,"");d=d.replace(/--/g,"");L(3,"HC",c[0][1],c[0][0].length,0).b.content=d})},u:"\\x3c!--",v:/\\x3c!--(?!\\[if)[\\s\\S]*?--\\x3e/ig,
w:5E4},HTMLElements:{r:function(a,b){var c={a:{"":"URL",href:"url"},em:{"":"EM"},hr:{"":"HR"},s:{"":"S"},strong:{"":"STRONG"},sup:{"":"SUP"}};b.forEach(function(d){var l="/"===a[d[0][1]+1],k=d[0][1],h=d[0][0].length,t=d[2-l][0].toLowerCase(),p=c&&c[t]&&c[t][""]?c[t][""]:"html:"+t;if(l)Mb(p,k,h);else for(l=/(<\\S+|[\'"\\s])\\/>$/.test(d[0][0])?M(p,k,h,k+h,0):L(1,p,k,h,0),d=d[3][0],k=/([a-z][-a-z0-9]*)(?:\\s*=\\s*("[^"]*"|\'[^\']*\'|[^\\s"\'=<>`]+))?/gi;p=k.exec(d);)h=p[1].toLowerCase(),p="undefined"!==typeof p[2]?
p[2]:h,c&&c[t]&&c[t][h]&&(h=c[t][h]),/^["\']/.test(p)&&(p=p.substr(1,p.length-2)),p=wb(p),l.b[h]=p})},u:"<",v:/<(?:\\/((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))|((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))((?:\\s+[a-z][-a-z0-9]*(?:\\s*=\\s*(?:"[^"]*"|\'[^\']*\'|[^\\s"\'=<>`]+))?)*)\\s*\\/?)\\s*>/ig,w:5E4},
HTMLEntities:{r:function(a,b){b.forEach(function(c){var d=c[0][0],l=wb(d);l===d||32>l.charCodeAt(0)||(L(3,"HE",c[0][1],d.length,0).b["char"]=l)})},u:"&",v:/&(?:[a-z]+|#(?:[0-9]+|x[0-9a-f]+));/ig,w:5E4},Litedown:{r:function(a){function b(e){-1<e.indexOf("&")&&(e=wb(e));e=e.replace(/\\x1A/g,"");p&&(e=e.replace(/\\x1B./g,function(f){return{"\\u001b0":"!","\\u001b1":\'"\',"\\u001b2":"\'","\\u001b3":"(","\\u001b4":")","\\u001b5":"*","\\u001b6":"<","\\u001b7":">","\\u001b8":"[","\\u001b9":"\\\\","\\u001bA":"]","\\u001bB":"^",
"\\u001bC":"_","\\u001bD":"`","\\u001bE":"~"}[f]}));return e}function c(e){return 0<" abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".indexOf(e)}function d(e){a=a.substr(0,e)+"\\u0017"+a.substr(e+1)}function l(e,f){0<f&&(a=a.substr(0,e)+Array(1+f).join("\\u001a")+a.substr(e+f))}function k(e,f,q){if(-1!==a.indexOf(e))for(var r;r=f.exec(a);)e=r.index,r=e+r[0].length-2,M(q,e,2,r,2),l(e,2),l(r,2)}function h(e,f,q,r){function g(m){m=a.indexOf(f+"(",m);if(-1!==m){var w;for(r.lastIndex=m;w=r.exec(a);){var y=
w[0];w=w.index;var D=y.length;M(e,w,2,w+D-1,1);l(w,D)}y&&g(m)}}var n=a.indexOf(f);-1!==n&&(function(m){var w;for(q.lastIndex=m;w=q.exec(a);){m=w[0];w=w.index;var y=m.substr(-1)===f?1:0;M(e,w,1,w+m.length-y,y)}}(n),g(n))}function t(e,f,q){var r=f.replace(/^\\s*/,"").replace(/\\s*$/,"");f="";var g=r.indexOf(" ");-1!==g&&(f=r.substr(g).replace(/^\\s*\\S/,"").replace(/\\S\\s*$/,""),r=r.substr(0,g));/^<.+>$/.test(r)&&(r=r.replace(/^<(.+)>$/,"$1").replace(/\\\\>/g,">"));r=b(r);e.b[q]=r;""<f&&(q=b(f),e.b.title=
q)}var p=!1,u=!1,v={};0<=a.indexOf("\\\\")&&(p=!0,a=a.replace(/\\\\[!"\'()*<>[\\\\\\]^_`~]/g,function(e){return{"\\\\!":"\\u001b0",\'\\\\"\':"\\u001b1","\\\\\'":"\\u001b2","\\\\(":"\\u001b3","\\\\)":"\\u001b4","\\\\*":"\\u001b5","\\\\<":"\\u001b6","\\\\>":"\\u001b7","\\\\[":"\\u001b8","\\\\\\\\":"\\u001b9","\\\\]":"\\u001bA","\\\\^":"\\u001bB","\\\\_":"\\u001bC","\\\\`":"\\u001bD","\\\\~":"\\u001bE"}[e]}));a+="\\n\\n\\u0017";(function(){function e(m,w){Db(Mb("LIST",w,0),m.U);Db(Mb("LI",w,0),m.H);m.P&&m.I.forEach(function(y){y.flags&=-9})}function f(m,w){for(var y=
m;0<=--w;)y=y.replace(/^ *>!? ?/,"");return m.length-y.length}function q(m,w){return/[ \\t]*#*[ \\t]*$/.exec(a.substr(m,w-m))[0].length}function r(m){for(var w=[],y=/>!?/g,D;D=y.exec(m);)w.push(D[0]);return w}function g(){if(-1!==a.indexOf("-")||-1!==a.indexOf("="))for(var m,w=/^(?=[-=>])(?:>!? ?)*(?=[-=])(?:-+|=+) *$/gm;m=w.exec(a);){var y=m[0];m=m.index;for(var D=m-1;0<D&&" "===a[D-1];)--D;n[m-1]={L:m+y.length-D,M:D,S:y.length-y.replace(/>/g,"").length,J:"="===y[0]?"H1":"H2"}}}var n={};(function(){g();
for(var m=[],w=0,y,D=4,z,H=!0,Q=[],N=0,ea=!1,S=0,ma,ja,Z,ib,Yb,U,P,jb,Sa,ka,la,ta,Zb=[],kb,Ta=/^(?:(?=[-*+\\d \\t>`~#_])((?: {0,3}>(?:(?!!)|!(?![^\\n>]*?!<)) ?)+)?([ \\t]+)?(\\* *\\* *\\*[* ]*$|- *- *-[- ]*$|_ *_ *_[_ ]*$)?((?:[-*+]|\\d+\\.)[ \\t]+(?=\\S))?[ \\t]*(#{1,6}[ \\t]+|```+[^`\\n]*$|~~~+[^~\\n]*$)?)?/gm;kb=Ta.exec(a);)Zb.push(kb),kb.index===Ta.lastIndex&&++Ta.lastIndex;Zb.forEach(function(E){var aa=[],V=E.index,ua=E[0].length,R;ka=Z=0;ja=!H;U=a.indexOf("\\n",V);H=U===V+ua&&!E[3]&&!E[4]&&!E[5];ua||++Ta.lastIndex;
ma=H&&ja;E[1]&&(aa=r(E[1]),ka=aa.length,Z=E[1].length,z&&"blockDepth"in z.b&&(ka=Math.min(ka,z.b.blockDepth),Z=f(E[1],ka)),l(V,Z));if(ka<w&&!ja){ea=!0;do{var W=m.pop();Db(Mb(W.name,S,0),W)}while(ka<--w)}if(ka>w&&!H){ea=!0;do m.push(L(1,">!"===aa[w]?"SPOILER":"QUOTE",V,0,-999));while(ka>++w)}W=R=0;if(E[2]&&!y){ib=E[2];Yb=ib.length;do" "===ib[W]?++R:R=R+4&-4;while(++W<Yb&&R<D)}z&&!y&&R<D&&!H&&(ea=!0);ea&&(ea=!1,z&&(S>z.i?(l(z.i,S-z.i),Db(z,Mb("CODE",S,0,-1))):C(z),y=z=null),Q.forEach(function(lb){e(lb,
S)}),Q=[],N=0,V&&d(V-1));if(R>=D){if(z||!ja)Z=(E[1]||"").length+W,z||(z=L(1,"CODE",V+Z,0,-999)),E={}}else if(!z){aa=!!E[4];if(R||ja||aa)if(ja&&!aa)P=N-1;else if(N)for(P=0;P<N&&R>Q[P].O;)++P;else P=aa?0:-1;else P=-1;for(;P<N-1;)e(Q.pop(),S),--N;P!==N||aa||--P;if(aa&&0<=P)if(ma=!0,la=V+Z+W,ta=E[4].length,W=L(1,"LI",la,ta,0),l(la,ta),P<N)Db(Mb("LI",S,0),Q[P].H),Q[P].H=W,Q[P].I.push(W);else{++N;P?(Sa=Q[P-1].O+1,jb=Math.max(Sa,4*P)):(Sa=0,jb=R);R=L(1,"LIST",la,0,0);if(-1<E[4].indexOf(".")){R.b.type="decimal";
var $b=+E[4];1!==$b&&(R.b.start=$b)}Q.push({U:R,H:W,I:[W],ca:Sa,O:jb,P:!0})}!N||ja||H||(1<Q[0].I.length||!aa)&&Q.forEach(function(lb){lb.P=!1});D=4*(N+1)}if(E[5])if("#"===E[5][0])W=E[5].length,aa=V+ua-W,R=q(V+ua,U),ua=U-R,M("H"+/#{1,6}/.exec(E[5])[0].length,aa,W,ua,R),d(aa),d(U),ja&&(ma=!0);else{if("`"===E[5][0]||"~"===E[5][0])la=V+Z,ta=U-la,z&&E[5]===y?(Db(z,Mb("CODE",la,ta,-1)),Nb(S,la-S),l(z.i,la+ta-z.i),y=z=null):z||(z=L(1,"CODE",la,ta,0),y=E[5].replace(/[^`~]+/,""),z.b.blockDepth=ka,Nb(la+ta,
1),E=E[5].replace(/^[`~\\s]*/,"").replace(/\\s+$/,""),""!==E&&(z.b.lang=E))}else E[3]&&!N&&"\\u0017"!==a[V+ua]?(L(3,"HR",V+Z,ua-Z,0),ma=!0,d(U)):!n[U]||n[U].S!==ka||H||N||z||(M(n[U].J,V+Z,0,n[U].M,n[U].L),d(n[U].M+n[U].L));ma&&(L(3,"pb",S,0,0),d(S));H||(S=U);Z&&Nb(V,Z,1E3)})})()})();(function(){if(!(0>a.indexOf("]:")))for(var e,f=/^\\x1A* {0,3}\\[([^\\x17\\]]+)\\]: *([^[\\s\\x17]+ *(?:"[^\\x17]*?"|\'[^\\x17]*?\'|\\([^\\x17)]*\\))?) *(?=$|\\x17)\\n?/gm;e=f.exec(a);){Nb(e.index,e[0].length);var q=e[1].toLowerCase();v[q]||
(u=!0,v[q]=e[2])}})();(function(){var e=a.indexOf("`");if(0>e)var f=[];else{f=/(`+)(\\s*)[^\\x17`]*/g;var q=0,r=[],g=a.replace(/\\x1BD/g,"\\\\`");for(f.lastIndex=e;e=f.exec(g);)r.push({i:e.index,j:e[1].length,Q:q,X:e[2].length,next:e.index+e[0].length}),q=e[0].length-e[0].replace(/\\s+$/,"").length;f=r}g=-1;for(q=f.length;++g<q-1;)for(e=f[g].next,r=g,"`"!==a[f[g].i]&&(++f[g].i,--f[g].j);++r<q&&f[r].i===e;){if(f[r].j===f[g].j){g=f[g];var n=f[r];e=g.i;var m=n.i-n.Q;n=n.j+n.Q;M("C",e,g.j+g.X,m,n);l(e,m+n-
e);g=r;break}e=f[r].next}})();(function(){function e(f,q,r,g,n){var m=M("IMG",f,2,q,r);t(m,g,"src");g=b(n);m.b.alt=g;l(f,q+r-f)}(function(){var f=a.indexOf("![");if(-1!==f){if(0<a.indexOf("](",f))for(var q=/!\\[(?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*\\]\\(( *(?:[^\\x17\\s()]|\\([^\\x17\\s()]*\\))*(?=[ )]) *(?:"[^\\x17]*?"|\'[^\\x17]*?\'|\\([^\\x17)]*\\))? *)\\)/g;f=q.exec(a);){var r=f[1],g=f.index,n=3+r.length;e(g,g+f[0].length-n,n,r,f[0].substr(2,f[0].length-n-2))}if(u)for(q=/!\\[((?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*)\\](?: ?\\[([^\\x17[\\]]+)\\])?/g;f=
q.exec(a);){r=f.index;g=r+2+f[1].length;n=1;var m=f[1],w=m;if(""<f[2]&&v[f[2]])n=f[0].length-m.length-2,w=f[2];else if(!v[w])continue;e(r,g,n,v[w],m)}}})()})();k(">!",/>![^\\x17]+?!</g,"ISPOILER");k("||",/\\|\\|[^\\x17]+?\\|\\|/g,"ISPOILER");(function(){function e(g,n,m,w){var y=M("URL",g,1,n,m,1===m?1:-1);t(y,w,"url");l(g,1);l(n,m)}function f(){for(var g,n=/<[-+.\\w]+([:@])[^\\x17\\s>]+?(?:>|\\x1B7)/g;g=n.exec(a);){var m=b(g[0].replace(/\\x1B/g,"\\\\\\u001b")).replace(/^<(.+)>$/,"$1"),w=g.index,y=":"===g[1]?"URL":
"EMAIL",D=y.toLowerCase();M(y,w,1,w+g[0].length-1,1).b[D]=m}}function q(){for(var g,n=/\\[(?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*\\]\\(( *(?:\\([^\\x17\\s()]*\\)|[^\\x17\\s)])*(?=[ )]) *(?:"[^\\x17]*?"|\'[^\\x17]*?\'|\\([^\\x17)]*\\))? *)\\)/g;g=n.exec(a);){var m=g[1],w=g.index,y=3+m.length;e(w,w+g[0].length-y,y,m)}}function r(){for(var g={},n,m=/\\[((?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*)\\]/g;n=m.exec(a);)g[n.index]=n[1].toLowerCase();for(var w in g){n=g[w];m=+w+2+n.length;var y=m-1,D=1;" "===a[m]&&++m;""<g[m]&&v[g[m]]&&(n=g[m],
D=m+2+n.length-y);v[n]&&e(+w,y,D,v[n])}}-1!==a.indexOf("](")&&q();-1!==a.indexOf("<")&&f();u&&r()})();k("~~",/~~[^\\x17]+?~~(?!~)/g,"DEL");h("SUB","~",/~[^\\x17\\s!"#$%&\'()*+,\\-.\\/:;<=>?@[\\]^_`{}|~]+~?/g,/~\\([^\\x17()]+\\)/g);h("SUP","^",/\\^[^\\x17\\s!"#$%&\'()*+,\\-.\\/:;<=>?@[\\]^_`{}|~]+\\^?/g,/\\^\\([^\\x17()]+\\)/g);(function(){function e(D,z){var H=a.indexOf(D);if(-1!==H){D=[];var Q=[],N=a.indexOf("\\u0017",H),ea;for(z.lastIndex=H;ea=z.exec(a);){H=ea.index;ea=ea[0].length;H>N&&(Q.push(D),D=[],N=a.indexOf("\\u0017",
H));var S,ma=H,ja=ea;if(S="_"===a.charAt(ma)&&1===ja)S=0<ma&&c(a[ma-1])&&c(a[ma+ja]);S||D.push([H,ea])}Q.push(D);Q.forEach(f)}}function f(D){w=g=-1;D.forEach(function(z){var H=z[0];z=z[1];var Q=!(-1<" \\n\\t".indexOf(a[H+z-1+1])),N=0<H&&-1<" \\n\\t".indexOf(a.charAt(H-1))?0:Math.min(z,3);q=!!(N&1)&&0<=g;r=!!(N&2)&&0<=w;y=n=H;m=z;0<=g&&g===w&&(q?g+=2:++w);q&&r&&(g<w?n+=2:++y);q&&(--m,M("EM",g,1,n,1),g=-1);r&&(m-=2,M("STRONG",w,2,y,2),w=-1);m=Q?Math.min(m,3):0;H+=z;m&1&&(g=H-m);m&2&&(w=H-m)})}var q,r,g,
n,m,w,y;e("*",/\\*+/g);e("_",/_+/g)})();(function(){for(var e=a.indexOf("  \\n");0<e;)Cb(L(3,"br",e+2,0,0),L(3,"v",e+2,1,0)),e=a.indexOf("  \\n",e+3)})()}},MediaEmbed:{r:function(a,b){b.forEach(function(c){var d=c[0][0];L(3,"MEDIA",c[0][1],d.length,-10).b.url=d})},u:"://",v:/\\bhttps?:\\/\\/[^["\'\\s]+/ig,w:5E4},PipeTables:{r:function(a){function b(v,e){k=e.i;e.D.split("|").forEach(function(f,q){0<q&&(Cb(t,Nb(k,1,1E3)),++k);q=h.K[q]?h.K[q]:"";var r=k,g=r+f.length;k=g;var n=/^( *).*?( *)$/.exec(f);n[1]&&(f=
n[1].length,Cb(t,Nb(r,f,1E3)),r+=f);n[2]&&(f=n[2].length,Cb(t,Nb(g-f,f,1E3)),g-=f);g=r===g?L(3,v,r,0,-101):M(v,r,0,g,0,-101);q&&(g.b.align=q)});M("TR",e.i,0,k,0,-102)}function c(){if(h&&2<h.n.length&&/^ *:?-+:?(?:(?:\\+| *\\| *):?-+:?)+ */.test(h.n[1].D)){for(var v=h,e=h.n[1].D,f=["","right","left","center"],q=[],r=/(:?)-+(:?)/g,g;g=r.exec(e);)q.push(f[(g[1]?2:0)+(g[2]?1:0)]);v.K=q;p.push(h)}h=null}function d(v){return v.replace(/[!>]/g," ")}function l(v){return v.replace(/\\|/g,".")}var k,h=null,t,
p,u=a;-1<u.indexOf("`")&&(u=u.replace(/`[^`]*`/g,l));-1<u.indexOf(">")&&(u=u.replace(/^(?:>!? ?)+/gm,d));-1<u.indexOf("\\\\|")&&(u=u.replace(/\\\\[\\\\|]/g,".."));(function(){h=null;p=[];k=0;u.split("\\n").forEach(function(v){if(0>v.indexOf("|"))c();else{var e=v,f=0;h||(h={n:[]},f=/^ */.exec(e)[0].length,e=e.substr(f));e=e.replace(/^( *)\\|/,"$1 ").replace(/\\|( *)$/," $1");h.n.push({D:e,i:k+f})}k+=1+v.length});c()})();(function(){for(var v=-1,e=p.length;++v<e;){h=p[v];var f=h.n[h.n.length-1];t=M("TABLE",
h.n[0].i,0,f.i+f.D.length,0,-104);b("TH",h.n[0]);M("THEAD",h.n[0].i,0,k,0,-103);f=h.n[1];Cb(t,Nb(f.i-1,1+f.D.length,1E3));f=1;for(var q=h.n.length;++f<q;)b("TD",h.n[f]);M("TBODY",h.n[2].i,0,k,0,-103)}})()},u:"|"}},O,Pa={"MediaEmbed.hosts":{"bandcamp.com":"bandcamp","dai.ly":"dailymotion","dailymotion.com":"dailymotion","facebook.com":"facebook","fb.watch":"facebook","link.tospotify.com":"spotify","liveleak.com":"liveleak","open.spotify.com":"spotify","play.spotify.com":"spotify","soundcloud.com":"soundcloud",
"twitch.tv":"twitch","vimeo.com":"vimeo","vine.co":"vine","youtu.be":"youtube","youtube.com":"youtube"},"MediaEmbed.sites":{bandcamp:[[],[{x:[[/\\/album=(\\d+)/,ra]],match:[[/bandcamp\\.com\\/album\\/./,ca]]},{x:[[/"album_id":(\\d+)/,ra],[/"track_num":(\\d+)/,["","track_num"]],[/\\/track=(\\d+)/,sa]],match:[[/bandcamp\\.com\\/track\\/./,ca]]}]],dailymotion:[[[/dai\\.ly\\/([a-z0-9]+)/i,ha],[/dailymotion\\.com\\/(?:live\\/|swf\\/|user\\/[^#]+#video=|(?:related\\/\\d+\\/)?video\\/)([a-z0-9]+)/i,ha],[/start=(\\d+)/,fa]],[]],
facebook:[[[/\\/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com\\/(?:[\\/\\w]+\\/permalink|(?!marketplace\\/|pages\\/|groups\\/).*?)(?:\\/|fbid=|\\?v=)(\\d+)(?=$|[\\/?&#])/,ha],[/facebook\\.com\\/([.\\w]+)\\/(?=(?:post|video)s?\\/)([pv])/,["","user","type"]],[/facebook\\.com\\/video\\/(?=post|video)([pv])/,oa],[/facebook\\.com\\/watch\\/\\?([pv])=/,oa]],[{x:[[/facebook\\.com\\/watch\\/\\?(v)=(\\d+)/,["","type","id"]],[/facebook\\.com\\/([.\\w]+)\\/(v)ideos\\/(\\d+)/,["","user","type","id"]]],G:"User-agent: PHP (not Mozilla)",match:[[/fb\\.watch\\/./,
ca]]}]],liveleak:[[[/liveleak\\.com\\/(?:e\\/|view\\?i=)(\\w+)/,ha]],[{x:[[/liveleak\\.com\\/e\\/(\\w+)/,ha]],match:[[/liveleak\\.com\\/view\\?t=/,ca]]}]],soundcloud:[[[/https?:\\/\\/(?:api\\.)?soundcloud\\.com\\/(?!pages\\/)([-\\/\\w]+\\/[-\\/\\w]+|^[^\\/]+\\/[^\\/]+$)/i,ha],[/api\\.soundcloud\\.com\\/playlists\\/(\\d+)/,Fa],[/api\\.soundcloud\\.com\\/tracks\\/(\\d+)(?:\\?secret_token=([-\\w]+))?/,["","track_id","secret_token"]],[/soundcloud\\.com\\/(?!playlists|tracks)[-\\w]+\\/[-\\w]+\\/(?=s-)([-\\w]+)/,["","secret_token"]]],[{x:[[/soundcloud:tracks:(\\d+)/,
sa]],G:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/(?!playlists\\/\\d|tracks\\/\\d)[-\\w]+\\/[-\\w]/,ca]]},{x:[[/soundcloud:\\/\\/playlists:(\\d+)/,Fa]],G:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/\\w+\\/sets\\//,ca]]}]],spotify:[Ja,[{x:Ja,G:"User-agent: PHP (not Mozilla)",match:[[/link\\.tospotify\\.com\\/./,ca]]}]],twitch:[[[/twitch\\.tv\\/(?:videos|\\w+\\/v)\\/(\\d+)?/,["","video_id"]],[/www\\.twitch\\.tv\\/(?!videos\\/)(\\w+)(?:\\/clip\\/([-\\w]+))?/,Ga],[/t=((?:(?:\\d+h)?\\d+m)?\\d+s)/,fa],[/clips\\.twitch\\.tv\\/(?:(\\w+)\\/)?([-\\w]+)/,
Ga]],[]],vimeo:[[[/vimeo\\.com\\/(?:channels\\/[^\\/]+\\/|video\\/)?(\\d+)/,ha],[/#t=([\\dhms]+)/,fa]],[]],vine:[[[/vine\\.co\\/v\\/([^\\/]+)/,ha]],[]],youtube:[[[/youtube\\.com\\/(?:watch.*?v=|v\\/|attribution_link.*?v%3D)([-\\w]+)/,ha],[/youtu\\.be\\/([-\\w]+)/,ha],[/[#&?]t=(\\d[\\dhms]*)/,fa],[/[&?]list=([-\\w]+)/,["","list"]]],[{x:[[/\\/vi\\/([-\\w]+)/,ha]],match:[[/\\/shared\\?ci=/,ca]]}]]},urlConfig:{R:/^(?:ftp|https?|mailto)$/i}},Pb={d:Da,flags:8},X={BANDCAMP:{d:wa,b:{album_id:x,track_id:x,track_num:x},h:2,c:F,f:10,
e:pa,g:5E3},C:ab,CODE:{d:da,b:{lang:Xa},h:1,c:F,f:10,e:{l:A,flags:4436,m:A},g:5E3},DAILYMOTION:{d:wa,b:{id:x,t:x},h:2,c:F,f:10,e:pa,g:5E3},DEL:eb,EM:db,EMAIL:{d:Aa,b:{email:{c:[function(a){return/^[-\\w.+]+@[-\\w.]+$/.test(a)?a:!1}],p:!0}},h:2,c:F,f:10,e:na,g:5E3},ESC:{d:da,b:{},h:7,c:F,f:10,e:{flags:1616},g:5E3},FACEBOOK:{d:wa,b:{id:x,type:x,user:x},h:2,c:F,f:10,e:pa,g:5E3},FP:mb,H1:ob,H2:ob,H3:ob,H4:ob,H5:ob,H6:ob,HC:{d:da,b:{content:Ha},h:7,c:F,f:10,e:{flags:3153},g:5E3},HE:mb,HR:{d:va,b:{},h:1,
c:F,f:10,e:{l:A,flags:3349},g:5E3},IMG:{d:va,b:{alt:x,src:Ya,title:x},h:0,c:F,f:10,e:pa,g:5E3},ISPOILER:cb,LI:{d:xa,b:{},h:4,c:[Ka,function(a){for(var b=a.i+a.j;" "===T.charAt(b);)++b;var c=T.substr(b,3);if(/\\[[ Xx]\\]/.test(c)){var d=Math.random().toString(16).substr(2);c="[ ]"===c?"unchecked":"checked";b=L(3,"TASK",b,3,0);b.b.id=d;b.b.state=c;Cb(a,b)}}],f:10,e:bb,g:5E3},LIST:{d:Ea,b:{start:{c:[function(a){return/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],p:!1},type:Xa},h:1,c:F,f:10,e:$a,g:5E3},LIVELEAK:hb,
MEDIA:{d:[65519,65329,256],b:{},h:16,c:[function(a){return function(b,c,d){function l(k,h,t){var p=!1;t.forEach(function(u){var v=u[1],e=u[0].exec(h);e&&(p=!0,v.forEach(function(f,q){""<e[q]&&""<f&&(k[f]=e[q])}))});return p}(function(k,h,t){C(k);if("url"in k.b){var p=k.b.url,u;a:{for(u=/^https?:\\/\\/([^\\/]+)/.exec(p.toLowerCase())[1]||"";""<u;){if(h[u]){u=h[u];break a}u=u.replace(/^[^.]*./,"")}u=""}if(t[u]){h={};l(h,p,t[u][0]);a:{for(var v in h){t=!1;break a}t=!0}if(!t){t=k.i;var e=k.z;e?(p=k.j,v=
e.i,e=e.j):(p=0,v=k.i+k.j,e=0);k=M(u.toUpperCase(),t,p,v,e,k.q);La(k,h)}}}})(b,c,d)}(a,Pa["MediaEmbed.hosts"],Pa["MediaEmbed.sites"],Pa.cacheDir)}],f:10,e:{flags:513},g:5E3},QUOTE:{d:xa,b:{},h:1,c:F,f:10,e:Za,g:5E3},SOUNDCLOUD:{d:wa,b:{id:x,playlist_id:x,secret_token:x,track_id:x},h:2,c:F,f:10,e:pa,g:5E3},SPOILER:{d:xa,b:{},h:5,c:F,f:10,e:Za,g:5E3},SPOTIFY:hb,STRONG:db,SUB:cb,SUP:cb,TABLE:rb,TASK:{d:va,b:{id:Wa,state:Wa},h:2,c:F,f:10,e:pa,g:5E3},TBODY:tb,TD:{d:xa,b:nb,h:10,c:F,f:10,e:gb,g:5E3},TH:{d:Ca,
b:nb,h:10,c:F,f:10,e:gb,g:5E3},THEAD:qb,TR:sb,TWITCH:{d:wa,b:{channel:x,clip_id:x,t:x,video_id:x},h:2,c:F,f:10,e:pa,g:5E3},URL:{d:Aa,b:{title:x,url:Ya},h:6,c:F,f:10,e:na,g:5E3},VIMEO:{d:wa,b:{id:x,t:Oa},h:2,c:F,f:10,e:pa,g:5E3},VINE:hb,YOUTUBE:{d:wa,b:{id:{c:Na,p:!1},list:x,t:Oa},h:2,c:F,f:10,e:pa,g:5E3},"html:abbr":{d:ya,b:{title:x},h:0,c:F,f:10,e:ia,g:5E3},"html:b":db,"html:br":{d:Ba,b:{},h:0,c:F,f:10,e:qa,g:5E3},"html:code":ab,"html:dd":{d:xa,b:{},h:12,c:F,f:10,e:fb,g:5E3},"html:del":eb,"html:div":{d:Da,
b:Ia,h:13,c:F,f:10,e:Za,g:5E3},"html:dl":{d:[65408,65328,257],b:{},h:1,c:F,f:10,e:$a,g:5E3},"html:dt":{d:Ca,b:{},h:12,c:F,f:10,e:fb,g:5E3},"html:i":db,"html:img":{d:Ba,b:{alt:x,height:x,src:{c:Va,p:!1},title:x,width:x},h:0,c:F,f:10,e:qa,g:5E3},"html:ins":eb,"html:li":{d:xa,b:{},h:4,c:F,f:10,e:bb,g:5E3},"html:ol":pb,"html:pre":{d:ya,b:{},h:1,c:F,f:10,e:{l:A,flags:276,m:A},g:5E3},"html:rb":{d:ya,b:{},h:14,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:rb":1,
"html:rt":1,"html:rtc":1,"html:strong":1,"html:u":1},flags:256,m:A},g:5E3},"html:rp":{d:ya,b:{},h:15,c:F,f:10,e:{l:A,flags:256,m:A},g:5E3},"html:rt":{d:ya,b:{},h:15,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:rb":1,"html:rt":1,"html:strong":1,"html:u":1},flags:256,m:A},g:5E3},"html:rtc":{d:[65477,65409,257],b:{},h:14,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:rt":1,"html:rtc":1,"html:strong":1,"html:u":1},flags:256,
m:A},g:5E3},"html:ruby":{d:[65477,65473,257],b:{},h:0,c:F,f:10,e:ia,g:5E3},"html:span":{d:ya,b:Ia,h:0,c:F,f:10,e:ia,g:5E3},"html:strong":db,"html:sub":cb,"html:sup":cb,"html:table":rb,"html:tbody":tb,"html:td":{d:xa,b:{colspan:x,rowspan:x},h:10,c:F,f:10,e:gb,g:5E3},"html:tfoot":tb,"html:th":{d:Ca,b:{colspan:x,rowspan:x,scope:x},h:10,c:F,f:10,e:gb,g:5E3},"html:thead":qb,"html:tr":sb,"html:u":db,"html:ul":pb},Y,Qb,T,Rb,Sb=0,Tb;
function Ub(a){a=a.replace(/\\r\\n?/g,"\\n");a=a.replace(/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]+/g,"");var b=B;b.q=[];delete b.y;delete b.k;Hb={};Ib={};Jb=0;I=null;Kb=!1;Lb={};J=[];K="";O=0;Y=[];Qb=!1;T=a;Rb=T.length;Tb=0;G=Pb;G.A=!1;++Sb;a=Sb;for(var c in Ob)if(!Ob[c].B)a:{b=c;var d=Ob[b];if(!(d.u&&0>T.indexOf(d.u))){var l=[];if("undefined"!==typeof d.v&&"undefined"!==typeof d.w){l=void 0;var k=d.v;d=d.w;k.lastIndex=0;for(var h=[],t=0;++t<=d&&(l=k.exec(T));){for(var p=l.index,u=[[l[0],p]],v=0;++v<l.length;){var e=
l[v];void 0===e?u.push(["",-1]):(u.push([e,T.indexOf(e,p)]),p+=e.length)}h.push(u)}l=h;if(!l.length)break a}(0,Ob[b].r)(T,l)}}Vb();Wb(Rb,0,!0);do c=K,K=K.replace(/<([^ />]+)[^>]*><\\/\\1>/g,"");while(K!==c);K=K.replace(/<\\/i><i>/g,"");K=K.replace(/[\\x00-\\x08\\x0B-\\x1F]/g,"");K=K.replace(/[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,Xb);b=Kb?"r":"t";c="<"+b;for(var f in Lb)c+=" xmlns:"+f+\'="urn:s9e:TextFormatter:\'+f+\'"\';K=c+">"+K+"</"+b+">";if(Sb!==a)throw"The parser has been reset during execution";1E4<Jb&&B.add("warn",
"Fixing cost limit exceeded",void 0);return K}function ac(a){var b={},c;for(c in X[a])b[c]=X[a][c];return X[a]=b}function Xb(a){return"&#"+((a.charCodeAt(0)<<10)+a.charCodeAt(1)-56613888)+";"}
function bc(a){Kb=!0;var b=a.name,c=a.i,d=a.j,l=a.flags,k=0,h=0;l&256&&(k=1,h=a.k&2?2:1);Wb(c,k,!(a.k&1&&!(l&4)));k=d?yb(T.substr(c,d)):"";if(a.k&1){l&4||cc(c);l=b.indexOf(":");0<l&&(Lb[b.substr(0,l)]=0);K+="<"+b;var t=Fb(a);l=[];for(var p in t)l.push(p);l.sort(function(u,v){return u>v?1:-1});l.forEach(function(u){K+=" "+u+\'="\'+xb(t[u].toString()).replace(/\\n/g,"&#10;")+\'"\'});K=3===a.k?d?K+(">"+k+"</"+b+">"):K+"/>":d?K+("><s>"+k+"</s>"):K+">"}else d&&(K+="<e>"+k+"</e>"),K+="</"+b+">";for(Tb=O=c+d;h&&
Tb<Rb&&"\\n"===T[Tb];)--h,++Tb}
function Wb(a,b,c){c&&(G.flags&8?b=-1:c=!1);O>=a&&c&&dc();if(Tb>O){var d=Math.min(a,Tb);K+=T.substr(O,d-O);O=d;O>=a&&c&&dc()}if(G.flags&128)d=a-O,b=T.substr(O,d),/^[ \\n\\t]*$/.test(b)||(b="<i>"+yb(b)+"</i>"),K+=b,O=a,c&&dc();else{var l=a;for(d=0;b&&--l>=O;){var k=T[l];if(" "!==k&&"\\n"!==k&&"\\t"!==k)break;"\\n"===k&&--b;++d}a-=d;if(G.flags&8)for(G.A||(ec(a),a>O&&cc(a)),b=T.indexOf("\\n\\n",O);-1<b&&b<a;)Wb(b,0,!0),cc(a),b=T.indexOf("\\n\\n",O);a>O&&(b=yb(T.substr(O,a-O)),K+=b);c&&dc();d&&(K+=T.substr(a,
d));O=a+d}}function fc(a){var b=a.i;a=a.j;var c=T.substr(b,a);Wb(b,0,!1);K+="<i>"+yb(c)+"</i>";Kb=!0;O=b+a}function cc(a){!G.A&&G.flags&8&&(ec(a),O<Rb&&(K+="<p>",G.A=!0))}function dc(){G.A&&(K+="</p>",G.A=!1)}function ec(a){for(;O<a&&-1<" \\n\\t".indexOf(T[O]);)K+=T[O],++O}function gc(a,b,c){var d=a.name;(I.flags|a.flags)&256&&(b=hc(b));b=Mb(d,b,0,c||0);Db(b,a)}function hc(a){for(;a>O&&-1<" \\n\\t".indexOf(T[a-1]);)--a;return a}
function Vb(){if(Y.length){for(var a in X)Hb[a]=0,Ib[a]=0;do{for(;Y.length;)Qb||ic(),I=Y.pop(),jc();J.forEach(function(b){gc(b,Rb)})}while(Y.length)}}
function jc(){G.flags&64&&!Gb(I,J[J.length-1])&&!(-1<"br i pb v".indexOf(I.name))&&C(I);var a=I.i,b=I.j;if(O>a&&!I.o){var c;if((c=I.F)&&0<=J.indexOf(c)){Db(Mb(c.name,O,Math.max(0,a+b-O)),c);return}if("i"===I.name&&(a=a+b-O,0<a)){Nb(O,a);return}C(I)}if(!I.o)if("i"===I.name)fc(I);else if("br"===I.name)G.flags&1024||(Wb(I.i,0,!1),K+="<br/>");else if("pb"===I.name)Wb(I.i,0,!0);else if("v"===I.name)a=G.flags,G.flags=I.flags,Wb(I.i+I.j,0,!1),G.flags=a;else if(I.k&1)if(a=I,b=a.name,c=X[b],Ib[b]>=c.g)B.add("err",
"Tag limit exceeded",{tag:a,tagName:b,tagLimit:c.g}),C(a);else{var d=a,l=X[d.name];B.k=d;for(var k=0;k<l.c.length&&!d.o;++k)l.c[k](d,l);delete B.k;if(!(d=a.o)&&(d=1E4>Jb)){a:{d=a;if(J.length){k=d.name;var h=X[k];if(h.e.m){l=J[J.length-1];var t=l.name;if(h.e.m[t]){if(t!==k&&1E4>Jb){k=d.i+d.j;Y.length?(h=Y[Y.length-1],h=h.i):h=Rb+1;for(;k<h&&-1<" \\n\\t".indexOf(T[k]);)++k;k=kc(l,k);Cb(d,k)}Y.push(d);gc(l,d.i,d.q-1);Jb+=4;d=!0;break a}}}d=!1}if(!d)a:{d=a;if(J.length&&(l=X[d.name],l.e.l&&(k=J[J.length-
1],l.e.l[k.name]))){++Jb;Y.push(d);gc(k,d.i,d.q-1);d=!0;break a}d=!1}d=d||!1}d||(Hb[b]>=c.f?(B.add("err","Nesting limit exceeded",{tag:a,tagName:b,nestingLimit:c.f}),C(a)):(c=X[b].h,G.d[c>>3]&1<<(c&7)?(!(a.flags&1&&3!==a.k)||a.z||Y.length&&Gb(Y[Y.length-1],a)||(b=new Bb(3,b,a.i,a.j),La(b,Fb(a)),b.flags=a.flags,a=b),a.flags&4096&&"\\n"===T[a.i+a.j]&&Nb(a.i+a.j,1),bc(a),lc(a)):(b={tag:a,tagName:b},0<a.j?B.add("warn","Tag is not allowed in this context",b):Ab("Tag is not allowed in this context",b),C(a))))}else mc()}
function mc(){var a=I;if(Hb[a.name]){for(var b=[],c=J.length;0<=--c;){var d=J[c];if(Gb(a,d))break;b.push(d);++Jb}if(0>c)Ab("Skipping end tag with no start tag",{tag:a});else{var l=a.flags;b.forEach(function(v){l|=v.flags});var k=l&256,h=1E4>Jb,t=[];b.forEach(function(v){var e=v.name;h&&(v.flags&2?t.push(v):h=!1);var f=a.i;k&&(f=hc(f));e=new Bb(2,e,f,0);e.flags=v.flags;bc(e);nc()});bc(a);nc();if(b.length&&1E4>Jb){d=O;for(c=Y.length;0<=--c&&1E4>++Jb;){var p=Y[c];if(p.i>d||p.k&1)break;for(var u=b.length;0<=
--u&&1E4>++Jb;)if(Gb(p,b[u])){b.splice(u,1);t[u]&&t.splice(u,1);d=Math.max(d,p.i+p.j);break}}d>O&&fc(new Bb(3,"i",O,d-O))}t.forEach(function(v){var e=kc(v,O);(v=v.z)&&Db(e,v)})}}}function nc(){var a=J.pop();--Hb[a.name];G=G.V}function lc(a){var b=a.name,c=a.flags,d=X[b];++Ib[b];if(3!==a.k){var l=[];G.d.forEach(function(h,t){c&512||(h=h&65280|h>>8);l.push(d.d[t]&h)});var k=c|G.flags&32;k&16&&(k&=-33);++Hb[b];J.push(a);G={V:G};G.d=l;G.flags=k}}function Mb(a,b,c,d){return L(2,a,b,c,d||0)}
function Nb(a,b,c){return L(3,"i",a,Math.min(b,Rb-a),c||0)}function kc(a,b){b=L(a.k,a.name,b,0,a.q);La(b,Fb(a));return b}function L(a,b,c,d,l){a=new Bb(a,b,c,d,l||0);X[b]&&(a.flags=X[b].e.flags);if(!(X[b]||-1<"br i pb v".indexOf(a.name))||0>d||0>c||c+d>Rb||/[\\uDC00-\\uDFFF]/.test(T.substr(c,1)+T.substr(c+d,1)))C(a);else if(X[b]&&X[b].B)B.add("warn","Tag is disabled",{tag:a,tagName:b}),C(a);else if(Qb){b=Y.length;for(c=oc(a);0<b&&c>oc(Y[b-1]);)Y[b]=Y[b-1],--b;Y[b]=a}else Y.push(a);return a}
function M(a,b,c,d,l,k){d=Mb(a,d,l,-k||0);a=L(1,a,b,c,k||0);Db(a,d);return a}function ic(){for(var a={},b=[],c=Y.length;0<=--c;){var d=Y[c],l=oc(d,c);b.push(l);a[l]=d}b.sort();c=b.length;for(Y=[];0<=--c;)Y.push(a[b[c]]);Qb=!0}function oc(a,b){var c=0<=a.q,d=a.q;c||(d+=1073741824);var l=0<a.j,k;l?k=Rb-a.j:k={2:0,3:1,1:2}[a.k];return pc(a.i)+ +c+pc(d)+ +l+pc(k)+pc(b||0)}function pc(a){a=a.toString(16);return"        ".substr(a.length)+a}var qc="undefined"===typeof DOMParser||"undefined"===typeof XSLTProcessor;
function rc(a){if(qc){var b=new ActiveXObject("MSXML2.FreeThreadedDOMDocument.6.0");b.async=!1;b.validateOnParse=!1;b.loadXML(a)}else b=(new DOMParser).parseFromString(a,"text/xml");if(!b)throw"Cannot parse "+a;return b}function sc(a,b){if(qc){var c=b.createElement("div");b=b.createDocumentFragment();tc.input=rc(a);tc.transform();for(c.innerHTML=tc.output;c.firstChild;)b.appendChild(c.firstChild);return b}return tc.transformToFragment(rc(a),b)}var tc,uc=rc(ub);
if(qc){var vc=new ActiveXObject("MSXML2.XSLTemplate.6.0");vc.stylesheet=uc;tc=vc.createProcessor()}else tc=new XSLTProcessor,tc.importStylesheet(uc);window.s9e||(window.s9e={});
window.s9e.TextFormatter={disablePlugin:function(a){Ob[a]&&(Ob[a].B=!0)},disableTag:function(a){X[a]&&(ac(a).B=!0)},enablePlugin:function(a){Ob[a]&&(Ob[a].B=!1)},enableTag:function(a){X[a]&&(ac(a).B=!1)},getLogger:function(){return B},parse:Ub,preview:function(a,b){function c(h,t){var p=h.childNodes;t=t.childNodes;for(var u=p.length,v=t.length,e,f,q=0,r=0;q<u&&q<v;){e=p[q];f=t[q];if(!d(e,f))break;++q}for(var g=Math.min(u-q,v-q);r<g;){e=p[u-(r+1)];f=t[v-(r+1)];if(!d(e,f))break;++r}for(u-=r;--u>=q;)h.removeChild(p[u]),
k=h;p=v-r;if(!(q>=p)){v=l.createDocumentFragment();u=q;do f=t[u],k=v.appendChild(f);while(u<--p);r?h.insertBefore(v,h.childNodes[q]):h.appendChild(v)}}function d(h,t){if(h.nodeName!==t.nodeName||h.nodeType!==t.nodeType)return!1;if(h instanceof HTMLElement&&t instanceof HTMLElement){if(!h.isEqualNode(t)){for(var p=h.attributes,u=t.attributes,v=u.length,e=p.length,f=" "+h.getAttribute("data-s9e-livepreview-ignore-attrs")+" ";0<=--e;){var q=p[e],r=q.namespaceURI;q=q.name;-1<f.indexOf(" "+q+" ")||t.hasAttributeNS(r,
q)||(h.removeAttributeNS(r,q),k=h)}for(e=v;0<=--e;)p=u[e],r=p.namespaceURI,q=p.name,p=p.value,-1<f.indexOf(" "+q+" ")||p===h.getAttributeNS(r,q)||(h.setAttributeNS(r,q,p),k=h);c(h,t)}}else 3!==h.nodeType&&8!==h.nodeType||h.nodeValue===t.nodeValue||(h.nodeValue=t.nodeValue,k=h);return!0}var l=b.ownerDocument;if(!l)throw"Target does not have a ownerDocument";a=sc(Ub(a).replace(/<[eis]>[^<]*<\\/[eis]>/g,""),l);var k=b;"undefined"!==typeof window&&"chrome"in window&&a.querySelectorAll("script").forEach(function(h){var t=
document.createElement("script");var p=h.attributes;var u="undefined"!=typeof Symbol&&Symbol.iterator&&p[Symbol.iterator];p=u?u.call(p):{next:ba(p)};for(u=p.next();!u.done;u=p.next())u=u.value,t.setAttribute(u.name,u.value);t.textContent=h.textContent;h.parentNode.replaceChild(t,h)});c(b,a);return k},registeredVars:Pa,setNestingLimit:function(a,b){X[a]&&(ac(a).f=b)},setParameter:function(a,b){qc?tc.addParameter(a,b,""):tc.setParameter(null,a,b)},setTagLimit:function(a,b){X[a]&&(ac(a).g=b)}};})();';
	}

	/**
	* {@inheritdoc}
	*/
	public static function getParser()
	{
		return unserialize('O:24:"s9e\\TextFormatter\\Parser":4:{s:16:"' . "\0" . '*' . "\0" . 'pluginsConfig";a:10:{s:9:"Autoemail";a:5:{s:8:"attrName";s:5:"email";s:10:"quickMatch";s:1:"@";s:6:"regexp";s:39:"/\\b[-a-z0-9_+.]+@[-a-z0-9.]*[a-z0-9]/Si";s:7:"tagName";s:5:"EMAIL";s:11:"regexpLimit";i:50000;}s:8:"Autolink";a:5:{s:8:"attrName";s:3:"url";s:6:"regexp";s:135:"#\\b(?:ftp|https?|mailto):(?>[^\\s()\\[\\]\\x{FF01}-\\x{FF0F}\\x{FF1A}-\\x{FF20}\\x{FF3B}-\\x{FF40}\\x{FF5B}-\\x{FF65}]|\\([^\\s()]*\\)|\\[\\w*\\])++#Siu";s:7:"tagName";s:3:"URL";s:10:"quickMatch";s:1:":";s:11:"regexpLimit";i:50000;}s:7:"Escaper";a:4:{s:10:"quickMatch";s:1:"\\";s:6:"regexp";s:30:"/\\\\[-!#()*+.:<>@[\\\\\\]^_`{|}~]/";s:7:"tagName";s:3:"ESC";s:11:"regexpLimit";i:50000;}s:10:"FancyPants";a:2:{s:8:"attrName";s:4:"char";s:7:"tagName";s:2:"FP";}s:12:"HTMLComments";a:5:{s:8:"attrName";s:7:"content";s:10:"quickMatch";s:4:"<!--";s:6:"regexp";s:22:"/<!--(?!\\[if).*?-->/is";s:7:"tagName";s:2:"HC";s:11:"regexpLimit";i:50000;}s:12:"HTMLElements";a:5:{s:10:"quickMatch";s:1:"<";s:6:"prefix";s:4:"html";s:6:"regexp";s:385:"#<(?>/((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))|((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))((?>\\s+[a-z][-a-z0-9]*(?>\\s*=\\s*(?>"[^"]*"|\'[^\']*\'|[^\\s"\'=<>`]+))?)*+)\\s*/?)\\s*>#i";s:7:"aliases";a:6:{s:1:"a";a:2:{s:0:"";s:3:"URL";s:4:"href";s:3:"url";}s:2:"hr";a:1:{s:0:"";s:2:"HR";}s:2:"em";a:1:{s:0:"";s:2:"EM";}s:1:"s";a:1:{s:0:"";s:1:"S";}s:6:"strong";a:1:{s:0:"";s:6:"STRONG";}s:3:"sup";a:1:{s:0:"";s:3:"SUP";}}s:11:"regexpLimit";i:50000;}s:12:"HTMLEntities";a:5:{s:8:"attrName";s:4:"char";s:10:"quickMatch";s:1:"&";s:6:"regexp";s:38:"/&(?>[a-z]+|#(?>[0-9]+|x[0-9a-f]+));/i";s:7:"tagName";s:2:"HE";s:11:"regexpLimit";i:50000;}s:8:"Litedown";a:1:{s:18:"decodeHtmlEntities";b:1;}s:10:"MediaEmbed";a:4:{s:10:"quickMatch";s:3:"://";s:6:"regexp";s:26:"/\\bhttps?:\\/\\/[^["\'\\s]+/Si";s:7:"tagName";s:5:"MEDIA";s:11:"regexpLimit";i:50000;}s:10:"PipeTables";a:3:{s:16:"overwriteEscapes";b:1;s:17:"overwriteMarkdown";b:1;s:10:"quickMatch";s:1:"|";}}s:14:"registeredVars";a:3:{s:9:"urlConfig";a:1:{s:14:"allowedSchemes";s:27:"/^(?:ftp|https?|mailto)$/Di";}s:16:"MediaEmbed.hosts";a:15:{s:12:"bandcamp.com";s:8:"bandcamp";s:6:"dai.ly";s:11:"dailymotion";s:15:"dailymotion.com";s:11:"dailymotion";s:12:"facebook.com";s:8:"facebook";s:8:"fb.watch";s:8:"facebook";s:12:"liveleak.com";s:8:"liveleak";s:14:"soundcloud.com";s:10:"soundcloud";s:18:"link.tospotify.com";s:7:"spotify";s:16:"open.spotify.com";s:7:"spotify";s:16:"play.spotify.com";s:7:"spotify";s:9:"twitch.tv";s:6:"twitch";s:9:"vimeo.com";s:5:"vimeo";s:7:"vine.co";s:4:"vine";s:11:"youtube.com";s:7:"youtube";s:8:"youtu.be";s:7:"youtube";}s:16:"MediaEmbed.sites";a:10:{s:8:"bandcamp";a:2:{i:0;a:0:{}i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!/album=(?\'album_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"album_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/album/.!";i:1;a:1:{i:0;s:0:"";}}}}i:1;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:29:"!"album_id":(?\'album_id\'\\d+)!";i:1;R:92;}i:1;a:2:{i:0;s:31:"!"track_num":(?\'track_num\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"track_num";}}i:2;a:2:{i:0;s:25:"!/track=(?\'track_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"track_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/track/.!";i:1;R:98;}}}}}s:11:"dailymotion";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:27:"!dai\\.ly/(?\'id\'[a-z0-9]+)!i";i:1;a:2:{i:0;s:0:"";i:1;s:2:"id";}}i:1;a:2:{i:0;s:92:"!dailymotion\\.com/(?:live/|swf/|user/[^#]+#video=|(?:related/\\d+/)?video/)(?\'id\'[a-z0-9]+)!i";i:1;R:121;}i:2;a:2:{i:0;s:17:"!start=(?\'t\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:1:"t";}}}i:1;R:86;}s:8:"facebook";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:148:"@/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com/(?:[/\\w]+/permalink|(?!marketplace/|pages/|groups/).*?)(?:/|fbid=|\\?v=)(?\'id\'\\d+)(?=$|[/?&#])@";i:1;R:121;}i:1;a:2:{i:0;s:66:"@facebook\\.com/(?\'user\'[.\\w]+)/(?=(?:post|video)s?/)(?\'type\'[pv])@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";}}i:2;a:2:{i:0;s:49:"@facebook\\.com/video/(?=post|video)(?\'type\'[pv])@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"type";}}i:3;a:2:{i:0;s:38:"@facebook\\.com/watch/\\?(?\'type\'[pv])=@";i:1;R:143;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:45:"@facebook\\.com/watch/\\?(?\'type\'v)=(?\'id\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"type";i:2;s:2:"id";}}i:1;a:2:{i:0;s:58:"@facebook\\.com/(?\'user\'[.\\w]+)/(?\'type\'v)ideos/(?\'id\'\\d+)@";i:1;a:4:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";i:3;s:2:"id";}}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"@fb\\.watch/.@";i:1;R:98;}}}}}s:8:"liveleak";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!liveleak\\.com/(?:e/|view\\?i=)(?\'id\'\\w+)!";i:1;R:121;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"!liveleak\\.com/e/(?\'id\'\\w+)!";i:1;R:121;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!liveleak\\.com/view\\?t=!";i:1;R:98;}}}}}s:10:"soundcloud";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:84:"@https?://(?:api\\.)?soundcloud\\.com/(?!pages/)(?\'id\'[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)@i";i:1;R:121;}i:1;a:2:{i:0;s:52:"@api\\.soundcloud\\.com/playlists/(?\'playlist_id\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:11:"playlist_id";}}i:2;a:2:{i:0;s:89:"@api\\.soundcloud\\.com/tracks/(?\'track_id\'\\d+)(?:\\?secret_token=(?\'secret_token\'[-\\w]+))?@";i:1;a:3:{i:0;s:0:"";i:1;s:8:"track_id";i:2;s:12:"secret_token";}}i:3;a:2:{i:0;s:81:"@soundcloud\\.com/(?!playlists|tracks)[-\\w]+/[-\\w]+/(?=s-)(?\'secret_token\'[-\\w]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:12:"secret_token";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:36:"@soundcloud:tracks:(?\'track_id\'\\d+)@";i:1;R:111;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"@soundcloud\\.com/(?!playlists/\\d|tracks/\\d)[-\\w]+/[-\\w]@";i:1;R:98;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:44:"@soundcloud://playlists:(?\'playlist_id\'\\d+)@";i:1;R:186;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:27:"@soundcloud\\.com/\\w+/sets/@";i:1;R:98;}}}}}s:7:"spotify";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:115:"!(?:open|play)\\.spotify\\.com/(?:user/[-.\\w]+/)?(?\'id\'(?:album|artist|episode|playlist|show|track)(?:[:/][-.\\w]+)+)!";i:1;R:121;}}i:1;a:1:{i:0;a:3:{s:7:"extract";R:218;s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!link\\.tospotify\\.com/.!";i:1;R:98;}}}}}s:6:"twitch";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:47:"#twitch\\.tv/(?:videos|\\w+/v)/(?\'video_id\'\\d+)?#";i:1;a:2:{i:0;s:0:"";i:1;s:8:"video_id";}}i:1;a:2:{i:0;s:73:"#www\\.twitch\\.tv/(?!videos/)(?\'channel\'\\w+)(?:/clip/(?\'clip_id\'[-\\w]+))?#";i:1;a:3:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:7:"clip_id";}}i:2;a:2:{i:0;s:32:"#t=(?\'t\'(?:(?:\\d+h)?\\d+m)?\\d+s)#";i:1;R:128;}i:3;a:2:{i:0;s:59:"#clips\\.twitch\\.tv/(?:(?\'channel\'\\w+)/)?(?\'clip_id\'[-\\w]+)#";i:1;R:236;}}i:1;R:86;}s:5:"vimeo";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!vimeo\\.com/(?:channels/[^/]+/|video/)?(?\'id\'\\d+)!";i:1;R:121;}i:1;a:2:{i:0;s:19:"!#t=(?\'t\'[\\dhms]+)!";i:1;R:128;}}i:1;R:86;}s:4:"vine";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!vine\\.co/v/(?\'id\'[^/]+)!";i:1;R:121;}}i:1;R:86;}s:7:"youtube";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:69:"!youtube\\.com/(?:watch.*?v=|v/|attribution_link.*?v%3D)(?\'id\'[-\\w]+)!";i:1;R:121;}i:1;a:2:{i:0;s:25:"!youtu\\.be/(?\'id\'[-\\w]+)!";i:1;R:121;}i:2;a:2:{i:0;s:25:"@[#&?]t=(?\'t\'\\d[\\dhms]*)@";i:1;R:128;}i:3;a:2:{i:0;s:26:"![&?]list=(?\'list\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:4:"list";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!/vi/(?\'id\'[-\\w]+)!";i:1;R:121;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:14:"!/shared\\?ci=!";i:1;R:98;}}}}}}}s:14:"' . "\0" . '*' . "\0" . 'rootContext";a:2:{s:7:"allowed";a:3:{i:0;i:65519;i:1;i:65329;i:2;i:257;}s:5:"flags";i:8;}s:13:"' . "\0" . '*' . "\0" . 'tagsConfig";a:77:{s:8:"BANDCAMP";a:7:{s:10:"attributes";a:3:{s:8:"album_id";a:2:{s:8:"required";b:0;s:11:"filterChain";R:86;}s:8:"track_id";R:284;s:9:"track_num";R:284;}s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\FilterProcessing::filterAttributes";s:6:"params";a:4:{s:3:"tag";N;s:9:"tagConfig";N;s:14:"registeredVars";N;s:6:"logger";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3089;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";a:3:{i:0;i:32960;i:1;i:257;i:2;i:256;}}s:1:"C";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:66;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:0;s:7:"allowed";a:3:{i:0;i:0;i:1;i:0;i:2;i:0;}}s:4:"CODE";a:7:{s:10:"attributes";a:1:{s:4:"lang";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:23:"/^[- +,.0-9A-Za-z_]+$/D";}}}s:8:"required";b:0;}}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:10:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;}s:12:"fosterParent";R:325;s:5:"flags";i:4436;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:309;}s:11:"DAILYMOTION";a:7:{s:10:"attributes";a:2:{s:2:"id";R:284;s:1:"t";R:284;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:295;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:299;}s:3:"DEL";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:512;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:0;s:7:"allowed";R:276;}s:2:"EM";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:2;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:0;s:7:"allowed";a:3:{i:0;i:65477;i:1;i:65281;i:2;i:257;}}s:5:"EMAIL";a:7:{s:10:"attributes";a:1:{s:5:"email";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:61:"s9e\\TextFormatter\\Parser\\AttributeFilters\\EmailFilter::filter";s:6:"params";a:1:{s:9:"attrValue";N;}}}s:8:"required";b:1;}}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:514;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";a:3:{i:0;i:39819;i:1;i:65329;i:2;i:257;}}s:3:"ESC";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:1616;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:7;s:7:"allowed";R:309;}s:8:"FACEBOOK";a:7:{s:10:"attributes";a:3:{s:2:"id";R:284;s:4:"type";R:284;s:4:"user";R:284;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:295;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:299;}s:2:"FP";a:7:{s:10:"attributes";a:1:{s:4:"char";a:2:{s:8:"required";b:1;s:11:"filterChain";R:86;}}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:295;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:8;s:7:"allowed";a:3:{i:0;i:32896;i:1;i:257;i:2;i:257;}}s:2:"H1";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:325;s:12:"fosterParent";R:325;s:5:"flags";i:260;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:3;s:7:"allowed";R:356;}s:2:"H2";R:400;s:2:"H3";R:400;s:2:"H4";R:400;s:2:"H5";R:400;s:2:"H6";R:400;s:2:"HC";a:7:{s:10:"attributes";a:1:{s:7:"content";R:391;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3153;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:7;s:7:"allowed";R:309;}s:2:"HE";R:389;s:2:"HR";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:2:{s:11:"closeParent";R:325;s:5:"flags";i:3349;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:1;s:7:"allowed";R:396;}s:3:"IMG";a:7:{s:10:"attributes";a:3:{s:3:"alt";R:284;s:3:"src";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\AttributeFilters\\UrlFilter::filter";s:6:"params";a:3:{s:9:"attrValue";N;s:9:"urlConfig";N;s:6:"logger";N;}}}s:8:"required";b:1;}s:5:"title";R:284;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:295;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:396;}s:8:"ISPOILER";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:0;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:0;s:7:"allowed";R:356;}s:2:"LI";a:7:{s:11:"filterChain";a:2:{i:0;R:287;i:1;a:2:{s:8:"callback";s:58:"s9e\\TextFormatter\\Plugins\\TaskLists\\Helper::filterListItem";s:6:"params";a:3:{s:6:"parser";N;s:3:"tag";N;s:4:"text";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:2:"LI";i:1;s:7:"html:li";i:1;}s:12:"fosterParent";R:325;s:5:"flags";i:264;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:4;s:7:"allowed";a:3:{i:0;i:65519;i:1;i:65313;i:2;i:257;}}s:4:"LIST";a:7:{s:10:"attributes";a:2:{s:5:"start";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:67:"s9e\\TextFormatter\\Parser\\AttributeFilters\\NumericFilter::filterUint";s:6:"params";R:366;}}s:8:"required";b:0;}s:4:"type";R:315;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:325;s:12:"fosterParent";R:325;s:5:"flags";i:3460;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";a:3:{i:0;i:65424;i:1;i:65280;i:2;i:257;}}s:8:"LIVELEAK";a:7:{s:10:"attributes";a:1:{s:2:"id";R:284;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:295;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:299;}s:5:"MEDIA";a:7:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:54:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::filterTag";s:6:"params";a:5:{s:3:"tag";N;s:6:"parser";N;s:16:"MediaEmbed.hosts";N;s:16:"MediaEmbed.sites";N;s:8:"cacheDir";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:513;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:16;s:7:"allowed";a:3:{i:0;i:65519;i:1;i:65329;i:2;i:256;}}s:5:"QUOTE";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:325;s:12:"fosterParent";R:325;s:5:"flags";i:268;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:1;s:7:"allowed";R:465;}s:10:"SOUNDCLOUD";a:7:{s:10:"attributes";a:4:{s:2:"id";R:284;s:11:"playlist_id";R:284;s:12:"secret_token";R:284;s:8:"track_id";R:284;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:295;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:299;}s:7:"SPOILER";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:511;s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:5;s:7:"allowed";R:465;}s:7:"SPOTIFY";R:485;s:6:"STRONG";R:350;s:3:"SUB";R:433;s:3:"SUP";R:433;s:5:"TABLE";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:477;s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:1;s:7:"allowed";a:3:{i:0;i:65408;i:1;i:65290;i:2;i:257;}}s:4:"TASK";a:7:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:19:"/^[-0-9A-Za-z_]+$/D";}}}s:8:"required";b:1;}s:5:"state";R:534;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:295;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:396;}s:5:"TBODY";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:20:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:5:"TBODY";i:1;s:2:"TD";i:1;s:2:"TH";i:1;s:5:"THEAD";i:1;s:2:"TR";i:1;s:10:"html:tbody";i:1;s:7:"html:td";i:1;s:7:"html:th";i:1;s:10:"html:thead";i:1;s:7:"html:tr";i:1;}s:12:"fosterParent";R:325;s:5:"flags";i:3456;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:9;s:7:"allowed";a:3:{i:0;i:65408;i:1;i:65288;i:2;i:257;}}s:2:"TD";a:7:{s:10:"attributes";a:1:{s:5:"align";a:2:{s:11:"filterChain";a:2:{i:0;a:2:{s:8:"callback";s:10:"strtolower";s:6:"params";R:366;}i:1;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:34:"/^(?:center|justify|left|right)$/D";}}}s:8:"required";b:0;}}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:14:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:2:"TD";i:1;s:2:"TH";i:1;s:7:"html:td";i:1;s:7:"html:th";i:1;}s:12:"fosterParent";R:325;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";R:465;}s:2:"TH";a:7:{s:10:"attributes";R:577;s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:589;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";a:3:{i:0;i:63463;i:1;i:65313;i:2;i:257;}}s:5:"THEAD";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:325;s:12:"fosterParent";R:325;s:5:"flags";i:3456;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:9;s:7:"allowed";R:572;}s:2:"TR";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:16:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:2:"TD";i:1;s:2:"TH";i:1;s:2:"TR";i:1;s:7:"html:td";i:1;s:7:"html:th";i:1;s:7:"html:tr";i:1;}s:12:"fosterParent";R:325;s:5:"flags";i:3456;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:11;s:7:"allowed";a:3:{i:0;i:65408;i:1;i:65284;i:2;i:257;}}s:6:"TWITCH";a:7:{s:10:"attributes";a:4:{s:7:"channel";R:284;s:7:"clip_id";R:284;s:1:"t";R:284;s:8:"video_id";R:284;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:295;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:299;}s:3:"URL";a:7:{s:10:"attributes";a:2:{s:5:"title";R:284;s:3:"url";R:421;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:370;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:6;s:7:"allowed";R:374;}s:5:"VIMEO";a:7:{s:10:"attributes";a:2:{s:2:"id";R:284;s:1:"t";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:65:"s9e\\TextFormatter\\Parser\\AttributeFilters\\TimestampFilter::filter";s:6:"params";R:366;}}s:8:"required";b:0;}}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:295;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:299;}s:4:"VINE";R:485;s:7:"YOUTUBE";a:7:{s:10:"attributes";a:3:{s:2:"id";a:2:{s:11:"filterChain";R:535;s:8:"required";b:0;}s:4:"list";R:284;s:1:"t";R:661;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:295;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:299;}s:9:"html:abbr";a:7:{s:10:"attributes";a:1:{s:5:"title";R:284;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:435;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:356;}s:6:"html:b";R:350;s:7:"html:br";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3201;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:0;s:7:"allowed";a:3:{i:0;i:65408;i:1;i:65280;i:2;i:257;}}s:9:"html:code";R:303;s:7:"html:dd";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:7:"html:dd";i:1;s:7:"html:dt";i:1;}s:12:"fosterParent";R:325;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:12;s:7:"allowed";R:465;}s:8:"html:del";R:344;s:8:"html:div";a:7:{s:10:"attributes";a:1:{s:5:"class";R:284;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:511;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:13;s:7:"allowed";R:276;}s:7:"html:dl";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:477;s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:1;s:7:"allowed";a:3:{i:0;i:65408;i:1;i:65328;i:2;i:257;}}s:7:"html:dt";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:693;s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:12;s:7:"allowed";R:612;}s:6:"html:i";R:350;s:8:"html:img";a:7:{s:10:"attributes";a:5:{s:3:"alt";R:284;s:6:"height";R:284;s:3:"src";a:2:{s:11:"filterChain";R:422;s:8:"required";b:0;}s:5:"title";R:284;s:5:"width";R:284;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:683;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:687;}s:8:"html:ins";R:344;s:7:"html:li";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:448;s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:4;s:7:"allowed";R:465;}s:7:"html:ol";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:477;s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:1;s:7:"allowed";R:481;}s:8:"html:pre";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:325;s:12:"fosterParent";R:325;s:5:"flags";i:276;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:1;s:7:"allowed";R:356;}s:7:"html:rb";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:13:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:7:"html:rb";i:1;s:7:"html:rt";i:1;s:8:"html:rtc";i:1;}s:12:"fosterParent";R:325;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:14;s:7:"allowed";R:356;}s:7:"html:rp";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:325;s:12:"fosterParent";R:325;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:15;s:7:"allowed";R:356;}s:7:"html:rt";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:7:"html:rb";i:1;s:7:"html:rt";i:1;}s:12:"fosterParent";R:325;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:15;s:7:"allowed";R:356;}s:8:"html:rtc";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"C";i:1;s:2:"EM";i:1;s:5:"EMAIL";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:7:"html:rt";i:1;s:8:"html:rtc";i:1;}s:12:"fosterParent";R:325;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:14;s:7:"allowed";a:3:{i:0;i:65477;i:1;i:65409;i:2;i:257;}}s:9:"html:ruby";a:7:{s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:435;s:8:"tagLimit";i:5000;s:10:"attributes";R:86;s:9:"bitNumber";i:0;s:7:"allowed";a:3:{i:0;i:65477;i:1;i:65473;i:2;i:257;}}s:9:"html:span";a:7:{s:10:"attributes";R:711;s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:435;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:356;}s:11:"html:strong";R:350;s:8:"html:sub";R:433;s:8:"html:sup";R:433;s:10:"html:table";R:524;s:10:"html:tbody";R:545;s:7:"html:td";a:7:{s:10:"attributes";a:2:{s:7:"colspan";R:284;s:7:"rowspan";R:284;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:589;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";R:465;}s:10:"html:tfoot";R:545;s:7:"html:th";a:7:{s:10:"attributes";a:3:{s:7:"colspan";R:284;s:7:"rowspan";R:284;s:5:"scope";R:284;}s:11:"filterChain";R:286;s:12:"nestingLimit";i:10;s:5:"rules";R:589;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";R:612;}s:10:"html:thead";R:616;s:7:"html:tr";R:622;s:6:"html:u";R:350;s:7:"html:ul";R:738;}}');
	}

	/**
	* {@inheritdoc}
	*/
	public static function getRenderer()
	{
		return unserialize('O:42:"s9e\\TextFormatter\\Bundles\\Fatdown\\Renderer":2:{s:19:"enableQuickRenderer";b:1;s:9:"' . "\0" . '*' . "\0" . 'params";a:2:{s:16:"MEDIAEMBED_THEME";s:0:"";s:18:"TASKLISTS_EDITABLE";s:0:"";}}');
	}
}