<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2019 The s9e Authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Bundles;

abstract class Forum extends \s9e\TextFormatter\Bundle
{
	/**
	* @var s9e\TextFormatter\Parser Singleton instance used by parse()
	*/
	protected static $parser;

	/**
	* @var s9e\TextFormatter\Renderer Singleton instance used by render()
	*/
	protected static $renderer;

	/**
	* {@inheritdoc}
	*/
	public static function getJS()
	{
		return '(function(){var r=[""],aa=[0,257],ba=["","t"],t=[128,256],ca={flags:2},v=["","id"],da={flags:514},ea=[65413,257],w=[65431,257],fa=[27395,257],ha=[65288,257],x={flags:3089},ia=["","track_id"],ja=["","album_id"],ka=["","playlist_id"],y={c:[],o:!1},A={B:1,COLOR:1,EMAIL:1,FONT:1,I:1,S:1,SIZE:1,U:1,URL:1},E=[function(a,b){var c={},d;for(d in b.b){var h=b.b[d],f=!1;if(d in a.b){f=h.c;var m=d,n=a.b[d];B.f=m;for(var l=0;l<f.length&&(n=f[l](n,m),!1!==n);++l);delete B.f;f=n}!1!==f?c[d]=f:h.o&&C(a)}D(a,c)}],ma=[function(a){return la(a,
/^[-0-9A-Za-z_]+$/)}],na={c:[function(a){var b=/^(?=\\d)(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?$/.exec(a);return b?3600*(b[1]||0)+60*(b[2]||0)+(+b[3]||0):/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],o:!1},oa={c:[function(a){return/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],o:!1},pa={p:A,flags:256,q:A},qa={p:A,flags:3456,q:A},ra={c:ma,o:!1},sa={c:ma,o:!0},wa={c:[function(a){var b=F.urlConfig,c=B,d=ta(a.replace(/^\\s+/,"").replace(/\\s+$/,""));(b=ua(b,d))?(c&&(d.attrValue=a,c.add("err",b,d)),a=!1):a=va(d);return a}],o:!0},ya={e:ea,
b:{},j:0,c:E,g:10,d:ca,h:5E3},H={e:t,b:{id:y},j:2,c:E,g:10,d:x,h:5E3},za={e:ha,b:{},j:1,c:E,g:10,d:qa,h:5E3},Aa={e:w,b:{align:{c:[function(a){return a.toLowerCase()},function(a){return la(a,/^(?:center|justify|left|right)$/)}],o:!1},colspan:oa,rowspan:oa},j:5,c:E,g:10,d:{p:{B:1,COLOR:1,EMAIL:1,FONT:1,I:1,S:1,SIZE:1,TD:1,TH:1,U:1,URL:1},flags:256,q:A},h:5E3},Ba=\'<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"><xsl:output method="html" encoding="utf-8" indent="no"/><xsl:param$nL_HIDE">Hide</xsl:param><xsl:param$nL_SHOW">Show</xsl:param><xsl:param$nL_SPOILER">Spoiler</xsl:param><xsl:param$nL_WROTE">wrote:</xsl:param>$bB|I|LI|OL|S|TABLE|TR|U|UL|p"><xsl:element$n{translate(name(),\\\'ABEILORSTU\\\',\\\'abeilorstu\\\')}">$i</xsl:element>$g$bBANDCAMP"><$t$jbandcamp"$k$e400px"><$t$k$a100%">$f$k$d><$l$nsrc">//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/<$r><$s$m@album_id">album=$c@album_id"/><$u$m@track_num">/t=$c@track_num"/></$u></$s><$p>track=$c@track_id"/></$p></$r></$l></iframe></$t></$t>$g$bCENTER"><div$ktext-align:center">$i</div>$g$bCODE"><pre data-s9e-livepreview-hash="" data-s9e-livepreview-onupdate="if(typeof hljsLoader!==\\\'undefined\\\')hljsLoader.highlightBlocks(this)"><code><$u$m@lang"><$l$nclass">language-$c@lang"/></$l></$u>$i</code></pre><script async="" crossorigin="anonymous" data-hljs-style="github-gist" data-s9e-livepreview-onrender="if(typeof hljsLoader!==\\\'undefined\\\')this.parentNode.removeChild(this)" integrity="sha384-fiUfbVu5WfS+y/0EiW3QpI0iZScy4ET77WKz9f0dGwHGgLNQz6pQa8AdSi8Y59ZZ"$whttps://cdn.jsdelivr.net/gh/s9e/hljs-loader@1.0.1/loader.min.js"/>$g$bCOLOR"><$t$kcolor:{@color}">$i</$t>$g$bDAILYMOTION"><$t$jdailymotion"$k$e640px"><$t$k$a56.25%">$f$k$d><$l$nsrc">//www.dailymotion.com/embed/video/$c@id"/><$u$m@t">?start=$c@t"/></$u></$l></iframe></$t></$t>$g$bEMAIL"><a href="mailto:{@email}">$i</a>$g$bEMOJI"><img alt="{.}"$zemoji" draggable="false"$whttps://twemoji.maxcdn.com/2/svg/{@tseq}.svg"/>$g$bFACEBOOK"><iframe$jfacebook"$v"$q$y onload="$h$xno"$whttps://s9e.github.io/iframe/2/facebook.min.html#{@type}{@id}"$kborder:0;height:360px;max-width:640px;width:100%"/>$g$bFONT"><$t$kfont-family:{@font}">$i</$t>$g$bIMG"><img$w{@src}" title="{@title}" alt="{@alt}">$oheight|@width"/></img>$g$bINDIEGOGO"><$t$jindiegogo"$k$e222px"><$t$k$a200.45045%">$f$w//www.indiegogo.com/project/{@id}/embedded"$k$d/></$t></$t>$g$bINSTAGRAM"><iframe$jinstagram"$v"$q$y onload="$h$xno"$whttps://s9e.github.io/iframe/2/instagram.min.html#{@id}"$kbackground:url(https://www.instagram.com/static/images/ico/favicon.svg/fc72dd4bfde8.svg) no-repeat 50% 50% / 50%;border:0;height:540px;max-width:540px;width:100%"/>$g$bKICKSTARTER"><$t$jkickstarter"><$r><$s$m@video"><$l$n$y>$e640px</$l><$t$k$a56.25%">$f$w//www.kickstarter.com/projects/{@id}/widget/video.html"$k$d/></$t></$s><$p><$l$n$y>$e220px</$l><$t$k$a190.909091%">$f$w//www.kickstarter.com/projects/{@id}/widget/card.html"$k$d/></$t></$p></$r></$t>$g$bLIST"><$r><$s$mnot(@type)"><ul>$i</ul></$s><$s$mstarts-with(@type,\\\'decimal\\\')or starts-with(@type,\\\'lower\\\')or starts-with(@type,\\\'upper\\\')"><ol$klist-style-type:{@type}">$ostart"/>$i</ol></$s><$p><ul$klist-style-type:{@type}">$i</ul></$p></$r>$g$bLIVELEAK"><$t$jliveleak"$k$e640px"><$t$k$a56.25%">$f$w//www.liveleak.com/e/{@id}"$k$d/></$t></$t>$g$bQUOTE"><blockquote><$u$mnot(@author)"><$l$nclass">uncited</$l></$u><div><$u$m@author"><cite>$c@author"/><xsl:text> </xsl:text>$c$L_WROTE"/></cite></$u>$i</div></blockquote>$g$bSIZE"><$t$kfont-size:{@size}px">$i</$t>$g$bSOUNDCLOUD"><iframe$jsoundcloud"$v"$xno"><$l$nsrc">https://w.soundcloud.com/player/?url=<$r><$s$m@playlist_id">https%3A//api.soundcloud.com/playlists/$c@playlist_id"/></$s><$s$m@track_id">https%3A//api.soundcloud.com/tracks/$c@track_id"/>&amp;secret_token=$c@secret_token"/></$s><$p><$u$mnot(contains(@id,\\\'://\\\'))">https%3A//soundcloud.com/</$u>$c@id"/></$p></$r></$l><$l$n$y>border:0;height:<$r><$s$m@playlist_id or contains(@id,\\\'/sets/\\\')">450</$s><$p>166</$p></$r>px;max-width:900px;width:100%</$l></iframe>$g$bSPOILER"><div$zspoiler"><div$zspoiler-header"><button onclick="var a=parentNode.nextSibling.style,b=firstChild.style,c=lastChild.style;b.display=a.display;a.display=c.display=(b.display)?\\\'\\\':\\\'none\\\';return!1"><$t>$c$L_SHOW"/></$t><$t$kdisplay:none">$c$L_HIDE"/></$t></button><$t$zspoiler-title">$c$L_SPOILER"/><xsl:text> </xsl:text>$c@title"/></$t></div><div$zspoiler-content"$kdisplay:none">$i</div></div>$g$bTD"><td>$ocol$t|@row$t"/><$u$m@align"><$l$n$y>text-align:$c@align"/></$l></$u>$i</td>$g$bTH"><th>$ocol$t|@row$t"/><$u$m@align"><$l$n$y>text-align:$c@align"/></$l></$u>$i</th>$g$bTWITCH"><$t$jtwitch"$k$e640px"><$t$k$a56.25%">$f$k$d><$l$nsrc">//<$r><$s$m@clip_id">clips.twitch.tv/embed?autoplay=false&amp;clip=<$u$m@channel">$c@channel"/>/</$u>$c@clip_id"/></$s><$p>player.twitch.tv/?autoplay=false&amp;<$r><$s$m@video_id">video=v$c@video_id"/></$s><$p>channel=$c@channel"/></$p></$r><$u$m@t">&amp;time=$c@t"/></$u></$p></$r></$l></iframe></$t></$t>$g$bTWITTER"><iframe$jtwitter" allow="autoplay *"$v"$q$y onload="$h$xno"$whttps://s9e.github.io/iframe/2/twitter.min.html#{@id}"$kbackground:url(https://abs.twimg.com/favicons/favicon.ico) no-repeat 50% 50%;border:0;height:250px;max-width:500px;width:100%"/>$g$bURL"><a href="{@url}">$otitle"/>$i</a>$g$bVIMEO"><$t$jvimeo"$k$e640px"><$t$k$a56.25%">$f$k$d><$l$nsrc">//player.vimeo.com/video/$c@id"/><$u$m@t">#t=$c@t"/></$u></$l></iframe></$t></$t>$g$bVINE"><$t$jvine"$k$e480px"><$t$k$a100%">$f$whttps://vine.co/v/{@id}/embed/simple?audio=1"$k$d/></$t></$t>$g$bWSHH"><$t$jwshh"$k$e640px"><$t$k$a56.25%">$f$w//www.worldstarhiphop.com/embed/{@id}"$k$d/></$t></$t>$g$bYOUTUBE"><$t$jyoutube"$k$e640px"><$t$k$a56.25%">$f$kbackground:url(https://i.ytimg.com/vi/{@id}/hqdefault.jpg) 50% 50% / cover;$d><$l$nsrc">https://www.youtube.com/embed/$c@id"/><$u$m@list">?list=$c@list"/></$u><$u$m@t"><$r><$s$m@list">&amp;</$s><$p>?</$p></$r>start=$c@t"/></$u></$l></iframe></$t></$t>$g$bbr"><br/>$g$be|i|s"/></xsl:stylesheet>\'.replace(/\\$[a-z]/g,
function(a){return{$a:"display:block;overflow:hidden;position:relative;padding-bottom:",$b:\'<xsl:template match="\',$c:\'<xsl:value-of select="\',$d:\'border:0;height:100%;left:0;position:absolute;width:100%"\',$e:"display:inline-block;width:100%;max-width:",$f:\'<iframe allowfullscreen="" scrolling="no"\',$g:"</xsl:template>",$h:"var c=new MessageChannel;c.port1.onmessage=function(e){{style.height=e.data+\'px\'}};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])\\"",$i:"<xsl:apply-templates/>",
$j:\' data-s9e-mediaembed="\',$k:\' style="\',$l:"xsl:attribute",$m:\' test="\',$n:\' name="\',$o:\'<xsl:copy-of select="@\',$p:"xsl:otherwise",$q:\' data-s9e-livepreview-ignore-attrs="\',$r:"xsl:choose",$s:"xsl:when",$t:"span",$u:"xsl:if",$v:\' allowfullscreen="\',$w:\' src="\',$x:\' scrolling="\',$y:\'style"\',$z:\' class="\'}[a]});
function Ca(a){var b=B;if(!/^(?:0|-?[1-9]\\d*)$/.test(a))return!1;a=parseInt(a,10);return 8>a?(b&&b.add("warn","Value outside of range, adjusted up to min value",{attrValue:a,min:8,max:36}),8):36<a?(b&&b.add("warn","Value outside of range, adjusted down to max value",{attrValue:a,min:8,max:36}),36):a}function la(a,b){return b.test(a)?a:!1}
function ta(a){var b=/^(?:([a-z][-+.\\w]*):)?(?:\\/\\/(?:([^:\\/?#]*)(?::([^\\/?#]*)?)?@)?(?:(\\[[a-f\\d:]+\\]|[^:\\/?#]+)(?::(\\d*))?)?(?![^\\/?#]))?([^?#]*)(\\?[^#]*)?(#.*)?$/i.exec(a),c={};"scheme user pass host port path query fragment".split(" ").forEach(function(d,h){c[d]=""<b[h+1]?b[h+1]:""});c.scheme=c.scheme.toLowerCase();c.host=c.host.replace(/[\\u3002\\uff0e\\uff61]/g,".").replace(/\\.+$/g,"");/[^\\x00-\\x7F]/.test(c.host)&&"undefined"!==typeof punycode&&(c.host=punycode.toASCII(c.host));return c}
function va(a){var b="";""!==a.scheme&&(b+=a.scheme+":");""!==a.host?(b+="//",""!==a.user&&(b+=Da(decodeURIComponent(a.user)),""!==a.pass&&(b+=":"+Da(decodeURIComponent(a.pass))),b+="@"),b+=a.host,""!==a.port&&(b+=":"+a.port)):"file"===a.scheme&&(b+="//");var c=a.path+a.query+a.fragment;c=c.replace(/%.?[a-f]/g,function(d){return d.toUpperCase()},c);b+=c.replace(/[^\\u0020-\\u007E]+/g,encodeURIComponent).replace(/%(?![0-9A-Fa-f]{2})|[^!#-&*-;=?-Z_a-z~]/g,escape);a.scheme||(b=b.replace(/^([^\\/]*):/,"$1%3A"));
return b}
function ua(a,b){if(""!==b.scheme&&!a.M.test(b.scheme))return"URL scheme is not allowed";if(""!==b.host){var c;if(c=!/^(?!-)[-a-z0-9]{0,62}[a-z0-9](?:\\.(?!-)[-a-z0-9]{0,62}[a-z0-9])*$/i.test(b.host)){a:if(c=b.host,/^\\d+\\.\\d+\\.\\d+\\.\\d+$/.test(c))for(var d=4,h=c.split(".");0<=--d;){if("0"===h[d][0]||255<h[d]){c=!1;break a}}else c=!1;if(c=!c)c=b.host.replace(/^\\[(.*)\\]$/,"$1",b.host),c=!(/^([\\da-f]{0,4}:){2,7}(?:[\\da-f]{0,4}|\\d+\\.\\d+\\.\\d+\\.\\d+)$/.test(c)&&c)}if(c)return"URL host is invalid";if(a.N&&
a.N.test(b.host)||a.Q&&!a.Q.test(b.host))return"URL host is not allowed"}else if(/^(?:(?:f|ht)tps?)$/.test(b.scheme))return"Missing host"}function Ea(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;",\'"\':"&quot;"};return a.replace(/[<>&"]/g,function(c){return b[c]})}function Fa(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;"};return a.replace(/[<>&]/g,function(c){return b[c]})}function Da(a){return encodeURIComponent(a).replace(/[!\'()*]/g,function(b){return"%"+b.charCodeAt(0).toString(16).toUpperCase()})}
function Ga(){this.m={};this.n=[]}Ga.prototype.add=function(a,b,c){c=c||{};"attrName"in c||!this.f||(c.attrName=this.f);"tag"in c||!this.k||(c.tag=this.k);this.m[a]&&this.m[a].forEach(function(d){d(b,c)});this.n.push([a,b,c])};Ga.prototype.getLogs=function(){return this.n};Ga.prototype.on=function(a,b){this.m[a].push(b)};function Ha(a,b){B.add("debug",a,b)}function Ia(a,b,c,d,h){this.k=+a;this.name=b;this.f=+c;this.m=+d;this.v=+h||0;this.b={};this.J=[];isNaN(a+c+d)&&C(this)}Ia.prototype.n=!1;
function Ja(a,b){a.J.push(b);a.n&&C(b)}function C(a){a.n||(a.n=!0,a.J.forEach(function(b){C(b)}))}function K(a,b){a.name===b.name&&(1===a.k&&2===b.k&&b.f>=a.f?(a.s=b,b.F=a,Ja(a,b)):2===a.k&&1===b.k&&b.f<=a.f&&(a.F=b,b.s=a))}function Ka(a){var b={},c;for(c in a.b)b[c]=a.b[c];return b}function La(a,b){return a.n||a.name!==b.name||1!==b.k||2!==a.k||a.f<b.f||a.F&&a.F!==b||b.s&&b.s!==a?!1:!0}function D(a,b){a.b={};for(var c in b)a.b[c]=b[c]}
var Ma,Na,M,N,O,Oa,B=new Ga,P,Q,S={Autoemail:{y:function(a,b){b.forEach(function(c){var d=R(1,"EMAIL",c[0][1],0,0);d.b.email=c[0][0];c=R(2,"EMAIL",c[0][1]+c[0][0].length,0,0);K(d,c)})},z:"@",C:/\\b[-a-z0-9_+.]+@[-a-z0-9.]*[a-z0-9]/ig,D:5E4},Autolink:{y:function(a,b){b.forEach(function(c){var d=c[0][1],h=c[0][0].replace(/(?![-=\\/)])[\\s!-.:-@[-`{-~]+$/,"");if(/^www\\.|^[^:]+:/i.test(h)){var f=d+h.length,m=R(2,"URL",f,0,0);"."===h[3]&&(h="http://"+h);c=R(1,"URL",d,0,1);c.b.url=h;K(c,m);d=R(3,"v",d,f-d,
1E3);Ja(c,d)}})},z:"://",C:/\\bhttps?:\\/\\/\\S(?:[^\\s()\\[\\]\\uFF01-\\uFF0F\\uFF1A-\\uFF20\\uFF3B-\\uFF40\\uFF5B-\\uFF65]|\\([^\\s()]*\\)|\\[\\w*\\])+/ig,D:5E4},BBCodes:{y:function(a,b){function c(){var q=R(3,e.w||g,z,k-z,0);D(q,l);return q}function d(){var q=R(1,e.w||g,z,k-z,0);D(q,l);return q}function h(){G||(G=a.toUpperCase());var q="[/"+g+p+"]",u=G.indexOf(q,k);return 0>u?null:R(2,e.w||g,u,q.length,0)}function f(){var q=k;for(l={};k<I;){var u=a[k];if(-1<" \\n\\t".indexOf(u))++k;else{if(-1<"/]".indexOf(u))break;var L=
/^[-\\w]*/.exec(a.substr(k,100))[0].length;if(L){u=a.substr(k,L).toLowerCase();k+=L;if(k>=I)throw"";if("="!==a[k])continue}else if("="===u&&k===q)u=e.r||g.toLowerCase();else throw"";if(++k>=I)throw"";L=l;if(\'"\'===a[k]||"\'"===a[k]){var J=a[k];var Va=k+1;do{k=a.indexOf(J,k+1);if(0>k)throw"";for(var xa=1;"\\\\"===a[k-xa];)++xa}while(0===xa%2);J=a.substr(Va,k-Va);-1<J.indexOf("\\\\")&&(J=J.replace(/\\\\([\\\\\'"])/g,"$1"));++k}else J=/(?:[^\\s\\]]|[ \\t](?!\\s*(?:[-\\w]+=|\\/?\\])))*/.exec(a.substr(k))[0],k+=J.length;
L[u]=J}}}function m(){p="";":"===a[k]&&(p=/^:\\d*/.exec(a.substr(k))[0],k+=p.length);if("/"===a[z+1])"]"===a[k]&&""===p&&(++k,R(2,e.w||g,z,k-z,0));else{f();if(e.L)for(var q in e.L)q in l||(l[q]=e.L[q]);if("]"===a[k]){++k;var u=[];e.l&&e.l.forEach(function(J){J in l||u.push(J)});var L=(q=p||e.R)||u.length?h():null;if(L)u.forEach(function(J){l[J]=a.substr(k,L.f-k)});else if(q)return;q=d();L&&K(q,L)}else"/]"===a.substr(k,2)&&(k+=2,c())}}var n={"*":{w:"LI"},B:[],BANDCAMP:{l:["id","url"]},CENTER:[],CODE:{r:"lang"},
COLOR:[],DAILYMOTION:{l:["id","url"]},EMAIL:{l:["email"]},FACEBOOK:{l:["id","url"]},FONT:[],I:[],IMG:{l:["src"],r:"src"},INDIEGOGO:{l:["id","url"]},INSTAGRAM:{l:["id","url"]},KICKSTARTER:{l:["id","url"]},LI:[],LIST:{r:"type"},LIVELEAK:{l:["id","url"]},MEDIA:{l:["url"]},OL:[],QUOTE:{r:"author"},S:[],SIZE:[],SOUNDCLOUD:{l:["id","url"]},SPOILER:{r:"title"},TABLE:[],TD:{r:"align"},TH:{r:"align"},TR:[],TWITCH:{l:["id","url"]},TWITTER:{l:["id","url"]},U:[],UL:[],URL:{l:["url"]},VIMEO:{l:["id","url"]},VINE:{l:["id",
"url"]},WSHH:{l:["id","url"]},YOUTUBE:{l:["id","url"]}},l,e,g,p,k,z,I=a.length,G="";b.forEach(function(q){g=q[1][0].toUpperCase();if(g in n){e=n[g];z=q[0][1];k=z+q[0][0].length;try{m()}catch(u){}}})},z:"[",C:/\\[\\/?(\\*|[-\\w]+)(?=[\\]\\s=:\\/])/g,D:5E4},Emoji:{y:function(a){function b(m,n,l){m=R(3,d.w,m,n,10);m.b.seq=l.replace(/-(?:200d|fe0f)/g,"");l=l.replace(/^0+/,"");0>l.indexOf("-200d")&&(l=l.replace(/-fe0f/g,""));m.b.tseq=l}function c(m){var n=[],l=0;do{var e=m.charCodeAt(l);55296<=e&&56319>=e&&(e=
(e<<10)+m.charCodeAt(++l)-56613888);n.push(("000"+e.toString(16)).replace(/^0+(.{4,})$/,"$1"))}while(++l<m.length);return n.join("-")}var d={G:/(?::(?:[()?DPop|]|-[(-*?DPp|])|;-?[)Pp])/g,w:"EMOJI"},h=/:[-+_a-z0-9]+(?=:)/g,f=/(?:[#*0-9]\\ufe0f\\u20e3?|[\\xa9\\xae\\u203c\\u2049\\u2122\\u2139\\u2194-\\u2199\\u21a9\\u21aa\\u2328\\u23cf\\u23ed-\\u23ef\\u23f1\\u23f2\\u23f8-\\u23fa\\u24c2\\u25aa\\u25ab\\u25b6\\u25c0\\u25fb\\u25fc\\u2600-\\u2604\\u260e\\u2611\\u2618\\u2620\\u2622\\u2623\\u2626\\u262a\\u262e\\u262f\\u2638-\\u263a\\u2640\\u2642\\u265f\\u2660\\u2663\\u2665\\u2666\\u2668\\u267b\\u267e\\u2692\\u2694-\\u2697\\u2699\\u269b\\u269c\\u26a0\\u26b0\\u26b1\\u26c8\\u26cf\\u26d1\\u26d3\\u26e9\\u26f0\\u26f1\\u26f4\\u26f7\\u26f8\\u2702\\u2708\\u2709\\u270f\\u2712\\u2714\\u2716\\u271d\\u2721\\u2733\\u2734\\u2744\\u2747\\u2763\\u2764\\u27a1\\u2934\\u2935\\u2b05-\\u2b07\\u3030\\u303d\\u3297\\u3299]\\ufe0f|[\\u261d\\u270c\\u270d](?:\\ufe0f|\\ud83c[\\udffb-\\udfff])|[\\u270a\\u270b](?:\\ud83c[\\udffb-\\udfff])?|[\\u231a\\u231b\\u23e9-\\u23ec\\u23f0\\u23f3\\u25fd\\u25fe\\u2614\\u2615\\u2648-\\u2653\\u267f\\u2693\\u26a1\\u26aa\\u26ab\\u26bd\\u26be\\u26c4\\u26c5\\u26ce\\u26d4\\u26ea\\u26f2\\u26f3\\u26f5\\u26fa\\u26fd\\u2705\\u2728\\u274c\\u274e\\u2753-\\u2755\\u2757\\u2795-\\u2797\\u27b0\\u27bf\\u2b1b\\u2b1c\\u2b50\\u2b55]|\\u26f9(?:\\ufe0f|\\ud83c[\\udffb-\\udfff])(?:\\u200d[\\u2640\\u2642]\\ufe0f)?|\\ud83c(?:[\\udd70\\udd71\\udd7e\\udd7f\\ude02\\ude37\\udf21\\udf24-\\udf2c\\udf36\\udf7d\\udf96\\udf97\\udf99-\\udf9b\\udf9e\\udf9f\\udfcd\\udfce\\udfd4-\\udfdf\\udff5\\udff7]\\ufe0f|[\\udde6-\\uddff](?:\\ud83c[\\udde6-\\uddff])?|[\\udf85\\udfc2\\udfc7](?:\\ud83c[\\udffb-\\udfff])?|[\\udfc3\\udfc4\\udfca](?:\\ud83c[\\udffb-\\udfff])?(?:\\u200d[\\u2640\\u2642]\\ufe0f)?|[\\udfcb\\udfcc](?:\\ufe0f|\\ud83c[\\udffb-\\udfff])(?:\\u200d[\\u2640\\u2642]\\ufe0f)?|[\\udc04\\udccf\\udd8e\\udd91-\\udd9a\\ude01\\ude1a\\ude2f\\ude32-\\ude36\\ude38-\\ude3a\\ude50\\ude51\\udf00-\\udf20\\udf2d-\\udf35\\udf37-\\udf7c\\udf7e-\\udf84\\udf86-\\udf93\\udfa0-\\udfc1\\udfc5\\udfc6\\udfc8\\udfc9\\udfcf-\\udfd3\\udfe0-\\udff0\\udff8-\\udfff]|\\udff3\\ufe0f(?:\\u200d\\ud83c\\udf08)?|\\udff4(?:\\u200d\\u2620\\ufe0f|\\udb40\\udc67\\udb40\\udc62\\udb40(?:\\udc65\\udb40\\udc6e\\udb40\\udc67|\\udc73\\udb40\\udc63\\udb40\\udc74|\\udc77\\udb40\\udc6c\\udb40\\udc73)\\udb40\\udc7f)?)|\\ud83d(?:[\\udc3f\\udcfd\\udd49\\udd4a\\udd6f\\udd70\\udd73\\udd76-\\udd79\\udd87\\udd8a-\\udd8d\\udda5\\udda8\\uddb1\\uddb2\\uddbc\\uddc2-\\uddc4\\uddd1-\\uddd3\\udddc-\\uddde\\udde1\\udde3\\udde8\\uddef\\uddf3\\uddfa\\udecb\\udecd-\\udecf\\udee0-\\udee5\\udee9\\udef0\\udef3]\\ufe0f|[\\udc42\\udc43\\udc46-\\udc50\\udc66\\udc67\\udc6b-\\udc6d\\udc70\\udc72\\udc74-\\udc76\\udc78\\udc7c\\udc83\\udc85\\udcaa\\udd7a\\udd95\\udd96\\ude4c\\ude4f\\udec0\\udecc](?:\\ud83c[\\udffb-\\udfff])?|[\\udc6e\\udc71\\udc73\\udc77\\udc81\\udc82\\udc86\\udc87\\ude45-\\ude47\\ude4b\\ude4d\\ude4e\\udea3\\udeb4-\\udeb6](?:\\ud83c[\\udffb-\\udfff])?(?:\\u200d[\\u2640\\u2642]\\ufe0f)?|[\\udd74\\udd90](?:\\ufe0f|\\ud83c[\\udffb-\\udfff])|[\\udc00-\\udc14\\udc16-\\udc3e\\udc40\\udc44\\udc45\\udc51-\\udc65\\udc6a\\udc79-\\udc7b\\udc7d-\\udc80\\udc84\\udc88-\\udca9\\udcab-\\udcfc\\udcff-\\udd3d\\udd4b-\\udd4e\\udd50-\\udd67\\udda4\\uddfb-\\ude44\\ude48-\\ude4a\\ude80-\\udea2\\udea4-\\udeb3\\udeb7-\\udebf\\udec1-\\udec5\\uded0-\\uded2\\uded5\\udeeb\\udeec\\udef4-\\udefa\\udfe0-\\udfeb]|\\udc15(?:\\u200d\\ud83e\\uddba)?|\\udc41\\ufe0f(?:\\u200d\\ud83d\\udde8\\ufe0f)?|\\udc68(?:\\u200d(?:[\\u2695\\u2696\\u2708]\\ufe0f|\\u2764\\ufe0f\\u200d\\ud83d(?:\\udc8b\\u200d\\ud83d)?\\udc68|\\ud83c[\\udf3e\\udf73\\udf93\\udfa4\\udfa8\\udfeb\\udfed]|\\ud83d(?:[\\udc68\\udc69]\\u200d\\ud83d(?:\\udc66(?:\\u200d\\ud83d\\udc66)?|\\udc67(?:\\u200d\\ud83d[\\udc66\\udc67])?)|[\\udcbb\\udcbc\\udd27\\udd2c\\ude80\\ude92]|\\udc66(?:\\u200d\\ud83d\\udc66)?|\\udc67(?:\\u200d\\ud83d[\\udc66\\udc67])?)|\\ud83e[\\uddaf-\\uddb3\\uddbc\\uddbd])|\\ud83c(?:\\udffb(?:\\u200d(?:[\\u2695\\u2696\\u2708]\\ufe0f|\\ud83c[\\udf3e\\udf73\\udf93\\udfa4\\udfa8\\udfeb\\udfed]|\\ud83d[\\udcbb\\udcbc\\udd27\\udd2c\\ude80\\ude92]|\\ud83e(?:[\\uddaf-\\uddb3\\uddbc\\uddbd]|\\udd1d\\u200d\\ud83d\\udc68\\ud83c[\\udffc-\\udfff])))?|\\udffc(?:\\u200d(?:[\\u2695\\u2696\\u2708]\\ufe0f|\\ud83c[\\udf3e\\udf73\\udf93\\udfa4\\udfa8\\udfeb\\udfed]|\\ud83d[\\udcbb\\udcbc\\udd27\\udd2c\\ude80\\ude92]|\\ud83e(?:[\\uddaf-\\uddb3\\uddbc\\uddbd]|\\udd1d\\u200d\\ud83d\\udc68\\ud83c[\\udffb\\udffd-\\udfff])))?|\\udffd(?:\\u200d(?:[\\u2695\\u2696\\u2708]\\ufe0f|\\ud83c[\\udf3e\\udf73\\udf93\\udfa4\\udfa8\\udfeb\\udfed]|\\ud83d[\\udcbb\\udcbc\\udd27\\udd2c\\ude80\\ude92]|\\ud83e(?:[\\uddaf-\\uddb3\\uddbc\\uddbd]|\\udd1d\\u200d\\ud83d\\udc68\\ud83c[\\udffb\\udffc\\udffe\\udfff])))?|\\udffe(?:\\u200d(?:[\\u2695\\u2696\\u2708]\\ufe0f|\\ud83c[\\udf3e\\udf73\\udf93\\udfa4\\udfa8\\udfeb\\udfed]|\\ud83d[\\udcbb\\udcbc\\udd27\\udd2c\\ude80\\ude92]|\\ud83e(?:[\\uddaf-\\uddb3\\uddbc\\uddbd]|\\udd1d\\u200d\\ud83d\\udc68\\ud83c[\\udffb-\\udffd\\udfff])))?|\\udfff(?:\\u200d(?:[\\u2695\\u2696\\u2708]\\ufe0f|\\ud83c[\\udf3e\\udf73\\udf93\\udfa4\\udfa8\\udfeb\\udfed]|\\ud83d[\\udcbb\\udcbc\\udd27\\udd2c\\ude80\\ude92]|\\ud83e(?:[\\uddaf-\\uddb3\\uddbc\\uddbd]|\\udd1d\\u200d\\ud83d\\udc68\\ud83c[\\udffb-\\udffe])))?))?|\\udc69(?:\\u200d(?:[\\u2695\\u2696\\u2708]\\ufe0f|\\u2764\\ufe0f\\u200d\\ud83d(?:\\udc8b\\u200d\\ud83d)?[\\udc68\\udc69]|\\ud83c[\\udf3e\\udf73\\udf93\\udfa4\\udfa8\\udfeb\\udfed]|\\ud83d(?:[\\udcbb\\udcbc\\udd27\\udd2c\\ude80\\ude92]|\\udc66(?:\\u200d\\ud83d\\udc66)?|\\udc67(?:\\u200d\\ud83d[\\udc66\\udc67])?|\\udc69\\u200d\\ud83d(?:\\udc66(?:\\u200d\\ud83d\\udc66)?|\\udc67(?:\\u200d\\ud83d[\\udc66\\udc67])?))|\\ud83e[\\uddaf-\\uddb3\\uddbc\\uddbd])|\\ud83c(?:\\udffb(?:\\u200d(?:[\\u2695\\u2696\\u2708]\\ufe0f|\\ud83c[\\udf3e\\udf73\\udf93\\udfa4\\udfa8\\udfeb\\udfed]|\\ud83d[\\udcbb\\udcbc\\udd27\\udd2c\\ude80\\ude92]|\\ud83e(?:[\\uddaf-\\uddb3\\uddbc\\uddbd]|\\udd1d\\u200d\\ud83d[\\udc68\\udc69]\\ud83c[\\udffc-\\udfff])))?|\\udffc(?:\\u200d(?:[\\u2695\\u2696\\u2708]\\ufe0f|\\ud83c[\\udf3e\\udf73\\udf93\\udfa4\\udfa8\\udfeb\\udfed]|\\ud83d[\\udcbb\\udcbc\\udd27\\udd2c\\ude80\\ude92]|\\ud83e(?:[\\uddaf-\\uddb3\\uddbc\\uddbd]|\\udd1d\\u200d\\ud83d[\\udc68\\udc69]\\ud83c[\\udffb\\udffd-\\udfff])))?|\\udffd(?:\\u200d(?:[\\u2695\\u2696\\u2708]\\ufe0f|\\ud83c[\\udf3e\\udf73\\udf93\\udfa4\\udfa8\\udfeb\\udfed]|\\ud83d[\\udcbb\\udcbc\\udd27\\udd2c\\ude80\\ude92]|\\ud83e(?:[\\uddaf-\\uddb3\\uddbc\\uddbd]|\\udd1d\\u200d\\ud83d[\\udc68\\udc69]\\ud83c[\\udffb\\udffc\\udffe\\udfff])))?|\\udffe(?:\\u200d(?:[\\u2695\\u2696\\u2708]\\ufe0f|\\ud83c[\\udf3e\\udf73\\udf93\\udfa4\\udfa8\\udfeb\\udfed]|\\ud83d[\\udcbb\\udcbc\\udd27\\udd2c\\ude80\\ude92]|\\ud83e(?:[\\uddaf-\\uddb3\\uddbc\\uddbd]|\\udd1d\\u200d\\ud83d[\\udc68\\udc69]\\ud83c[\\udffb-\\udffd\\udfff])))?|\\udfff(?:\\u200d(?:[\\u2695\\u2696\\u2708]\\ufe0f|\\ud83c[\\udf3e\\udf73\\udf93\\udfa4\\udfa8\\udfeb\\udfed]|\\ud83d[\\udcbb\\udcbc\\udd27\\udd2c\\ude80\\ude92]|\\ud83e(?:[\\uddaf-\\uddb3\\uddbc\\uddbd]|\\udd1d\\u200d\\ud83d[\\udc68\\udc69]\\ud83c[\\udffb-\\udffe])))?))?|\\udc6f(?:\\u200d[\\u2640\\u2642]\\ufe0f)?|\\udd75(?:\\ufe0f|\\ud83c[\\udffb-\\udfff])(?:\\u200d[\\u2640\\u2642]\\ufe0f)?)|\\ud83e(?:[\\udd0f\\udd18-\\udd1c\\udd1e\\udd1f\\udd30-\\udd36\\uddb5\\uddb6\\uddbb\\uddd2-\\uddd5](?:\\ud83c[\\udffb-\\udfff])?|[\\udd26\\udd37-\\udd39\\udd3d\\udd3e\\uddb8\\uddb9\\uddcd-\\uddcf\\uddd6-\\udddd](?:\\ud83c[\\udffb-\\udfff])?(?:\\u200d[\\u2640\\u2642]\\ufe0f)?|[\\udd3c\\uddde\\udddf](?:\\u200d[\\u2640\\u2642]\\ufe0f)?|[\\udd0d\\udd0e\\udd10-\\udd17\\udd1d\\udd20-\\udd25\\udd27-\\udd2f\\udd3a\\udd3f-\\udd45\\udd47-\\udd71\\udd73-\\udd76\\udd7a-\\udda2\\udda5-\\uddaa\\uddae-\\uddb4\\uddb7\\uddba\\uddbc-\\uddca\\uddd0\\udde0-\\uddff\\ude70-\\ude73\\ude78-\\ude7a\\ude80-\\ude82\\ude90-\\ude95]|\\uddd1(?:\\u200d(?:[\\u2695\\u2696\\u2708]\\ufe0f|\\ud83c[\\udf3e\\udf73\\udf93\\udfa4\\udfa8\\udfeb\\udfed]|\\ud83d[\\udcbb\\udcbc\\udd27\\udd2c\\ude80\\ude92]|\\ud83e(?:[\\uddaf-\\uddb3\\uddbc\\uddbd]|\\udd1d\\u200d\\ud83e\\uddd1))|\\ud83c[\\udffb-\\udfff](?:\\u200d(?:[\\u2695\\u2696\\u2708]\\ufe0f|\\ud83c[\\udf3e\\udf73\\udf93\\udfa4\\udfa8\\udfeb\\udfed]|\\ud83d[\\udcbb\\udcbc\\udd27\\udd2c\\ude80\\ude92]|\\ud83e(?:[\\uddaf-\\uddb3\\uddbc\\uddbd]|\\udd1d\\u200d\\ud83e\\uddd1\\ud83c[\\udffb-\\udfff])))?)?))(?!\\ufe0e)\\ufe0f?/g;
(function(m){var n,l=m.indexOf(":");if(!(0>l))for(h.lastIndex=l;n=h.exec(m);){var e=n[0]+":";l=e.length;n=n.index;F["Emoji.aliases"][e]?(e=c(F["Emoji.aliases"][e]),b(n,l,e)):/^:[0-3][0-9a-f]{3,4}(?:-[0-9a-f]{4,5})*:$/.test(e)&&b(n,l,e.substr(1,l-2))}})(a);(function(m){if("undefined"!==typeof d.G){var n;for(d.G.lastIndex=0;n=d.G.exec(m);){var l=n[0];n=n.index;if(F["Emoji.aliases"][l]){var e=c(F["Emoji.aliases"][l]);b(n,l.length,e)}}}})(a);(function(m){var n;for(f.lastIndex=0;n=f.exec(m);){var l=n[0];
b(n.index,l.length,c(l))}})(a)}},MediaEmbed:{y:function(a,b){b.forEach(function(c){var d=c[0][0];R(3,"MEDIA",c[0][1],d.length,-10).b.url=d})},z:"://",C:/\\bhttps?:\\/\\/[^["\'\\s]+/ig,D:5E4}},T,F={"Emoji.aliases":{":(":"\\u2639",":)":"\\ud83d\\ude42",":+1:":"\\ud83d\\udc4d",":-(":"\\u2639",":-)":"\\ud83d\\ude42",":-*":"\\ud83d\\ude18",":-1:":"\\ud83d\\udc4e",":-?":"\\ud83d\\ude15",":-D":"\\ud83d\\ude00",":-P":"\\ud83d\\ude1b",":-p":"\\ud83d\\ude1b",":-|":"\\ud83d\\ude10",":100:":"\\ud83d\\udcaf",":1234:":"\\ud83d\\udd22",":1st_place_medal:":"\\ud83e\\udd47",
":2nd_place_medal:":"\\ud83e\\udd48",":3rd_place_medal:":"\\ud83e\\udd49",":8ball:":"\\ud83c\\udfb1",":?":"\\ud83d\\ude15",":D":"\\ud83d\\ude00",":P":"\\ud83d\\ude1b",":a:":"\\ud83c\\udd70\\ufe0f",":ab:":"\\ud83c\\udd8e",":abc:":"\\ud83d\\udd24",":abcd:":"\\ud83d\\udd21",":accept:":"\\ud83c\\ude51",":adult:":"\\ud83e\\uddd1\\ud83c\\udfff",":adult_tone1:":"\\ud83e\\uddd1\\ud83c\\udffb",":adult_tone2:":"\\ud83e\\uddd1\\ud83c\\udffc",":adult_tone3:":"\\ud83e\\uddd1\\ud83c\\udffd",":adult_tone4:":"\\ud83e\\uddd1\\ud83c\\udffe",":adult_tone5:":"\\ud83e\\uddd1\\ud83c\\udfff",
":aerial_tramway:":"\\ud83d\\udea1",":afghanistan:":"\\ud83c\\udde6\\ud83c\\uddeb",":airplane:":"\\u2708\\ufe0f",":airplane_arriving:":"\\ud83d\\udeec",":airplane_departure:":"\\ud83d\\udeeb",":airplane_small:":"\\ud83d\\udee9\\ufe0f",":aland_islands:":"\\ud83c\\udde6\\ud83c\\uddfd",":alarm_clock:":"\\u23f0",":albania:":"\\ud83c\\udde6\\ud83c\\uddf1",":alembic:":"\\u2697\\ufe0f",":algeria:":"\\ud83c\\udde9\\ud83c\\uddff",":alien:":"\\ud83d\\udc7d",":ambulance:":"\\ud83d\\ude91",":american_samoa:":"\\ud83c\\udde6\\ud83c\\uddf8",":amphora:":"\\ud83c\\udffa",
":anchor:":"\\u2693\\ufe0f",":andorra:":"\\ud83c\\udde6\\ud83c\\udde9",":angel:":"\\ud83d\\udc7c",":angel_tone1:":"\\ud83d\\udc7c\\ud83c\\udffb",":angel_tone2:":"\\ud83d\\udc7c\\ud83c\\udffc",":angel_tone3:":"\\ud83d\\udc7c\\ud83c\\udffd",":angel_tone4:":"\\ud83d\\udc7c\\ud83c\\udffe",":angel_tone5:":"\\ud83d\\udc7c\\ud83c\\udfff",":anger:":"\\ud83d\\udca2",":anger_right:":"\\ud83d\\uddef\\ufe0f",":angola:":"\\ud83c\\udde6\\ud83c\\uddf4",":angry:":"\\ud83d\\ude20",":anguilla:":"\\ud83c\\udde6\\ud83c\\uddee",":anguished:":"\\ud83d\\ude27",":ant:":"\\ud83d\\udc1c",
":antarctica:":"\\ud83c\\udde6\\ud83c\\uddf6",":antigua_barbuda:":"\\ud83c\\udde6\\ud83c\\uddec",":apple:":"\\ud83c\\udf4e",":aquarius:":"\\u2652\\ufe0f",":argentina:":"\\ud83c\\udde6\\ud83c\\uddf7",":aries:":"\\u2648\\ufe0f",":armenia:":"\\ud83c\\udde6\\ud83c\\uddf2",":arrow_backward:":"\\u25c0\\ufe0f",":arrow_double_down:":"\\u23ec",":arrow_double_up:":"\\u23eb",":arrow_down:":"\\u2b07\\ufe0f",":arrow_down_small:":"\\ud83d\\udd3d",":arrow_forward:":"\\u25b6\\ufe0f",":arrow_heading_down:":"\\u2935\\ufe0f",":arrow_heading_up:":"\\u2934\\ufe0f",
":arrow_left:":"\\u2b05\\ufe0f",":arrow_lower_left:":"\\u2199\\ufe0f",":arrow_lower_right:":"\\u2198\\ufe0f",":arrow_right:":"\\u27a1\\ufe0f",":arrow_right_hook:":"\\u21aa\\ufe0f",":arrow_up:":"\\u2b06\\ufe0f",":arrow_up_down:":"\\u2195\\ufe0f",":arrow_up_small:":"\\ud83d\\udd3c",":arrow_upper_left:":"\\u2196\\ufe0f",":arrow_upper_right:":"\\u2197\\ufe0f",":arrows_clockwise:":"\\ud83d\\udd03",":arrows_counterclockwise:":"\\ud83d\\udd04",":art:":"\\ud83c\\udfa8",":articulated_lorry:":"\\ud83d\\ude9b",":artificial_satellite:":"\\ud83d\\udef0",
":aruba:":"\\ud83c\\udde6\\ud83c\\uddfc",":asterisk:":"*\\u20e3",":asterisk_symbol:":"*",":astonished:":"\\ud83d\\ude32",":athletic_shoe:":"\\ud83d\\udc5f",":atm:":"\\ud83c\\udfe7",":atom:":"\\u269b\\ufe0f",":atom_symbol:":"\\u269b\\ufe0f",":australia:":"\\ud83c\\udde6\\ud83c\\uddfa",":austria:":"\\ud83c\\udde6\\ud83c\\uddf9",":avocado:":"\\ud83e\\udd51",":azerbaijan:":"\\ud83c\\udde6\\ud83c\\uddff",":b:":"\\ud83c\\udd71\\ufe0f",":baby:":"\\ud83d\\udc76",":baby_bottle:":"\\ud83c\\udf7c",":baby_chick:":"\\ud83d\\udc24",":baby_symbol:":"\\ud83d\\udebc",
":baby_tone1:":"\\ud83d\\udc76\\ud83c\\udffb",":baby_tone2:":"\\ud83d\\udc76\\ud83c\\udffc",":baby_tone3:":"\\ud83d\\udc76\\ud83c\\udffd",":baby_tone4:":"\\ud83d\\udc76\\ud83c\\udffe",":baby_tone5:":"\\ud83d\\udc76\\ud83c\\udfff",":back:":"\\ud83d\\udd19",":bacon:":"\\ud83e\\udd53",":badminton:":"\\ud83c\\udff8",":baggage_claim:":"\\ud83d\\udec4",":baguette_bread:":"\\ud83e\\udd56",":bahamas:":"\\ud83c\\udde7\\ud83c\\uddf8",":bahrain:":"\\ud83c\\udde7\\ud83c\\udded",":balance_scale:":"\\u2696\\ufe0f",":balloon:":"\\ud83c\\udf88",":ballot_box:":"\\ud83d\\uddf3",
":ballot_box_with_check:":"\\u2611\\ufe0f",":bamboo:":"\\ud83c\\udf8d",":banana:":"\\ud83c\\udf4c",":bangbang:":"\\u203c\\ufe0f",":bangladesh:":"\\ud83c\\udde7\\ud83c\\udde9",":bank:":"\\ud83c\\udfe6",":bar_chart:":"\\ud83d\\udcca",":barbados:":"\\ud83c\\udde7\\ud83c\\udde7",":barber:":"\\ud83d\\udc88",":baseball:":"\\u26be\\ufe0f",":basketball:":"\\ud83c\\udfc0",":basketball_man:":"\\u26f9",":basketball_woman:":"\\u26f9\\ufe0f\\u200d\\u2640\\ufe0f",":bat:":"\\ud83e\\udd87",":bath:":"\\ud83d\\udec0",":bath_tone1:":"\\ud83d\\udec0\\ud83c\\udffb",
":bath_tone2:":"\\ud83d\\udec0\\ud83c\\udffc",":bath_tone3:":"\\ud83d\\udec0\\ud83c\\udffd",":bath_tone4:":"\\ud83d\\udec0\\ud83c\\udffe",":bath_tone5:":"\\ud83d\\udec0\\ud83c\\udfff",":bathtub:":"\\ud83d\\udec1",":battery:":"\\ud83d\\udd0b",":beach:":"\\ud83c\\udfd6\\ufe0f",":beach_umbrella:":"\\ud83c\\udfd6",":bear:":"\\ud83d\\udc3b",":bearded_person:":"\\ud83e\\uddd4\\ud83c\\udfff",":bearded_person_tone1:":"\\ud83e\\uddd4\\ud83c\\udffb",":bearded_person_tone2:":"\\ud83e\\uddd4\\ud83c\\udffc",":bearded_person_tone3:":"\\ud83e\\uddd4\\ud83c\\udffd",
":bearded_person_tone4:":"\\ud83e\\uddd4\\ud83c\\udffe",":bearded_person_tone5:":"\\ud83e\\uddd4\\ud83c\\udfff",":bed:":"\\ud83d\\udecf",":bee:":"\\ud83d\\udc1d",":beer:":"\\ud83c\\udf7a",":beers:":"\\ud83c\\udf7b",":beetle:":"\\ud83d\\udc1e",":beginner:":"\\ud83d\\udd30",":belarus:":"\\ud83c\\udde7\\ud83c\\uddfe",":belgium:":"\\ud83c\\udde7\\ud83c\\uddea",":belize:":"\\ud83c\\udde7\\ud83c\\uddff",":bell:":"\\ud83d\\udd14",":bellhop:":"\\ud83d\\udece\\ufe0f",":bellhop_bell:":"\\ud83d\\udece",":benin:":"\\ud83c\\udde7\\ud83c\\uddef",":bento:":"\\ud83c\\udf71",
":bermuda:":"\\ud83c\\udde7\\ud83c\\uddf2",":bhutan:":"\\ud83c\\udde7\\ud83c\\uddf9",":bicyclist:":"\\ud83d\\udeb4",":bike:":"\\ud83d\\udeb2",":biking_man:":"\\ud83d\\udeb4",":biking_woman:":"\\ud83d\\udeb4\\u200d\\u2640\\ufe0f",":bikini:":"\\ud83d\\udc59",":billed_cap:":"\\ud83e\\udde2",":biohazard:":"\\u2623\\ufe0f",":bird:":"\\ud83d\\udc26",":birthday:":"\\ud83c\\udf82",":black_circle:":"\\u26ab\\ufe0f",":black_flag:":"\\ud83c\\udff4",":black_heart:":"\\ud83d\\udda4",":black_joker:":"\\ud83c\\udccf",":black_large_square:":"\\u2b1b\\ufe0f",
":black_medium_small_square:":"\\u25fe\\ufe0f",":black_medium_square:":"\\u25fc\\ufe0f",":black_nib:":"\\u2712\\ufe0f",":black_small_square:":"\\u25aa\\ufe0f",":black_square_button:":"\\ud83d\\udd32",":blond-haired_man:":"\\ud83d\\udc71\\u200d\\u2642\\ufe0f",":blond-haired_man_tone1:":"\\ud83d\\udc71\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":blond-haired_man_tone2:":"\\ud83d\\udc71\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":blond-haired_man_tone3:":"\\ud83d\\udc71\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":blond-haired_man_tone4:":"\\ud83d\\udc71\\ud83c\\udffe\\u200d\\u2642\\ufe0f",
":blond-haired_man_tone5:":"\\ud83d\\udc71\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":blond-haired_woman:":"\\ud83d\\udc71\\u200d\\u2640\\ufe0f",":blond-haired_woman_tone1:":"\\ud83d\\udc71\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":blond-haired_woman_tone2:":"\\ud83d\\udc71\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":blond-haired_woman_tone3:":"\\ud83d\\udc71\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":blond-haired_woman_tone4:":"\\ud83d\\udc71\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":blond-haired_woman_tone5:":"\\ud83d\\udc71\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":blond_haired_person:":"\\ud83d\\udc71",
":blond_haired_person_tone1:":"\\ud83d\\udc71\\ud83c\\udffb",":blond_haired_person_tone2:":"\\ud83d\\udc71\\ud83c\\udffc",":blond_haired_person_tone3:":"\\ud83d\\udc71\\ud83c\\udffd",":blond_haired_person_tone4:":"\\ud83d\\udc71\\ud83c\\udffe",":blond_haired_person_tone5:":"\\ud83d\\udc71\\ud83c\\udfff",":blonde_man:":"\\ud83d\\udc71",":blonde_woman:":"\\ud83d\\udc71\\u200d\\u2640\\ufe0f",":blossom:":"\\ud83c\\udf3c",":blowfish:":"\\ud83d\\udc21",":blue_book:":"\\ud83d\\udcd8",":blue_car:":"\\ud83d\\ude99",":blue_circle:":"\\ud83d\\udd35",
":blue_heart:":"\\ud83d\\udc99",":blush:":"\\ud83d\\ude0a",":boar:":"\\ud83d\\udc17",":boat:":"\\u26f5\\ufe0f",":bolivia:":"\\ud83c\\udde7\\ud83c\\uddf4",":bomb:":"\\ud83d\\udca3",":book:":"\\ud83d\\udcd6",":bookmark:":"\\ud83d\\udd16",":bookmark_tabs:":"\\ud83d\\udcd1",":books:":"\\ud83d\\udcda",":boom:":"\\ud83d\\udca5",":boot:":"\\ud83d\\udc62",":bosnia_herzegovina:":"\\ud83c\\udde7\\ud83c\\udde6",":botswana:":"\\ud83c\\udde7\\ud83c\\uddfc",":bouquet:":"\\ud83d\\udc90",":bow:":"\\ud83d\\ude47",":bow_and_arrow:":"\\ud83c\\udff9",":bowing_man:":"\\ud83d\\ude47",
":bowing_woman:":"\\ud83d\\ude47\\u200d\\u2640\\ufe0f",":bowl_with_spoon:":"\\ud83e\\udd63",":bowling:":"\\ud83c\\udfb3",":boxing_glove:":"\\ud83e\\udd4a",":boy:":"\\ud83d\\udc66",":boy_tone1:":"\\ud83d\\udc66\\ud83c\\udffb",":boy_tone2:":"\\ud83d\\udc66\\ud83c\\udffc",":boy_tone3:":"\\ud83d\\udc66\\ud83c\\udffd",":boy_tone4:":"\\ud83d\\udc66\\ud83c\\udffe",":boy_tone5:":"\\ud83d\\udc66\\ud83c\\udfff",":brain:":"\\ud83e\\udde0",":brazil:":"\\ud83c\\udde7\\ud83c\\uddf7",":bread:":"\\ud83c\\udf5e",":breast_feeding:":"\\ud83e\\udd31",":breast_feeding_tone1:":"\\ud83e\\udd31\\ud83c\\udffb",
":breast_feeding_tone2:":"\\ud83e\\udd31\\ud83c\\udffc",":breast_feeding_tone3:":"\\ud83e\\udd31\\ud83c\\udffd",":breast_feeding_tone4:":"\\ud83e\\udd31\\ud83c\\udffe",":breast_feeding_tone5:":"\\ud83e\\udd31\\ud83c\\udfff",":bride_with_veil:":"\\ud83d\\udc70",":bride_with_veil_tone1:":"\\ud83d\\udc70\\ud83c\\udffb",":bride_with_veil_tone2:":"\\ud83d\\udc70\\ud83c\\udffc",":bride_with_veil_tone3:":"\\ud83d\\udc70\\ud83c\\udffd",":bride_with_veil_tone4:":"\\ud83d\\udc70\\ud83c\\udffe",":bride_with_veil_tone5:":"\\ud83d\\udc70\\ud83c\\udfff",
":bridge_at_night:":"\\ud83c\\udf09",":briefcase:":"\\ud83d\\udcbc",":british_indian_ocean_territory:":"\\ud83c\\uddee\\ud83c\\uddf4",":british_virgin_islands:":"\\ud83c\\uddfb\\ud83c\\uddec",":broccoli:":"\\ud83e\\udd66",":broken_heart:":"\\ud83d\\udc94",":brunei:":"\\ud83c\\udde7\\ud83c\\uddf3",":bug:":"\\ud83d\\udc1b",":building_construction:":"\\ud83c\\udfd7",":bulb:":"\\ud83d\\udca1",":bulgaria:":"\\ud83c\\udde7\\ud83c\\uddec",":bullettrain_front:":"\\ud83d\\ude85",":bullettrain_side:":"\\ud83d\\ude84",":burkina_faso:":"\\ud83c\\udde7\\ud83c\\uddeb",
":burrito:":"\\ud83c\\udf2f",":burundi:":"\\ud83c\\udde7\\ud83c\\uddee",":bus:":"\\ud83d\\ude8c",":business_suit_levitating:":"\\ud83d\\udd74",":busstop:":"\\ud83d\\ude8f",":bust_in_silhouette:":"\\ud83d\\udc64",":busts_in_silhouette:":"\\ud83d\\udc65",":butterfly:":"\\ud83e\\udd8b",":cactus:":"\\ud83c\\udf35",":cake:":"\\ud83c\\udf70",":calendar:":"\\ud83d\\udcc6",":calendar_spiral:":"\\ud83d\\uddd3\\ufe0f",":call_me:":"\\ud83e\\udd19",":call_me_hand:":"\\ud83e\\udd19",":call_me_tone1:":"\\ud83e\\udd19\\ud83c\\udffb",":call_me_tone2:":"\\ud83e\\udd19\\ud83c\\udffc",
":call_me_tone3:":"\\ud83e\\udd19\\ud83c\\udffd",":call_me_tone4:":"\\ud83e\\udd19\\ud83c\\udffe",":call_me_tone5:":"\\ud83e\\udd19\\ud83c\\udfff",":calling:":"\\ud83d\\udcf2",":cambodia:":"\\ud83c\\uddf0\\ud83c\\udded",":camel:":"\\ud83d\\udc2b",":camera:":"\\ud83d\\udcf7",":camera_flash:":"\\ud83d\\udcf8",":camera_with_flash:":"\\ud83d\\udcf8",":cameroon:":"\\ud83c\\udde8\\ud83c\\uddf2",":camping:":"\\ud83c\\udfd5",":canada:":"\\ud83c\\udde8\\ud83c\\udde6",":canary_islands:":"\\ud83c\\uddee\\ud83c\\udde8",":cancer:":"\\u264b\\ufe0f",":candle:":"\\ud83d\\udd6f",
":candy:":"\\ud83c\\udf6c",":canned_food:":"\\ud83e\\udd6b",":canoe:":"\\ud83d\\udef6",":cape_verde:":"\\ud83c\\udde8\\ud83c\\uddfb",":capital_abcd:":"\\ud83d\\udd20",":capricorn:":"\\u2651\\ufe0f",":car:":"\\ud83d\\ude97",":card_box:":"\\ud83d\\uddc3\\ufe0f",":card_file_box:":"\\ud83d\\uddc3",":card_index:":"\\ud83d\\udcc7",":card_index_dividers:":"\\ud83d\\uddc2",":caribbean_netherlands:":"\\ud83c\\udde7\\ud83c\\uddf6",":carousel_horse:":"\\ud83c\\udfa0",":carrot:":"\\ud83e\\udd55",":cat2:":"\\ud83d\\udc08",":cat:":"\\ud83d\\udc31",
":cayman_islands:":"\\ud83c\\uddf0\\ud83c\\uddfe",":cd:":"\\ud83d\\udcbf",":central_african_republic:":"\\ud83c\\udde8\\ud83c\\uddeb",":chad:":"\\ud83c\\uddf9\\ud83c\\udde9",":chains:":"\\u26d3",":champagne:":"\\ud83c\\udf7e",":champagne_glass:":"\\ud83e\\udd42",":chart:":"\\ud83d\\udcb9",":chart_with_downwards_trend:":"\\ud83d\\udcc9",":chart_with_upwards_trend:":"\\ud83d\\udcc8",":checkered_flag:":"\\ud83c\\udfc1",":cheese:":"\\ud83e\\uddc0",":cherries:":"\\ud83c\\udf52",":cherry_blossom:":"\\ud83c\\udf38",":chestnut:":"\\ud83c\\udf30",
":chicken:":"\\ud83d\\udc14",":child:":"\\ud83e\\uddd2\\ud83c\\udfff",":child_tone1:":"\\ud83e\\uddd2\\ud83c\\udffb",":child_tone2:":"\\ud83e\\uddd2\\ud83c\\udffc",":child_tone3:":"\\ud83e\\uddd2\\ud83c\\udffd",":child_tone4:":"\\ud83e\\uddd2\\ud83c\\udffe",":child_tone5:":"\\ud83e\\uddd2\\ud83c\\udfff",":children_crossing:":"\\ud83d\\udeb8",":chile:":"\\ud83c\\udde8\\ud83c\\uddf1",":chipmunk:":"\\ud83d\\udc3f",":chocolate_bar:":"\\ud83c\\udf6b",":chopsticks:":"\\ud83e\\udd62",":christmas_island:":"\\ud83c\\udde8\\ud83c\\uddfd",":christmas_tree:":"\\ud83c\\udf84",
":church:":"\\u26ea\\ufe0f",":cinema:":"\\ud83c\\udfa6",":circus_tent:":"\\ud83c\\udfaa",":city_dusk:":"\\ud83c\\udf06",":city_sunrise:":"\\ud83c\\udf07",":city_sunset:":"\\ud83c\\udf06",":cityscape:":"\\ud83c\\udfd9",":cl:":"\\ud83c\\udd91",":clamp:":"\\ud83d\\udddc",":clap:":"\\ud83d\\udc4f",":clap_tone1:":"\\ud83d\\udc4f\\ud83c\\udffb",":clap_tone2:":"\\ud83d\\udc4f\\ud83c\\udffc",":clap_tone3:":"\\ud83d\\udc4f\\ud83c\\udffd",":clap_tone4:":"\\ud83d\\udc4f\\ud83c\\udffe",":clap_tone5:":"\\ud83d\\udc4f\\ud83c\\udfff",":clapper:":"\\ud83c\\udfac",
":classical_building:":"\\ud83c\\udfdb",":clinking_glasses:":"\\ud83e\\udd42",":clipboard:":"\\ud83d\\udccb",":clock1030:":"\\ud83d\\udd65",":clock10:":"\\ud83d\\udd59",":clock1130:":"\\ud83d\\udd66",":clock11:":"\\ud83d\\udd5a",":clock1230:":"\\ud83d\\udd67",":clock12:":"\\ud83d\\udd5b",":clock130:":"\\ud83d\\udd5c",":clock1:":"\\ud83d\\udd50",":clock230:":"\\ud83d\\udd5d",":clock2:":"\\ud83d\\udd51",":clock330:":"\\ud83d\\udd5e",":clock3:":"\\ud83d\\udd52",":clock430:":"\\ud83d\\udd5f",":clock4:":"\\ud83d\\udd53",":clock530:":"\\ud83d\\udd60",
":clock5:":"\\ud83d\\udd54",":clock630:":"\\ud83d\\udd61",":clock6:":"\\ud83d\\udd55",":clock730:":"\\ud83d\\udd62",":clock7:":"\\ud83d\\udd56",":clock830:":"\\ud83d\\udd63",":clock8:":"\\ud83d\\udd57",":clock930:":"\\ud83d\\udd64",":clock9:":"\\ud83d\\udd58",":clock:":"\\ud83d\\udd70\\ufe0f",":closed_book:":"\\ud83d\\udcd5",":closed_lock_with_key:":"\\ud83d\\udd10",":closed_umbrella:":"\\ud83c\\udf02",":cloud:":"\\u2601\\ufe0f",":cloud_lightning:":"\\ud83c\\udf29\\ufe0f",":cloud_rain:":"\\ud83c\\udf27\\ufe0f",":cloud_snow:":"\\ud83c\\udf28\\ufe0f",
":cloud_tornado:":"\\ud83c\\udf2a\\ufe0f",":cloud_with_lightning:":"\\ud83c\\udf29",":cloud_with_lightning_and_rain:":"\\u26c8",":cloud_with_rain:":"\\ud83c\\udf27",":cloud_with_snow:":"\\ud83c\\udf28",":clown:":"\\ud83e\\udd21",":clown_face:":"\\ud83e\\udd21",":clubs:":"\\u2663\\ufe0f",":cn:":"\\ud83c\\udde8\\ud83c\\uddf3",":coat:":"\\ud83e\\udde5",":cocktail:":"\\ud83c\\udf78",":coconut:":"\\ud83e\\udd65",":cocos_islands:":"\\ud83c\\udde8\\ud83c\\udde8",":coffee:":"\\u2615\\ufe0f",":coffin:":"\\u26b0\\ufe0f",":cold_sweat:":"\\ud83d\\ude30",
":collision:":"\\ud83d\\udca5",":colombia:":"\\ud83c\\udde8\\ud83c\\uddf4",":comet:":"\\u2604",":comoros:":"\\ud83c\\uddf0\\ud83c\\uddf2",":compression:":"\\ud83d\\udddc\\ufe0f",":computer:":"\\ud83d\\udcbb",":computer_mouse:":"\\ud83d\\uddb1",":confetti_ball:":"\\ud83c\\udf8a",":confounded:":"\\ud83d\\ude16",":confused:":"\\ud83d\\ude15",":congo_brazzaville:":"\\ud83c\\udde8\\ud83c\\uddec",":congo_kinshasa:":"\\ud83c\\udde8\\ud83c\\udde9",":congratulations:":"\\u3297\\ufe0f",":construction:":"\\ud83d\\udea7",":construction_site:":"\\ud83c\\udfd7\\ufe0f",
":construction_worker:":"\\ud83d\\udc77",":construction_worker_man:":"\\ud83d\\udc77",":construction_worker_tone1:":"\\ud83d\\udc77\\ud83c\\udffb",":construction_worker_tone2:":"\\ud83d\\udc77\\ud83c\\udffc",":construction_worker_tone3:":"\\ud83d\\udc77\\ud83c\\udffd",":construction_worker_tone4:":"\\ud83d\\udc77\\ud83c\\udffe",":construction_worker_tone5:":"\\ud83d\\udc77\\ud83c\\udfff",":construction_worker_woman:":"\\ud83d\\udc77\\u200d\\u2640\\ufe0f",":control_knobs:":"\\ud83c\\udf9b",":convenience_store:":"\\ud83c\\udfea",":cook_islands:":"\\ud83c\\udde8\\ud83c\\uddf0",
":cookie:":"\\ud83c\\udf6a",":cooking:":"\\ud83c\\udf73",":cool:":"\\ud83c\\udd92",":cop:":"\\ud83d\\udc6e",":copyright:":"\\u00a9\\ufe0f",":corn:":"\\ud83c\\udf3d",":costa_rica:":"\\ud83c\\udde8\\ud83c\\uddf7",":cote_divoire:":"\\ud83c\\udde8\\ud83c\\uddee",":couch:":"\\ud83d\\udecb\\ufe0f",":couch_and_lamp:":"\\ud83d\\udecb",":couple:":"\\ud83d\\udc6b",":couple_mm:":"\\ud83d\\udc68\\u200d\\u2764\\ufe0f\\u200d\\ud83d\\udc68",":couple_with_heart:":"\\ud83d\\udc91",":couple_with_heart_man_man:":"\\ud83d\\udc68\\u200d\\u2764\\ufe0f\\u200d\\ud83d\\udc68",
":couple_with_heart_woman_man:":"\\ud83d\\udc91",":couple_with_heart_woman_woman:":"\\ud83d\\udc69\\u200d\\u2764\\ufe0f\\u200d\\ud83d\\udc69",":couple_ww:":"\\ud83d\\udc69\\u200d\\u2764\\ufe0f\\u200d\\ud83d\\udc69",":couplekiss:":"\\ud83d\\udc8f",":couplekiss_man_man:":"\\ud83d\\udc68\\u200d\\u2764\\ufe0f\\u200d\\ud83d\\udc8b\\u200d\\ud83d\\udc68",":couplekiss_man_woman:":"\\ud83d\\udc8f",":couplekiss_woman_woman:":"\\ud83d\\udc69\\u200d\\u2764\\ufe0f\\u200d\\ud83d\\udc8b\\u200d\\ud83d\\udc69",":cow2:":"\\ud83d\\udc04",":cow:":"\\ud83d\\udc2e",
":cowboy:":"\\ud83e\\udd20",":cowboy_hat_face:":"\\ud83e\\udd20",":crab:":"\\ud83e\\udd80",":crayon:":"\\ud83d\\udd8d",":crazy_face:":"\\ud83e\\udd2a",":credit_card:":"\\ud83d\\udcb3",":crescent_moon:":"\\ud83c\\udf19",":cricket:":"\\ud83c\\udfcf",":cricket_game:":"\\ud83c\\udfcf",":croatia:":"\\ud83c\\udded\\ud83c\\uddf7",":crocodile:":"\\ud83d\\udc0a",":croissant:":"\\ud83e\\udd50",":cross:":"\\u271d\\ufe0f",":crossed_fingers:":"\\ud83e\\udd1e",":crossed_flags:":"\\ud83c\\udf8c",":crossed_swords:":"\\u2694\\ufe0f",":crown:":"\\ud83d\\udc51",
":cruise_ship:":"\\ud83d\\udef3\\ufe0f",":cry:":"\\ud83d\\ude22",":crying_cat_face:":"\\ud83d\\ude3f",":crystal_ball:":"\\ud83d\\udd2e",":cuba:":"\\ud83c\\udde8\\ud83c\\uddfa",":cucumber:":"\\ud83e\\udd52",":cup_with_straw:":"\\ud83e\\udd64",":cupid:":"\\ud83d\\udc98",":curacao:":"\\ud83c\\udde8\\ud83c\\uddfc",":curling_stone:":"\\ud83e\\udd4c",":curly_loop:":"\\u27b0",":currency_exchange:":"\\ud83d\\udcb1",":curry:":"\\ud83c\\udf5b",":custard:":"\\ud83c\\udf6e",":customs:":"\\ud83d\\udec3",":cut_of_meat:":"\\ud83e\\udd69",":cyclone:":"\\ud83c\\udf00",
":cyprus:":"\\ud83c\\udde8\\ud83c\\uddfe",":czech_republic:":"\\ud83c\\udde8\\ud83c\\uddff",":dagger:":"\\ud83d\\udde1",":dancer:":"\\ud83d\\udc83",":dancer_tone1:":"\\ud83d\\udc83\\ud83c\\udffb",":dancer_tone2:":"\\ud83d\\udc83\\ud83c\\udffc",":dancer_tone3:":"\\ud83d\\udc83\\ud83c\\udffd",":dancer_tone4:":"\\ud83d\\udc83\\ud83c\\udffe",":dancer_tone5:":"\\ud83d\\udc83\\ud83c\\udfff",":dancers:":"\\ud83d\\udc6f",":dancing_men:":"\\ud83d\\udc6f\\u200d\\u2642\\ufe0f",":dancing_women:":"\\ud83d\\udc6f",":dango:":"\\ud83c\\udf61",":dark_sunglasses:":"\\ud83d\\udd76",
":dart:":"\\ud83c\\udfaf",":dash:":"\\ud83d\\udca8",":date:":"\\ud83d\\udcc5",":de:":"\\ud83c\\udde9\\ud83c\\uddea",":deciduous_tree:":"\\ud83c\\udf33",":deer:":"\\ud83e\\udd8c",":denmark:":"\\ud83c\\udde9\\ud83c\\uddf0",":department_store:":"\\ud83c\\udfec",":derelict_house:":"\\ud83c\\udfda",":desert:":"\\ud83c\\udfdc",":desert_island:":"\\ud83c\\udfdd",":desktop:":"\\ud83d\\udda5\\ufe0f",":desktop_computer:":"\\ud83d\\udda5",":detective:":"\\ud83d\\udd75",":detective_tone1:":"\\ud83d\\udd75\\ud83c\\udffb",":detective_tone2:":"\\ud83d\\udd75\\ud83c\\udffc",
":detective_tone3:":"\\ud83d\\udd75\\ud83c\\udffd",":detective_tone4:":"\\ud83d\\udd75\\ud83c\\udffe",":detective_tone5:":"\\ud83d\\udd75\\ud83c\\udfff",":diamond_shape_with_a_dot_inside:":"\\ud83d\\udca0",":diamonds:":"\\u2666\\ufe0f",":digit_eight:":"8",":digit_five:":"5",":digit_four:":"4",":digit_nine:":"9",":digit_one:":"1",":digit_seven:":"7",":digit_six:":"6",":digit_three:":"3",":digit_two:":"2",":digit_zero:":"0",":disappointed:":"\\ud83d\\ude1e",":disappointed_relieved:":"\\ud83d\\ude25",":dividers:":"\\ud83d\\uddc2\\ufe0f",
":dizzy:":"\\ud83d\\udcab",":dizzy_face:":"\\ud83d\\ude35",":djibouti:":"\\ud83c\\udde9\\ud83c\\uddef",":do_not_litter:":"\\ud83d\\udeaf",":dog2:":"\\ud83d\\udc15",":dog:":"\\ud83d\\udc36",":dollar:":"\\ud83d\\udcb5",":dolls:":"\\ud83c\\udf8e",":dolphin:":"\\ud83d\\udc2c",":dominica:":"\\ud83c\\udde9\\ud83c\\uddf2",":dominican_republic:":"\\ud83c\\udde9\\ud83c\\uddf4",":door:":"\\ud83d\\udeaa",":doughnut:":"\\ud83c\\udf69",":dove:":"\\ud83d\\udd4a",":dragon:":"\\ud83d\\udc09",":dragon_face:":"\\ud83d\\udc32",":dress:":"\\ud83d\\udc57",
":dromedary_camel:":"\\ud83d\\udc2a",":drooling_face:":"\\ud83e\\udd24",":droplet:":"\\ud83d\\udca7",":drum:":"\\ud83e\\udd41",":duck:":"\\ud83e\\udd86",":dumpling:":"\\ud83e\\udd5f",":dvd:":"\\ud83d\\udcc0",":e-mail:":"\\ud83d\\udce7",":eagle:":"\\ud83e\\udd85",":ear:":"\\ud83d\\udc42",":ear_of_rice:":"\\ud83c\\udf3e",":ear_tone1:":"\\ud83d\\udc42\\ud83c\\udffb",":ear_tone2:":"\\ud83d\\udc42\\ud83c\\udffc",":ear_tone3:":"\\ud83d\\udc42\\ud83c\\udffd",":ear_tone4:":"\\ud83d\\udc42\\ud83c\\udffe",":ear_tone5:":"\\ud83d\\udc42\\ud83c\\udfff",
":earth_africa:":"\\ud83c\\udf0d",":earth_americas:":"\\ud83c\\udf0e",":earth_asia:":"\\ud83c\\udf0f",":ecuador:":"\\ud83c\\uddea\\ud83c\\udde8",":egg:":"\\ud83e\\udd5a",":eggplant:":"\\ud83c\\udf46",":egypt:":"\\ud83c\\uddea\\ud83c\\uddec",":eight:":"8\\u20e3",":eight_pointed_black_star:":"\\u2734\\ufe0f",":eight_spoked_asterisk:":"\\u2733\\ufe0f",":eject:":"\\u23cf\\ufe0f",":el_salvador:":"\\ud83c\\uddf8\\ud83c\\uddfb",":electric_plug:":"\\ud83d\\udd0c",":elephant:":"\\ud83d\\udc18",":elf:":"\\ud83e\\udddd\\ud83c\\udfff",":elf_tone1:":"\\ud83e\\udddd\\ud83c\\udffb",
":elf_tone2:":"\\ud83e\\udddd\\ud83c\\udffc",":elf_tone3:":"\\ud83e\\udddd\\ud83c\\udffd",":elf_tone4:":"\\ud83e\\udddd\\ud83c\\udffe",":elf_tone5:":"\\ud83e\\udddd\\ud83c\\udfff",":email:":"\\u2709\\ufe0f",":end:":"\\ud83d\\udd1a",":england:":"\\ud83c\\udff4\\udb40\\udc67\\udb40\\udc62\\udb40\\udc65\\udb40\\udc6e\\udb40\\udc67\\udb40\\udc7f",":envelope:":"\\u2709\\ufe0f",":envelope_with_arrow:":"\\ud83d\\udce9",":equatorial_guinea:":"\\ud83c\\uddec\\ud83c\\uddf6",":eritrea:":"\\ud83c\\uddea\\ud83c\\uddf7",":es:":"\\ud83c\\uddea\\ud83c\\uddf8",":estonia:":"\\ud83c\\uddea\\ud83c\\uddea",
":ethiopia:":"\\ud83c\\uddea\\ud83c\\uddf9",":eu:":"\\ud83c\\uddea\\ud83c\\uddfa",":euro:":"\\ud83d\\udcb6",":european_castle:":"\\ud83c\\udff0",":european_post_office:":"\\ud83c\\udfe4",":european_union:":"\\ud83c\\uddea\\ud83c\\uddfa",":evergreen_tree:":"\\ud83c\\udf32",":exclamation:":"\\u2757\\ufe0f",":exploding_head:":"\\ud83e\\udd2f",":expressionless:":"\\ud83d\\ude11",":eye:":"\\ud83d\\udc41",":eye_in_speech_bubble:":"\\ud83d\\udc41\\u200d\\ud83d\\udde8",":eye_speech_bubble:":"\\ud83d\\udc41\\u200d\\ud83d\\udde8",":eyeglasses:":"\\ud83d\\udc53",
":eyes:":"\\ud83d\\udc40",":face_vomiting:":"\\ud83e\\udd2e",":face_with_hand_over_mouth:":"\\ud83e\\udd2d",":face_with_head_bandage:":"\\ud83e\\udd15",":face_with_monocle:":"\\ud83e\\uddd0",":face_with_raised_eyebrow:":"\\ud83e\\udd28",":face_with_symbols_over_mouth:":"\\ud83e\\udd2c",":face_with_thermometer:":"\\ud83e\\udd12",":facepunch:":"\\ud83d\\udc4a",":factory:":"\\ud83c\\udfed",":fairy:":"\\ud83e\\uddda\\ud83c\\udfff",":fairy_tone1:":"\\ud83e\\uddda\\ud83c\\udffb",":fairy_tone2:":"\\ud83e\\uddda\\ud83c\\udffc",":fairy_tone3:":"\\ud83e\\uddda\\ud83c\\udffd",
":fairy_tone4:":"\\ud83e\\uddda\\ud83c\\udffe",":fairy_tone5:":"\\ud83e\\uddda\\ud83c\\udfff",":falkland_islands:":"\\ud83c\\uddeb\\ud83c\\uddf0",":fallen_leaf:":"\\ud83c\\udf42",":family:":"\\ud83d\\udc6a",":family_man_boy:":"\\ud83d\\udc68\\u200d\\ud83d\\udc66",":family_man_boy_boy:":"\\ud83d\\udc68\\u200d\\ud83d\\udc66\\u200d\\ud83d\\udc66",":family_man_girl:":"\\ud83d\\udc68\\u200d\\ud83d\\udc67",":family_man_girl_boy:":"\\ud83d\\udc68\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc66",":family_man_girl_girl:":"\\ud83d\\udc68\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc67",
":family_man_man_boy:":"\\ud83d\\udc68\\u200d\\ud83d\\udc68\\u200d\\ud83d\\udc66",":family_man_man_boy_boy:":"\\ud83d\\udc68\\u200d\\ud83d\\udc68\\u200d\\ud83d\\udc66\\u200d\\ud83d\\udc66",":family_man_man_girl:":"\\ud83d\\udc68\\u200d\\ud83d\\udc68\\u200d\\ud83d\\udc67",":family_man_man_girl_boy:":"\\ud83d\\udc68\\u200d\\ud83d\\udc68\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc66",":family_man_man_girl_girl:":"\\ud83d\\udc68\\u200d\\ud83d\\udc68\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc67",":family_man_woman_boy:":"\\ud83d\\udc6a",":family_man_woman_boy_boy:":"\\ud83d\\udc68\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc66\\u200d\\ud83d\\udc66",
":family_man_woman_girl:":"\\ud83d\\udc68\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc67",":family_man_woman_girl_boy:":"\\ud83d\\udc68\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc66",":family_man_woman_girl_girl:":"\\ud83d\\udc68\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc67",":family_mmb:":"\\ud83d\\udc68\\u200d\\ud83d\\udc68\\u200d\\ud83d\\udc66",":family_mmbb:":"\\ud83d\\udc68\\u200d\\ud83d\\udc68\\u200d\\ud83d\\udc66\\u200d\\ud83d\\udc66",":family_mmg:":"\\ud83d\\udc68\\u200d\\ud83d\\udc68\\u200d\\ud83d\\udc67",":family_mmgb:":"\\ud83d\\udc68\\u200d\\ud83d\\udc68\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc66",
":family_mmgg:":"\\ud83d\\udc68\\u200d\\ud83d\\udc68\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc67",":family_mwbb:":"\\ud83d\\udc68\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc66\\u200d\\ud83d\\udc66",":family_mwg:":"\\ud83d\\udc68\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc67",":family_mwgb:":"\\ud83d\\udc68\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc66",":family_mwgg:":"\\ud83d\\udc68\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc67",":family_woman_boy:":"\\ud83d\\udc69\\u200d\\ud83d\\udc66",":family_woman_boy_boy:":"\\ud83d\\udc69\\u200d\\ud83d\\udc66\\u200d\\ud83d\\udc66",
":family_woman_girl:":"\\ud83d\\udc69\\u200d\\ud83d\\udc67",":family_woman_girl_boy:":"\\ud83d\\udc69\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc66",":family_woman_girl_girl:":"\\ud83d\\udc69\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc67",":family_woman_woman_boy:":"\\ud83d\\udc69\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc66",":family_woman_woman_boy_boy:":"\\ud83d\\udc69\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc66\\u200d\\ud83d\\udc66",":family_woman_woman_girl:":"\\ud83d\\udc69\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc67",":family_woman_woman_girl_boy:":"\\ud83d\\udc69\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc66",
":family_woman_woman_girl_girl:":"\\ud83d\\udc69\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc67",":family_wwb:":"\\ud83d\\udc69\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc66",":family_wwbb:":"\\ud83d\\udc69\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc66\\u200d\\ud83d\\udc66",":family_wwg:":"\\ud83d\\udc69\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc67",":family_wwgb:":"\\ud83d\\udc69\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc66",":family_wwgg:":"\\ud83d\\udc69\\u200d\\ud83d\\udc69\\u200d\\ud83d\\udc67\\u200d\\ud83d\\udc67",":faroe_islands:":"\\ud83c\\uddeb\\ud83c\\uddf4",
":fast_forward:":"\\u23e9",":fax:":"\\ud83d\\udce0",":fearful:":"\\ud83d\\ude28",":feet:":"\\ud83d\\udc3e",":female_detective:":"\\ud83d\\udd75\\ufe0f\\u200d\\u2640\\ufe0f",":female_sign:":"\\u2640\\ufe0f",":ferris_wheel:":"\\ud83c\\udfa1",":ferry:":"\\u26f4",":field_hockey:":"\\ud83c\\udfd1",":fiji:":"\\ud83c\\uddeb\\ud83c\\uddef",":file_cabinet:":"\\ud83d\\uddc4",":file_folder:":"\\ud83d\\udcc1",":film_frames:":"\\ud83c\\udf9e\\ufe0f",":film_projector:":"\\ud83d\\udcfd",":film_strip:":"\\ud83c\\udf9e",":fingers_crossed:":"\\ud83e\\udd1e",
":fingers_crossed_tone1:":"\\ud83e\\udd1e\\ud83c\\udffb",":fingers_crossed_tone2:":"\\ud83e\\udd1e\\ud83c\\udffc",":fingers_crossed_tone3:":"\\ud83e\\udd1e\\ud83c\\udffd",":fingers_crossed_tone4:":"\\ud83e\\udd1e\\ud83c\\udffe",":fingers_crossed_tone5:":"\\ud83e\\udd1e\\ud83c\\udfff",":finland:":"\\ud83c\\uddeb\\ud83c\\uddee",":fire:":"\\ud83d\\udd25",":fire_engine:":"\\ud83d\\ude92",":fireworks:":"\\ud83c\\udf86",":first_place:":"\\ud83e\\udd47",":first_quarter_moon:":"\\ud83c\\udf13",":first_quarter_moon_with_face:":"\\ud83c\\udf1b",
":fish:":"\\ud83d\\udc1f",":fish_cake:":"\\ud83c\\udf65",":fishing_pole_and_fish:":"\\ud83c\\udfa3",":fist:":"\\u270a",":fist_left:":"\\ud83e\\udd1b",":fist_oncoming:":"\\ud83d\\udc4a",":fist_raised:":"\\u270a",":fist_right:":"\\ud83e\\udd1c",":fist_tone1:":"\\u270a\\ud83c\\udffb",":fist_tone2:":"\\u270a\\ud83c\\udffc",":fist_tone3:":"\\u270a\\ud83c\\udffd",":fist_tone4:":"\\u270a\\ud83c\\udffe",":fist_tone5:":"\\u270a\\ud83c\\udfff",":five:":"5\\u20e3",":flag_ac:":"\\ud83c\\udde6\\ud83c\\udde8",":flag_ad:":"\\ud83c\\udde6\\ud83c\\udde9",
":flag_ae:":"\\ud83c\\udde6\\ud83c\\uddea",":flag_af:":"\\ud83c\\udde6\\ud83c\\uddeb",":flag_ag:":"\\ud83c\\udde6\\ud83c\\uddec",":flag_ai:":"\\ud83c\\udde6\\ud83c\\uddee",":flag_al:":"\\ud83c\\udde6\\ud83c\\uddf1",":flag_am:":"\\ud83c\\udde6\\ud83c\\uddf2",":flag_ao:":"\\ud83c\\udde6\\ud83c\\uddf4",":flag_aq:":"\\ud83c\\udde6\\ud83c\\uddf6",":flag_ar:":"\\ud83c\\udde6\\ud83c\\uddf7",":flag_as:":"\\ud83c\\udde6\\ud83c\\uddf8",":flag_at:":"\\ud83c\\udde6\\ud83c\\uddf9",":flag_au:":"\\ud83c\\udde6\\ud83c\\uddfa",":flag_aw:":"\\ud83c\\udde6\\ud83c\\uddfc",
":flag_ax:":"\\ud83c\\udde6\\ud83c\\uddfd",":flag_az:":"\\ud83c\\udde6\\ud83c\\uddff",":flag_ba:":"\\ud83c\\udde7\\ud83c\\udde6",":flag_bb:":"\\ud83c\\udde7\\ud83c\\udde7",":flag_bd:":"\\ud83c\\udde7\\ud83c\\udde9",":flag_be:":"\\ud83c\\udde7\\ud83c\\uddea",":flag_bf:":"\\ud83c\\udde7\\ud83c\\uddeb",":flag_bg:":"\\ud83c\\udde7\\ud83c\\uddec",":flag_bh:":"\\ud83c\\udde7\\ud83c\\udded",":flag_bi:":"\\ud83c\\udde7\\ud83c\\uddee",":flag_bj:":"\\ud83c\\udde7\\ud83c\\uddef",":flag_bl:":"\\ud83c\\udde7\\ud83c\\uddf1",":flag_black:":"\\ud83c\\udff4",":flag_bm:":"\\ud83c\\udde7\\ud83c\\uddf2",
":flag_bn:":"\\ud83c\\udde7\\ud83c\\uddf3",":flag_bo:":"\\ud83c\\udde7\\ud83c\\uddf4",":flag_bq:":"\\ud83c\\udde7\\ud83c\\uddf6",":flag_br:":"\\ud83c\\udde7\\ud83c\\uddf7",":flag_bs:":"\\ud83c\\udde7\\ud83c\\uddf8",":flag_bt:":"\\ud83c\\udde7\\ud83c\\uddf9",":flag_bv:":"\\ud83c\\udde7\\ud83c\\uddfb",":flag_bw:":"\\ud83c\\udde7\\ud83c\\uddfc",":flag_by:":"\\ud83c\\udde7\\ud83c\\uddfe",":flag_bz:":"\\ud83c\\udde7\\ud83c\\uddff",":flag_ca:":"\\ud83c\\udde8\\ud83c\\udde6",":flag_cc:":"\\ud83c\\udde8\\ud83c\\udde8",":flag_cd:":"\\ud83c\\udde8\\ud83c\\udde9",
":flag_cf:":"\\ud83c\\udde8\\ud83c\\uddeb",":flag_cg:":"\\ud83c\\udde8\\ud83c\\uddec",":flag_ch:":"\\ud83c\\udde8\\ud83c\\udded",":flag_ci:":"\\ud83c\\udde8\\ud83c\\uddee",":flag_ck:":"\\ud83c\\udde8\\ud83c\\uddf0",":flag_cl:":"\\ud83c\\udde8\\ud83c\\uddf1",":flag_cm:":"\\ud83c\\udde8\\ud83c\\uddf2",":flag_cn:":"\\ud83c\\udde8\\ud83c\\uddf3",":flag_co:":"\\ud83c\\udde8\\ud83c\\uddf4",":flag_cp:":"\\ud83c\\udde8\\ud83c\\uddf5",":flag_cr:":"\\ud83c\\udde8\\ud83c\\uddf7",":flag_cu:":"\\ud83c\\udde8\\ud83c\\uddfa",":flag_cv:":"\\ud83c\\udde8\\ud83c\\uddfb",
":flag_cw:":"\\ud83c\\udde8\\ud83c\\uddfc",":flag_cx:":"\\ud83c\\udde8\\ud83c\\uddfd",":flag_cy:":"\\ud83c\\udde8\\ud83c\\uddfe",":flag_cz:":"\\ud83c\\udde8\\ud83c\\uddff",":flag_de:":"\\ud83c\\udde9\\ud83c\\uddea",":flag_dg:":"\\ud83c\\udde9\\ud83c\\uddec",":flag_dj:":"\\ud83c\\udde9\\ud83c\\uddef",":flag_dk:":"\\ud83c\\udde9\\ud83c\\uddf0",":flag_dm:":"\\ud83c\\udde9\\ud83c\\uddf2",":flag_do:":"\\ud83c\\udde9\\ud83c\\uddf4",":flag_dz:":"\\ud83c\\udde9\\ud83c\\uddff",":flag_ea:":"\\ud83c\\uddea\\ud83c\\udde6",":flag_ec:":"\\ud83c\\uddea\\ud83c\\udde8",
":flag_ee:":"\\ud83c\\uddea\\ud83c\\uddea",":flag_eg:":"\\ud83c\\uddea\\ud83c\\uddec",":flag_eh:":"\\ud83c\\uddea\\ud83c\\udded",":flag_er:":"\\ud83c\\uddea\\ud83c\\uddf7",":flag_es:":"\\ud83c\\uddea\\ud83c\\uddf8",":flag_et:":"\\ud83c\\uddea\\ud83c\\uddf9",":flag_eu:":"\\ud83c\\uddea\\ud83c\\uddfa",":flag_fi:":"\\ud83c\\uddeb\\ud83c\\uddee",":flag_fj:":"\\ud83c\\uddeb\\ud83c\\uddef",":flag_fk:":"\\ud83c\\uddeb\\ud83c\\uddf0",":flag_fm:":"\\ud83c\\uddeb\\ud83c\\uddf2",":flag_fo:":"\\ud83c\\uddeb\\ud83c\\uddf4",":flag_fr:":"\\ud83c\\uddeb\\ud83c\\uddf7",
":flag_ga:":"\\ud83c\\uddec\\ud83c\\udde6",":flag_gb:":"\\ud83c\\uddec\\ud83c\\udde7",":flag_gd:":"\\ud83c\\uddec\\ud83c\\udde9",":flag_ge:":"\\ud83c\\uddec\\ud83c\\uddea",":flag_gf:":"\\ud83c\\uddec\\ud83c\\uddeb",":flag_gg:":"\\ud83c\\uddec\\ud83c\\uddec",":flag_gh:":"\\ud83c\\uddec\\ud83c\\udded",":flag_gi:":"\\ud83c\\uddec\\ud83c\\uddee",":flag_gl:":"\\ud83c\\uddec\\ud83c\\uddf1",":flag_gm:":"\\ud83c\\uddec\\ud83c\\uddf2",":flag_gn:":"\\ud83c\\uddec\\ud83c\\uddf3",":flag_gp:":"\\ud83c\\uddec\\ud83c\\uddf5",":flag_gq:":"\\ud83c\\uddec\\ud83c\\uddf6",
":flag_gr:":"\\ud83c\\uddec\\ud83c\\uddf7",":flag_gs:":"\\ud83c\\uddec\\ud83c\\uddf8",":flag_gt:":"\\ud83c\\uddec\\ud83c\\uddf9",":flag_gu:":"\\ud83c\\uddec\\ud83c\\uddfa",":flag_gw:":"\\ud83c\\uddec\\ud83c\\uddfc",":flag_gy:":"\\ud83c\\uddec\\ud83c\\uddfe",":flag_hk:":"\\ud83c\\udded\\ud83c\\uddf0",":flag_hm:":"\\ud83c\\udded\\ud83c\\uddf2",":flag_hn:":"\\ud83c\\udded\\ud83c\\uddf3",":flag_hr:":"\\ud83c\\udded\\ud83c\\uddf7",":flag_ht:":"\\ud83c\\udded\\ud83c\\uddf9",":flag_hu:":"\\ud83c\\udded\\ud83c\\uddfa",":flag_ic:":"\\ud83c\\uddee\\ud83c\\udde8",
":flag_id:":"\\ud83c\\uddee\\ud83c\\udde9",":flag_ie:":"\\ud83c\\uddee\\ud83c\\uddea",":flag_il:":"\\ud83c\\uddee\\ud83c\\uddf1",":flag_im:":"\\ud83c\\uddee\\ud83c\\uddf2",":flag_in:":"\\ud83c\\uddee\\ud83c\\uddf3",":flag_io:":"\\ud83c\\uddee\\ud83c\\uddf4",":flag_iq:":"\\ud83c\\uddee\\ud83c\\uddf6",":flag_ir:":"\\ud83c\\uddee\\ud83c\\uddf7",":flag_is:":"\\ud83c\\uddee\\ud83c\\uddf8",":flag_it:":"\\ud83c\\uddee\\ud83c\\uddf9",":flag_je:":"\\ud83c\\uddef\\ud83c\\uddea",":flag_jm:":"\\ud83c\\uddef\\ud83c\\uddf2",":flag_jo:":"\\ud83c\\uddef\\ud83c\\uddf4",
":flag_jp:":"\\ud83c\\uddef\\ud83c\\uddf5",":flag_ke:":"\\ud83c\\uddf0\\ud83c\\uddea",":flag_kg:":"\\ud83c\\uddf0\\ud83c\\uddec",":flag_kh:":"\\ud83c\\uddf0\\ud83c\\udded",":flag_ki:":"\\ud83c\\uddf0\\ud83c\\uddee",":flag_km:":"\\ud83c\\uddf0\\ud83c\\uddf2",":flag_kn:":"\\ud83c\\uddf0\\ud83c\\uddf3",":flag_kp:":"\\ud83c\\uddf0\\ud83c\\uddf5",":flag_kr:":"\\ud83c\\uddf0\\ud83c\\uddf7",":flag_kw:":"\\ud83c\\uddf0\\ud83c\\uddfc",":flag_ky:":"\\ud83c\\uddf0\\ud83c\\uddfe",":flag_kz:":"\\ud83c\\uddf0\\ud83c\\uddff",":flag_la:":"\\ud83c\\uddf1\\ud83c\\udde6",
":flag_lb:":"\\ud83c\\uddf1\\ud83c\\udde7",":flag_lc:":"\\ud83c\\uddf1\\ud83c\\udde8",":flag_li:":"\\ud83c\\uddf1\\ud83c\\uddee",":flag_lk:":"\\ud83c\\uddf1\\ud83c\\uddf0",":flag_lr:":"\\ud83c\\uddf1\\ud83c\\uddf7",":flag_ls:":"\\ud83c\\uddf1\\ud83c\\uddf8",":flag_lt:":"\\ud83c\\uddf1\\ud83c\\uddf9",":flag_lu:":"\\ud83c\\uddf1\\ud83c\\uddfa",":flag_lv:":"\\ud83c\\uddf1\\ud83c\\uddfb",":flag_ly:":"\\ud83c\\uddf1\\ud83c\\uddfe",":flag_ma:":"\\ud83c\\uddf2\\ud83c\\udde6",":flag_mc:":"\\ud83c\\uddf2\\ud83c\\udde8",":flag_md:":"\\ud83c\\uddf2\\ud83c\\udde9",
":flag_me:":"\\ud83c\\uddf2\\ud83c\\uddea",":flag_mf:":"\\ud83c\\uddf2\\ud83c\\uddeb",":flag_mg:":"\\ud83c\\uddf2\\ud83c\\uddec",":flag_mh:":"\\ud83c\\uddf2\\ud83c\\udded",":flag_mk:":"\\ud83c\\uddf2\\ud83c\\uddf0",":flag_ml:":"\\ud83c\\uddf2\\ud83c\\uddf1",":flag_mm:":"\\ud83c\\uddf2\\ud83c\\uddf2",":flag_mn:":"\\ud83c\\uddf2\\ud83c\\uddf3",":flag_mo:":"\\ud83c\\uddf2\\ud83c\\uddf4",":flag_mp:":"\\ud83c\\uddf2\\ud83c\\uddf5",":flag_mq:":"\\ud83c\\uddf2\\ud83c\\uddf6",":flag_mr:":"\\ud83c\\uddf2\\ud83c\\uddf7",":flag_ms:":"\\ud83c\\uddf2\\ud83c\\uddf8",
":flag_mt:":"\\ud83c\\uddf2\\ud83c\\uddf9",":flag_mu:":"\\ud83c\\uddf2\\ud83c\\uddfa",":flag_mv:":"\\ud83c\\uddf2\\ud83c\\uddfb",":flag_mw:":"\\ud83c\\uddf2\\ud83c\\uddfc",":flag_mx:":"\\ud83c\\uddf2\\ud83c\\uddfd",":flag_my:":"\\ud83c\\uddf2\\ud83c\\uddfe",":flag_mz:":"\\ud83c\\uddf2\\ud83c\\uddff",":flag_na:":"\\ud83c\\uddf3\\ud83c\\udde6",":flag_nc:":"\\ud83c\\uddf3\\ud83c\\udde8",":flag_ne:":"\\ud83c\\uddf3\\ud83c\\uddea",":flag_nf:":"\\ud83c\\uddf3\\ud83c\\uddeb",":flag_ng:":"\\ud83c\\uddf3\\ud83c\\uddec",":flag_ni:":"\\ud83c\\uddf3\\ud83c\\uddee",
":flag_nl:":"\\ud83c\\uddf3\\ud83c\\uddf1",":flag_no:":"\\ud83c\\uddf3\\ud83c\\uddf4",":flag_np:":"\\ud83c\\uddf3\\ud83c\\uddf5",":flag_nr:":"\\ud83c\\uddf3\\ud83c\\uddf7",":flag_nu:":"\\ud83c\\uddf3\\ud83c\\uddfa",":flag_nz:":"\\ud83c\\uddf3\\ud83c\\uddff",":flag_om:":"\\ud83c\\uddf4\\ud83c\\uddf2",":flag_pa:":"\\ud83c\\uddf5\\ud83c\\udde6",":flag_pe:":"\\ud83c\\uddf5\\ud83c\\uddea",":flag_pf:":"\\ud83c\\uddf5\\ud83c\\uddeb",":flag_pg:":"\\ud83c\\uddf5\\ud83c\\uddec",":flag_ph:":"\\ud83c\\uddf5\\ud83c\\udded",":flag_pk:":"\\ud83c\\uddf5\\ud83c\\uddf0",
":flag_pl:":"\\ud83c\\uddf5\\ud83c\\uddf1",":flag_pm:":"\\ud83c\\uddf5\\ud83c\\uddf2",":flag_pn:":"\\ud83c\\uddf5\\ud83c\\uddf3",":flag_pr:":"\\ud83c\\uddf5\\ud83c\\uddf7",":flag_ps:":"\\ud83c\\uddf5\\ud83c\\uddf8",":flag_pt:":"\\ud83c\\uddf5\\ud83c\\uddf9",":flag_pw:":"\\ud83c\\uddf5\\ud83c\\uddfc",":flag_py:":"\\ud83c\\uddf5\\ud83c\\uddfe",":flag_qa:":"\\ud83c\\uddf6\\ud83c\\udde6",":flag_re:":"\\ud83c\\uddf7\\ud83c\\uddea",":flag_ro:":"\\ud83c\\uddf7\\ud83c\\uddf4",":flag_rs:":"\\ud83c\\uddf7\\ud83c\\uddf8",":flag_ru:":"\\ud83c\\uddf7\\ud83c\\uddfa",
":flag_rw:":"\\ud83c\\uddf7\\ud83c\\uddfc",":flag_sa:":"\\ud83c\\uddf8\\ud83c\\udde6",":flag_sb:":"\\ud83c\\uddf8\\ud83c\\udde7",":flag_sc:":"\\ud83c\\uddf8\\ud83c\\udde8",":flag_sd:":"\\ud83c\\uddf8\\ud83c\\udde9",":flag_se:":"\\ud83c\\uddf8\\ud83c\\uddea",":flag_sg:":"\\ud83c\\uddf8\\ud83c\\uddec",":flag_sh:":"\\ud83c\\uddf8\\ud83c\\udded",":flag_si:":"\\ud83c\\uddf8\\ud83c\\uddee",":flag_sj:":"\\ud83c\\uddf8\\ud83c\\uddef",":flag_sk:":"\\ud83c\\uddf8\\ud83c\\uddf0",":flag_sl:":"\\ud83c\\uddf8\\ud83c\\uddf1",":flag_sm:":"\\ud83c\\uddf8\\ud83c\\uddf2",
":flag_sn:":"\\ud83c\\uddf8\\ud83c\\uddf3",":flag_so:":"\\ud83c\\uddf8\\ud83c\\uddf4",":flag_sr:":"\\ud83c\\uddf8\\ud83c\\uddf7",":flag_ss:":"\\ud83c\\uddf8\\ud83c\\uddf8",":flag_st:":"\\ud83c\\uddf8\\ud83c\\uddf9",":flag_sv:":"\\ud83c\\uddf8\\ud83c\\uddfb",":flag_sx:":"\\ud83c\\uddf8\\ud83c\\uddfd",":flag_sy:":"\\ud83c\\uddf8\\ud83c\\uddfe",":flag_sz:":"\\ud83c\\uddf8\\ud83c\\uddff",":flag_ta:":"\\ud83c\\uddf9\\ud83c\\udde6",":flag_tc:":"\\ud83c\\uddf9\\ud83c\\udde8",":flag_td:":"\\ud83c\\uddf9\\ud83c\\udde9",":flag_tf:":"\\ud83c\\uddf9\\ud83c\\uddeb",
":flag_tg:":"\\ud83c\\uddf9\\ud83c\\uddec",":flag_th:":"\\ud83c\\uddf9\\ud83c\\udded",":flag_tj:":"\\ud83c\\uddf9\\ud83c\\uddef",":flag_tk:":"\\ud83c\\uddf9\\ud83c\\uddf0",":flag_tl:":"\\ud83c\\uddf9\\ud83c\\uddf1",":flag_tm:":"\\ud83c\\uddf9\\ud83c\\uddf2",":flag_tn:":"\\ud83c\\uddf9\\ud83c\\uddf3",":flag_to:":"\\ud83c\\uddf9\\ud83c\\uddf4",":flag_tr:":"\\ud83c\\uddf9\\ud83c\\uddf7",":flag_tt:":"\\ud83c\\uddf9\\ud83c\\uddf9",":flag_tv:":"\\ud83c\\uddf9\\ud83c\\uddfb",":flag_tw:":"\\ud83c\\uddf9\\ud83c\\uddfc",":flag_tz:":"\\ud83c\\uddf9\\ud83c\\uddff",
":flag_ua:":"\\ud83c\\uddfa\\ud83c\\udde6",":flag_ug:":"\\ud83c\\uddfa\\ud83c\\uddec",":flag_um:":"\\ud83c\\uddfa\\ud83c\\uddf2",":flag_us:":"\\ud83c\\uddfa\\ud83c\\uddf8",":flag_uy:":"\\ud83c\\uddfa\\ud83c\\uddfe",":flag_uz:":"\\ud83c\\uddfa\\ud83c\\uddff",":flag_va:":"\\ud83c\\uddfb\\ud83c\\udde6",":flag_vc:":"\\ud83c\\uddfb\\ud83c\\udde8",":flag_ve:":"\\ud83c\\uddfb\\ud83c\\uddea",":flag_vg:":"\\ud83c\\uddfb\\ud83c\\uddec",":flag_vi:":"\\ud83c\\uddfb\\ud83c\\uddee",":flag_vn:":"\\ud83c\\uddfb\\ud83c\\uddf3",":flag_vu:":"\\ud83c\\uddfb\\ud83c\\uddfa",
":flag_wf:":"\\ud83c\\uddfc\\ud83c\\uddeb",":flag_white:":"\\ud83c\\udff3\\ufe0f",":flag_ws:":"\\ud83c\\uddfc\\ud83c\\uddf8",":flag_xk:":"\\ud83c\\uddfd\\ud83c\\uddf0",":flag_ye:":"\\ud83c\\uddfe\\ud83c\\uddea",":flag_yt:":"\\ud83c\\uddfe\\ud83c\\uddf9",":flag_za:":"\\ud83c\\uddff\\ud83c\\udde6",":flag_zm:":"\\ud83c\\uddff\\ud83c\\uddf2",":flag_zw:":"\\ud83c\\uddff\\ud83c\\uddfc",":flags:":"\\ud83c\\udf8f",":flashlight:":"\\ud83d\\udd26",":fleur-de-lis:":"\\u269c\\ufe0f",":fleur_de_lis:":"\\u269c\\ufe0f",":flight_arrival:":"\\ud83d\\udeec",
":flight_departure:":"\\ud83d\\udeeb",":flipper:":"\\ud83d\\udc2c",":floppy_disk:":"\\ud83d\\udcbe",":flower_playing_cards:":"\\ud83c\\udfb4",":flushed:":"\\ud83d\\ude33",":flying_saucer:":"\\ud83d\\udef8",":fog:":"\\ud83c\\udf2b",":foggy:":"\\ud83c\\udf01",":football:":"\\ud83c\\udfc8",":footprints:":"\\ud83d\\udc63",":fork_and_knife:":"\\ud83c\\udf74",":fork_knife_plate:":"\\ud83c\\udf7d\\ufe0f",":fortune_cookie:":"\\ud83e\\udd60",":fountain:":"\\u26f2\\ufe0f",":fountain_pen:":"\\ud83d\\udd8b",":four:":"4\\u20e3",":four_leaf_clover:":"\\ud83c\\udf40",
":fox:":"\\ud83e\\udd8a",":fox_face:":"\\ud83e\\udd8a",":fr:":"\\ud83c\\uddeb\\ud83c\\uddf7",":frame_photo:":"\\ud83d\\uddbc\\ufe0f",":framed_picture:":"\\ud83d\\uddbc",":free:":"\\ud83c\\udd93",":french_bread:":"\\ud83e\\udd56",":french_guiana:":"\\ud83c\\uddec\\ud83c\\uddeb",":french_polynesia:":"\\ud83c\\uddf5\\ud83c\\uddeb",":french_southern_territories:":"\\ud83c\\uddf9\\ud83c\\uddeb",":fried_egg:":"\\ud83c\\udf73",":fried_shrimp:":"\\ud83c\\udf64",":fries:":"\\ud83c\\udf5f",":frog:":"\\ud83d\\udc38",":frowning2:":"\\u2639\\ufe0f",
":frowning:":"\\ud83d\\ude26",":frowning_face:":"\\u2639\\ufe0f",":frowning_man:":"\\ud83d\\ude4d\\u200d\\u2642\\ufe0f",":frowning_woman:":"\\ud83d\\ude4d",":fu:":"\\ud83d\\udd95",":fuelpump:":"\\u26fd\\ufe0f",":full_moon:":"\\ud83c\\udf15",":full_moon_with_face:":"\\ud83c\\udf1d",":funeral_urn:":"\\u26b1\\ufe0f",":gabon:":"\\ud83c\\uddec\\ud83c\\udde6",":gambia:":"\\ud83c\\uddec\\ud83c\\uddf2",":game_die:":"\\ud83c\\udfb2",":gb:":"\\ud83c\\uddec\\ud83c\\udde7",":gear:":"\\u2699\\ufe0f",":gem:":"\\ud83d\\udc8e",":gemini:":"\\u264a\\ufe0f",
":genie:":"\\ud83e\\uddde",":georgia:":"\\ud83c\\uddec\\ud83c\\uddea",":ghana:":"\\ud83c\\uddec\\ud83c\\udded",":ghost:":"\\ud83d\\udc7b",":gibraltar:":"\\ud83c\\uddec\\ud83c\\uddee",":gift:":"\\ud83c\\udf81",":gift_heart:":"\\ud83d\\udc9d",":giraffe:":"\\ud83e\\udd92",":girl:":"\\ud83d\\udc67",":girl_tone1:":"\\ud83d\\udc67\\ud83c\\udffb",":girl_tone2:":"\\ud83d\\udc67\\ud83c\\udffc",":girl_tone3:":"\\ud83d\\udc67\\ud83c\\udffd",":girl_tone4:":"\\ud83d\\udc67\\ud83c\\udffe",":girl_tone5:":"\\ud83d\\udc67\\ud83c\\udfff",":globe_with_meridians:":"\\ud83c\\udf10",
":gloves:":"\\ud83e\\udde4",":goal:":"\\ud83e\\udd45",":goal_net:":"\\ud83e\\udd45",":goat:":"\\ud83d\\udc10",":golf:":"\\u26f3\\ufe0f",":golfing_man:":"\\ud83c\\udfcc",":golfing_woman:":"\\ud83c\\udfcc\\ufe0f\\u200d\\u2640\\ufe0f",":gorilla:":"\\ud83e\\udd8d",":grapes:":"\\ud83c\\udf47",":greece:":"\\ud83c\\uddec\\ud83c\\uddf7",":green_apple:":"\\ud83c\\udf4f",":green_book:":"\\ud83d\\udcd7",":green_heart:":"\\ud83d\\udc9a",":green_salad:":"\\ud83e\\udd57",":greenland:":"\\ud83c\\uddec\\ud83c\\uddf1",":grenada:":"\\ud83c\\uddec\\ud83c\\udde9",
":grey_exclamation:":"\\u2755",":grey_question:":"\\u2754",":grimacing:":"\\ud83d\\ude2c",":grin:":"\\ud83d\\ude01",":grinning:":"\\ud83d\\ude00",":guadeloupe:":"\\ud83c\\uddec\\ud83c\\uddf5",":guam:":"\\ud83c\\uddec\\ud83c\\uddfa",":guard:":"\\ud83d\\udc82\\ud83c\\udfff",":guard_tone1:":"\\ud83d\\udc82\\ud83c\\udffb",":guard_tone2:":"\\ud83d\\udc82\\ud83c\\udffc",":guard_tone3:":"\\ud83d\\udc82\\ud83c\\udffd",":guard_tone4:":"\\ud83d\\udc82\\ud83c\\udffe",":guard_tone5:":"\\ud83d\\udc82\\ud83c\\udfff",":guardsman:":"\\ud83d\\udc82",":guardswoman:":"\\ud83d\\udc82\\u200d\\u2640\\ufe0f",
":guatemala:":"\\ud83c\\uddec\\ud83c\\uddf9",":guernsey:":"\\ud83c\\uddec\\ud83c\\uddec",":guinea:":"\\ud83c\\uddec\\ud83c\\uddf3",":guinea_bissau:":"\\ud83c\\uddec\\ud83c\\uddfc",":guitar:":"\\ud83c\\udfb8",":gun:":"\\ud83d\\udd2b",":guyana:":"\\ud83c\\uddec\\ud83c\\uddfe",":haircut:":"\\ud83d\\udc87",":haircut_man:":"\\ud83d\\udc87\\u200d\\u2642\\ufe0f",":haircut_woman:":"\\ud83d\\udc87",":haiti:":"\\ud83c\\udded\\ud83c\\uddf9",":hamburger:":"\\ud83c\\udf54",":hammer:":"\\ud83d\\udd28",":hammer_and_pick:":"\\u2692",":hammer_and_wrench:":"\\ud83d\\udee0",
":hammer_pick:":"\\u2692\\ufe0f",":hamster:":"\\ud83d\\udc39",":hand:":"\\u270b",":hand_splayed:":"\\ud83d\\udd90\\ufe0f",":hand_splayed_tone1:":"\\ud83d\\udd90\\ud83c\\udffb",":hand_splayed_tone2:":"\\ud83d\\udd90\\ud83c\\udffc",":hand_splayed_tone3:":"\\ud83d\\udd90\\ud83c\\udffd",":hand_splayed_tone4:":"\\ud83d\\udd90\\ud83c\\udffe",":hand_splayed_tone5:":"\\ud83d\\udd90\\ud83c\\udfff",":handbag:":"\\ud83d\\udc5c",":handshake:":"\\ud83e\\udd1d",":hankey:":"\\ud83d\\udca9",":hash:":"#\\u20e3",":hatched_chick:":"\\ud83d\\udc25",":hatching_chick:":"\\ud83d\\udc23",
":head_bandage:":"\\ud83e\\udd15",":headphones:":"\\ud83c\\udfa7",":hear_no_evil:":"\\ud83d\\ude49",":heart:":"\\u2764\\ufe0f",":heart_decoration:":"\\ud83d\\udc9f",":heart_exclamation:":"\\u2763\\ufe0f",":heart_eyes:":"\\ud83d\\ude0d",":heart_eyes_cat:":"\\ud83d\\ude3b",":heartbeat:":"\\ud83d\\udc93",":heartpulse:":"\\ud83d\\udc97",":hearts:":"\\u2665\\ufe0f",":heavy_check_mark:":"\\u2714\\ufe0f",":heavy_division_sign:":"\\u2797",":heavy_dollar_sign:":"\\ud83d\\udcb2",":heavy_exclamation_mark:":"\\u2757\\ufe0f",":heavy_heart_exclamation:":"\\u2763\\ufe0f",
":heavy_minus_sign:":"\\u2796",":heavy_multiplication_x:":"\\u2716\\ufe0f",":heavy_plus_sign:":"\\u2795",":hedgehog:":"\\ud83e\\udd94",":helicopter:":"\\ud83d\\ude81",":helmet_with_cross:":"\\u26d1\\ufe0f",":herb:":"\\ud83c\\udf3f",":hibiscus:":"\\ud83c\\udf3a",":high_brightness:":"\\ud83d\\udd06",":high_heel:":"\\ud83d\\udc60",":hocho:":"\\ud83d\\udd2a",":hockey:":"\\ud83c\\udfd2",":hole:":"\\ud83d\\udd73",":homes:":"\\ud83c\\udfd8\\ufe0f",":honduras:":"\\ud83c\\udded\\ud83c\\uddf3",":honey_pot:":"\\ud83c\\udf6f",":honeybee:":"\\ud83d\\udc1d",
":hong_kong:":"\\ud83c\\udded\\ud83c\\uddf0",":horse:":"\\ud83d\\udc34",":horse_racing:":"\\ud83c\\udfc7",":horse_racing_tone1:":"\\ud83c\\udfc7\\ud83c\\udffb",":horse_racing_tone2:":"\\ud83c\\udfc7\\ud83c\\udffc",":horse_racing_tone3:":"\\ud83c\\udfc7\\ud83c\\udffd",":horse_racing_tone4:":"\\ud83c\\udfc7\\ud83c\\udffe",":horse_racing_tone5:":"\\ud83c\\udfc7\\ud83c\\udfff",":hospital:":"\\ud83c\\udfe5",":hot_pepper:":"\\ud83c\\udf36",":hotdog:":"\\ud83c\\udf2d",":hotel:":"\\ud83c\\udfe8",":hotsprings:":"\\u2668\\ufe0f",":hourglass:":"\\u231b\\ufe0f",
":hourglass_flowing_sand:":"\\u23f3",":house:":"\\ud83c\\udfe0",":house_abandoned:":"\\ud83c\\udfda\\ufe0f",":house_with_garden:":"\\ud83c\\udfe1",":houses:":"\\ud83c\\udfd8",":hugging:":"\\ud83e\\udd17",":hugs:":"\\ud83e\\udd17",":hungary:":"\\ud83c\\udded\\ud83c\\uddfa",":hushed:":"\\ud83d\\ude2f",":ice_cream:":"\\ud83c\\udf68",":ice_hockey:":"\\ud83c\\udfd2",":ice_skate:":"\\u26f8",":icecream:":"\\ud83c\\udf66",":iceland:":"\\ud83c\\uddee\\ud83c\\uddf8",":id:":"\\ud83c\\udd94",":ideograph_advantage:":"\\ud83c\\ude50",":imp:":"\\ud83d\\udc7f",
":inbox_tray:":"\\ud83d\\udce5",":incoming_envelope:":"\\ud83d\\udce8",":india:":"\\ud83c\\uddee\\ud83c\\uddf3",":indonesia:":"\\ud83c\\uddee\\ud83c\\udde9",":information_desk_person:":"\\ud83d\\udc81",":information_source:":"\\u2139\\ufe0f",":innocent:":"\\ud83d\\ude07",":interrobang:":"\\u2049\\ufe0f",":iphone:":"\\ud83d\\udcf1",":iran:":"\\ud83c\\uddee\\ud83c\\uddf7",":iraq:":"\\ud83c\\uddee\\ud83c\\uddf6",":ireland:":"\\ud83c\\uddee\\ud83c\\uddea",":island:":"\\ud83c\\udfdd\\ufe0f",":isle_of_man:":"\\ud83c\\uddee\\ud83c\\uddf2",":israel:":"\\ud83c\\uddee\\ud83c\\uddf1",
":it:":"\\ud83c\\uddee\\ud83c\\uddf9",":izakaya_lantern:":"\\ud83c\\udfee",":jack_o_lantern:":"\\ud83c\\udf83",":jamaica:":"\\ud83c\\uddef\\ud83c\\uddf2",":japan:":"\\ud83d\\uddfe",":japanese_castle:":"\\ud83c\\udfef",":japanese_goblin:":"\\ud83d\\udc7a",":japanese_ogre:":"\\ud83d\\udc79",":jeans:":"\\ud83d\\udc56",":jersey:":"\\ud83c\\uddef\\ud83c\\uddea",":jordan:":"\\ud83c\\uddef\\ud83c\\uddf4",":joy:":"\\ud83d\\ude02",":joy_cat:":"\\ud83d\\ude39",":joystick:":"\\ud83d\\udd79",":jp:":"\\ud83c\\uddef\\ud83c\\uddf5",":kaaba:":"\\ud83d\\udd4b",
":kazakhstan:":"\\ud83c\\uddf0\\ud83c\\uddff",":kenya:":"\\ud83c\\uddf0\\ud83c\\uddea",":key2:":"\\ud83d\\udddd\\ufe0f",":key:":"\\ud83d\\udd11",":keyboard:":"\\u2328\\ufe0f",":keycap_ten:":"\\ud83d\\udd1f",":kick_scooter:":"\\ud83d\\udef4",":kimono:":"\\ud83d\\udc58",":kiribati:":"\\ud83c\\uddf0\\ud83c\\uddee",":kiss:":"\\ud83d\\udc8b",":kiss_mm:":"\\ud83d\\udc68\\u200d\\u2764\\ufe0f\\u200d\\ud83d\\udc8b\\u200d\\ud83d\\udc68",":kiss_woman_man:":"\\ud83d\\udc69\\u200d\\u2764\\ufe0f\\u200d\\ud83d\\udc8b\\u200d\\ud83d\\udc68",":kiss_ww:":"\\ud83d\\udc69\\u200d\\u2764\\ufe0f\\u200d\\ud83d\\udc8b\\u200d\\ud83d\\udc69",
":kissing:":"\\ud83d\\ude17",":kissing_cat:":"\\ud83d\\ude3d",":kissing_closed_eyes:":"\\ud83d\\ude1a",":kissing_heart:":"\\ud83d\\ude18",":kissing_smiling_eyes:":"\\ud83d\\ude19",":kiwi:":"\\ud83e\\udd5d",":kiwi_fruit:":"\\ud83e\\udd5d",":knife:":"\\ud83d\\udd2a",":koala:":"\\ud83d\\udc28",":koko:":"\\ud83c\\ude01",":kosovo:":"\\ud83c\\uddfd\\ud83c\\uddf0",":kr:":"\\ud83c\\uddf0\\ud83c\\uddf7",":kuwait:":"\\ud83c\\uddf0\\ud83c\\uddfc",":kyrgyzstan:":"\\ud83c\\uddf0\\ud83c\\uddec",":label:":"\\ud83c\\udff7",":lantern:":"\\ud83c\\udfee",
":laos:":"\\ud83c\\uddf1\\ud83c\\udde6",":large_blue_circle:":"\\ud83d\\udd35",":large_blue_diamond:":"\\ud83d\\udd37",":large_orange_diamond:":"\\ud83d\\udd36",":last_quarter_moon:":"\\ud83c\\udf17",":last_quarter_moon_with_face:":"\\ud83c\\udf1c",":latin_cross:":"\\u271d\\ufe0f",":latvia:":"\\ud83c\\uddf1\\ud83c\\uddfb",":laughing:":"\\ud83d\\ude06",":leaves:":"\\ud83c\\udf43",":lebanon:":"\\ud83c\\uddf1\\ud83c\\udde7",":ledger:":"\\ud83d\\udcd2",":left_facing_fist:":"\\ud83e\\udd1b",":left_facing_fist_tone1:":"\\ud83e\\udd1b\\ud83c\\udffb",
":left_facing_fist_tone2:":"\\ud83e\\udd1b\\ud83c\\udffc",":left_facing_fist_tone3:":"\\ud83e\\udd1b\\ud83c\\udffd",":left_facing_fist_tone4:":"\\ud83e\\udd1b\\ud83c\\udffe",":left_facing_fist_tone5:":"\\ud83e\\udd1b\\ud83c\\udfff",":left_luggage:":"\\ud83d\\udec5",":left_right_arrow:":"\\u2194\\ufe0f",":leftwards_arrow_with_hook:":"\\u21a9\\ufe0f",":lemon:":"\\ud83c\\udf4b",":leo:":"\\u264c\\ufe0f",":leopard:":"\\ud83d\\udc06",":lesotho:":"\\ud83c\\uddf1\\ud83c\\uddf8",":level_slider:":"\\ud83c\\udf9a",":levitate:":"\\ud83d\\udd74",
":liberia:":"\\ud83c\\uddf1\\ud83c\\uddf7",":libra:":"\\u264e\\ufe0f",":libya:":"\\ud83c\\uddf1\\ud83c\\uddfe",":liechtenstein:":"\\ud83c\\uddf1\\ud83c\\uddee",":light_rail:":"\\ud83d\\ude88",":link:":"\\ud83d\\udd17",":lion:":"\\ud83e\\udd81",":lion_face:":"\\ud83e\\udd81",":lips:":"\\ud83d\\udc44",":lipstick:":"\\ud83d\\udc84",":lithuania:":"\\ud83c\\uddf1\\ud83c\\uddf9",":lizard:":"\\ud83e\\udd8e",":lock:":"\\ud83d\\udd12",":lock_with_ink_pen:":"\\ud83d\\udd0f",":lol:":"\\ud83d\\ude02",":lollipop:":"\\ud83c\\udf6d",":loop:":"\\u27bf",
":loud_sound:":"\\ud83d\\udd0a",":loudspeaker:":"\\ud83d\\udce2",":love_hotel:":"\\ud83c\\udfe9",":love_letter:":"\\ud83d\\udc8c",":love_you_gesture:":"\\ud83e\\udd1f",":love_you_gesture_tone1:":"\\ud83e\\udd1f\\ud83c\\udffb",":love_you_gesture_tone2:":"\\ud83e\\udd1f\\ud83c\\udffc",":love_you_gesture_tone3:":"\\ud83e\\udd1f\\ud83c\\udffd",":love_you_gesture_tone4:":"\\ud83e\\udd1f\\ud83c\\udffe",":love_you_gesture_tone5:":"\\ud83e\\udd1f\\ud83c\\udfff",":low_brightness:":"\\ud83d\\udd05",":luxembourg:":"\\ud83c\\uddf1\\ud83c\\uddfa",
":lying_face:":"\\ud83e\\udd25",":m:":"\\u24c2\\ufe0f",":macau:":"\\ud83c\\uddf2\\ud83c\\uddf4",":macedonia:":"\\ud83c\\uddf2\\ud83c\\uddf0",":madagascar:":"\\ud83c\\uddf2\\ud83c\\uddec",":mag:":"\\ud83d\\udd0d",":mag_right:":"\\ud83d\\udd0e",":mage:":"\\ud83e\\uddd9\\ud83c\\udfff",":mage_tone1:":"\\ud83e\\uddd9\\ud83c\\udffb",":mage_tone2:":"\\ud83e\\uddd9\\ud83c\\udffc",":mage_tone3:":"\\ud83e\\uddd9\\ud83c\\udffd",":mage_tone4:":"\\ud83e\\uddd9\\ud83c\\udffe",":mage_tone5:":"\\ud83e\\uddd9\\ud83c\\udfff",":mahjong:":"\\ud83c\\udc04\\ufe0f",
":mailbox:":"\\ud83d\\udceb",":mailbox_closed:":"\\ud83d\\udcea",":mailbox_with_mail:":"\\ud83d\\udcec",":mailbox_with_no_mail:":"\\ud83d\\udced",":malawi:":"\\ud83c\\uddf2\\ud83c\\uddfc",":malaysia:":"\\ud83c\\uddf2\\ud83c\\uddfe",":maldives:":"\\ud83c\\uddf2\\ud83c\\uddfb",":male_detective:":"\\ud83d\\udd75",":male_sign:":"\\u2642\\ufe0f",":mali:":"\\ud83c\\uddf2\\ud83c\\uddf1",":malta:":"\\ud83c\\uddf2\\ud83c\\uddf9",":man:":"\\ud83d\\udc68",":man_artist:":"\\ud83d\\udc68\\u200d\\ud83c\\udfa8",":man_artist_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\ud83c\\udfa8",
":man_artist_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\ud83c\\udfa8",":man_artist_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\ud83c\\udfa8",":man_artist_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\ud83c\\udfa8",":man_artist_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\ud83c\\udfa8",":man_astronaut:":"\\ud83d\\udc68\\u200d\\ud83d\\ude80",":man_astronaut_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\ud83d\\ude80",":man_astronaut_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\ud83d\\ude80",":man_astronaut_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\ud83d\\ude80",
":man_astronaut_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\ud83d\\ude80",":man_astronaut_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\ud83d\\ude80",":man_biking:":"\\ud83d\\udeb4\\u200d\\u2642\\ufe0f",":man_biking_tone1:":"\\ud83d\\udeb4\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_biking_tone2:":"\\ud83d\\udeb4\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_biking_tone3:":"\\ud83d\\udeb4\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_biking_tone4:":"\\ud83d\\udeb4\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_biking_tone5:":"\\ud83d\\udeb4\\ud83c\\udfff\\u200d\\u2642\\ufe0f",
":man_bouncing_ball:":"\\u26f9\\ufe0f\\u200d\\u2642\\ufe0f",":man_bouncing_ball_tone1:":"\\u26f9\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_bouncing_ball_tone2:":"\\u26f9\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_bouncing_ball_tone3:":"\\u26f9\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_bouncing_ball_tone4:":"\\u26f9\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_bouncing_ball_tone5:":"\\u26f9\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_bowing:":"\\ud83d\\ude47\\u200d\\u2642\\ufe0f",":man_bowing_tone1:":"\\ud83d\\ude47\\ud83c\\udffb\\u200d\\u2642\\ufe0f",
":man_bowing_tone2:":"\\ud83d\\ude47\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_bowing_tone3:":"\\ud83d\\ude47\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_bowing_tone4:":"\\ud83d\\ude47\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_bowing_tone5:":"\\ud83d\\ude47\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_cartwheeling:":"\\ud83e\\udd38\\u200d\\u2642\\ufe0f",":man_cartwheeling_tone1:":"\\ud83e\\udd38\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_cartwheeling_tone2:":"\\ud83e\\udd38\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_cartwheeling_tone3:":"\\ud83e\\udd38\\ud83c\\udffd\\u200d\\u2642\\ufe0f",
":man_cartwheeling_tone4:":"\\ud83e\\udd38\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_cartwheeling_tone5:":"\\ud83e\\udd38\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_climbing:":"\\ud83e\\uddd7\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_climbing_tone1:":"\\ud83e\\uddd7\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_climbing_tone2:":"\\ud83e\\uddd7\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_climbing_tone3:":"\\ud83e\\uddd7\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_climbing_tone4:":"\\ud83e\\uddd7\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_climbing_tone5:":"\\ud83e\\uddd7\\ud83c\\udfff\\u200d\\u2642\\ufe0f",
":man_construction_worker:":"\\ud83d\\udc77\\u200d\\u2642\\ufe0f",":man_construction_worker_tone1:":"\\ud83d\\udc77\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_construction_worker_tone2:":"\\ud83d\\udc77\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_construction_worker_tone3:":"\\ud83d\\udc77\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_construction_worker_tone4:":"\\ud83d\\udc77\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_construction_worker_tone5:":"\\ud83d\\udc77\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_cook:":"\\ud83d\\udc68\\u200d\\ud83c\\udf73",
":man_cook_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\ud83c\\udf73",":man_cook_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\ud83c\\udf73",":man_cook_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\ud83c\\udf73",":man_cook_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\ud83c\\udf73",":man_cook_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\ud83c\\udf73",":man_dancing:":"\\ud83d\\udd7a",":man_dancing_tone1:":"\\ud83d\\udd7a\\ud83c\\udffb",":man_dancing_tone2:":"\\ud83d\\udd7a\\ud83c\\udffc",":man_dancing_tone3:":"\\ud83d\\udd7a\\ud83c\\udffd",":man_dancing_tone4:":"\\ud83d\\udd7a\\ud83c\\udffe",
":man_dancing_tone5:":"\\ud83d\\udd7a\\ud83c\\udfff",":man_detective:":"\\ud83d\\udd75\\ufe0f\\u200d\\u2642\\ufe0f",":man_detective_tone1:":"\\ud83d\\udd75\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_detective_tone2:":"\\ud83d\\udd75\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_detective_tone3:":"\\ud83d\\udd75\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_detective_tone4:":"\\ud83d\\udd75\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_detective_tone5:":"\\ud83d\\udd75\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_elf:":"\\ud83e\\udddd\\ud83c\\udfff\\u200d\\u2642\\ufe0f",
":man_elf_tone1:":"\\ud83e\\udddd\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_elf_tone2:":"\\ud83e\\udddd\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_elf_tone3:":"\\ud83e\\udddd\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_elf_tone4:":"\\ud83e\\udddd\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_elf_tone5:":"\\ud83e\\udddd\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_facepalming:":"\\ud83e\\udd26\\u200d\\u2642\\ufe0f",":man_facepalming_tone1:":"\\ud83e\\udd26\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_facepalming_tone2:":"\\ud83e\\udd26\\ud83c\\udffc\\u200d\\u2642\\ufe0f",
":man_facepalming_tone3:":"\\ud83e\\udd26\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_facepalming_tone4:":"\\ud83e\\udd26\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_facepalming_tone5:":"\\ud83e\\udd26\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_factory_worker:":"\\ud83d\\udc68\\u200d\\ud83c\\udfed",":man_factory_worker_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\ud83c\\udfed",":man_factory_worker_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\ud83c\\udfed",":man_factory_worker_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\ud83c\\udfed",":man_factory_worker_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\ud83c\\udfed",
":man_factory_worker_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\ud83c\\udfed",":man_fairy:":"\\ud83e\\uddda\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_fairy_tone1:":"\\ud83e\\uddda\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_fairy_tone2:":"\\ud83e\\uddda\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_fairy_tone3:":"\\ud83e\\uddda\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_fairy_tone4:":"\\ud83e\\uddda\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_fairy_tone5:":"\\ud83e\\uddda\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_farmer:":"\\ud83d\\udc68\\u200d\\ud83c\\udf3e",
":man_farmer_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\ud83c\\udf3e",":man_farmer_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\ud83c\\udf3e",":man_farmer_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\ud83c\\udf3e",":man_farmer_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\ud83c\\udf3e",":man_farmer_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\ud83c\\udf3e",":man_firefighter:":"\\ud83d\\udc68\\u200d\\ud83d\\ude92",":man_firefighter_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\ud83d\\ude92",":man_firefighter_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\ud83d\\ude92",
":man_firefighter_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\ud83d\\ude92",":man_firefighter_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\ud83d\\ude92",":man_firefighter_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\ud83d\\ude92",":man_frowning:":"\\ud83d\\ude4d\\u200d\\u2642\\ufe0f",":man_frowning_tone1:":"\\ud83d\\ude4d\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_frowning_tone2:":"\\ud83d\\ude4d\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_frowning_tone3:":"\\ud83d\\ude4d\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_frowning_tone4:":"\\ud83d\\ude4d\\ud83c\\udffe\\u200d\\u2642\\ufe0f",
":man_frowning_tone5:":"\\ud83d\\ude4d\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_genie:":"\\ud83e\\uddde\\u200d\\u2642\\ufe0f",":man_gesturing_no:":"\\ud83d\\ude45\\u200d\\u2642\\ufe0f",":man_gesturing_no_tone1:":"\\ud83d\\ude45\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_gesturing_no_tone2:":"\\ud83d\\ude45\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_gesturing_no_tone3:":"\\ud83d\\ude45\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_gesturing_no_tone4:":"\\ud83d\\ude45\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_gesturing_no_tone5:":"\\ud83d\\ude45\\ud83c\\udfff\\u200d\\u2642\\ufe0f",
":man_gesturing_ok:":"\\ud83d\\ude46\\u200d\\u2642\\ufe0f",":man_gesturing_ok_tone1:":"\\ud83d\\ude46\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_gesturing_ok_tone2:":"\\ud83d\\ude46\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_gesturing_ok_tone3:":"\\ud83d\\ude46\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_gesturing_ok_tone4:":"\\ud83d\\ude46\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_gesturing_ok_tone5:":"\\ud83d\\ude46\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_getting_face_massage:":"\\ud83d\\udc86\\u200d\\u2642\\ufe0f",":man_getting_face_massage_tone1:":"\\ud83d\\udc86\\ud83c\\udffb\\u200d\\u2642\\ufe0f",
":man_getting_face_massage_tone2:":"\\ud83d\\udc86\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_getting_face_massage_tone3:":"\\ud83d\\udc86\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_getting_face_massage_tone4:":"\\ud83d\\udc86\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_getting_face_massage_tone5:":"\\ud83d\\udc86\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_getting_haircut:":"\\ud83d\\udc87\\u200d\\u2642\\ufe0f",":man_getting_haircut_tone1:":"\\ud83d\\udc87\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_getting_haircut_tone2:":"\\ud83d\\udc87\\ud83c\\udffc\\u200d\\u2642\\ufe0f",
":man_getting_haircut_tone3:":"\\ud83d\\udc87\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_getting_haircut_tone4:":"\\ud83d\\udc87\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_getting_haircut_tone5:":"\\ud83d\\udc87\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_golfing:":"\\ud83c\\udfcc\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_golfing_tone1:":"\\ud83c\\udfcc\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_golfing_tone2:":"\\ud83c\\udfcc\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_golfing_tone3:":"\\ud83c\\udfcc\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_golfing_tone4:":"\\ud83c\\udfcc\\ud83c\\udffe\\u200d\\u2642\\ufe0f",
":man_golfing_tone5:":"\\ud83c\\udfcc\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_guard:":"\\ud83d\\udc82\\u200d\\u2642\\ufe0f",":man_guard_tone1:":"\\ud83d\\udc82\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_guard_tone2:":"\\ud83d\\udc82\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_guard_tone3:":"\\ud83d\\udc82\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_guard_tone4:":"\\ud83d\\udc82\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_guard_tone5:":"\\ud83d\\udc82\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_health_worker:":"\\ud83d\\udc68\\u200d\\u2695\\ufe0f",":man_health_worker_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\u2695\\ufe0f",
":man_health_worker_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\u2695\\ufe0f",":man_health_worker_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\u2695\\ufe0f",":man_health_worker_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\u2695\\ufe0f",":man_health_worker_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\u2695\\ufe0f",":man_in_business_suit_levitating_tone1:":"\\ud83d\\udd74\\ud83c\\udffb",":man_in_business_suit_levitating_tone2:":"\\ud83d\\udd74\\ud83c\\udffc",":man_in_business_suit_levitating_tone3:":"\\ud83d\\udd74\\ud83c\\udffd",":man_in_business_suit_levitating_tone4:":"\\ud83d\\udd74\\ud83c\\udffe",
":man_in_business_suit_levitating_tone5:":"\\ud83d\\udd74\\ud83c\\udfff",":man_in_lotus_position:":"\\ud83e\\uddd8\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_in_lotus_position_tone1:":"\\ud83e\\uddd8\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_in_lotus_position_tone2:":"\\ud83e\\uddd8\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_in_lotus_position_tone3:":"\\ud83e\\uddd8\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_in_lotus_position_tone4:":"\\ud83e\\uddd8\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_in_lotus_position_tone5:":"\\ud83e\\uddd8\\ud83c\\udfff\\u200d\\u2642\\ufe0f",
":man_in_steamy_room:":"\\ud83e\\uddd6\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_in_steamy_room_tone1:":"\\ud83e\\uddd6\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_in_steamy_room_tone2:":"\\ud83e\\uddd6\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_in_steamy_room_tone3:":"\\ud83e\\uddd6\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_in_steamy_room_tone4:":"\\ud83e\\uddd6\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_in_steamy_room_tone5:":"\\ud83e\\uddd6\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_in_tuxedo:":"\\ud83e\\udd35",":man_in_tuxedo_tone1:":"\\ud83e\\udd35\\ud83c\\udffb",
":man_in_tuxedo_tone2:":"\\ud83e\\udd35\\ud83c\\udffc",":man_in_tuxedo_tone3:":"\\ud83e\\udd35\\ud83c\\udffd",":man_in_tuxedo_tone4:":"\\ud83e\\udd35\\ud83c\\udffe",":man_in_tuxedo_tone5:":"\\ud83e\\udd35\\ud83c\\udfff",":man_judge:":"\\ud83d\\udc68\\u200d\\u2696\\ufe0f",":man_judge_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\u2696\\ufe0f",":man_judge_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\u2696\\ufe0f",":man_judge_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\u2696\\ufe0f",":man_judge_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\u2696\\ufe0f",
":man_judge_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\u2696\\ufe0f",":man_juggling:":"\\ud83e\\udd39\\u200d\\u2642\\ufe0f",":man_juggling_tone1:":"\\ud83e\\udd39\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_juggling_tone2:":"\\ud83e\\udd39\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_juggling_tone3:":"\\ud83e\\udd39\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_juggling_tone4:":"\\ud83e\\udd39\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_juggling_tone5:":"\\ud83e\\udd39\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_lifting_weights:":"\\ud83c\\udfcb\\ufe0f\\u200d\\u2642\\ufe0f",
":man_lifting_weights_tone1:":"\\ud83c\\udfcb\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_lifting_weights_tone2:":"\\ud83c\\udfcb\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_lifting_weights_tone3:":"\\ud83c\\udfcb\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_lifting_weights_tone4:":"\\ud83c\\udfcb\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_lifting_weights_tone5:":"\\ud83c\\udfcb\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_mage:":"\\ud83e\\uddd9\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_mage_tone1:":"\\ud83e\\uddd9\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_mage_tone2:":"\\ud83e\\uddd9\\ud83c\\udffc\\u200d\\u2642\\ufe0f",
":man_mage_tone3:":"\\ud83e\\uddd9\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_mage_tone4:":"\\ud83e\\uddd9\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_mage_tone5:":"\\ud83e\\uddd9\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_mechanic:":"\\ud83d\\udc68\\u200d\\ud83d\\udd27",":man_mechanic_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\ud83d\\udd27",":man_mechanic_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\ud83d\\udd27",":man_mechanic_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\ud83d\\udd27",":man_mechanic_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\ud83d\\udd27",
":man_mechanic_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\ud83d\\udd27",":man_mountain_biking:":"\\ud83d\\udeb5\\u200d\\u2642\\ufe0f",":man_mountain_biking_tone1:":"\\ud83d\\udeb5\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_mountain_biking_tone2:":"\\ud83d\\udeb5\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_mountain_biking_tone3:":"\\ud83d\\udeb5\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_mountain_biking_tone4:":"\\ud83d\\udeb5\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_mountain_biking_tone5:":"\\ud83d\\udeb5\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_office_worker:":"\\ud83d\\udc68\\u200d\\ud83d\\udcbc",
":man_office_worker_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\ud83d\\udcbc",":man_office_worker_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\ud83d\\udcbc",":man_office_worker_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\ud83d\\udcbc",":man_office_worker_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\ud83d\\udcbc",":man_office_worker_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\ud83d\\udcbc",":man_pilot:":"\\ud83d\\udc68\\u200d\\u2708\\ufe0f",":man_pilot_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\u2708\\ufe0f",":man_pilot_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\u2708\\ufe0f",
":man_pilot_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\u2708\\ufe0f",":man_pilot_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\u2708\\ufe0f",":man_pilot_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\u2708\\ufe0f",":man_playing_handball:":"\\ud83e\\udd3e\\u200d\\u2642\\ufe0f",":man_playing_handball_tone1:":"\\ud83e\\udd3e\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_playing_handball_tone2:":"\\ud83e\\udd3e\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_playing_handball_tone3:":"\\ud83e\\udd3e\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_playing_handball_tone4:":"\\ud83e\\udd3e\\ud83c\\udffe\\u200d\\u2642\\ufe0f",
":man_playing_handball_tone5:":"\\ud83e\\udd3e\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_playing_water_polo:":"\\ud83e\\udd3d\\u200d\\u2642\\ufe0f",":man_playing_water_polo_tone1:":"\\ud83e\\udd3d\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_playing_water_polo_tone2:":"\\ud83e\\udd3d\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_playing_water_polo_tone3:":"\\ud83e\\udd3d\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_playing_water_polo_tone4:":"\\ud83e\\udd3d\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_playing_water_polo_tone5:":"\\ud83e\\udd3d\\ud83c\\udfff\\u200d\\u2642\\ufe0f",
":man_police_officer:":"\\ud83d\\udc6e\\u200d\\u2642\\ufe0f",":man_police_officer_tone1:":"\\ud83d\\udc6e\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_police_officer_tone2:":"\\ud83d\\udc6e\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_police_officer_tone3:":"\\ud83d\\udc6e\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_police_officer_tone4:":"\\ud83d\\udc6e\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_police_officer_tone5:":"\\ud83d\\udc6e\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_pouting:":"\\ud83d\\ude4e\\u200d\\u2642\\ufe0f",":man_pouting_tone1:":"\\ud83d\\ude4e\\ud83c\\udffb\\u200d\\u2642\\ufe0f",
":man_pouting_tone2:":"\\ud83d\\ude4e\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_pouting_tone3:":"\\ud83d\\ude4e\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_pouting_tone4:":"\\ud83d\\ude4e\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_pouting_tone5:":"\\ud83d\\ude4e\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_raising_hand:":"\\ud83d\\ude4b\\u200d\\u2642\\ufe0f",":man_raising_hand_tone1:":"\\ud83d\\ude4b\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_raising_hand_tone2:":"\\ud83d\\ude4b\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_raising_hand_tone3:":"\\ud83d\\ude4b\\ud83c\\udffd\\u200d\\u2642\\ufe0f",
":man_raising_hand_tone4:":"\\ud83d\\ude4b\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_raising_hand_tone5:":"\\ud83d\\ude4b\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_rowing_boat:":"\\ud83d\\udea3\\u200d\\u2642\\ufe0f",":man_rowing_boat_tone1:":"\\ud83d\\udea3\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_rowing_boat_tone2:":"\\ud83d\\udea3\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_rowing_boat_tone3:":"\\ud83d\\udea3\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_rowing_boat_tone4:":"\\ud83d\\udea3\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_rowing_boat_tone5:":"\\ud83d\\udea3\\ud83c\\udfff\\u200d\\u2642\\ufe0f",
":man_running:":"\\ud83c\\udfc3\\u200d\\u2642\\ufe0f",":man_running_tone1:":"\\ud83c\\udfc3\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_running_tone2:":"\\ud83c\\udfc3\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_running_tone3:":"\\ud83c\\udfc3\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_running_tone4:":"\\ud83c\\udfc3\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_running_tone5:":"\\ud83c\\udfc3\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_scientist:":"\\ud83d\\udc68\\u200d\\ud83d\\udd2c",":man_scientist_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\ud83d\\udd2c",
":man_scientist_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\ud83d\\udd2c",":man_scientist_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\ud83d\\udd2c",":man_scientist_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\ud83d\\udd2c",":man_scientist_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\ud83d\\udd2c",":man_shrugging:":"\\ud83e\\udd37\\u200d\\u2642\\ufe0f",":man_shrugging_tone1:":"\\ud83e\\udd37\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_shrugging_tone2:":"\\ud83e\\udd37\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_shrugging_tone3:":"\\ud83e\\udd37\\ud83c\\udffd\\u200d\\u2642\\ufe0f",
":man_shrugging_tone4:":"\\ud83e\\udd37\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_shrugging_tone5:":"\\ud83e\\udd37\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_singer:":"\\ud83d\\udc68\\u200d\\ud83c\\udfa4",":man_singer_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\ud83c\\udfa4",":man_singer_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\ud83c\\udfa4",":man_singer_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\ud83c\\udfa4",":man_singer_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\ud83c\\udfa4",":man_singer_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\ud83c\\udfa4",
":man_student:":"\\ud83d\\udc68\\u200d\\ud83c\\udf93",":man_student_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\ud83c\\udf93",":man_student_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\ud83c\\udf93",":man_student_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\ud83c\\udf93",":man_student_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\ud83c\\udf93",":man_student_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\ud83c\\udf93",":man_surfing:":"\\ud83c\\udfc4\\u200d\\u2642\\ufe0f",":man_surfing_tone1:":"\\ud83c\\udfc4\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_surfing_tone2:":"\\ud83c\\udfc4\\ud83c\\udffc\\u200d\\u2642\\ufe0f",
":man_surfing_tone3:":"\\ud83c\\udfc4\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_surfing_tone4:":"\\ud83c\\udfc4\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_surfing_tone5:":"\\ud83c\\udfc4\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_swimming:":"\\ud83c\\udfca\\u200d\\u2642\\ufe0f",":man_swimming_tone1:":"\\ud83c\\udfca\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_swimming_tone2:":"\\ud83c\\udfca\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_swimming_tone3:":"\\ud83c\\udfca\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_swimming_tone4:":"\\ud83c\\udfca\\ud83c\\udffe\\u200d\\u2642\\ufe0f",
":man_swimming_tone5:":"\\ud83c\\udfca\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_teacher:":"\\ud83d\\udc68\\u200d\\ud83c\\udfeb",":man_teacher_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\ud83c\\udfeb",":man_teacher_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\ud83c\\udfeb",":man_teacher_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\ud83c\\udfeb",":man_teacher_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\ud83c\\udfeb",":man_teacher_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\ud83c\\udfeb",":man_technologist:":"\\ud83d\\udc68\\u200d\\ud83d\\udcbb",
":man_technologist_tone1:":"\\ud83d\\udc68\\ud83c\\udffb\\u200d\\ud83d\\udcbb",":man_technologist_tone2:":"\\ud83d\\udc68\\ud83c\\udffc\\u200d\\ud83d\\udcbb",":man_technologist_tone3:":"\\ud83d\\udc68\\ud83c\\udffd\\u200d\\ud83d\\udcbb",":man_technologist_tone4:":"\\ud83d\\udc68\\ud83c\\udffe\\u200d\\ud83d\\udcbb",":man_technologist_tone5:":"\\ud83d\\udc68\\ud83c\\udfff\\u200d\\ud83d\\udcbb",":man_tipping_hand:":"\\ud83d\\udc81\\u200d\\u2642\\ufe0f",":man_tipping_hand_tone1:":"\\ud83d\\udc81\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_tipping_hand_tone2:":"\\ud83d\\udc81\\ud83c\\udffc\\u200d\\u2642\\ufe0f",
":man_tipping_hand_tone3:":"\\ud83d\\udc81\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_tipping_hand_tone4:":"\\ud83d\\udc81\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_tipping_hand_tone5:":"\\ud83d\\udc81\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_tone1:":"\\ud83d\\udc68\\ud83c\\udffb",":man_tone2:":"\\ud83d\\udc68\\ud83c\\udffc",":man_tone3:":"\\ud83d\\udc68\\ud83c\\udffd",":man_tone4:":"\\ud83d\\udc68\\ud83c\\udffe",":man_tone5:":"\\ud83d\\udc68\\ud83c\\udfff",":man_vampire:":"\\ud83e\\udddb\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_vampire_tone1:":"\\ud83e\\udddb\\ud83c\\udffb\\u200d\\u2642\\ufe0f",
":man_vampire_tone2:":"\\ud83e\\udddb\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_vampire_tone3:":"\\ud83e\\udddb\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_vampire_tone4:":"\\ud83e\\udddb\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_vampire_tone5:":"\\ud83e\\udddb\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_walking:":"\\ud83d\\udeb6\\u200d\\u2642\\ufe0f",":man_walking_tone1:":"\\ud83d\\udeb6\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_walking_tone2:":"\\ud83d\\udeb6\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_walking_tone3:":"\\ud83d\\udeb6\\ud83c\\udffd\\u200d\\u2642\\ufe0f",
":man_walking_tone4:":"\\ud83d\\udeb6\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_walking_tone5:":"\\ud83d\\udeb6\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":man_wearing_turban:":"\\ud83d\\udc73\\u200d\\u2642\\ufe0f",":man_wearing_turban_tone1:":"\\ud83d\\udc73\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":man_wearing_turban_tone2:":"\\ud83d\\udc73\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":man_wearing_turban_tone3:":"\\ud83d\\udc73\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":man_wearing_turban_tone4:":"\\ud83d\\udc73\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":man_wearing_turban_tone5:":"\\ud83d\\udc73\\ud83c\\udfff\\u200d\\u2642\\ufe0f",
":man_with_chinese_cap:":"\\ud83d\\udc72",":man_with_chinese_cap_tone1:":"\\ud83d\\udc72\\ud83c\\udffb",":man_with_chinese_cap_tone2:":"\\ud83d\\udc72\\ud83c\\udffc",":man_with_chinese_cap_tone3:":"\\ud83d\\udc72\\ud83c\\udffd",":man_with_chinese_cap_tone4:":"\\ud83d\\udc72\\ud83c\\udffe",":man_with_chinese_cap_tone5:":"\\ud83d\\udc72\\ud83c\\udfff",":man_with_gua_pi_mao:":"\\ud83d\\udc72",":man_with_turban:":"\\ud83d\\udc73",":man_zombie:":"\\ud83e\\udddf\\u200d\\u2642\\ufe0f",":mandarin:":"\\ud83c\\udf4a",":mans_shoe:":"\\ud83d\\udc5e",
":mantelpiece_clock:":"\\ud83d\\udd70",":map:":"\\ud83d\\uddfa\\ufe0f",":maple_leaf:":"\\ud83c\\udf41",":marshall_islands:":"\\ud83c\\uddf2\\ud83c\\udded",":martial_arts_uniform:":"\\ud83e\\udd4b",":martinique:":"\\ud83c\\uddf2\\ud83c\\uddf6",":mask:":"\\ud83d\\ude37",":massage:":"\\ud83d\\udc86",":massage_man:":"\\ud83d\\udc86\\u200d\\u2642\\ufe0f",":massage_woman:":"\\ud83d\\udc86",":mauritania:":"\\ud83c\\uddf2\\ud83c\\uddf7",":mauritius:":"\\ud83c\\uddf2\\ud83c\\uddfa",":mayotte:":"\\ud83c\\uddfe\\ud83c\\uddf9",":meat_on_bone:":"\\ud83c\\udf56",
":medal:":"\\ud83c\\udfc5",":medal_military:":"\\ud83c\\udf96",":medal_sports:":"\\ud83c\\udfc5",":medical_symbol:":"\\u2695\\ufe0f",":mega:":"\\ud83d\\udce3",":melon:":"\\ud83c\\udf48",":memo:":"\\ud83d\\udcdd",":men_with_bunny_ears_partying:":"\\ud83d\\udc6f\\u200d\\u2642\\ufe0f",":men_wrestling:":"\\ud83e\\udd3c\\u200d\\u2642\\ufe0f",":menorah:":"\\ud83d\\udd4e",":mens:":"\\ud83d\\udeb9",":mermaid:":"\\ud83e\\udddc\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":mermaid_tone1:":"\\ud83e\\udddc\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":mermaid_tone2:":"\\ud83e\\udddc\\ud83c\\udffc\\u200d\\u2640\\ufe0f",
":mermaid_tone3:":"\\ud83e\\udddc\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":mermaid_tone4:":"\\ud83e\\udddc\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":mermaid_tone5:":"\\ud83e\\udddc\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":merman:":"\\ud83e\\udddc\\ud83c\\udfff\\u200d\\u2642\\ufe0f",":merman_tone1:":"\\ud83e\\udddc\\ud83c\\udffb\\u200d\\u2642\\ufe0f",":merman_tone2:":"\\ud83e\\udddc\\ud83c\\udffc\\u200d\\u2642\\ufe0f",":merman_tone3:":"\\ud83e\\udddc\\ud83c\\udffd\\u200d\\u2642\\ufe0f",":merman_tone4:":"\\ud83e\\udddc\\ud83c\\udffe\\u200d\\u2642\\ufe0f",":merman_tone5:":"\\ud83e\\udddc\\ud83c\\udfff\\u200d\\u2642\\ufe0f",
":merperson:":"\\ud83e\\udddc\\ud83c\\udfff",":merperson_tone1:":"\\ud83e\\udddc\\ud83c\\udffb",":merperson_tone2:":"\\ud83e\\udddc\\ud83c\\udffc",":merperson_tone3:":"\\ud83e\\udddc\\ud83c\\udffd",":merperson_tone4:":"\\ud83e\\udddc\\ud83c\\udffe",":merperson_tone5:":"\\ud83e\\udddc\\ud83c\\udfff",":metal:":"\\ud83e\\udd18",":metal_tone1:":"\\ud83e\\udd18\\ud83c\\udffb",":metal_tone2:":"\\ud83e\\udd18\\ud83c\\udffc",":metal_tone3:":"\\ud83e\\udd18\\ud83c\\udffd",":metal_tone4:":"\\ud83e\\udd18\\ud83c\\udffe",":metal_tone5:":"\\ud83e\\udd18\\ud83c\\udfff",
":metro:":"\\ud83d\\ude87",":mexico:":"\\ud83c\\uddf2\\ud83c\\uddfd",":micronesia:":"\\ud83c\\uddeb\\ud83c\\uddf2",":microphone2:":"\\ud83c\\udf99\\ufe0f",":microphone:":"\\ud83c\\udfa4",":microscope:":"\\ud83d\\udd2c",":middle_finger:":"\\ud83d\\udd95",":middle_finger_tone1:":"\\ud83d\\udd95\\ud83c\\udffb",":middle_finger_tone2:":"\\ud83d\\udd95\\ud83c\\udffc",":middle_finger_tone3:":"\\ud83d\\udd95\\ud83c\\udffd",":middle_finger_tone4:":"\\ud83d\\udd95\\ud83c\\udffe",":middle_finger_tone5:":"\\ud83d\\udd95\\ud83c\\udfff",":military_medal:":"\\ud83c\\udf96\\ufe0f",
":milk:":"\\ud83e\\udd5b",":milk_glass:":"\\ud83e\\udd5b",":milky_way:":"\\ud83c\\udf0c",":minibus:":"\\ud83d\\ude90",":minidisc:":"\\ud83d\\udcbd",":mobile_phone_off:":"\\ud83d\\udcf4",":moldova:":"\\ud83c\\uddf2\\ud83c\\udde9",":monaco:":"\\ud83c\\uddf2\\ud83c\\udde8",":money_mouth:":"\\ud83e\\udd11",":money_mouth_face:":"\\ud83e\\udd11",":money_with_wings:":"\\ud83d\\udcb8",":moneybag:":"\\ud83d\\udcb0",":mongolia:":"\\ud83c\\uddf2\\ud83c\\uddf3",":monkey:":"\\ud83d\\udc12",":monkey_face:":"\\ud83d\\udc35",":monorail:":"\\ud83d\\ude9d",
":montenegro:":"\\ud83c\\uddf2\\ud83c\\uddea",":montserrat:":"\\ud83c\\uddf2\\ud83c\\uddf8",":moon:":"\\ud83c\\udf14",":morocco:":"\\ud83c\\uddf2\\ud83c\\udde6",":mortar_board:":"\\ud83c\\udf93",":mosque:":"\\ud83d\\udd4c",":motor_boat:":"\\ud83d\\udee5",":motor_scooter:":"\\ud83d\\udef5",":motorboat:":"\\ud83d\\udee5\\ufe0f",":motorcycle:":"\\ud83c\\udfcd",":motorway:":"\\ud83d\\udee3",":mount_fuji:":"\\ud83d\\uddfb",":mountain:":"\\u26f0",":mountain_bicyclist:":"\\ud83d\\udeb5",":mountain_biking_man:":"\\ud83d\\udeb5",":mountain_biking_woman:":"\\ud83d\\udeb5\\u200d\\u2640\\ufe0f",
":mountain_cableway:":"\\ud83d\\udea0",":mountain_railway:":"\\ud83d\\ude9e",":mountain_snow:":"\\ud83c\\udfd4",":mouse2:":"\\ud83d\\udc01",":mouse:":"\\ud83d\\udc2d",":mouse_three_button:":"\\ud83d\\uddb1\\ufe0f",":movie_camera:":"\\ud83c\\udfa5",":moyai:":"\\ud83d\\uddff",":mozambique:":"\\ud83c\\uddf2\\ud83c\\uddff",":mrs_claus:":"\\ud83e\\udd36",":mrs_claus_tone1:":"\\ud83e\\udd36\\ud83c\\udffb",":mrs_claus_tone2:":"\\ud83e\\udd36\\ud83c\\udffc",":mrs_claus_tone3:":"\\ud83e\\udd36\\ud83c\\udffd",":mrs_claus_tone4:":"\\ud83e\\udd36\\ud83c\\udffe",
":mrs_claus_tone5:":"\\ud83e\\udd36\\ud83c\\udfff",":muscle:":"\\ud83d\\udcaa",":muscle_tone1:":"\\ud83d\\udcaa\\ud83c\\udffb",":muscle_tone2:":"\\ud83d\\udcaa\\ud83c\\udffc",":muscle_tone3:":"\\ud83d\\udcaa\\ud83c\\udffd",":muscle_tone4:":"\\ud83d\\udcaa\\ud83c\\udffe",":muscle_tone5:":"\\ud83d\\udcaa\\ud83c\\udfff",":mushroom:":"\\ud83c\\udf44",":musical_keyboard:":"\\ud83c\\udfb9",":musical_note:":"\\ud83c\\udfb5",":musical_score:":"\\ud83c\\udfbc",":mute:":"\\ud83d\\udd07",":myanmar:":"\\ud83c\\uddf2\\ud83c\\uddf2",":nail_care:":"\\ud83d\\udc85",
":nail_care_tone1:":"\\ud83d\\udc85\\ud83c\\udffb",":nail_care_tone2:":"\\ud83d\\udc85\\ud83c\\udffc",":nail_care_tone3:":"\\ud83d\\udc85\\ud83c\\udffd",":nail_care_tone4:":"\\ud83d\\udc85\\ud83c\\udffe",":nail_care_tone5:":"\\ud83d\\udc85\\ud83c\\udfff",":name_badge:":"\\ud83d\\udcdb",":namibia:":"\\ud83c\\uddf3\\ud83c\\udde6",":national_park:":"\\ud83c\\udfde",":nauru:":"\\ud83c\\uddf3\\ud83c\\uddf7",":nauseated_face:":"\\ud83e\\udd22",":necktie:":"\\ud83d\\udc54",":negative_squared_cross_mark:":"\\u274e",":nepal:":"\\ud83c\\uddf3\\ud83c\\uddf5",
":nerd:":"\\ud83e\\udd13",":nerd_face:":"\\ud83e\\udd13",":netherlands:":"\\ud83c\\uddf3\\ud83c\\uddf1",":neutral_face:":"\\ud83d\\ude10",":new:":"\\ud83c\\udd95",":new_caledonia:":"\\ud83c\\uddf3\\ud83c\\udde8",":new_moon:":"\\ud83c\\udf11",":new_moon_with_face:":"\\ud83c\\udf1a",":new_zealand:":"\\ud83c\\uddf3\\ud83c\\uddff",":newspaper2:":"\\ud83d\\uddde\\ufe0f",":newspaper:":"\\ud83d\\udcf0",":newspaper_roll:":"\\ud83d\\uddde",":next_track_button:":"\\u23ed",":ng:":"\\ud83c\\udd96",":ng_man:":"\\ud83d\\ude45\\u200d\\u2642\\ufe0f",
":ng_woman:":"\\ud83d\\ude45",":nicaragua:":"\\ud83c\\uddf3\\ud83c\\uddee",":niger:":"\\ud83c\\uddf3\\ud83c\\uddea",":nigeria:":"\\ud83c\\uddf3\\ud83c\\uddec",":night_with_stars:":"\\ud83c\\udf03",":nine:":"9\\u20e3",":niue:":"\\ud83c\\uddf3\\ud83c\\uddfa",":no_bell:":"\\ud83d\\udd15",":no_bicycles:":"\\ud83d\\udeb3",":no_entry:":"\\u26d4\\ufe0f",":no_entry_sign:":"\\ud83d\\udeab",":no_good:":"\\ud83d\\ude45",":no_good_man:":"\\ud83d\\ude45\\u200d\\u2642\\ufe0f",":no_good_woman:":"\\ud83d\\ude45",":no_mobile_phones:":"\\ud83d\\udcf5",":no_mouth:":"\\ud83d\\ude36",
":no_pedestrians:":"\\ud83d\\udeb7",":no_smoking:":"\\ud83d\\udead",":non-potable_water:":"\\ud83d\\udeb1",":norfolk_island:":"\\ud83c\\uddf3\\ud83c\\uddeb",":north_korea:":"\\ud83c\\uddf0\\ud83c\\uddf5",":northern_mariana_islands:":"\\ud83c\\uddf2\\ud83c\\uddf5",":norway:":"\\ud83c\\uddf3\\ud83c\\uddf4",":nose:":"\\ud83d\\udc43",":nose_tone1:":"\\ud83d\\udc43\\ud83c\\udffb",":nose_tone2:":"\\ud83d\\udc43\\ud83c\\udffc",":nose_tone3:":"\\ud83d\\udc43\\ud83c\\udffd",":nose_tone4:":"\\ud83d\\udc43\\ud83c\\udffe",":nose_tone5:":"\\ud83d\\udc43\\ud83c\\udfff",
":notebook:":"\\ud83d\\udcd3",":notebook_with_decorative_cover:":"\\ud83d\\udcd4",":notepad_spiral:":"\\ud83d\\uddd2\\ufe0f",":notes:":"\\ud83c\\udfb6",":nut_and_bolt:":"\\ud83d\\udd29",":o":"\\ud83d\\ude2e",":o2:":"\\ud83c\\udd7e\\ufe0f",":o:":"\\u2b55\\ufe0f",":ocean:":"\\ud83c\\udf0a",":octagonal_sign:":"\\ud83d\\uded1",":octopus:":"\\ud83d\\udc19",":oden:":"\\ud83c\\udf62",":office:":"\\ud83c\\udfe2",":oil:":"\\ud83d\\udee2\\ufe0f",":oil_drum:":"\\ud83d\\udee2",":ok:":"\\ud83c\\udd97",":ok_hand:":"\\ud83d\\udc4c",":ok_hand_tone1:":"\\ud83d\\udc4c\\ud83c\\udffb",
":ok_hand_tone2:":"\\ud83d\\udc4c\\ud83c\\udffc",":ok_hand_tone3:":"\\ud83d\\udc4c\\ud83c\\udffd",":ok_hand_tone4:":"\\ud83d\\udc4c\\ud83c\\udffe",":ok_hand_tone5:":"\\ud83d\\udc4c\\ud83c\\udfff",":ok_man:":"\\ud83d\\ude46\\u200d\\u2642\\ufe0f",":ok_woman:":"\\ud83d\\ude46",":old_key:":"\\ud83d\\udddd",":older_adult:":"\\ud83e\\uddd3\\ud83c\\udfff",":older_adult_tone1:":"\\ud83e\\uddd3\\ud83c\\udffb",":older_adult_tone2:":"\\ud83e\\uddd3\\ud83c\\udffc",":older_adult_tone3:":"\\ud83e\\uddd3\\ud83c\\udffd",":older_adult_tone4:":"\\ud83e\\uddd3\\ud83c\\udffe",
":older_adult_tone5:":"\\ud83e\\uddd3\\ud83c\\udfff",":older_man:":"\\ud83d\\udc74",":older_man_tone1:":"\\ud83d\\udc74\\ud83c\\udffb",":older_man_tone2:":"\\ud83d\\udc74\\ud83c\\udffc",":older_man_tone3:":"\\ud83d\\udc74\\ud83c\\udffd",":older_man_tone4:":"\\ud83d\\udc74\\ud83c\\udffe",":older_man_tone5:":"\\ud83d\\udc74\\ud83c\\udfff",":older_woman:":"\\ud83d\\udc75",":older_woman_tone1:":"\\ud83d\\udc75\\ud83c\\udffb",":older_woman_tone2:":"\\ud83d\\udc75\\ud83c\\udffc",":older_woman_tone3:":"\\ud83d\\udc75\\ud83c\\udffd",":older_woman_tone4:":"\\ud83d\\udc75\\ud83c\\udffe",
":older_woman_tone5:":"\\ud83d\\udc75\\ud83c\\udfff",":om:":"\\ud83d\\udd49",":om_symbol:":"\\ud83d\\udd49\\ufe0f",":oman:":"\\ud83c\\uddf4\\ud83c\\uddf2",":on:":"\\ud83d\\udd1b",":oncoming_automobile:":"\\ud83d\\ude98",":oncoming_bus:":"\\ud83d\\ude8d",":oncoming_police_car:":"\\ud83d\\ude94",":oncoming_taxi:":"\\ud83d\\ude96",":one:":"1\\u20e3",":open_book:":"\\ud83d\\udcd6",":open_file_folder:":"\\ud83d\\udcc2",":open_hands:":"\\ud83d\\udc50",":open_hands_tone1:":"\\ud83d\\udc50\\ud83c\\udffb",":open_hands_tone2:":"\\ud83d\\udc50\\ud83c\\udffc",
":open_hands_tone3:":"\\ud83d\\udc50\\ud83c\\udffd",":open_hands_tone4:":"\\ud83d\\udc50\\ud83c\\udffe",":open_hands_tone5:":"\\ud83d\\udc50\\ud83c\\udfff",":open_mouth:":"\\ud83d\\ude2e",":open_umbrella:":"\\u2602\\ufe0f",":ophiuchus:":"\\u26ce",":orange:":"\\ud83c\\udf4a",":orange_book:":"\\ud83d\\udcd9",":orange_heart:":"\\ud83e\\udde1",":orthodox_cross:":"\\u2626\\ufe0f",":outbox_tray:":"\\ud83d\\udce4",":owl:":"\\ud83e\\udd89",":ox:":"\\ud83d\\udc02",":p":"\\ud83d\\ude1b",":package:":"\\ud83d\\udce6",":page_facing_up:":"\\ud83d\\udcc4",
":page_with_curl:":"\\ud83d\\udcc3",":pager:":"\\ud83d\\udcdf",":paintbrush:":"\\ud83d\\udd8c",":pakistan:":"\\ud83c\\uddf5\\ud83c\\uddf0",":palau:":"\\ud83c\\uddf5\\ud83c\\uddfc",":palestinian_territories:":"\\ud83c\\uddf5\\ud83c\\uddf8",":palm_tree:":"\\ud83c\\udf34",":palms_up_together:":"\\ud83e\\udd32\\ud83c\\udfff",":palms_up_together_tone1:":"\\ud83e\\udd32\\ud83c\\udffb",":palms_up_together_tone2:":"\\ud83e\\udd32\\ud83c\\udffc",":palms_up_together_tone3:":"\\ud83e\\udd32\\ud83c\\udffd",":palms_up_together_tone4:":"\\ud83e\\udd32\\ud83c\\udffe",
":palms_up_together_tone5:":"\\ud83e\\udd32\\ud83c\\udfff",":panama:":"\\ud83c\\uddf5\\ud83c\\udde6",":pancakes:":"\\ud83e\\udd5e",":panda_face:":"\\ud83d\\udc3c",":paperclip:":"\\ud83d\\udcce",":paperclips:":"\\ud83d\\udd87",":papua_new_guinea:":"\\ud83c\\uddf5\\ud83c\\uddec",":paraguay:":"\\ud83c\\uddf5\\ud83c\\uddfe",":parasol_on_ground:":"\\u26f1",":park:":"\\ud83c\\udfde\\ufe0f",":parking:":"\\ud83c\\udd7f\\ufe0f",":part_alternation_mark:":"\\u303d\\ufe0f",":partly_sunny:":"\\u26c5\\ufe0f",":passenger_ship:":"\\ud83d\\udef3",":passport_control:":"\\ud83d\\udec2",
":pause_button:":"\\u23f8",":paw_prints:":"\\ud83d\\udc3e",":peace:":"\\u262e\\ufe0f",":peace_symbol:":"\\u262e\\ufe0f",":peach:":"\\ud83c\\udf51",":peanuts:":"\\ud83e\\udd5c",":pear:":"\\ud83c\\udf50",":pen:":"\\ud83d\\udd8a",":pen_ballpoint:":"\\ud83d\\udd8a\\ufe0f",":pen_fountain:":"\\ud83d\\udd8b\\ufe0f",":pencil2:":"\\u270f\\ufe0f",":pencil:":"\\ud83d\\udcdd",":penguin:":"\\ud83d\\udc27",":pensive:":"\\ud83d\\ude14",":people_with_bunny_ears_partying:":"\\ud83d\\udc6f",":people_wrestling:":"\\ud83e\\udd3c",":performing_arts:":"\\ud83c\\udfad",
":persevere:":"\\ud83d\\ude23",":person_biking:":"\\ud83d\\udeb4\\ud83c\\udfff",":person_biking_tone1:":"\\ud83d\\udeb4\\ud83c\\udffb",":person_biking_tone2:":"\\ud83d\\udeb4\\ud83c\\udffc",":person_biking_tone3:":"\\ud83d\\udeb4\\ud83c\\udffd",":person_biking_tone4:":"\\ud83d\\udeb4\\ud83c\\udffe",":person_biking_tone5:":"\\ud83d\\udeb4\\ud83c\\udfff",":person_bouncing_ball:":"\\u26f9\\ud83c\\udfff",":person_bouncing_ball_tone1:":"\\u26f9\\ud83c\\udffb",":person_bouncing_ball_tone2:":"\\u26f9\\ud83c\\udffc",":person_bouncing_ball_tone3:":"\\u26f9\\ud83c\\udffd",
":person_bouncing_ball_tone4:":"\\u26f9\\ud83c\\udffe",":person_bouncing_ball_tone5:":"\\u26f9\\ud83c\\udfff",":person_bowing:":"\\ud83d\\ude47\\ud83c\\udfff",":person_bowing_tone1:":"\\ud83d\\ude47\\ud83c\\udffb",":person_bowing_tone2:":"\\ud83d\\ude47\\ud83c\\udffc",":person_bowing_tone3:":"\\ud83d\\ude47\\ud83c\\udffd",":person_bowing_tone4:":"\\ud83d\\ude47\\ud83c\\udffe",":person_bowing_tone5:":"\\ud83d\\ude47\\ud83c\\udfff",":person_climbing:":"\\ud83e\\uddd7\\ud83c\\udfff",":person_climbing_tone1:":"\\ud83e\\uddd7\\ud83c\\udffb",
":person_climbing_tone2:":"\\ud83e\\uddd7\\ud83c\\udffc",":person_climbing_tone3:":"\\ud83e\\uddd7\\ud83c\\udffd",":person_climbing_tone4:":"\\ud83e\\uddd7\\ud83c\\udffe",":person_climbing_tone5:":"\\ud83e\\uddd7\\ud83c\\udfff",":person_doing_cartwheel:":"\\ud83e\\udd38",":person_doing_cartwheel_tone1:":"\\ud83e\\udd38\\ud83c\\udffb",":person_doing_cartwheel_tone2:":"\\ud83e\\udd38\\ud83c\\udffc",":person_doing_cartwheel_tone3:":"\\ud83e\\udd38\\ud83c\\udffd",":person_doing_cartwheel_tone4:":"\\ud83e\\udd38\\ud83c\\udffe",":person_doing_cartwheel_tone5:":"\\ud83e\\udd38\\ud83c\\udfff",
":person_facepalming:":"\\ud83e\\udd26\\ud83c\\udfff",":person_facepalming_tone1:":"\\ud83e\\udd26\\ud83c\\udffb",":person_facepalming_tone2:":"\\ud83e\\udd26\\ud83c\\udffc",":person_facepalming_tone3:":"\\ud83e\\udd26\\ud83c\\udffd",":person_facepalming_tone4:":"\\ud83e\\udd26\\ud83c\\udffe",":person_facepalming_tone5:":"\\ud83e\\udd26\\ud83c\\udfff",":person_fencing:":"\\ud83e\\udd3a",":person_frowning:":"\\ud83d\\ude4d",":person_frowning_tone1:":"\\ud83d\\ude4d\\ud83c\\udffb",":person_frowning_tone2:":"\\ud83d\\ude4d\\ud83c\\udffc",
":person_frowning_tone3:":"\\ud83d\\ude4d\\ud83c\\udffd",":person_frowning_tone4:":"\\ud83d\\ude4d\\ud83c\\udffe",":person_frowning_tone5:":"\\ud83d\\ude4d\\ud83c\\udfff",":person_gesturing_no:":"\\ud83d\\ude45",":person_gesturing_no_tone1:":"\\ud83d\\ude45\\ud83c\\udffb",":person_gesturing_no_tone2:":"\\ud83d\\ude45\\ud83c\\udffc",":person_gesturing_no_tone3:":"\\ud83d\\ude45\\ud83c\\udffd",":person_gesturing_no_tone4:":"\\ud83d\\ude45\\ud83c\\udffe",":person_gesturing_no_tone5:":"\\ud83d\\ude45\\ud83c\\udfff",":person_gesturing_ok:":"\\ud83d\\ude46",
":person_gesturing_ok_tone1:":"\\ud83d\\ude46\\ud83c\\udffb",":person_gesturing_ok_tone2:":"\\ud83d\\ude46\\ud83c\\udffc",":person_gesturing_ok_tone3:":"\\ud83d\\ude46\\ud83c\\udffd",":person_gesturing_ok_tone4:":"\\ud83d\\ude46\\ud83c\\udffe",":person_gesturing_ok_tone5:":"\\ud83d\\ude46\\ud83c\\udfff",":person_getting_haircut:":"\\ud83d\\udc87\\ud83c\\udfff",":person_getting_haircut_tone1:":"\\ud83d\\udc87\\ud83c\\udffb",":person_getting_haircut_tone2:":"\\ud83d\\udc87\\ud83c\\udffc",":person_getting_haircut_tone3:":"\\ud83d\\udc87\\ud83c\\udffd",
":person_getting_haircut_tone4:":"\\ud83d\\udc87\\ud83c\\udffe",":person_getting_haircut_tone5:":"\\ud83d\\udc87\\ud83c\\udfff",":person_getting_massage:":"\\ud83d\\udc86\\ud83c\\udfff",":person_getting_massage_tone1:":"\\ud83d\\udc86\\ud83c\\udffb",":person_getting_massage_tone2:":"\\ud83d\\udc86\\ud83c\\udffc",":person_getting_massage_tone3:":"\\ud83d\\udc86\\ud83c\\udffd",":person_getting_massage_tone4:":"\\ud83d\\udc86\\ud83c\\udffe",":person_getting_massage_tone5:":"\\ud83d\\udc86\\ud83c\\udfff",":person_golfing:":"\\ud83c\\udfcc\\ud83c\\udfff",
":person_golfing_tone1:":"\\ud83c\\udfcc\\ud83c\\udffb",":person_golfing_tone2:":"\\ud83c\\udfcc\\ud83c\\udffc",":person_golfing_tone3:":"\\ud83c\\udfcc\\ud83c\\udffd",":person_golfing_tone4:":"\\ud83c\\udfcc\\ud83c\\udffe",":person_golfing_tone5:":"\\ud83c\\udfcc\\ud83c\\udfff",":person_in_bed_tone1:":"\\ud83d\\udecc\\ud83c\\udffb",":person_in_bed_tone2:":"\\ud83d\\udecc\\ud83c\\udffc",":person_in_bed_tone3:":"\\ud83d\\udecc\\ud83c\\udffd",":person_in_bed_tone4:":"\\ud83d\\udecc\\ud83c\\udffe",":person_in_bed_tone5:":"\\ud83d\\udecc\\ud83c\\udfff",
":person_in_lotus_position:":"\\ud83e\\uddd8\\ud83c\\udfff",":person_in_lotus_position_tone1:":"\\ud83e\\uddd8\\ud83c\\udffb",":person_in_lotus_position_tone2:":"\\ud83e\\uddd8\\ud83c\\udffc",":person_in_lotus_position_tone3:":"\\ud83e\\uddd8\\ud83c\\udffd",":person_in_lotus_position_tone4:":"\\ud83e\\uddd8\\ud83c\\udffe",":person_in_lotus_position_tone5:":"\\ud83e\\uddd8\\ud83c\\udfff",":person_in_steamy_room:":"\\ud83e\\uddd6\\ud83c\\udfff",":person_in_steamy_room_tone1:":"\\ud83e\\uddd6\\ud83c\\udffb",":person_in_steamy_room_tone2:":"\\ud83e\\uddd6\\ud83c\\udffc",
":person_in_steamy_room_tone3:":"\\ud83e\\uddd6\\ud83c\\udffd",":person_in_steamy_room_tone4:":"\\ud83e\\uddd6\\ud83c\\udffe",":person_in_steamy_room_tone5:":"\\ud83e\\uddd6\\ud83c\\udfff",":person_juggling:":"\\ud83e\\udd39\\ud83c\\udfff",":person_juggling_tone1:":"\\ud83e\\udd39\\ud83c\\udffb",":person_juggling_tone2:":"\\ud83e\\udd39\\ud83c\\udffc",":person_juggling_tone3:":"\\ud83e\\udd39\\ud83c\\udffd",":person_juggling_tone4:":"\\ud83e\\udd39\\ud83c\\udffe",":person_juggling_tone5:":"\\ud83e\\udd39\\ud83c\\udfff",":person_lifting_weights:":"\\ud83c\\udfcb\\ud83c\\udfff",
":person_lifting_weights_tone1:":"\\ud83c\\udfcb\\ud83c\\udffb",":person_lifting_weights_tone2:":"\\ud83c\\udfcb\\ud83c\\udffc",":person_lifting_weights_tone3:":"\\ud83c\\udfcb\\ud83c\\udffd",":person_lifting_weights_tone4:":"\\ud83c\\udfcb\\ud83c\\udffe",":person_lifting_weights_tone5:":"\\ud83c\\udfcb\\ud83c\\udfff",":person_mountain_biking:":"\\ud83d\\udeb5\\ud83c\\udfff",":person_mountain_biking_tone1:":"\\ud83d\\udeb5\\ud83c\\udffb",":person_mountain_biking_tone2:":"\\ud83d\\udeb5\\ud83c\\udffc",":person_mountain_biking_tone3:":"\\ud83d\\udeb5\\ud83c\\udffd",
":person_mountain_biking_tone4:":"\\ud83d\\udeb5\\ud83c\\udffe",":person_mountain_biking_tone5:":"\\ud83d\\udeb5\\ud83c\\udfff",":person_playing_handball:":"\\ud83e\\udd3e\\ud83c\\udfff",":person_playing_handball_tone1:":"\\ud83e\\udd3e\\ud83c\\udffb",":person_playing_handball_tone2:":"\\ud83e\\udd3e\\ud83c\\udffc",":person_playing_handball_tone3:":"\\ud83e\\udd3e\\ud83c\\udffd",":person_playing_handball_tone4:":"\\ud83e\\udd3e\\ud83c\\udffe",":person_playing_handball_tone5:":"\\ud83e\\udd3e\\ud83c\\udfff",":person_playing_water_polo:":"\\ud83e\\udd3d\\ud83c\\udfff",
":person_playing_water_polo_tone1:":"\\ud83e\\udd3d\\ud83c\\udffb",":person_playing_water_polo_tone2:":"\\ud83e\\udd3d\\ud83c\\udffc",":person_playing_water_polo_tone3:":"\\ud83e\\udd3d\\ud83c\\udffd",":person_playing_water_polo_tone4:":"\\ud83e\\udd3d\\ud83c\\udffe",":person_playing_water_polo_tone5:":"\\ud83e\\udd3d\\ud83c\\udfff",":person_pouting:":"\\ud83d\\ude4e\\ud83c\\udfff",":person_pouting_tone1:":"\\ud83d\\ude4e\\ud83c\\udffb",":person_pouting_tone2:":"\\ud83d\\ude4e\\ud83c\\udffc",":person_pouting_tone3:":"\\ud83d\\ude4e\\ud83c\\udffd",
":person_pouting_tone4:":"\\ud83d\\ude4e\\ud83c\\udffe",":person_pouting_tone5:":"\\ud83d\\ude4e\\ud83c\\udfff",":person_raising_hand:":"\\ud83d\\ude4b\\ud83c\\udfff",":person_raising_hand_tone1:":"\\ud83d\\ude4b\\ud83c\\udffb",":person_raising_hand_tone2:":"\\ud83d\\ude4b\\ud83c\\udffc",":person_raising_hand_tone3:":"\\ud83d\\ude4b\\ud83c\\udffd",":person_raising_hand_tone4:":"\\ud83d\\ude4b\\ud83c\\udffe",":person_raising_hand_tone5:":"\\ud83d\\ude4b\\ud83c\\udfff",":person_rowing_boat:":"\\ud83d\\udea3\\ud83c\\udfff",":person_rowing_boat_tone1:":"\\ud83d\\udea3\\ud83c\\udffb",
":person_rowing_boat_tone2:":"\\ud83d\\udea3\\ud83c\\udffc",":person_rowing_boat_tone3:":"\\ud83d\\udea3\\ud83c\\udffd",":person_rowing_boat_tone4:":"\\ud83d\\udea3\\ud83c\\udffe",":person_rowing_boat_tone5:":"\\ud83d\\udea3\\ud83c\\udfff",":person_running:":"\\ud83c\\udfc3\\ud83c\\udfff",":person_running_tone1:":"\\ud83c\\udfc3\\ud83c\\udffb",":person_running_tone2:":"\\ud83c\\udfc3\\ud83c\\udffc",":person_running_tone3:":"\\ud83c\\udfc3\\ud83c\\udffd",":person_running_tone4:":"\\ud83c\\udfc3\\ud83c\\udffe",":person_running_tone5:":"\\ud83c\\udfc3\\ud83c\\udfff",
":person_shrugging:":"\\ud83e\\udd37\\ud83c\\udfff",":person_shrugging_tone1:":"\\ud83e\\udd37\\ud83c\\udffb",":person_shrugging_tone2:":"\\ud83e\\udd37\\ud83c\\udffc",":person_shrugging_tone3:":"\\ud83e\\udd37\\ud83c\\udffd",":person_shrugging_tone4:":"\\ud83e\\udd37\\ud83c\\udffe",":person_shrugging_tone5:":"\\ud83e\\udd37\\ud83c\\udfff",":person_surfing:":"\\ud83c\\udfc4\\ud83c\\udfff",":person_surfing_tone1:":"\\ud83c\\udfc4\\ud83c\\udffb",":person_surfing_tone2:":"\\ud83c\\udfc4\\ud83c\\udffc",":person_surfing_tone3:":"\\ud83c\\udfc4\\ud83c\\udffd",
":person_surfing_tone4:":"\\ud83c\\udfc4\\ud83c\\udffe",":person_surfing_tone5:":"\\ud83c\\udfc4\\ud83c\\udfff",":person_swimming:":"\\ud83c\\udfca\\ud83c\\udfff",":person_swimming_tone1:":"\\ud83c\\udfca\\ud83c\\udffb",":person_swimming_tone2:":"\\ud83c\\udfca\\ud83c\\udffc",":person_swimming_tone3:":"\\ud83c\\udfca\\ud83c\\udffd",":person_swimming_tone4:":"\\ud83c\\udfca\\ud83c\\udffe",":person_swimming_tone5:":"\\ud83c\\udfca\\ud83c\\udfff",":person_tipping_hand:":"\\ud83d\\udc81\\ud83c\\udfff",":person_tipping_hand_tone1:":"\\ud83d\\udc81\\ud83c\\udffb",
":person_tipping_hand_tone2:":"\\ud83d\\udc81\\ud83c\\udffc",":person_tipping_hand_tone3:":"\\ud83d\\udc81\\ud83c\\udffd",":person_tipping_hand_tone4:":"\\ud83d\\udc81\\ud83c\\udffe",":person_tipping_hand_tone5:":"\\ud83d\\udc81\\ud83c\\udfff",":person_walking:":"\\ud83d\\udeb6\\ud83c\\udfff",":person_walking_tone1:":"\\ud83d\\udeb6\\ud83c\\udffb",":person_walking_tone2:":"\\ud83d\\udeb6\\ud83c\\udffc",":person_walking_tone3:":"\\ud83d\\udeb6\\ud83c\\udffd",":person_walking_tone4:":"\\ud83d\\udeb6\\ud83c\\udffe",":person_walking_tone5:":"\\ud83d\\udeb6\\ud83c\\udfff",
":person_wearing_turban:":"\\ud83d\\udc73\\ud83c\\udfff",":person_wearing_turban_tone1:":"\\ud83d\\udc73\\ud83c\\udffb",":person_wearing_turban_tone2:":"\\ud83d\\udc73\\ud83c\\udffc",":person_wearing_turban_tone3:":"\\ud83d\\udc73\\ud83c\\udffd",":person_wearing_turban_tone4:":"\\ud83d\\udc73\\ud83c\\udffe",":person_wearing_turban_tone5:":"\\ud83d\\udc73\\ud83c\\udfff",":person_with_blond_hair:":"\\ud83d\\udc71",":person_with_pouting_face:":"\\ud83d\\ude4e",":peru:":"\\ud83c\\uddf5\\ud83c\\uddea",":philippines:":"\\ud83c\\uddf5\\ud83c\\udded",
":phone:":"\\u260e\\ufe0f",":pick:":"\\u26cf",":pie:":"\\ud83e\\udd67",":pig2:":"\\ud83d\\udc16",":pig:":"\\ud83d\\udc37",":pig_nose:":"\\ud83d\\udc3d",":pill:":"\\ud83d\\udc8a",":pineapple:":"\\ud83c\\udf4d",":ping_pong:":"\\ud83c\\udfd3",":pisces:":"\\u2653\\ufe0f",":pitcairn_islands:":"\\ud83c\\uddf5\\ud83c\\uddf3",":pizza:":"\\ud83c\\udf55",":place_of_worship:":"\\ud83d\\uded0",":plate_with_cutlery:":"\\ud83c\\udf7d",":play_or_pause_button:":"\\u23ef",":play_pause:":"\\u23ef\\ufe0f",":point_down:":"\\ud83d\\udc47",":point_down_tone1:":"\\ud83d\\udc47\\ud83c\\udffb",
":point_down_tone2:":"\\ud83d\\udc47\\ud83c\\udffc",":point_down_tone3:":"\\ud83d\\udc47\\ud83c\\udffd",":point_down_tone4:":"\\ud83d\\udc47\\ud83c\\udffe",":point_down_tone5:":"\\ud83d\\udc47\\ud83c\\udfff",":point_left:":"\\ud83d\\udc48",":point_left_tone1:":"\\ud83d\\udc48\\ud83c\\udffb",":point_left_tone2:":"\\ud83d\\udc48\\ud83c\\udffc",":point_left_tone3:":"\\ud83d\\udc48\\ud83c\\udffd",":point_left_tone4:":"\\ud83d\\udc48\\ud83c\\udffe",":point_left_tone5:":"\\ud83d\\udc48\\ud83c\\udfff",":point_right:":"\\ud83d\\udc49",":point_right_tone1:":"\\ud83d\\udc49\\ud83c\\udffb",
":point_right_tone2:":"\\ud83d\\udc49\\ud83c\\udffc",":point_right_tone3:":"\\ud83d\\udc49\\ud83c\\udffd",":point_right_tone4:":"\\ud83d\\udc49\\ud83c\\udffe",":point_right_tone5:":"\\ud83d\\udc49\\ud83c\\udfff",":point_up:":"\\u261d\\ufe0f",":point_up_2:":"\\ud83d\\udc46",":point_up_2_tone1:":"\\ud83d\\udc46\\ud83c\\udffb",":point_up_2_tone2:":"\\ud83d\\udc46\\ud83c\\udffc",":point_up_2_tone3:":"\\ud83d\\udc46\\ud83c\\udffd",":point_up_2_tone4:":"\\ud83d\\udc46\\ud83c\\udffe",":point_up_2_tone5:":"\\ud83d\\udc46\\ud83c\\udfff",":point_up_tone1:":"\\u261d\\ud83c\\udffb",
":point_up_tone2:":"\\u261d\\ud83c\\udffc",":point_up_tone3:":"\\u261d\\ud83c\\udffd",":point_up_tone4:":"\\u261d\\ud83c\\udffe",":point_up_tone5:":"\\u261d\\ud83c\\udfff",":poland:":"\\ud83c\\uddf5\\ud83c\\uddf1",":police_car:":"\\ud83d\\ude93",":police_officer:":"\\ud83d\\udc6e\\ud83c\\udfff",":police_officer_tone1:":"\\ud83d\\udc6e\\ud83c\\udffb",":police_officer_tone2:":"\\ud83d\\udc6e\\ud83c\\udffc",":police_officer_tone3:":"\\ud83d\\udc6e\\ud83c\\udffd",":police_officer_tone4:":"\\ud83d\\udc6e\\ud83c\\udffe",":police_officer_tone5:":"\\ud83d\\udc6e\\ud83c\\udfff",
":policeman:":"\\ud83d\\udc6e",":policewoman:":"\\ud83d\\udc6e\\u200d\\u2640\\ufe0f",":poodle:":"\\ud83d\\udc29",":poop:":"\\ud83d\\udca9",":popcorn:":"\\ud83c\\udf7f",":portugal:":"\\ud83c\\uddf5\\ud83c\\uddf9",":post_office:":"\\ud83c\\udfe3",":postal_horn:":"\\ud83d\\udcef",":postbox:":"\\ud83d\\udcee",":potable_water:":"\\ud83d\\udeb0",":potato:":"\\ud83e\\udd54",":pouch:":"\\ud83d\\udc5d",":poultry_leg:":"\\ud83c\\udf57",":pound:":"\\ud83d\\udcb7",":pound_symbol:":"#",":pout:":"\\ud83d\\ude21",":pouting_cat:":"\\ud83d\\ude3e",":pouting_man:":"\\ud83d\\ude4e\\u200d\\u2642\\ufe0f",
":pouting_woman:":"\\ud83d\\ude4e",":pray:":"\\ud83d\\ude4f",":pray_tone1:":"\\ud83d\\ude4f\\ud83c\\udffb",":pray_tone2:":"\\ud83d\\ude4f\\ud83c\\udffc",":pray_tone3:":"\\ud83d\\ude4f\\ud83c\\udffd",":pray_tone4:":"\\ud83d\\ude4f\\ud83c\\udffe",":pray_tone5:":"\\ud83d\\ude4f\\ud83c\\udfff",":prayer_beads:":"\\ud83d\\udcff",":pregnant_woman:":"\\ud83e\\udd30",":pregnant_woman_tone1:":"\\ud83e\\udd30\\ud83c\\udffb",":pregnant_woman_tone2:":"\\ud83e\\udd30\\ud83c\\udffc",":pregnant_woman_tone3:":"\\ud83e\\udd30\\ud83c\\udffd",":pregnant_woman_tone4:":"\\ud83e\\udd30\\ud83c\\udffe",
":pregnant_woman_tone5:":"\\ud83e\\udd30\\ud83c\\udfff",":pretzel:":"\\ud83e\\udd68",":previous_track_button:":"\\u23ee",":prince:":"\\ud83e\\udd34",":prince_tone1:":"\\ud83e\\udd34\\ud83c\\udffb",":prince_tone2:":"\\ud83e\\udd34\\ud83c\\udffc",":prince_tone3:":"\\ud83e\\udd34\\ud83c\\udffd",":prince_tone4:":"\\ud83e\\udd34\\ud83c\\udffe",":prince_tone5:":"\\ud83e\\udd34\\ud83c\\udfff",":princess:":"\\ud83d\\udc78",":princess_tone1:":"\\ud83d\\udc78\\ud83c\\udffb",":princess_tone2:":"\\ud83d\\udc78\\ud83c\\udffc",":princess_tone3:":"\\ud83d\\udc78\\ud83c\\udffd",
":princess_tone4:":"\\ud83d\\udc78\\ud83c\\udffe",":princess_tone5:":"\\ud83d\\udc78\\ud83c\\udfff",":printer:":"\\ud83d\\udda8",":projector:":"\\ud83d\\udcfd\\ufe0f",":puerto_rico:":"\\ud83c\\uddf5\\ud83c\\uddf7",":punch:":"\\ud83d\\udc4a",":punch_tone1:":"\\ud83d\\udc4a\\ud83c\\udffb",":punch_tone2:":"\\ud83d\\udc4a\\ud83c\\udffc",":punch_tone3:":"\\ud83d\\udc4a\\ud83c\\udffd",":punch_tone4:":"\\ud83d\\udc4a\\ud83c\\udffe",":punch_tone5:":"\\ud83d\\udc4a\\ud83c\\udfff",":purple_heart:":"\\ud83d\\udc9c",":purse:":"\\ud83d\\udc5b",":pushpin:":"\\ud83d\\udccc",
":put_litter_in_its_place:":"\\ud83d\\udeae",":qatar:":"\\ud83c\\uddf6\\ud83c\\udde6",":question:":"\\u2753",":rabbit2:":"\\ud83d\\udc07",":rabbit:":"\\ud83d\\udc30",":race_car:":"\\ud83c\\udfce\\ufe0f",":racehorse:":"\\ud83d\\udc0e",":racing_car:":"\\ud83c\\udfce",":radio:":"\\ud83d\\udcfb",":radio_button:":"\\ud83d\\udd18",":radioactive:":"\\u2622\\ufe0f",":rage:":"\\ud83d\\ude21",":railway_car:":"\\ud83d\\ude83",":railway_track:":"\\ud83d\\udee4",":rainbow:":"\\ud83c\\udf08",":rainbow_flag:":"\\ud83c\\udff3\\ufe0f\\u200d\\ud83c\\udf08",
":raised_back_of_hand:":"\\ud83e\\udd1a",":raised_back_of_hand_tone1:":"\\ud83e\\udd1a\\ud83c\\udffb",":raised_back_of_hand_tone2:":"\\ud83e\\udd1a\\ud83c\\udffc",":raised_back_of_hand_tone3:":"\\ud83e\\udd1a\\ud83c\\udffd",":raised_back_of_hand_tone4:":"\\ud83e\\udd1a\\ud83c\\udffe",":raised_back_of_hand_tone5:":"\\ud83e\\udd1a\\ud83c\\udfff",":raised_hand:":"\\u270b",":raised_hand_tone1:":"\\u270b\\ud83c\\udffb",":raised_hand_tone2:":"\\u270b\\ud83c\\udffc",":raised_hand_tone3:":"\\u270b\\ud83c\\udffd",":raised_hand_tone4:":"\\u270b\\ud83c\\udffe",
":raised_hand_tone5:":"\\u270b\\ud83c\\udfff",":raised_hand_with_fingers_splayed:":"\\ud83d\\udd90",":raised_hands:":"\\ud83d\\ude4c",":raised_hands_tone1:":"\\ud83d\\ude4c\\ud83c\\udffb",":raised_hands_tone2:":"\\ud83d\\ude4c\\ud83c\\udffc",":raised_hands_tone3:":"\\ud83d\\ude4c\\ud83c\\udffd",":raised_hands_tone4:":"\\ud83d\\ude4c\\ud83c\\udffe",":raised_hands_tone5:":"\\ud83d\\ude4c\\ud83c\\udfff",":raising_hand:":"\\ud83d\\ude4b",":raising_hand_man:":"\\ud83d\\ude4b\\u200d\\u2642\\ufe0f",":raising_hand_woman:":"\\ud83d\\ude4b",
":ram:":"\\ud83d\\udc0f",":ramen:":"\\ud83c\\udf5c",":rat:":"\\ud83d\\udc00",":record_button:":"\\u23fa",":recycle:":"\\u267b\\ufe0f",":red_car:":"\\ud83d\\ude97",":red_circle:":"\\ud83d\\udd34",":regional_indicator_a:":"\\ud83c\\udde6",":regional_indicator_b:":"\\ud83c\\udde7",":regional_indicator_c:":"\\ud83c\\udde8",":regional_indicator_d:":"\\ud83c\\udde9",":regional_indicator_e:":"\\ud83c\\uddea",":regional_indicator_f:":"\\ud83c\\uddeb",":regional_indicator_g:":"\\ud83c\\uddec",":regional_indicator_h:":"\\ud83c\\udded",
":regional_indicator_i:":"\\ud83c\\uddee",":regional_indicator_j:":"\\ud83c\\uddef",":regional_indicator_k:":"\\ud83c\\uddf0",":regional_indicator_l:":"\\ud83c\\uddf1",":regional_indicator_m:":"\\ud83c\\uddf2",":regional_indicator_n:":"\\ud83c\\uddf3",":regional_indicator_o:":"\\ud83c\\uddf4",":regional_indicator_p:":"\\ud83c\\uddf5",":regional_indicator_q:":"\\ud83c\\uddf6",":regional_indicator_r:":"\\ud83c\\uddf7",":regional_indicator_s:":"\\ud83c\\uddf8",":regional_indicator_t:":"\\ud83c\\uddf9",":regional_indicator_u:":"\\ud83c\\uddfa",
":regional_indicator_v:":"\\ud83c\\uddfb",":regional_indicator_w:":"\\ud83c\\uddfc",":regional_indicator_x:":"\\ud83c\\uddfd",":regional_indicator_y:":"\\ud83c\\uddfe",":regional_indicator_z:":"\\ud83c\\uddff",":registered:":"\\u00ae\\ufe0f",":relaxed:":"\\u263a\\ufe0f",":relieved:":"\\ud83d\\ude0c",":reminder_ribbon:":"\\ud83c\\udf97",":repeat:":"\\ud83d\\udd01",":repeat_one:":"\\ud83d\\udd02",":rescue_worker_helmet:":"\\u26d1",":restroom:":"\\ud83d\\udebb",":reunion:":"\\ud83c\\uddf7\\ud83c\\uddea",":revolving_hearts:":"\\ud83d\\udc9e",
":rewind:":"\\u23ea",":rhino:":"\\ud83e\\udd8f",":rhinoceros:":"\\ud83e\\udd8f",":ribbon:":"\\ud83c\\udf80",":rice:":"\\ud83c\\udf5a",":rice_ball:":"\\ud83c\\udf59",":rice_cracker:":"\\ud83c\\udf58",":rice_scene:":"\\ud83c\\udf91",":right_anger_bubble:":"\\ud83d\\uddef",":right_facing_fist:":"\\ud83e\\udd1c",":right_facing_fist_tone1:":"\\ud83e\\udd1c\\ud83c\\udffb",":right_facing_fist_tone2:":"\\ud83e\\udd1c\\ud83c\\udffc",":right_facing_fist_tone3:":"\\ud83e\\udd1c\\ud83c\\udffd",":right_facing_fist_tone4:":"\\ud83e\\udd1c\\ud83c\\udffe",
":right_facing_fist_tone5:":"\\ud83e\\udd1c\\ud83c\\udfff",":ring:":"\\ud83d\\udc8d",":robot:":"\\ud83e\\udd16",":rocket:":"\\ud83d\\ude80",":rofl:":"\\ud83e\\udd23",":roll_eyes:":"\\ud83d\\ude44",":roller_coaster:":"\\ud83c\\udfa2",":rolling_eyes:":"\\ud83d\\ude44",":romania:":"\\ud83c\\uddf7\\ud83c\\uddf4",":rooster:":"\\ud83d\\udc13",":rose:":"\\ud83c\\udf39",":rosette:":"\\ud83c\\udff5",":rotating_light:":"\\ud83d\\udea8",":round_pushpin:":"\\ud83d\\udccd",":rowboat:":"\\ud83d\\udea3",":rowing_man:":"\\ud83d\\udea3",":rowing_woman:":"\\ud83d\\udea3\\u200d\\u2640\\ufe0f",
":ru:":"\\ud83c\\uddf7\\ud83c\\uddfa",":rugby_football:":"\\ud83c\\udfc9",":runner:":"\\ud83c\\udfc3",":running:":"\\ud83c\\udfc3",":running_man:":"\\ud83c\\udfc3",":running_shirt_with_sash:":"\\ud83c\\udfbd",":running_woman:":"\\ud83c\\udfc3\\u200d\\u2640\\ufe0f",":rwanda:":"\\ud83c\\uddf7\\ud83c\\uddfc",":sa:":"\\ud83c\\ude02\\ufe0f",":sagittarius:":"\\u2650\\ufe0f",":sailboat:":"\\u26f5\\ufe0f",":sake:":"\\ud83c\\udf76",":salad:":"\\ud83e\\udd57",":samoa:":"\\ud83c\\uddfc\\ud83c\\uddf8",":san_marino:":"\\ud83c\\uddf8\\ud83c\\uddf2",":sandal:":"\\ud83d\\udc61",
":sandwich:":"\\ud83e\\udd6a",":santa:":"\\ud83c\\udf85",":santa_tone1:":"\\ud83c\\udf85\\ud83c\\udffb",":santa_tone2:":"\\ud83c\\udf85\\ud83c\\udffc",":santa_tone3:":"\\ud83c\\udf85\\ud83c\\udffd",":santa_tone4:":"\\ud83c\\udf85\\ud83c\\udffe",":santa_tone5:":"\\ud83c\\udf85\\ud83c\\udfff",":sao_tome_principe:":"\\ud83c\\uddf8\\ud83c\\uddf9",":sassy_man:":"\\ud83d\\udc81\\u200d\\u2642\\ufe0f",":sassy_woman:":"\\ud83d\\udc81",":satellite:":"\\ud83d\\udce1",":satellite_orbital:":"\\ud83d\\udef0\\ufe0f",":satisfied:":"\\ud83d\\ude06",":saudi_arabia:":"\\ud83c\\uddf8\\ud83c\\udde6",
":sauropod:":"\\ud83e\\udd95",":saxophone:":"\\ud83c\\udfb7",":scales:":"\\u2696\\ufe0f",":scarf:":"\\ud83e\\udde3",":school:":"\\ud83c\\udfeb",":school_satchel:":"\\ud83c\\udf92",":scissors:":"\\u2702\\ufe0f",":scooter:":"\\ud83d\\udef4",":scorpion:":"\\ud83e\\udd82",":scorpius:":"\\u264f\\ufe0f",":scotland:":"\\ud83c\\udff4\\udb40\\udc67\\udb40\\udc62\\udb40\\udc73\\udb40\\udc63\\udb40\\udc74\\udb40\\udc7f",":scream:":"\\ud83d\\ude31",":scream_cat:":"\\ud83d\\ude40",":scroll:":"\\ud83d\\udcdc",":seat:":"\\ud83d\\udcba",":second_place:":"\\ud83e\\udd48",
":secret:":"\\u3299\\ufe0f",":see_no_evil:":"\\ud83d\\ude48",":seedling:":"\\ud83c\\udf31",":selfie:":"\\ud83e\\udd33",":selfie_tone1:":"\\ud83e\\udd33\\ud83c\\udffb",":selfie_tone2:":"\\ud83e\\udd33\\ud83c\\udffc",":selfie_tone3:":"\\ud83e\\udd33\\ud83c\\udffd",":selfie_tone4:":"\\ud83e\\udd33\\ud83c\\udffe",":selfie_tone5:":"\\ud83e\\udd33\\ud83c\\udfff",":senegal:":"\\ud83c\\uddf8\\ud83c\\uddf3",":serbia:":"\\ud83c\\uddf7\\ud83c\\uddf8",":seven:":"7\\u20e3",":seychelles:":"\\ud83c\\uddf8\\ud83c\\udde8",":shallow_pan_of_food:":"\\ud83e\\udd58",
":shamrock:":"\\u2618\\ufe0f",":shark:":"\\ud83e\\udd88",":shaved_ice:":"\\ud83c\\udf67",":sheep:":"\\ud83d\\udc11",":shell:":"\\ud83d\\udc1a",":shield:":"\\ud83d\\udee1",":shinto_shrine:":"\\u26e9",":ship:":"\\ud83d\\udea2",":shirt:":"\\ud83d\\udc55",":shit:":"\\ud83d\\udca9",":shoe:":"\\ud83d\\udc5e",":shopping:":"\\ud83d\\udecd",":shopping_bags:":"\\ud83d\\udecd\\ufe0f",":shopping_cart:":"\\ud83d\\uded2",":shower:":"\\ud83d\\udebf",":shrimp:":"\\ud83e\\udd90",":shushing_face:":"\\ud83e\\udd2b",":sierra_leone:":"\\ud83c\\uddf8\\ud83c\\uddf1",
":signal_strength:":"\\ud83d\\udcf6",":singapore:":"\\ud83c\\uddf8\\ud83c\\uddec",":sint_maarten:":"\\ud83c\\uddf8\\ud83c\\uddfd",":six:":"6\\u20e3",":six_pointed_star:":"\\ud83d\\udd2f",":ski:":"\\ud83c\\udfbf",":skier:":"\\u26f7",":skull:":"\\ud83d\\udc80",":skull_and_crossbones:":"\\u2620\\ufe0f",":skull_crossbones:":"\\u2620\\ufe0f",":sled:":"\\ud83d\\udef7",":sleeping:":"\\ud83d\\ude34",":sleeping_accommodation:":"\\ud83d\\udecc",":sleeping_bed:":"\\ud83d\\udecc",":sleepy:":"\\ud83d\\ude2a",":slight_frown:":"\\ud83d\\ude41",
":slight_smile:":"\\ud83d\\ude42",":slightly_frowning_face:":"\\ud83d\\ude41",":slightly_smiling_face:":"\\ud83d\\ude42",":slot_machine:":"\\ud83c\\udfb0",":slovakia:":"\\ud83c\\uddf8\\ud83c\\uddf0",":slovenia:":"\\ud83c\\uddf8\\ud83c\\uddee",":small_airplane:":"\\ud83d\\udee9",":small_blue_diamond:":"\\ud83d\\udd39",":small_orange_diamond:":"\\ud83d\\udd38",":small_red_triangle:":"\\ud83d\\udd3a",":small_red_triangle_down:":"\\ud83d\\udd3b",":smile:":"\\ud83d\\ude04",":smile_cat:":"\\ud83d\\ude38",":smiley:":"\\ud83d\\ude03",":smiley_cat:":"\\ud83d\\ude3a",
":smiling_imp:":"\\ud83d\\ude08",":smirk:":"\\ud83d\\ude0f",":smirk_cat:":"\\ud83d\\ude3c",":smoking:":"\\ud83d\\udeac",":snail:":"\\ud83d\\udc0c",":snake:":"\\ud83d\\udc0d",":sneezing_face:":"\\ud83e\\udd27",":snowboarder:":"\\ud83c\\udfc2",":snowboarder_tone1:":"\\ud83c\\udfc2\\ud83c\\udffb",":snowboarder_tone2:":"\\ud83c\\udfc2\\ud83c\\udffc",":snowboarder_tone3:":"\\ud83c\\udfc2\\ud83c\\udffd",":snowboarder_tone4:":"\\ud83c\\udfc2\\ud83c\\udffe",":snowboarder_tone5:":"\\ud83c\\udfc2\\ud83c\\udfff",":snowflake:":"\\u2744\\ufe0f",":snowman2:":"\\u2603\\ufe0f",
":snowman:":"\\u26c4\\ufe0f",":snowman_with_snow:":"\\u2603\\ufe0f",":sob:":"\\ud83d\\ude2d",":soccer:":"\\u26bd\\ufe0f",":socks:":"\\ud83e\\udde6",":solomon_islands:":"\\ud83c\\uddf8\\ud83c\\udde7",":somalia:":"\\ud83c\\uddf8\\ud83c\\uddf4",":soon:":"\\ud83d\\udd1c",":sos:":"\\ud83c\\udd98",":sound:":"\\ud83d\\udd09",":south_africa:":"\\ud83c\\uddff\\ud83c\\udde6",":south_georgia_south_sandwich_islands:":"\\ud83c\\uddec\\ud83c\\uddf8",":south_sudan:":"\\ud83c\\uddf8\\ud83c\\uddf8",":space_invader:":"\\ud83d\\udc7e",":spades:":"\\u2660\\ufe0f",
":spaghetti:":"\\ud83c\\udf5d",":sparkle:":"\\u2747\\ufe0f",":sparkler:":"\\ud83c\\udf87",":sparkles:":"\\u2728",":sparkling_heart:":"\\ud83d\\udc96",":speak_no_evil:":"\\ud83d\\ude4a",":speaker:":"\\ud83d\\udd08",":speaking_head:":"\\ud83d\\udde3",":speech_balloon:":"\\ud83d\\udcac",":speech_left:":"\\ud83d\\udde8\\ufe0f",":speedboat:":"\\ud83d\\udea4",":spider:":"\\ud83d\\udd77",":spider_web:":"\\ud83d\\udd78",":spiral_calendar:":"\\ud83d\\uddd3",":spiral_notepad:":"\\ud83d\\uddd2",":spoon:":"\\ud83e\\udd44",":squid:":"\\ud83e\\udd91",
":sri_lanka:":"\\ud83c\\uddf1\\ud83c\\uddf0",":st_barthelemy:":"\\ud83c\\udde7\\ud83c\\uddf1",":st_helena:":"\\ud83c\\uddf8\\ud83c\\udded",":st_kitts_nevis:":"\\ud83c\\uddf0\\ud83c\\uddf3",":st_lucia:":"\\ud83c\\uddf1\\ud83c\\udde8",":st_pierre_miquelon:":"\\ud83c\\uddf5\\ud83c\\uddf2",":st_vincent_grenadines:":"\\ud83c\\uddfb\\ud83c\\udde8",":stadium:":"\\ud83c\\udfdf",":star2:":"\\ud83c\\udf1f",":star:":"\\u2b50\\ufe0f",":star_and_crescent:":"\\u262a\\ufe0f",":star_of_david:":"\\u2721\\ufe0f",":star_struck:":"\\ud83e\\udd29",":stars:":"\\ud83c\\udf20",
":station:":"\\ud83d\\ude89",":statue_of_liberty:":"\\ud83d\\uddfd",":steam_locomotive:":"\\ud83d\\ude82",":stew:":"\\ud83c\\udf72",":stop_button:":"\\u23f9",":stop_sign:":"\\ud83d\\uded1",":stopwatch:":"\\u23f1",":straight_ruler:":"\\ud83d\\udccf",":strawberry:":"\\ud83c\\udf53",":stuck_out_tongue:":"\\ud83d\\ude1b",":stuck_out_tongue_closed_eyes:":"\\ud83d\\ude1d",":stuck_out_tongue_winking_eye:":"\\ud83d\\ude1c",":studio_microphone:":"\\ud83c\\udf99",":stuffed_flatbread:":"\\ud83e\\udd59",":sudan:":"\\ud83c\\uddf8\\ud83c\\udde9",
":sun_behind_large_cloud:":"\\ud83c\\udf25",":sun_behind_rain_cloud:":"\\ud83c\\udf26",":sun_behind_small_cloud:":"\\ud83c\\udf24",":sun_with_face:":"\\ud83c\\udf1e",":sunflower:":"\\ud83c\\udf3b",":sunglasses:":"\\ud83d\\ude0e",":sunny:":"\\u2600\\ufe0f",":sunrise:":"\\ud83c\\udf05",":sunrise_over_mountains:":"\\ud83c\\udf04",":surfer:":"\\ud83c\\udfc4",":surfing_man:":"\\ud83c\\udfc4",":surfing_woman:":"\\ud83c\\udfc4\\u200d\\u2640\\ufe0f",":suriname:":"\\ud83c\\uddf8\\ud83c\\uddf7",":sushi:":"\\ud83c\\udf63",":suspension_railway:":"\\ud83d\\ude9f",
":swaziland:":"\\ud83c\\uddf8\\ud83c\\uddff",":sweat:":"\\ud83d\\ude13",":sweat_drops:":"\\ud83d\\udca6",":sweat_smile:":"\\ud83d\\ude05",":sweden:":"\\ud83c\\uddf8\\ud83c\\uddea",":sweet_potato:":"\\ud83c\\udf60",":swimmer:":"\\ud83c\\udfca",":swimming_man:":"\\ud83c\\udfca",":swimming_woman:":"\\ud83c\\udfca\\u200d\\u2640\\ufe0f",":switzerland:":"\\ud83c\\udde8\\ud83c\\udded",":symbols:":"\\ud83d\\udd23",":synagogue:":"\\ud83d\\udd4d",":syria:":"\\ud83c\\uddf8\\ud83c\\uddfe",":syringe:":"\\ud83d\\udc89",":t_rex:":"\\ud83e\\udd96",":taco:":"\\ud83c\\udf2e",
":tada:":"\\ud83c\\udf89",":taiwan:":"\\ud83c\\uddf9\\ud83c\\uddfc",":tajikistan:":"\\ud83c\\uddf9\\ud83c\\uddef",":takeout_box:":"\\ud83e\\udd61",":tanabata_tree:":"\\ud83c\\udf8b",":tangerine:":"\\ud83c\\udf4a",":tanzania:":"\\ud83c\\uddf9\\ud83c\\uddff",":taurus:":"\\u2649\\ufe0f",":taxi:":"\\ud83d\\ude95",":tea:":"\\ud83c\\udf75",":telephone:":"\\u260e\\ufe0f",":telephone_receiver:":"\\ud83d\\udcde",":telescope:":"\\ud83d\\udd2d",":tennis:":"\\ud83c\\udfbe",":tent:":"\\u26fa\\ufe0f",":thailand:":"\\ud83c\\uddf9\\ud83c\\udded",":thermometer:":"\\ud83c\\udf21",
":thermometer_face:":"\\ud83e\\udd12",":thinking:":"\\ud83e\\udd14",":third_place:":"\\ud83e\\udd49",":thought_balloon:":"\\ud83d\\udcad",":three:":"3\\u20e3",":thumbsdown:":"\\ud83d\\udc4e",":thumbsdown_tone1:":"\\ud83d\\udc4e\\ud83c\\udffb",":thumbsdown_tone2:":"\\ud83d\\udc4e\\ud83c\\udffc",":thumbsdown_tone3:":"\\ud83d\\udc4e\\ud83c\\udffd",":thumbsdown_tone4:":"\\ud83d\\udc4e\\ud83c\\udffe",":thumbsdown_tone5:":"\\ud83d\\udc4e\\ud83c\\udfff",":thumbsup:":"\\ud83d\\udc4d",":thumbsup_tone1:":"\\ud83d\\udc4d\\ud83c\\udffb",":thumbsup_tone2:":"\\ud83d\\udc4d\\ud83c\\udffc",
":thumbsup_tone3:":"\\ud83d\\udc4d\\ud83c\\udffd",":thumbsup_tone4:":"\\ud83d\\udc4d\\ud83c\\udffe",":thumbsup_tone5:":"\\ud83d\\udc4d\\ud83c\\udfff",":thunder_cloud_rain:":"\\u26c8\\ufe0f",":ticket:":"\\ud83c\\udfab",":tickets:":"\\ud83c\\udf9f",":tiger2:":"\\ud83d\\udc05",":tiger:":"\\ud83d\\udc2f",":timer:":"\\u23f2\\ufe0f",":timer_clock:":"\\u23f2",":timor_leste:":"\\ud83c\\uddf9\\ud83c\\uddf1",":tipping_hand_man:":"\\ud83d\\udc81\\u200d\\u2642\\ufe0f",":tipping_hand_woman:":"\\ud83d\\udc81",":tired_face:":"\\ud83d\\ude2b",":tm:":"\\u2122\\ufe0f",
":togo:":"\\ud83c\\uddf9\\ud83c\\uddec",":toilet:":"\\ud83d\\udebd",":tokelau:":"\\ud83c\\uddf9\\ud83c\\uddf0",":tokyo_tower:":"\\ud83d\\uddfc",":tomato:":"\\ud83c\\udf45",":tone1:":"\\ud83c\\udffb",":tone2:":"\\ud83c\\udffc",":tone3:":"\\ud83c\\udffd",":tone4:":"\\ud83c\\udffe",":tone5:":"\\ud83c\\udfff",":tonga:":"\\ud83c\\uddf9\\ud83c\\uddf4",":tongue:":"\\ud83d\\udc45",":tools:":"\\ud83d\\udee0\\ufe0f",":top:":"\\ud83d\\udd1d",":tophat:":"\\ud83c\\udfa9",":tornado:":"\\ud83c\\udf2a",":tr:":"\\ud83c\\uddf9\\ud83c\\uddf7",":track_next:":"\\u23ed\\ufe0f",
":track_previous:":"\\u23ee\\ufe0f",":trackball:":"\\ud83d\\uddb2",":tractor:":"\\ud83d\\ude9c",":traffic_light:":"\\ud83d\\udea5",":train2:":"\\ud83d\\ude86",":train:":"\\ud83d\\ude8b",":tram:":"\\ud83d\\ude8a",":triangular_flag_on_post:":"\\ud83d\\udea9",":triangular_ruler:":"\\ud83d\\udcd0",":trident:":"\\ud83d\\udd31",":trinidad_tobago:":"\\ud83c\\uddf9\\ud83c\\uddf9",":triumph:":"\\ud83d\\ude24",":trolleybus:":"\\ud83d\\ude8e",":trophy:":"\\ud83c\\udfc6",":tropical_drink:":"\\ud83c\\udf79",":tropical_fish:":"\\ud83d\\udc20",
":truck:":"\\ud83d\\ude9a",":trumpet:":"\\ud83c\\udfba",":tshirt:":"\\ud83d\\udc55",":tulip:":"\\ud83c\\udf37",":tumbler_glass:":"\\ud83e\\udd43",":tunisia:":"\\ud83c\\uddf9\\ud83c\\uddf3",":turkey:":"\\ud83e\\udd83",":turkmenistan:":"\\ud83c\\uddf9\\ud83c\\uddf2",":turks_caicos_islands:":"\\ud83c\\uddf9\\ud83c\\udde8",":turtle:":"\\ud83d\\udc22",":tuvalu:":"\\ud83c\\uddf9\\ud83c\\uddfb",":tv:":"\\ud83d\\udcfa",":twisted_rightwards_arrows:":"\\ud83d\\udd00",":two:":"2\\u20e3",":two_hearts:":"\\ud83d\\udc95",":two_men_holding_hands:":"\\ud83d\\udc6c",
":two_women_holding_hands:":"\\ud83d\\udc6d",":u5272:":"\\ud83c\\ude39",":u5408:":"\\ud83c\\ude34",":u55b6:":"\\ud83c\\ude3a",":u6307:":"\\ud83c\\ude2f\\ufe0f",":u6708:":"\\ud83c\\ude37\\ufe0f",":u6709:":"\\ud83c\\ude36",":u6e80:":"\\ud83c\\ude35",":u7121:":"\\ud83c\\ude1a\\ufe0f",":u7533:":"\\ud83c\\ude38",":u7981:":"\\ud83c\\ude32",":u7a7a:":"\\ud83c\\ude33",":uganda:":"\\ud83c\\uddfa\\ud83c\\uddec",":uk:":"\\ud83c\\uddec\\ud83c\\udde7",":ukraine:":"\\ud83c\\uddfa\\ud83c\\udde6",":umbrella2:":"\\u2602\\ufe0f",":umbrella:":"\\u2614\\ufe0f",
":unamused:":"\\ud83d\\ude12",":underage:":"\\ud83d\\udd1e",":unicorn:":"\\ud83e\\udd84",":united_arab_emirates:":"\\ud83c\\udde6\\ud83c\\uddea",":united_nations:":"\\ud83c\\uddfa\\ud83c\\uddf3",":unlock:":"\\ud83d\\udd13",":up:":"\\ud83c\\udd99",":upside_down:":"\\ud83d\\ude43",":upside_down_face:":"\\ud83d\\ude43",":urn:":"\\u26b1\\ufe0f",":uruguay:":"\\ud83c\\uddfa\\ud83c\\uddfe",":us:":"\\ud83c\\uddfa\\ud83c\\uddf8",":us_virgin_islands:":"\\ud83c\\uddfb\\ud83c\\uddee",":uzbekistan:":"\\ud83c\\uddfa\\ud83c\\uddff",":v:":"\\u270c\\ufe0f",
":v_tone1:":"\\u270c\\ud83c\\udffb",":v_tone2:":"\\u270c\\ud83c\\udffc",":v_tone3:":"\\u270c\\ud83c\\udffd",":v_tone4:":"\\u270c\\ud83c\\udffe",":v_tone5:":"\\u270c\\ud83c\\udfff",":vampire:":"\\ud83e\\udddb\\ud83c\\udfff",":vampire_tone1:":"\\ud83e\\udddb\\ud83c\\udffb",":vampire_tone2:":"\\ud83e\\udddb\\ud83c\\udffc",":vampire_tone3:":"\\ud83e\\udddb\\ud83c\\udffd",":vampire_tone4:":"\\ud83e\\udddb\\ud83c\\udffe",":vampire_tone5:":"\\ud83e\\udddb\\ud83c\\udfff",":vanuatu:":"\\ud83c\\uddfb\\ud83c\\uddfa",":vatican_city:":"\\ud83c\\uddfb\\ud83c\\udde6",
":venezuela:":"\\ud83c\\uddfb\\ud83c\\uddea",":vertical_traffic_light:":"\\ud83d\\udea6",":vhs:":"\\ud83d\\udcfc",":vibration_mode:":"\\ud83d\\udcf3",":video_camera:":"\\ud83d\\udcf9",":video_game:":"\\ud83c\\udfae",":vietnam:":"\\ud83c\\uddfb\\ud83c\\uddf3",":violin:":"\\ud83c\\udfbb",":virgo:":"\\u264d\\ufe0f",":volcano:":"\\ud83c\\udf0b",":volleyball:":"\\ud83c\\udfd0",":vs:":"\\ud83c\\udd9a",":vulcan:":"\\ud83d\\udd96",":vulcan_salute:":"\\ud83d\\udd96",":vulcan_tone1:":"\\ud83d\\udd96\\ud83c\\udffb",":vulcan_tone2:":"\\ud83d\\udd96\\ud83c\\udffc",
":vulcan_tone3:":"\\ud83d\\udd96\\ud83c\\udffd",":vulcan_tone4:":"\\ud83d\\udd96\\ud83c\\udffe",":vulcan_tone5:":"\\ud83d\\udd96\\ud83c\\udfff",":wales:":"\\ud83c\\udff4\\udb40\\udc67\\udb40\\udc62\\udb40\\udc77\\udb40\\udc6c\\udb40\\udc73\\udb40\\udc7f",":walking:":"\\ud83d\\udeb6",":walking_man:":"\\ud83d\\udeb6",":walking_woman:":"\\ud83d\\udeb6\\u200d\\u2640\\ufe0f",":wallis_futuna:":"\\ud83c\\uddfc\\ud83c\\uddeb",":waning_crescent_moon:":"\\ud83c\\udf18",":waning_gibbous_moon:":"\\ud83c\\udf16",":warning:":"\\u26a0\\ufe0f",":wastebasket:":"\\ud83d\\uddd1",
":watch:":"\\u231a\\ufe0f",":water_buffalo:":"\\ud83d\\udc03",":watermelon:":"\\ud83c\\udf49",":wave:":"\\ud83d\\udc4b",":wave_tone1:":"\\ud83d\\udc4b\\ud83c\\udffb",":wave_tone2:":"\\ud83d\\udc4b\\ud83c\\udffc",":wave_tone3:":"\\ud83d\\udc4b\\ud83c\\udffd",":wave_tone4:":"\\ud83d\\udc4b\\ud83c\\udffe",":wave_tone5:":"\\ud83d\\udc4b\\ud83c\\udfff",":wavy_dash:":"\\u3030\\ufe0f",":waxing_crescent_moon:":"\\ud83c\\udf12",":waxing_gibbous_moon:":"\\ud83c\\udf14",":wc:":"\\ud83d\\udebe",":weary:":"\\ud83d\\ude29",":wedding:":"\\ud83d\\udc92",
":weight_lifting_man:":"\\ud83c\\udfcb",":weight_lifting_woman:":"\\ud83c\\udfcb\\ufe0f\\u200d\\u2640\\ufe0f",":western_sahara:":"\\ud83c\\uddea\\ud83c\\udded",":whale2:":"\\ud83d\\udc0b",":whale:":"\\ud83d\\udc33",":wheel_of_dharma:":"\\u2638\\ufe0f",":wheelchair:":"\\u267f\\ufe0f",":white_check_mark:":"\\u2705",":white_circle:":"\\u26aa\\ufe0f",":white_flag:":"\\ud83c\\udff3\\ufe0f",":white_flower:":"\\ud83d\\udcae",":white_large_square:":"\\u2b1c\\ufe0f",":white_medium_small_square:":"\\u25fd\\ufe0f",":white_medium_square:":"\\u25fb\\ufe0f",
":white_small_square:":"\\u25ab\\ufe0f",":white_square_button:":"\\ud83d\\udd33",":white_sun_cloud:":"\\ud83c\\udf25\\ufe0f",":white_sun_rain_cloud:":"\\ud83c\\udf26\\ufe0f",":white_sun_small_cloud:":"\\ud83c\\udf24\\ufe0f",":wilted_flower:":"\\ud83e\\udd40",":wilted_rose:":"\\ud83e\\udd40",":wind_blowing_face:":"\\ud83c\\udf2c\\ufe0f",":wind_chime:":"\\ud83c\\udf90",":wind_face:":"\\ud83c\\udf2c",":wine_glass:":"\\ud83c\\udf77",":wink:":"\\ud83d\\ude09",":wolf:":"\\ud83d\\udc3a",":woman:":"\\ud83d\\udc69",":woman_artist:":"\\ud83d\\udc69\\u200d\\ud83c\\udfa8",
":woman_artist_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\ud83c\\udfa8",":woman_artist_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\ud83c\\udfa8",":woman_artist_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\ud83c\\udfa8",":woman_artist_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\ud83c\\udfa8",":woman_artist_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\ud83c\\udfa8",":woman_astronaut:":"\\ud83d\\udc69\\u200d\\ud83d\\ude80",":woman_astronaut_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\ud83d\\ude80",":woman_astronaut_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\ud83d\\ude80",
":woman_astronaut_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\ud83d\\ude80",":woman_astronaut_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\ud83d\\ude80",":woman_astronaut_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\ud83d\\ude80",":woman_biking:":"\\ud83d\\udeb4\\u200d\\u2640\\ufe0f",":woman_biking_tone1:":"\\ud83d\\udeb4\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_biking_tone2:":"\\ud83d\\udeb4\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_biking_tone3:":"\\ud83d\\udeb4\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_biking_tone4:":"\\ud83d\\udeb4\\ud83c\\udffe\\u200d\\u2640\\ufe0f",
":woman_biking_tone5:":"\\ud83d\\udeb4\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_bouncing_ball:":"\\u26f9\\ufe0f\\u200d\\u2640\\ufe0f",":woman_bouncing_ball_tone1:":"\\u26f9\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_bouncing_ball_tone2:":"\\u26f9\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_bouncing_ball_tone3:":"\\u26f9\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_bouncing_ball_tone4:":"\\u26f9\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_bouncing_ball_tone5:":"\\u26f9\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_bowing:":"\\ud83d\\ude47\\u200d\\u2640\\ufe0f",
":woman_bowing_tone1:":"\\ud83d\\ude47\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_bowing_tone2:":"\\ud83d\\ude47\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_bowing_tone3:":"\\ud83d\\ude47\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_bowing_tone4:":"\\ud83d\\ude47\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_bowing_tone5:":"\\ud83d\\ude47\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_cartwheeling:":"\\ud83e\\udd38\\u200d\\u2640\\ufe0f",":woman_cartwheeling_tone1:":"\\ud83e\\udd38\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_cartwheeling_tone2:":"\\ud83e\\udd38\\ud83c\\udffc\\u200d\\u2640\\ufe0f",
":woman_cartwheeling_tone3:":"\\ud83e\\udd38\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_cartwheeling_tone4:":"\\ud83e\\udd38\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_cartwheeling_tone5:":"\\ud83e\\udd38\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_climbing:":"\\ud83e\\uddd7\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_climbing_tone1:":"\\ud83e\\uddd7\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_climbing_tone2:":"\\ud83e\\uddd7\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_climbing_tone3:":"\\ud83e\\uddd7\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_climbing_tone4:":"\\ud83e\\uddd7\\ud83c\\udffe\\u200d\\u2640\\ufe0f",
":woman_climbing_tone5:":"\\ud83e\\uddd7\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_construction_worker:":"\\ud83d\\udc77\\u200d\\u2640\\ufe0f",":woman_construction_worker_tone1:":"\\ud83d\\udc77\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_construction_worker_tone2:":"\\ud83d\\udc77\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_construction_worker_tone3:":"\\ud83d\\udc77\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_construction_worker_tone4:":"\\ud83d\\udc77\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_construction_worker_tone5:":"\\ud83d\\udc77\\ud83c\\udfff\\u200d\\u2640\\ufe0f",
":woman_cook:":"\\ud83d\\udc69\\u200d\\ud83c\\udf73",":woman_cook_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\ud83c\\udf73",":woman_cook_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\ud83c\\udf73",":woman_cook_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\ud83c\\udf73",":woman_cook_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\ud83c\\udf73",":woman_cook_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\ud83c\\udf73",":woman_detective:":"\\ud83d\\udd75\\ufe0f\\u200d\\u2640\\ufe0f",":woman_detective_tone1:":"\\ud83d\\udd75\\ud83c\\udffb\\u200d\\u2640\\ufe0f",
":woman_detective_tone2:":"\\ud83d\\udd75\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_detective_tone3:":"\\ud83d\\udd75\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_detective_tone4:":"\\ud83d\\udd75\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_detective_tone5:":"\\ud83d\\udd75\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_elf:":"\\ud83e\\udddd\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_elf_tone1:":"\\ud83e\\udddd\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_elf_tone2:":"\\ud83e\\udddd\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_elf_tone3:":"\\ud83e\\udddd\\ud83c\\udffd\\u200d\\u2640\\ufe0f",
":woman_elf_tone4:":"\\ud83e\\udddd\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_elf_tone5:":"\\ud83e\\udddd\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_facepalming:":"\\ud83e\\udd26\\u200d\\u2640\\ufe0f",":woman_facepalming_tone1:":"\\ud83e\\udd26\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_facepalming_tone2:":"\\ud83e\\udd26\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_facepalming_tone3:":"\\ud83e\\udd26\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_facepalming_tone4:":"\\ud83e\\udd26\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_facepalming_tone5:":"\\ud83e\\udd26\\ud83c\\udfff\\u200d\\u2640\\ufe0f",
":woman_factory_worker:":"\\ud83d\\udc69\\u200d\\ud83c\\udfed",":woman_factory_worker_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\ud83c\\udfed",":woman_factory_worker_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\ud83c\\udfed",":woman_factory_worker_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\ud83c\\udfed",":woman_factory_worker_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\ud83c\\udfed",":woman_factory_worker_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\ud83c\\udfed",":woman_fairy:":"\\ud83e\\uddda\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_fairy_tone1:":"\\ud83e\\uddda\\ud83c\\udffb\\u200d\\u2640\\ufe0f",
":woman_fairy_tone2:":"\\ud83e\\uddda\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_fairy_tone3:":"\\ud83e\\uddda\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_fairy_tone4:":"\\ud83e\\uddda\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_fairy_tone5:":"\\ud83e\\uddda\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_farmer:":"\\ud83d\\udc69\\u200d\\ud83c\\udf3e",":woman_farmer_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\ud83c\\udf3e",":woman_farmer_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\ud83c\\udf3e",":woman_farmer_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\ud83c\\udf3e",
":woman_farmer_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\ud83c\\udf3e",":woman_farmer_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\ud83c\\udf3e",":woman_firefighter:":"\\ud83d\\udc69\\u200d\\ud83d\\ude92",":woman_firefighter_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\ud83d\\ude92",":woman_firefighter_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\ud83d\\ude92",":woman_firefighter_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\ud83d\\ude92",":woman_firefighter_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\ud83d\\ude92",":woman_firefighter_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\ud83d\\ude92",
":woman_frowning:":"\\ud83d\\ude4d\\u200d\\u2640\\ufe0f",":woman_frowning_tone1:":"\\ud83d\\ude4d\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_frowning_tone2:":"\\ud83d\\ude4d\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_frowning_tone3:":"\\ud83d\\ude4d\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_frowning_tone4:":"\\ud83d\\ude4d\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_frowning_tone5:":"\\ud83d\\ude4d\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_genie:":"\\ud83e\\uddde\\u200d\\u2640\\ufe0f",":woman_gesturing_no:":"\\ud83d\\ude45\\u200d\\u2640\\ufe0f",
":woman_gesturing_no_tone1:":"\\ud83d\\ude45\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_gesturing_no_tone2:":"\\ud83d\\ude45\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_gesturing_no_tone3:":"\\ud83d\\ude45\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_gesturing_no_tone4:":"\\ud83d\\ude45\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_gesturing_no_tone5:":"\\ud83d\\ude45\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_gesturing_ok:":"\\ud83d\\ude46\\u200d\\u2640\\ufe0f",":woman_gesturing_ok_tone1:":"\\ud83d\\ude46\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_gesturing_ok_tone2:":"\\ud83d\\ude46\\ud83c\\udffc\\u200d\\u2640\\ufe0f",
":woman_gesturing_ok_tone3:":"\\ud83d\\ude46\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_gesturing_ok_tone4:":"\\ud83d\\ude46\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_gesturing_ok_tone5:":"\\ud83d\\ude46\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_getting_face_massage:":"\\ud83d\\udc86\\u200d\\u2640\\ufe0f",":woman_getting_face_massage_tone1:":"\\ud83d\\udc86\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_getting_face_massage_tone2:":"\\ud83d\\udc86\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_getting_face_massage_tone3:":"\\ud83d\\udc86\\ud83c\\udffd\\u200d\\u2640\\ufe0f",
":woman_getting_face_massage_tone4:":"\\ud83d\\udc86\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_getting_face_massage_tone5:":"\\ud83d\\udc86\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_getting_haircut:":"\\ud83d\\udc87\\u200d\\u2640\\ufe0f",":woman_getting_haircut_tone1:":"\\ud83d\\udc87\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_getting_haircut_tone2:":"\\ud83d\\udc87\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_getting_haircut_tone3:":"\\ud83d\\udc87\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_getting_haircut_tone4:":"\\ud83d\\udc87\\ud83c\\udffe\\u200d\\u2640\\ufe0f",
":woman_getting_haircut_tone5:":"\\ud83d\\udc87\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_golfing:":"\\ud83c\\udfcc\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_golfing_tone1:":"\\ud83c\\udfcc\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_golfing_tone2:":"\\ud83c\\udfcc\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_golfing_tone3:":"\\ud83c\\udfcc\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_golfing_tone4:":"\\ud83c\\udfcc\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_golfing_tone5:":"\\ud83c\\udfcc\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_guard:":"\\ud83d\\udc82\\u200d\\u2640\\ufe0f",
":woman_guard_tone1:":"\\ud83d\\udc82\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_guard_tone2:":"\\ud83d\\udc82\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_guard_tone3:":"\\ud83d\\udc82\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_guard_tone4:":"\\ud83d\\udc82\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_guard_tone5:":"\\ud83d\\udc82\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_health_worker:":"\\ud83d\\udc69\\u200d\\u2695\\ufe0f",":woman_health_worker_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\u2695\\ufe0f",":woman_health_worker_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\u2695\\ufe0f",
":woman_health_worker_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\u2695\\ufe0f",":woman_health_worker_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\u2695\\ufe0f",":woman_health_worker_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\u2695\\ufe0f",":woman_in_lotus_position:":"\\ud83e\\uddd8\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_in_lotus_position_tone1:":"\\ud83e\\uddd8\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_in_lotus_position_tone2:":"\\ud83e\\uddd8\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_in_lotus_position_tone3:":"\\ud83e\\uddd8\\ud83c\\udffd\\u200d\\u2640\\ufe0f",
":woman_in_lotus_position_tone4:":"\\ud83e\\uddd8\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_in_lotus_position_tone5:":"\\ud83e\\uddd8\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_in_steamy_room:":"\\ud83e\\uddd6\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_in_steamy_room_tone1:":"\\ud83e\\uddd6\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_in_steamy_room_tone2:":"\\ud83e\\uddd6\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_in_steamy_room_tone3:":"\\ud83e\\uddd6\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_in_steamy_room_tone4:":"\\ud83e\\uddd6\\ud83c\\udffe\\u200d\\u2640\\ufe0f",
":woman_in_steamy_room_tone5:":"\\ud83e\\uddd6\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_judge:":"\\ud83d\\udc69\\u200d\\u2696\\ufe0f",":woman_judge_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\u2696\\ufe0f",":woman_judge_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\u2696\\ufe0f",":woman_judge_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\u2696\\ufe0f",":woman_judge_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\u2696\\ufe0f",":woman_judge_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\u2696\\ufe0f",":woman_juggling:":"\\ud83e\\udd39\\u200d\\u2640\\ufe0f",
":woman_juggling_tone1:":"\\ud83e\\udd39\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_juggling_tone2:":"\\ud83e\\udd39\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_juggling_tone3:":"\\ud83e\\udd39\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_juggling_tone4:":"\\ud83e\\udd39\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_juggling_tone5:":"\\ud83e\\udd39\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_lifting_weights:":"\\ud83c\\udfcb\\ufe0f\\u200d\\u2640\\ufe0f",":woman_lifting_weights_tone1:":"\\ud83c\\udfcb\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_lifting_weights_tone2:":"\\ud83c\\udfcb\\ud83c\\udffc\\u200d\\u2640\\ufe0f",
":woman_lifting_weights_tone3:":"\\ud83c\\udfcb\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_lifting_weights_tone4:":"\\ud83c\\udfcb\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_lifting_weights_tone5:":"\\ud83c\\udfcb\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_mage:":"\\ud83e\\uddd9\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_mage_tone1:":"\\ud83e\\uddd9\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_mage_tone2:":"\\ud83e\\uddd9\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_mage_tone3:":"\\ud83e\\uddd9\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_mage_tone4:":"\\ud83e\\uddd9\\ud83c\\udffe\\u200d\\u2640\\ufe0f",
":woman_mage_tone5:":"\\ud83e\\uddd9\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_mechanic:":"\\ud83d\\udc69\\u200d\\ud83d\\udd27",":woman_mechanic_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\ud83d\\udd27",":woman_mechanic_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\ud83d\\udd27",":woman_mechanic_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\ud83d\\udd27",":woman_mechanic_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\ud83d\\udd27",":woman_mechanic_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\ud83d\\udd27",":woman_mountain_biking:":"\\ud83d\\udeb5\\u200d\\u2640\\ufe0f",
":woman_mountain_biking_tone1:":"\\ud83d\\udeb5\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_mountain_biking_tone2:":"\\ud83d\\udeb5\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_mountain_biking_tone3:":"\\ud83d\\udeb5\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_mountain_biking_tone4:":"\\ud83d\\udeb5\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_mountain_biking_tone5:":"\\ud83d\\udeb5\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_office_worker:":"\\ud83d\\udc69\\u200d\\ud83d\\udcbc",":woman_office_worker_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\ud83d\\udcbc",
":woman_office_worker_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\ud83d\\udcbc",":woman_office_worker_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\ud83d\\udcbc",":woman_office_worker_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\ud83d\\udcbc",":woman_office_worker_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\ud83d\\udcbc",":woman_pilot:":"\\ud83d\\udc69\\u200d\\u2708\\ufe0f",":woman_pilot_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\u2708\\ufe0f",":woman_pilot_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\u2708\\ufe0f",":woman_pilot_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\u2708\\ufe0f",
":woman_pilot_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\u2708\\ufe0f",":woman_pilot_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\u2708\\ufe0f",":woman_playing_handball:":"\\ud83e\\udd3e\\u200d\\u2640\\ufe0f",":woman_playing_handball_tone1:":"\\ud83e\\udd3e\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_playing_handball_tone2:":"\\ud83e\\udd3e\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_playing_handball_tone3:":"\\ud83e\\udd3e\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_playing_handball_tone4:":"\\ud83e\\udd3e\\ud83c\\udffe\\u200d\\u2640\\ufe0f",
":woman_playing_handball_tone5:":"\\ud83e\\udd3e\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_playing_water_polo:":"\\ud83e\\udd3d\\u200d\\u2640\\ufe0f",":woman_playing_water_polo_tone1:":"\\ud83e\\udd3d\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_playing_water_polo_tone2:":"\\ud83e\\udd3d\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_playing_water_polo_tone3:":"\\ud83e\\udd3d\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_playing_water_polo_tone4:":"\\ud83e\\udd3d\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_playing_water_polo_tone5:":"\\ud83e\\udd3d\\ud83c\\udfff\\u200d\\u2640\\ufe0f",
":woman_police_officer:":"\\ud83d\\udc6e\\u200d\\u2640\\ufe0f",":woman_police_officer_tone1:":"\\ud83d\\udc6e\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_police_officer_tone2:":"\\ud83d\\udc6e\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_police_officer_tone3:":"\\ud83d\\udc6e\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_police_officer_tone4:":"\\ud83d\\udc6e\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_police_officer_tone5:":"\\ud83d\\udc6e\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_pouting:":"\\ud83d\\ude4e\\u200d\\u2640\\ufe0f",":woman_pouting_tone1:":"\\ud83d\\ude4e\\ud83c\\udffb\\u200d\\u2640\\ufe0f",
":woman_pouting_tone2:":"\\ud83d\\ude4e\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_pouting_tone3:":"\\ud83d\\ude4e\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_pouting_tone4:":"\\ud83d\\ude4e\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_pouting_tone5:":"\\ud83d\\ude4e\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_raising_hand:":"\\ud83d\\ude4b\\u200d\\u2640\\ufe0f",":woman_raising_hand_tone1:":"\\ud83d\\ude4b\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_raising_hand_tone2:":"\\ud83d\\ude4b\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_raising_hand_tone3:":"\\ud83d\\ude4b\\ud83c\\udffd\\u200d\\u2640\\ufe0f",
":woman_raising_hand_tone4:":"\\ud83d\\ude4b\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_raising_hand_tone5:":"\\ud83d\\ude4b\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_rowing_boat:":"\\ud83d\\udea3\\u200d\\u2640\\ufe0f",":woman_rowing_boat_tone1:":"\\ud83d\\udea3\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_rowing_boat_tone2:":"\\ud83d\\udea3\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_rowing_boat_tone3:":"\\ud83d\\udea3\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_rowing_boat_tone4:":"\\ud83d\\udea3\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_rowing_boat_tone5:":"\\ud83d\\udea3\\ud83c\\udfff\\u200d\\u2640\\ufe0f",
":woman_running:":"\\ud83c\\udfc3\\u200d\\u2640\\ufe0f",":woman_running_tone1:":"\\ud83c\\udfc3\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_running_tone2:":"\\ud83c\\udfc3\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_running_tone3:":"\\ud83c\\udfc3\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_running_tone4:":"\\ud83c\\udfc3\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_running_tone5:":"\\ud83c\\udfc3\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_scientist:":"\\ud83d\\udc69\\u200d\\ud83d\\udd2c",":woman_scientist_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\ud83d\\udd2c",
":woman_scientist_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\ud83d\\udd2c",":woman_scientist_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\ud83d\\udd2c",":woman_scientist_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\ud83d\\udd2c",":woman_scientist_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\ud83d\\udd2c",":woman_shrugging:":"\\ud83e\\udd37\\u200d\\u2640\\ufe0f",":woman_shrugging_tone1:":"\\ud83e\\udd37\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_shrugging_tone2:":"\\ud83e\\udd37\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_shrugging_tone3:":"\\ud83e\\udd37\\ud83c\\udffd\\u200d\\u2640\\ufe0f",
":woman_shrugging_tone4:":"\\ud83e\\udd37\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_shrugging_tone5:":"\\ud83e\\udd37\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_singer:":"\\ud83d\\udc69\\u200d\\ud83c\\udfa4",":woman_singer_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\ud83c\\udfa4",":woman_singer_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\ud83c\\udfa4",":woman_singer_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\ud83c\\udfa4",":woman_singer_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\ud83c\\udfa4",":woman_singer_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\ud83c\\udfa4",
":woman_student:":"\\ud83d\\udc69\\u200d\\ud83c\\udf93",":woman_student_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\ud83c\\udf93",":woman_student_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\ud83c\\udf93",":woman_student_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\ud83c\\udf93",":woman_student_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\ud83c\\udf93",":woman_student_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\ud83c\\udf93",":woman_surfing:":"\\ud83c\\udfc4\\u200d\\u2640\\ufe0f",":woman_surfing_tone1:":"\\ud83c\\udfc4\\ud83c\\udffb\\u200d\\u2640\\ufe0f",
":woman_surfing_tone2:":"\\ud83c\\udfc4\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_surfing_tone3:":"\\ud83c\\udfc4\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_surfing_tone4:":"\\ud83c\\udfc4\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_surfing_tone5:":"\\ud83c\\udfc4\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_swimming:":"\\ud83c\\udfca\\u200d\\u2640\\ufe0f",":woman_swimming_tone1:":"\\ud83c\\udfca\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_swimming_tone2:":"\\ud83c\\udfca\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_swimming_tone3:":"\\ud83c\\udfca\\ud83c\\udffd\\u200d\\u2640\\ufe0f",
":woman_swimming_tone4:":"\\ud83c\\udfca\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_swimming_tone5:":"\\ud83c\\udfca\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_teacher:":"\\ud83d\\udc69\\u200d\\ud83c\\udfeb",":woman_teacher_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\ud83c\\udfeb",":woman_teacher_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\ud83c\\udfeb",":woman_teacher_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\ud83c\\udfeb",":woman_teacher_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\ud83c\\udfeb",":woman_teacher_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\ud83c\\udfeb",
":woman_technologist:":"\\ud83d\\udc69\\u200d\\ud83d\\udcbb",":woman_technologist_tone1:":"\\ud83d\\udc69\\ud83c\\udffb\\u200d\\ud83d\\udcbb",":woman_technologist_tone2:":"\\ud83d\\udc69\\ud83c\\udffc\\u200d\\ud83d\\udcbb",":woman_technologist_tone3:":"\\ud83d\\udc69\\ud83c\\udffd\\u200d\\ud83d\\udcbb",":woman_technologist_tone4:":"\\ud83d\\udc69\\ud83c\\udffe\\u200d\\ud83d\\udcbb",":woman_technologist_tone5:":"\\ud83d\\udc69\\ud83c\\udfff\\u200d\\ud83d\\udcbb",":woman_tipping_hand:":"\\ud83d\\udc81\\u200d\\u2640\\ufe0f",":woman_tipping_hand_tone1:":"\\ud83d\\udc81\\ud83c\\udffb\\u200d\\u2640\\ufe0f",
":woman_tipping_hand_tone2:":"\\ud83d\\udc81\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_tipping_hand_tone3:":"\\ud83d\\udc81\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_tipping_hand_tone4:":"\\ud83d\\udc81\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_tipping_hand_tone5:":"\\ud83d\\udc81\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_tone1:":"\\ud83d\\udc69\\ud83c\\udffb",":woman_tone2:":"\\ud83d\\udc69\\ud83c\\udffc",":woman_tone3:":"\\ud83d\\udc69\\ud83c\\udffd",":woman_tone4:":"\\ud83d\\udc69\\ud83c\\udffe",":woman_tone5:":"\\ud83d\\udc69\\ud83c\\udfff",
":woman_vampire:":"\\ud83e\\udddb\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_vampire_tone1:":"\\ud83e\\udddb\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_vampire_tone2:":"\\ud83e\\udddb\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_vampire_tone3:":"\\ud83e\\udddb\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_vampire_tone4:":"\\ud83e\\udddb\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_vampire_tone5:":"\\ud83e\\udddb\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_walking:":"\\ud83d\\udeb6\\u200d\\u2640\\ufe0f",":woman_walking_tone1:":"\\ud83d\\udeb6\\ud83c\\udffb\\u200d\\u2640\\ufe0f",
":woman_walking_tone2:":"\\ud83d\\udeb6\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_walking_tone3:":"\\ud83d\\udeb6\\ud83c\\udffd\\u200d\\u2640\\ufe0f",":woman_walking_tone4:":"\\ud83d\\udeb6\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_walking_tone5:":"\\ud83d\\udeb6\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_wearing_turban:":"\\ud83d\\udc73\\u200d\\u2640\\ufe0f",":woman_wearing_turban_tone1:":"\\ud83d\\udc73\\ud83c\\udffb\\u200d\\u2640\\ufe0f",":woman_wearing_turban_tone2:":"\\ud83d\\udc73\\ud83c\\udffc\\u200d\\u2640\\ufe0f",":woman_wearing_turban_tone3:":"\\ud83d\\udc73\\ud83c\\udffd\\u200d\\u2640\\ufe0f",
":woman_wearing_turban_tone4:":"\\ud83d\\udc73\\ud83c\\udffe\\u200d\\u2640\\ufe0f",":woman_wearing_turban_tone5:":"\\ud83d\\udc73\\ud83c\\udfff\\u200d\\u2640\\ufe0f",":woman_with_headscarf:":"\\ud83e\\uddd5\\ud83c\\udfff",":woman_with_headscarf_tone1:":"\\ud83e\\uddd5\\ud83c\\udffb",":woman_with_headscarf_tone2:":"\\ud83e\\uddd5\\ud83c\\udffc",":woman_with_headscarf_tone3:":"\\ud83e\\uddd5\\ud83c\\udffd",":woman_with_headscarf_tone4:":"\\ud83e\\uddd5\\ud83c\\udffe",":woman_with_headscarf_tone5:":"\\ud83e\\uddd5\\ud83c\\udfff",":woman_with_turban:":"\\ud83d\\udc73\\u200d\\u2640\\ufe0f",
":woman_zombie:":"\\ud83e\\udddf\\u200d\\u2640\\ufe0f",":womans_clothes:":"\\ud83d\\udc5a",":womans_hat:":"\\ud83d\\udc52",":women_with_bunny_ears_partying:":"\\ud83d\\udc6f\\u200d\\u2640\\ufe0f",":women_wrestling:":"\\ud83e\\udd3c\\u200d\\u2640\\ufe0f",":womens:":"\\ud83d\\udeba",":world_map:":"\\ud83d\\uddfa",":worried:":"\\ud83d\\ude1f",":wrench:":"\\ud83d\\udd27",":writing_hand:":"\\u270d\\ufe0f",":writing_hand_tone1:":"\\u270d\\ud83c\\udffb",":writing_hand_tone2:":"\\u270d\\ud83c\\udffc",":writing_hand_tone3:":"\\u270d\\ud83c\\udffd",
":writing_hand_tone4:":"\\u270d\\ud83c\\udffe",":writing_hand_tone5:":"\\u270d\\ud83c\\udfff",":x:":"\\u274c",":yellow_heart:":"\\ud83d\\udc9b",":yemen:":"\\ud83c\\uddfe\\ud83c\\uddea",":yen:":"\\ud83d\\udcb4",":yin_yang:":"\\u262f\\ufe0f",":yum:":"\\ud83d\\ude0b",":zambia:":"\\ud83c\\uddff\\ud83c\\uddf2",":zap:":"\\u26a1\\ufe0f",":zebra:":"\\ud83e\\udd93",":zero:":"0\\u20e3",":zimbabwe:":"\\ud83c\\uddff\\ud83c\\uddfc",":zipper_mouth:":"\\ud83e\\udd10",":zipper_mouth_face:":"\\ud83e\\udd10",":zombie:":"\\ud83e\\udddf",":zzz:":"\\ud83d\\udca4",
":|":"\\ud83d\\ude10",";)":"\\ud83d\\ude09",";-)":"\\ud83d\\ude09",";-P":"\\ud83d\\ude1c",";-p":"\\ud83d\\ude1c",";P":"\\ud83d\\ude1c",";p":"\\ud83d\\ude1c"},"MediaEmbed.hosts":{"bandcamp.com":"bandcamp","dai.ly":"dailymotion","dailymotion.com":"dailymotion","facebook.com":"facebook","indiegogo.com":"indiegogo","instagram.com":"instagram","kickstarter.com":"kickstarter","liveleak.com":"liveleak","soundcloud.com":"soundcloud","twitch.tv":"twitch","twitter.com":"twitter","vimeo.com":"vimeo","vine.co":"vine","worldstarhiphop.com":"wshh",
"youtu.be":"youtube","youtube.com":"youtube"},"MediaEmbed.sites":{bandcamp:[[],[{u:[[/\\/album=(\\d+)/,ja]],match:[[/bandcamp\\.com\\/album\\/./,r]]},{u:[[/"album_id":(\\d+)/,ja],[/"track_num":(\\d+)/,["","track_num"]],[/\\/track=(\\d+)/,ia]],match:[[/bandcamp\\.com\\/track\\/./,r]]}]],dailymotion:[[[/dai\\.ly\\/([a-z0-9]+)/i,v],[/dailymotion\\.com\\/(?:live\\/|swf\\/|user\\/[^#]+#video=|(?:related\\/\\d+\\/)?video\\/)([a-z0-9]+)/i,v],[/start=(\\d+)/,ba]],[]],facebook:[[[/\\/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com\\/(?:[\\/\\w]+\\/permalink|(?!pages\\/|groups\\/).*?)(?:\\/|fbid=|\\?v=)(\\d+)(?=$|[\\/?&#])/,
v],[/facebook\\.com\\/([.\\w]+)\\/(post|video)s?\\//,["","user","type"]],[/facebook\\.com\\/video\\/(post|video)\\.php/,["","type"]]],[]],indiegogo:[[[/indiegogo\\.com\\/projects\\/([-\\w]+)/,v]],[]],instagram:[[[/instagram\\.com\\/(?:p|tv)\\/([-\\w]+)/,v]],[]],kickstarter:[[[/kickstarter\\.com\\/projects\\/([^\\/]+\\/[^\\/?]+)(?:\\/widget\\/(?:(card)|(video)))?/,["","id","card","video"]]],[]],liveleak:[[[/liveleak\\.com\\/(?:e\\/|view\\?i=)(\\w+)/,v]],[{u:[[/liveleak\\.com\\/e\\/(\\w+)/,v]],match:[[/liveleak\\.com\\/view\\?t=/,r]]}]],
soundcloud:[[[/https?:\\/\\/(?:api\\.)?soundcloud\\.com\\/(?!pages\\/)([-\\/\\w]+\\/[-\\/\\w]+|^[^\\/]+\\/[^\\/]+$)/i,v],[/api\\.soundcloud\\.com\\/playlists\\/(\\d+)/,ka],[/api\\.soundcloud\\.com\\/tracks\\/(\\d+)(?:\\?secret_token=([-\\w]+))?/,["","track_id","secret_token"]],[/soundcloud\\.com\\/(?!playlists|tracks)[-\\w]+\\/[-\\w]+\\/(?=s-)([-\\w]+)/,["","secret_token"]]],[{u:[[/soundcloud:tracks:(\\d+)/,ia]],O:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/(?!playlists\\/\\d|tracks\\/\\d)[-\\w]+\\/[-\\w]/,r]]},{u:[[/soundcloud:\\/\\/playlists:(\\d+)/,
ka]],O:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/\\w+\\/sets\\//,r]]}]],twitch:[[[/twitch\\.tv\\/(?:videos|\\w+\\/v)\\/(\\d+)?/,["","video_id"]],[/www\\.twitch\\.tv\\/(?!videos\\/)(\\w+)/,["","channel"]],[/t=((?:(?:\\d+h)?\\d+m)?\\d+s)/,ba],[/clips\\.twitch\\.tv\\/(?:(\\w+)\\/)?(\\w+)/,["","channel","clip_id"]]],[]],twitter:[[[/twitter\\.com\\/(?:#!\\/|i\\/)?\\w+\\/(?:status(?:es)?|tweet)\\/(\\d+)/,v]],[]],vimeo:[[[/vimeo\\.com\\/(?:channels\\/[^\\/]+\\/|video\\/)?(\\d+)/,v],[/#t=([\\dhms]+)/,ba]],[]],vine:[[[/vine\\.co\\/v\\/([^\\/]+)/,
v]],[]],wshh:[[[/worldstarhiphop\\.com\\/featured\\/(\\d+)/,v]],[{u:[[/v: ?"?(\\d+)/,v]],match:[[/worldstarhiphop\\.com\\/(?:\\w+\\/)?video\\.php\\?v=\\w+/,r]]}]],youtube:[[[/youtube\\.com\\/(?:watch.*?v=|v\\/|attribution_link.*?v%3D)([-\\w]+)/,v],[/youtu\\.be\\/([-\\w]+)/,v],[/[#&?]t=(\\d[\\dhms]*)/,ba],[/[&?]list=([-\\w]+)/,["","list"]]],[{u:[[/\\/vi\\/([-\\w]+)/,v]],match:[[/\\/shared\\?ci=/,r]]}]]},urlConfig:{M:/^https?$/i}},Pa={e:w,flags:32},U={B:ya,BANDCAMP:{e:t,b:{album_id:y,track_id:y,track_num:y},j:2,c:E,g:10,d:x,
h:5E3},CENTER:{e:w,b:{},j:1,c:E,g:10,d:pa,h:5E3},CODE:{e:[0,0],b:{lang:ra},j:1,c:E,g:10,d:{p:A,flags:4432,q:A},h:5E3},COLOR:{e:ea,b:{color:{c:[function(a){return la(a,/^(?:#(?:(?:[0-9a-f]{3}){1,2}|(?:[0-9a-f]{4}){1,2})|rgb\\(\\d{1,3}, *\\d{1,3}, *\\d{1,3}\\)|rgba\\(\\d{1,3}, *\\d{1,3}, *\\d{1,3}, *\\d*(?:\\.\\d+)?\\)|[a-z]+)$/i)}],o:!0}},j:0,c:E,g:10,d:ca,h:5E3},DAILYMOTION:{e:t,b:{id:y,t:y},j:2,c:E,g:10,d:x,h:5E3},EMAIL:{e:fa,b:{email:{c:[function(a){return/^[-\\w.+]+@[-\\w.]+$/.test(a)?a:!1}],o:!0}},j:2,c:E,g:10,
d:da,h:5E3},EMOJI:{e:aa,b:{seq:sa,tseq:sa},j:0,c:E,g:10,d:x,h:5E3},FACEBOOK:{e:t,b:{id:y,type:y,user:y},j:2,c:E,g:10,d:x,h:5E3},FONT:{e:ea,b:{font:{c:[function(a){return la(a,/^(?:\'[- \\w]+\'|"[- \\w]+"|[- \\w]+)(?:, *(?:\'[- \\w]+\'|"[- \\w]+"|[- \\w]+))*$/)}],o:!0}},j:0,c:E,g:10,d:ca,h:5E3},I:ya,IMG:{e:aa,b:{alt:y,height:oa,src:wa,title:y,width:oa},j:0,c:E,g:10,d:x,h:5E3},INDIEGOGO:H,INSTAGRAM:H,KICKSTARTER:{e:t,b:{card:y,id:y,video:y},j:2,c:E,g:10,d:x,h:5E3},LI:{e:w,b:{},j:3,c:E,g:10,d:{p:{B:1,COLOR:1,
EMAIL:1,FONT:1,I:1,LI:1,S:1,SIZE:1,U:1,URL:1},flags:256,q:A},h:5E3},LIST:{e:ha,b:{start:oa,type:{c:[function(a){var b={A:"upper-alpha",I:"upper-roman",a:"lower-alpha",i:"lower-roman",1:"decimal"};return a in b?b[a]:a},function(a){return la(a,/^[- +,.0-9A-Za-z_]+$/)}],o:!1}},j:1,c:E,g:10,d:{p:A,H:["LI"],flags:3456,q:A},h:5E3},LIVELEAK:H,MEDIA:{e:[65431,256],b:{},j:8,c:[function(a){return function(b,c,d){function h(f,m,n){var l=!1;n.forEach(function(e){var g=e[1],p=e[0].exec(m);p&&(l=!0,g.forEach(function(k,
z){""<p[z]&&""<k&&(f[k]=p[z])}))});return l}(function(f,m,n){C(f);if("url"in f.b){var l=f.b.url,e;a:{for(e=/^https?:\\/\\/([^\\/]+)/.exec(l.toLowerCase())[1]||"";""<e;){if(m[e]){e=m[e];break a}e=e.replace(/^[^.]*./,"")}e=""}if(n[e]){m={};h(m,l,n[e][0]);a:{for(var g in m){n=!1;break a}n=!0}if(!n){n=f.f;g=f.s;if(g){var p=f.m;l=g.f;g=g.m}else p=0,l=f.f+f.m,g=0;e=e.toUpperCase();f=f.v;l=R(2,e,l,g,-f||0);f=R(1,e,n,p,f||0);K(f,l);D(f,m)}}}})(b,c,d)}(a,F["MediaEmbed.hosts"],F["MediaEmbed.sites"],F.cacheDir)}],
g:10,d:{flags:513},h:5E3},OL:za,QUOTE:{e:w,b:{author:y},j:1,c:E,g:10,d:pa,h:5E3},S:ya,SIZE:{e:ea,b:{size:{c:[function(a){return Ca(a)}],o:!0}},j:0,c:E,g:10,d:ca,h:5E3},SOUNDCLOUD:{e:t,b:{id:y,playlist_id:y,secret_token:y,track_id:y},j:2,c:E,g:10,d:x,h:5E3},SPOILER:{e:w,b:{title:y},j:4,c:E,g:10,d:pa,h:5E3},TABLE:{e:[65344,257],b:{},j:1,c:E,g:10,d:qa,h:5E3},TD:Aa,TH:Aa,TR:{e:[65312,257],b:{},j:6,c:E,g:10,d:{p:{B:1,COLOR:1,EMAIL:1,FONT:1,I:1,S:1,SIZE:1,TD:1,TH:1,TR:1,U:1,URL:1},flags:3456,q:A},h:5E3},
TWITCH:{e:t,b:{channel:y,clip_id:y,t:y,video_id:y},j:2,c:E,g:10,d:x,h:5E3},TWITTER:H,U:ya,UL:za,URL:{e:fa,b:{title:y,url:wa},j:7,c:E,g:10,d:da,h:5E3},VIMEO:{e:t,b:{id:y,t:na},j:2,c:E,g:10,d:x,h:5E3},VINE:H,WSHH:H,YOUTUBE:{e:t,b:{id:ra,list:y,t:na},j:2,c:E,g:10,d:x,h:5E3}},V,Qa,W,X,Ra=0,Y;
function Sa(a){a=a.replace(/\\r\\n?/g,"\\n");a=a.replace(/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]+/g,"");var b=B;b.n=[];delete b.f;delete b.k;Ma={};Na={};N=0;O=null;Oa=!1;P=[];Q="";T=0;V=[];Qa=!1;W=a;X=W.length;Y=0;M=Pa;M.K=!1;++Ra;a=Ra;for(var c in S)if(!S[c].x)a:{b=c;var d=S[b];if(!(d.z&&0>W.indexOf(d.z))){var h=[];if("undefined"!==typeof d.C&&"undefined"!==typeof d.D){h=void 0;var f=d.C;d=d.D;f.lastIndex=0;for(var m=[],n=0;++n<=d&&(h=f.exec(W));){for(var l=h.index,e=[[h[0],l]],g=0;++g<h.length;){var p=h[g];
void 0===p?e.push(["",-1]):(e.push([p,W.indexOf(p,l)]),l+=p.length)}m.push(e)}h=m;if(!h.length)break a}(0,S[b].y)(W,h)}}Ta();Ua(X,0,!0);do c=Q,Q=Q.replace(/<([^ />]+)[^>]*><\\/\\1>/g,"");while(Q!==c);Q=Q.replace(/<\\/i><i>/g,"");Q=Q.replace(/[\\x00-\\x08\\x0B-\\x1F]/g,"");Q=Q.replace(/[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,Wa);c=Oa?"r":"t";Q="<"+c+">"+Q+"</"+c+">";if(Ra!==a)throw"The parser has been reset during execution";1E4<N&&B.add("warn","Fixing cost limit exceeded",void 0);return Q}
function Xa(a){var b={},c;for(c in U[a])b[c]=U[a][c];return U[a]=b}function Wa(a){return"&#"+((a.charCodeAt(0)<<10)+a.charCodeAt(1)-56613888)+";"}
function Ya(a){Oa=!0;var b=a.name,c=a.f,d=a.m,h=0,f=0;a.flags&256&&(h=1,f=a.k&2?2:1);var m=!1;a.k&1||(m=!0);Ua(c,h,m);h=d?Fa(W.substr(c,d)):"";if(a.k&1){Q+="<"+b;var n=Ka(a);m=[];for(var l in n)m.push(l);m.sort(function(e,g){return e>g?1:-1});m.forEach(function(e){Q+=" "+e+\'="\'+Ea(n[e].toString()).replace(/\\n/g,"&#10;")+\'"\'});Q=3===a.k?d?Q+(">"+h+"</"+b+">"):Q+"/>":d?Q+("><s>"+h+"</s>"):Q+">"}else d&&(Q+="<e>"+h+"</e>"),Q+="</"+b+">";for(Y=T=c+d;f&&Y<X&&"\\n"===W[Y];)--f,++Y}
function Ua(a,b,c){c&&(M.flags&8?b=-1:c=!1);T>=a&&c&&Za();if(Y>T){var d=Math.min(a,Y);Q+=W.substr(T,d-T);T=d;T>=a&&c&&Za()}if(M.flags&128)b=a-T,b=W.substr(T,b),/^[ \\n\\t]*$/.test(b)||(b="<i>"+Fa(b)+"</i>"),Q+=b,T=a,c&&Za();else{var h=a;for(d=0;b&&--h>=T;){var f=W[h];if(" "!==f&&"\\n"!==f&&"\\t"!==f)break;"\\n"===f&&--b;++d}a-=d;a>T&&(b=Fa(W.substr(T,a-T)),32===(M.flags&2096)&&(b=b.replace(/\\n/g,"<br/>\\n")),Q+=b);c&&Za();d&&(Q+=W.substr(a,d));T=a+d}}
function $a(a){var b=a.f;a=a.m;var c=W.substr(b,a);Ua(b,0,!1);Q+="<i>"+Fa(c)+"</i>";Oa=!0;T=b+a}function Za(){M.K&&(Q+="</p>",M.K=!1)}function ab(a){a=U[a.name];if(a.d.H){var b=-1E3,c=W.substr(T),d=T+c.length-c.replace(/^[ \\n\\r\\t]+/,"").length;a.d.H.forEach(function(h){var f=++b;R(1,h,d,0,f||0)})}}function bb(a,b,c){var d=a.name;(O.flags|a.flags)&256&&(b=cb(b));b=R(2,d,b,0,c||0);K(b,a)}function cb(a){for(;a>T&&-1<" \\n\\t".indexOf(W[a-1]);)--a;return a}
function Ta(){if(V.length){for(var a in U)Ma[a]=0,Na[a]=0;do{for(;V.length;)Qa||db(),O=V.pop(),eb();P.forEach(function(b){bb(b,X)})}while(V.length)}}
function eb(){M.flags&64&&!La(O,P[P.length-1])&&!(-1<"br i pb v".indexOf(O.name))&&C(O);var a=O.f,b=O.m;if(T>a&&!O.n){var c;if((c=O.F)&&0<=P.indexOf(c)){K(R(2,c.name,T,Math.max(0,a+b-T),0),c);return}if("i"===O.name&&(a=a+b-T,0<a)){R(3,"i",T,Math.min(a,X-T),0);return}C(O)}if(!O.n)if("i"===O.name)$a(O);else if("br"===O.name)M.flags&1024||(Ua(O.f,0,!1),Q+="<br/>");else if("pb"===O.name)Ua(O.f,0,!0);else if("v"===O.name)a=M.flags,M.flags=O.flags,Ua(O.f+O.m,0,!1),M.flags=a;else if(O.k&1)if(a=O,b=a.name,
c=U[b],Na[b]>=c.h)B.add("err","Tag limit exceeded",{tag:a,tagName:b,tagLimit:c.h}),C(a);else{var d=a,h=U[d.name];B.k=d;for(var f=0;f<h.c.length&&!d.n;++f)h.c[f](d,h);delete B.k;if(!(d=a.n)&&(d=1E4>N)){a:{d=a;if(P.length){f=d.name;var m=U[f];if(m.d.q){h=P[P.length-1];var n=h.name;if(m.d.q[n]){if(n!==f&&1E4>N){f=d.f+d.m;V.length?(m=V[V.length-1],m=m.f):m=X+1;for(;f<m&&-1<" \\n\\t".indexOf(W[f]);)++f;f=fb(h,f);Ja(d,f)}V.push(d);bb(h,d.f,d.v-1);N+=4;d=!0;break a}}}d=!1}if(!d)a:{d=a;if(P.length&&(h=U[d.name],
h.d.p&&(f=P[P.length-1],h.d.p[f.name]))){++N;V.push(d);bb(f,d.f,d.v-1);d=!0;break a}d=!1}d=d||!1}d||(Ma[b]>=c.g?(B.add("err","Nesting limit exceeded",{tag:a,tagName:b,nestingLimit:c.g}),C(a)):(c=U[b].j,M.e[c>>3]&1<<(c&7)?(!(a.flags&1&&3!==a.k)||a.s||V.length&&La(V[V.length-1],a)||(b=new Ia(3,b,a.f,a.m),D(b,Ka(a)),b.flags=a.flags,a=b),a.flags&4096&&"\\n"===W[a.f+a.m]&&(b=a.f+a.m,R(3,"i",b,Math.min(1,X-b),0)),Ya(a),gb(a),ab(a)):(b={tag:a,tagName:b},0<a.m?B.add("warn","Tag is not allowed in this context",
b):Ha("Tag is not allowed in this context",b),C(a))))}else hb()}
function hb(){var a=O;if(Ma[a.name]){for(var b=[],c=P.length;0<=--c;){var d=P[c];if(La(a,d))break;b.push(d);++N}if(0>c)Ha("Skipping end tag with no start tag",{tag:a});else{var h=a.flags;b.forEach(function(g){h|=g.flags});var f=h&256,m=1E4>N,n=[];b.forEach(function(g){var p=g.name;m&&(g.flags&2?n.push(g):m=!1);var k=a.f;f&&(k=cb(k));p=new Ia(2,p,k,0);p.flags=g.flags;Ya(p);ib()});Ya(a);ib();if(b.length&&1E4>N){d=T;for(c=V.length;0<=--c&&1E4>++N;){var l=V[c];if(l.f>d||l.k&1)break;for(var e=b.length;0<=
--e&&1E4>++N;)if(La(l,b[e])){b.splice(e,1);n[e]&&n.splice(e,1);d=Math.max(d,l.f+l.m);break}}d>T&&$a(new Ia(3,"i",T,d-T))}n.forEach(function(g){var p=fb(g,T);(g=g.s)&&K(p,g)})}}}function ib(){var a=P.pop();--Ma[a.name];M=M.P}function gb(a){var b=a.name,c=a.flags,d=U[b];++Na[b];if(3!==a.k){var h=[];M.e.forEach(function(m,n){c&512||(m=m&65280|m>>8);h.push(d.e[n]&m)});var f=c|M.flags&32;f&16&&(f&=-33);++Ma[b];P.push(a);M={P:M};M.e=h;M.flags=f}}
function fb(a,b){b=R(a.k,a.name,b,0,a.v);D(b,Ka(a));return b}function R(a,b,c,d,h){a=new Ia(a,b,c,d,h||0);U[b]&&(a.flags=U[b].d.flags);if(!(U[b]||-1<"br i pb v".indexOf(a.name))||0>d||0>c||c+d>X||/[\\uDC00-\\uDFFF]/.test(W.substr(c,1)+W.substr(c+d,1)))C(a);else if(U[b]&&U[b].x)B.add("warn","Tag is disabled",{tag:a,tagName:b}),C(a);else if(Qa){b=V.length;for(c=jb(a);0<b&&c>jb(V[b-1]);)V[b]=V[b-1],--b;V[b]=a}else V.push(a);return a}
function db(){for(var a={},b=[],c=V.length;0<=--c;){var d=V[c],h=jb(d,c);b.push(h);a[h]=d}b.sort();c=b.length;for(V=[];0<=--c;)V.push(a[b[c]]);Qa=!0}function jb(a,b){var c=0<=a.v,d=a.v;c||(d+=1073741824);var h=0<a.m,f;h?f=X-a.m:f={2:0,3:1,1:2}[a.k];return kb(a.f)+ +c+kb(d)+ +h+kb(f)+kb(b||0)}function kb(a){a=a.toString(16);return"        ".substr(a.length)+a}var lb="undefined"===typeof DOMParser||"undefined"===typeof XSLTProcessor;
function mb(a){if(lb){var b=new ActiveXObject("MSXML2.FreeThreadedDOMDocument.6.0");b.async=!1;b.validateOnParse=!1;b.loadXML(a)}else b=(new DOMParser).parseFromString(a,"text/xml");if(!b)throw"Cannot parse "+a;return b}function nb(a,b){if(lb){var c=b.createElement("div");b=b.createDocumentFragment();Z.input=mb(a);Z.transform();for(c.innerHTML=Z.output;c.firstChild;)b.appendChild(c.firstChild);return b}return Z.transformToFragment(mb(a),b)}var Z,ob=mb(Ba);
if(lb){var pb=new ActiveXObject("MSXML2.XSLTemplate.6.0");pb.stylesheet=ob;Z=pb.createProcessor()}else Z=new XSLTProcessor,Z.importStylesheet(ob);var qb={};window.s9e||(window.s9e={});
window.s9e.TextFormatter={disablePlugin:function(a){S[a]&&(S[a].x=!0)},disableTag:function(a){U[a]&&(Xa(a).x=!0)},enablePlugin:function(a){S[a]&&(S[a].x=!1)},enableTag:function(a){U[a]&&(Xa(a).x=!1)},getLogger:function(){return B},parse:Sa,preview:function(a,b){function c(e,g){g=e.getAttribute("data-s9e-livepreview-on"+g);qb[g]||(qb[g]=new Function(g));qb[g].call(e)}function d(e,g){e instanceof Element&&e.hasAttribute("data-s9e-livepreview-on"+g)&&c(e,g);e=e.querySelectorAll("[data-s9e-livepreview-on"+
g+"]");for(var p=e.length;0<=--p;)c(e[p],g)}function h(e,g){var p=e.childNodes;g=g.childNodes;for(var k=p.length,z=g.length,I,G,q=0,u=0;q<k&&q<z;){I=p[q];G=g[q];if(!f(I,G))break;++q}for(var L=Math.min(k-q,z-q);u<L;){I=p[k-(u+1)];G=g[z-(u+1)];if(!f(I,G))break;++u}for(k-=u;--k>=q;)e.removeChild(p[k]),l=e;p=z-u;if(!(q>=p)){z=n.createDocumentFragment();k=q;do G=g[k],G instanceof Element&&d(G,"update"),l=z.appendChild(G);while(k<--p);u?e.insertBefore(z,e.childNodes[q]):e.appendChild(z)}}function f(e,g){if(e.nodeName!==
g.nodeName||e.nodeType!==g.nodeType)return!1;if(e instanceof HTMLElement&&g instanceof HTMLElement){var p;if(p=!e.isEqualNode(g))p=!(e.hasAttribute("data-s9e-livepreview-hash")&&g.hasAttribute("data-s9e-livepreview-hash")&&e.getAttribute("data-s9e-livepreview-hash")===g.getAttribute("data-s9e-livepreview-hash"));if(p){g.hasAttribute("data-s9e-livepreview-onupdate")&&c(g,"update");var k=e.attributes;p=g.attributes;for(var z=p.length,I=k.length,G=" "+e.getAttribute("data-s9e-livepreview-ignore-attrs")+
" ";0<=--I;){var q=k[I],u=q.namespaceURI;q=q.name;-1<G.indexOf(" "+q+" ")||g.hasAttributeNS(u,q)||(e.removeAttributeNS(u,q),l=e)}for(I=z;0<=--I;)k=p[I],u=k.namespaceURI,q=k.name,k=k.value,-1<G.indexOf(" "+q+" ")||k===e.getAttributeNS(u,q)||(e.setAttributeNS(u,q,k),l=e);h(e,g)}}else 3!==e.nodeType&&8!==e.nodeType||e.nodeValue===g.nodeValue||(e.nodeValue=g.nodeValue,l=e);return!0}function m(e){for(var g=e.length,p=0,k=0;0<=--g;)p=(p+e.charCodeAt(g))%65535,k=(p+k)%65535;return k<<16|p}var n=b.ownerDocument;
if(!n)throw"Target does not have a ownerDocument";a=nb(Sa(a).replace(/<[eis]>[^<]*<\\/[eis]>/g,""),n);var l=b;(function(e){e=e.querySelectorAll("[data-s9e-livepreview-hash]");for(var g=e.length;0<=--g;)e[g].setAttribute("data-s9e-livepreview-hash",m(e[g].outerHTML))})(a);d(a,"render");h(b,a);return l},registeredVars:F,setNestingLimit:function(a,b){U[a]&&(Xa(a).g=b)},setParameter:function(a,b){lb?Z.addParameter(a,b,""):Z.setParameter(null,a,b)},setTagLimit:function(a,b){U[a]&&(Xa(a).h=b)}};})();';
	}

	/**
	* {@inheritdoc}
	*/
	public static function getParser()
	{
		return unserialize('O:24:"s9e\\TextFormatter\\Parser":4:{s:16:"' . "\0" . '*' . "\0" . 'pluginsConfig";a:5:{s:9:"Autoemail";a:5:{s:8:"attrName";s:5:"email";s:10:"quickMatch";s:1:"@";s:6:"regexp";s:39:"/\\b[-a-z0-9_+.]+@[-a-z0-9.]*[a-z0-9]/Si";s:7:"tagName";s:5:"EMAIL";s:11:"regexpLimit";i:50000;}s:8:"Autolink";a:5:{s:8:"attrName";s:3:"url";s:6:"regexp";s:124:"#\\bhttps?://\\S(?>[^\\s()\\[\\]\\x{FF01}-\\x{FF0F}\\x{FF1A}-\\x{FF20}\\x{FF3B}-\\x{FF40}\\x{FF5B}-\\x{FF65}]|\\([^\\s()]*\\)|\\[\\w*\\])++#Siu";s:7:"tagName";s:3:"URL";s:10:"quickMatch";s:3:"://";s:11:"regexpLimit";i:50000;}s:7:"BBCodes";a:4:{s:7:"bbcodes";a:38:{s:1:"*";a:1:{s:7:"tagName";s:2:"LI";}s:1:"B";a:0:{}s:8:"BANDCAMP";a:1:{s:17:"contentAttributes";a:2:{i:0;s:2:"id";i:1;s:3:"url";}}s:6:"CENTER";R:19;s:4:"CODE";a:1:{s:16:"defaultAttribute";s:4:"lang";}s:5:"COLOR";R:19;s:11:"DAILYMOTION";R:20;s:5:"EMAIL";a:1:{s:17:"contentAttributes";a:1:{i:0;s:5:"email";}}s:8:"FACEBOOK";R:20;s:4:"FONT";R:19;s:1:"I";R:19;s:3:"IMG";a:2:{s:17:"contentAttributes";a:1:{i:0;s:3:"src";}s:16:"defaultAttribute";s:3:"src";}s:9:"INDIEGOGO";R:20;s:9:"INSTAGRAM";R:20;s:11:"KICKSTARTER";R:20;s:2:"LI";R:19;s:4:"LIST";a:1:{s:16:"defaultAttribute";s:4:"type";}s:8:"LIVELEAK";R:20;s:5:"MEDIA";a:1:{s:17:"contentAttributes";a:1:{i:0;s:3:"url";}}s:2:"OL";R:19;s:5:"QUOTE";a:1:{s:16:"defaultAttribute";s:6:"author";}s:1:"S";R:19;s:4:"SIZE";R:19;s:10:"SOUNDCLOUD";R:20;s:7:"SPOILER";a:1:{s:16:"defaultAttribute";s:5:"title";}s:5:"TABLE";R:19;s:2:"TD";a:1:{s:16:"defaultAttribute";s:5:"align";}s:2:"TH";R:42;s:2:"TR";R:19;s:6:"TWITCH";R:20;s:7:"TWITTER";R:20;s:1:"U";R:19;s:2:"UL";R:19;s:3:"URL";R:35;s:5:"VIMEO";R:20;s:4:"VINE";R:20;s:4:"WSHH";R:20;s:7:"YOUTUBE";R:20;}s:10:"quickMatch";s:1:"[";s:6:"regexp";s:30:"#\\[/?(\\*|[-\\w]+)(?=[\\]\\s=:/])#";s:11:"regexpLimit";i:50000;}s:5:"Emoji";a:2:{s:7:"tagName";s:5:"EMOJI";s:12:"customRegexp";s:42:"/(?::(?:[()?DPop|]|-[(-*?DPp|])|;-?[)Pp])/";}s:10:"MediaEmbed";a:4:{s:10:"quickMatch";s:3:"://";s:6:"regexp";s:26:"/\\bhttps?:\\/\\/[^["\'\\s]+/Si";s:7:"tagName";s:5:"MEDIA";s:11:"regexpLimit";i:50000;}}s:14:"registeredVars";a:4:{s:9:"urlConfig";a:1:{s:14:"allowedSchemes";s:12:"/^https?$/Di";}s:16:"MediaEmbed.hosts";a:16:{s:12:"bandcamp.com";s:8:"bandcamp";s:6:"dai.ly";s:11:"dailymotion";s:15:"dailymotion.com";s:11:"dailymotion";s:12:"facebook.com";s:8:"facebook";s:13:"indiegogo.com";s:9:"indiegogo";s:13:"instagram.com";s:9:"instagram";s:15:"kickstarter.com";s:11:"kickstarter";s:12:"liveleak.com";s:8:"liveleak";s:14:"soundcloud.com";s:10:"soundcloud";s:9:"twitch.tv";s:6:"twitch";s:11:"twitter.com";s:7:"twitter";s:9:"vimeo.com";s:5:"vimeo";s:7:"vine.co";s:4:"vine";s:19:"worldstarhiphop.com";s:4:"wshh";s:11:"youtube.com";s:7:"youtube";s:8:"youtu.be";s:7:"youtube";}s:16:"MediaEmbed.sites";a:14:{s:8:"bandcamp";a:2:{i:0;R:19;i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!/album=(?\'album_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"album_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/album/.!";i:1;a:1:{i:0;s:0:"";}}}}i:1;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:29:"!"album_id":(?\'album_id\'\\d+)!";i:1;R:82;}i:1;a:2:{i:0;s:31:"!"track_num":(?\'track_num\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"track_num";}}i:2;a:2:{i:0;s:25:"!/track=(?\'track_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"track_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/track/.!";i:1;R:88;}}}}}s:11:"dailymotion";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:27:"!dai\\.ly/(?\'id\'[a-z0-9]+)!i";i:1;a:2:{i:0;s:0:"";i:1;s:2:"id";}}i:1;a:2:{i:0;s:92:"!dailymotion\\.com/(?:live/|swf/|user/[^#]+#video=|(?:related/\\d+/)?video/)(?\'id\'[a-z0-9]+)!i";i:1;R:111;}i:2;a:2:{i:0;s:17:"!start=(?\'t\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:1:"t";}}}i:1;R:19;}s:8:"facebook";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:135:"@/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com/(?:[/\\w]+/permalink|(?!pages/|groups/).*?)(?:/|fbid=|\\?v=)(?\'id\'\\d+)(?=$|[/?&#])@";i:1;R:111;}i:1;a:2:{i:0;s:54:"@facebook\\.com/(?\'user\'[.\\w]+)/(?\'type\'post|video)s?/@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";}}i:2;a:2:{i:0;s:46:"@facebook\\.com/video/(?\'type\'post|video)\\.php@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"type";}}}i:1;R:19;}s:9:"indiegogo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!indiegogo\\.com/projects/(?\'id\'[-\\w]+)!";i:1;R:111;}}i:1;R:19;}s:9:"instagram";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!instagram\\.com/(?:p|tv)/(?\'id\'[-\\w]+)!";i:1;R:111;}}i:1;R:19;}s:11:"kickstarter";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:93:"!kickstarter\\.com/projects/(?\'id\'[^/]+/[^/?]+)(?:/widget/(?:(?\'card\'card)|(?\'video\'video)))?!";i:1;a:4:{i:0;s:0:"";i:1;s:2:"id";i:2;s:4:"card";i:3;s:5:"video";}}}i:1;R:19;}s:8:"liveleak";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!liveleak\\.com/(?:e/|view\\?i=)(?\'id\'\\w+)!";i:1;R:111;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"!liveleak\\.com/e/(?\'id\'\\w+)!";i:1;R:111;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!liveleak\\.com/view\\?t=!";i:1;R:88;}}}}}s:10:"soundcloud";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:84:"@https?://(?:api\\.)?soundcloud\\.com/(?!pages/)(?\'id\'[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)@i";i:1;R:111;}i:1;a:2:{i:0;s:52:"@api\\.soundcloud\\.com/playlists/(?\'playlist_id\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:11:"playlist_id";}}i:2;a:2:{i:0;s:89:"@api\\.soundcloud\\.com/tracks/(?\'track_id\'\\d+)(?:\\?secret_token=(?\'secret_token\'[-\\w]+))?@";i:1;a:3:{i:0;s:0:"";i:1;s:8:"track_id";i:2;s:12:"secret_token";}}i:3;a:2:{i:0;s:81:"@soundcloud\\.com/(?!playlists|tracks)[-\\w]+/[-\\w]+/(?=s-)(?\'secret_token\'[-\\w]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:12:"secret_token";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:36:"@soundcloud:tracks:(?\'track_id\'\\d+)@";i:1;R:101;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"@soundcloud\\.com/(?!playlists/\\d|tracks/\\d)[-\\w]+/[-\\w]@";i:1;R:88;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:44:"@soundcloud://playlists:(?\'playlist_id\'\\d+)@";i:1;R:171;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:27:"@soundcloud\\.com/\\w+/sets/@";i:1;R:88;}}}}}s:6:"twitch";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:47:"#twitch\\.tv/(?:videos|\\w+/v)/(?\'video_id\'\\d+)?#";i:1;a:2:{i:0;s:0:"";i:1;s:8:"video_id";}}i:1;a:2:{i:0;s:44:"#www\\.twitch\\.tv/(?!videos/)(?\'channel\'\\w+)#";i:1;a:2:{i:0;s:0:"";i:1;s:7:"channel";}}i:2;a:2:{i:0;s:32:"#t=(?\'t\'(?:(?:\\d+h)?\\d+m)?\\d+s)#";i:1;R:118;}i:3;a:2:{i:0;s:56:"#clips\\.twitch\\.tv/(?:(?\'channel\'\\w+)/)?(?\'clip_id\'\\w+)#";i:1;a:3:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:7:"clip_id";}}}i:1;R:19;}s:7:"twitter";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"@twitter\\.com/(?:#!/|i/)?\\w+/(?:status(?:es)?|tweet)/(?\'id\'\\d+)@";i:1;R:111;}}i:1;R:19;}s:5:"vimeo";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!vimeo\\.com/(?:channels/[^/]+/|video/)?(?\'id\'\\d+)!";i:1;R:111;}i:1;a:2:{i:0;s:19:"!#t=(?\'t\'[\\dhms]+)!";i:1;R:118;}}i:1;R:19;}s:4:"vine";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!vine\\.co/v/(?\'id\'[^/]+)!";i:1;R:111;}}i:1;R:19;}s:4:"wshh";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:42:"!worldstarhiphop\\.com/featured/(?\'id\'\\d+)!";i:1;R:111;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:18:"!v: ?"?(?\'id\'\\d+)!";i:1;R:111;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:49:"!worldstarhiphop\\.com/(?:\\w+/)?video\\.php\\?v=\\w+!";i:1;R:88;}}}}}s:7:"youtube";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:69:"!youtube\\.com/(?:watch.*?v=|v/|attribution_link.*?v%3D)(?\'id\'[-\\w]+)!";i:1;R:111;}i:1;a:2:{i:0;s:25:"!youtu\\.be/(?\'id\'[-\\w]+)!";i:1;R:111;}i:2;a:2:{i:0;s:25:"@[#&?]t=(?\'t\'\\d[\\dhms]*)@";i:1;R:118;}i:3;a:2:{i:0;s:26:"![&?]list=(?\'list\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:4:"list";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!/vi/(?\'id\'[-\\w]+)!";i:1;R:111;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:14:"!/shared\\?ci=!";i:1;R:88;}}}}}}s:13:"Emoji.aliases";a:3170:{s:4:":-1:";s:4:"👎";s:4:":+1:";s:4:"👍";s:17:":1st_place_medal:";s:4:"🥇";s:17:":2nd_place_medal:";s:4:"🥈";s:17:":3rd_place_medal:";s:4:"🥉";s:7:":8ball:";s:4:"🎱";s:3:":a:";s:7:"🅰️";s:4:":ab:";s:4:"🆎";s:5:":abc:";s:4:"🔤";s:6:":abcd:";s:4:"🔡";s:8:":accept:";s:4:"🉑";s:7:":adult:";s:8:"🧑🏿";s:13:":adult_tone1:";s:8:"🧑🏻";s:13:":adult_tone2:";s:8:"🧑🏼";s:13:":adult_tone3:";s:8:"🧑🏽";s:13:":adult_tone4:";s:8:"🧑🏾";s:13:":adult_tone5:";s:8:"🧑🏿";s:16:":aerial_tramway:";s:4:"🚡";s:13:":afghanistan:";s:8:"🇦🇫";s:10:":airplane:";s:6:"✈️";s:19:":airplane_arriving:";s:4:"🛬";s:20:":airplane_departure:";s:4:"🛫";s:16:":airplane_small:";s:7:"🛩️";s:15:":aland_islands:";s:8:"🇦🇽";s:13:":alarm_clock:";s:3:"⏰";s:9:":albania:";s:8:"🇦🇱";s:9:":alembic:";s:6:"⚗️";s:9:":algeria:";s:8:"🇩🇿";s:7:":alien:";s:4:"👽";s:11:":ambulance:";s:4:"🚑";s:16:":american_samoa:";s:8:"🇦🇸";s:9:":amphora:";s:4:"🏺";s:8:":anchor:";s:6:"⚓️";s:9:":andorra:";s:8:"🇦🇩";s:7:":angel:";s:4:"👼";s:13:":angel_tone1:";s:8:"👼🏻";s:13:":angel_tone2:";s:8:"👼🏼";s:13:":angel_tone3:";s:8:"👼🏽";s:13:":angel_tone4:";s:8:"👼🏾";s:13:":angel_tone5:";s:8:"👼🏿";s:7:":anger:";s:4:"💢";s:13:":anger_right:";s:7:"🗯️";s:8:":angola:";s:8:"🇦🇴";s:7:":angry:";s:4:"😠";s:10:":anguilla:";s:8:"🇦🇮";s:11:":anguished:";s:4:"😧";s:5:":ant:";s:4:"🐜";s:12:":antarctica:";s:8:"🇦🇶";s:17:":antigua_barbuda:";s:8:"🇦🇬";s:7:":apple:";s:4:"🍎";s:10:":aquarius:";s:6:"♒️";s:11:":argentina:";s:8:"🇦🇷";s:7:":aries:";s:6:"♈️";s:9:":armenia:";s:8:"🇦🇲";s:16:":arrow_backward:";s:6:"◀️";s:19:":arrow_double_down:";s:3:"⏬";s:17:":arrow_double_up:";s:3:"⏫";s:12:":arrow_down:";s:6:"⬇️";s:18:":arrow_down_small:";s:4:"🔽";s:15:":arrow_forward:";s:6:"▶️";s:20:":arrow_heading_down:";s:6:"⤵️";s:18:":arrow_heading_up:";s:6:"⤴️";s:12:":arrow_left:";s:6:"⬅️";s:18:":arrow_lower_left:";s:6:"↙️";s:19:":arrow_lower_right:";s:6:"↘️";s:13:":arrow_right:";s:6:"➡️";s:18:":arrow_right_hook:";s:6:"↪️";s:10:":arrow_up:";s:6:"⬆️";s:15:":arrow_up_down:";s:6:"↕️";s:16:":arrow_up_small:";s:4:"🔼";s:18:":arrow_upper_left:";s:6:"↖️";s:19:":arrow_upper_right:";s:6:"↗️";s:18:":arrows_clockwise:";s:4:"🔃";s:25:":arrows_counterclockwise:";s:4:"🔄";s:5:":art:";s:4:"🎨";s:19:":articulated_lorry:";s:4:"🚛";s:22:":artificial_satellite:";s:4:"🛰";s:7:":aruba:";s:8:"🇦🇼";s:10:":asterisk:";s:4:"*⃣";s:17:":asterisk_symbol:";s:1:"*";s:12:":astonished:";s:4:"😲";s:15:":athletic_shoe:";s:4:"👟";s:5:":atm:";s:4:"🏧";s:6:":atom:";s:6:"⚛️";s:13:":atom_symbol:";s:6:"⚛️";s:11:":australia:";s:8:"🇦🇺";s:9:":austria:";s:8:"🇦🇹";s:9:":avocado:";s:4:"🥑";s:12:":azerbaijan:";s:8:"🇦🇿";s:3:":b:";s:7:"🅱️";s:6:":baby:";s:4:"👶";s:13:":baby_bottle:";s:4:"🍼";s:12:":baby_chick:";s:4:"🐤";s:13:":baby_symbol:";s:4:"🚼";s:12:":baby_tone1:";s:8:"👶🏻";s:12:":baby_tone2:";s:8:"👶🏼";s:12:":baby_tone3:";s:8:"👶🏽";s:12:":baby_tone4:";s:8:"👶🏾";s:12:":baby_tone5:";s:8:"👶🏿";s:6:":back:";s:4:"🔙";s:7:":bacon:";s:4:"🥓";s:11:":badminton:";s:4:"🏸";s:15:":baggage_claim:";s:4:"🛄";s:16:":baguette_bread:";s:4:"🥖";s:9:":bahamas:";s:8:"🇧🇸";s:9:":bahrain:";s:8:"🇧🇭";s:15:":balance_scale:";s:6:"⚖️";s:9:":balloon:";s:4:"🎈";s:12:":ballot_box:";s:4:"🗳";s:23:":ballot_box_with_check:";s:6:"☑️";s:8:":bamboo:";s:4:"🎍";s:8:":banana:";s:4:"🍌";s:10:":bangbang:";s:6:"‼️";s:12:":bangladesh:";s:8:"🇧🇩";s:6:":bank:";s:4:"🏦";s:11:":bar_chart:";s:4:"📊";s:10:":barbados:";s:8:"🇧🇧";s:8:":barber:";s:4:"💈";s:10:":baseball:";s:6:"⚾️";s:12:":basketball:";s:4:"🏀";s:16:":basketball_man:";s:3:"⛹";s:18:":basketball_woman:";s:15:"⛹️‍♀️";s:5:":bat:";s:4:"🦇";s:6:":bath:";s:4:"🛀";s:12:":bath_tone1:";s:8:"🛀🏻";s:12:":bath_tone2:";s:8:"🛀🏼";s:12:":bath_tone3:";s:8:"🛀🏽";s:12:":bath_tone4:";s:8:"🛀🏾";s:12:":bath_tone5:";s:8:"🛀🏿";s:9:":bathtub:";s:4:"🛁";s:9:":battery:";s:4:"🔋";s:7:":beach:";s:7:"🏖️";s:16:":beach_umbrella:";s:4:"🏖";s:6:":bear:";s:4:"🐻";s:16:":bearded_person:";s:8:"🧔🏿";s:22:":bearded_person_tone1:";s:8:"🧔🏻";s:22:":bearded_person_tone2:";s:8:"🧔🏼";s:22:":bearded_person_tone3:";s:8:"🧔🏽";s:22:":bearded_person_tone4:";s:8:"🧔🏾";s:22:":bearded_person_tone5:";s:8:"🧔🏿";s:5:":bed:";s:4:"🛏";s:5:":bee:";s:4:"🐝";s:6:":beer:";s:4:"🍺";s:7:":beers:";s:4:"🍻";s:8:":beetle:";s:4:"🐞";s:10:":beginner:";s:4:"🔰";s:9:":belarus:";s:8:"🇧🇾";s:9:":belgium:";s:8:"🇧🇪";s:8:":belize:";s:8:"🇧🇿";s:6:":bell:";s:4:"🔔";s:9:":bellhop:";s:7:"🛎️";s:14:":bellhop_bell:";s:4:"🛎";s:7:":benin:";s:8:"🇧🇯";s:7:":bento:";s:4:"🍱";s:9:":bermuda:";s:8:"🇧🇲";s:8:":bhutan:";s:8:"🇧🇹";s:11:":bicyclist:";s:4:"🚴";s:6:":bike:";s:4:"🚲";s:12:":biking_man:";s:4:"🚴";s:14:":biking_woman:";s:13:"🚴‍♀️";s:8:":bikini:";s:4:"👙";s:12:":billed_cap:";s:4:"🧢";s:11:":biohazard:";s:6:"☣️";s:6:":bird:";s:4:"🐦";s:10:":birthday:";s:4:"🎂";s:14:":black_circle:";s:6:"⚫️";s:12:":black_flag:";s:4:"🏴";s:13:":black_heart:";s:4:"🖤";s:13:":black_joker:";s:4:"🃏";s:20:":black_large_square:";s:6:"⬛️";s:27:":black_medium_small_square:";s:6:"◾️";s:21:":black_medium_square:";s:6:"◼️";s:11:":black_nib:";s:6:"✒️";s:20:":black_small_square:";s:6:"▪️";s:21:":black_square_button:";s:4:"🔲";s:18:":blond-haired_man:";s:13:"👱‍♂️";s:24:":blond-haired_man_tone1:";s:17:"👱🏻‍♂️";s:24:":blond-haired_man_tone2:";s:17:"👱🏼‍♂️";s:24:":blond-haired_man_tone3:";s:17:"👱🏽‍♂️";s:24:":blond-haired_man_tone4:";s:17:"👱🏾‍♂️";s:24:":blond-haired_man_tone5:";s:17:"👱🏿‍♂️";s:20:":blond-haired_woman:";s:13:"👱‍♀️";s:26:":blond-haired_woman_tone1:";s:17:"👱🏻‍♀️";s:26:":blond-haired_woman_tone2:";s:17:"👱🏼‍♀️";s:26:":blond-haired_woman_tone3:";s:17:"👱🏽‍♀️";s:26:":blond-haired_woman_tone4:";s:17:"👱🏾‍♀️";s:26:":blond-haired_woman_tone5:";s:17:"👱🏿‍♀️";s:21:":blond_haired_person:";s:4:"👱";s:27:":blond_haired_person_tone1:";s:8:"👱🏻";s:27:":blond_haired_person_tone2:";s:8:"👱🏼";s:27:":blond_haired_person_tone3:";s:8:"👱🏽";s:27:":blond_haired_person_tone4:";s:8:"👱🏾";s:27:":blond_haired_person_tone5:";s:8:"👱🏿";s:12:":blonde_man:";s:4:"👱";s:14:":blonde_woman:";s:13:"👱‍♀️";s:9:":blossom:";s:4:"🌼";s:10:":blowfish:";s:4:"🐡";s:11:":blue_book:";s:4:"📘";s:10:":blue_car:";s:4:"🚙";s:13:":blue_circle:";s:4:"🔵";s:12:":blue_heart:";s:4:"💙";s:7:":blush:";s:4:"😊";s:6:":boar:";s:4:"🐗";s:6:":boat:";s:6:"⛵️";s:9:":bolivia:";s:8:"🇧🇴";s:6:":bomb:";s:4:"💣";s:6:":book:";s:4:"📖";s:10:":bookmark:";s:4:"🔖";s:15:":bookmark_tabs:";s:4:"📑";s:7:":books:";s:4:"📚";s:6:":boom:";s:4:"💥";s:6:":boot:";s:4:"👢";s:20:":bosnia_herzegovina:";s:8:"🇧🇦";s:10:":botswana:";s:8:"🇧🇼";s:9:":bouquet:";s:4:"💐";s:5:":bow:";s:4:"🙇";s:15:":bow_and_arrow:";s:4:"🏹";s:12:":bowing_man:";s:4:"🙇";s:14:":bowing_woman:";s:13:"🙇‍♀️";s:17:":bowl_with_spoon:";s:4:"🥣";s:9:":bowling:";s:4:"🎳";s:14:":boxing_glove:";s:4:"🥊";s:5:":boy:";s:4:"👦";s:11:":boy_tone1:";s:8:"👦🏻";s:11:":boy_tone2:";s:8:"👦🏼";s:11:":boy_tone3:";s:8:"👦🏽";s:11:":boy_tone4:";s:8:"👦🏾";s:11:":boy_tone5:";s:8:"👦🏿";s:7:":brain:";s:4:"🧠";s:8:":brazil:";s:8:"🇧🇷";s:7:":bread:";s:4:"🍞";s:16:":breast_feeding:";s:4:"🤱";s:22:":breast_feeding_tone1:";s:8:"🤱🏻";s:22:":breast_feeding_tone2:";s:8:"🤱🏼";s:22:":breast_feeding_tone3:";s:8:"🤱🏽";s:22:":breast_feeding_tone4:";s:8:"🤱🏾";s:22:":breast_feeding_tone5:";s:8:"🤱🏿";s:17:":bride_with_veil:";s:4:"👰";s:23:":bride_with_veil_tone1:";s:8:"👰🏻";s:23:":bride_with_veil_tone2:";s:8:"👰🏼";s:23:":bride_with_veil_tone3:";s:8:"👰🏽";s:23:":bride_with_veil_tone4:";s:8:"👰🏾";s:23:":bride_with_veil_tone5:";s:8:"👰🏿";s:17:":bridge_at_night:";s:4:"🌉";s:11:":briefcase:";s:4:"💼";s:32:":british_indian_ocean_territory:";s:8:"🇮🇴";s:24:":british_virgin_islands:";s:8:"🇻🇬";s:10:":broccoli:";s:4:"🥦";s:14:":broken_heart:";s:4:"💔";s:8:":brunei:";s:8:"🇧🇳";s:5:":bug:";s:4:"🐛";s:23:":building_construction:";s:4:"🏗";s:6:":bulb:";s:4:"💡";s:10:":bulgaria:";s:8:"🇧🇬";s:19:":bullettrain_front:";s:4:"🚅";s:18:":bullettrain_side:";s:4:"🚄";s:14:":burkina_faso:";s:8:"🇧🇫";s:9:":burrito:";s:4:"🌯";s:9:":burundi:";s:8:"🇧🇮";s:5:":bus:";s:4:"🚌";s:26:":business_suit_levitating:";s:4:"🕴";s:9:":busstop:";s:4:"🚏";s:20:":bust_in_silhouette:";s:4:"👤";s:21:":busts_in_silhouette:";s:4:"👥";s:11:":butterfly:";s:4:"🦋";s:8:":cactus:";s:4:"🌵";s:6:":cake:";s:4:"🍰";s:10:":calendar:";s:4:"📆";s:17:":calendar_spiral:";s:7:"🗓️";s:9:":call_me:";s:4:"🤙";s:14:":call_me_hand:";s:4:"🤙";s:15:":call_me_tone1:";s:8:"🤙🏻";s:15:":call_me_tone2:";s:8:"🤙🏼";s:15:":call_me_tone3:";s:8:"🤙🏽";s:15:":call_me_tone4:";s:8:"🤙🏾";s:15:":call_me_tone5:";s:8:"🤙🏿";s:9:":calling:";s:4:"📲";s:10:":cambodia:";s:8:"🇰🇭";s:7:":camel:";s:4:"🐫";s:8:":camera:";s:4:"📷";s:14:":camera_flash:";s:4:"📸";s:19:":camera_with_flash:";s:4:"📸";s:10:":cameroon:";s:8:"🇨🇲";s:9:":camping:";s:4:"🏕";s:8:":canada:";s:8:"🇨🇦";s:16:":canary_islands:";s:8:"🇮🇨";s:8:":cancer:";s:6:"♋️";s:8:":candle:";s:4:"🕯";s:7:":candy:";s:4:"🍬";s:13:":canned_food:";s:4:"🥫";s:7:":canoe:";s:4:"🛶";s:12:":cape_verde:";s:8:"🇨🇻";s:14:":capital_abcd:";s:4:"🔠";s:11:":capricorn:";s:6:"♑️";s:5:":car:";s:4:"🚗";s:10:":card_box:";s:7:"🗃️";s:15:":card_file_box:";s:4:"🗃";s:12:":card_index:";s:4:"📇";s:21:":card_index_dividers:";s:4:"🗂";s:23:":caribbean_netherlands:";s:8:"🇧🇶";s:16:":carousel_horse:";s:4:"🎠";s:8:":carrot:";s:4:"🥕";s:5:":cat:";s:4:"🐱";s:6:":cat2:";s:4:"🐈";s:16:":cayman_islands:";s:8:"🇰🇾";s:4:":cd:";s:4:"💿";s:26:":central_african_republic:";s:8:"🇨🇫";s:6:":chad:";s:8:"🇹🇩";s:8:":chains:";s:3:"⛓";s:11:":champagne:";s:4:"🍾";s:17:":champagne_glass:";s:4:"🥂";s:7:":chart:";s:4:"💹";s:28:":chart_with_downwards_trend:";s:4:"📉";s:26:":chart_with_upwards_trend:";s:4:"📈";s:16:":checkered_flag:";s:4:"🏁";s:8:":cheese:";s:4:"🧀";s:10:":cherries:";s:4:"🍒";s:16:":cherry_blossom:";s:4:"🌸";s:10:":chestnut:";s:4:"🌰";s:9:":chicken:";s:4:"🐔";s:7:":child:";s:8:"🧒🏿";s:13:":child_tone1:";s:8:"🧒🏻";s:13:":child_tone2:";s:8:"🧒🏼";s:13:":child_tone3:";s:8:"🧒🏽";s:13:":child_tone4:";s:8:"🧒🏾";s:13:":child_tone5:";s:8:"🧒🏿";s:19:":children_crossing:";s:4:"🚸";s:7:":chile:";s:8:"🇨🇱";s:10:":chipmunk:";s:4:"🐿";s:15:":chocolate_bar:";s:4:"🍫";s:12:":chopsticks:";s:4:"🥢";s:18:":christmas_island:";s:8:"🇨🇽";s:16:":christmas_tree:";s:4:"🎄";s:8:":church:";s:6:"⛪️";s:8:":cinema:";s:4:"🎦";s:13:":circus_tent:";s:4:"🎪";s:11:":city_dusk:";s:4:"🌆";s:14:":city_sunrise:";s:4:"🌇";s:13:":city_sunset:";s:4:"🌆";s:11:":cityscape:";s:4:"🏙";s:4:":cl:";s:4:"🆑";s:7:":clamp:";s:4:"🗜";s:6:":clap:";s:4:"👏";s:12:":clap_tone1:";s:8:"👏🏻";s:12:":clap_tone2:";s:8:"👏🏼";s:12:":clap_tone3:";s:8:"👏🏽";s:12:":clap_tone4:";s:8:"👏🏾";s:12:":clap_tone5:";s:8:"👏🏿";s:9:":clapper:";s:4:"🎬";s:20:":classical_building:";s:4:"🏛";s:18:":clinking_glasses:";s:4:"🥂";s:11:":clipboard:";s:4:"📋";s:7:":clock:";s:7:"🕰️";s:8:":clock1:";s:4:"🕐";s:9:":clock10:";s:4:"🕙";s:11:":clock1030:";s:4:"🕥";s:9:":clock11:";s:4:"🕚";s:11:":clock1130:";s:4:"🕦";s:9:":clock12:";s:4:"🕛";s:11:":clock1230:";s:4:"🕧";s:10:":clock130:";s:4:"🕜";s:8:":clock2:";s:4:"🕑";s:10:":clock230:";s:4:"🕝";s:8:":clock3:";s:4:"🕒";s:10:":clock330:";s:4:"🕞";s:8:":clock4:";s:4:"🕓";s:10:":clock430:";s:4:"🕟";s:8:":clock5:";s:4:"🕔";s:10:":clock530:";s:4:"🕠";s:8:":clock6:";s:4:"🕕";s:10:":clock630:";s:4:"🕡";s:8:":clock7:";s:4:"🕖";s:10:":clock730:";s:4:"🕢";s:8:":clock8:";s:4:"🕗";s:10:":clock830:";s:4:"🕣";s:8:":clock9:";s:4:"🕘";s:10:":clock930:";s:4:"🕤";s:13:":closed_book:";s:4:"📕";s:22:":closed_lock_with_key:";s:4:"🔐";s:17:":closed_umbrella:";s:4:"🌂";s:7:":cloud:";s:6:"☁️";s:17:":cloud_lightning:";s:7:"🌩️";s:12:":cloud_rain:";s:7:"🌧️";s:12:":cloud_snow:";s:7:"🌨️";s:15:":cloud_tornado:";s:7:"🌪️";s:22:":cloud_with_lightning:";s:4:"🌩";s:31:":cloud_with_lightning_and_rain:";s:3:"⛈";s:17:":cloud_with_rain:";s:4:"🌧";s:17:":cloud_with_snow:";s:4:"🌨";s:7:":clown:";s:4:"🤡";s:12:":clown_face:";s:4:"🤡";s:7:":clubs:";s:6:"♣️";s:4:":cn:";s:8:"🇨🇳";s:6:":coat:";s:4:"🧥";s:10:":cocktail:";s:4:"🍸";s:9:":coconut:";s:4:"🥥";s:15:":cocos_islands:";s:8:"🇨🇨";s:8:":coffee:";s:6:"☕️";s:8:":coffin:";s:6:"⚰️";s:12:":cold_sweat:";s:4:"😰";s:11:":collision:";s:4:"💥";s:10:":colombia:";s:8:"🇨🇴";s:7:":comet:";s:3:"☄";s:9:":comoros:";s:8:"🇰🇲";s:13:":compression:";s:7:"🗜️";s:10:":computer:";s:4:"💻";s:16:":computer_mouse:";s:4:"🖱";s:15:":confetti_ball:";s:4:"🎊";s:12:":confounded:";s:4:"😖";s:10:":confused:";s:4:"😕";s:19:":congo_brazzaville:";s:8:"🇨🇬";s:16:":congo_kinshasa:";s:8:"🇨🇩";s:17:":congratulations:";s:6:"㊗️";s:14:":construction:";s:4:"🚧";s:19:":construction_site:";s:7:"🏗️";s:21:":construction_worker:";s:4:"👷";s:25:":construction_worker_man:";s:4:"👷";s:27:":construction_worker_tone1:";s:8:"👷🏻";s:27:":construction_worker_tone2:";s:8:"👷🏼";s:27:":construction_worker_tone3:";s:8:"👷🏽";s:27:":construction_worker_tone4:";s:8:"👷🏾";s:27:":construction_worker_tone5:";s:8:"👷🏿";s:27:":construction_worker_woman:";s:13:"👷‍♀️";s:15:":control_knobs:";s:4:"🎛";s:19:":convenience_store:";s:4:"🏪";s:14:":cook_islands:";s:8:"🇨🇰";s:8:":cookie:";s:4:"🍪";s:9:":cooking:";s:4:"🍳";s:6:":cool:";s:4:"🆒";s:5:":cop:";s:4:"👮";s:11:":copyright:";s:5:"©️";s:6:":corn:";s:4:"🌽";s:12:":costa_rica:";s:8:"🇨🇷";s:14:":cote_divoire:";s:8:"🇨🇮";s:7:":couch:";s:7:"🛋️";s:16:":couch_and_lamp:";s:4:"🛋";s:8:":couple:";s:4:"👫";s:11:":couple_mm:";s:20:"👨‍❤️‍👨";s:19:":couple_with_heart:";s:4:"💑";s:27:":couple_with_heart_man_man:";s:20:"👨‍❤️‍👨";s:29:":couple_with_heart_woman_man:";s:4:"💑";s:31:":couple_with_heart_woman_woman:";s:20:"👩‍❤️‍👩";s:11:":couple_ww:";s:20:"👩‍❤️‍👩";s:12:":couplekiss:";s:4:"💏";s:20:":couplekiss_man_man:";s:27:"👨‍❤️‍💋‍👨";s:22:":couplekiss_man_woman:";s:4:"💏";s:24:":couplekiss_woman_woman:";s:27:"👩‍❤️‍💋‍👩";s:5:":cow:";s:4:"🐮";s:6:":cow2:";s:4:"🐄";s:8:":cowboy:";s:4:"🤠";s:17:":cowboy_hat_face:";s:4:"🤠";s:6:":crab:";s:4:"🦀";s:8:":crayon:";s:4:"🖍";s:12:":crazy_face:";s:4:"🤪";s:13:":credit_card:";s:4:"💳";s:15:":crescent_moon:";s:4:"🌙";s:9:":cricket:";s:4:"🏏";s:14:":cricket_game:";s:4:"🏏";s:9:":croatia:";s:8:"🇭🇷";s:11:":crocodile:";s:4:"🐊";s:11:":croissant:";s:4:"🥐";s:7:":cross:";s:6:"✝️";s:17:":crossed_fingers:";s:4:"🤞";s:15:":crossed_flags:";s:4:"🎌";s:16:":crossed_swords:";s:6:"⚔️";s:7:":crown:";s:4:"👑";s:13:":cruise_ship:";s:7:"🛳️";s:5:":cry:";s:4:"😢";s:17:":crying_cat_face:";s:4:"😿";s:14:":crystal_ball:";s:4:"🔮";s:6:":cuba:";s:8:"🇨🇺";s:10:":cucumber:";s:4:"🥒";s:16:":cup_with_straw:";s:4:"🥤";s:7:":cupid:";s:4:"💘";s:9:":curacao:";s:8:"🇨🇼";s:15:":curling_stone:";s:4:"🥌";s:12:":curly_loop:";s:3:"➰";s:19:":currency_exchange:";s:4:"💱";s:7:":curry:";s:4:"🍛";s:9:":custard:";s:4:"🍮";s:9:":customs:";s:4:"🛃";s:13:":cut_of_meat:";s:4:"🥩";s:9:":cyclone:";s:4:"🌀";s:8:":cyprus:";s:8:"🇨🇾";s:16:":czech_republic:";s:8:"🇨🇿";s:8:":dagger:";s:4:"🗡";s:8:":dancer:";s:4:"💃";s:14:":dancer_tone1:";s:8:"💃🏻";s:14:":dancer_tone2:";s:8:"💃🏼";s:14:":dancer_tone3:";s:8:"💃🏽";s:14:":dancer_tone4:";s:8:"💃🏾";s:14:":dancer_tone5:";s:8:"💃🏿";s:9:":dancers:";s:4:"👯";s:13:":dancing_men:";s:13:"👯‍♂️";s:15:":dancing_women:";s:4:"👯";s:7:":dango:";s:4:"🍡";s:17:":dark_sunglasses:";s:4:"🕶";s:6:":dart:";s:4:"🎯";s:6:":dash:";s:4:"💨";s:6:":date:";s:4:"📅";s:4:":de:";s:8:"🇩🇪";s:16:":deciduous_tree:";s:4:"🌳";s:6:":deer:";s:4:"🦌";s:9:":denmark:";s:8:"🇩🇰";s:18:":department_store:";s:4:"🏬";s:16:":derelict_house:";s:4:"🏚";s:8:":desert:";s:4:"🏜";s:15:":desert_island:";s:4:"🏝";s:9:":desktop:";s:7:"🖥️";s:18:":desktop_computer:";s:4:"🖥";s:11:":detective:";s:4:"🕵";s:17:":detective_tone1:";s:8:"🕵🏻";s:17:":detective_tone2:";s:8:"🕵🏼";s:17:":detective_tone3:";s:8:"🕵🏽";s:17:":detective_tone4:";s:8:"🕵🏾";s:17:":detective_tone5:";s:8:"🕵🏿";s:33:":diamond_shape_with_a_dot_inside:";s:4:"💠";s:10:":diamonds:";s:6:"♦️";s:13:":digit_eight:";s:1:"8";s:12:":digit_five:";s:1:"5";s:12:":digit_four:";s:1:"4";s:12:":digit_nine:";s:1:"9";s:11:":digit_one:";s:1:"1";s:13:":digit_seven:";s:1:"7";s:11:":digit_six:";s:1:"6";s:13:":digit_three:";s:1:"3";s:11:":digit_two:";s:1:"2";s:12:":digit_zero:";s:1:"0";s:14:":disappointed:";s:4:"😞";s:23:":disappointed_relieved:";s:4:"😥";s:10:":dividers:";s:7:"🗂️";s:7:":dizzy:";s:4:"💫";s:12:":dizzy_face:";s:4:"😵";s:10:":djibouti:";s:8:"🇩🇯";s:15:":do_not_litter:";s:4:"🚯";s:5:":dog:";s:4:"🐶";s:6:":dog2:";s:4:"🐕";s:8:":dollar:";s:4:"💵";s:7:":dolls:";s:4:"🎎";s:9:":dolphin:";s:4:"🐬";s:10:":dominica:";s:8:"🇩🇲";s:20:":dominican_republic:";s:8:"🇩🇴";s:6:":door:";s:4:"🚪";s:10:":doughnut:";s:4:"🍩";s:6:":dove:";s:4:"🕊";s:8:":dragon:";s:4:"🐉";s:13:":dragon_face:";s:4:"🐲";s:7:":dress:";s:4:"👗";s:17:":dromedary_camel:";s:4:"🐪";s:15:":drooling_face:";s:4:"🤤";s:9:":droplet:";s:4:"💧";s:6:":drum:";s:4:"🥁";s:6:":duck:";s:4:"🦆";s:10:":dumpling:";s:4:"🥟";s:5:":dvd:";s:4:"📀";s:8:":e-mail:";s:4:"📧";s:7:":eagle:";s:4:"🦅";s:5:":ear:";s:4:"👂";s:13:":ear_of_rice:";s:4:"🌾";s:11:":ear_tone1:";s:8:"👂🏻";s:11:":ear_tone2:";s:8:"👂🏼";s:11:":ear_tone3:";s:8:"👂🏽";s:11:":ear_tone4:";s:8:"👂🏾";s:11:":ear_tone5:";s:8:"👂🏿";s:14:":earth_africa:";s:4:"🌍";s:16:":earth_americas:";s:4:"🌎";s:12:":earth_asia:";s:4:"🌏";s:9:":ecuador:";s:8:"🇪🇨";s:5:":egg:";s:4:"🥚";s:10:":eggplant:";s:4:"🍆";s:7:":egypt:";s:8:"🇪🇬";s:7:":eight:";s:4:"8⃣";s:26:":eight_pointed_black_star:";s:6:"✴️";s:23:":eight_spoked_asterisk:";s:6:"✳️";s:7:":eject:";s:6:"⏏️";s:13:":el_salvador:";s:8:"🇸🇻";s:15:":electric_plug:";s:4:"🔌";s:10:":elephant:";s:4:"🐘";s:5:":elf:";s:8:"🧝🏿";s:11:":elf_tone1:";s:8:"🧝🏻";s:11:":elf_tone2:";s:8:"🧝🏼";s:11:":elf_tone3:";s:8:"🧝🏽";s:11:":elf_tone4:";s:8:"🧝🏾";s:11:":elf_tone5:";s:8:"🧝🏿";s:7:":email:";s:6:"✉️";s:5:":end:";s:4:"🔚";s:9:":england:";s:28:"🏴󠁧󠁢󠁥󠁮󠁧󠁿";s:10:":envelope:";s:6:"✉️";s:21:":envelope_with_arrow:";s:4:"📩";s:19:":equatorial_guinea:";s:8:"🇬🇶";s:9:":eritrea:";s:8:"🇪🇷";s:4:":es:";s:8:"🇪🇸";s:9:":estonia:";s:8:"🇪🇪";s:10:":ethiopia:";s:8:"🇪🇹";s:4:":eu:";s:8:"🇪🇺";s:6:":euro:";s:4:"💶";s:17:":european_castle:";s:4:"🏰";s:22:":european_post_office:";s:4:"🏤";s:16:":european_union:";s:8:"🇪🇺";s:16:":evergreen_tree:";s:4:"🌲";s:13:":exclamation:";s:6:"❗️";s:16:":exploding_head:";s:4:"🤯";s:16:":expressionless:";s:4:"😑";s:5:":eye:";s:4:"👁";s:22:":eye_in_speech_bubble:";s:11:"👁‍🗨";s:19:":eye_speech_bubble:";s:11:"👁‍🗨";s:12:":eyeglasses:";s:4:"👓";s:6:":eyes:";s:4:"👀";s:15:":face_vomiting:";s:4:"🤮";s:27:":face_with_hand_over_mouth:";s:4:"🤭";s:24:":face_with_head_bandage:";s:4:"🤕";s:19:":face_with_monocle:";s:4:"🧐";s:26:":face_with_raised_eyebrow:";s:4:"🤨";s:30:":face_with_symbols_over_mouth:";s:4:"🤬";s:23:":face_with_thermometer:";s:4:"🤒";s:11:":facepunch:";s:4:"👊";s:9:":factory:";s:4:"🏭";s:7:":fairy:";s:8:"🧚🏿";s:13:":fairy_tone1:";s:8:"🧚🏻";s:13:":fairy_tone2:";s:8:"🧚🏼";s:13:":fairy_tone3:";s:8:"🧚🏽";s:13:":fairy_tone4:";s:8:"🧚🏾";s:13:":fairy_tone5:";s:8:"🧚🏿";s:18:":falkland_islands:";s:8:"🇫🇰";s:13:":fallen_leaf:";s:4:"🍂";s:8:":family:";s:4:"👪";s:16:":family_man_boy:";s:11:"👨‍👦";s:20:":family_man_boy_boy:";s:18:"👨‍👦‍👦";s:17:":family_man_girl:";s:11:"👨‍👧";s:21:":family_man_girl_boy:";s:18:"👨‍👧‍👦";s:22:":family_man_girl_girl:";s:18:"👨‍👧‍👧";s:20:":family_man_man_boy:";s:18:"👨‍👨‍👦";s:24:":family_man_man_boy_boy:";s:25:"👨‍👨‍👦‍👦";s:21:":family_man_man_girl:";s:18:"👨‍👨‍👧";s:25:":family_man_man_girl_boy:";s:25:"👨‍👨‍👧‍👦";s:26:":family_man_man_girl_girl:";s:25:"👨‍👨‍👧‍👧";s:22:":family_man_woman_boy:";s:4:"👪";s:26:":family_man_woman_boy_boy:";s:25:"👨‍👩‍👦‍👦";s:23:":family_man_woman_girl:";s:18:"👨‍👩‍👧";s:27:":family_man_woman_girl_boy:";s:25:"👨‍👩‍👧‍👦";s:28:":family_man_woman_girl_girl:";s:25:"👨‍👩‍👧‍👧";s:12:":family_mmb:";s:18:"👨‍👨‍👦";s:13:":family_mmbb:";s:25:"👨‍👨‍👦‍👦";s:12:":family_mmg:";s:18:"👨‍👨‍👧";s:13:":family_mmgb:";s:25:"👨‍👨‍👧‍👦";s:13:":family_mmgg:";s:25:"👨‍👨‍👧‍👧";s:13:":family_mwbb:";s:25:"👨‍👩‍👦‍👦";s:12:":family_mwg:";s:18:"👨‍👩‍👧";s:13:":family_mwgb:";s:25:"👨‍👩‍👧‍👦";s:13:":family_mwgg:";s:25:"👨‍👩‍👧‍👧";s:18:":family_woman_boy:";s:11:"👩‍👦";s:22:":family_woman_boy_boy:";s:18:"👩‍👦‍👦";s:19:":family_woman_girl:";s:11:"👩‍👧";s:23:":family_woman_girl_boy:";s:18:"👩‍👧‍👦";s:24:":family_woman_girl_girl:";s:18:"👩‍👧‍👧";s:24:":family_woman_woman_boy:";s:18:"👩‍👩‍👦";s:28:":family_woman_woman_boy_boy:";s:25:"👩‍👩‍👦‍👦";s:25:":family_woman_woman_girl:";s:18:"👩‍👩‍👧";s:29:":family_woman_woman_girl_boy:";s:25:"👩‍👩‍👧‍👦";s:30:":family_woman_woman_girl_girl:";s:25:"👩‍👩‍👧‍👧";s:12:":family_wwb:";s:18:"👩‍👩‍👦";s:13:":family_wwbb:";s:25:"👩‍👩‍👦‍👦";s:12:":family_wwg:";s:18:"👩‍👩‍👧";s:13:":family_wwgb:";s:25:"👩‍👩‍👧‍👦";s:13:":family_wwgg:";s:25:"👩‍👩‍👧‍👧";s:15:":faroe_islands:";s:8:"🇫🇴";s:14:":fast_forward:";s:3:"⏩";s:5:":fax:";s:4:"📠";s:9:":fearful:";s:4:"😨";s:6:":feet:";s:4:"🐾";s:18:":female_detective:";s:16:"🕵️‍♀️";s:13:":female_sign:";s:6:"♀️";s:14:":ferris_wheel:";s:4:"🎡";s:7:":ferry:";s:3:"⛴";s:14:":field_hockey:";s:4:"🏑";s:6:":fiji:";s:8:"🇫🇯";s:14:":file_cabinet:";s:4:"🗄";s:13:":file_folder:";s:4:"📁";s:13:":film_frames:";s:7:"🎞️";s:16:":film_projector:";s:4:"📽";s:12:":film_strip:";s:4:"🎞";s:17:":fingers_crossed:";s:4:"🤞";s:23:":fingers_crossed_tone1:";s:8:"🤞🏻";s:23:":fingers_crossed_tone2:";s:8:"🤞🏼";s:23:":fingers_crossed_tone3:";s:8:"🤞🏽";s:23:":fingers_crossed_tone4:";s:8:"🤞🏾";s:23:":fingers_crossed_tone5:";s:8:"🤞🏿";s:9:":finland:";s:8:"🇫🇮";s:6:":fire:";s:4:"🔥";s:13:":fire_engine:";s:4:"🚒";s:11:":fireworks:";s:4:"🎆";s:13:":first_place:";s:4:"🥇";s:20:":first_quarter_moon:";s:4:"🌓";s:30:":first_quarter_moon_with_face:";s:4:"🌛";s:6:":fish:";s:4:"🐟";s:11:":fish_cake:";s:4:"🍥";s:23:":fishing_pole_and_fish:";s:4:"🎣";s:6:":fist:";s:3:"✊";s:11:":fist_left:";s:4:"🤛";s:15:":fist_oncoming:";s:4:"👊";s:13:":fist_raised:";s:3:"✊";s:12:":fist_right:";s:4:"🤜";s:12:":fist_tone1:";s:7:"✊🏻";s:12:":fist_tone2:";s:7:"✊🏼";s:12:":fist_tone3:";s:7:"✊🏽";s:12:":fist_tone4:";s:7:"✊🏾";s:12:":fist_tone5:";s:7:"✊🏿";s:6:":five:";s:4:"5⃣";s:9:":flag_ac:";s:8:"🇦🇨";s:9:":flag_ad:";s:8:"🇦🇩";s:9:":flag_ae:";s:8:"🇦🇪";s:9:":flag_af:";s:8:"🇦🇫";s:9:":flag_ag:";s:8:"🇦🇬";s:9:":flag_ai:";s:8:"🇦🇮";s:9:":flag_al:";s:8:"🇦🇱";s:9:":flag_am:";s:8:"🇦🇲";s:9:":flag_ao:";s:8:"🇦🇴";s:9:":flag_aq:";s:8:"🇦🇶";s:9:":flag_ar:";s:8:"🇦🇷";s:9:":flag_as:";s:8:"🇦🇸";s:9:":flag_at:";s:8:"🇦🇹";s:9:":flag_au:";s:8:"🇦🇺";s:9:":flag_aw:";s:8:"🇦🇼";s:9:":flag_ax:";s:8:"🇦🇽";s:9:":flag_az:";s:8:"🇦🇿";s:9:":flag_ba:";s:8:"🇧🇦";s:9:":flag_bb:";s:8:"🇧🇧";s:9:":flag_bd:";s:8:"🇧🇩";s:9:":flag_be:";s:8:"🇧🇪";s:9:":flag_bf:";s:8:"🇧🇫";s:9:":flag_bg:";s:8:"🇧🇬";s:9:":flag_bh:";s:8:"🇧🇭";s:9:":flag_bi:";s:8:"🇧🇮";s:9:":flag_bj:";s:8:"🇧🇯";s:9:":flag_bl:";s:8:"🇧🇱";s:12:":flag_black:";s:4:"🏴";s:9:":flag_bm:";s:8:"🇧🇲";s:9:":flag_bn:";s:8:"🇧🇳";s:9:":flag_bo:";s:8:"🇧🇴";s:9:":flag_bq:";s:8:"🇧🇶";s:9:":flag_br:";s:8:"🇧🇷";s:9:":flag_bs:";s:8:"🇧🇸";s:9:":flag_bt:";s:8:"🇧🇹";s:9:":flag_bv:";s:8:"🇧🇻";s:9:":flag_bw:";s:8:"🇧🇼";s:9:":flag_by:";s:8:"🇧🇾";s:9:":flag_bz:";s:8:"🇧🇿";s:9:":flag_ca:";s:8:"🇨🇦";s:9:":flag_cc:";s:8:"🇨🇨";s:9:":flag_cd:";s:8:"🇨🇩";s:9:":flag_cf:";s:8:"🇨🇫";s:9:":flag_cg:";s:8:"🇨🇬";s:9:":flag_ch:";s:8:"🇨🇭";s:9:":flag_ci:";s:8:"🇨🇮";s:9:":flag_ck:";s:8:"🇨🇰";s:9:":flag_cl:";s:8:"🇨🇱";s:9:":flag_cm:";s:8:"🇨🇲";s:9:":flag_cn:";s:8:"🇨🇳";s:9:":flag_co:";s:8:"🇨🇴";s:9:":flag_cp:";s:8:"🇨🇵";s:9:":flag_cr:";s:8:"🇨🇷";s:9:":flag_cu:";s:8:"🇨🇺";s:9:":flag_cv:";s:8:"🇨🇻";s:9:":flag_cw:";s:8:"🇨🇼";s:9:":flag_cx:";s:8:"🇨🇽";s:9:":flag_cy:";s:8:"🇨🇾";s:9:":flag_cz:";s:8:"🇨🇿";s:9:":flag_de:";s:8:"🇩🇪";s:9:":flag_dg:";s:8:"🇩🇬";s:9:":flag_dj:";s:8:"🇩🇯";s:9:":flag_dk:";s:8:"🇩🇰";s:9:":flag_dm:";s:8:"🇩🇲";s:9:":flag_do:";s:8:"🇩🇴";s:9:":flag_dz:";s:8:"🇩🇿";s:9:":flag_ea:";s:8:"🇪🇦";s:9:":flag_ec:";s:8:"🇪🇨";s:9:":flag_ee:";s:8:"🇪🇪";s:9:":flag_eg:";s:8:"🇪🇬";s:9:":flag_eh:";s:8:"🇪🇭";s:9:":flag_er:";s:8:"🇪🇷";s:9:":flag_es:";s:8:"🇪🇸";s:9:":flag_et:";s:8:"🇪🇹";s:9:":flag_eu:";s:8:"🇪🇺";s:9:":flag_fi:";s:8:"🇫🇮";s:9:":flag_fj:";s:8:"🇫🇯";s:9:":flag_fk:";s:8:"🇫🇰";s:9:":flag_fm:";s:8:"🇫🇲";s:9:":flag_fo:";s:8:"🇫🇴";s:9:":flag_fr:";s:8:"🇫🇷";s:9:":flag_ga:";s:8:"🇬🇦";s:9:":flag_gb:";s:8:"🇬🇧";s:9:":flag_gd:";s:8:"🇬🇩";s:9:":flag_ge:";s:8:"🇬🇪";s:9:":flag_gf:";s:8:"🇬🇫";s:9:":flag_gg:";s:8:"🇬🇬";s:9:":flag_gh:";s:8:"🇬🇭";s:9:":flag_gi:";s:8:"🇬🇮";s:9:":flag_gl:";s:8:"🇬🇱";s:9:":flag_gm:";s:8:"🇬🇲";s:9:":flag_gn:";s:8:"🇬🇳";s:9:":flag_gp:";s:8:"🇬🇵";s:9:":flag_gq:";s:8:"🇬🇶";s:9:":flag_gr:";s:8:"🇬🇷";s:9:":flag_gs:";s:8:"🇬🇸";s:9:":flag_gt:";s:8:"🇬🇹";s:9:":flag_gu:";s:8:"🇬🇺";s:9:":flag_gw:";s:8:"🇬🇼";s:9:":flag_gy:";s:8:"🇬🇾";s:9:":flag_hk:";s:8:"🇭🇰";s:9:":flag_hm:";s:8:"🇭🇲";s:9:":flag_hn:";s:8:"🇭🇳";s:9:":flag_hr:";s:8:"🇭🇷";s:9:":flag_ht:";s:8:"🇭🇹";s:9:":flag_hu:";s:8:"🇭🇺";s:9:":flag_ic:";s:8:"🇮🇨";s:9:":flag_id:";s:8:"🇮🇩";s:9:":flag_ie:";s:8:"🇮🇪";s:9:":flag_il:";s:8:"🇮🇱";s:9:":flag_im:";s:8:"🇮🇲";s:9:":flag_in:";s:8:"🇮🇳";s:9:":flag_io:";s:8:"🇮🇴";s:9:":flag_iq:";s:8:"🇮🇶";s:9:":flag_ir:";s:8:"🇮🇷";s:9:":flag_is:";s:8:"🇮🇸";s:9:":flag_it:";s:8:"🇮🇹";s:9:":flag_je:";s:8:"🇯🇪";s:9:":flag_jm:";s:8:"🇯🇲";s:9:":flag_jo:";s:8:"🇯🇴";s:9:":flag_jp:";s:8:"🇯🇵";s:9:":flag_ke:";s:8:"🇰🇪";s:9:":flag_kg:";s:8:"🇰🇬";s:9:":flag_kh:";s:8:"🇰🇭";s:9:":flag_ki:";s:8:"🇰🇮";s:9:":flag_km:";s:8:"🇰🇲";s:9:":flag_kn:";s:8:"🇰🇳";s:9:":flag_kp:";s:8:"🇰🇵";s:9:":flag_kr:";s:8:"🇰🇷";s:9:":flag_kw:";s:8:"🇰🇼";s:9:":flag_ky:";s:8:"🇰🇾";s:9:":flag_kz:";s:8:"🇰🇿";s:9:":flag_la:";s:8:"🇱🇦";s:9:":flag_lb:";s:8:"🇱🇧";s:9:":flag_lc:";s:8:"🇱🇨";s:9:":flag_li:";s:8:"🇱🇮";s:9:":flag_lk:";s:8:"🇱🇰";s:9:":flag_lr:";s:8:"🇱🇷";s:9:":flag_ls:";s:8:"🇱🇸";s:9:":flag_lt:";s:8:"🇱🇹";s:9:":flag_lu:";s:8:"🇱🇺";s:9:":flag_lv:";s:8:"🇱🇻";s:9:":flag_ly:";s:8:"🇱🇾";s:9:":flag_ma:";s:8:"🇲🇦";s:9:":flag_mc:";s:8:"🇲🇨";s:9:":flag_md:";s:8:"🇲🇩";s:9:":flag_me:";s:8:"🇲🇪";s:9:":flag_mf:";s:8:"🇲🇫";s:9:":flag_mg:";s:8:"🇲🇬";s:9:":flag_mh:";s:8:"🇲🇭";s:9:":flag_mk:";s:8:"🇲🇰";s:9:":flag_ml:";s:8:"🇲🇱";s:9:":flag_mm:";s:8:"🇲🇲";s:9:":flag_mn:";s:8:"🇲🇳";s:9:":flag_mo:";s:8:"🇲🇴";s:9:":flag_mp:";s:8:"🇲🇵";s:9:":flag_mq:";s:8:"🇲🇶";s:9:":flag_mr:";s:8:"🇲🇷";s:9:":flag_ms:";s:8:"🇲🇸";s:9:":flag_mt:";s:8:"🇲🇹";s:9:":flag_mu:";s:8:"🇲🇺";s:9:":flag_mv:";s:8:"🇲🇻";s:9:":flag_mw:";s:8:"🇲🇼";s:9:":flag_mx:";s:8:"🇲🇽";s:9:":flag_my:";s:8:"🇲🇾";s:9:":flag_mz:";s:8:"🇲🇿";s:9:":flag_na:";s:8:"🇳🇦";s:9:":flag_nc:";s:8:"🇳🇨";s:9:":flag_ne:";s:8:"🇳🇪";s:9:":flag_nf:";s:8:"🇳🇫";s:9:":flag_ng:";s:8:"🇳🇬";s:9:":flag_ni:";s:8:"🇳🇮";s:9:":flag_nl:";s:8:"🇳🇱";s:9:":flag_no:";s:8:"🇳🇴";s:9:":flag_np:";s:8:"🇳🇵";s:9:":flag_nr:";s:8:"🇳🇷";s:9:":flag_nu:";s:8:"🇳🇺";s:9:":flag_nz:";s:8:"🇳🇿";s:9:":flag_om:";s:8:"🇴🇲";s:9:":flag_pa:";s:8:"🇵🇦";s:9:":flag_pe:";s:8:"🇵🇪";s:9:":flag_pf:";s:8:"🇵🇫";s:9:":flag_pg:";s:8:"🇵🇬";s:9:":flag_ph:";s:8:"🇵🇭";s:9:":flag_pk:";s:8:"🇵🇰";s:9:":flag_pl:";s:8:"🇵🇱";s:9:":flag_pm:";s:8:"🇵🇲";s:9:":flag_pn:";s:8:"🇵🇳";s:9:":flag_pr:";s:8:"🇵🇷";s:9:":flag_ps:";s:8:"🇵🇸";s:9:":flag_pt:";s:8:"🇵🇹";s:9:":flag_pw:";s:8:"🇵🇼";s:9:":flag_py:";s:8:"🇵🇾";s:9:":flag_qa:";s:8:"🇶🇦";s:9:":flag_re:";s:8:"🇷🇪";s:9:":flag_ro:";s:8:"🇷🇴";s:9:":flag_rs:";s:8:"🇷🇸";s:9:":flag_ru:";s:8:"🇷🇺";s:9:":flag_rw:";s:8:"🇷🇼";s:9:":flag_sa:";s:8:"🇸🇦";s:9:":flag_sb:";s:8:"🇸🇧";s:9:":flag_sc:";s:8:"🇸🇨";s:9:":flag_sd:";s:8:"🇸🇩";s:9:":flag_se:";s:8:"🇸🇪";s:9:":flag_sg:";s:8:"🇸🇬";s:9:":flag_sh:";s:8:"🇸🇭";s:9:":flag_si:";s:8:"🇸🇮";s:9:":flag_sj:";s:8:"🇸🇯";s:9:":flag_sk:";s:8:"🇸🇰";s:9:":flag_sl:";s:8:"🇸🇱";s:9:":flag_sm:";s:8:"🇸🇲";s:9:":flag_sn:";s:8:"🇸🇳";s:9:":flag_so:";s:8:"🇸🇴";s:9:":flag_sr:";s:8:"🇸🇷";s:9:":flag_ss:";s:8:"🇸🇸";s:9:":flag_st:";s:8:"🇸🇹";s:9:":flag_sv:";s:8:"🇸🇻";s:9:":flag_sx:";s:8:"🇸🇽";s:9:":flag_sy:";s:8:"🇸🇾";s:9:":flag_sz:";s:8:"🇸🇿";s:9:":flag_ta:";s:8:"🇹🇦";s:9:":flag_tc:";s:8:"🇹🇨";s:9:":flag_td:";s:8:"🇹🇩";s:9:":flag_tf:";s:8:"🇹🇫";s:9:":flag_tg:";s:8:"🇹🇬";s:9:":flag_th:";s:8:"🇹🇭";s:9:":flag_tj:";s:8:"🇹🇯";s:9:":flag_tk:";s:8:"🇹🇰";s:9:":flag_tl:";s:8:"🇹🇱";s:9:":flag_tm:";s:8:"🇹🇲";s:9:":flag_tn:";s:8:"🇹🇳";s:9:":flag_to:";s:8:"🇹🇴";s:9:":flag_tr:";s:8:"🇹🇷";s:9:":flag_tt:";s:8:"🇹🇹";s:9:":flag_tv:";s:8:"🇹🇻";s:9:":flag_tw:";s:8:"🇹🇼";s:9:":flag_tz:";s:8:"🇹🇿";s:9:":flag_ua:";s:8:"🇺🇦";s:9:":flag_ug:";s:8:"🇺🇬";s:9:":flag_um:";s:8:"🇺🇲";s:9:":flag_us:";s:8:"🇺🇸";s:9:":flag_uy:";s:8:"🇺🇾";s:9:":flag_uz:";s:8:"🇺🇿";s:9:":flag_va:";s:8:"🇻🇦";s:9:":flag_vc:";s:8:"🇻🇨";s:9:":flag_ve:";s:8:"🇻🇪";s:9:":flag_vg:";s:8:"🇻🇬";s:9:":flag_vi:";s:8:"🇻🇮";s:9:":flag_vn:";s:8:"🇻🇳";s:9:":flag_vu:";s:8:"🇻🇺";s:9:":flag_wf:";s:8:"🇼🇫";s:12:":flag_white:";s:7:"🏳️";s:9:":flag_ws:";s:8:"🇼🇸";s:9:":flag_xk:";s:8:"🇽🇰";s:9:":flag_ye:";s:8:"🇾🇪";s:9:":flag_yt:";s:8:"🇾🇹";s:9:":flag_za:";s:8:"🇿🇦";s:9:":flag_zm:";s:8:"🇿🇲";s:9:":flag_zw:";s:8:"🇿🇼";s:7:":flags:";s:4:"🎏";s:12:":flashlight:";s:4:"🔦";s:14:":fleur-de-lis:";s:6:"⚜️";s:14:":fleur_de_lis:";s:6:"⚜️";s:16:":flight_arrival:";s:4:"🛬";s:18:":flight_departure:";s:4:"🛫";s:9:":flipper:";s:4:"🐬";s:13:":floppy_disk:";s:4:"💾";s:22:":flower_playing_cards:";s:4:"🎴";s:9:":flushed:";s:4:"😳";s:15:":flying_saucer:";s:4:"🛸";s:5:":fog:";s:4:"🌫";s:7:":foggy:";s:4:"🌁";s:10:":football:";s:4:"🏈";s:12:":footprints:";s:4:"👣";s:16:":fork_and_knife:";s:4:"🍴";s:18:":fork_knife_plate:";s:7:"🍽️";s:16:":fortune_cookie:";s:4:"🥠";s:10:":fountain:";s:6:"⛲️";s:14:":fountain_pen:";s:4:"🖋";s:6:":four:";s:4:"4⃣";s:18:":four_leaf_clover:";s:4:"🍀";s:5:":fox:";s:4:"🦊";s:10:":fox_face:";s:4:"🦊";s:4:":fr:";s:8:"🇫🇷";s:13:":frame_photo:";s:7:"🖼️";s:16:":framed_picture:";s:4:"🖼";s:6:":free:";s:4:"🆓";s:14:":french_bread:";s:4:"🥖";s:15:":french_guiana:";s:8:"🇬🇫";s:18:":french_polynesia:";s:8:"🇵🇫";s:29:":french_southern_territories:";s:8:"🇹🇫";s:11:":fried_egg:";s:4:"🍳";s:14:":fried_shrimp:";s:4:"🍤";s:7:":fries:";s:4:"🍟";s:6:":frog:";s:4:"🐸";s:10:":frowning:";s:4:"😦";s:11:":frowning2:";s:6:"☹️";s:15:":frowning_face:";s:6:"☹️";s:14:":frowning_man:";s:13:"🙍‍♂️";s:16:":frowning_woman:";s:4:"🙍";s:4:":fu:";s:4:"🖕";s:10:":fuelpump:";s:6:"⛽️";s:11:":full_moon:";s:4:"🌕";s:21:":full_moon_with_face:";s:4:"🌝";s:13:":funeral_urn:";s:6:"⚱️";s:7:":gabon:";s:8:"🇬🇦";s:8:":gambia:";s:8:"🇬🇲";s:10:":game_die:";s:4:"🎲";s:4:":gb:";s:8:"🇬🇧";s:6:":gear:";s:6:"⚙️";s:5:":gem:";s:4:"💎";s:8:":gemini:";s:6:"♊️";s:7:":genie:";s:4:"🧞";s:9:":georgia:";s:8:"🇬🇪";s:7:":ghana:";s:8:"🇬🇭";s:7:":ghost:";s:4:"👻";s:11:":gibraltar:";s:8:"🇬🇮";s:6:":gift:";s:4:"🎁";s:12:":gift_heart:";s:4:"💝";s:9:":giraffe:";s:4:"🦒";s:6:":girl:";s:4:"👧";s:12:":girl_tone1:";s:8:"👧🏻";s:12:":girl_tone2:";s:8:"👧🏼";s:12:":girl_tone3:";s:8:"👧🏽";s:12:":girl_tone4:";s:8:"👧🏾";s:12:":girl_tone5:";s:8:"👧🏿";s:22:":globe_with_meridians:";s:4:"🌐";s:8:":gloves:";s:4:"🧤";s:6:":goal:";s:4:"🥅";s:10:":goal_net:";s:4:"🥅";s:6:":goat:";s:4:"🐐";s:6:":golf:";s:6:"⛳️";s:13:":golfing_man:";s:4:"🏌";s:15:":golfing_woman:";s:16:"🏌️‍♀️";s:9:":gorilla:";s:4:"🦍";s:8:":grapes:";s:4:"🍇";s:8:":greece:";s:8:"🇬🇷";s:13:":green_apple:";s:4:"🍏";s:12:":green_book:";s:4:"📗";s:13:":green_heart:";s:4:"💚";s:13:":green_salad:";s:4:"🥗";s:11:":greenland:";s:8:"🇬🇱";s:9:":grenada:";s:8:"🇬🇩";s:18:":grey_exclamation:";s:3:"❕";s:15:":grey_question:";s:3:"❔";s:11:":grimacing:";s:4:"😬";s:6:":grin:";s:4:"😁";s:10:":grinning:";s:4:"😀";s:12:":guadeloupe:";s:8:"🇬🇵";s:6:":guam:";s:8:"🇬🇺";s:7:":guard:";s:8:"💂🏿";s:13:":guard_tone1:";s:8:"💂🏻";s:13:":guard_tone2:";s:8:"💂🏼";s:13:":guard_tone3:";s:8:"💂🏽";s:13:":guard_tone4:";s:8:"💂🏾";s:13:":guard_tone5:";s:8:"💂🏿";s:11:":guardsman:";s:4:"💂";s:13:":guardswoman:";s:13:"💂‍♀️";s:11:":guatemala:";s:8:"🇬🇹";s:10:":guernsey:";s:8:"🇬🇬";s:8:":guinea:";s:8:"🇬🇳";s:15:":guinea_bissau:";s:8:"🇬🇼";s:8:":guitar:";s:4:"🎸";s:5:":gun:";s:4:"🔫";s:8:":guyana:";s:8:"🇬🇾";s:9:":haircut:";s:4:"💇";s:13:":haircut_man:";s:13:"💇‍♂️";s:15:":haircut_woman:";s:4:"💇";s:7:":haiti:";s:8:"🇭🇹";s:11:":hamburger:";s:4:"🍔";s:8:":hammer:";s:4:"🔨";s:17:":hammer_and_pick:";s:3:"⚒";s:19:":hammer_and_wrench:";s:4:"🛠";s:13:":hammer_pick:";s:6:"⚒️";s:9:":hamster:";s:4:"🐹";s:6:":hand:";s:3:"✋";s:14:":hand_splayed:";s:7:"🖐️";s:20:":hand_splayed_tone1:";s:8:"🖐🏻";s:20:":hand_splayed_tone2:";s:8:"🖐🏼";s:20:":hand_splayed_tone3:";s:8:"🖐🏽";s:20:":hand_splayed_tone4:";s:8:"🖐🏾";s:20:":hand_splayed_tone5:";s:8:"🖐🏿";s:9:":handbag:";s:4:"👜";s:11:":handshake:";s:4:"🤝";s:8:":hankey:";s:4:"💩";s:6:":hash:";s:4:"#⃣";s:15:":hatched_chick:";s:4:"🐥";s:16:":hatching_chick:";s:4:"🐣";s:14:":head_bandage:";s:4:"🤕";s:12:":headphones:";s:4:"🎧";s:14:":hear_no_evil:";s:4:"🙉";s:7:":heart:";s:6:"❤️";s:18:":heart_decoration:";s:4:"💟";s:19:":heart_exclamation:";s:6:"❣️";s:12:":heart_eyes:";s:4:"😍";s:16:":heart_eyes_cat:";s:4:"😻";s:11:":heartbeat:";s:4:"💓";s:12:":heartpulse:";s:4:"💗";s:8:":hearts:";s:6:"♥️";s:18:":heavy_check_mark:";s:6:"✔️";s:21:":heavy_division_sign:";s:3:"➗";s:19:":heavy_dollar_sign:";s:4:"💲";s:24:":heavy_exclamation_mark:";s:6:"❗️";s:25:":heavy_heart_exclamation:";s:6:"❣️";s:18:":heavy_minus_sign:";s:3:"➖";s:24:":heavy_multiplication_x:";s:6:"✖️";s:17:":heavy_plus_sign:";s:3:"➕";s:10:":hedgehog:";s:4:"🦔";s:12:":helicopter:";s:4:"🚁";s:19:":helmet_with_cross:";s:6:"⛑️";s:6:":herb:";s:4:"🌿";s:10:":hibiscus:";s:4:"🌺";s:17:":high_brightness:";s:4:"🔆";s:11:":high_heel:";s:4:"👠";s:7:":hocho:";s:4:"🔪";s:8:":hockey:";s:4:"🏒";s:6:":hole:";s:4:"🕳";s:7:":homes:";s:7:"🏘️";s:10:":honduras:";s:8:"🇭🇳";s:11:":honey_pot:";s:4:"🍯";s:10:":honeybee:";s:4:"🐝";s:11:":hong_kong:";s:8:"🇭🇰";s:7:":horse:";s:4:"🐴";s:14:":horse_racing:";s:4:"🏇";s:20:":horse_racing_tone1:";s:8:"🏇🏻";s:20:":horse_racing_tone2:";s:8:"🏇🏼";s:20:":horse_racing_tone3:";s:8:"🏇🏽";s:20:":horse_racing_tone4:";s:8:"🏇🏾";s:20:":horse_racing_tone5:";s:8:"🏇🏿";s:10:":hospital:";s:4:"🏥";s:12:":hot_pepper:";s:4:"🌶";s:8:":hotdog:";s:4:"🌭";s:7:":hotel:";s:4:"🏨";s:12:":hotsprings:";s:6:"♨️";s:11:":hourglass:";s:6:"⌛️";s:24:":hourglass_flowing_sand:";s:3:"⏳";s:7:":house:";s:4:"🏠";s:17:":house_abandoned:";s:7:"🏚️";s:19:":house_with_garden:";s:4:"🏡";s:8:":houses:";s:4:"🏘";s:9:":hugging:";s:4:"🤗";s:6:":hugs:";s:4:"🤗";s:9:":hungary:";s:8:"🇭🇺";s:8:":hushed:";s:4:"😯";s:11:":ice_cream:";s:4:"🍨";s:12:":ice_hockey:";s:4:"🏒";s:11:":ice_skate:";s:3:"⛸";s:10:":icecream:";s:4:"🍦";s:9:":iceland:";s:8:"🇮🇸";s:4:":id:";s:4:"🆔";s:21:":ideograph_advantage:";s:4:"🉐";s:5:":imp:";s:4:"👿";s:12:":inbox_tray:";s:4:"📥";s:19:":incoming_envelope:";s:4:"📨";s:7:":india:";s:8:"🇮🇳";s:11:":indonesia:";s:8:"🇮🇩";s:25:":information_desk_person:";s:4:"💁";s:20:":information_source:";s:6:"ℹ️";s:10:":innocent:";s:4:"😇";s:13:":interrobang:";s:6:"⁉️";s:8:":iphone:";s:4:"📱";s:6:":iran:";s:8:"🇮🇷";s:6:":iraq:";s:8:"🇮🇶";s:9:":ireland:";s:8:"🇮🇪";s:8:":island:";s:7:"🏝️";s:13:":isle_of_man:";s:8:"🇮🇲";s:8:":israel:";s:8:"🇮🇱";s:4:":it:";s:8:"🇮🇹";s:17:":izakaya_lantern:";s:4:"🏮";s:16:":jack_o_lantern:";s:4:"🎃";s:9:":jamaica:";s:8:"🇯🇲";s:7:":japan:";s:4:"🗾";s:17:":japanese_castle:";s:4:"🏯";s:17:":japanese_goblin:";s:4:"👺";s:15:":japanese_ogre:";s:4:"👹";s:7:":jeans:";s:4:"👖";s:8:":jersey:";s:8:"🇯🇪";s:8:":jordan:";s:8:"🇯🇴";s:5:":joy:";s:4:"😂";s:9:":joy_cat:";s:4:"😹";s:10:":joystick:";s:4:"🕹";s:4:":jp:";s:8:"🇯🇵";s:7:":kaaba:";s:4:"🕋";s:12:":kazakhstan:";s:8:"🇰🇿";s:7:":kenya:";s:8:"🇰🇪";s:5:":key:";s:4:"🔑";s:6:":key2:";s:7:"🗝️";s:10:":keyboard:";s:6:"⌨️";s:12:":keycap_ten:";s:4:"🔟";s:14:":kick_scooter:";s:4:"🛴";s:8:":kimono:";s:4:"👘";s:10:":kiribati:";s:8:"🇰🇮";s:6:":kiss:";s:4:"💋";s:9:":kiss_mm:";s:27:"👨‍❤️‍💋‍👨";s:16:":kiss_woman_man:";s:27:"👩‍❤️‍💋‍👨";s:9:":kiss_ww:";s:27:"👩‍❤️‍💋‍👩";s:9:":kissing:";s:4:"😗";s:13:":kissing_cat:";s:4:"😽";s:21:":kissing_closed_eyes:";s:4:"😚";s:15:":kissing_heart:";s:4:"😘";s:22:":kissing_smiling_eyes:";s:4:"😙";s:6:":kiwi:";s:4:"🥝";s:12:":kiwi_fruit:";s:4:"🥝";s:7:":knife:";s:4:"🔪";s:7:":koala:";s:4:"🐨";s:6:":koko:";s:4:"🈁";s:8:":kosovo:";s:8:"🇽🇰";s:4:":kr:";s:8:"🇰🇷";s:8:":kuwait:";s:8:"🇰🇼";s:12:":kyrgyzstan:";s:8:"🇰🇬";s:7:":label:";s:4:"🏷";s:9:":lantern:";s:4:"🏮";s:6:":laos:";s:8:"🇱🇦";s:19:":large_blue_circle:";s:4:"🔵";s:20:":large_blue_diamond:";s:4:"🔷";s:22:":large_orange_diamond:";s:4:"🔶";s:19:":last_quarter_moon:";s:4:"🌗";s:29:":last_quarter_moon_with_face:";s:4:"🌜";s:13:":latin_cross:";s:6:"✝️";s:8:":latvia:";s:8:"🇱🇻";s:10:":laughing:";s:4:"😆";s:8:":leaves:";s:4:"🍃";s:9:":lebanon:";s:8:"🇱🇧";s:8:":ledger:";s:4:"📒";s:18:":left_facing_fist:";s:4:"🤛";s:24:":left_facing_fist_tone1:";s:8:"🤛🏻";s:24:":left_facing_fist_tone2:";s:8:"🤛🏼";s:24:":left_facing_fist_tone3:";s:8:"🤛🏽";s:24:":left_facing_fist_tone4:";s:8:"🤛🏾";s:24:":left_facing_fist_tone5:";s:8:"🤛🏿";s:14:":left_luggage:";s:4:"🛅";s:18:":left_right_arrow:";s:6:"↔️";s:27:":leftwards_arrow_with_hook:";s:6:"↩️";s:7:":lemon:";s:4:"🍋";s:5:":leo:";s:6:"♌️";s:9:":leopard:";s:4:"🐆";s:9:":lesotho:";s:8:"🇱🇸";s:14:":level_slider:";s:4:"🎚";s:10:":levitate:";s:4:"🕴";s:9:":liberia:";s:8:"🇱🇷";s:7:":libra:";s:6:"♎️";s:7:":libya:";s:8:"🇱🇾";s:15:":liechtenstein:";s:8:"🇱🇮";s:12:":light_rail:";s:4:"🚈";s:6:":link:";s:4:"🔗";s:6:":lion:";s:4:"🦁";s:11:":lion_face:";s:4:"🦁";s:6:":lips:";s:4:"👄";s:10:":lipstick:";s:4:"💄";s:11:":lithuania:";s:8:"🇱🇹";s:8:":lizard:";s:4:"🦎";s:6:":lock:";s:4:"🔒";s:19:":lock_with_ink_pen:";s:4:"🔏";s:10:":lollipop:";s:4:"🍭";s:6:":loop:";s:3:"➿";s:12:":loud_sound:";s:4:"🔊";s:13:":loudspeaker:";s:4:"📢";s:12:":love_hotel:";s:4:"🏩";s:13:":love_letter:";s:4:"💌";s:18:":love_you_gesture:";s:4:"🤟";s:24:":love_you_gesture_tone1:";s:8:"🤟🏻";s:24:":love_you_gesture_tone2:";s:8:"🤟🏼";s:24:":love_you_gesture_tone3:";s:8:"🤟🏽";s:24:":love_you_gesture_tone4:";s:8:"🤟🏾";s:24:":love_you_gesture_tone5:";s:8:"🤟🏿";s:16:":low_brightness:";s:4:"🔅";s:12:":luxembourg:";s:8:"🇱🇺";s:12:":lying_face:";s:4:"🤥";s:3:":m:";s:6:"Ⓜ️";s:7:":macau:";s:8:"🇲🇴";s:11:":macedonia:";s:8:"🇲🇰";s:12:":madagascar:";s:8:"🇲🇬";s:5:":mag:";s:4:"🔍";s:11:":mag_right:";s:4:"🔎";s:6:":mage:";s:8:"🧙🏿";s:12:":mage_tone1:";s:8:"🧙🏻";s:12:":mage_tone2:";s:8:"🧙🏼";s:12:":mage_tone3:";s:8:"🧙🏽";s:12:":mage_tone4:";s:8:"🧙🏾";s:12:":mage_tone5:";s:8:"🧙🏿";s:9:":mahjong:";s:7:"🀄️";s:9:":mailbox:";s:4:"📫";s:16:":mailbox_closed:";s:4:"📪";s:19:":mailbox_with_mail:";s:4:"📬";s:22:":mailbox_with_no_mail:";s:4:"📭";s:8:":malawi:";s:8:"🇲🇼";s:10:":malaysia:";s:8:"🇲🇾";s:10:":maldives:";s:8:"🇲🇻";s:16:":male_detective:";s:4:"🕵";s:11:":male_sign:";s:6:"♂️";s:6:":mali:";s:8:"🇲🇱";s:7:":malta:";s:8:"🇲🇹";s:5:":man:";s:4:"👨";s:12:":man_artist:";s:11:"👨‍🎨";s:18:":man_artist_tone1:";s:15:"👨🏻‍🎨";s:18:":man_artist_tone2:";s:15:"👨🏼‍🎨";s:18:":man_artist_tone3:";s:15:"👨🏽‍🎨";s:18:":man_artist_tone4:";s:15:"👨🏾‍🎨";s:18:":man_artist_tone5:";s:15:"👨🏿‍🎨";s:15:":man_astronaut:";s:11:"👨‍🚀";s:21:":man_astronaut_tone1:";s:15:"👨🏻‍🚀";s:21:":man_astronaut_tone2:";s:15:"👨🏼‍🚀";s:21:":man_astronaut_tone3:";s:15:"👨🏽‍🚀";s:21:":man_astronaut_tone4:";s:15:"👨🏾‍🚀";s:21:":man_astronaut_tone5:";s:15:"👨🏿‍🚀";s:12:":man_biking:";s:13:"🚴‍♂️";s:18:":man_biking_tone1:";s:17:"🚴🏻‍♂️";s:18:":man_biking_tone2:";s:17:"🚴🏼‍♂️";s:18:":man_biking_tone3:";s:17:"🚴🏽‍♂️";s:18:":man_biking_tone4:";s:17:"🚴🏾‍♂️";s:18:":man_biking_tone5:";s:17:"🚴🏿‍♂️";s:19:":man_bouncing_ball:";s:15:"⛹️‍♂️";s:25:":man_bouncing_ball_tone1:";s:16:"⛹🏻‍♂️";s:25:":man_bouncing_ball_tone2:";s:16:"⛹🏼‍♂️";s:25:":man_bouncing_ball_tone3:";s:16:"⛹🏽‍♂️";s:25:":man_bouncing_ball_tone4:";s:16:"⛹🏾‍♂️";s:25:":man_bouncing_ball_tone5:";s:16:"⛹🏿‍♂️";s:12:":man_bowing:";s:13:"🙇‍♂️";s:18:":man_bowing_tone1:";s:17:"🙇🏻‍♂️";s:18:":man_bowing_tone2:";s:17:"🙇🏼‍♂️";s:18:":man_bowing_tone3:";s:17:"🙇🏽‍♂️";s:18:":man_bowing_tone4:";s:17:"🙇🏾‍♂️";s:18:":man_bowing_tone5:";s:17:"🙇🏿‍♂️";s:18:":man_cartwheeling:";s:13:"🤸‍♂️";s:24:":man_cartwheeling_tone1:";s:17:"🤸🏻‍♂️";s:24:":man_cartwheeling_tone2:";s:17:"🤸🏼‍♂️";s:24:":man_cartwheeling_tone3:";s:17:"🤸🏽‍♂️";s:24:":man_cartwheeling_tone4:";s:17:"🤸🏾‍♂️";s:24:":man_cartwheeling_tone5:";s:17:"🤸🏿‍♂️";s:14:":man_climbing:";s:17:"🧗🏿‍♂️";s:20:":man_climbing_tone1:";s:17:"🧗🏻‍♂️";s:20:":man_climbing_tone2:";s:17:"🧗🏼‍♂️";s:20:":man_climbing_tone3:";s:17:"🧗🏽‍♂️";s:20:":man_climbing_tone4:";s:17:"🧗🏾‍♂️";s:20:":man_climbing_tone5:";s:17:"🧗🏿‍♂️";s:25:":man_construction_worker:";s:13:"👷‍♂️";s:31:":man_construction_worker_tone1:";s:17:"👷🏻‍♂️";s:31:":man_construction_worker_tone2:";s:17:"👷🏼‍♂️";s:31:":man_construction_worker_tone3:";s:17:"👷🏽‍♂️";s:31:":man_construction_worker_tone4:";s:17:"👷🏾‍♂️";s:31:":man_construction_worker_tone5:";s:17:"👷🏿‍♂️";s:10:":man_cook:";s:11:"👨‍🍳";s:16:":man_cook_tone1:";s:15:"👨🏻‍🍳";s:16:":man_cook_tone2:";s:15:"👨🏼‍🍳";s:16:":man_cook_tone3:";s:15:"👨🏽‍🍳";s:16:":man_cook_tone4:";s:15:"👨🏾‍🍳";s:16:":man_cook_tone5:";s:15:"👨🏿‍🍳";s:13:":man_dancing:";s:4:"🕺";s:19:":man_dancing_tone1:";s:8:"🕺🏻";s:19:":man_dancing_tone2:";s:8:"🕺🏼";s:19:":man_dancing_tone3:";s:8:"🕺🏽";s:19:":man_dancing_tone4:";s:8:"🕺🏾";s:19:":man_dancing_tone5:";s:8:"🕺🏿";s:15:":man_detective:";s:16:"🕵️‍♂️";s:21:":man_detective_tone1:";s:17:"🕵🏻‍♂️";s:21:":man_detective_tone2:";s:17:"🕵🏼‍♂️";s:21:":man_detective_tone3:";s:17:"🕵🏽‍♂️";s:21:":man_detective_tone4:";s:17:"🕵🏾‍♂️";s:21:":man_detective_tone5:";s:17:"🕵🏿‍♂️";s:9:":man_elf:";s:17:"🧝🏿‍♂️";s:15:":man_elf_tone1:";s:17:"🧝🏻‍♂️";s:15:":man_elf_tone2:";s:17:"🧝🏼‍♂️";s:15:":man_elf_tone3:";s:17:"🧝🏽‍♂️";s:15:":man_elf_tone4:";s:17:"🧝🏾‍♂️";s:15:":man_elf_tone5:";s:17:"🧝🏿‍♂️";s:17:":man_facepalming:";s:13:"🤦‍♂️";s:23:":man_facepalming_tone1:";s:17:"🤦🏻‍♂️";s:23:":man_facepalming_tone2:";s:17:"🤦🏼‍♂️";s:23:":man_facepalming_tone3:";s:17:"🤦🏽‍♂️";s:23:":man_facepalming_tone4:";s:17:"🤦🏾‍♂️";s:23:":man_facepalming_tone5:";s:17:"🤦🏿‍♂️";s:20:":man_factory_worker:";s:11:"👨‍🏭";s:26:":man_factory_worker_tone1:";s:15:"👨🏻‍🏭";s:26:":man_factory_worker_tone2:";s:15:"👨🏼‍🏭";s:26:":man_factory_worker_tone3:";s:15:"👨🏽‍🏭";s:26:":man_factory_worker_tone4:";s:15:"👨🏾‍🏭";s:26:":man_factory_worker_tone5:";s:15:"👨🏿‍🏭";s:11:":man_fairy:";s:17:"🧚🏿‍♂️";s:17:":man_fairy_tone1:";s:17:"🧚🏻‍♂️";s:17:":man_fairy_tone2:";s:17:"🧚🏼‍♂️";s:17:":man_fairy_tone3:";s:17:"🧚🏽‍♂️";s:17:":man_fairy_tone4:";s:17:"🧚🏾‍♂️";s:17:":man_fairy_tone5:";s:17:"🧚🏿‍♂️";s:12:":man_farmer:";s:11:"👨‍🌾";s:18:":man_farmer_tone1:";s:15:"👨🏻‍🌾";s:18:":man_farmer_tone2:";s:15:"👨🏼‍🌾";s:18:":man_farmer_tone3:";s:15:"👨🏽‍🌾";s:18:":man_farmer_tone4:";s:15:"👨🏾‍🌾";s:18:":man_farmer_tone5:";s:15:"👨🏿‍🌾";s:17:":man_firefighter:";s:11:"👨‍🚒";s:23:":man_firefighter_tone1:";s:15:"👨🏻‍🚒";s:23:":man_firefighter_tone2:";s:15:"👨🏼‍🚒";s:23:":man_firefighter_tone3:";s:15:"👨🏽‍🚒";s:23:":man_firefighter_tone4:";s:15:"👨🏾‍🚒";s:23:":man_firefighter_tone5:";s:15:"👨🏿‍🚒";s:14:":man_frowning:";s:13:"🙍‍♂️";s:20:":man_frowning_tone1:";s:17:"🙍🏻‍♂️";s:20:":man_frowning_tone2:";s:17:"🙍🏼‍♂️";s:20:":man_frowning_tone3:";s:17:"🙍🏽‍♂️";s:20:":man_frowning_tone4:";s:17:"🙍🏾‍♂️";s:20:":man_frowning_tone5:";s:17:"🙍🏿‍♂️";s:11:":man_genie:";s:13:"🧞‍♂️";s:18:":man_gesturing_no:";s:13:"🙅‍♂️";s:24:":man_gesturing_no_tone1:";s:17:"🙅🏻‍♂️";s:24:":man_gesturing_no_tone2:";s:17:"🙅🏼‍♂️";s:24:":man_gesturing_no_tone3:";s:17:"🙅🏽‍♂️";s:24:":man_gesturing_no_tone4:";s:17:"🙅🏾‍♂️";s:24:":man_gesturing_no_tone5:";s:17:"🙅🏿‍♂️";s:18:":man_gesturing_ok:";s:13:"🙆‍♂️";s:24:":man_gesturing_ok_tone1:";s:17:"🙆🏻‍♂️";s:24:":man_gesturing_ok_tone2:";s:17:"🙆🏼‍♂️";s:24:":man_gesturing_ok_tone3:";s:17:"🙆🏽‍♂️";s:24:":man_gesturing_ok_tone4:";s:17:"🙆🏾‍♂️";s:24:":man_gesturing_ok_tone5:";s:17:"🙆🏿‍♂️";s:26:":man_getting_face_massage:";s:13:"💆‍♂️";s:32:":man_getting_face_massage_tone1:";s:17:"💆🏻‍♂️";s:32:":man_getting_face_massage_tone2:";s:17:"💆🏼‍♂️";s:32:":man_getting_face_massage_tone3:";s:17:"💆🏽‍♂️";s:32:":man_getting_face_massage_tone4:";s:17:"💆🏾‍♂️";s:32:":man_getting_face_massage_tone5:";s:17:"💆🏿‍♂️";s:21:":man_getting_haircut:";s:13:"💇‍♂️";s:27:":man_getting_haircut_tone1:";s:17:"💇🏻‍♂️";s:27:":man_getting_haircut_tone2:";s:17:"💇🏼‍♂️";s:27:":man_getting_haircut_tone3:";s:17:"💇🏽‍♂️";s:27:":man_getting_haircut_tone4:";s:17:"💇🏾‍♂️";s:27:":man_getting_haircut_tone5:";s:17:"💇🏿‍♂️";s:13:":man_golfing:";s:17:"🏌🏿‍♂️";s:19:":man_golfing_tone1:";s:17:"🏌🏻‍♂️";s:19:":man_golfing_tone2:";s:17:"🏌🏼‍♂️";s:19:":man_golfing_tone3:";s:17:"🏌🏽‍♂️";s:19:":man_golfing_tone4:";s:17:"🏌🏾‍♂️";s:19:":man_golfing_tone5:";s:17:"🏌🏿‍♂️";s:11:":man_guard:";s:13:"💂‍♂️";s:17:":man_guard_tone1:";s:17:"💂🏻‍♂️";s:17:":man_guard_tone2:";s:17:"💂🏼‍♂️";s:17:":man_guard_tone3:";s:17:"💂🏽‍♂️";s:17:":man_guard_tone4:";s:17:"💂🏾‍♂️";s:17:":man_guard_tone5:";s:17:"💂🏿‍♂️";s:19:":man_health_worker:";s:13:"👨‍⚕️";s:25:":man_health_worker_tone1:";s:17:"👨🏻‍⚕️";s:25:":man_health_worker_tone2:";s:17:"👨🏼‍⚕️";s:25:":man_health_worker_tone3:";s:17:"👨🏽‍⚕️";s:25:":man_health_worker_tone4:";s:17:"👨🏾‍⚕️";s:25:":man_health_worker_tone5:";s:17:"👨🏿‍⚕️";s:39:":man_in_business_suit_levitating_tone1:";s:8:"🕴🏻";s:39:":man_in_business_suit_levitating_tone2:";s:8:"🕴🏼";s:39:":man_in_business_suit_levitating_tone3:";s:8:"🕴🏽";s:39:":man_in_business_suit_levitating_tone4:";s:8:"🕴🏾";s:39:":man_in_business_suit_levitating_tone5:";s:8:"🕴🏿";s:23:":man_in_lotus_position:";s:17:"🧘🏿‍♂️";s:29:":man_in_lotus_position_tone1:";s:17:"🧘🏻‍♂️";s:29:":man_in_lotus_position_tone2:";s:17:"🧘🏼‍♂️";s:29:":man_in_lotus_position_tone3:";s:17:"🧘🏽‍♂️";s:29:":man_in_lotus_position_tone4:";s:17:"🧘🏾‍♂️";s:29:":man_in_lotus_position_tone5:";s:17:"🧘🏿‍♂️";s:20:":man_in_steamy_room:";s:17:"🧖🏿‍♂️";s:26:":man_in_steamy_room_tone1:";s:17:"🧖🏻‍♂️";s:26:":man_in_steamy_room_tone2:";s:17:"🧖🏼‍♂️";s:26:":man_in_steamy_room_tone3:";s:17:"🧖🏽‍♂️";s:26:":man_in_steamy_room_tone4:";s:17:"🧖🏾‍♂️";s:26:":man_in_steamy_room_tone5:";s:17:"🧖🏿‍♂️";s:15:":man_in_tuxedo:";s:4:"🤵";s:21:":man_in_tuxedo_tone1:";s:8:"🤵🏻";s:21:":man_in_tuxedo_tone2:";s:8:"🤵🏼";s:21:":man_in_tuxedo_tone3:";s:8:"🤵🏽";s:21:":man_in_tuxedo_tone4:";s:8:"🤵🏾";s:21:":man_in_tuxedo_tone5:";s:8:"🤵🏿";s:11:":man_judge:";s:13:"👨‍⚖️";s:17:":man_judge_tone1:";s:17:"👨🏻‍⚖️";s:17:":man_judge_tone2:";s:17:"👨🏼‍⚖️";s:17:":man_judge_tone3:";s:17:"👨🏽‍⚖️";s:17:":man_judge_tone4:";s:17:"👨🏾‍⚖️";s:17:":man_judge_tone5:";s:17:"👨🏿‍⚖️";s:14:":man_juggling:";s:13:"🤹‍♂️";s:20:":man_juggling_tone1:";s:17:"🤹🏻‍♂️";s:20:":man_juggling_tone2:";s:17:"🤹🏼‍♂️";s:20:":man_juggling_tone3:";s:17:"🤹🏽‍♂️";s:20:":man_juggling_tone4:";s:17:"🤹🏾‍♂️";s:20:":man_juggling_tone5:";s:17:"🤹🏿‍♂️";s:21:":man_lifting_weights:";s:16:"🏋️‍♂️";s:27:":man_lifting_weights_tone1:";s:17:"🏋🏻‍♂️";s:27:":man_lifting_weights_tone2:";s:17:"🏋🏼‍♂️";s:27:":man_lifting_weights_tone3:";s:17:"🏋🏽‍♂️";s:27:":man_lifting_weights_tone4:";s:17:"🏋🏾‍♂️";s:27:":man_lifting_weights_tone5:";s:17:"🏋🏿‍♂️";s:10:":man_mage:";s:17:"🧙🏿‍♂️";s:16:":man_mage_tone1:";s:17:"🧙🏻‍♂️";s:16:":man_mage_tone2:";s:17:"🧙🏼‍♂️";s:16:":man_mage_tone3:";s:17:"🧙🏽‍♂️";s:16:":man_mage_tone4:";s:17:"🧙🏾‍♂️";s:16:":man_mage_tone5:";s:17:"🧙🏿‍♂️";s:14:":man_mechanic:";s:11:"👨‍🔧";s:20:":man_mechanic_tone1:";s:15:"👨🏻‍🔧";s:20:":man_mechanic_tone2:";s:15:"👨🏼‍🔧";s:20:":man_mechanic_tone3:";s:15:"👨🏽‍🔧";s:20:":man_mechanic_tone4:";s:15:"👨🏾‍🔧";s:20:":man_mechanic_tone5:";s:15:"👨🏿‍🔧";s:21:":man_mountain_biking:";s:13:"🚵‍♂️";s:27:":man_mountain_biking_tone1:";s:17:"🚵🏻‍♂️";s:27:":man_mountain_biking_tone2:";s:17:"🚵🏼‍♂️";s:27:":man_mountain_biking_tone3:";s:17:"🚵🏽‍♂️";s:27:":man_mountain_biking_tone4:";s:17:"🚵🏾‍♂️";s:27:":man_mountain_biking_tone5:";s:17:"🚵🏿‍♂️";s:19:":man_office_worker:";s:11:"👨‍💼";s:25:":man_office_worker_tone1:";s:15:"👨🏻‍💼";s:25:":man_office_worker_tone2:";s:15:"👨🏼‍💼";s:25:":man_office_worker_tone3:";s:15:"👨🏽‍💼";s:25:":man_office_worker_tone4:";s:15:"👨🏾‍💼";s:25:":man_office_worker_tone5:";s:15:"👨🏿‍💼";s:11:":man_pilot:";s:13:"👨‍✈️";s:17:":man_pilot_tone1:";s:17:"👨🏻‍✈️";s:17:":man_pilot_tone2:";s:17:"👨🏼‍✈️";s:17:":man_pilot_tone3:";s:17:"👨🏽‍✈️";s:17:":man_pilot_tone4:";s:17:"👨🏾‍✈️";s:17:":man_pilot_tone5:";s:17:"👨🏿‍✈️";s:22:":man_playing_handball:";s:13:"🤾‍♂️";s:28:":man_playing_handball_tone1:";s:17:"🤾🏻‍♂️";s:28:":man_playing_handball_tone2:";s:17:"🤾🏼‍♂️";s:28:":man_playing_handball_tone3:";s:17:"🤾🏽‍♂️";s:28:":man_playing_handball_tone4:";s:17:"🤾🏾‍♂️";s:28:":man_playing_handball_tone5:";s:17:"🤾🏿‍♂️";s:24:":man_playing_water_polo:";s:13:"🤽‍♂️";s:30:":man_playing_water_polo_tone1:";s:17:"🤽🏻‍♂️";s:30:":man_playing_water_polo_tone2:";s:17:"🤽🏼‍♂️";s:30:":man_playing_water_polo_tone3:";s:17:"🤽🏽‍♂️";s:30:":man_playing_water_polo_tone4:";s:17:"🤽🏾‍♂️";s:30:":man_playing_water_polo_tone5:";s:17:"🤽🏿‍♂️";s:20:":man_police_officer:";s:13:"👮‍♂️";s:26:":man_police_officer_tone1:";s:17:"👮🏻‍♂️";s:26:":man_police_officer_tone2:";s:17:"👮🏼‍♂️";s:26:":man_police_officer_tone3:";s:17:"👮🏽‍♂️";s:26:":man_police_officer_tone4:";s:17:"👮🏾‍♂️";s:26:":man_police_officer_tone5:";s:17:"👮🏿‍♂️";s:13:":man_pouting:";s:13:"🙎‍♂️";s:19:":man_pouting_tone1:";s:17:"🙎🏻‍♂️";s:19:":man_pouting_tone2:";s:17:"🙎🏼‍♂️";s:19:":man_pouting_tone3:";s:17:"🙎🏽‍♂️";s:19:":man_pouting_tone4:";s:17:"🙎🏾‍♂️";s:19:":man_pouting_tone5:";s:17:"🙎🏿‍♂️";s:18:":man_raising_hand:";s:13:"🙋‍♂️";s:24:":man_raising_hand_tone1:";s:17:"🙋🏻‍♂️";s:24:":man_raising_hand_tone2:";s:17:"🙋🏼‍♂️";s:24:":man_raising_hand_tone3:";s:17:"🙋🏽‍♂️";s:24:":man_raising_hand_tone4:";s:17:"🙋🏾‍♂️";s:24:":man_raising_hand_tone5:";s:17:"🙋🏿‍♂️";s:17:":man_rowing_boat:";s:13:"🚣‍♂️";s:23:":man_rowing_boat_tone1:";s:17:"🚣🏻‍♂️";s:23:":man_rowing_boat_tone2:";s:17:"🚣🏼‍♂️";s:23:":man_rowing_boat_tone3:";s:17:"🚣🏽‍♂️";s:23:":man_rowing_boat_tone4:";s:17:"🚣🏾‍♂️";s:23:":man_rowing_boat_tone5:";s:17:"🚣🏿‍♂️";s:13:":man_running:";s:13:"🏃‍♂️";s:19:":man_running_tone1:";s:17:"🏃🏻‍♂️";s:19:":man_running_tone2:";s:17:"🏃🏼‍♂️";s:19:":man_running_tone3:";s:17:"🏃🏽‍♂️";s:19:":man_running_tone4:";s:17:"🏃🏾‍♂️";s:19:":man_running_tone5:";s:17:"🏃🏿‍♂️";s:15:":man_scientist:";s:11:"👨‍🔬";s:21:":man_scientist_tone1:";s:15:"👨🏻‍🔬";s:21:":man_scientist_tone2:";s:15:"👨🏼‍🔬";s:21:":man_scientist_tone3:";s:15:"👨🏽‍🔬";s:21:":man_scientist_tone4:";s:15:"👨🏾‍🔬";s:21:":man_scientist_tone5:";s:15:"👨🏿‍🔬";s:15:":man_shrugging:";s:13:"🤷‍♂️";s:21:":man_shrugging_tone1:";s:17:"🤷🏻‍♂️";s:21:":man_shrugging_tone2:";s:17:"🤷🏼‍♂️";s:21:":man_shrugging_tone3:";s:17:"🤷🏽‍♂️";s:21:":man_shrugging_tone4:";s:17:"🤷🏾‍♂️";s:21:":man_shrugging_tone5:";s:17:"🤷🏿‍♂️";s:12:":man_singer:";s:11:"👨‍🎤";s:18:":man_singer_tone1:";s:15:"👨🏻‍🎤";s:18:":man_singer_tone2:";s:15:"👨🏼‍🎤";s:18:":man_singer_tone3:";s:15:"👨🏽‍🎤";s:18:":man_singer_tone4:";s:15:"👨🏾‍🎤";s:18:":man_singer_tone5:";s:15:"👨🏿‍🎤";s:13:":man_student:";s:11:"👨‍🎓";s:19:":man_student_tone1:";s:15:"👨🏻‍🎓";s:19:":man_student_tone2:";s:15:"👨🏼‍🎓";s:19:":man_student_tone3:";s:15:"👨🏽‍🎓";s:19:":man_student_tone4:";s:15:"👨🏾‍🎓";s:19:":man_student_tone5:";s:15:"👨🏿‍🎓";s:13:":man_surfing:";s:13:"🏄‍♂️";s:19:":man_surfing_tone1:";s:17:"🏄🏻‍♂️";s:19:":man_surfing_tone2:";s:17:"🏄🏼‍♂️";s:19:":man_surfing_tone3:";s:17:"🏄🏽‍♂️";s:19:":man_surfing_tone4:";s:17:"🏄🏾‍♂️";s:19:":man_surfing_tone5:";s:17:"🏄🏿‍♂️";s:14:":man_swimming:";s:13:"🏊‍♂️";s:20:":man_swimming_tone1:";s:17:"🏊🏻‍♂️";s:20:":man_swimming_tone2:";s:17:"🏊🏼‍♂️";s:20:":man_swimming_tone3:";s:17:"🏊🏽‍♂️";s:20:":man_swimming_tone4:";s:17:"🏊🏾‍♂️";s:20:":man_swimming_tone5:";s:17:"🏊🏿‍♂️";s:13:":man_teacher:";s:11:"👨‍🏫";s:19:":man_teacher_tone1:";s:15:"👨🏻‍🏫";s:19:":man_teacher_tone2:";s:15:"👨🏼‍🏫";s:19:":man_teacher_tone3:";s:15:"👨🏽‍🏫";s:19:":man_teacher_tone4:";s:15:"👨🏾‍🏫";s:19:":man_teacher_tone5:";s:15:"👨🏿‍🏫";s:18:":man_technologist:";s:11:"👨‍💻";s:24:":man_technologist_tone1:";s:15:"👨🏻‍💻";s:24:":man_technologist_tone2:";s:15:"👨🏼‍💻";s:24:":man_technologist_tone3:";s:15:"👨🏽‍💻";s:24:":man_technologist_tone4:";s:15:"👨🏾‍💻";s:24:":man_technologist_tone5:";s:15:"👨🏿‍💻";s:18:":man_tipping_hand:";s:13:"💁‍♂️";s:24:":man_tipping_hand_tone1:";s:17:"💁🏻‍♂️";s:24:":man_tipping_hand_tone2:";s:17:"💁🏼‍♂️";s:24:":man_tipping_hand_tone3:";s:17:"💁🏽‍♂️";s:24:":man_tipping_hand_tone4:";s:17:"💁🏾‍♂️";s:24:":man_tipping_hand_tone5:";s:17:"💁🏿‍♂️";s:11:":man_tone1:";s:8:"👨🏻";s:11:":man_tone2:";s:8:"👨🏼";s:11:":man_tone3:";s:8:"👨🏽";s:11:":man_tone4:";s:8:"👨🏾";s:11:":man_tone5:";s:8:"👨🏿";s:13:":man_vampire:";s:17:"🧛🏿‍♂️";s:19:":man_vampire_tone1:";s:17:"🧛🏻‍♂️";s:19:":man_vampire_tone2:";s:17:"🧛🏼‍♂️";s:19:":man_vampire_tone3:";s:17:"🧛🏽‍♂️";s:19:":man_vampire_tone4:";s:17:"🧛🏾‍♂️";s:19:":man_vampire_tone5:";s:17:"🧛🏿‍♂️";s:13:":man_walking:";s:13:"🚶‍♂️";s:19:":man_walking_tone1:";s:17:"🚶🏻‍♂️";s:19:":man_walking_tone2:";s:17:"🚶🏼‍♂️";s:19:":man_walking_tone3:";s:17:"🚶🏽‍♂️";s:19:":man_walking_tone4:";s:17:"🚶🏾‍♂️";s:19:":man_walking_tone5:";s:17:"🚶🏿‍♂️";s:20:":man_wearing_turban:";s:13:"👳‍♂️";s:26:":man_wearing_turban_tone1:";s:17:"👳🏻‍♂️";s:26:":man_wearing_turban_tone2:";s:17:"👳🏼‍♂️";s:26:":man_wearing_turban_tone3:";s:17:"👳🏽‍♂️";s:26:":man_wearing_turban_tone4:";s:17:"👳🏾‍♂️";s:26:":man_wearing_turban_tone5:";s:17:"👳🏿‍♂️";s:22:":man_with_chinese_cap:";s:4:"👲";s:28:":man_with_chinese_cap_tone1:";s:8:"👲🏻";s:28:":man_with_chinese_cap_tone2:";s:8:"👲🏼";s:28:":man_with_chinese_cap_tone3:";s:8:"👲🏽";s:28:":man_with_chinese_cap_tone4:";s:8:"👲🏾";s:28:":man_with_chinese_cap_tone5:";s:8:"👲🏿";s:21:":man_with_gua_pi_mao:";s:4:"👲";s:17:":man_with_turban:";s:4:"👳";s:12:":man_zombie:";s:13:"🧟‍♂️";s:10:":mandarin:";s:4:"🍊";s:11:":mans_shoe:";s:4:"👞";s:19:":mantelpiece_clock:";s:4:"🕰";s:5:":map:";s:7:"🗺️";s:12:":maple_leaf:";s:4:"🍁";s:18:":marshall_islands:";s:8:"🇲🇭";s:22:":martial_arts_uniform:";s:4:"🥋";s:12:":martinique:";s:8:"🇲🇶";s:6:":mask:";s:4:"😷";s:9:":massage:";s:4:"💆";s:13:":massage_man:";s:13:"💆‍♂️";s:15:":massage_woman:";s:4:"💆";s:12:":mauritania:";s:8:"🇲🇷";s:11:":mauritius:";s:8:"🇲🇺";s:9:":mayotte:";s:8:"🇾🇹";s:14:":meat_on_bone:";s:4:"🍖";s:7:":medal:";s:4:"🏅";s:16:":medal_military:";s:4:"🎖";s:14:":medal_sports:";s:4:"🏅";s:16:":medical_symbol:";s:6:"⚕️";s:6:":mega:";s:4:"📣";s:7:":melon:";s:4:"🍈";s:6:":memo:";s:4:"📝";s:30:":men_with_bunny_ears_partying:";s:13:"👯‍♂️";s:15:":men_wrestling:";s:13:"🤼‍♂️";s:9:":menorah:";s:4:"🕎";s:6:":mens:";s:4:"🚹";s:9:":mermaid:";s:17:"🧜🏿‍♀️";s:15:":mermaid_tone1:";s:17:"🧜🏻‍♀️";s:15:":mermaid_tone2:";s:17:"🧜🏼‍♀️";s:15:":mermaid_tone3:";s:17:"🧜🏽‍♀️";s:15:":mermaid_tone4:";s:17:"🧜🏾‍♀️";s:15:":mermaid_tone5:";s:17:"🧜🏿‍♀️";s:8:":merman:";s:17:"🧜🏿‍♂️";s:14:":merman_tone1:";s:17:"🧜🏻‍♂️";s:14:":merman_tone2:";s:17:"🧜🏼‍♂️";s:14:":merman_tone3:";s:17:"🧜🏽‍♂️";s:14:":merman_tone4:";s:17:"🧜🏾‍♂️";s:14:":merman_tone5:";s:17:"🧜🏿‍♂️";s:11:":merperson:";s:8:"🧜🏿";s:17:":merperson_tone1:";s:8:"🧜🏻";s:17:":merperson_tone2:";s:8:"🧜🏼";s:17:":merperson_tone3:";s:8:"🧜🏽";s:17:":merperson_tone4:";s:8:"🧜🏾";s:17:":merperson_tone5:";s:8:"🧜🏿";s:7:":metal:";s:4:"🤘";s:13:":metal_tone1:";s:8:"🤘🏻";s:13:":metal_tone2:";s:8:"🤘🏼";s:13:":metal_tone3:";s:8:"🤘🏽";s:13:":metal_tone4:";s:8:"🤘🏾";s:13:":metal_tone5:";s:8:"🤘🏿";s:7:":metro:";s:4:"🚇";s:8:":mexico:";s:8:"🇲🇽";s:12:":micronesia:";s:8:"🇫🇲";s:12:":microphone:";s:4:"🎤";s:13:":microphone2:";s:7:"🎙️";s:12:":microscope:";s:4:"🔬";s:15:":middle_finger:";s:4:"🖕";s:21:":middle_finger_tone1:";s:8:"🖕🏻";s:21:":middle_finger_tone2:";s:8:"🖕🏼";s:21:":middle_finger_tone3:";s:8:"🖕🏽";s:21:":middle_finger_tone4:";s:8:"🖕🏾";s:21:":middle_finger_tone5:";s:8:"🖕🏿";s:16:":military_medal:";s:7:"🎖️";s:6:":milk:";s:4:"🥛";s:12:":milk_glass:";s:4:"🥛";s:11:":milky_way:";s:4:"🌌";s:9:":minibus:";s:4:"🚐";s:10:":minidisc:";s:4:"💽";s:18:":mobile_phone_off:";s:4:"📴";s:9:":moldova:";s:8:"🇲🇩";s:8:":monaco:";s:8:"🇲🇨";s:13:":money_mouth:";s:4:"🤑";s:18:":money_mouth_face:";s:4:"🤑";s:18:":money_with_wings:";s:4:"💸";s:10:":moneybag:";s:4:"💰";s:10:":mongolia:";s:8:"🇲🇳";s:8:":monkey:";s:4:"🐒";s:13:":monkey_face:";s:4:"🐵";s:10:":monorail:";s:4:"🚝";s:12:":montenegro:";s:8:"🇲🇪";s:12:":montserrat:";s:8:"🇲🇸";s:6:":moon:";s:4:"🌔";s:9:":morocco:";s:8:"🇲🇦";s:14:":mortar_board:";s:4:"🎓";s:8:":mosque:";s:4:"🕌";s:12:":motor_boat:";s:4:"🛥";s:15:":motor_scooter:";s:4:"🛵";s:11:":motorboat:";s:7:"🛥️";s:12:":motorcycle:";s:4:"🏍";s:10:":motorway:";s:4:"🛣";s:12:":mount_fuji:";s:4:"🗻";s:10:":mountain:";s:3:"⛰";s:20:":mountain_bicyclist:";s:4:"🚵";s:21:":mountain_biking_man:";s:4:"🚵";s:23:":mountain_biking_woman:";s:13:"🚵‍♀️";s:19:":mountain_cableway:";s:4:"🚠";s:18:":mountain_railway:";s:4:"🚞";s:15:":mountain_snow:";s:4:"🏔";s:7:":mouse:";s:4:"🐭";s:8:":mouse2:";s:4:"🐁";s:20:":mouse_three_button:";s:7:"🖱️";s:14:":movie_camera:";s:4:"🎥";s:7:":moyai:";s:4:"🗿";s:12:":mozambique:";s:8:"🇲🇿";s:11:":mrs_claus:";s:4:"🤶";s:17:":mrs_claus_tone1:";s:8:"🤶🏻";s:17:":mrs_claus_tone2:";s:8:"🤶🏼";s:17:":mrs_claus_tone3:";s:8:"🤶🏽";s:17:":mrs_claus_tone4:";s:8:"🤶🏾";s:17:":mrs_claus_tone5:";s:8:"🤶🏿";s:8:":muscle:";s:4:"💪";s:14:":muscle_tone1:";s:8:"💪🏻";s:14:":muscle_tone2:";s:8:"💪🏼";s:14:":muscle_tone3:";s:8:"💪🏽";s:14:":muscle_tone4:";s:8:"💪🏾";s:14:":muscle_tone5:";s:8:"💪🏿";s:10:":mushroom:";s:4:"🍄";s:18:":musical_keyboard:";s:4:"🎹";s:14:":musical_note:";s:4:"🎵";s:15:":musical_score:";s:4:"🎼";s:6:":mute:";s:4:"🔇";s:9:":myanmar:";s:8:"🇲🇲";s:11:":nail_care:";s:4:"💅";s:17:":nail_care_tone1:";s:8:"💅🏻";s:17:":nail_care_tone2:";s:8:"💅🏼";s:17:":nail_care_tone3:";s:8:"💅🏽";s:17:":nail_care_tone4:";s:8:"💅🏾";s:17:":nail_care_tone5:";s:8:"💅🏿";s:12:":name_badge:";s:4:"📛";s:9:":namibia:";s:8:"🇳🇦";s:15:":national_park:";s:4:"🏞";s:7:":nauru:";s:8:"🇳🇷";s:16:":nauseated_face:";s:4:"🤢";s:9:":necktie:";s:4:"👔";s:29:":negative_squared_cross_mark:";s:3:"❎";s:7:":nepal:";s:8:"🇳🇵";s:6:":nerd:";s:4:"🤓";s:11:":nerd_face:";s:4:"🤓";s:13:":netherlands:";s:8:"🇳🇱";s:14:":neutral_face:";s:4:"😐";s:5:":new:";s:4:"🆕";s:15:":new_caledonia:";s:8:"🇳🇨";s:10:":new_moon:";s:4:"🌑";s:20:":new_moon_with_face:";s:4:"🌚";s:13:":new_zealand:";s:8:"🇳🇿";s:11:":newspaper:";s:4:"📰";s:12:":newspaper2:";s:7:"🗞️";s:16:":newspaper_roll:";s:4:"🗞";s:19:":next_track_button:";s:3:"⏭";s:4:":ng:";s:4:"🆖";s:8:":ng_man:";s:13:"🙅‍♂️";s:10:":ng_woman:";s:4:"🙅";s:11:":nicaragua:";s:8:"🇳🇮";s:7:":niger:";s:8:"🇳🇪";s:9:":nigeria:";s:8:"🇳🇬";s:18:":night_with_stars:";s:4:"🌃";s:6:":nine:";s:4:"9⃣";s:6:":niue:";s:8:"🇳🇺";s:9:":no_bell:";s:4:"🔕";s:13:":no_bicycles:";s:4:"🚳";s:10:":no_entry:";s:6:"⛔️";s:15:":no_entry_sign:";s:4:"🚫";s:9:":no_good:";s:4:"🙅";s:13:":no_good_man:";s:13:"🙅‍♂️";s:15:":no_good_woman:";s:4:"🙅";s:18:":no_mobile_phones:";s:4:"📵";s:10:":no_mouth:";s:4:"😶";s:16:":no_pedestrians:";s:4:"🚷";s:12:":no_smoking:";s:4:"🚭";s:19:":non-potable_water:";s:4:"🚱";s:16:":norfolk_island:";s:8:"🇳🇫";s:13:":north_korea:";s:8:"🇰🇵";s:26:":northern_mariana_islands:";s:8:"🇲🇵";s:8:":norway:";s:8:"🇳🇴";s:6:":nose:";s:4:"👃";s:12:":nose_tone1:";s:8:"👃🏻";s:12:":nose_tone2:";s:8:"👃🏼";s:12:":nose_tone3:";s:8:"👃🏽";s:12:":nose_tone4:";s:8:"👃🏾";s:12:":nose_tone5:";s:8:"👃🏿";s:10:":notebook:";s:4:"📓";s:32:":notebook_with_decorative_cover:";s:4:"📔";s:16:":notepad_spiral:";s:7:"🗒️";s:7:":notes:";s:4:"🎶";s:14:":nut_and_bolt:";s:4:"🔩";s:3:":o:";s:6:"⭕️";s:4:":o2:";s:7:"🅾️";s:7:":ocean:";s:4:"🌊";s:16:":octagonal_sign:";s:4:"🛑";s:9:":octopus:";s:4:"🐙";s:6:":oden:";s:4:"🍢";s:8:":office:";s:4:"🏢";s:5:":oil:";s:7:"🛢️";s:10:":oil_drum:";s:4:"🛢";s:4:":ok:";s:4:"🆗";s:9:":ok_hand:";s:4:"👌";s:15:":ok_hand_tone1:";s:8:"👌🏻";s:15:":ok_hand_tone2:";s:8:"👌🏼";s:15:":ok_hand_tone3:";s:8:"👌🏽";s:15:":ok_hand_tone4:";s:8:"👌🏾";s:15:":ok_hand_tone5:";s:8:"👌🏿";s:8:":ok_man:";s:13:"🙆‍♂️";s:10:":ok_woman:";s:4:"🙆";s:9:":old_key:";s:4:"🗝";s:13:":older_adult:";s:8:"🧓🏿";s:19:":older_adult_tone1:";s:8:"🧓🏻";s:19:":older_adult_tone2:";s:8:"🧓🏼";s:19:":older_adult_tone3:";s:8:"🧓🏽";s:19:":older_adult_tone4:";s:8:"🧓🏾";s:19:":older_adult_tone5:";s:8:"🧓🏿";s:11:":older_man:";s:4:"👴";s:17:":older_man_tone1:";s:8:"👴🏻";s:17:":older_man_tone2:";s:8:"👴🏼";s:17:":older_man_tone3:";s:8:"👴🏽";s:17:":older_man_tone4:";s:8:"👴🏾";s:17:":older_man_tone5:";s:8:"👴🏿";s:13:":older_woman:";s:4:"👵";s:19:":older_woman_tone1:";s:8:"👵🏻";s:19:":older_woman_tone2:";s:8:"👵🏼";s:19:":older_woman_tone3:";s:8:"👵🏽";s:19:":older_woman_tone4:";s:8:"👵🏾";s:19:":older_woman_tone5:";s:8:"👵🏿";s:4:":om:";s:4:"🕉";s:11:":om_symbol:";s:7:"🕉️";s:6:":oman:";s:8:"🇴🇲";s:4:":on:";s:4:"🔛";s:21:":oncoming_automobile:";s:4:"🚘";s:14:":oncoming_bus:";s:4:"🚍";s:21:":oncoming_police_car:";s:4:"🚔";s:15:":oncoming_taxi:";s:4:"🚖";s:5:":one:";s:4:"1⃣";s:11:":open_book:";s:4:"📖";s:18:":open_file_folder:";s:4:"📂";s:12:":open_hands:";s:4:"👐";s:18:":open_hands_tone1:";s:8:"👐🏻";s:18:":open_hands_tone2:";s:8:"👐🏼";s:18:":open_hands_tone3:";s:8:"👐🏽";s:18:":open_hands_tone4:";s:8:"👐🏾";s:18:":open_hands_tone5:";s:8:"👐🏿";s:12:":open_mouth:";s:4:"😮";s:15:":open_umbrella:";s:6:"☂️";s:11:":ophiuchus:";s:3:"⛎";s:8:":orange:";s:4:"🍊";s:13:":orange_book:";s:4:"📙";s:14:":orange_heart:";s:4:"🧡";s:16:":orthodox_cross:";s:6:"☦️";s:13:":outbox_tray:";s:4:"📤";s:5:":owl:";s:4:"🦉";s:4:":ox:";s:4:"🐂";s:9:":package:";s:4:"📦";s:16:":page_facing_up:";s:4:"📄";s:16:":page_with_curl:";s:4:"📃";s:7:":pager:";s:4:"📟";s:12:":paintbrush:";s:4:"🖌";s:10:":pakistan:";s:8:"🇵🇰";s:7:":palau:";s:8:"🇵🇼";s:25:":palestinian_territories:";s:8:"🇵🇸";s:11:":palm_tree:";s:4:"🌴";s:19:":palms_up_together:";s:8:"🤲🏿";s:25:":palms_up_together_tone1:";s:8:"🤲🏻";s:25:":palms_up_together_tone2:";s:8:"🤲🏼";s:25:":palms_up_together_tone3:";s:8:"🤲🏽";s:25:":palms_up_together_tone4:";s:8:"🤲🏾";s:25:":palms_up_together_tone5:";s:8:"🤲🏿";s:8:":panama:";s:8:"🇵🇦";s:10:":pancakes:";s:4:"🥞";s:12:":panda_face:";s:4:"🐼";s:11:":paperclip:";s:4:"📎";s:12:":paperclips:";s:4:"🖇";s:18:":papua_new_guinea:";s:8:"🇵🇬";s:10:":paraguay:";s:8:"🇵🇾";s:19:":parasol_on_ground:";s:3:"⛱";s:6:":park:";s:7:"🏞️";s:9:":parking:";s:7:"🅿️";s:23:":part_alternation_mark:";s:6:"〽️";s:14:":partly_sunny:";s:6:"⛅️";s:16:":passenger_ship:";s:4:"🛳";s:18:":passport_control:";s:4:"🛂";s:14:":pause_button:";s:3:"⏸";s:12:":paw_prints:";s:4:"🐾";s:7:":peace:";s:6:"☮️";s:14:":peace_symbol:";s:6:"☮️";s:7:":peach:";s:4:"🍑";s:9:":peanuts:";s:4:"🥜";s:6:":pear:";s:4:"🍐";s:5:":pen:";s:4:"🖊";s:15:":pen_ballpoint:";s:7:"🖊️";s:14:":pen_fountain:";s:7:"🖋️";s:8:":pencil:";s:4:"📝";s:9:":pencil2:";s:6:"✏️";s:9:":penguin:";s:4:"🐧";s:9:":pensive:";s:4:"😔";s:33:":people_with_bunny_ears_partying:";s:4:"👯";s:18:":people_wrestling:";s:4:"🤼";s:17:":performing_arts:";s:4:"🎭";s:11:":persevere:";s:4:"😣";s:15:":person_biking:";s:8:"🚴🏿";s:21:":person_biking_tone1:";s:8:"🚴🏻";s:21:":person_biking_tone2:";s:8:"🚴🏼";s:21:":person_biking_tone3:";s:8:"🚴🏽";s:21:":person_biking_tone4:";s:8:"🚴🏾";s:21:":person_biking_tone5:";s:8:"🚴🏿";s:22:":person_bouncing_ball:";s:7:"⛹🏿";s:28:":person_bouncing_ball_tone1:";s:7:"⛹🏻";s:28:":person_bouncing_ball_tone2:";s:7:"⛹🏼";s:28:":person_bouncing_ball_tone3:";s:7:"⛹🏽";s:28:":person_bouncing_ball_tone4:";s:7:"⛹🏾";s:28:":person_bouncing_ball_tone5:";s:7:"⛹🏿";s:15:":person_bowing:";s:8:"🙇🏿";s:21:":person_bowing_tone1:";s:8:"🙇🏻";s:21:":person_bowing_tone2:";s:8:"🙇🏼";s:21:":person_bowing_tone3:";s:8:"🙇🏽";s:21:":person_bowing_tone4:";s:8:"🙇🏾";s:21:":person_bowing_tone5:";s:8:"🙇🏿";s:17:":person_climbing:";s:8:"🧗🏿";s:23:":person_climbing_tone1:";s:8:"🧗🏻";s:23:":person_climbing_tone2:";s:8:"🧗🏼";s:23:":person_climbing_tone3:";s:8:"🧗🏽";s:23:":person_climbing_tone4:";s:8:"🧗🏾";s:23:":person_climbing_tone5:";s:8:"🧗🏿";s:24:":person_doing_cartwheel:";s:4:"🤸";s:30:":person_doing_cartwheel_tone1:";s:8:"🤸🏻";s:30:":person_doing_cartwheel_tone2:";s:8:"🤸🏼";s:30:":person_doing_cartwheel_tone3:";s:8:"🤸🏽";s:30:":person_doing_cartwheel_tone4:";s:8:"🤸🏾";s:30:":person_doing_cartwheel_tone5:";s:8:"🤸🏿";s:20:":person_facepalming:";s:8:"🤦🏿";s:26:":person_facepalming_tone1:";s:8:"🤦🏻";s:26:":person_facepalming_tone2:";s:8:"🤦🏼";s:26:":person_facepalming_tone3:";s:8:"🤦🏽";s:26:":person_facepalming_tone4:";s:8:"🤦🏾";s:26:":person_facepalming_tone5:";s:8:"🤦🏿";s:16:":person_fencing:";s:4:"🤺";s:17:":person_frowning:";s:4:"🙍";s:23:":person_frowning_tone1:";s:8:"🙍🏻";s:23:":person_frowning_tone2:";s:8:"🙍🏼";s:23:":person_frowning_tone3:";s:8:"🙍🏽";s:23:":person_frowning_tone4:";s:8:"🙍🏾";s:23:":person_frowning_tone5:";s:8:"🙍🏿";s:21:":person_gesturing_no:";s:4:"🙅";s:27:":person_gesturing_no_tone1:";s:8:"🙅🏻";s:27:":person_gesturing_no_tone2:";s:8:"🙅🏼";s:27:":person_gesturing_no_tone3:";s:8:"🙅🏽";s:27:":person_gesturing_no_tone4:";s:8:"🙅🏾";s:27:":person_gesturing_no_tone5:";s:8:"🙅🏿";s:21:":person_gesturing_ok:";s:4:"🙆";s:27:":person_gesturing_ok_tone1:";s:8:"🙆🏻";s:27:":person_gesturing_ok_tone2:";s:8:"🙆🏼";s:27:":person_gesturing_ok_tone3:";s:8:"🙆🏽";s:27:":person_gesturing_ok_tone4:";s:8:"🙆🏾";s:27:":person_gesturing_ok_tone5:";s:8:"🙆🏿";s:24:":person_getting_haircut:";s:8:"💇🏿";s:30:":person_getting_haircut_tone1:";s:8:"💇🏻";s:30:":person_getting_haircut_tone2:";s:8:"💇🏼";s:30:":person_getting_haircut_tone3:";s:8:"💇🏽";s:30:":person_getting_haircut_tone4:";s:8:"💇🏾";s:30:":person_getting_haircut_tone5:";s:8:"💇🏿";s:24:":person_getting_massage:";s:8:"💆🏿";s:30:":person_getting_massage_tone1:";s:8:"💆🏻";s:30:":person_getting_massage_tone2:";s:8:"💆🏼";s:30:":person_getting_massage_tone3:";s:8:"💆🏽";s:30:":person_getting_massage_tone4:";s:8:"💆🏾";s:30:":person_getting_massage_tone5:";s:8:"💆🏿";s:16:":person_golfing:";s:8:"🏌🏿";s:22:":person_golfing_tone1:";s:8:"🏌🏻";s:22:":person_golfing_tone2:";s:8:"🏌🏼";s:22:":person_golfing_tone3:";s:8:"🏌🏽";s:22:":person_golfing_tone4:";s:8:"🏌🏾";s:22:":person_golfing_tone5:";s:8:"🏌🏿";s:21:":person_in_bed_tone1:";s:8:"🛌🏻";s:21:":person_in_bed_tone2:";s:8:"🛌🏼";s:21:":person_in_bed_tone3:";s:8:"🛌🏽";s:21:":person_in_bed_tone4:";s:8:"🛌🏾";s:21:":person_in_bed_tone5:";s:8:"🛌🏿";s:26:":person_in_lotus_position:";s:8:"🧘🏿";s:32:":person_in_lotus_position_tone1:";s:8:"🧘🏻";s:32:":person_in_lotus_position_tone2:";s:8:"🧘🏼";s:32:":person_in_lotus_position_tone3:";s:8:"🧘🏽";s:32:":person_in_lotus_position_tone4:";s:8:"🧘🏾";s:32:":person_in_lotus_position_tone5:";s:8:"🧘🏿";s:23:":person_in_steamy_room:";s:8:"🧖🏿";s:29:":person_in_steamy_room_tone1:";s:8:"🧖🏻";s:29:":person_in_steamy_room_tone2:";s:8:"🧖🏼";s:29:":person_in_steamy_room_tone3:";s:8:"🧖🏽";s:29:":person_in_steamy_room_tone4:";s:8:"🧖🏾";s:29:":person_in_steamy_room_tone5:";s:8:"🧖🏿";s:17:":person_juggling:";s:8:"🤹🏿";s:23:":person_juggling_tone1:";s:8:"🤹🏻";s:23:":person_juggling_tone2:";s:8:"🤹🏼";s:23:":person_juggling_tone3:";s:8:"🤹🏽";s:23:":person_juggling_tone4:";s:8:"🤹🏾";s:23:":person_juggling_tone5:";s:8:"🤹🏿";s:24:":person_lifting_weights:";s:8:"🏋🏿";s:30:":person_lifting_weights_tone1:";s:8:"🏋🏻";s:30:":person_lifting_weights_tone2:";s:8:"🏋🏼";s:30:":person_lifting_weights_tone3:";s:8:"🏋🏽";s:30:":person_lifting_weights_tone4:";s:8:"🏋🏾";s:30:":person_lifting_weights_tone5:";s:8:"🏋🏿";s:24:":person_mountain_biking:";s:8:"🚵🏿";s:30:":person_mountain_biking_tone1:";s:8:"🚵🏻";s:30:":person_mountain_biking_tone2:";s:8:"🚵🏼";s:30:":person_mountain_biking_tone3:";s:8:"🚵🏽";s:30:":person_mountain_biking_tone4:";s:8:"🚵🏾";s:30:":person_mountain_biking_tone5:";s:8:"🚵🏿";s:25:":person_playing_handball:";s:8:"🤾🏿";s:31:":person_playing_handball_tone1:";s:8:"🤾🏻";s:31:":person_playing_handball_tone2:";s:8:"🤾🏼";s:31:":person_playing_handball_tone3:";s:8:"🤾🏽";s:31:":person_playing_handball_tone4:";s:8:"🤾🏾";s:31:":person_playing_handball_tone5:";s:8:"🤾🏿";s:27:":person_playing_water_polo:";s:8:"🤽🏿";s:33:":person_playing_water_polo_tone1:";s:8:"🤽🏻";s:33:":person_playing_water_polo_tone2:";s:8:"🤽🏼";s:33:":person_playing_water_polo_tone3:";s:8:"🤽🏽";s:33:":person_playing_water_polo_tone4:";s:8:"🤽🏾";s:33:":person_playing_water_polo_tone5:";s:8:"🤽🏿";s:16:":person_pouting:";s:8:"🙎🏿";s:22:":person_pouting_tone1:";s:8:"🙎🏻";s:22:":person_pouting_tone2:";s:8:"🙎🏼";s:22:":person_pouting_tone3:";s:8:"🙎🏽";s:22:":person_pouting_tone4:";s:8:"🙎🏾";s:22:":person_pouting_tone5:";s:8:"🙎🏿";s:21:":person_raising_hand:";s:8:"🙋🏿";s:27:":person_raising_hand_tone1:";s:8:"🙋🏻";s:27:":person_raising_hand_tone2:";s:8:"🙋🏼";s:27:":person_raising_hand_tone3:";s:8:"🙋🏽";s:27:":person_raising_hand_tone4:";s:8:"🙋🏾";s:27:":person_raising_hand_tone5:";s:8:"🙋🏿";s:20:":person_rowing_boat:";s:8:"🚣🏿";s:26:":person_rowing_boat_tone1:";s:8:"🚣🏻";s:26:":person_rowing_boat_tone2:";s:8:"🚣🏼";s:26:":person_rowing_boat_tone3:";s:8:"🚣🏽";s:26:":person_rowing_boat_tone4:";s:8:"🚣🏾";s:26:":person_rowing_boat_tone5:";s:8:"🚣🏿";s:16:":person_running:";s:8:"🏃🏿";s:22:":person_running_tone1:";s:8:"🏃🏻";s:22:":person_running_tone2:";s:8:"🏃🏼";s:22:":person_running_tone3:";s:8:"🏃🏽";s:22:":person_running_tone4:";s:8:"🏃🏾";s:22:":person_running_tone5:";s:8:"🏃🏿";s:18:":person_shrugging:";s:8:"🤷🏿";s:24:":person_shrugging_tone1:";s:8:"🤷🏻";s:24:":person_shrugging_tone2:";s:8:"🤷🏼";s:24:":person_shrugging_tone3:";s:8:"🤷🏽";s:24:":person_shrugging_tone4:";s:8:"🤷🏾";s:24:":person_shrugging_tone5:";s:8:"🤷🏿";s:16:":person_surfing:";s:8:"🏄🏿";s:22:":person_surfing_tone1:";s:8:"🏄🏻";s:22:":person_surfing_tone2:";s:8:"🏄🏼";s:22:":person_surfing_tone3:";s:8:"🏄🏽";s:22:":person_surfing_tone4:";s:8:"🏄🏾";s:22:":person_surfing_tone5:";s:8:"🏄🏿";s:17:":person_swimming:";s:8:"🏊🏿";s:23:":person_swimming_tone1:";s:8:"🏊🏻";s:23:":person_swimming_tone2:";s:8:"🏊🏼";s:23:":person_swimming_tone3:";s:8:"🏊🏽";s:23:":person_swimming_tone4:";s:8:"🏊🏾";s:23:":person_swimming_tone5:";s:8:"🏊🏿";s:21:":person_tipping_hand:";s:8:"💁🏿";s:27:":person_tipping_hand_tone1:";s:8:"💁🏻";s:27:":person_tipping_hand_tone2:";s:8:"💁🏼";s:27:":person_tipping_hand_tone3:";s:8:"💁🏽";s:27:":person_tipping_hand_tone4:";s:8:"💁🏾";s:27:":person_tipping_hand_tone5:";s:8:"💁🏿";s:16:":person_walking:";s:8:"🚶🏿";s:22:":person_walking_tone1:";s:8:"🚶🏻";s:22:":person_walking_tone2:";s:8:"🚶🏼";s:22:":person_walking_tone3:";s:8:"🚶🏽";s:22:":person_walking_tone4:";s:8:"🚶🏾";s:22:":person_walking_tone5:";s:8:"🚶🏿";s:23:":person_wearing_turban:";s:8:"👳🏿";s:29:":person_wearing_turban_tone1:";s:8:"👳🏻";s:29:":person_wearing_turban_tone2:";s:8:"👳🏼";s:29:":person_wearing_turban_tone3:";s:8:"👳🏽";s:29:":person_wearing_turban_tone4:";s:8:"👳🏾";s:29:":person_wearing_turban_tone5:";s:8:"👳🏿";s:24:":person_with_blond_hair:";s:4:"👱";s:26:":person_with_pouting_face:";s:4:"🙎";s:6:":peru:";s:8:"🇵🇪";s:13:":philippines:";s:8:"🇵🇭";s:7:":phone:";s:6:"☎️";s:6:":pick:";s:3:"⛏";s:5:":pie:";s:4:"🥧";s:5:":pig:";s:4:"🐷";s:6:":pig2:";s:4:"🐖";s:10:":pig_nose:";s:4:"🐽";s:6:":pill:";s:4:"💊";s:11:":pineapple:";s:4:"🍍";s:11:":ping_pong:";s:4:"🏓";s:8:":pisces:";s:6:"♓️";s:18:":pitcairn_islands:";s:8:"🇵🇳";s:7:":pizza:";s:4:"🍕";s:18:":place_of_worship:";s:4:"🛐";s:20:":plate_with_cutlery:";s:4:"🍽";s:22:":play_or_pause_button:";s:3:"⏯";s:12:":play_pause:";s:6:"⏯️";s:12:":point_down:";s:4:"👇";s:18:":point_down_tone1:";s:8:"👇🏻";s:18:":point_down_tone2:";s:8:"👇🏼";s:18:":point_down_tone3:";s:8:"👇🏽";s:18:":point_down_tone4:";s:8:"👇🏾";s:18:":point_down_tone5:";s:8:"👇🏿";s:12:":point_left:";s:4:"👈";s:18:":point_left_tone1:";s:8:"👈🏻";s:18:":point_left_tone2:";s:8:"👈🏼";s:18:":point_left_tone3:";s:8:"👈🏽";s:18:":point_left_tone4:";s:8:"👈🏾";s:18:":point_left_tone5:";s:8:"👈🏿";s:13:":point_right:";s:4:"👉";s:19:":point_right_tone1:";s:8:"👉🏻";s:19:":point_right_tone2:";s:8:"👉🏼";s:19:":point_right_tone3:";s:8:"👉🏽";s:19:":point_right_tone4:";s:8:"👉🏾";s:19:":point_right_tone5:";s:8:"👉🏿";s:10:":point_up:";s:6:"☝️";s:12:":point_up_2:";s:4:"👆";s:18:":point_up_2_tone1:";s:8:"👆🏻";s:18:":point_up_2_tone2:";s:8:"👆🏼";s:18:":point_up_2_tone3:";s:8:"👆🏽";s:18:":point_up_2_tone4:";s:8:"👆🏾";s:18:":point_up_2_tone5:";s:8:"👆🏿";s:16:":point_up_tone1:";s:7:"☝🏻";s:16:":point_up_tone2:";s:7:"☝🏼";s:16:":point_up_tone3:";s:7:"☝🏽";s:16:":point_up_tone4:";s:7:"☝🏾";s:16:":point_up_tone5:";s:7:"☝🏿";s:8:":poland:";s:8:"🇵🇱";s:12:":police_car:";s:4:"🚓";s:16:":police_officer:";s:8:"👮🏿";s:22:":police_officer_tone1:";s:8:"👮🏻";s:22:":police_officer_tone2:";s:8:"👮🏼";s:22:":police_officer_tone3:";s:8:"👮🏽";s:22:":police_officer_tone4:";s:8:"👮🏾";s:22:":police_officer_tone5:";s:8:"👮🏿";s:11:":policeman:";s:4:"👮";s:13:":policewoman:";s:13:"👮‍♀️";s:8:":poodle:";s:4:"🐩";s:6:":poop:";s:4:"💩";s:9:":popcorn:";s:4:"🍿";s:10:":portugal:";s:8:"🇵🇹";s:13:":post_office:";s:4:"🏣";s:13:":postal_horn:";s:4:"📯";s:9:":postbox:";s:4:"📮";s:15:":potable_water:";s:4:"🚰";s:8:":potato:";s:4:"🥔";s:7:":pouch:";s:4:"👝";s:13:":poultry_leg:";s:4:"🍗";s:7:":pound:";s:4:"💷";s:14:":pound_symbol:";s:1:"#";s:6:":pout:";s:4:"😡";s:13:":pouting_cat:";s:4:"😾";s:13:":pouting_man:";s:13:"🙎‍♂️";s:15:":pouting_woman:";s:4:"🙎";s:6:":pray:";s:4:"🙏";s:12:":pray_tone1:";s:8:"🙏🏻";s:12:":pray_tone2:";s:8:"🙏🏼";s:12:":pray_tone3:";s:8:"🙏🏽";s:12:":pray_tone4:";s:8:"🙏🏾";s:12:":pray_tone5:";s:8:"🙏🏿";s:14:":prayer_beads:";s:4:"📿";s:16:":pregnant_woman:";s:4:"🤰";s:22:":pregnant_woman_tone1:";s:8:"🤰🏻";s:22:":pregnant_woman_tone2:";s:8:"🤰🏼";s:22:":pregnant_woman_tone3:";s:8:"🤰🏽";s:22:":pregnant_woman_tone4:";s:8:"🤰🏾";s:22:":pregnant_woman_tone5:";s:8:"🤰🏿";s:9:":pretzel:";s:4:"🥨";s:23:":previous_track_button:";s:3:"⏮";s:8:":prince:";s:4:"🤴";s:14:":prince_tone1:";s:8:"🤴🏻";s:14:":prince_tone2:";s:8:"🤴🏼";s:14:":prince_tone3:";s:8:"🤴🏽";s:14:":prince_tone4:";s:8:"🤴🏾";s:14:":prince_tone5:";s:8:"🤴🏿";s:10:":princess:";s:4:"👸";s:16:":princess_tone1:";s:8:"👸🏻";s:16:":princess_tone2:";s:8:"👸🏼";s:16:":princess_tone3:";s:8:"👸🏽";s:16:":princess_tone4:";s:8:"👸🏾";s:16:":princess_tone5:";s:8:"👸🏿";s:9:":printer:";s:4:"🖨";s:11:":projector:";s:7:"📽️";s:13:":puerto_rico:";s:8:"🇵🇷";s:7:":punch:";s:4:"👊";s:13:":punch_tone1:";s:8:"👊🏻";s:13:":punch_tone2:";s:8:"👊🏼";s:13:":punch_tone3:";s:8:"👊🏽";s:13:":punch_tone4:";s:8:"👊🏾";s:13:":punch_tone5:";s:8:"👊🏿";s:14:":purple_heart:";s:4:"💜";s:7:":purse:";s:4:"👛";s:9:":pushpin:";s:4:"📌";s:25:":put_litter_in_its_place:";s:4:"🚮";s:7:":qatar:";s:8:"🇶🇦";s:10:":question:";s:3:"❓";s:8:":rabbit:";s:4:"🐰";s:9:":rabbit2:";s:4:"🐇";s:10:":race_car:";s:7:"🏎️";s:11:":racehorse:";s:4:"🐎";s:12:":racing_car:";s:4:"🏎";s:7:":radio:";s:4:"📻";s:14:":radio_button:";s:4:"🔘";s:13:":radioactive:";s:6:"☢️";s:6:":rage:";s:4:"😡";s:13:":railway_car:";s:4:"🚃";s:15:":railway_track:";s:4:"🛤";s:9:":rainbow:";s:4:"🌈";s:14:":rainbow_flag:";s:14:"🏳️‍🌈";s:21:":raised_back_of_hand:";s:4:"🤚";s:27:":raised_back_of_hand_tone1:";s:8:"🤚🏻";s:27:":raised_back_of_hand_tone2:";s:8:"🤚🏼";s:27:":raised_back_of_hand_tone3:";s:8:"🤚🏽";s:27:":raised_back_of_hand_tone4:";s:8:"🤚🏾";s:27:":raised_back_of_hand_tone5:";s:8:"🤚🏿";s:13:":raised_hand:";s:3:"✋";s:19:":raised_hand_tone1:";s:7:"✋🏻";s:19:":raised_hand_tone2:";s:7:"✋🏼";s:19:":raised_hand_tone3:";s:7:"✋🏽";s:19:":raised_hand_tone4:";s:7:"✋🏾";s:19:":raised_hand_tone5:";s:7:"✋🏿";s:34:":raised_hand_with_fingers_splayed:";s:4:"🖐";s:14:":raised_hands:";s:4:"🙌";s:20:":raised_hands_tone1:";s:8:"🙌🏻";s:20:":raised_hands_tone2:";s:8:"🙌🏼";s:20:":raised_hands_tone3:";s:8:"🙌🏽";s:20:":raised_hands_tone4:";s:8:"🙌🏾";s:20:":raised_hands_tone5:";s:8:"🙌🏿";s:14:":raising_hand:";s:4:"🙋";s:18:":raising_hand_man:";s:13:"🙋‍♂️";s:20:":raising_hand_woman:";s:4:"🙋";s:5:":ram:";s:4:"🐏";s:7:":ramen:";s:4:"🍜";s:5:":rat:";s:4:"🐀";s:15:":record_button:";s:3:"⏺";s:9:":recycle:";s:6:"♻️";s:9:":red_car:";s:4:"🚗";s:12:":red_circle:";s:4:"🔴";s:22:":regional_indicator_a:";s:4:"🇦";s:22:":regional_indicator_b:";s:4:"🇧";s:22:":regional_indicator_c:";s:4:"🇨";s:22:":regional_indicator_d:";s:4:"🇩";s:22:":regional_indicator_e:";s:4:"🇪";s:22:":regional_indicator_f:";s:4:"🇫";s:22:":regional_indicator_g:";s:4:"🇬";s:22:":regional_indicator_h:";s:4:"🇭";s:22:":regional_indicator_i:";s:4:"🇮";s:22:":regional_indicator_j:";s:4:"🇯";s:22:":regional_indicator_k:";s:4:"🇰";s:22:":regional_indicator_l:";s:4:"🇱";s:22:":regional_indicator_m:";s:4:"🇲";s:22:":regional_indicator_n:";s:4:"🇳";s:22:":regional_indicator_o:";s:4:"🇴";s:22:":regional_indicator_p:";s:4:"🇵";s:22:":regional_indicator_q:";s:4:"🇶";s:22:":regional_indicator_r:";s:4:"🇷";s:22:":regional_indicator_s:";s:4:"🇸";s:22:":regional_indicator_t:";s:4:"🇹";s:22:":regional_indicator_u:";s:4:"🇺";s:22:":regional_indicator_v:";s:4:"🇻";s:22:":regional_indicator_w:";s:4:"🇼";s:22:":regional_indicator_x:";s:4:"🇽";s:22:":regional_indicator_y:";s:4:"🇾";s:22:":regional_indicator_z:";s:4:"🇿";s:12:":registered:";s:5:"®️";s:9:":relaxed:";s:6:"☺️";s:10:":relieved:";s:4:"😌";s:17:":reminder_ribbon:";s:4:"🎗";s:8:":repeat:";s:4:"🔁";s:12:":repeat_one:";s:4:"🔂";s:22:":rescue_worker_helmet:";s:3:"⛑";s:10:":restroom:";s:4:"🚻";s:9:":reunion:";s:8:"🇷🇪";s:18:":revolving_hearts:";s:4:"💞";s:8:":rewind:";s:3:"⏪";s:7:":rhino:";s:4:"🦏";s:12:":rhinoceros:";s:4:"🦏";s:8:":ribbon:";s:4:"🎀";s:6:":rice:";s:4:"🍚";s:11:":rice_ball:";s:4:"🍙";s:14:":rice_cracker:";s:4:"🍘";s:12:":rice_scene:";s:4:"🎑";s:20:":right_anger_bubble:";s:4:"🗯";s:19:":right_facing_fist:";s:4:"🤜";s:25:":right_facing_fist_tone1:";s:8:"🤜🏻";s:25:":right_facing_fist_tone2:";s:8:"🤜🏼";s:25:":right_facing_fist_tone3:";s:8:"🤜🏽";s:25:":right_facing_fist_tone4:";s:8:"🤜🏾";s:25:":right_facing_fist_tone5:";s:8:"🤜🏿";s:6:":ring:";s:4:"💍";s:7:":robot:";s:4:"🤖";s:8:":rocket:";s:4:"🚀";s:6:":rofl:";s:4:"🤣";s:11:":roll_eyes:";s:4:"🙄";s:16:":roller_coaster:";s:4:"🎢";s:14:":rolling_eyes:";s:4:"🙄";s:9:":romania:";s:8:"🇷🇴";s:9:":rooster:";s:4:"🐓";s:6:":rose:";s:4:"🌹";s:9:":rosette:";s:4:"🏵";s:16:":rotating_light:";s:4:"🚨";s:15:":round_pushpin:";s:4:"📍";s:9:":rowboat:";s:4:"🚣";s:12:":rowing_man:";s:4:"🚣";s:14:":rowing_woman:";s:13:"🚣‍♀️";s:4:":ru:";s:8:"🇷🇺";s:16:":rugby_football:";s:4:"🏉";s:8:":runner:";s:4:"🏃";s:9:":running:";s:4:"🏃";s:13:":running_man:";s:4:"🏃";s:25:":running_shirt_with_sash:";s:4:"🎽";s:15:":running_woman:";s:13:"🏃‍♀️";s:8:":rwanda:";s:8:"🇷🇼";s:4:":sa:";s:7:"🈂️";s:13:":sagittarius:";s:6:"♐️";s:10:":sailboat:";s:6:"⛵️";s:6:":sake:";s:4:"🍶";s:7:":salad:";s:4:"🥗";s:7:":samoa:";s:8:"🇼🇸";s:12:":san_marino:";s:8:"🇸🇲";s:8:":sandal:";s:4:"👡";s:10:":sandwich:";s:4:"🥪";s:7:":santa:";s:4:"🎅";s:13:":santa_tone1:";s:8:"🎅🏻";s:13:":santa_tone2:";s:8:"🎅🏼";s:13:":santa_tone3:";s:8:"🎅🏽";s:13:":santa_tone4:";s:8:"🎅🏾";s:13:":santa_tone5:";s:8:"🎅🏿";s:19:":sao_tome_principe:";s:8:"🇸🇹";s:11:":sassy_man:";s:13:"💁‍♂️";s:13:":sassy_woman:";s:4:"💁";s:11:":satellite:";s:4:"📡";s:19:":satellite_orbital:";s:7:"🛰️";s:11:":satisfied:";s:4:"😆";s:14:":saudi_arabia:";s:8:"🇸🇦";s:10:":sauropod:";s:4:"🦕";s:11:":saxophone:";s:4:"🎷";s:8:":scales:";s:6:"⚖️";s:7:":scarf:";s:4:"🧣";s:8:":school:";s:4:"🏫";s:16:":school_satchel:";s:4:"🎒";s:10:":scissors:";s:6:"✂️";s:9:":scooter:";s:4:"🛴";s:10:":scorpion:";s:4:"🦂";s:10:":scorpius:";s:6:"♏️";s:10:":scotland:";s:28:"🏴󠁧󠁢󠁳󠁣󠁴󠁿";s:8:":scream:";s:4:"😱";s:12:":scream_cat:";s:4:"🙀";s:8:":scroll:";s:4:"📜";s:6:":seat:";s:4:"💺";s:14:":second_place:";s:4:"🥈";s:8:":secret:";s:6:"㊙️";s:13:":see_no_evil:";s:4:"🙈";s:10:":seedling:";s:4:"🌱";s:8:":selfie:";s:4:"🤳";s:14:":selfie_tone1:";s:8:"🤳🏻";s:14:":selfie_tone2:";s:8:"🤳🏼";s:14:":selfie_tone3:";s:8:"🤳🏽";s:14:":selfie_tone4:";s:8:"🤳🏾";s:14:":selfie_tone5:";s:8:"🤳🏿";s:9:":senegal:";s:8:"🇸🇳";s:8:":serbia:";s:8:"🇷🇸";s:7:":seven:";s:4:"7⃣";s:12:":seychelles:";s:8:"🇸🇨";s:21:":shallow_pan_of_food:";s:4:"🥘";s:10:":shamrock:";s:6:"☘️";s:7:":shark:";s:4:"🦈";s:12:":shaved_ice:";s:4:"🍧";s:7:":sheep:";s:4:"🐑";s:7:":shell:";s:4:"🐚";s:8:":shield:";s:4:"🛡";s:15:":shinto_shrine:";s:3:"⛩";s:6:":ship:";s:4:"🚢";s:7:":shirt:";s:4:"👕";s:6:":shit:";s:4:"💩";s:6:":shoe:";s:4:"👞";s:10:":shopping:";s:4:"🛍";s:15:":shopping_bags:";s:7:"🛍️";s:15:":shopping_cart:";s:4:"🛒";s:8:":shower:";s:4:"🚿";s:8:":shrimp:";s:4:"🦐";s:15:":shushing_face:";s:4:"🤫";s:14:":sierra_leone:";s:8:"🇸🇱";s:17:":signal_strength:";s:4:"📶";s:11:":singapore:";s:8:"🇸🇬";s:14:":sint_maarten:";s:8:"🇸🇽";s:5:":six:";s:4:"6⃣";s:18:":six_pointed_star:";s:4:"🔯";s:5:":ski:";s:4:"🎿";s:7:":skier:";s:3:"⛷";s:7:":skull:";s:4:"💀";s:22:":skull_and_crossbones:";s:6:"☠️";s:18:":skull_crossbones:";s:6:"☠️";s:6:":sled:";s:4:"🛷";s:10:":sleeping:";s:4:"😴";s:24:":sleeping_accommodation:";s:4:"🛌";s:14:":sleeping_bed:";s:4:"🛌";s:8:":sleepy:";s:4:"😪";s:14:":slight_frown:";s:4:"🙁";s:14:":slight_smile:";s:4:"🙂";s:24:":slightly_frowning_face:";s:4:"🙁";s:23:":slightly_smiling_face:";s:4:"🙂";s:14:":slot_machine:";s:4:"🎰";s:10:":slovakia:";s:8:"🇸🇰";s:10:":slovenia:";s:8:"🇸🇮";s:16:":small_airplane:";s:4:"🛩";s:20:":small_blue_diamond:";s:4:"🔹";s:22:":small_orange_diamond:";s:4:"🔸";s:20:":small_red_triangle:";s:4:"🔺";s:25:":small_red_triangle_down:";s:4:"🔻";s:7:":smile:";s:4:"😄";s:11:":smile_cat:";s:4:"😸";s:8:":smiley:";s:4:"😃";s:12:":smiley_cat:";s:4:"😺";s:13:":smiling_imp:";s:4:"😈";s:7:":smirk:";s:4:"😏";s:11:":smirk_cat:";s:4:"😼";s:9:":smoking:";s:4:"🚬";s:7:":snail:";s:4:"🐌";s:7:":snake:";s:4:"🐍";s:15:":sneezing_face:";s:4:"🤧";s:13:":snowboarder:";s:4:"🏂";s:19:":snowboarder_tone1:";s:8:"🏂🏻";s:19:":snowboarder_tone2:";s:8:"🏂🏼";s:19:":snowboarder_tone3:";s:8:"🏂🏽";s:19:":snowboarder_tone4:";s:8:"🏂🏾";s:19:":snowboarder_tone5:";s:8:"🏂🏿";s:11:":snowflake:";s:6:"❄️";s:9:":snowman:";s:6:"⛄️";s:10:":snowman2:";s:6:"☃️";s:19:":snowman_with_snow:";s:6:"☃️";s:5:":sob:";s:4:"😭";s:8:":soccer:";s:6:"⚽️";s:7:":socks:";s:4:"🧦";s:17:":solomon_islands:";s:8:"🇸🇧";s:9:":somalia:";s:8:"🇸🇴";s:6:":soon:";s:4:"🔜";s:5:":sos:";s:4:"🆘";s:7:":sound:";s:4:"🔉";s:14:":south_africa:";s:8:"🇿🇦";s:38:":south_georgia_south_sandwich_islands:";s:8:"🇬🇸";s:13:":south_sudan:";s:8:"🇸🇸";s:15:":space_invader:";s:4:"👾";s:8:":spades:";s:6:"♠️";s:11:":spaghetti:";s:4:"🍝";s:9:":sparkle:";s:6:"❇️";s:10:":sparkler:";s:4:"🎇";s:10:":sparkles:";s:3:"✨";s:17:":sparkling_heart:";s:4:"💖";s:15:":speak_no_evil:";s:4:"🙊";s:9:":speaker:";s:4:"🔈";s:15:":speaking_head:";s:4:"🗣";s:16:":speech_balloon:";s:4:"💬";s:13:":speech_left:";s:7:"🗨️";s:11:":speedboat:";s:4:"🚤";s:8:":spider:";s:4:"🕷";s:12:":spider_web:";s:4:"🕸";s:17:":spiral_calendar:";s:4:"🗓";s:16:":spiral_notepad:";s:4:"🗒";s:7:":spoon:";s:4:"🥄";s:7:":squid:";s:4:"🦑";s:11:":sri_lanka:";s:8:"🇱🇰";s:15:":st_barthelemy:";s:8:"🇧🇱";s:11:":st_helena:";s:8:"🇸🇭";s:16:":st_kitts_nevis:";s:8:"🇰🇳";s:10:":st_lucia:";s:8:"🇱🇨";s:20:":st_pierre_miquelon:";s:8:"🇵🇲";s:23:":st_vincent_grenadines:";s:8:"🇻🇨";s:9:":stadium:";s:4:"🏟";s:6:":star:";s:6:"⭐️";s:7:":star2:";s:4:"🌟";s:19:":star_and_crescent:";s:6:"☪️";s:15:":star_of_david:";s:6:"✡️";s:13:":star_struck:";s:4:"🤩";s:7:":stars:";s:4:"🌠";s:9:":station:";s:4:"🚉";s:19:":statue_of_liberty:";s:4:"🗽";s:18:":steam_locomotive:";s:4:"🚂";s:6:":stew:";s:4:"🍲";s:13:":stop_button:";s:3:"⏹";s:11:":stop_sign:";s:4:"🛑";s:11:":stopwatch:";s:3:"⏱";s:16:":straight_ruler:";s:4:"📏";s:12:":strawberry:";s:4:"🍓";s:18:":stuck_out_tongue:";s:4:"😛";s:30:":stuck_out_tongue_closed_eyes:";s:4:"😝";s:30:":stuck_out_tongue_winking_eye:";s:4:"😜";s:19:":studio_microphone:";s:4:"🎙";s:19:":stuffed_flatbread:";s:4:"🥙";s:7:":sudan:";s:8:"🇸🇩";s:24:":sun_behind_large_cloud:";s:4:"🌥";s:23:":sun_behind_rain_cloud:";s:4:"🌦";s:24:":sun_behind_small_cloud:";s:4:"🌤";s:15:":sun_with_face:";s:4:"🌞";s:11:":sunflower:";s:4:"🌻";s:12:":sunglasses:";s:4:"😎";s:7:":sunny:";s:6:"☀️";s:9:":sunrise:";s:4:"🌅";s:24:":sunrise_over_mountains:";s:4:"🌄";s:8:":surfer:";s:4:"🏄";s:13:":surfing_man:";s:4:"🏄";s:15:":surfing_woman:";s:13:"🏄‍♀️";s:10:":suriname:";s:8:"🇸🇷";s:7:":sushi:";s:4:"🍣";s:20:":suspension_railway:";s:4:"🚟";s:11:":swaziland:";s:8:"🇸🇿";s:7:":sweat:";s:4:"😓";s:13:":sweat_drops:";s:4:"💦";s:13:":sweat_smile:";s:4:"😅";s:8:":sweden:";s:8:"🇸🇪";s:14:":sweet_potato:";s:4:"🍠";s:9:":swimmer:";s:4:"🏊";s:14:":swimming_man:";s:4:"🏊";s:16:":swimming_woman:";s:13:"🏊‍♀️";s:13:":switzerland:";s:8:"🇨🇭";s:9:":symbols:";s:4:"🔣";s:11:":synagogue:";s:4:"🕍";s:7:":syria:";s:8:"🇸🇾";s:9:":syringe:";s:4:"💉";s:7:":t_rex:";s:4:"🦖";s:6:":taco:";s:4:"🌮";s:6:":tada:";s:4:"🎉";s:8:":taiwan:";s:8:"🇹🇼";s:12:":tajikistan:";s:8:"🇹🇯";s:13:":takeout_box:";s:4:"🥡";s:15:":tanabata_tree:";s:4:"🎋";s:11:":tangerine:";s:4:"🍊";s:10:":tanzania:";s:8:"🇹🇿";s:8:":taurus:";s:6:"♉️";s:6:":taxi:";s:4:"🚕";s:5:":tea:";s:4:"🍵";s:11:":telephone:";s:6:"☎️";s:20:":telephone_receiver:";s:4:"📞";s:11:":telescope:";s:4:"🔭";s:8:":tennis:";s:4:"🎾";s:6:":tent:";s:6:"⛺️";s:10:":thailand:";s:8:"🇹🇭";s:13:":thermometer:";s:4:"🌡";s:18:":thermometer_face:";s:4:"🤒";s:10:":thinking:";s:4:"🤔";s:13:":third_place:";s:4:"🥉";s:17:":thought_balloon:";s:4:"💭";s:7:":three:";s:4:"3⃣";s:12:":thumbsdown:";s:4:"👎";s:18:":thumbsdown_tone1:";s:8:"👎🏻";s:18:":thumbsdown_tone2:";s:8:"👎🏼";s:18:":thumbsdown_tone3:";s:8:"👎🏽";s:18:":thumbsdown_tone4:";s:8:"👎🏾";s:18:":thumbsdown_tone5:";s:8:"👎🏿";s:10:":thumbsup:";s:4:"👍";s:16:":thumbsup_tone1:";s:8:"👍🏻";s:16:":thumbsup_tone2:";s:8:"👍🏼";s:16:":thumbsup_tone3:";s:8:"👍🏽";s:16:":thumbsup_tone4:";s:8:"👍🏾";s:16:":thumbsup_tone5:";s:8:"👍🏿";s:20:":thunder_cloud_rain:";s:6:"⛈️";s:8:":ticket:";s:4:"🎫";s:9:":tickets:";s:4:"🎟";s:7:":tiger:";s:4:"🐯";s:8:":tiger2:";s:4:"🐅";s:7:":timer:";s:6:"⏲️";s:13:":timer_clock:";s:3:"⏲";s:13:":timor_leste:";s:8:"🇹🇱";s:18:":tipping_hand_man:";s:13:"💁‍♂️";s:20:":tipping_hand_woman:";s:4:"💁";s:12:":tired_face:";s:4:"😫";s:4:":tm:";s:6:"™️";s:6:":togo:";s:8:"🇹🇬";s:8:":toilet:";s:4:"🚽";s:9:":tokelau:";s:8:"🇹🇰";s:13:":tokyo_tower:";s:4:"🗼";s:8:":tomato:";s:4:"🍅";s:7:":tone1:";s:4:"🏻";s:7:":tone2:";s:4:"🏼";s:7:":tone3:";s:4:"🏽";s:7:":tone4:";s:4:"🏾";s:7:":tone5:";s:4:"🏿";s:7:":tonga:";s:8:"🇹🇴";s:8:":tongue:";s:4:"👅";s:7:":tools:";s:7:"🛠️";s:5:":top:";s:4:"🔝";s:8:":tophat:";s:4:"🎩";s:9:":tornado:";s:4:"🌪";s:4:":tr:";s:8:"🇹🇷";s:12:":track_next:";s:6:"⏭️";s:16:":track_previous:";s:6:"⏮️";s:11:":trackball:";s:4:"🖲";s:9:":tractor:";s:4:"🚜";s:15:":traffic_light:";s:4:"🚥";s:7:":train:";s:4:"🚋";s:8:":train2:";s:4:"🚆";s:6:":tram:";s:4:"🚊";s:25:":triangular_flag_on_post:";s:4:"🚩";s:18:":triangular_ruler:";s:4:"📐";s:9:":trident:";s:4:"🔱";s:17:":trinidad_tobago:";s:8:"🇹🇹";s:9:":triumph:";s:4:"😤";s:12:":trolleybus:";s:4:"🚎";s:8:":trophy:";s:4:"🏆";s:16:":tropical_drink:";s:4:"🍹";s:15:":tropical_fish:";s:4:"🐠";s:7:":truck:";s:4:"🚚";s:9:":trumpet:";s:4:"🎺";s:8:":tshirt:";s:4:"👕";s:7:":tulip:";s:4:"🌷";s:15:":tumbler_glass:";s:4:"🥃";s:9:":tunisia:";s:8:"🇹🇳";s:8:":turkey:";s:4:"🦃";s:14:":turkmenistan:";s:8:"🇹🇲";s:22:":turks_caicos_islands:";s:8:"🇹🇨";s:8:":turtle:";s:4:"🐢";s:8:":tuvalu:";s:8:"🇹🇻";s:4:":tv:";s:4:"📺";s:27:":twisted_rightwards_arrows:";s:4:"🔀";s:5:":two:";s:4:"2⃣";s:12:":two_hearts:";s:4:"💕";s:23:":two_men_holding_hands:";s:4:"👬";s:25:":two_women_holding_hands:";s:4:"👭";s:7:":u5272:";s:4:"🈹";s:7:":u5408:";s:4:"🈴";s:7:":u55b6:";s:4:"🈺";s:7:":u6307:";s:7:"🈯️";s:7:":u6708:";s:7:"🈷️";s:7:":u6709:";s:4:"🈶";s:7:":u6e80:";s:4:"🈵";s:7:":u7121:";s:7:"🈚️";s:7:":u7533:";s:4:"🈸";s:7:":u7981:";s:4:"🈲";s:7:":u7a7a:";s:4:"🈳";s:8:":uganda:";s:8:"🇺🇬";s:4:":uk:";s:8:"🇬🇧";s:9:":ukraine:";s:8:"🇺🇦";s:10:":umbrella:";s:6:"☔️";s:11:":umbrella2:";s:6:"☂️";s:10:":unamused:";s:4:"😒";s:10:":underage:";s:4:"🔞";s:9:":unicorn:";s:4:"🦄";s:22:":united_arab_emirates:";s:8:"🇦🇪";s:16:":united_nations:";s:8:"🇺🇳";s:8:":unlock:";s:4:"🔓";s:4:":up:";s:4:"🆙";s:13:":upside_down:";s:4:"🙃";s:18:":upside_down_face:";s:4:"🙃";s:5:":urn:";s:6:"⚱️";s:9:":uruguay:";s:8:"🇺🇾";s:4:":us:";s:8:"🇺🇸";s:19:":us_virgin_islands:";s:8:"🇻🇮";s:12:":uzbekistan:";s:8:"🇺🇿";s:3:":v:";s:6:"✌️";s:9:":v_tone1:";s:7:"✌🏻";s:9:":v_tone2:";s:7:"✌🏼";s:9:":v_tone3:";s:7:"✌🏽";s:9:":v_tone4:";s:7:"✌🏾";s:9:":v_tone5:";s:7:"✌🏿";s:9:":vampire:";s:8:"🧛🏿";s:15:":vampire_tone1:";s:8:"🧛🏻";s:15:":vampire_tone2:";s:8:"🧛🏼";s:15:":vampire_tone3:";s:8:"🧛🏽";s:15:":vampire_tone4:";s:8:"🧛🏾";s:15:":vampire_tone5:";s:8:"🧛🏿";s:9:":vanuatu:";s:8:"🇻🇺";s:14:":vatican_city:";s:8:"🇻🇦";s:11:":venezuela:";s:8:"🇻🇪";s:24:":vertical_traffic_light:";s:4:"🚦";s:5:":vhs:";s:4:"📼";s:16:":vibration_mode:";s:4:"📳";s:14:":video_camera:";s:4:"📹";s:12:":video_game:";s:4:"🎮";s:9:":vietnam:";s:8:"🇻🇳";s:8:":violin:";s:4:"🎻";s:7:":virgo:";s:6:"♍️";s:9:":volcano:";s:4:"🌋";s:12:":volleyball:";s:4:"🏐";s:4:":vs:";s:4:"🆚";s:8:":vulcan:";s:4:"🖖";s:15:":vulcan_salute:";s:4:"🖖";s:14:":vulcan_tone1:";s:8:"🖖🏻";s:14:":vulcan_tone2:";s:8:"🖖🏼";s:14:":vulcan_tone3:";s:8:"🖖🏽";s:14:":vulcan_tone4:";s:8:"🖖🏾";s:14:":vulcan_tone5:";s:8:"🖖🏿";s:7:":wales:";s:28:"🏴󠁧󠁢󠁷󠁬󠁳󠁿";s:9:":walking:";s:4:"🚶";s:13:":walking_man:";s:4:"🚶";s:15:":walking_woman:";s:13:"🚶‍♀️";s:15:":wallis_futuna:";s:8:"🇼🇫";s:22:":waning_crescent_moon:";s:4:"🌘";s:21:":waning_gibbous_moon:";s:4:"🌖";s:9:":warning:";s:6:"⚠️";s:13:":wastebasket:";s:4:"🗑";s:7:":watch:";s:6:"⌚️";s:15:":water_buffalo:";s:4:"🐃";s:12:":watermelon:";s:4:"🍉";s:6:":wave:";s:4:"👋";s:12:":wave_tone1:";s:8:"👋🏻";s:12:":wave_tone2:";s:8:"👋🏼";s:12:":wave_tone3:";s:8:"👋🏽";s:12:":wave_tone4:";s:8:"👋🏾";s:12:":wave_tone5:";s:8:"👋🏿";s:11:":wavy_dash:";s:6:"〰️";s:22:":waxing_crescent_moon:";s:4:"🌒";s:21:":waxing_gibbous_moon:";s:4:"🌔";s:4:":wc:";s:4:"🚾";s:7:":weary:";s:4:"😩";s:9:":wedding:";s:4:"💒";s:20:":weight_lifting_man:";s:4:"🏋";s:22:":weight_lifting_woman:";s:16:"🏋️‍♀️";s:16:":western_sahara:";s:8:"🇪🇭";s:7:":whale:";s:4:"🐳";s:8:":whale2:";s:4:"🐋";s:17:":wheel_of_dharma:";s:6:"☸️";s:12:":wheelchair:";s:6:"♿️";s:18:":white_check_mark:";s:3:"✅";s:14:":white_circle:";s:6:"⚪️";s:12:":white_flag:";s:7:"🏳️";s:14:":white_flower:";s:4:"💮";s:20:":white_large_square:";s:6:"⬜️";s:27:":white_medium_small_square:";s:6:"◽️";s:21:":white_medium_square:";s:6:"◻️";s:20:":white_small_square:";s:6:"▫️";s:21:":white_square_button:";s:4:"🔳";s:17:":white_sun_cloud:";s:7:"🌥️";s:22:":white_sun_rain_cloud:";s:7:"🌦️";s:23:":white_sun_small_cloud:";s:7:"🌤️";s:15:":wilted_flower:";s:4:"🥀";s:13:":wilted_rose:";s:4:"🥀";s:19:":wind_blowing_face:";s:7:"🌬️";s:12:":wind_chime:";s:4:"🎐";s:11:":wind_face:";s:4:"🌬";s:12:":wine_glass:";s:4:"🍷";s:6:":wink:";s:4:"😉";s:6:":wolf:";s:4:"🐺";s:7:":woman:";s:4:"👩";s:14:":woman_artist:";s:11:"👩‍🎨";s:20:":woman_artist_tone1:";s:15:"👩🏻‍🎨";s:20:":woman_artist_tone2:";s:15:"👩🏼‍🎨";s:20:":woman_artist_tone3:";s:15:"👩🏽‍🎨";s:20:":woman_artist_tone4:";s:15:"👩🏾‍🎨";s:20:":woman_artist_tone5:";s:15:"👩🏿‍🎨";s:17:":woman_astronaut:";s:11:"👩‍🚀";s:23:":woman_astronaut_tone1:";s:15:"👩🏻‍🚀";s:23:":woman_astronaut_tone2:";s:15:"👩🏼‍🚀";s:23:":woman_astronaut_tone3:";s:15:"👩🏽‍🚀";s:23:":woman_astronaut_tone4:";s:15:"👩🏾‍🚀";s:23:":woman_astronaut_tone5:";s:15:"👩🏿‍🚀";s:14:":woman_biking:";s:13:"🚴‍♀️";s:20:":woman_biking_tone1:";s:17:"🚴🏻‍♀️";s:20:":woman_biking_tone2:";s:17:"🚴🏼‍♀️";s:20:":woman_biking_tone3:";s:17:"🚴🏽‍♀️";s:20:":woman_biking_tone4:";s:17:"🚴🏾‍♀️";s:20:":woman_biking_tone5:";s:17:"🚴🏿‍♀️";s:21:":woman_bouncing_ball:";s:15:"⛹️‍♀️";s:27:":woman_bouncing_ball_tone1:";s:16:"⛹🏻‍♀️";s:27:":woman_bouncing_ball_tone2:";s:16:"⛹🏼‍♀️";s:27:":woman_bouncing_ball_tone3:";s:16:"⛹🏽‍♀️";s:27:":woman_bouncing_ball_tone4:";s:16:"⛹🏾‍♀️";s:27:":woman_bouncing_ball_tone5:";s:16:"⛹🏿‍♀️";s:14:":woman_bowing:";s:13:"🙇‍♀️";s:20:":woman_bowing_tone1:";s:17:"🙇🏻‍♀️";s:20:":woman_bowing_tone2:";s:17:"🙇🏼‍♀️";s:20:":woman_bowing_tone3:";s:17:"🙇🏽‍♀️";s:20:":woman_bowing_tone4:";s:17:"🙇🏾‍♀️";s:20:":woman_bowing_tone5:";s:17:"🙇🏿‍♀️";s:20:":woman_cartwheeling:";s:13:"🤸‍♀️";s:26:":woman_cartwheeling_tone1:";s:17:"🤸🏻‍♀️";s:26:":woman_cartwheeling_tone2:";s:17:"🤸🏼‍♀️";s:26:":woman_cartwheeling_tone3:";s:17:"🤸🏽‍♀️";s:26:":woman_cartwheeling_tone4:";s:17:"🤸🏾‍♀️";s:26:":woman_cartwheeling_tone5:";s:17:"🤸🏿‍♀️";s:16:":woman_climbing:";s:17:"🧗🏿‍♀️";s:22:":woman_climbing_tone1:";s:17:"🧗🏻‍♀️";s:22:":woman_climbing_tone2:";s:17:"🧗🏼‍♀️";s:22:":woman_climbing_tone3:";s:17:"🧗🏽‍♀️";s:22:":woman_climbing_tone4:";s:17:"🧗🏾‍♀️";s:22:":woman_climbing_tone5:";s:17:"🧗🏿‍♀️";s:27:":woman_construction_worker:";s:13:"👷‍♀️";s:33:":woman_construction_worker_tone1:";s:17:"👷🏻‍♀️";s:33:":woman_construction_worker_tone2:";s:17:"👷🏼‍♀️";s:33:":woman_construction_worker_tone3:";s:17:"👷🏽‍♀️";s:33:":woman_construction_worker_tone4:";s:17:"👷🏾‍♀️";s:33:":woman_construction_worker_tone5:";s:17:"👷🏿‍♀️";s:12:":woman_cook:";s:11:"👩‍🍳";s:18:":woman_cook_tone1:";s:15:"👩🏻‍🍳";s:18:":woman_cook_tone2:";s:15:"👩🏼‍🍳";s:18:":woman_cook_tone3:";s:15:"👩🏽‍🍳";s:18:":woman_cook_tone4:";s:15:"👩🏾‍🍳";s:18:":woman_cook_tone5:";s:15:"👩🏿‍🍳";s:17:":woman_detective:";s:16:"🕵️‍♀️";s:23:":woman_detective_tone1:";s:17:"🕵🏻‍♀️";s:23:":woman_detective_tone2:";s:17:"🕵🏼‍♀️";s:23:":woman_detective_tone3:";s:17:"🕵🏽‍♀️";s:23:":woman_detective_tone4:";s:17:"🕵🏾‍♀️";s:23:":woman_detective_tone5:";s:17:"🕵🏿‍♀️";s:11:":woman_elf:";s:17:"🧝🏿‍♀️";s:17:":woman_elf_tone1:";s:17:"🧝🏻‍♀️";s:17:":woman_elf_tone2:";s:17:"🧝🏼‍♀️";s:17:":woman_elf_tone3:";s:17:"🧝🏽‍♀️";s:17:":woman_elf_tone4:";s:17:"🧝🏾‍♀️";s:17:":woman_elf_tone5:";s:17:"🧝🏿‍♀️";s:19:":woman_facepalming:";s:13:"🤦‍♀️";s:25:":woman_facepalming_tone1:";s:17:"🤦🏻‍♀️";s:25:":woman_facepalming_tone2:";s:17:"🤦🏼‍♀️";s:25:":woman_facepalming_tone3:";s:17:"🤦🏽‍♀️";s:25:":woman_facepalming_tone4:";s:17:"🤦🏾‍♀️";s:25:":woman_facepalming_tone5:";s:17:"🤦🏿‍♀️";s:22:":woman_factory_worker:";s:11:"👩‍🏭";s:28:":woman_factory_worker_tone1:";s:15:"👩🏻‍🏭";s:28:":woman_factory_worker_tone2:";s:15:"👩🏼‍🏭";s:28:":woman_factory_worker_tone3:";s:15:"👩🏽‍🏭";s:28:":woman_factory_worker_tone4:";s:15:"👩🏾‍🏭";s:28:":woman_factory_worker_tone5:";s:15:"👩🏿‍🏭";s:13:":woman_fairy:";s:17:"🧚🏿‍♀️";s:19:":woman_fairy_tone1:";s:17:"🧚🏻‍♀️";s:19:":woman_fairy_tone2:";s:17:"🧚🏼‍♀️";s:19:":woman_fairy_tone3:";s:17:"🧚🏽‍♀️";s:19:":woman_fairy_tone4:";s:17:"🧚🏾‍♀️";s:19:":woman_fairy_tone5:";s:17:"🧚🏿‍♀️";s:14:":woman_farmer:";s:11:"👩‍🌾";s:20:":woman_farmer_tone1:";s:15:"👩🏻‍🌾";s:20:":woman_farmer_tone2:";s:15:"👩🏼‍🌾";s:20:":woman_farmer_tone3:";s:15:"👩🏽‍🌾";s:20:":woman_farmer_tone4:";s:15:"👩🏾‍🌾";s:20:":woman_farmer_tone5:";s:15:"👩🏿‍🌾";s:19:":woman_firefighter:";s:11:"👩‍🚒";s:25:":woman_firefighter_tone1:";s:15:"👩🏻‍🚒";s:25:":woman_firefighter_tone2:";s:15:"👩🏼‍🚒";s:25:":woman_firefighter_tone3:";s:15:"👩🏽‍🚒";s:25:":woman_firefighter_tone4:";s:15:"👩🏾‍🚒";s:25:":woman_firefighter_tone5:";s:15:"👩🏿‍🚒";s:16:":woman_frowning:";s:13:"🙍‍♀️";s:22:":woman_frowning_tone1:";s:17:"🙍🏻‍♀️";s:22:":woman_frowning_tone2:";s:17:"🙍🏼‍♀️";s:22:":woman_frowning_tone3:";s:17:"🙍🏽‍♀️";s:22:":woman_frowning_tone4:";s:17:"🙍🏾‍♀️";s:22:":woman_frowning_tone5:";s:17:"🙍🏿‍♀️";s:13:":woman_genie:";s:13:"🧞‍♀️";s:20:":woman_gesturing_no:";s:13:"🙅‍♀️";s:26:":woman_gesturing_no_tone1:";s:17:"🙅🏻‍♀️";s:26:":woman_gesturing_no_tone2:";s:17:"🙅🏼‍♀️";s:26:":woman_gesturing_no_tone3:";s:17:"🙅🏽‍♀️";s:26:":woman_gesturing_no_tone4:";s:17:"🙅🏾‍♀️";s:26:":woman_gesturing_no_tone5:";s:17:"🙅🏿‍♀️";s:20:":woman_gesturing_ok:";s:13:"🙆‍♀️";s:26:":woman_gesturing_ok_tone1:";s:17:"🙆🏻‍♀️";s:26:":woman_gesturing_ok_tone2:";s:17:"🙆🏼‍♀️";s:26:":woman_gesturing_ok_tone3:";s:17:"🙆🏽‍♀️";s:26:":woman_gesturing_ok_tone4:";s:17:"🙆🏾‍♀️";s:26:":woman_gesturing_ok_tone5:";s:17:"🙆🏿‍♀️";s:28:":woman_getting_face_massage:";s:13:"💆‍♀️";s:34:":woman_getting_face_massage_tone1:";s:17:"💆🏻‍♀️";s:34:":woman_getting_face_massage_tone2:";s:17:"💆🏼‍♀️";s:34:":woman_getting_face_massage_tone3:";s:17:"💆🏽‍♀️";s:34:":woman_getting_face_massage_tone4:";s:17:"💆🏾‍♀️";s:34:":woman_getting_face_massage_tone5:";s:17:"💆🏿‍♀️";s:23:":woman_getting_haircut:";s:13:"💇‍♀️";s:29:":woman_getting_haircut_tone1:";s:17:"💇🏻‍♀️";s:29:":woman_getting_haircut_tone2:";s:17:"💇🏼‍♀️";s:29:":woman_getting_haircut_tone3:";s:17:"💇🏽‍♀️";s:29:":woman_getting_haircut_tone4:";s:17:"💇🏾‍♀️";s:29:":woman_getting_haircut_tone5:";s:17:"💇🏿‍♀️";s:15:":woman_golfing:";s:17:"🏌🏿‍♀️";s:21:":woman_golfing_tone1:";s:17:"🏌🏻‍♀️";s:21:":woman_golfing_tone2:";s:17:"🏌🏼‍♀️";s:21:":woman_golfing_tone3:";s:17:"🏌🏽‍♀️";s:21:":woman_golfing_tone4:";s:17:"🏌🏾‍♀️";s:21:":woman_golfing_tone5:";s:17:"🏌🏿‍♀️";s:13:":woman_guard:";s:13:"💂‍♀️";s:19:":woman_guard_tone1:";s:17:"💂🏻‍♀️";s:19:":woman_guard_tone2:";s:17:"💂🏼‍♀️";s:19:":woman_guard_tone3:";s:17:"💂🏽‍♀️";s:19:":woman_guard_tone4:";s:17:"💂🏾‍♀️";s:19:":woman_guard_tone5:";s:17:"💂🏿‍♀️";s:21:":woman_health_worker:";s:13:"👩‍⚕️";s:27:":woman_health_worker_tone1:";s:17:"👩🏻‍⚕️";s:27:":woman_health_worker_tone2:";s:17:"👩🏼‍⚕️";s:27:":woman_health_worker_tone3:";s:17:"👩🏽‍⚕️";s:27:":woman_health_worker_tone4:";s:17:"👩🏾‍⚕️";s:27:":woman_health_worker_tone5:";s:17:"👩🏿‍⚕️";s:25:":woman_in_lotus_position:";s:17:"🧘🏿‍♀️";s:31:":woman_in_lotus_position_tone1:";s:17:"🧘🏻‍♀️";s:31:":woman_in_lotus_position_tone2:";s:17:"🧘🏼‍♀️";s:31:":woman_in_lotus_position_tone3:";s:17:"🧘🏽‍♀️";s:31:":woman_in_lotus_position_tone4:";s:17:"🧘🏾‍♀️";s:31:":woman_in_lotus_position_tone5:";s:17:"🧘🏿‍♀️";s:22:":woman_in_steamy_room:";s:17:"🧖🏿‍♀️";s:28:":woman_in_steamy_room_tone1:";s:17:"🧖🏻‍♀️";s:28:":woman_in_steamy_room_tone2:";s:17:"🧖🏼‍♀️";s:28:":woman_in_steamy_room_tone3:";s:17:"🧖🏽‍♀️";s:28:":woman_in_steamy_room_tone4:";s:17:"🧖🏾‍♀️";s:28:":woman_in_steamy_room_tone5:";s:17:"🧖🏿‍♀️";s:13:":woman_judge:";s:13:"👩‍⚖️";s:19:":woman_judge_tone1:";s:17:"👩🏻‍⚖️";s:19:":woman_judge_tone2:";s:17:"👩🏼‍⚖️";s:19:":woman_judge_tone3:";s:17:"👩🏽‍⚖️";s:19:":woman_judge_tone4:";s:17:"👩🏾‍⚖️";s:19:":woman_judge_tone5:";s:17:"👩🏿‍⚖️";s:16:":woman_juggling:";s:13:"🤹‍♀️";s:22:":woman_juggling_tone1:";s:17:"🤹🏻‍♀️";s:22:":woman_juggling_tone2:";s:17:"🤹🏼‍♀️";s:22:":woman_juggling_tone3:";s:17:"🤹🏽‍♀️";s:22:":woman_juggling_tone4:";s:17:"🤹🏾‍♀️";s:22:":woman_juggling_tone5:";s:17:"🤹🏿‍♀️";s:23:":woman_lifting_weights:";s:16:"🏋️‍♀️";s:29:":woman_lifting_weights_tone1:";s:17:"🏋🏻‍♀️";s:29:":woman_lifting_weights_tone2:";s:17:"🏋🏼‍♀️";s:29:":woman_lifting_weights_tone3:";s:17:"🏋🏽‍♀️";s:29:":woman_lifting_weights_tone4:";s:17:"🏋🏾‍♀️";s:29:":woman_lifting_weights_tone5:";s:17:"🏋🏿‍♀️";s:12:":woman_mage:";s:17:"🧙🏿‍♀️";s:18:":woman_mage_tone1:";s:17:"🧙🏻‍♀️";s:18:":woman_mage_tone2:";s:17:"🧙🏼‍♀️";s:18:":woman_mage_tone3:";s:17:"🧙🏽‍♀️";s:18:":woman_mage_tone4:";s:17:"🧙🏾‍♀️";s:18:":woman_mage_tone5:";s:17:"🧙🏿‍♀️";s:16:":woman_mechanic:";s:11:"👩‍🔧";s:22:":woman_mechanic_tone1:";s:15:"👩🏻‍🔧";s:22:":woman_mechanic_tone2:";s:15:"👩🏼‍🔧";s:22:":woman_mechanic_tone3:";s:15:"👩🏽‍🔧";s:22:":woman_mechanic_tone4:";s:15:"👩🏾‍🔧";s:22:":woman_mechanic_tone5:";s:15:"👩🏿‍🔧";s:23:":woman_mountain_biking:";s:13:"🚵‍♀️";s:29:":woman_mountain_biking_tone1:";s:17:"🚵🏻‍♀️";s:29:":woman_mountain_biking_tone2:";s:17:"🚵🏼‍♀️";s:29:":woman_mountain_biking_tone3:";s:17:"🚵🏽‍♀️";s:29:":woman_mountain_biking_tone4:";s:17:"🚵🏾‍♀️";s:29:":woman_mountain_biking_tone5:";s:17:"🚵🏿‍♀️";s:21:":woman_office_worker:";s:11:"👩‍💼";s:27:":woman_office_worker_tone1:";s:15:"👩🏻‍💼";s:27:":woman_office_worker_tone2:";s:15:"👩🏼‍💼";s:27:":woman_office_worker_tone3:";s:15:"👩🏽‍💼";s:27:":woman_office_worker_tone4:";s:15:"👩🏾‍💼";s:27:":woman_office_worker_tone5:";s:15:"👩🏿‍💼";s:13:":woman_pilot:";s:13:"👩‍✈️";s:19:":woman_pilot_tone1:";s:17:"👩🏻‍✈️";s:19:":woman_pilot_tone2:";s:17:"👩🏼‍✈️";s:19:":woman_pilot_tone3:";s:17:"👩🏽‍✈️";s:19:":woman_pilot_tone4:";s:17:"👩🏾‍✈️";s:19:":woman_pilot_tone5:";s:17:"👩🏿‍✈️";s:24:":woman_playing_handball:";s:13:"🤾‍♀️";s:30:":woman_playing_handball_tone1:";s:17:"🤾🏻‍♀️";s:30:":woman_playing_handball_tone2:";s:17:"🤾🏼‍♀️";s:30:":woman_playing_handball_tone3:";s:17:"🤾🏽‍♀️";s:30:":woman_playing_handball_tone4:";s:17:"🤾🏾‍♀️";s:30:":woman_playing_handball_tone5:";s:17:"🤾🏿‍♀️";s:26:":woman_playing_water_polo:";s:13:"🤽‍♀️";s:32:":woman_playing_water_polo_tone1:";s:17:"🤽🏻‍♀️";s:32:":woman_playing_water_polo_tone2:";s:17:"🤽🏼‍♀️";s:32:":woman_playing_water_polo_tone3:";s:17:"🤽🏽‍♀️";s:32:":woman_playing_water_polo_tone4:";s:17:"🤽🏾‍♀️";s:32:":woman_playing_water_polo_tone5:";s:17:"🤽🏿‍♀️";s:22:":woman_police_officer:";s:13:"👮‍♀️";s:28:":woman_police_officer_tone1:";s:17:"👮🏻‍♀️";s:28:":woman_police_officer_tone2:";s:17:"👮🏼‍♀️";s:28:":woman_police_officer_tone3:";s:17:"👮🏽‍♀️";s:28:":woman_police_officer_tone4:";s:17:"👮🏾‍♀️";s:28:":woman_police_officer_tone5:";s:17:"👮🏿‍♀️";s:15:":woman_pouting:";s:13:"🙎‍♀️";s:21:":woman_pouting_tone1:";s:17:"🙎🏻‍♀️";s:21:":woman_pouting_tone2:";s:17:"🙎🏼‍♀️";s:21:":woman_pouting_tone3:";s:17:"🙎🏽‍♀️";s:21:":woman_pouting_tone4:";s:17:"🙎🏾‍♀️";s:21:":woman_pouting_tone5:";s:17:"🙎🏿‍♀️";s:20:":woman_raising_hand:";s:13:"🙋‍♀️";s:26:":woman_raising_hand_tone1:";s:17:"🙋🏻‍♀️";s:26:":woman_raising_hand_tone2:";s:17:"🙋🏼‍♀️";s:26:":woman_raising_hand_tone3:";s:17:"🙋🏽‍♀️";s:26:":woman_raising_hand_tone4:";s:17:"🙋🏾‍♀️";s:26:":woman_raising_hand_tone5:";s:17:"🙋🏿‍♀️";s:19:":woman_rowing_boat:";s:13:"🚣‍♀️";s:25:":woman_rowing_boat_tone1:";s:17:"🚣🏻‍♀️";s:25:":woman_rowing_boat_tone2:";s:17:"🚣🏼‍♀️";s:25:":woman_rowing_boat_tone3:";s:17:"🚣🏽‍♀️";s:25:":woman_rowing_boat_tone4:";s:17:"🚣🏾‍♀️";s:25:":woman_rowing_boat_tone5:";s:17:"🚣🏿‍♀️";s:15:":woman_running:";s:13:"🏃‍♀️";s:21:":woman_running_tone1:";s:17:"🏃🏻‍♀️";s:21:":woman_running_tone2:";s:17:"🏃🏼‍♀️";s:21:":woman_running_tone3:";s:17:"🏃🏽‍♀️";s:21:":woman_running_tone4:";s:17:"🏃🏾‍♀️";s:21:":woman_running_tone5:";s:17:"🏃🏿‍♀️";s:17:":woman_scientist:";s:11:"👩‍🔬";s:23:":woman_scientist_tone1:";s:15:"👩🏻‍🔬";s:23:":woman_scientist_tone2:";s:15:"👩🏼‍🔬";s:23:":woman_scientist_tone3:";s:15:"👩🏽‍🔬";s:23:":woman_scientist_tone4:";s:15:"👩🏾‍🔬";s:23:":woman_scientist_tone5:";s:15:"👩🏿‍🔬";s:17:":woman_shrugging:";s:13:"🤷‍♀️";s:23:":woman_shrugging_tone1:";s:17:"🤷🏻‍♀️";s:23:":woman_shrugging_tone2:";s:17:"🤷🏼‍♀️";s:23:":woman_shrugging_tone3:";s:17:"🤷🏽‍♀️";s:23:":woman_shrugging_tone4:";s:17:"🤷🏾‍♀️";s:23:":woman_shrugging_tone5:";s:17:"🤷🏿‍♀️";s:14:":woman_singer:";s:11:"👩‍🎤";s:20:":woman_singer_tone1:";s:15:"👩🏻‍🎤";s:20:":woman_singer_tone2:";s:15:"👩🏼‍🎤";s:20:":woman_singer_tone3:";s:15:"👩🏽‍🎤";s:20:":woman_singer_tone4:";s:15:"👩🏾‍🎤";s:20:":woman_singer_tone5:";s:15:"👩🏿‍🎤";s:15:":woman_student:";s:11:"👩‍🎓";s:21:":woman_student_tone1:";s:15:"👩🏻‍🎓";s:21:":woman_student_tone2:";s:15:"👩🏼‍🎓";s:21:":woman_student_tone3:";s:15:"👩🏽‍🎓";s:21:":woman_student_tone4:";s:15:"👩🏾‍🎓";s:21:":woman_student_tone5:";s:15:"👩🏿‍🎓";s:15:":woman_surfing:";s:13:"🏄‍♀️";s:21:":woman_surfing_tone1:";s:17:"🏄🏻‍♀️";s:21:":woman_surfing_tone2:";s:17:"🏄🏼‍♀️";s:21:":woman_surfing_tone3:";s:17:"🏄🏽‍♀️";s:21:":woman_surfing_tone4:";s:17:"🏄🏾‍♀️";s:21:":woman_surfing_tone5:";s:17:"🏄🏿‍♀️";s:16:":woman_swimming:";s:13:"🏊‍♀️";s:22:":woman_swimming_tone1:";s:17:"🏊🏻‍♀️";s:22:":woman_swimming_tone2:";s:17:"🏊🏼‍♀️";s:22:":woman_swimming_tone3:";s:17:"🏊🏽‍♀️";s:22:":woman_swimming_tone4:";s:17:"🏊🏾‍♀️";s:22:":woman_swimming_tone5:";s:17:"🏊🏿‍♀️";s:15:":woman_teacher:";s:11:"👩‍🏫";s:21:":woman_teacher_tone1:";s:15:"👩🏻‍🏫";s:21:":woman_teacher_tone2:";s:15:"👩🏼‍🏫";s:21:":woman_teacher_tone3:";s:15:"👩🏽‍🏫";s:21:":woman_teacher_tone4:";s:15:"👩🏾‍🏫";s:21:":woman_teacher_tone5:";s:15:"👩🏿‍🏫";s:20:":woman_technologist:";s:11:"👩‍💻";s:26:":woman_technologist_tone1:";s:15:"👩🏻‍💻";s:26:":woman_technologist_tone2:";s:15:"👩🏼‍💻";s:26:":woman_technologist_tone3:";s:15:"👩🏽‍💻";s:26:":woman_technologist_tone4:";s:15:"👩🏾‍💻";s:26:":woman_technologist_tone5:";s:15:"👩🏿‍💻";s:20:":woman_tipping_hand:";s:13:"💁‍♀️";s:26:":woman_tipping_hand_tone1:";s:17:"💁🏻‍♀️";s:26:":woman_tipping_hand_tone2:";s:17:"💁🏼‍♀️";s:26:":woman_tipping_hand_tone3:";s:17:"💁🏽‍♀️";s:26:":woman_tipping_hand_tone4:";s:17:"💁🏾‍♀️";s:26:":woman_tipping_hand_tone5:";s:17:"💁🏿‍♀️";s:13:":woman_tone1:";s:8:"👩🏻";s:13:":woman_tone2:";s:8:"👩🏼";s:13:":woman_tone3:";s:8:"👩🏽";s:13:":woman_tone4:";s:8:"👩🏾";s:13:":woman_tone5:";s:8:"👩🏿";s:15:":woman_vampire:";s:17:"🧛🏿‍♀️";s:21:":woman_vampire_tone1:";s:17:"🧛🏻‍♀️";s:21:":woman_vampire_tone2:";s:17:"🧛🏼‍♀️";s:21:":woman_vampire_tone3:";s:17:"🧛🏽‍♀️";s:21:":woman_vampire_tone4:";s:17:"🧛🏾‍♀️";s:21:":woman_vampire_tone5:";s:17:"🧛🏿‍♀️";s:15:":woman_walking:";s:13:"🚶‍♀️";s:21:":woman_walking_tone1:";s:17:"🚶🏻‍♀️";s:21:":woman_walking_tone2:";s:17:"🚶🏼‍♀️";s:21:":woman_walking_tone3:";s:17:"🚶🏽‍♀️";s:21:":woman_walking_tone4:";s:17:"🚶🏾‍♀️";s:21:":woman_walking_tone5:";s:17:"🚶🏿‍♀️";s:22:":woman_wearing_turban:";s:13:"👳‍♀️";s:28:":woman_wearing_turban_tone1:";s:17:"👳🏻‍♀️";s:28:":woman_wearing_turban_tone2:";s:17:"👳🏼‍♀️";s:28:":woman_wearing_turban_tone3:";s:17:"👳🏽‍♀️";s:28:":woman_wearing_turban_tone4:";s:17:"👳🏾‍♀️";s:28:":woman_wearing_turban_tone5:";s:17:"👳🏿‍♀️";s:22:":woman_with_headscarf:";s:8:"🧕🏿";s:28:":woman_with_headscarf_tone1:";s:8:"🧕🏻";s:28:":woman_with_headscarf_tone2:";s:8:"🧕🏼";s:28:":woman_with_headscarf_tone3:";s:8:"🧕🏽";s:28:":woman_with_headscarf_tone4:";s:8:"🧕🏾";s:28:":woman_with_headscarf_tone5:";s:8:"🧕🏿";s:19:":woman_with_turban:";s:13:"👳‍♀️";s:14:":woman_zombie:";s:13:"🧟‍♀️";s:16:":womans_clothes:";s:4:"👚";s:12:":womans_hat:";s:4:"👒";s:32:":women_with_bunny_ears_partying:";s:13:"👯‍♀️";s:17:":women_wrestling:";s:13:"🤼‍♀️";s:8:":womens:";s:4:"🚺";s:11:":world_map:";s:4:"🗺";s:9:":worried:";s:4:"😟";s:8:":wrench:";s:4:"🔧";s:14:":writing_hand:";s:6:"✍️";s:20:":writing_hand_tone1:";s:7:"✍🏻";s:20:":writing_hand_tone2:";s:7:"✍🏼";s:20:":writing_hand_tone3:";s:7:"✍🏽";s:20:":writing_hand_tone4:";s:7:"✍🏾";s:20:":writing_hand_tone5:";s:7:"✍🏿";s:3:":x:";s:3:"❌";s:14:":yellow_heart:";s:4:"💛";s:7:":yemen:";s:8:"🇾🇪";s:5:":yen:";s:4:"💴";s:10:":yin_yang:";s:6:"☯️";s:5:":yum:";s:4:"😋";s:8:":zambia:";s:8:"🇿🇲";s:5:":zap:";s:6:"⚡️";s:7:":zebra:";s:4:"🦓";s:6:":zero:";s:4:"0⃣";s:10:":zimbabwe:";s:8:"🇿🇼";s:14:":zipper_mouth:";s:4:"🤐";s:19:":zipper_mouth_face:";s:4:"🤐";s:8:":zombie:";s:4:"🧟";s:5:":zzz:";s:4:"💤";s:5:":100:";s:4:"💯";s:6:":1234:";s:4:"🔢";s:2:":)";s:4:"🙂";s:3:":-)";s:4:"🙂";s:2:";)";s:4:"😉";s:3:";-)";s:4:"😉";s:2:":D";s:4:"😀";s:3:":-D";s:4:"😀";s:2:":(";s:3:"☹";s:3:":-(";s:3:"☹";s:3:":-*";s:4:"😘";s:2:":P";s:4:"😛";s:3:":-P";s:4:"😛";s:2:":p";s:4:"😛";s:3:":-p";s:4:"😛";s:2:";P";s:4:"😜";s:3:";-P";s:4:"😜";s:2:";p";s:4:"😜";s:3:";-p";s:4:"😜";s:2:":?";s:4:"😕";s:3:":-?";s:4:"😕";s:2:":|";s:4:"😐";s:3:":-|";s:4:"😐";s:2:":o";s:4:"😮";s:5:":lol:";s:4:"😂";}}s:14:"' . "\0" . '*' . "\0" . 'rootContext";a:2:{s:7:"allowed";a:2:{i:0;i:65431;i:1;i:257;}s:5:"flags";i:32;}s:13:"' . "\0" . '*' . "\0" . 'tagsConfig";a:38:{s:1:"B";a:7:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\FilterProcessing::filterAttributes";s:6:"params";a:4:{s:3:"tag";N;s:9:"tagConfig";N;s:14:"registeredVars";N;s:6:"logger";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:2;}s:8:"tagLimit";i:5000;s:10:"attributes";R:19;s:9:"bitNumber";i:0;s:7:"allowed";a:2:{i:0;i:65413;i:1;i:257;}}s:8:"BANDCAMP";a:7:{s:10:"attributes";a:3:{s:8:"album_id";a:2:{s:8:"required";b:0;s:11:"filterChain";R:19;}s:8:"track_id";R:3465;s:9:"track_num";R:3465;}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3089;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";a:2:{i:0;i:128;i:1;i:256;}}s:6:"CENTER";a:7:{s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:9:{s:1:"B";i:1;s:5:"COLOR";i:1;s:5:"EMAIL";i:1;s:4:"FONT";i:1;s:1:"I";i:1;s:1:"S";i:1;s:4:"SIZE";i:1;s:1:"U";i:1;s:3:"URL";i:1;}s:12:"fosterParent";R:3478;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:19;s:9:"bitNumber";i:1;s:7:"allowed";R:3441;}s:4:"CODE";a:7:{s:10:"attributes";a:1:{s:4:"lang";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:19:"/^[-0-9A-Za-z_]+$/D";}}}s:8:"required";b:0;}}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:3478;s:12:"fosterParent";R:3478;s:5:"flags";i:4432;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";a:2:{i:0;i:0;i:1;i:0;}}s:5:"COLOR";a:7:{s:10:"attributes";a:1:{s:5:"color";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:150:"/^(?:#(?:(?:[0-9a-f]{3}){1,2}|(?:[0-9a-f]{4}){1,2})|rgb\\(\\d{1,3}, *\\d{1,3}, *\\d{1,3}\\)|rgba\\(\\d{1,3}, *\\d{1,3}, *\\d{1,3}, *\\d*(?:\\.\\d+)?\\)|[a-z]+)$/Di";}}}s:8:"required";b:1;}}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3456;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:3460;}s:11:"DAILYMOTION";a:7:{s:10:"attributes";a:2:{s:2:"id";R:3465;s:1:"t";R:3465;}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3468;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:3472;}s:5:"EMAIL";a:7:{s:10:"attributes";a:1:{s:5:"email";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:61:"s9e\\TextFormatter\\Parser\\AttributeFilters\\EmailFilter::filter";s:6:"params";a:1:{s:9:"attrValue";N;}}}s:8:"required";b:1;}}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:514;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";a:2:{i:0;i:27395;i:1;i:257;}}s:5:"EMOJI";a:7:{s:10:"attributes";a:2:{s:3:"seq";a:2:{s:11:"filterChain";R:3494;s:8:"required";b:1;}s:4:"tseq";R:3546;}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3468;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";a:2:{i:0;i:0;i:1;i:257;}}s:8:"FACEBOOK";a:7:{s:10:"attributes";a:3:{s:2:"id";R:3465;s:4:"type";R:3465;s:4:"user";R:3465;}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3468;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:3472;}s:4:"FONT";a:7:{s:10:"attributes";a:1:{s:4:"font";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:74:"/^(?:\'[- \\w]+\'|"[- \\w]+"|[- \\w]+)(?:, *(?:\'[- \\w]+\'|"[- \\w]+"|[- \\w]+))*$/";}}}s:8:"required";b:1;}}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3456;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:3460;}s:1:"I";R:3446;s:3:"IMG";a:7:{s:10:"attributes";a:5:{s:3:"alt";R:3465;s:6:"height";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:67:"s9e\\TextFormatter\\Parser\\AttributeFilters\\NumericFilter::filterUint";s:6:"params";R:3533;}}s:8:"required";b:0;}s:3:"src";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\AttributeFilters\\UrlFilter::filter";s:6:"params";a:3:{s:9:"attrValue";N;s:9:"urlConfig";N;s:6:"logger";N;}}}s:8:"required";b:1;}s:5:"title";R:3465;s:5:"width";R:3574;}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3468;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:3551;}s:9:"INDIEGOGO";a:7:{s:10:"attributes";a:1:{s:2:"id";R:3465;}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3468;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:3472;}s:9:"INSTAGRAM";R:3591;s:11:"KICKSTARTER";a:7:{s:10:"attributes";a:3:{s:4:"card";R:3465;s:2:"id";R:3465;s:5:"video";R:3465;}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3468;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:3472;}s:2:"LI";a:7:{s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:10:{s:1:"B";i:1;s:5:"COLOR";i:1;s:5:"EMAIL";i:1;s:4:"FONT";i:1;s:1:"I";i:1;s:1:"S";i:1;s:4:"SIZE";i:1;s:1:"U";i:1;s:3:"URL";i:1;s:2:"LI";i:1;}s:12:"fosterParent";R:3478;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:19;s:9:"bitNumber";i:3;s:7:"allowed";R:3441;}s:4:"LIST";a:7:{s:10:"attributes";a:2:{s:5:"start";R:3574;s:4:"type";a:2:{s:11:"filterChain";a:2:{i:0;a:2:{s:8:"callback";s:63:"s9e\\TextFormatter\\Parser\\AttributeFilters\\HashmapFilter::filter";s:6:"params";a:3:{s:9:"attrValue";N;i:0;a:5:{s:1:"A";s:11:"upper-alpha";s:1:"I";s:11:"upper-roman";s:1:"a";s:11:"lower-alpha";s:1:"i";s:11:"lower-roman";i:1;s:7:"decimal";}i:1;b:0;}}i:1;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:23:"/^[- +,.0-9A-Za-z_]+$/D";}}}s:8:"required";b:0;}}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";a:4:{s:11:"createChild";a:1:{i:0;s:2:"LI";}s:11:"closeParent";R:3478;s:12:"fosterParent";R:3478;s:5:"flags";i:3456;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";a:2:{i:0;i:65288;i:1;i:257;}}s:8:"LIVELEAK";R:3591;s:5:"MEDIA";a:7:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:54:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::filterTag";s:6:"params";a:5:{s:3:"tag";N;s:6:"parser";N;s:16:"MediaEmbed.hosts";N;s:16:"MediaEmbed.sites";N;s:8:"cacheDir";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:513;}s:8:"tagLimit";i:5000;s:10:"attributes";R:19;s:9:"bitNumber";i:8;s:7:"allowed";a:2:{i:0;i:65431;i:1;i:256;}}s:2:"OL";a:7:{s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:3478;s:12:"fosterParent";R:3478;s:5:"flags";i:3456;}s:8:"tagLimit";i:5000;s:10:"attributes";R:19;s:9:"bitNumber";i:1;s:7:"allowed";R:3646;}s:5:"QUOTE";a:7:{s:10:"attributes";a:1:{s:6:"author";R:3465;}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3477;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:3441;}s:1:"S";R:3446;s:4:"SIZE";a:7:{s:10:"attributes";a:1:{s:4:"size";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:68:"s9e\\TextFormatter\\Parser\\AttributeFilters\\NumericFilter::filterRange";s:6:"params";a:4:{s:9:"attrValue";N;i:0;i:8;i:1;i:36;s:6:"logger";N;}}}s:8:"required";b:1;}}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3456;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:3460;}s:10:"SOUNDCLOUD";a:7:{s:10:"attributes";a:4:{s:2:"id";R:3465;s:11:"playlist_id";R:3465;s:12:"secret_token";R:3465;s:8:"track_id";R:3465;}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3468;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:3472;}s:7:"SPOILER";a:7:{s:10:"attributes";a:1:{s:5:"title";R:3465;}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3477;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:4;s:7:"allowed";R:3441;}s:5:"TABLE";a:7:{s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3669;s:8:"tagLimit";i:5000;s:10:"attributes";R:19;s:9:"bitNumber";i:1;s:7:"allowed";a:2:{i:0;i:65344;i:1;i:257;}}s:2:"TD";a:7:{s:10:"attributes";a:3:{s:5:"align";a:2:{s:11:"filterChain";a:2:{i:0;a:2:{s:8:"callback";s:10:"strtolower";s:6:"params";R:3533;}i:1;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:34:"/^(?:center|justify|left|right)$/D";}}}s:8:"required";b:0;}s:7:"colspan";R:3574;s:7:"rowspan";R:3574;}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:11:{s:1:"B";i:1;s:5:"COLOR";i:1;s:5:"EMAIL";i:1;s:4:"FONT";i:1;s:1:"I";i:1;s:1:"S";i:1;s:4:"SIZE";i:1;s:1:"U";i:1;s:3:"URL";i:1;s:2:"TD";i:1;s:2:"TH";i:1;}s:12:"fosterParent";R:3478;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:5;s:7:"allowed";R:3441;}s:2:"TH";R:3710;s:2:"TR";a:7:{s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"B";i:1;s:5:"COLOR";i:1;s:5:"EMAIL";i:1;s:4:"FONT";i:1;s:1:"I";i:1;s:1:"S";i:1;s:4:"SIZE";i:1;s:1:"U";i:1;s:3:"URL";i:1;s:2:"TD";i:1;s:2:"TH";i:1;s:2:"TR";i:1;}s:12:"fosterParent";R:3478;s:5:"flags";i:3456;}s:8:"tagLimit";i:5000;s:10:"attributes";R:19;s:9:"bitNumber";i:6;s:7:"allowed";a:2:{i:0;i:65312;i:1;i:257;}}s:6:"TWITCH";a:7:{s:10:"attributes";a:4:{s:7:"channel";R:3465;s:7:"clip_id";R:3465;s:1:"t";R:3465;s:8:"video_id";R:3465;}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3468;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:3472;}s:7:"TWITTER";R:3591;s:1:"U";R:3446;s:2:"UL";R:3667;s:3:"URL";a:7:{s:10:"attributes";a:2:{s:5:"title";R:3465;s:3:"url";R:3579;}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3537;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:7;s:7:"allowed";R:3541;}s:5:"VIMEO";a:7:{s:10:"attributes";a:2:{s:2:"id";R:3465;s:1:"t";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:65:"s9e\\TextFormatter\\Parser\\AttributeFilters\\TimestampFilter::filter";s:6:"params";R:3533;}}s:8:"required";b:0;}}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3468;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:3472;}s:4:"VINE";R:3591;s:4:"WSHH";R:3591;s:7:"YOUTUBE";a:7:{s:10:"attributes";a:3:{s:2:"id";R:3493;s:4:"list";R:3465;s:1:"t";R:3773;}s:11:"filterChain";R:3447;s:12:"nestingLimit";i:10;s:5:"rules";R:3468;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:2;s:7:"allowed";R:3472;}}}');
	}

	/**
	* {@inheritdoc}
	*/
	public static function getRenderer()
	{
		return unserialize('O:40:"s9e\\TextFormatter\\Bundles\\Forum\\Renderer":2:{s:19:"enableQuickRenderer";b:1;s:9:"' . "\0" . '*' . "\0" . 'params";a:4:{s:6:"L_HIDE";s:4:"Hide";s:6:"L_SHOW";s:4:"Show";s:9:"L_SPOILER";s:7:"Spoiler";s:7:"L_WROTE";s:6:"wrote:";}}');
	}
}