<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2019 The s9e Authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Bundles;

abstract class Fatdown extends \s9e\TextFormatter\Bundle
{
	/**
	* @var s9e\TextFormatter\Parser Singleton instance used by parse()
	*/
	protected static $parser;

	/**
	* @var s9e\TextFormatter\Renderer Singleton instance used by render()
	*/
	protected static $renderer;

	/**
	* {@inheritdoc}
	*/
	public static function getJS()
	{
		return '(function(){var ba=[""],ca=[0,0,0],da=["","t"],fa=["","id"],ka={flags:0},la={flags:514},na={flags:3201},oa={flags:3089},pa=["","album_id"],qa=["","track_id"],ra=[32928,257,256],ua=[32896,257,257],va=[65527,65313,257],wa=[65408,65280,257],xa=[65505,65281,257],ya=[36743,65329,257],za=[65416,65280,257],Aa=[65408,65288,257],Ba=[65527,65329,257],Ca=[64499,65313,257],Da=["","playlist_id"],x={c:[],r:!1},Ea={c:[],r:!0},Fa={"class":x},z={C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:strong":1,
"html:u":1},F=[function(a,b){var c={},d;for(d in b.b){var l=b.b[d],k=!1;if(d in a.b){k=l.c;var h=d,u=a.b[d];B.x=h;for(var r=0;r<k.length&&(u=k[r](u,h),!1!==u);++r);delete B.x;k=u}!1!==k?c[d]=k:l.r&&C(a)}Ga(a,c)}],Ha={c:[function(a){var b=/^(?=\\d)(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?$/.exec(a);return b?3600*(b[1]||0)+60*(b[2]||0)+(+b[3]||0):/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],r:!1},Ma=[function(a){var b=Ia.urlConfig,c=B,d=Ja(a.replace(/^\\s+/,"").replace(/\\s+$/,""));(b=Ka(b,d))?(c&&(d.attrValue=a,c.add("err",
b,d)),a=!1):a=La(d);return a}],Oa={c:[function(a){return Na(a,/^[- +,.0-9A-Za-z_]+$/)}],r:!1},Pa={c:Ma,r:!0},Qa={l:z,flags:268,m:z},Ta={l:z,flags:3460,m:z},Ua={d:ca,b:{},h:0,c:F,f:10,e:{flags:66},g:5E3},Va={d:xa,b:{},h:0,c:F,f:10,e:{flags:2},g:5E3},Wa={d:xa,b:{},h:0,c:F,f:10,e:ka,g:5E3},Xa={d:Ba,b:{},h:0,c:F,f:10,e:{flags:512},g:5E3},Ya={l:{C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:dd":1,"html:dt":1,"html:i":1,"html:strong":1,"html:u":1},flags:256,m:z},Za={l:{C:1,EM:1,EMAIL:1,
STRONG:1,TD:1,TH:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:strong":1,"html:td":1,"html:th":1,"html:u":1},flags:256,m:z},$a={d:ra,b:{id:x},h:6,c:F,f:10,e:oa,g:5E3},ab={d:ua,b:{"char":Ea},h:8,c:F,f:10,e:oa,g:5E3},bb={align:{c:[function(a){return a.toLowerCase()},function(a){return Na(a,/^(?:center|justify|left|right)$/)}],r:!1}},cb={d:xa,b:{},h:2,c:F,f:10,e:{l:z,flags:260,m:z},g:5E3},db={d:za,b:{},h:1,c:F,f:10,e:Ta,g:5E3},eb={d:[65408,65290,257],b:{},h:1,c:F,f:10,e:Ta,g:5E3},fb={d:Aa,b:{},h:9,
c:F,f:10,e:{l:z,flags:3456,m:z},g:5E3},gb={d:va,b:{},h:3,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,LI:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:li":1,"html:strong":1,"html:u":1},flags:264,m:z},g:5E3},lb={d:[65408,65284,257],b:{},h:11,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,STRONG:1,TD:1,TH:1,TR:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:strong":1,"html:td":1,"html:th":1,"html:tr":1,"html:u":1},flags:3456,m:z},g:5E3},mb={d:Aa,b:{},h:9,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,STRONG:1,TBODY:1,TD:1,TH:1,
THEAD:1,TR:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:strong":1,"html:tbody":1,"html:td":1,"html:th":1,"html:thead":1,"html:tr":1,"html:u":1},flags:3456,m:z},g:5E3},nb=\'<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:html="urn:s9e:TextFormatter:html" exclude-result-prefixes="html"><xsl:output method="html" encoding="utf-8" indent="no"/>$aBANDCAMP"><$t$ibandcamp"$k$g400px"><$t$k$c100%">$h$k$f><$l$psrc">//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/<$q><$r$m@album_id">album=$b@album_id"/><$s$m@track_num">/t=$b@track_num"/></$s></$r><$o>track=$b@track_id"/></$o></$q></$l></iframe></$t></$t>$d$aC"><code>$e</code>$d$aCODE"><pre><code><$s$m@lang"><$l$pclass">language-$b@lang"/></$l></$s>$e</code></pre>$d$aDAILYMOTION"><$t$idailymotion"$k$g640px"><$t$k$c56.25%">$h$k$f><$l$psrc">//www.dailymotion.com/embed/video/$b@id"/><$s$m@t">?start=$b@t"/></$s></$l></iframe></$t></$t>$d$aDEL|EM|H1|H2|H3|H4|H5|H6|LI|STRONG|SUB|SUP|TABLE|TBODY|THEAD|TR|html:b|html:br|html:code|html:dd|html:del|html:dl|html:dt|html:i|html:ins|html:li|html:ol|html:pre|html:rb|html:rp|html:rt|html:rtc|html:ruby|html:strong|html:sub|html:sup|html:table|html:tbody|html:tfoot|html:thead|html:tr|html:u|html:ul|p"><xsl:element$p{translate(local-name(),\\\'ABDEGHILMNOPRSTUY\\\',\\\'abdeghilmnoprstuy\\\')}">$e</xsl:element>$d$aEMAIL"><a href="mailto:{@email}">$e</a>$d$aESC">$e$d$aFACEBOOK"><iframe$ifacebook"$u"$nstyle" onload="var c=new MessageChannel;c.port1.onmessage=function(e){{style.height=e.data+\\\'px\\\'}};contentWindow.postMessage(\\\'s9e:init\\\',\\\'https://s9e.github.io\\\',[c.port2])"$vno" src="https://s9e.github.io/iframe/2/facebook.min.html#{@type}{@id}"$kborder:0;height:360px;max-width:640px;width:100%"/>$d$aFP|HE">$b@char"/>$d$aHC"><xsl:comment>$b@content"/></xsl:comment>$d$aHR"><hr/>$d$aIMG"><img src="{@src}">$jalt|@title"/></img>$d$aISPOILER"><$t class="spoiler"$nstyle" onclick="removeAttribute(\\\'style\\\')"$kbackground:#444;color:transparent">$e</$t>$d$aLIST"><$q><$r$mnot(@type)"><ul>$e</ul></$r><$o><ol>$jstart"/>$e</ol></$o></$q>$d$aLIVELEAK"><$t$iliveleak"$k$g640px"><$t$k$c56.25%">$h src="//www.liveleak.com/e/{@id}"$k$f/></$t></$t>$d$aQUOTE"><blockquote>$e</blockquote>$d$aSOUNDCLOUD"><iframe$isoundcloud"$u"$vno"><$l$psrc">https://w.soundcloud.com/player/?url=<$q><$r$m$w">https%3A//api.soundcloud.com/playlists/$b$w"/></$r><$r$m@track_id">https%3A//api.soundcloud.com/tracks/$b@track_id"/>&amp;secret_token=$b@secret_token"/></$r><$o><$s$mnot(contains(@id,\\\'://\\\'))">https%3A//soundcloud.com/</$s>$b@id"/></$o></$q></$l><$l$pstyle">border:0;height:<$q><$r$m$w or contains(@id,\\\'/sets/\\\')">450</$r><$o>166</$o></$q>px;max-width:900px;width:100%</$l></iframe>$d$aSPOILER"><details class="spoiler"$nopen">$e</details>$d$aSPOTIFY"><$t$ispotify"$k$g400px"><$t$k$c100%"><iframe allow="encrypted-media"$u"$vno" src="https://open.spotify.com/embed/{translate(@id,\\\':\\\',\\\'/\\\')}{@path}"$k$f/></$t></$t>$d$aTD"><td><$s$m@align"><$l$pstyle">text-align:$b@align"/></$l></$s>$e</td>$d$aTH"><th><$s$m@align"><$l$pstyle">text-align:$b@align"/></$l></$s>$e</th>$d$aTWITCH"><$t$itwitch"$k$g640px"><$t$k$c56.25%">$h$k$f><$l$psrc">//<$q><$r$m@clip_id">clips.twitch.tv/embed?autoplay=false&amp;clip=<$s$m@channel">$b@channel"/>/</$s>$b@clip_id"/></$r><$o>player.twitch.tv/?autoplay=false&amp;<$q><$r$m@video_id">video=v$b@video_id"/></$r><$o>channel=$b@channel"/></$o></$q><$s$m@t">&amp;time=$b@t"/></$s></$o></$q></$l></iframe></$t></$t>$d$aURL"><a href="{@url}">$jtitle"/>$e</a>$d$aVIMEO"><$t$ivimeo"$k$g640px"><$t$k$c56.25%">$h$k$f><$l$psrc">//player.vimeo.com/video/$b@id"/><$s$m@t">#t=$b@t"/></$s></$l></iframe></$t></$t>$d$aVINE"><$t$ivine"$k$g480px"><$t$k$c100%">$h src="https://vine.co/v/{@id}/embed/simple?audio=1"$k$f/></$t></$t>$d$aYOUTUBE"><$t$iyoutube"$k$g640px"><$t$k$c56.25%">$h$kbackground:url(https://i.ytimg.com/vi/{@id}/hqdefault.jpg) 50% 50% / cover;$f><$l$psrc">https://www.youtube.com/embed/$b@id"/><$s$m@list">?list=$b@list"/></$s><$s$m@t"><$q><$r$m@list">&amp;</$r><$o>?</$o></$q>start=$b@t"/></$s></$l></iframe></$t></$t>$d$abr"><br/>$d$ae|i|s"/>$ahtml:abbr"><abbr>$jtitle"/>$e</abbr>$d$ahtml:div"><div>$jclass"/>$e</div>$d$ahtml:img"><img>$jalt|@height|@src|@title|@width"/>$e</img>$d$ahtml:$t"><$t>$jclass"/>$e</$t>$d$ahtml:td"><td>$jcol$t|@row$t"/>$e</td>$d$ahtml:th"><th>$jcol$t|@row$t|@scope"/>$e</th>$d</xsl:stylesheet>\'.replace(/\\$[a-w]/g,
function(a){return{$a:\'<xsl:template match="\',$b:\'<xsl:value-of select="\',$c:"display:block;overflow:hidden;position:relative;padding-bottom:",$d:"</xsl:template>",$e:"<xsl:apply-templates/>",$f:\'border:0;height:100%;left:0;position:absolute;width:100%"\',$g:"display:inline-block;width:100%;max-width:",$h:\'<iframe allowfullscreen="" scrolling="no"\',$i:\' data-s9e-mediaembed="\',$j:\'<xsl:copy-of select="@\',$k:\' style="\',$l:"xsl:attribute",$m:\' test="\',$n:\' data-s9e-livepreview-ignore-attrs="\',$o:"xsl:otherwise",
$p:\' name="\',$q:"xsl:choose",$r:"xsl:when",$s:"xsl:if",$t:"span",$u:\' allowfullscreen="\',$v:\' scrolling="\',$w:"@playlist_id"}[a]});function Na(a,b){return b.test(a)?a:!1}
function Ja(a){var b=/^(?:([a-z][-+.\\w]*):)?(?:\\/\\/(?:([^:\\/?#]*)(?::([^\\/?#]*)?)?@)?(?:(\\[[a-f\\d:]+\\]|[^:\\/?#]+)(?::(\\d*))?)?(?![^\\/?#]))?([^?#]*)(\\?[^#]*)?(#.*)?$/i.exec(a),c={};"scheme user pass host port path query fragment".split(" ").forEach(function(d,l){c[d]=""<b[l+1]?b[l+1]:""});c.scheme=c.scheme.toLowerCase();c.host=c.host.replace(/[\\u3002\\uff0e\\uff61]/g,".").replace(/\\.+$/g,"");/[^\\x00-\\x7F]/.test(c.host)&&"undefined"!==typeof punycode&&(c.host=punycode.toASCII(c.host));return c}
function La(a){var b="";""!==a.scheme&&(b+=a.scheme+":");""!==a.host?(b+="//",""!==a.user&&(b+=ob(decodeURIComponent(a.user)),""!==a.pass&&(b+=":"+ob(decodeURIComponent(a.pass))),b+="@"),b+=a.host,""!==a.port&&(b+=":"+a.port)):"file"===a.scheme&&(b+="//");var c=a.path+a.query+a.fragment;c=c.replace(/%.?[a-f]/g,function(d){return d.toUpperCase()},c);b+=c.replace(/[^\\u0020-\\u007E]+/g,encodeURIComponent).replace(/%(?![0-9A-Fa-f]{2})|[^!#-&*-;=?-Z_a-z~]/g,escape);a.scheme||(b=b.replace(/^([^\\/]*):/,"$1%3A"));
return b}
function Ka(a,b){if(""!==b.scheme&&!a.Q.test(b.scheme))return"URL scheme is not allowed";if(""!==b.host){var c;if(c=!/^(?!-)[-a-z0-9]{0,62}[a-z0-9](?:\\.(?!-)[-a-z0-9]{0,62}[a-z0-9])*$/i.test(b.host)){a:if(c=b.host,/^\\d+\\.\\d+\\.\\d+\\.\\d+$/.test(c))for(var d=4,l=c.split(".");0<=--d;){if("0"===l[d][0]||255<l[d]){c=!1;break a}}else c=!1;if(c=!c)c=b.host.replace(/^\\[(.*)\\]$/,"$1",b.host),c=!(/^([\\da-f]{0,4}:){2,7}(?:[\\da-f]{0,4}|\\d+\\.\\d+\\.\\d+\\.\\d+)$/.test(c)&&c)}if(c)return"URL host is invalid";if(a.S&&
a.S.test(b.host)||a.W&&!a.W.test(b.host))return"URL host is not allowed"}else if(/^(?:(?:f|ht)tps?)$/.test(b.scheme))return"Missing host"}function pb(a){var b=document.createElement("b");pb=function(c){b.innerHTML=c.replace(/</g,"&lt;");return b.textContent};return pb(a)}function qb(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;",\'"\':"&quot;"};return a.replace(/[<>&"]/g,function(c){return b[c]})}
function rb(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;"};return a.replace(/[<>&]/g,function(c){return b[c]})}function ob(a){return encodeURIComponent(a).replace(/[!\'()*]/g,function(b){return"%"+b.charCodeAt(0).toString(16).toUpperCase()})}function sb(){this.o={};this.p=[]}sb.prototype.add=function(a,b,c){c=c||{};"attrName"in c||!this.x||(c.attrName=this.x);"tag"in c||!this.j||(c.tag=this.j);this.o[a]&&this.o[a].forEach(function(d){d(b,c)});this.p.push([a,b,c])};sb.prototype.getLogs=function(){return this.p};
sb.prototype.on=function(a,b){this.o[a].push(b)};function tb(a,b){B.add("debug",a,b)}function ub(a,b,c,d,l){this.j=+a;this.name=b;this.i=+c;this.k=+d;this.p=+l||0;this.b={};this.M=[];isNaN(a+c+d)&&C(this)}ub.prototype.o=!1;function vb(a,b){a.M.push(b);a.o&&C(b)}function C(a){a.o||(a.o=!0,a.M.forEach(function(b){C(b)}))}function wb(a,b){a.name===b.name&&(1===a.j&&2===b.j&&b.i>=a.i?(a.y=b,b.F=a,vb(a,b)):2===a.j&&1===b.j&&b.i<=a.i&&(a.F=b,b.y=a))}
function xb(a){var b={},c;for(c in a.b)b[c]=a.b[c];return b}function yb(a,b){return a.o||a.name!==b.name||1!==b.j||2!==a.j||a.i<b.i||a.F&&a.F!==b||b.y&&b.y!==a?!1:!0}function Ga(a,b){a.b={};for(var c in b)a.b[c]=b[c]}
var zb,Ab,G,Bb,I,Cb,B=new sb,Db,J,K,Gb={Autoemail:{q:function(a,b){b.forEach(function(c){var d=L(1,"EMAIL",c[0][1],0,0);d.b.email=c[0][0];c=Eb("EMAIL",c[0][1]+c[0][0].length,0);wb(d,c)})},u:"@",v:/\\b[-a-z0-9_+.]+@[-a-z0-9.]*[a-z0-9]/ig,w:5E4},Autolink:{q:function(a,b){b.forEach(function(c){var d=c[0][1],l=c[0][0].replace(/(?![-=\\/)])[\\s!-.:-@[-`{-~]+$/,"");if(/^www\\.|^[^:]+:/i.test(l)){var k=d+l.length,h=Eb("URL",k,0);"."===l[3]&&(l="http://"+l);c=L(1,"URL",d,0,1);c.b.url=l;wb(c,h);d=L(3,"v",d,k-
d,1E3);vb(c,d)}})},u:"://",v:/\\b(?:ftp|https?|mailto):\\/\\/\\S(?:[^\\s()\\[\\]\\uFF01-\\uFF0F\\uFF1A-\\uFF20\\uFF3B-\\uFF40\\uFF5B-\\uFF65]|\\([^\\s()]*\\)|\\[\\w*\\])+/ig,w:5E4},Escaper:{q:function(a,b){b.forEach(function(c){N("ESC",c[0][1],1,c[0][1]+c[0][0].length,0)})},u:"\\\\",v:/\\\\[-!#()*+.:<>@[\\\\\\]^_`{|}~]/g,w:5E4},FancyPants:{q:function(a){function b(g,n,m,v){g=L(3,p,g,n,v||0);g.b[e]=m;return g}function c(){if(!(0>a.indexOf("...")&&0>a.indexOf("--")))for(var g={"--":"\\u2013","---":"\\u2014","...":"\\u2026"},n=/---?|\\.\\.\\./g,
m;m=n.exec(a);)b(m.index,m[0].length,g[m[0]])}function d(){if(!(0>a.indexOf("/")))for(var g={"0/3":"\\u2189","1/10":"\\u2152","1/2":"\\u00bd","1/3":"\\u2153","1/4":"\\u00bc","1/5":"\\u2155","1/6":"\\u2159","1/7":"\\u2150","1/8":"\\u215b","1/9":"\\u2151","2/3":"\\u2154","2/5":"\\u2156","3/4":"\\u00be","3/5":"\\u2157","3/8":"\\u215c","4/5":"\\u2158","5/6":"\\u215a","5/8":"\\u215d","7/8":"\\u215e"},n,m=/\\b(?:0\\/3|1\\/(?:[2-9]|10)|2\\/[35]|3\\/[458]|4\\/5|5\\/[68]|7\\/8)\\b/g;n=m.exec(a);)b(n.index,n[0].length,g[n[0]])}function l(){if(!(0>
a.indexOf("<<")))for(var g,n=/<<( ?)(?! )[^\\n<>]*?[^\\n <>]\\1>>(?!>)/g;g=n.exec(a);){var m=b(g.index,2,"\\u00ab");g=b(g.index+g[0].length-2,2,"\\u00bb");vb(m,g)}}function k(){if(!(0>a.indexOf("!=")&&0>a.indexOf("=/=")))for(var g,n=/\\b (?:!|=\\/)=(?= \\b)/g;g=n.exec(a);)b(g.index+1,g[0].length-1,"\\u2260")}function h(g,n,m,v){for(var y;y=n.exec(a);){var E=b(y.index+y[0].indexOf(g),1,m);y=b(y.index+y[0].length-1,1,v);vb(E,y)}}function u(){if(f)for(var g,n=/[a-z]\'|(?:^|\\s)\'(?=[a-z]|[0-9]{2})/gi;g=n.exec(a);)b(g.index+
g[0].indexOf("\'"),1,"\\u2019",10)}function r(){if(f||q||!(0>a.indexOf("x")))for(var g={"\'s":"\\u2019","\'":"\\u2032","\' ":"\\u2032","\'x":"\\u2032",\'"\':"\\u2033",\'" \':"\\u2033",\'"x\':"\\u2033"},n,m=/[0-9](?:\'s|["\']? ?x(?= ?[0-9])|["\'])/g;n=m.exec(a);){"x"===n[0][n[0].length-1]&&b(n.index+n[0].length-1,1,"\\u00d7");var v=n[0].substr(1,2);g[v]&&b(n.index+1,1,g[v])}}function w(){if(!(0>a.indexOf("(")))for(var g={"(c)":"\\u00a9","(r)":"\\u00ae","(tm)":"\\u2122"},n=/\\((?:c|r|tm)\\)/gi,m;m=n.exec(a);)b(m.index,m[0].length,
g[m[0].toLowerCase()])}var t={x:"char",I:"FP"},e=t.x,f=0<=a.indexOf("\'"),q=0<=a.indexOf(\'"\'),p=t.I;"undefined"===typeof t.aa&&(u(),f&&h("\'",/(?:^|\\W)\'.+?\'(?!\\w)/g,"\\u2018","\\u2019"),q&&h(\'"\',/(?:^|\\W)".+?"(?!\\w)/g,"\\u201c","\\u201d"));"undefined"===typeof t.Y&&l();"undefined"===typeof t.Z&&(k(),r(),d());"undefined"===typeof t.$&&c();"undefined"===typeof t.ba&&w()}},HTMLComments:{q:function(a,b){b.forEach(function(c){var d=pb(c[0][0].substr(4,c[0][0].length-7));d=d.replace(/[<>]/g,"");d=d.replace(/-+$/,
"");d=d.replace(/--/g,"");L(3,"HC",c[0][1],c[0][0].length,0).b.content=d})},u:"\\x3c!--",v:/\\x3c!--(?!\\[if)[\\s\\S]*?--\\x3e/ig,w:5E4},HTMLElements:{q:function(a,b){var c={a:{"":"URL",href:"url"},em:{"":"EM"},hr:{"":"HR"},s:{"":"S"},strong:{"":"STRONG"},sup:{"":"SUP"}};b.forEach(function(d){var l="/"===a[d[0][1]+1],k=d[0][1],h=d[0][0].length,u=d[2-l][0].toLowerCase(),r=c&&c[u]&&c[u][""]?c[u][""]:"html:"+u;if(l)Eb(r,k,h);else for(l=/(<\\S+|[\'"\\s])\\/>$/.test(d[0][0])?N(r,k,h,k+h,0):L(1,r,k,h,0),d=d[3][0],
k=/([a-z][-a-z0-9]*)(?:\\s*=\\s*("[^"]*"|\'[^\']*\'|[^\\s"\'=<>`]+))?/gi;r=k.exec(d);)h=r[1].toLowerCase(),r="undefined"!==typeof r[2]?r[2]:h,c&&c[u]&&c[u][h]&&(h=c[u][h]),/^["\']/.test(r)&&(r=r.substr(1,r.length-2)),r=pb(r),l.b[h]=r})},u:"<",v:/<(?:\\/((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))|((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))((?:\\s+[a-z][-a-z0-9]*(?:\\s*=\\s*(?:"[^"]*"|\'[^\']*\'|[^\\s"\'=<>`]+))?)*)\\s*\\/?)\\s*>/ig,
w:5E4},HTMLEntities:{q:function(a,b){b.forEach(function(c){var d=c[0][0],l=pb(d);l===d||32>l.charCodeAt(0)||(L(3,"HE",c[0][1],d.length,0).b["char"]=l)})},u:"&",v:/&(?:[a-z]+|#(?:[0-9]+|x[0-9a-f]+));/ig,w:5E4},Litedown:{q:function(a){function b(e){-1<e.indexOf("&")&&(e=pb(e));e=e.replace(/\\x1A/g,"");r&&(e=e.replace(/\\x1B./g,function(f){return{"\\u001b0":"!","\\u001b1":\'"\',"\\u001b2":"\'","\\u001b3":"(","\\u001b4":")","\\u001b5":"*","\\u001b6":"[","\\u001b7":"\\\\","\\u001b8":"]","\\u001b9":"^","\\u001bA":"_","\\u001bB":"`",
"\\u001bC":"~"}[f]}));return e}function c(e){return 0<" abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".indexOf(e)}function d(e){a=a.substr(0,e)+"\\u0017"+a.substr(e+1)}function l(e,f){0<f&&(a=a.substr(0,e)+Array(1+f).join("\\u001a")+a.substr(e+f))}function k(e,f,q){if(-1!==a.indexOf(e))for(var p;p=f.exec(a);)e=p.index,p=e+p[0].length-2,N(q,e,2,p,2),l(e,2),l(p,2)}function h(e,f,q,p){function g(m){m=a.indexOf(f+"(",m);if(-1!==m){var v;for(p.lastIndex=m;v=p.exec(a);){var y=v[0];v=v.index;
var E=y.length;N(e,v,2,v+E-1,1);l(v,E)}y&&g(m)}}var n=a.indexOf(f);-1!==n&&(function(m){var v;for(q.lastIndex=m;v=q.exec(a);){m=v[0];v=v.index;var y=m.substr(-1)===f?1:0;N(e,v,1,v+m.length-y,y)}}(n),g(n))}function u(e,f,q){var p=f.replace(/^\\s*/,"").replace(/\\s*$/,"");f="";var g=p.indexOf(" ");-1!==g&&(f=p.substr(g).replace(/^\\s*\\S/,"").replace(/\\S\\s*$/,""),p=p.substr(0,g));p=b(p);e.b[q]=p;""<f&&(q=b(f),e.b.title=q)}var r=!1,w=!1,t={};0<=a.indexOf("\\\\")&&(r=!0,a=a.replace(/\\\\[!"\'()*[\\\\\\]^_`~]/g,function(e){return{"\\\\!":"\\u001b0",
\'\\\\"\':"\\u001b1","\\\\\'":"\\u001b2","\\\\(":"\\u001b3","\\\\)":"\\u001b4","\\\\*":"\\u001b5","\\\\[":"\\u001b6","\\\\\\\\":"\\u001b7","\\\\]":"\\u001b8","\\\\^":"\\u001b9","\\\\_":"\\u001bA","\\\\`":"\\u001bB","\\\\~":"\\u001bC"}[e]}));a+="\\n\\n\\u0017";(function(){function e(m,v){wb(Eb("LIST",v,0),m.U);wb(Eb("LI",v,0),m.G);m.O&&m.H.forEach(function(y){y.flags&=-9})}function f(m,v){for(var y=m;0<=--v;)y=y.replace(/^ *>!? ?/,"");return m.length-y.length}function q(m,v){return/[ \\t]*#*[ \\t]*$/.exec(a.substr(m,v-m))[0].length}function p(m){for(var v=
[],y=/>!?/g,E;E=y.exec(m);)v.push(E[0]);return v}function g(){if(-1!==a.indexOf("-")||-1!==a.indexOf("="))for(var m,v=/^(?=[-=>])(?:>!? ?)*(?=[-=])(?:-+|=+) *$/gm;m=v.exec(a);){var y=m[0];m=m.index;for(var E=m-1;0<E&&" "===a[E-1];)--E;n[m-1]={K:m+y.length-E,L:E,R:y.length-y.replace(/>/g,"").length,I:"="===y[0]?"H1":"H2"}}}var n={};(function(){g();for(var m=[],v=0,y,E=4,A,H=!0,Q=[],M=0,ea=!1,S=0,ma,ha,Z,hb,Rb,U,P,ib,Ra,ia,ja,sa,Sb=[],jb,Sa=/^(?:(?=[-*+\\d \\t>`~#_])((?: {0,3}>(?:(?!!)|!(?![^\\n>]*?!<)) ?)+)?([ \\t]+)?(\\* *\\* *\\*[* ]*$|- *- *-[- ]*$|_ *_ *_[_ ]*$)?((?:[-*+]|\\d+\\.)[ \\t]+(?=\\S))?[ \\t]*(#{1,6}[ \\t]+|```+[^`\\n]*$|~~~+[^~\\n]*$)?)?/gm;jb=
Sa.exec(a);)Sb.push(jb),jb.index===Sa.lastIndex&&++Sa.lastIndex;Sb.forEach(function(D){var aa=[],V=D.index,ta=D[0].length,R;ia=Z=0;ha=!H;U=a.indexOf("\\n",V);H=U===V+ta&&!D[3]&&!D[4]&&!D[5];ta||++Sa.lastIndex;ma=H&&ha;D[1]&&(aa=p(D[1]),ia=aa.length,Z=D[1].length,A&&"blockDepth"in A.b&&(ia=Math.min(ia,A.b.blockDepth),Z=f(D[1],ia)),l(V,Z));if(ia<v&&!ha){ea=!0;do{var W=m.pop();wb(Eb(W.name,S,0),W)}while(ia<--v)}if(ia>v&&!H){ea=!0;do m.push(L(1,">!"===aa[v]?"SPOILER":"QUOTE",V,0,-999));while(ia>++v)}W=
R=0;if(D[2]&&!y){hb=D[2];Rb=hb.length;do" "===hb[W]?++R:R=R+4&-4;while(++W<Rb&&R<E)}A&&!y&&R<E&&!H&&(ea=!0);ea&&(ea=!1,A&&(S>A.i?(l(A.i,S-A.i),wb(A,Eb("CODE",S,0,-1))):C(A),y=A=null),Q.forEach(function(kb){e(kb,S)}),Q=[],M=0,V&&d(V-1));if(R>=E){if(A||!ha)Z=(D[1]||"").length+W,A||(A=L(1,"CODE",V+Z,0,-999)),D={}}else{aa=!!D[4];if(R||ha||aa)if(ha&&!aa)P=M-1;else if(M)for(P=0;P<M&&R>Q[P].N;)++P;else P=aa?0:-1;else P=-1;for(;P<M-1;)e(Q.pop(),S),--M;P!==M||aa||--P;if(aa&&0<=P)if(ma=!0,ja=V+Z+W,sa=D[4].length,
W=L(1,"LI",ja,sa,0),l(ja,sa),P<M)wb(Eb("LI",S,0),Q[P].G),Q[P].G=W,Q[P].H.push(W);else{++M;P?(Ra=Q[P-1].N+1,ib=Math.max(Ra,4*P)):(Ra=0,ib=R);R=L(1,"LIST",ja,0,0);if(-1<D[4].indexOf(".")){R.b.type="decimal";var Tb=+D[4];1!==Tb&&(R.b.start=Tb)}Q.push({U:R,G:W,H:[W],ca:Ra,N:ib,O:!0})}!M||ha||H||(1<Q[0].H.length||!aa)&&Q.forEach(function(kb){kb.O=!1});E=4*(M+1)}if(D[5])if("#"===D[5][0])W=D[5].length,aa=V+ta-W,R=q(V+ta,U),ta=U-R,N("H"+/#{1,6}/.exec(D[5])[0].length,aa,W,ta,R),d(aa),d(U),ha&&(ma=!0);else{if("`"===
D[5][0]||"~"===D[5][0])ja=V+Z,sa=U-ja,A&&D[5]===y?(wb(A,Eb("CODE",ja,sa,-1)),Fb(S,ja-S),l(A.i,ja+sa-A.i),y=A=null):A||(A=L(1,"CODE",ja,sa,0),y=D[5].replace(/[^`~]+/,""),A.b.blockDepth=ia,Fb(ja+sa,1),D=D[5].replace(/^[`~\\s]*/,"").replace(/\\s+$/,""),""!==D&&(A.b.lang=D))}else D[3]&&!M&&"\\u0017"!==a[V+ta]?(L(3,"HR",V+Z,ta-Z,0),ma=!0,d(U)):!n[U]||n[U].R!==ia||H||M||A||(N(n[U].I,V+Z,0,n[U].L,n[U].K),d(n[U].L+n[U].K));ma&&(L(3,"pb",S,0,0),d(S));H||(S=U);Z&&Fb(V,Z,1E3)})})()})();(function(){if(!(0>a.indexOf("]:")))for(var e,
f=/^\\x1A* {0,3}\\[([^\\x17\\]]+)\\]: *([^[\\s\\x17]+ *(?:"[^\\x17]*?"|\'[^\\x17]*?\'|\\([^\\x17)]*\\))?) *(?=$|\\x17)\\n?/gm;e=f.exec(a);){Fb(e.index,e[0].length);var q=e[1].toLowerCase();t[q]||(w=!0,t[q]=e[2])}})();(function(){var e=a.indexOf("`");if(0>e)var f=[];else{f=/(`+)(\\s*)[^\\x17`]*/g;var q=0,p=[],g=a.replace(/\\x1BB/g,"\\\\`");for(f.lastIndex=e;e=f.exec(g);)p.push({i:e.index,k:e[1].length,P:q,X:e[2].length,next:e.index+e[0].length}),q=e[0].length-e[0].replace(/\\s+$/,"").length;f=p}g=-1;for(q=f.length;++g<
q-1;)for(e=f[g].next,p=g,"`"!==a[f[g].i]&&(++f[g].i,--f[g].k);++p<q&&f[p].i===e;){if(f[p].k===f[g].k){g=f[g];var n=f[p];e=g.i;var m=n.i-n.P;n=n.k+n.P;N("C",e,g.k+g.X,m,n);l(e,m+n-e);g=p;break}e=f[p].next}})();(function(){function e(f,q,p,g,n){var m=N("IMG",f,2,q,p);u(m,g,"src");g=b(n);m.b.alt=g;l(f,q+p-f)}(function(){var f=a.indexOf("![");if(-1!==f){if(0<a.indexOf("](",f))for(var q=/!\\[(?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*\\]\\(( *(?:[^\\x17\\s()]|\\([^\\x17\\s()]*\\))*(?=[ )]) *(?:"[^\\x17]*?"|\'[^\\x17]*?\'|\\([^\\x17)]*\\))? *)\\)/g;f=
q.exec(a);){var p=f[1],g=f.index,n=3+p.length;e(g,g+f[0].length-n,n,p,f[0].substr(2,f[0].length-n-2))}if(w)for(q=/!\\[((?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*)\\](?: ?\\[([^\\x17[\\]]+)\\])?/g;f=q.exec(a);){p=f.index;g=p+2+f[1].length;n=1;var m=f[1],v=m;if(""<f[2]&&t[f[2]])n=f[0].length-m.length-2,v=f[2];else if(!t[v])continue;e(p,g,n,t[v],m)}}})()})();k(">!",/>![^\\x17]+?!</g,"ISPOILER");k("||",/\\|\\|[^\\x17]+?\\|\\|/g,"ISPOILER");(function(){function e(p,g,n,m){var v=N("URL",p,1,g,n,1===n?1:-1);u(v,m,"url");l(p,1);
l(g,n)}function f(){for(var p,g=/\\[(?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*\\]\\(( *(?:[^\\x17\\s()]|\\([^\\x17\\s()]*\\))*(?=[ )]) *(?:"[^\\x17]*?"|\'[^\\x17]*?\'|\\([^\\x17)]*\\))? *)\\)/g;p=g.exec(a);){var n=p[1],m=p.index,v=3+n.length;e(m,m+p[0].length-v,v,n)}}function q(){for(var p={},g,n=/\\[((?:[^\\x17[\\]]|\\[[^\\x17[\\]]*\\])*)\\]/g;g=n.exec(a);)p[g.index]=g[1].toLowerCase();for(var m in p){g=p[m];n=+m+2+g.length;var v=n-1,y=1;" "===a[n]&&++n;""<p[n]&&t[p[n]]&&(g=p[n],y=n+2+g.length-v);t[g]&&e(+m,v,y,t[g])}}-1!==a.indexOf("](")&&
f();w&&q()})();k("~~",/~~[^\\x17]+?~~(?!~)/g,"DEL");h("SUB","~",/~[^\\x17\\s!"#$%&\'()*+,\\-.\\/:;<=>?@[\\]^_`{}|~]+~?/g,/~\\([^\\x17()]+\\)/g);h("SUP","^",/\\^[^\\x17\\s!"#$%&\'()*+,\\-.\\/:;<=>?@[\\]^_`{}|~]+\\^?/g,/\\^\\([^\\x17()]+\\)/g);(function(){function e(E,A){var H=a.indexOf(E);if(-1!==H){E=[];var Q=[],M=a.indexOf("\\u0017",H),ea;for(A.lastIndex=H;ea=A.exec(a);){H=ea.index;ea=ea[0].length;H>M&&(Q.push(E),E=[],M=a.indexOf("\\u0017",H));var S,ma=H,ha=ea;if(S="_"===a.charAt(ma)&&1===ha)S=0<ma&&c(a[ma-1])&&c(a[ma+
ha]);S||E.push([H,ea])}Q.push(E);Q.forEach(f)}}function f(E){v=g=-1;E.forEach(function(A){var H=A[0];A=A[1];var Q=!(-1<" \\n\\t".indexOf(a[H+A-1+1])),M=0<H&&-1<" \\n\\t".indexOf(a.charAt(H-1))?0:Math.min(A,3);q=!!(M&1)&&0<=g;p=!!(M&2)&&0<=v;y=n=H;m=A;0<=g&&g===v&&(q?g+=2:++v);q&&p&&(g<v?n+=2:++y);q&&(--m,N("EM",g,1,n,1),g=-1);p&&(m-=2,N("STRONG",v,2,y,2),v=-1);m=Q?Math.min(m,3):0;H+=A;m&1&&(g=H-m);m&2&&(v=H-m)})}var q,p,g,n,m,v,y;e("*",/\\*+/g);e("_",/_+/g)})();(function(){for(var e=a.indexOf("  \\n");0<
e;)vb(L(3,"br",e+2,0,0),L(3,"v",e+2,1,0)),e=a.indexOf("  \\n",e+3)})()}},MediaEmbed:{q:function(a,b){b.forEach(function(c){var d=c[0][0];L(3,"MEDIA",c[0][1],d.length,-10).b.url=d})},u:"://",v:/\\bhttps?:\\/\\/[^["\'\\s]+/ig,w:5E4},PipeTables:{q:function(a){function b(t,e){k=e.i;e.D.split("|").forEach(function(f,q){0<q&&(vb(u,Fb(k,1,1E3)),++k);q=h.J[q]?h.J[q]:"";var p=k,g=p+f.length;k=g;var n=/^( *).*?( *)$/.exec(f);n[1]&&(f=n[1].length,vb(u,Fb(p,f,1E3)),p+=f);n[2]&&(f=n[2].length,vb(u,Fb(g-f,f,1E3)),g-=
f);g=p===g?L(3,t,p,0,-101):N(t,p,0,g,0,-101);q&&(g.b.align=q)});N("TR",e.i,0,k,0,-102)}function c(){if(h&&2<h.n.length&&/^ *:?-+:?(?:(?:\\+| *\\| *):?-+:?)+ */.test(h.n[1].D)){for(var t=h,e=h.n[1].D,f=["","right","left","center"],q=[],p=/(:?)-+(:?)/g,g;g=p.exec(e);)q.push(f[(g[1]?2:0)+(g[2]?1:0)]);t.J=q;r.push(h)}h=null}function d(t){return t.replace(/[!>]/g," ")}function l(t){return t.replace(/\\|/g,".")}var k,h=null,u,r,w=a;-1<w.indexOf("`")&&(w=w.replace(/`[^`]*`/g,l));-1<w.indexOf(">")&&(w=w.replace(/^(?:>!? ?)+/gm,
d));-1<w.indexOf("\\\\|")&&(w=w.replace(/\\\\[\\\\|]/g,".."));(function(){h=null;r=[];k=0;w.split("\\n").forEach(function(t){if(0>t.indexOf("|"))c();else{var e=t,f=0;h||(h={n:[]},f=/^ */.exec(e)[0].length,e=e.substr(f));e=e.replace(/^( *)\\|/,"$1 ").replace(/\\|( *)$/," $1");h.n.push({D:e,i:k+f})}k+=1+t.length});c()})();(function(){for(var t=-1,e=r.length;++t<e;){h=r[t];var f=h.n[h.n.length-1];u=N("TABLE",h.n[0].i,0,f.i+f.D.length,0,-104);b("TH",h.n[0]);N("THEAD",h.n[0].i,0,k,0,-103);f=h.n[1];vb(u,Fb(f.i-
1,1+f.D.length,1E3));f=1;for(var q=h.n.length;++f<q;)b("TD",h.n[f]);N("TBODY",h.n[2].i,0,k,0,-103)}})()},u:"|"}},O,Ia={"MediaEmbed.hosts":{"bandcamp.com":"bandcamp","dai.ly":"dailymotion","dailymotion.com":"dailymotion","facebook.com":"facebook","liveleak.com":"liveleak","open.spotify.com":"spotify","play.spotify.com":"spotify","soundcloud.com":"soundcloud","twitch.tv":"twitch","vimeo.com":"vimeo","vine.co":"vine","youtu.be":"youtube","youtube.com":"youtube"},"MediaEmbed.sites":{bandcamp:[[],[{z:[[/\\/album=(\\d+)/,
pa]],match:[[/bandcamp\\.com\\/album\\/./,ba]]},{z:[[/"album_id":(\\d+)/,pa],[/"track_num":(\\d+)/,["","track_num"]],[/\\/track=(\\d+)/,qa]],match:[[/bandcamp\\.com\\/track\\/./,ba]]}]],dailymotion:[[[/dai\\.ly\\/([a-z0-9]+)/i,fa],[/dailymotion\\.com\\/(?:live\\/|swf\\/|user\\/[^#]+#video=|(?:related\\/\\d+\\/)?video\\/)([a-z0-9]+)/i,fa],[/start=(\\d+)/,da]],[]],facebook:[[[/\\/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com\\/(?:[\\/\\w]+\\/permalink|(?!pages\\/|groups\\/).*?)(?:\\/|fbid=|\\?v=)(\\d+)(?=$|[\\/?&#])/,fa],[/facebook\\.com\\/([.\\w]+)\\/(post|video)s?\\//,
["","user","type"]],[/facebook\\.com\\/video\\/(post|video)\\.php/,["","type"]]],[]],liveleak:[[[/liveleak\\.com\\/(?:e\\/|view\\?i=)(\\w+)/,fa]],[{z:[[/liveleak\\.com\\/e\\/(\\w+)/,fa]],match:[[/liveleak\\.com\\/view\\?t=/,ba]]}]],soundcloud:[[[/https?:\\/\\/(?:api\\.)?soundcloud\\.com\\/(?!pages\\/)([-\\/\\w]+\\/[-\\/\\w]+|^[^\\/]+\\/[^\\/]+$)/i,fa],[/api\\.soundcloud\\.com\\/playlists\\/(\\d+)/,Da],[/api\\.soundcloud\\.com\\/tracks\\/(\\d+)(?:\\?secret_token=([-\\w]+))?/,["","track_id","secret_token"]],[/soundcloud\\.com\\/(?!playlists|tracks)[-\\w]+\\/[-\\w]+\\/(?=s-)([-\\w]+)/,
["","secret_token"]]],[{z:[[/soundcloud:tracks:(\\d+)/,qa]],T:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/(?!playlists\\/\\d|tracks\\/\\d)[-\\w]+\\/[-\\w]/,ba]]},{z:[[/soundcloud:\\/\\/playlists:(\\d+)/,Da]],T:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/\\w+\\/sets\\//,ba]]}]],spotify:[[[/(?:open|play)\\.spotify\\.com\\/((?:user\\/[-.\\w]+\\/)?(?:album|artist|playlist|track)(?:[:\\/][-.\\w]+)+)/,fa]],[]],twitch:[[[/twitch\\.tv\\/(?:videos|\\w+\\/v)\\/(\\d+)?/,["","video_id"]],[/www\\.twitch\\.tv\\/(?!videos\\/)(\\w+)/,
["","channel"]],[/t=((?:(?:\\d+h)?\\d+m)?\\d+s)/,da],[/clips\\.twitch\\.tv\\/(?:(\\w+)\\/)?(\\w+)/,["","channel","clip_id"]]],[]],vimeo:[[[/vimeo\\.com\\/(?:channels\\/[^\\/]+\\/|video\\/)?(\\d+)/,fa],[/#t=([\\dhms]+)/,da]],[]],vine:[[[/vine\\.co\\/v\\/([^\\/]+)/,fa]],[]],youtube:[[[/youtube\\.com\\/(?:watch.*?v=|v\\/|attribution_link.*?v%3D)([-\\w]+)/,fa],[/youtu\\.be\\/([-\\w]+)/,fa],[/[#&?]t=(\\d[\\dhms]*)/,da],[/[&?]list=([-\\w]+)/,["","list"]]],[{z:[[/\\/vi\\/([-\\w]+)/,fa]],match:[[/\\/shared\\?ci=/,ba]]}]]},urlConfig:{Q:/^(?:ftp|https?|mailto)$/i}},
Hb={d:Ba,flags:8},T={BANDCAMP:{d:ra,b:{album_id:x,track_id:x,track_num:x},h:6,c:F,f:10,e:oa,g:5E3},C:Ua,CODE:{d:ca,b:{lang:Oa},h:1,c:F,f:10,e:{l:z,flags:4436,m:z},g:5E3},DAILYMOTION:{d:ra,b:{id:x,t:x},h:6,c:F,f:10,e:oa,g:5E3},DEL:Xa,EM:Va,EMAIL:{d:ya,b:{email:{c:[function(a){return/^[-\\w.+]+@[-\\w.]+$/.test(a)?a:!1}],r:!0}},h:6,c:F,f:10,e:la,g:5E3},ESC:{d:ca,b:{},h:7,c:F,f:10,e:{flags:1616},g:5E3},FACEBOOK:{d:ra,b:{id:x,type:x,user:x},h:6,c:F,f:10,e:oa,g:5E3},FP:ab,H1:cb,H2:cb,H3:cb,H4:cb,H5:cb,H6:cb,
HC:{d:ca,b:{content:Ea},h:7,c:F,f:10,e:{flags:3153},g:5E3},HE:ab,HR:{d:ua,b:{},h:1,c:F,f:10,e:{l:z,flags:3349},g:5E3},IMG:{d:ua,b:{alt:x,src:Pa,title:x},h:0,c:F,f:10,e:oa,g:5E3},ISPOILER:Wa,LI:gb,LIST:{d:za,b:{start:{c:[function(a){return/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],r:!1},type:Oa},h:1,c:F,f:10,e:Ta,g:5E3},LIVELEAK:$a,MEDIA:{d:[65527,65329,256],b:{},h:16,c:[function(a){return function(b,c,d){function l(k,h,u){var r=!1;u.forEach(function(w){var t=w[1],e=w[0].exec(h);e&&(r=!0,t.forEach(function(f,
q){""<e[q]&&""<f&&(k[f]=e[q])}))});return r}(function(k,h,u){C(k);if("url"in k.b){var r=k.b.url,w;a:{for(w=/^https?:\\/\\/([^\\/]+)/.exec(r.toLowerCase())[1]||"";""<w;){if(h[w]){w=h[w];break a}w=w.replace(/^[^.]*./,"")}w=""}if(u[w]){h={};l(h,r,u[w][0]);a:{for(var t in h){u=!1;break a}u=!0}if(!u){u=k.i;var e=k.y;e?(r=k.k,t=e.i,e=e.k):(r=0,t=k.i+k.k,e=0);k=N(w.toUpperCase(),u,r,t,e,k.p);Ga(k,h)}}}})(b,c,d)}(a,Ia["MediaEmbed.hosts"],Ia["MediaEmbed.sites"],Ia.cacheDir)}],f:10,e:{flags:513},g:5E3},QUOTE:{d:va,
b:{},h:1,c:F,f:10,e:Qa,g:5E3},SOUNDCLOUD:{d:ra,b:{id:x,playlist_id:x,secret_token:x,track_id:x},h:6,c:F,f:10,e:oa,g:5E3},SPOILER:{d:va,b:{},h:4,c:F,f:10,e:Qa,g:5E3},SPOTIFY:$a,STRONG:Va,SUB:Wa,SUP:Wa,TABLE:eb,TBODY:mb,TD:{d:va,b:bb,h:10,c:F,f:10,e:Za,g:5E3},TH:{d:Ca,b:bb,h:10,c:F,f:10,e:Za,g:5E3},THEAD:fb,TR:lb,TWITCH:{d:ra,b:{channel:x,clip_id:x,t:x,video_id:x},h:6,c:F,f:10,e:oa,g:5E3},URL:{d:ya,b:{title:x,url:Pa},h:5,c:F,f:10,e:la,g:5E3},VIMEO:{d:ra,b:{id:x,t:Ha},h:6,c:F,f:10,e:oa,g:5E3},VINE:$a,
YOUTUBE:{d:ra,b:{id:{c:[function(a){return Na(a,/^[-0-9A-Za-z_]+$/)}],r:!1},list:x,t:Ha},h:6,c:F,f:10,e:oa,g:5E3},"html:abbr":{d:xa,b:{title:x},h:0,c:F,f:10,e:ka,g:5E3},"html:b":Va,"html:br":{d:wa,b:{},h:0,c:F,f:10,e:na,g:5E3},"html:code":Ua,"html:dd":{d:va,b:{},h:12,c:F,f:10,e:Ya,g:5E3},"html:del":Xa,"html:div":{d:Ba,b:Fa,h:13,c:F,f:10,e:Qa,g:5E3},"html:dl":{d:[65408,65328,257],b:{},h:1,c:F,f:10,e:Ta,g:5E3},"html:dt":{d:Ca,b:{},h:12,c:F,f:10,e:Ya,g:5E3},"html:i":Va,"html:img":{d:wa,b:{alt:x,height:x,
src:{c:Ma,r:!1},title:x,width:x},h:0,c:F,f:10,e:na,g:5E3},"html:ins":Xa,"html:li":gb,"html:ol":db,"html:pre":{d:xa,b:{},h:1,c:F,f:10,e:{l:z,flags:276,m:z},g:5E3},"html:rb":{d:xa,b:{},h:14,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:rb":1,"html:rt":1,"html:rtc":1,"html:strong":1,"html:u":1},flags:256,m:z},g:5E3},"html:rp":{d:xa,b:{},h:15,c:F,f:10,e:{l:z,flags:256,m:z},g:5E3},"html:rt":{d:xa,b:{},h:15,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,
"html:code":1,"html:i":1,"html:rb":1,"html:rt":1,"html:strong":1,"html:u":1},flags:256,m:z},g:5E3},"html:rtc":{d:[65505,65409,257],b:{},h:14,c:F,f:10,e:{l:{C:1,EM:1,EMAIL:1,STRONG:1,URL:1,"html:b":1,"html:code":1,"html:i":1,"html:rt":1,"html:rtc":1,"html:strong":1,"html:u":1},flags:256,m:z},g:5E3},"html:ruby":{d:[65505,65473,257],b:{},h:0,c:F,f:10,e:ka,g:5E3},"html:span":{d:xa,b:Fa,h:0,c:F,f:10,e:ka,g:5E3},"html:strong":Va,"html:sub":Wa,"html:sup":Wa,"html:table":eb,"html:tbody":mb,"html:td":{d:va,
b:{colspan:x,rowspan:x},h:10,c:F,f:10,e:Za,g:5E3},"html:tfoot":mb,"html:th":{d:Ca,b:{colspan:x,rowspan:x,scope:x},h:10,c:F,f:10,e:Za,g:5E3},"html:thead":fb,"html:tr":lb,"html:u":Va,"html:ul":db},X,Ib,Y,Jb,Kb=0,Lb;
function Mb(a){a=a.replace(/\\r\\n?/g,"\\n");a=a.replace(/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]+/g,"");var b=B;b.p=[];delete b.x;delete b.j;zb={};Ab={};Bb=0;I=null;Cb=!1;Db={};J=[];K="";O=0;X=[];Ib=!1;Y=a;Jb=Y.length;Lb=0;G=Hb;G.A=!1;++Kb;a=Kb;for(var c in Gb)if(!Gb[c].B)a:{b=c;var d=Gb[b];if(!(d.u&&0>Y.indexOf(d.u))){var l=[];if("undefined"!==typeof d.v&&"undefined"!==typeof d.w){l=void 0;var k=d.v;d=d.w;k.lastIndex=0;for(var h=[],u=0;++u<=d&&(l=k.exec(Y));){for(var r=l.index,w=[[l[0],r]],t=0;++t<l.length;){var e=
l[t];void 0===e?w.push(["",-1]):(w.push([e,Y.indexOf(e,r)]),r+=e.length)}h.push(w)}l=h;if(!l.length)break a}(0,Gb[b].q)(Y,l)}}Nb();Ob(Jb,0,!0);do c=K,K=K.replace(/<([^ />]+)[^>]*><\\/\\1>/g,"");while(K!==c);K=K.replace(/<\\/i><i>/g,"");K=K.replace(/[\\x00-\\x08\\x0B-\\x1F]/g,"");K=K.replace(/[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,Pb);b=Cb?"r":"t";c="<"+b;for(var f in Db)c+=" xmlns:"+f+\'="urn:s9e:TextFormatter:\'+f+\'"\';K=c+">"+K+"</"+b+">";if(Kb!==a)throw"The parser has been reset during execution";1E4<Bb&&B.add("warn",
"Fixing cost limit exceeded",void 0);return K}function Qb(a){var b={},c;for(c in T[a])b[c]=T[a][c];return T[a]=b}function Pb(a){return"&#"+((a.charCodeAt(0)<<10)+a.charCodeAt(1)-56613888)+";"}
function Ub(a){Cb=!0;var b=a.name,c=a.i,d=a.k,l=a.flags,k=0,h=0;l&256&&(k=1,h=a.j&2?2:1);var u=!1;a.j&1?l&4&&(u=!0):u=!0;Ob(c,k,u);k=d?rb(Y.substr(c,d)):"";if(a.j&1){l&4||Vb(c);l=b.indexOf(":");0<l&&(Db[b.substr(0,l)]=0);K+="<"+b;var r=xb(a);l=[];for(var w in r)l.push(w);l.sort(function(t,e){return t>e?1:-1});l.forEach(function(t){K+=" "+t+\'="\'+qb(r[t].toString()).replace(/\\n/g,"&#10;")+\'"\'});K=3===a.j?d?K+(">"+k+"</"+b+">"):K+"/>":d?K+("><s>"+k+"</s>"):K+">"}else d&&(K+="<e>"+k+"</e>"),K+="</"+b+
">";for(Lb=O=c+d;h&&Lb<Jb&&"\\n"===Y[Lb];)--h,++Lb}
function Ob(a,b,c){c&&(G.flags&8?b=-1:c=!1);O>=a&&c&&Wb();if(Lb>O){var d=Math.min(a,Lb);K+=Y.substr(O,d-O);O=d;O>=a&&c&&Wb()}if(G.flags&128)d=a-O,b=Y.substr(O,d),/^[ \\n\\t]*$/.test(b)||(b="<i>"+rb(b)+"</i>"),K+=b,O=a,c&&Wb();else{var l=a;for(d=0;b&&--l>=O;){var k=Y[l];if(" "!==k&&"\\n"!==k&&"\\t"!==k)break;"\\n"===k&&--b;++d}a-=d;if(G.flags&8)for(G.A||(Xb(a),a>O&&Vb(a)),b=Y.indexOf("\\n\\n",O);-1<b&&b<a;)Ob(b,0,!0),Vb(a),b=Y.indexOf("\\n\\n",O);a>O&&(b=rb(Y.substr(O,a-O)),K+=b);c&&Wb();d&&(K+=Y.substr(a,
d));O=a+d}}function Yb(a){var b=a.i;a=a.k;var c=Y.substr(b,a);Ob(b,0,!1);K+="<i>"+rb(c)+"</i>";Cb=!0;O=b+a}function Vb(a){!G.A&&G.flags&8&&(Xb(a),O<Jb&&(K+="<p>",G.A=!0))}function Wb(){G.A&&(K+="</p>",G.A=!1)}function Xb(a){for(;O<a&&-1<" \\n\\t".indexOf(Y[O]);)K+=Y[O],++O}function Zb(a,b,c){var d=a.name;(I.flags|a.flags)&256&&(b=$b(b));b=Eb(d,b,0,c||0);wb(b,a)}function $b(a){for(;a>O&&-1<" \\n\\t".indexOf(Y[a-1]);)--a;return a}
function Nb(){if(X.length){for(var a in T)zb[a]=0,Ab[a]=0;do{for(;X.length;)Ib||ac(),I=X.pop(),bc();J.forEach(function(b){Zb(b,Jb)})}while(X.length)}}
function bc(){G.flags&64&&!yb(I,J[J.length-1])&&!(-1<"br i pb v".indexOf(I.name))&&C(I);var a=I.i,b=I.k;if(O>a&&!I.o){var c;if((c=I.F)&&0<=J.indexOf(c)){wb(Eb(c.name,O,Math.max(0,a+b-O)),c);return}if("i"===I.name&&(a=a+b-O,0<a)){Fb(O,a);return}C(I)}if(!I.o)if("i"===I.name)Yb(I);else if("br"===I.name)G.flags&1024||(Ob(I.i,0,!1),K+="<br/>");else if("pb"===I.name)Ob(I.i,0,!0);else if("v"===I.name)a=G.flags,G.flags=I.flags,Ob(I.i+I.k,0,!1),G.flags=a;else if(I.j&1)if(a=I,b=a.name,c=T[b],Ab[b]>=c.g)B.add("err",
"Tag limit exceeded",{tag:a,tagName:b,tagLimit:c.g}),C(a);else{var d=a,l=T[d.name];B.j=d;for(var k=0;k<l.c.length&&!d.o;++k)l.c[k](d,l);delete B.j;if(!(d=a.o)&&(d=1E4>Bb)){a:{d=a;if(J.length){k=d.name;var h=T[k];if(h.e.m){l=J[J.length-1];var u=l.name;if(h.e.m[u]){if(u!==k&&1E4>Bb){k=d.i+d.k;X.length?(h=X[X.length-1],h=h.i):h=Jb+1;for(;k<h&&-1<" \\n\\t".indexOf(Y[k]);)++k;k=cc(l,k);vb(d,k)}X.push(d);Zb(l,d.i,d.p-1);Bb+=4;d=!0;break a}}}d=!1}if(!d)a:{d=a;if(J.length&&(l=T[d.name],l.e.l&&(k=J[J.length-
1],l.e.l[k.name]))){++Bb;X.push(d);Zb(k,d.i,d.p-1);d=!0;break a}d=!1}d=d||!1}d||(zb[b]>=c.f?(B.add("err","Nesting limit exceeded",{tag:a,tagName:b,nestingLimit:c.f}),C(a)):(c=T[b].h,G.d[c>>3]&1<<(c&7)?(!(a.flags&1&&3!==a.j)||a.y||X.length&&yb(X[X.length-1],a)||(b=new ub(3,b,a.i,a.k),Ga(b,xb(a)),b.flags=a.flags,a=b),a.flags&4096&&"\\n"===Y[a.i+a.k]&&Fb(a.i+a.k,1),Ub(a),dc(a)):(b={tag:a,tagName:b},0<a.k?B.add("warn","Tag is not allowed in this context",b):tb("Tag is not allowed in this context",b),C(a))))}else ec()}
function ec(){var a=I;if(zb[a.name]){for(var b=[],c=J.length;0<=--c;){var d=J[c];if(yb(a,d))break;b.push(d);++Bb}if(0>c)tb("Skipping end tag with no start tag",{tag:a});else{var l=a.flags;b.forEach(function(t){l|=t.flags});var k=l&256,h=1E4>Bb,u=[];b.forEach(function(t){var e=t.name;h&&(t.flags&2?u.push(t):h=!1);var f=a.i;k&&(f=$b(f));e=new ub(2,e,f,0);e.flags=t.flags;Ub(e);fc()});Ub(a);fc();if(b.length&&1E4>Bb){d=O;for(c=X.length;0<=--c&&1E4>++Bb;){var r=X[c];if(r.i>d||r.j&1)break;for(var w=b.length;0<=
--w&&1E4>++Bb;)if(yb(r,b[w])){b.splice(w,1);u[w]&&u.splice(w,1);d=Math.max(d,r.i+r.k);break}}d>O&&Yb(new ub(3,"i",O,d-O))}u.forEach(function(t){var e=cc(t,O);(t=t.y)&&wb(e,t)})}}}function fc(){var a=J.pop();--zb[a.name];G=G.V}function dc(a){var b=a.name,c=a.flags,d=T[b];++Ab[b];if(3!==a.j){var l=[];G.d.forEach(function(h,u){c&512||(h=h&65280|h>>8);l.push(d.d[u]&h)});var k=c|G.flags&32;k&16&&(k&=-33);++zb[b];J.push(a);G={V:G};G.d=l;G.flags=k}}function Eb(a,b,c,d){return L(2,a,b,c,d||0)}
function Fb(a,b,c){return L(3,"i",a,Math.min(b,Jb-a),c||0)}function cc(a,b){b=L(a.j,a.name,b,0,a.p);Ga(b,xb(a));return b}function L(a,b,c,d,l){a=new ub(a,b,c,d,l||0);T[b]&&(a.flags=T[b].e.flags);if(!(T[b]||-1<"br i pb v".indexOf(a.name))||0>d||0>c||c+d>Jb||/[\\uDC00-\\uDFFF]/.test(Y.substr(c,1)+Y.substr(c+d,1)))C(a);else if(T[b]&&T[b].B)B.add("warn","Tag is disabled",{tag:a,tagName:b}),C(a);else if(Ib){b=X.length;for(c=gc(a);0<b&&c>gc(X[b-1]);)X[b]=X[b-1],--b;X[b]=a}else X.push(a);return a}
function N(a,b,c,d,l,k){d=Eb(a,d,l,-k||0);a=L(1,a,b,c,k||0);wb(a,d);return a}function ac(){for(var a={},b=[],c=X.length;0<=--c;){var d=X[c],l=gc(d,c);b.push(l);a[l]=d}b.sort();c=b.length;for(X=[];0<=--c;)X.push(a[b[c]]);Ib=!0}function gc(a,b){var c=0<=a.p,d=a.p;c||(d+=1073741824);var l=0<a.k,k;l?k=Jb-a.k:k={2:0,3:1,1:2}[a.j];return hc(a.i)+ +c+hc(d)+ +l+hc(k)+hc(b||0)}function hc(a){a=a.toString(16);return"        ".substr(a.length)+a}var ic="undefined"===typeof DOMParser||"undefined"===typeof XSLTProcessor;
function jc(a){if(ic){var b=new ActiveXObject("MSXML2.FreeThreadedDOMDocument.6.0");b.async=!1;b.validateOnParse=!1;b.loadXML(a)}else b=(new DOMParser).parseFromString(a,"text/xml");if(!b)throw"Cannot parse "+a;return b}function kc(a,b){if(ic){var c=b.createElement("div");b=b.createDocumentFragment();lc.input=jc(a);lc.transform();for(c.innerHTML=lc.output;c.firstChild;)b.appendChild(c.firstChild);return b}return lc.transformToFragment(jc(a),b)}var lc,mc=jc(nb);
if(ic){var nc=new ActiveXObject("MSXML2.XSLTemplate.6.0");nc.stylesheet=mc;lc=nc.createProcessor()}else lc=new XSLTProcessor,lc.importStylesheet(mc);window.s9e||(window.s9e={});
window.s9e.TextFormatter={disablePlugin:function(a){Gb[a]&&(Gb[a].B=!0)},disableTag:function(a){T[a]&&(Qb(a).B=!0)},enablePlugin:function(a){Gb[a]&&(Gb[a].B=!1)},enableTag:function(a){T[a]&&(Qb(a).B=!1)},getLogger:function(){return B},parse:Mb,preview:function(a,b){function c(h,u){var r=h.childNodes;u=u.childNodes;for(var w=r.length,t=u.length,e,f,q=0,p=0;q<w&&q<t;){e=r[q];f=u[q];if(!d(e,f))break;++q}for(var g=Math.min(w-q,t-q);p<g;){e=r[w-(p+1)];f=u[t-(p+1)];if(!d(e,f))break;++p}for(w-=p;--w>=q;)h.removeChild(r[w]),
k=h;r=t-p;if(!(q>=r)){t=l.createDocumentFragment();w=q;do f=u[w],k=t.appendChild(f);while(w<--r);p?h.insertBefore(t,h.childNodes[q]):h.appendChild(t)}}function d(h,u){if(h.nodeName!==u.nodeName||h.nodeType!==u.nodeType)return!1;if(h instanceof HTMLElement&&u instanceof HTMLElement){if(!h.isEqualNode(u)){for(var r=h.attributes,w=u.attributes,t=w.length,e=r.length,f=" "+h.getAttribute("data-s9e-livepreview-ignore-attrs")+" ";0<=--e;){var q=r[e],p=q.namespaceURI;q=q.name;-1<f.indexOf(" "+q+" ")||u.hasAttributeNS(p,
q)||(h.removeAttributeNS(p,q),k=h)}for(e=t;0<=--e;)r=w[e],p=r.namespaceURI,q=r.name,r=r.value,-1<f.indexOf(" "+q+" ")||r===h.getAttributeNS(p,q)||(h.setAttributeNS(p,q,r),k=h);c(h,u)}}else 3!==h.nodeType&&8!==h.nodeType||h.nodeValue===u.nodeValue||(h.nodeValue=u.nodeValue,k=h);return!0}var l=b.ownerDocument;if(!l)throw"Target does not have a ownerDocument";a=kc(Mb(a).replace(/<[eis]>[^<]*<\\/[eis]>/g,""),l);var k=b;c(b,a);return k},registeredVars:Ia,setNestingLimit:function(a,b){T[a]&&(Qb(a).f=b)},
setParameter:function(a,b){ic?lc.addParameter(a,b,""):lc.setParameter(null,a,b)},setTagLimit:function(a,b){T[a]&&(Qb(a).g=b)}};})();';
	}

	/**
	* {@inheritdoc}
	*/
	public static function getParser()
	{
		return unserialize('O:24:"s9e\\TextFormatter\\Parser":4:{s:16:"' . "\0" . '*' . "\0" . 'pluginsConfig";a:10:{s:9:"Autoemail";a:5:{s:8:"attrName";s:5:"email";s:10:"quickMatch";s:1:"@";s:6:"regexp";s:39:"/\\b[-a-z0-9_+.]+@[-a-z0-9.]*[a-z0-9]/Si";s:7:"tagName";s:5:"EMAIL";s:11:"regexpLimit";i:50000;}s:8:"Autolink";a:5:{s:8:"attrName";s:3:"url";s:6:"regexp";s:139:"#\\b(?:ftp|https?|mailto)://\\S(?>[^\\s()\\[\\]\\x{FF01}-\\x{FF0F}\\x{FF1A}-\\x{FF20}\\x{FF3B}-\\x{FF40}\\x{FF5B}-\\x{FF65}]|\\([^\\s()]*\\)|\\[\\w*\\])++#Siu";s:7:"tagName";s:3:"URL";s:10:"quickMatch";s:3:"://";s:11:"regexpLimit";i:50000;}s:7:"Escaper";a:4:{s:10:"quickMatch";s:1:"\\";s:6:"regexp";s:30:"/\\\\[-!#()*+.:<>@[\\\\\\]^_`{|}~]/";s:7:"tagName";s:3:"ESC";s:11:"regexpLimit";i:50000;}s:10:"FancyPants";a:2:{s:8:"attrName";s:4:"char";s:7:"tagName";s:2:"FP";}s:12:"HTMLComments";a:5:{s:8:"attrName";s:7:"content";s:10:"quickMatch";s:4:"<!--";s:6:"regexp";s:22:"/<!--(?!\\[if).*?-->/is";s:7:"tagName";s:2:"HC";s:11:"regexpLimit";i:50000;}s:12:"HTMLElements";a:5:{s:10:"quickMatch";s:1:"<";s:6:"prefix";s:4:"html";s:6:"regexp";s:385:"#<(?>/((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))|((?:a(?:bbr)?|br?|code|d(?:[dlt]|el|iv)|em|hr|i(?:mg|ns)?|li|ol|pre|r(?:[bp]|tc?|uby)|s(?:pan|trong|u[bp])?|t(?:[dr]|able|body|foot|h(?:ead)?)|ul?))((?>\\s+[a-z][-a-z0-9]*(?>\\s*=\\s*(?>"[^"]*"|\'[^\']*\'|[^\\s"\'=<>`]+))?)*+)\\s*/?)\\s*>#i";s:7:"aliases";a:6:{s:1:"a";a:2:{s:0:"";s:3:"URL";s:4:"href";s:3:"url";}s:2:"hr";a:1:{s:0:"";s:2:"HR";}s:2:"em";a:1:{s:0:"";s:2:"EM";}s:1:"s";a:1:{s:0:"";s:1:"S";}s:6:"strong";a:1:{s:0:"";s:6:"STRONG";}s:3:"sup";a:1:{s:0:"";s:3:"SUP";}}s:11:"regexpLimit";i:50000;}s:12:"HTMLEntities";a:5:{s:8:"attrName";s:4:"char";s:10:"quickMatch";s:1:"&";s:6:"regexp";s:38:"/&(?>[a-z]+|#(?>[0-9]+|x[0-9a-f]+));/i";s:7:"tagName";s:2:"HE";s:11:"regexpLimit";i:50000;}s:8:"Litedown";a:1:{s:18:"decodeHtmlEntities";b:1;}s:10:"MediaEmbed";a:4:{s:10:"quickMatch";s:3:"://";s:6:"regexp";s:26:"/\\bhttps?:\\/\\/[^["\'\\s]+/Si";s:7:"tagName";s:5:"MEDIA";s:11:"regexpLimit";i:50000;}s:10:"PipeTables";a:3:{s:16:"overwriteEscapes";b:1;s:17:"overwriteMarkdown";b:1;s:10:"quickMatch";s:1:"|";}}s:14:"registeredVars";a:3:{s:9:"urlConfig";a:1:{s:14:"allowedSchemes";s:27:"/^(?:ftp|https?|mailto)$/Di";}s:16:"MediaEmbed.hosts";a:13:{s:12:"bandcamp.com";s:8:"bandcamp";s:6:"dai.ly";s:11:"dailymotion";s:15:"dailymotion.com";s:11:"dailymotion";s:12:"facebook.com";s:8:"facebook";s:12:"liveleak.com";s:8:"liveleak";s:14:"soundcloud.com";s:10:"soundcloud";s:16:"open.spotify.com";s:7:"spotify";s:16:"play.spotify.com";s:7:"spotify";s:9:"twitch.tv";s:6:"twitch";s:9:"vimeo.com";s:5:"vimeo";s:7:"vine.co";s:4:"vine";s:11:"youtube.com";s:7:"youtube";s:8:"youtu.be";s:7:"youtube";}s:16:"MediaEmbed.sites";a:10:{s:8:"bandcamp";a:2:{i:0;a:0:{}i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!/album=(?\'album_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"album_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/album/.!";i:1;a:1:{i:0;s:0:"";}}}}i:1;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:29:"!"album_id":(?\'album_id\'\\d+)!";i:1;R:90;}i:1;a:2:{i:0;s:31:"!"track_num":(?\'track_num\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"track_num";}}i:2;a:2:{i:0;s:25:"!/track=(?\'track_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"track_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/track/.!";i:1;R:96;}}}}}s:11:"dailymotion";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:27:"!dai\\.ly/(?\'id\'[a-z0-9]+)!i";i:1;a:2:{i:0;s:0:"";i:1;s:2:"id";}}i:1;a:2:{i:0;s:92:"!dailymotion\\.com/(?:live/|swf/|user/[^#]+#video=|(?:related/\\d+/)?video/)(?\'id\'[a-z0-9]+)!i";i:1;R:119;}i:2;a:2:{i:0;s:17:"!start=(?\'t\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:1:"t";}}}i:1;R:84;}s:8:"facebook";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:135:"@/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com/(?:[/\\w]+/permalink|(?!pages/|groups/).*?)(?:/|fbid=|\\?v=)(?\'id\'\\d+)(?=$|[/?&#])@";i:1;R:119;}i:1;a:2:{i:0;s:54:"@facebook\\.com/(?\'user\'[.\\w]+)/(?\'type\'post|video)s?/@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";}}i:2;a:2:{i:0;s:46:"@facebook\\.com/video/(?\'type\'post|video)\\.php@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"type";}}}i:1;R:84;}s:8:"liveleak";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!liveleak\\.com/(?:e/|view\\?i=)(?\'id\'\\w+)!";i:1;R:119;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"!liveleak\\.com/e/(?\'id\'\\w+)!";i:1;R:119;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!liveleak\\.com/view\\?t=!";i:1;R:96;}}}}}s:10:"soundcloud";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:84:"@https?://(?:api\\.)?soundcloud\\.com/(?!pages/)(?\'id\'[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)@i";i:1;R:119;}i:1;a:2:{i:0;s:52:"@api\\.soundcloud\\.com/playlists/(?\'playlist_id\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:11:"playlist_id";}}i:2;a:2:{i:0;s:89:"@api\\.soundcloud\\.com/tracks/(?\'track_id\'\\d+)(?:\\?secret_token=(?\'secret_token\'[-\\w]+))?@";i:1;a:3:{i:0;s:0:"";i:1;s:8:"track_id";i:2;s:12:"secret_token";}}i:3;a:2:{i:0;s:81:"@soundcloud\\.com/(?!playlists|tracks)[-\\w]+/[-\\w]+/(?=s-)(?\'secret_token\'[-\\w]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:12:"secret_token";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:36:"@soundcloud:tracks:(?\'track_id\'\\d+)@";i:1;R:109;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"@soundcloud\\.com/(?!playlists/\\d|tracks/\\d)[-\\w]+/[-\\w]@";i:1;R:96;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:44:"@soundcloud://playlists:(?\'playlist_id\'\\d+)@";i:1;R:162;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:27:"@soundcloud\\.com/\\w+/sets/@";i:1;R:96;}}}}}s:7:"spotify";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:102:"!(?:open|play)\\.spotify\\.com/(?\'id\'(?:user/[-.\\w]+/)?(?:album|artist|playlist|track)(?:[:/][-.\\w]+)+)!";i:1;R:119;}}i:1;R:84;}s:6:"twitch";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:47:"#twitch\\.tv/(?:videos|\\w+/v)/(?\'video_id\'\\d+)?#";i:1;a:2:{i:0;s:0:"";i:1;s:8:"video_id";}}i:1;a:2:{i:0;s:44:"#www\\.twitch\\.tv/(?!videos/)(?\'channel\'\\w+)#";i:1;a:2:{i:0;s:0:"";i:1;s:7:"channel";}}i:2;a:2:{i:0;s:32:"#t=(?\'t\'(?:(?:\\d+h)?\\d+m)?\\d+s)#";i:1;R:126;}i:3;a:2:{i:0;s:56:"#clips\\.twitch\\.tv/(?:(?\'channel\'\\w+)/)?(?\'clip_id\'\\w+)#";i:1;a:3:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:7:"clip_id";}}}i:1;R:84;}s:5:"vimeo";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!vimeo\\.com/(?:channels/[^/]+/|video/)?(?\'id\'\\d+)!";i:1;R:119;}i:1;a:2:{i:0;s:19:"!#t=(?\'t\'[\\dhms]+)!";i:1;R:126;}}i:1;R:84;}s:4:"vine";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!vine\\.co/v/(?\'id\'[^/]+)!";i:1;R:119;}}i:1;R:84;}s:7:"youtube";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:69:"!youtube\\.com/(?:watch.*?v=|v/|attribution_link.*?v%3D)(?\'id\'[-\\w]+)!";i:1;R:119;}i:1;a:2:{i:0;s:25:"!youtu\\.be/(?\'id\'[-\\w]+)!";i:1;R:119;}i:2;a:2:{i:0;s:25:"@[#&?]t=(?\'t\'\\d[\\dhms]*)@";i:1;R:126;}i:3;a:2:{i:0;s:26:"![&?]list=(?\'list\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:4:"list";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!/vi/(?\'id\'[-\\w]+)!";i:1;R:119;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:14:"!/shared\\?ci=!";i:1;R:96;}}}}}}}s:14:"' . "\0" . '*' . "\0" . 'rootContext";a:2:{s:7:"allowed";a:3:{i:0;i:65527;i:1;i:65329;i:2;i:257;}s:5:"flags";i:8;}s:13:"' . "\0" . '*' . "\0" . 'tagsConfig";a:76:{s:8:"BANDCAMP";a:7:{s:10:"attributes";a:3:{s:8:"album_id";a:2:{s:8:"required";b:0;s:11:"filterChain";R:84;}s:8:"track_id";R:257;s:9:"track_num";R:257;}s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\FilterProcessing::filterAttributes";s:6:"params";a:4:{s:3:"tag";N;s:9:"tagConfig";N;s:14:"registeredVars";N;s:6:"logger";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3089;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:6;s:7:"allowed";a:3:{i:0;i:32928;i:1;i:257;i:2;i:256;}}s:1:"C";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:66;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:0;s:7:"allowed";a:3:{i:0;i:0;i:1;i:0;i:2;i:0;}}s:4:"CODE";a:7:{s:10:"attributes";a:1:{s:4:"lang";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:23:"/^[- +,.0-9A-Za-z_]+$/D";}}}s:8:"required";b:0;}}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:10:{s:1:"C";i:1;s:2:"EM";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:5:"EMAIL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;}s:12:"fosterParent";R:298;s:5:"flags";i:4436;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:282;}s:11:"DAILYMOTION";a:7:{s:10:"attributes";a:2:{s:2:"id";R:257;s:1:"t";R:257;}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:268;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:6;s:7:"allowed";R:272;}s:3:"DEL";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:512;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:0;s:7:"allowed";R:249;}s:2:"EM";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:2;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:0;s:7:"allowed";a:3:{i:0;i:65505;i:1;i:65281;i:2;i:257;}}s:5:"EMAIL";a:7:{s:10:"attributes";a:1:{s:5:"email";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:61:"s9e\\TextFormatter\\Parser\\AttributeFilters\\EmailFilter::filter";s:6:"params";a:1:{s:9:"attrValue";N;}}}s:8:"required";b:1;}}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:514;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:6;s:7:"allowed";a:3:{i:0;i:36743;i:1;i:65329;i:2;i:257;}}s:3:"ESC";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:1616;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:7;s:7:"allowed";R:282;}s:8:"FACEBOOK";a:7:{s:10:"attributes";a:3:{s:2:"id";R:257;s:4:"type";R:257;s:4:"user";R:257;}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:268;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:6;s:7:"allowed";R:272;}s:2:"FP";a:7:{s:10:"attributes";a:1:{s:4:"char";a:2:{s:8:"required";b:1;s:11:"filterChain";R:84;}}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:268;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:8;s:7:"allowed";a:3:{i:0;i:32896;i:1;i:257;i:2;i:257;}}s:2:"H1";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:298;s:12:"fosterParent";R:298;s:5:"flags";i:260;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:2;s:7:"allowed";R:329;}s:2:"H2";R:373;s:2:"H3";R:373;s:2:"H4";R:373;s:2:"H5";R:373;s:2:"H6";R:373;s:2:"HC";a:7:{s:10:"attributes";a:1:{s:7:"content";R:364;}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3153;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:7;s:7:"allowed";R:282;}s:2:"HE";R:362;s:2:"HR";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:2:{s:11:"closeParent";R:298;s:5:"flags";i:3349;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:1;s:7:"allowed";R:369;}s:3:"IMG";a:7:{s:10:"attributes";a:3:{s:3:"alt";R:257;s:3:"src";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\AttributeFilters\\UrlFilter::filter";s:6:"params";a:3:{s:9:"attrValue";N;s:9:"urlConfig";N;s:6:"logger";N;}}}s:8:"required";b:1;}s:5:"title";R:257;}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:268;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:369;}s:8:"ISPOILER";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:0;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:0;s:7:"allowed";R:329;}s:2:"LI";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"C";i:1;s:2:"EM";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:5:"EMAIL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:2:"LI";i:1;s:7:"html:li";i:1;}s:12:"fosterParent";R:298;s:5:"flags";i:264;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:3;s:7:"allowed";a:3:{i:0;i:65527;i:1;i:65313;i:2;i:257;}}s:4:"LIST";a:7:{s:10:"attributes";a:2:{s:5:"start";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:67:"s9e\\TextFormatter\\Parser\\AttributeFilters\\NumericFilter::filterUint";s:6:"params";R:339;}}s:8:"required";b:0;}s:4:"type";R:288;}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:298;s:12:"fosterParent";R:298;s:5:"flags";i:3460;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";a:3:{i:0;i:65416;i:1;i:65280;i:2;i:257;}}s:8:"LIVELEAK";a:7:{s:10:"attributes";a:1:{s:2:"id";R:257;}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:268;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:6;s:7:"allowed";R:272;}s:5:"MEDIA";a:7:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:54:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::filterTag";s:6:"params";a:5:{s:3:"tag";N;s:6:"parser";N;s:16:"MediaEmbed.hosts";N;s:16:"MediaEmbed.sites";N;s:8:"cacheDir";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:513;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:16;s:7:"allowed";a:3:{i:0;i:65527;i:1;i:65329;i:2;i:256;}}s:5:"QUOTE";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:298;s:12:"fosterParent";R:298;s:5:"flags";i:268;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:1;s:7:"allowed";R:431;}s:10:"SOUNDCLOUD";a:7:{s:10:"attributes";a:4:{s:2:"id";R:257;s:11:"playlist_id";R:257;s:12:"secret_token";R:257;s:8:"track_id";R:257;}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:268;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:6;s:7:"allowed";R:272;}s:7:"SPOILER";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:477;s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:4;s:7:"allowed";R:431;}s:7:"SPOTIFY";R:451;s:6:"STRONG";R:323;s:3:"SUB";R:406;s:3:"SUP";R:406;s:5:"TABLE";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:443;s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:1;s:7:"allowed";a:3:{i:0;i:65408;i:1;i:65290;i:2;i:257;}}s:5:"TBODY";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:20:{s:1:"C";i:1;s:2:"EM";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:5:"EMAIL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:5:"TBODY";i:1;s:2:"TD";i:1;s:2:"TH";i:1;s:5:"THEAD";i:1;s:2:"TR";i:1;s:10:"html:tbody";i:1;s:7:"html:td";i:1;s:7:"html:th";i:1;s:10:"html:thead";i:1;s:7:"html:tr";i:1;}s:12:"fosterParent";R:298;s:5:"flags";i:3456;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:9;s:7:"allowed";a:3:{i:0;i:65408;i:1;i:65288;i:2;i:257;}}s:2:"TD";a:7:{s:10:"attributes";a:1:{s:5:"align";a:2:{s:11:"filterChain";a:2:{i:0;a:2:{s:8:"callback";s:10:"strtolower";s:6:"params";R:339;}i:1;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:34:"/^(?:center|justify|left|right)$/D";}}}s:8:"required";b:0;}}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:14:{s:1:"C";i:1;s:2:"EM";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:5:"EMAIL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:2:"TD";i:1;s:2:"TH";i:1;s:7:"html:td";i:1;s:7:"html:th";i:1;}s:12:"fosterParent";R:298;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";R:431;}s:2:"TH";a:7:{s:10:"attributes";R:530;s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:542;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";a:3:{i:0;i:64499;i:1;i:65313;i:2;i:257;}}s:5:"THEAD";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:298;s:12:"fosterParent";R:298;s:5:"flags";i:3456;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:9;s:7:"allowed";R:525;}s:2:"TR";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:16:{s:1:"C";i:1;s:2:"EM";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:5:"EMAIL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:2:"TD";i:1;s:2:"TH";i:1;s:2:"TR";i:1;s:7:"html:td";i:1;s:7:"html:th";i:1;s:7:"html:tr";i:1;}s:12:"fosterParent";R:298;s:5:"flags";i:3456;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:11;s:7:"allowed";a:3:{i:0;i:65408;i:1;i:65284;i:2;i:257;}}s:6:"TWITCH";a:7:{s:10:"attributes";a:4:{s:7:"channel";R:257;s:7:"clip_id";R:257;s:1:"t";R:257;s:8:"video_id";R:257;}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:268;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:6;s:7:"allowed";R:272;}s:3:"URL";a:7:{s:10:"attributes";a:2:{s:5:"title";R:257;s:3:"url";R:394;}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:343;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:5;s:7:"allowed";R:347;}s:5:"VIMEO";a:7:{s:10:"attributes";a:2:{s:2:"id";R:257;s:1:"t";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:65:"s9e\\TextFormatter\\Parser\\AttributeFilters\\TimestampFilter::filter";s:6:"params";R:339;}}s:8:"required";b:0;}}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:268;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:6;s:7:"allowed";R:272;}s:4:"VINE";R:451;s:7:"YOUTUBE";a:7:{s:10:"attributes";a:3:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:19:"/^[-0-9A-Za-z_]+$/D";}}}s:8:"required";b:0;}s:4:"list";R:257;s:1:"t";R:614;}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:268;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:6;s:7:"allowed";R:272;}s:9:"html:abbr";a:7:{s:10:"attributes";a:1:{s:5:"title";R:257;}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:408;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:329;}s:6:"html:b";R:323;s:7:"html:br";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3201;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:0;s:7:"allowed";a:3:{i:0;i:65408;i:1;i:65280;i:2;i:257;}}s:9:"html:code";R:276;s:7:"html:dd";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"C";i:1;s:2:"EM";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:5:"EMAIL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:7:"html:dd";i:1;s:7:"html:dt";i:1;}s:12:"fosterParent";R:298;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:12;s:7:"allowed";R:431;}s:8:"html:del";R:317;s:8:"html:div";a:7:{s:10:"attributes";a:1:{s:5:"class";R:257;}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:477;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:13;s:7:"allowed";R:249;}s:7:"html:dl";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:443;s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:1;s:7:"allowed";a:3:{i:0;i:65408;i:1;i:65328;i:2;i:257;}}s:7:"html:dt";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:652;s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:12;s:7:"allowed";R:565;}s:6:"html:i";R:323;s:8:"html:img";a:7:{s:10:"attributes";a:5:{s:3:"alt";R:257;s:6:"height";R:257;s:3:"src";a:2:{s:11:"filterChain";R:395;s:8:"required";b:0;}s:5:"title";R:257;s:5:"width";R:257;}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:642;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:646;}s:8:"html:ins";R:317;s:7:"html:li";R:412;s:7:"html:ol";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:443;s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:1;s:7:"allowed";R:447;}s:8:"html:pre";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:298;s:12:"fosterParent";R:298;s:5:"flags";i:276;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:1;s:7:"allowed";R:329;}s:7:"html:rb";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:13:{s:1:"C";i:1;s:2:"EM";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:5:"EMAIL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:7:"html:rb";i:1;s:7:"html:rt";i:1;s:8:"html:rtc";i:1;}s:12:"fosterParent";R:298;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:14;s:7:"allowed";R:329;}s:7:"html:rp";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";R:298;s:12:"fosterParent";R:298;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:15;s:7:"allowed";R:329;}s:7:"html:rt";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"C";i:1;s:2:"EM";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:5:"EMAIL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:7:"html:rb";i:1;s:7:"html:rt";i:1;}s:12:"fosterParent";R:298;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:15;s:7:"allowed";R:329;}s:8:"html:rtc";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";a:3:{s:11:"closeParent";a:12:{s:1:"C";i:1;s:2:"EM";i:1;s:6:"STRONG";i:1;s:3:"URL";i:1;s:5:"EMAIL";i:1;s:6:"html:b";i:1;s:9:"html:code";i:1;s:6:"html:i";i:1;s:11:"html:strong";i:1;s:6:"html:u";i:1;s:7:"html:rt";i:1;s:8:"html:rtc";i:1;}s:12:"fosterParent";R:298;s:5:"flags";i:256;}s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:14;s:7:"allowed";a:3:{i:0;i:65505;i:1;i:65409;i:2;i:257;}}s:9:"html:ruby";a:7:{s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:408;s:8:"tagLimit";i:5000;s:10:"attributes";R:84;s:9:"bitNumber";i:0;s:7:"allowed";a:3:{i:0;i:65505;i:1;i:65473;i:2;i:257;}}s:9:"html:span";a:7:{s:10:"attributes";R:670;s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:408;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:0;s:7:"allowed";R:329;}s:11:"html:strong";R:323;s:8:"html:sub";R:406;s:8:"html:sup";R:406;s:10:"html:table";R:490;s:10:"html:tbody";R:498;s:7:"html:td";a:7:{s:10:"attributes";a:2:{s:7:"colspan";R:257;s:7:"rowspan";R:257;}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:542;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";R:431;}s:10:"html:tfoot";R:498;s:7:"html:th";a:7:{s:10:"attributes";a:3:{s:7:"colspan";R:257;s:7:"rowspan";R:257;s:5:"scope";R:257;}s:11:"filterChain";R:259;s:12:"nestingLimit";i:10;s:5:"rules";R:542;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:10;s:7:"allowed";R:565;}s:10:"html:thead";R:569;s:7:"html:tr";R:575;s:6:"html:u";R:323;s:7:"html:ul";R:693;}}');
	}

	/**
	* {@inheritdoc}
	*/
	public static function getRenderer()
	{
		return unserialize('O:42:"s9e\\TextFormatter\\Bundles\\Fatdown\\Renderer":2:{s:19:"enableQuickRenderer";b:1;s:9:"' . "\0" . '*' . "\0" . 'params";a:0:{}}');
	}
}