<?php

/*
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2019 The s9e Authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Plugins\Emoji;
use s9e\TextFormatter\Configurator\Helpers\ConfigHelper;
use s9e\TextFormatter\Configurator\Helpers\RegexpBuilder;
use s9e\TextFormatter\Configurator\Items\Regexp;
use s9e\TextFormatter\Configurator\JavaScript\Dictionary;
use s9e\TextFormatter\Plugins\ConfiguratorBase;
class Configurator extends ConfiguratorBase
{
	protected $attrName = 'seq';
	public $aliases = [':-1:'=>"\xf0\x9f\x91\x8e",':+1:'=>"\xf0\x9f\x91\x8d",':1st_place_medal:'=>"\xf0\x9f\xa5\x87",':2nd_place_medal:'=>"\xf0\x9f\xa5\x88",':3rd_place_medal:'=>"\xf0\x9f\xa5\x89",':8ball:'=>"\xf0\x9f\x8e\xb1",':a:'=>"\xf0\x9f\x85\xb0\xef\xb8\x8f",':ab:'=>"\xf0\x9f\x86\x8e",':abc:'=>"\xf0\x9f\x94\xa4",':abcd:'=>"\xf0\x9f\x94\xa1",':accept:'=>"\xf0\x9f\x89\x91",':adult:'=>"\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf",':adult_tone1:'=>"\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbb",':adult_tone2:'=>"\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbc",':adult_tone3:'=>"\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbd",':adult_tone4:'=>"\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbe",':adult_tone5:'=>"\xf0\x9f\xa7\x91\xf0\x9f\x8f\xbf",':aerial_tramway:'=>"\xf0\x9f\x9a\xa1",':afghanistan:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xab",':airplane:'=>"\xe2\x9c\x88\xef\xb8\x8f",':airplane_arriving:'=>"\xf0\x9f\x9b\xac",':airplane_departure:'=>"\xf0\x9f\x9b\xab",':airplane_small:'=>"\xf0\x9f\x9b\xa9\xef\xb8\x8f",':aland_islands:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xbd",':alarm_clock:'=>"\xe2\x8f\xb0",':albania:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xb1",':alembic:'=>"\xe2\x9a\x97\xef\xb8\x8f",':algeria:'=>"\xf0\x9f\x87\xa9\xf0\x9f\x87\xbf",':alien:'=>"\xf0\x9f\x91\xbd",':ambulance:'=>"\xf0\x9f\x9a\x91",':american_samoa:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xb8",':amphora:'=>"\xf0\x9f\x8f\xba",':anchor:'=>"\xe2\x9a\x93\xef\xb8\x8f",':andorra:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xa9",':angel:'=>"\xf0\x9f\x91\xbc",':angel_tone1:'=>"\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbb",':angel_tone2:'=>"\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbc",':angel_tone3:'=>"\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbd",':angel_tone4:'=>"\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbe",':angel_tone5:'=>"\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbf",':anger:'=>"\xf0\x9f\x92\xa2",':anger_right:'=>"\xf0\x9f\x97\xaf\xef\xb8\x8f",':angola:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xb4",':angry:'=>"\xf0\x9f\x98\xa0",':anguilla:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xae",':anguished:'=>"\xf0\x9f\x98\xa7",':ant:'=>"\xf0\x9f\x90\x9c",':antarctica:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xb6",':antigua_barbuda:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xac",':apple:'=>"\xf0\x9f\x8d\x8e",':aquarius:'=>"\xe2\x99\x92\xef\xb8\x8f",':argentina:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xb7",':aries:'=>"\xe2\x99\x88\xef\xb8\x8f",':armenia:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xb2",':arrow_backward:'=>"\xe2\x97\x80\xef\xb8\x8f",':arrow_double_down:'=>"\xe2\x8f\xac",':arrow_double_up:'=>"\xe2\x8f\xab",':arrow_down:'=>"\xe2\xac\x87\xef\xb8\x8f",':arrow_down_small:'=>"\xf0\x9f\x94\xbd",':arrow_forward:'=>"\xe2\x96\xb6\xef\xb8\x8f",':arrow_heading_down:'=>"\xe2\xa4\xb5\xef\xb8\x8f",':arrow_heading_up:'=>"\xe2\xa4\xb4\xef\xb8\x8f",':arrow_left:'=>"\xe2\xac\x85\xef\xb8\x8f",':arrow_lower_left:'=>"\xe2\x86\x99\xef\xb8\x8f",':arrow_lower_right:'=>"\xe2\x86\x98\xef\xb8\x8f",':arrow_right:'=>"\xe2\x9e\xa1\xef\xb8\x8f",':arrow_right_hook:'=>"\xe2\x86\xaa\xef\xb8\x8f",':arrow_up:'=>"\xe2\xac\x86\xef\xb8\x8f",':arrow_up_down:'=>"\xe2\x86\x95\xef\xb8\x8f",':arrow_up_small:'=>"\xf0\x9f\x94\xbc",':arrow_upper_left:'=>"\xe2\x86\x96\xef\xb8\x8f",':arrow_upper_right:'=>"\xe2\x86\x97\xef\xb8\x8f",':arrows_clockwise:'=>"\xf0\x9f\x94\x83",':arrows_counterclockwise:'=>"\xf0\x9f\x94\x84",':art:'=>"\xf0\x9f\x8e\xa8",':articulated_lorry:'=>"\xf0\x9f\x9a\x9b",':artificial_satellite:'=>"\xf0\x9f\x9b\xb0",':aruba:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xbc",':asterisk:'=>"*\xe2\x83\xa3",':asterisk_symbol:'=>"*",':astonished:'=>"\xf0\x9f\x98\xb2",':athletic_shoe:'=>"\xf0\x9f\x91\x9f",':atm:'=>"\xf0\x9f\x8f\xa7",':atom:'=>"\xe2\x9a\x9b\xef\xb8\x8f",':atom_symbol:'=>"\xe2\x9a\x9b\xef\xb8\x8f",':australia:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xba",':austria:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xb9",':avocado:'=>"\xf0\x9f\xa5\x91",':azerbaijan:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xbf",':b:'=>"\xf0\x9f\x85\xb1\xef\xb8\x8f",':baby:'=>"\xf0\x9f\x91\xb6",':baby_bottle:'=>"\xf0\x9f\x8d\xbc",':baby_chick:'=>"\xf0\x9f\x90\xa4",':baby_symbol:'=>"\xf0\x9f\x9a\xbc",':baby_tone1:'=>"\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbb",':baby_tone2:'=>"\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbc",':baby_tone3:'=>"\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbd",':baby_tone4:'=>"\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbe",':baby_tone5:'=>"\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbf",':back:'=>"\xf0\x9f\x94\x99",':bacon:'=>"\xf0\x9f\xa5\x93",':badminton:'=>"\xf0\x9f\x8f\xb8",':baggage_claim:'=>"\xf0\x9f\x9b\x84",':baguette_bread:'=>"\xf0\x9f\xa5\x96",':bahamas:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb8",':bahrain:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xad",':balance_scale:'=>"\xe2\x9a\x96\xef\xb8\x8f",':balloon:'=>"\xf0\x9f\x8e\x88",':ballot_box:'=>"\xf0\x9f\x97\xb3",':ballot_box_with_check:'=>"\xe2\x98\x91\xef\xb8\x8f",':bamboo:'=>"\xf0\x9f\x8e\x8d",':banana:'=>"\xf0\x9f\x8d\x8c",':bangbang:'=>"\xe2\x80\xbc\xef\xb8\x8f",':bangladesh:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xa9",':bank:'=>"\xf0\x9f\x8f\xa6",':bar_chart:'=>"\xf0\x9f\x93\x8a",':barbados:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xa7",':barber:'=>"\xf0\x9f\x92\x88",':baseball:'=>"\xe2\x9a\xbe\xef\xb8\x8f",':basketball:'=>"\xf0\x9f\x8f\x80",':basketball_man:'=>"\xe2\x9b\xb9",':basketball_woman:'=>"\xe2\x9b\xb9\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':bat:'=>"\xf0\x9f\xa6\x87",':bath:'=>"\xf0\x9f\x9b\x80",':bath_tone1:'=>"\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbb",':bath_tone2:'=>"\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbc",':bath_tone3:'=>"\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbd",':bath_tone4:'=>"\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbe",':bath_tone5:'=>"\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbf",':bathtub:'=>"\xf0\x9f\x9b\x81",':battery:'=>"\xf0\x9f\x94\x8b",':beach:'=>"\xf0\x9f\x8f\x96\xef\xb8\x8f",':beach_umbrella:'=>"\xf0\x9f\x8f\x96",':bear:'=>"\xf0\x9f\x90\xbb",':bearded_person:'=>"\xf0\x9f\xa7\x94\xf0\x9f\x8f\xbf",':bearded_person_tone1:'=>"\xf0\x9f\xa7\x94\xf0\x9f\x8f\xbb",':bearded_person_tone2:'=>"\xf0\x9f\xa7\x94\xf0\x9f\x8f\xbc",':bearded_person_tone3:'=>"\xf0\x9f\xa7\x94\xf0\x9f\x8f\xbd",':bearded_person_tone4:'=>"\xf0\x9f\xa7\x94\xf0\x9f\x8f\xbe",':bearded_person_tone5:'=>"\xf0\x9f\xa7\x94\xf0\x9f\x8f\xbf",':bed:'=>"\xf0\x9f\x9b\x8f",':bee:'=>"\xf0\x9f\x90\x9d",':beer:'=>"\xf0\x9f\x8d\xba",':beers:'=>"\xf0\x9f\x8d\xbb",':beetle:'=>"\xf0\x9f\x90\x9e",':beginner:'=>"\xf0\x9f\x94\xb0",':belarus:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xbe",':belgium:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xaa",':belize:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xbf",':bell:'=>"\xf0\x9f\x94\x94",':bellhop:'=>"\xf0\x9f\x9b\x8e\xef\xb8\x8f",':bellhop_bell:'=>"\xf0\x9f\x9b\x8e",':benin:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xaf",':bento:'=>"\xf0\x9f\x8d\xb1",':bermuda:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb2",':bhutan:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb9",':bicyclist:'=>"\xf0\x9f\x9a\xb4",':bike:'=>"\xf0\x9f\x9a\xb2",':biking_man:'=>"\xf0\x9f\x9a\xb4",':biking_woman:'=>"\xf0\x9f\x9a\xb4\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':bikini:'=>"\xf0\x9f\x91\x99",':billed_cap:'=>"\xf0\x9f\xa7\xa2",':biohazard:'=>"\xe2\x98\xa3\xef\xb8\x8f",':bird:'=>"\xf0\x9f\x90\xa6",':birthday:'=>"\xf0\x9f\x8e\x82",':black_circle:'=>"\xe2\x9a\xab\xef\xb8\x8f",':black_flag:'=>"\xf0\x9f\x8f\xb4",':black_heart:'=>"\xf0\x9f\x96\xa4",':black_joker:'=>"\xf0\x9f\x83\x8f",':black_large_square:'=>"\xe2\xac\x9b\xef\xb8\x8f",':black_medium_small_square:'=>"\xe2\x97\xbe\xef\xb8\x8f",':black_medium_square:'=>"\xe2\x97\xbc\xef\xb8\x8f",':black_nib:'=>"\xe2\x9c\x92\xef\xb8\x8f",':black_small_square:'=>"\xe2\x96\xaa\xef\xb8\x8f",':black_square_button:'=>"\xf0\x9f\x94\xb2",':blond-haired_man:'=>"\xf0\x9f\x91\xb1\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':blond-haired_man_tone1:'=>"\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':blond-haired_man_tone2:'=>"\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':blond-haired_man_tone3:'=>"\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':blond-haired_man_tone4:'=>"\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':blond-haired_man_tone5:'=>"\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':blond-haired_woman:'=>"\xf0\x9f\x91\xb1\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':blond-haired_woman_tone1:'=>"\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':blond-haired_woman_tone2:'=>"\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':blond-haired_woman_tone3:'=>"\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':blond-haired_woman_tone4:'=>"\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':blond-haired_woman_tone5:'=>"\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':blond_haired_person:'=>"\xf0\x9f\x91\xb1",':blond_haired_person_tone1:'=>"\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbb",':blond_haired_person_tone2:'=>"\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbc",':blond_haired_person_tone3:'=>"\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbd",':blond_haired_person_tone4:'=>"\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbe",':blond_haired_person_tone5:'=>"\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbf",':blonde_man:'=>"\xf0\x9f\x91\xb1",':blonde_woman:'=>"\xf0\x9f\x91\xb1\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':blossom:'=>"\xf0\x9f\x8c\xbc",':blowfish:'=>"\xf0\x9f\x90\xa1",':blue_book:'=>"\xf0\x9f\x93\x98",':blue_car:'=>"\xf0\x9f\x9a\x99",':blue_circle:'=>"\xf0\x9f\x94\xb5",':blue_heart:'=>"\xf0\x9f\x92\x99",':blush:'=>"\xf0\x9f\x98\x8a",':boar:'=>"\xf0\x9f\x90\x97",':boat:'=>"\xe2\x9b\xb5\xef\xb8\x8f",':bolivia:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb4",':bomb:'=>"\xf0\x9f\x92\xa3",':book:'=>"\xf0\x9f\x93\x96",':bookmark:'=>"\xf0\x9f\x94\x96",':bookmark_tabs:'=>"\xf0\x9f\x93\x91",':books:'=>"\xf0\x9f\x93\x9a",':boom:'=>"\xf0\x9f\x92\xa5",':boot:'=>"\xf0\x9f\x91\xa2",':bosnia_herzegovina:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xa6",':botswana:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xbc",':bouquet:'=>"\xf0\x9f\x92\x90",':bow:'=>"\xf0\x9f\x99\x87",':bow_and_arrow:'=>"\xf0\x9f\x8f\xb9",':bowing_man:'=>"\xf0\x9f\x99\x87",':bowing_woman:'=>"\xf0\x9f\x99\x87\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':bowl_with_spoon:'=>"\xf0\x9f\xa5\xa3",':bowling:'=>"\xf0\x9f\x8e\xb3",':boxing_glove:'=>"\xf0\x9f\xa5\x8a",':boy:'=>"\xf0\x9f\x91\xa6",':boy_tone1:'=>"\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbb",':boy_tone2:'=>"\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbc",':boy_tone3:'=>"\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbd",':boy_tone4:'=>"\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbe",':boy_tone5:'=>"\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbf",':brain:'=>"\xf0\x9f\xa7\xa0",':brazil:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb7",':bread:'=>"\xf0\x9f\x8d\x9e",':breast_feeding:'=>"\xf0\x9f\xa4\xb1",':breast_feeding_tone1:'=>"\xf0\x9f\xa4\xb1\xf0\x9f\x8f\xbb",':breast_feeding_tone2:'=>"\xf0\x9f\xa4\xb1\xf0\x9f\x8f\xbc",':breast_feeding_tone3:'=>"\xf0\x9f\xa4\xb1\xf0\x9f\x8f\xbd",':breast_feeding_tone4:'=>"\xf0\x9f\xa4\xb1\xf0\x9f\x8f\xbe",':breast_feeding_tone5:'=>"\xf0\x9f\xa4\xb1\xf0\x9f\x8f\xbf",':bride_with_veil:'=>"\xf0\x9f\x91\xb0",':bride_with_veil_tone1:'=>"\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbb",':bride_with_veil_tone2:'=>"\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbc",':bride_with_veil_tone3:'=>"\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbd",':bride_with_veil_tone4:'=>"\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbe",':bride_with_veil_tone5:'=>"\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbf",':bridge_at_night:'=>"\xf0\x9f\x8c\x89",':briefcase:'=>"\xf0\x9f\x92\xbc",':british_indian_ocean_territory:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb4",':british_virgin_islands:'=>"\xf0\x9f\x87\xbb\xf0\x9f\x87\xac",':broccoli:'=>"\xf0\x9f\xa5\xa6",':broken_heart:'=>"\xf0\x9f\x92\x94",':brunei:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb3",':bug:'=>"\xf0\x9f\x90\x9b",':building_construction:'=>"\xf0\x9f\x8f\x97",':bulb:'=>"\xf0\x9f\x92\xa1",':bulgaria:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xac",':bullettrain_front:'=>"\xf0\x9f\x9a\x85",':bullettrain_side:'=>"\xf0\x9f\x9a\x84",':burkina_faso:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xab",':burrito:'=>"\xf0\x9f\x8c\xaf",':burundi:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xae",':bus:'=>"\xf0\x9f\x9a\x8c",':business_suit_levitating:'=>"\xf0\x9f\x95\xb4",':busstop:'=>"\xf0\x9f\x9a\x8f",':bust_in_silhouette:'=>"\xf0\x9f\x91\xa4",':busts_in_silhouette:'=>"\xf0\x9f\x91\xa5",':butterfly:'=>"\xf0\x9f\xa6\x8b",':cactus:'=>"\xf0\x9f\x8c\xb5",':cake:'=>"\xf0\x9f\x8d\xb0",':calendar:'=>"\xf0\x9f\x93\x86",':calendar_spiral:'=>"\xf0\x9f\x97\x93\xef\xb8\x8f",':call_me:'=>"\xf0\x9f\xa4\x99",':call_me_hand:'=>"\xf0\x9f\xa4\x99",':call_me_tone1:'=>"\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbb",':call_me_tone2:'=>"\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbc",':call_me_tone3:'=>"\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbd",':call_me_tone4:'=>"\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbe",':call_me_tone5:'=>"\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbf",':calling:'=>"\xf0\x9f\x93\xb2",':cambodia:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xad",':camel:'=>"\xf0\x9f\x90\xab",':camera:'=>"\xf0\x9f\x93\xb7",':camera_flash:'=>"\xf0\x9f\x93\xb8",':camera_with_flash:'=>"\xf0\x9f\x93\xb8",':cameroon:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xb2",':camping:'=>"\xf0\x9f\x8f\x95",':canada:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xa6",':canary_islands:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xa8",':cancer:'=>"\xe2\x99\x8b\xef\xb8\x8f",':candle:'=>"\xf0\x9f\x95\xaf",':candy:'=>"\xf0\x9f\x8d\xac",':canned_food:'=>"\xf0\x9f\xa5\xab",':canoe:'=>"\xf0\x9f\x9b\xb6",':cape_verde:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xbb",':capital_abcd:'=>"\xf0\x9f\x94\xa0",':capricorn:'=>"\xe2\x99\x91\xef\xb8\x8f",':car:'=>"\xf0\x9f\x9a\x97",':card_box:'=>"\xf0\x9f\x97\x83\xef\xb8\x8f",':card_file_box:'=>"\xf0\x9f\x97\x83",':card_index:'=>"\xf0\x9f\x93\x87",':card_index_dividers:'=>"\xf0\x9f\x97\x82",':caribbean_netherlands:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb6",':carousel_horse:'=>"\xf0\x9f\x8e\xa0",':carrot:'=>"\xf0\x9f\xa5\x95",':cat:'=>"\xf0\x9f\x90\xb1",':cat2:'=>"\xf0\x9f\x90\x88",':cayman_islands:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xbe",':cd:'=>"\xf0\x9f\x92\xbf",':central_african_republic:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xab",':chad:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xa9",':chains:'=>"\xe2\x9b\x93",':champagne:'=>"\xf0\x9f\x8d\xbe",':champagne_glass:'=>"\xf0\x9f\xa5\x82",':chart:'=>"\xf0\x9f\x92\xb9",':chart_with_downwards_trend:'=>"\xf0\x9f\x93\x89",':chart_with_upwards_trend:'=>"\xf0\x9f\x93\x88",':checkered_flag:'=>"\xf0\x9f\x8f\x81",':cheese:'=>"\xf0\x9f\xa7\x80",':cherries:'=>"\xf0\x9f\x8d\x92",':cherry_blossom:'=>"\xf0\x9f\x8c\xb8",':chestnut:'=>"\xf0\x9f\x8c\xb0",':chicken:'=>"\xf0\x9f\x90\x94",':child:'=>"\xf0\x9f\xa7\x92\xf0\x9f\x8f\xbf",':child_tone1:'=>"\xf0\x9f\xa7\x92\xf0\x9f\x8f\xbb",':child_tone2:'=>"\xf0\x9f\xa7\x92\xf0\x9f\x8f\xbc",':child_tone3:'=>"\xf0\x9f\xa7\x92\xf0\x9f\x8f\xbd",':child_tone4:'=>"\xf0\x9f\xa7\x92\xf0\x9f\x8f\xbe",':child_tone5:'=>"\xf0\x9f\xa7\x92\xf0\x9f\x8f\xbf",':children_crossing:'=>"\xf0\x9f\x9a\xb8",':chile:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xb1",':chipmunk:'=>"\xf0\x9f\x90\xbf",':chocolate_bar:'=>"\xf0\x9f\x8d\xab",':chopsticks:'=>"\xf0\x9f\xa5\xa2",':christmas_island:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xbd",':christmas_tree:'=>"\xf0\x9f\x8e\x84",':church:'=>"\xe2\x9b\xaa\xef\xb8\x8f",':cinema:'=>"\xf0\x9f\x8e\xa6",':circus_tent:'=>"\xf0\x9f\x8e\xaa",':city_dusk:'=>"\xf0\x9f\x8c\x86",':city_sunrise:'=>"\xf0\x9f\x8c\x87",':city_sunset:'=>"\xf0\x9f\x8c\x86",':cityscape:'=>"\xf0\x9f\x8f\x99",':cl:'=>"\xf0\x9f\x86\x91",':clamp:'=>"\xf0\x9f\x97\x9c",':clap:'=>"\xf0\x9f\x91\x8f",':clap_tone1:'=>"\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbb",':clap_tone2:'=>"\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbc",':clap_tone3:'=>"\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbd",':clap_tone4:'=>"\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbe",':clap_tone5:'=>"\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbf",':clapper:'=>"\xf0\x9f\x8e\xac",':classical_building:'=>"\xf0\x9f\x8f\x9b",':clinking_glasses:'=>"\xf0\x9f\xa5\x82",':clipboard:'=>"\xf0\x9f\x93\x8b",':clock:'=>"\xf0\x9f\x95\xb0\xef\xb8\x8f",':clock1:'=>"\xf0\x9f\x95\x90",':clock10:'=>"\xf0\x9f\x95\x99",':clock1030:'=>"\xf0\x9f\x95\xa5",':clock11:'=>"\xf0\x9f\x95\x9a",':clock1130:'=>"\xf0\x9f\x95\xa6",':clock12:'=>"\xf0\x9f\x95\x9b",':clock1230:'=>"\xf0\x9f\x95\xa7",':clock130:'=>"\xf0\x9f\x95\x9c",':clock2:'=>"\xf0\x9f\x95\x91",':clock230:'=>"\xf0\x9f\x95\x9d",':clock3:'=>"\xf0\x9f\x95\x92",':clock330:'=>"\xf0\x9f\x95\x9e",':clock4:'=>"\xf0\x9f\x95\x93",':clock430:'=>"\xf0\x9f\x95\x9f",':clock5:'=>"\xf0\x9f\x95\x94",':clock530:'=>"\xf0\x9f\x95\xa0",':clock6:'=>"\xf0\x9f\x95\x95",':clock630:'=>"\xf0\x9f\x95\xa1",':clock7:'=>"\xf0\x9f\x95\x96",':clock730:'=>"\xf0\x9f\x95\xa2",':clock8:'=>"\xf0\x9f\x95\x97",':clock830:'=>"\xf0\x9f\x95\xa3",':clock9:'=>"\xf0\x9f\x95\x98",':clock930:'=>"\xf0\x9f\x95\xa4",':closed_book:'=>"\xf0\x9f\x93\x95",':closed_lock_with_key:'=>"\xf0\x9f\x94\x90",':closed_umbrella:'=>"\xf0\x9f\x8c\x82",':cloud:'=>"\xe2\x98\x81\xef\xb8\x8f",':cloud_lightning:'=>"\xf0\x9f\x8c\xa9\xef\xb8\x8f",':cloud_rain:'=>"\xf0\x9f\x8c\xa7\xef\xb8\x8f",':cloud_snow:'=>"\xf0\x9f\x8c\xa8\xef\xb8\x8f",':cloud_tornado:'=>"\xf0\x9f\x8c\xaa\xef\xb8\x8f",':cloud_with_lightning:'=>"\xf0\x9f\x8c\xa9",':cloud_with_lightning_and_rain:'=>"\xe2\x9b\x88",':cloud_with_rain:'=>"\xf0\x9f\x8c\xa7",':cloud_with_snow:'=>"\xf0\x9f\x8c\xa8",':clown:'=>"\xf0\x9f\xa4\xa1",':clown_face:'=>"\xf0\x9f\xa4\xa1",':clubs:'=>"\xe2\x99\xa3\xef\xb8\x8f",':cn:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xb3",':coat:'=>"\xf0\x9f\xa7\xa5",':cocktail:'=>"\xf0\x9f\x8d\xb8",':coconut:'=>"\xf0\x9f\xa5\xa5",':cocos_islands:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xa8",':coffee:'=>"\xe2\x98\x95\xef\xb8\x8f",':coffin:'=>"\xe2\x9a\xb0\xef\xb8\x8f",':cold_sweat:'=>"\xf0\x9f\x98\xb0",':collision:'=>"\xf0\x9f\x92\xa5",':colombia:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xb4",':comet:'=>"\xe2\x98\x84",':comoros:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xb2",':compression:'=>"\xf0\x9f\x97\x9c\xef\xb8\x8f",':computer:'=>"\xf0\x9f\x92\xbb",':computer_mouse:'=>"\xf0\x9f\x96\xb1",':confetti_ball:'=>"\xf0\x9f\x8e\x8a",':confounded:'=>"\xf0\x9f\x98\x96",':confused:'=>"\xf0\x9f\x98\x95",':congo_brazzaville:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xac",':congo_kinshasa:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xa9",':congratulations:'=>"\xe3\x8a\x97\xef\xb8\x8f",':construction:'=>"\xf0\x9f\x9a\xa7",':construction_site:'=>"\xf0\x9f\x8f\x97\xef\xb8\x8f",':construction_worker:'=>"\xf0\x9f\x91\xb7",':construction_worker_man:'=>"\xf0\x9f\x91\xb7",':construction_worker_tone1:'=>"\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbb",':construction_worker_tone2:'=>"\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbc",':construction_worker_tone3:'=>"\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbd",':construction_worker_tone4:'=>"\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbe",':construction_worker_tone5:'=>"\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbf",':construction_worker_woman:'=>"\xf0\x9f\x91\xb7\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':control_knobs:'=>"\xf0\x9f\x8e\x9b",':convenience_store:'=>"\xf0\x9f\x8f\xaa",':cook_islands:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xb0",':cookie:'=>"\xf0\x9f\x8d\xaa",':cooking:'=>"\xf0\x9f\x8d\xb3",':cool:'=>"\xf0\x9f\x86\x92",':cop:'=>"\xf0\x9f\x91\xae",':copyright:'=>"\xc2\xa9\xef\xb8\x8f",':corn:'=>"\xf0\x9f\x8c\xbd",':costa_rica:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xb7",':cote_divoire:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xae",':couch:'=>"\xf0\x9f\x9b\x8b\xef\xb8\x8f",':couch_and_lamp:'=>"\xf0\x9f\x9b\x8b",':couple:'=>"\xf0\x9f\x91\xab",':couple_mm:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x91\xa8",':couple_with_heart:'=>"\xf0\x9f\x92\x91",':couple_with_heart_man_man:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x91\xa8",':couple_with_heart_woman_man:'=>"\xf0\x9f\x92\x91",':couple_with_heart_woman_woman:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x91\xa9",':couple_ww:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x91\xa9",':couplekiss:'=>"\xf0\x9f\x92\x8f",':couplekiss_man_man:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x92\x8b\xe2\x80\x8d\xf0\x9f\x91\xa8",':couplekiss_man_woman:'=>"\xf0\x9f\x92\x8f",':couplekiss_woman_woman:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x92\x8b\xe2\x80\x8d\xf0\x9f\x91\xa9",':cow:'=>"\xf0\x9f\x90\xae",':cow2:'=>"\xf0\x9f\x90\x84",':cowboy:'=>"\xf0\x9f\xa4\xa0",':cowboy_hat_face:'=>"\xf0\x9f\xa4\xa0",':crab:'=>"\xf0\x9f\xa6\x80",':crayon:'=>"\xf0\x9f\x96\x8d",':crazy_face:'=>"\xf0\x9f\xa4\xaa",':credit_card:'=>"\xf0\x9f\x92\xb3",':crescent_moon:'=>"\xf0\x9f\x8c\x99",':cricket:'=>"\xf0\x9f\x8f\x8f",':cricket_game:'=>"\xf0\x9f\x8f\x8f",':croatia:'=>"\xf0\x9f\x87\xad\xf0\x9f\x87\xb7",':crocodile:'=>"\xf0\x9f\x90\x8a",':croissant:'=>"\xf0\x9f\xa5\x90",':cross:'=>"\xe2\x9c\x9d\xef\xb8\x8f",':crossed_fingers:'=>"\xf0\x9f\xa4\x9e",':crossed_flags:'=>"\xf0\x9f\x8e\x8c",':crossed_swords:'=>"\xe2\x9a\x94\xef\xb8\x8f",':crown:'=>"\xf0\x9f\x91\x91",':cruise_ship:'=>"\xf0\x9f\x9b\xb3\xef\xb8\x8f",':cry:'=>"\xf0\x9f\x98\xa2",':crying_cat_face:'=>"\xf0\x9f\x98\xbf",':crystal_ball:'=>"\xf0\x9f\x94\xae",':cuba:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xba",':cucumber:'=>"\xf0\x9f\xa5\x92",':cup_with_straw:'=>"\xf0\x9f\xa5\xa4",':cupid:'=>"\xf0\x9f\x92\x98",':curacao:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xbc",':curling_stone:'=>"\xf0\x9f\xa5\x8c",':curly_loop:'=>"\xe2\x9e\xb0",':currency_exchange:'=>"\xf0\x9f\x92\xb1",':curry:'=>"\xf0\x9f\x8d\x9b",':custard:'=>"\xf0\x9f\x8d\xae",':customs:'=>"\xf0\x9f\x9b\x83",':cut_of_meat:'=>"\xf0\x9f\xa5\xa9",':cyclone:'=>"\xf0\x9f\x8c\x80",':cyprus:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xbe",':czech_republic:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xbf",':dagger:'=>"\xf0\x9f\x97\xa1",':dancer:'=>"\xf0\x9f\x92\x83",':dancer_tone1:'=>"\xf0\x9f\x92\x83\xf0\x9f\x8f\xbb",':dancer_tone2:'=>"\xf0\x9f\x92\x83\xf0\x9f\x8f\xbc",':dancer_tone3:'=>"\xf0\x9f\x92\x83\xf0\x9f\x8f\xbd",':dancer_tone4:'=>"\xf0\x9f\x92\x83\xf0\x9f\x8f\xbe",':dancer_tone5:'=>"\xf0\x9f\x92\x83\xf0\x9f\x8f\xbf",':dancers:'=>"\xf0\x9f\x91\xaf",':dancing_men:'=>"\xf0\x9f\x91\xaf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':dancing_women:'=>"\xf0\x9f\x91\xaf",':dango:'=>"\xf0\x9f\x8d\xa1",':dark_sunglasses:'=>"\xf0\x9f\x95\xb6",':dart:'=>"\xf0\x9f\x8e\xaf",':dash:'=>"\xf0\x9f\x92\xa8",':date:'=>"\xf0\x9f\x93\x85",':de:'=>"\xf0\x9f\x87\xa9\xf0\x9f\x87\xaa",':deciduous_tree:'=>"\xf0\x9f\x8c\xb3",':deer:'=>"\xf0\x9f\xa6\x8c",':denmark:'=>"\xf0\x9f\x87\xa9\xf0\x9f\x87\xb0",':department_store:'=>"\xf0\x9f\x8f\xac",':derelict_house:'=>"\xf0\x9f\x8f\x9a",':desert:'=>"\xf0\x9f\x8f\x9c",':desert_island:'=>"\xf0\x9f\x8f\x9d",':desktop:'=>"\xf0\x9f\x96\xa5\xef\xb8\x8f",':desktop_computer:'=>"\xf0\x9f\x96\xa5",':detective:'=>"\xf0\x9f\x95\xb5",':detective_tone1:'=>"\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbb",':detective_tone2:'=>"\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbc",':detective_tone3:'=>"\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbd",':detective_tone4:'=>"\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbe",':detective_tone5:'=>"\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbf",':diamond_shape_with_a_dot_inside:'=>"\xf0\x9f\x92\xa0",':diamonds:'=>"\xe2\x99\xa6\xef\xb8\x8f",':digit_eight:'=>"8",':digit_five:'=>"5",':digit_four:'=>"4",':digit_nine:'=>"9",':digit_one:'=>"1",':digit_seven:'=>"7",':digit_six:'=>"6",':digit_three:'=>"3",':digit_two:'=>"2",':digit_zero:'=>"0",':disappointed:'=>"\xf0\x9f\x98\x9e",':disappointed_relieved:'=>"\xf0\x9f\x98\xa5",':dividers:'=>"\xf0\x9f\x97\x82\xef\xb8\x8f",':dizzy:'=>"\xf0\x9f\x92\xab",':dizzy_face:'=>"\xf0\x9f\x98\xb5",':djibouti:'=>"\xf0\x9f\x87\xa9\xf0\x9f\x87\xaf",':do_not_litter:'=>"\xf0\x9f\x9a\xaf",':dog:'=>"\xf0\x9f\x90\xb6",':dog2:'=>"\xf0\x9f\x90\x95",':dollar:'=>"\xf0\x9f\x92\xb5",':dolls:'=>"\xf0\x9f\x8e\x8e",':dolphin:'=>"\xf0\x9f\x90\xac",':dominica:'=>"\xf0\x9f\x87\xa9\xf0\x9f\x87\xb2",':dominican_republic:'=>"\xf0\x9f\x87\xa9\xf0\x9f\x87\xb4",':door:'=>"\xf0\x9f\x9a\xaa",':doughnut:'=>"\xf0\x9f\x8d\xa9",':dove:'=>"\xf0\x9f\x95\x8a",':dragon:'=>"\xf0\x9f\x90\x89",':dragon_face:'=>"\xf0\x9f\x90\xb2",':dress:'=>"\xf0\x9f\x91\x97",':dromedary_camel:'=>"\xf0\x9f\x90\xaa",':drooling_face:'=>"\xf0\x9f\xa4\xa4",':droplet:'=>"\xf0\x9f\x92\xa7",':drum:'=>"\xf0\x9f\xa5\x81",':duck:'=>"\xf0\x9f\xa6\x86",':dumpling:'=>"\xf0\x9f\xa5\x9f",':dvd:'=>"\xf0\x9f\x93\x80",':e-mail:'=>"\xf0\x9f\x93\xa7",':eagle:'=>"\xf0\x9f\xa6\x85",':ear:'=>"\xf0\x9f\x91\x82",':ear_of_rice:'=>"\xf0\x9f\x8c\xbe",':ear_tone1:'=>"\xf0\x9f\x91\x82\xf0\x9f\x8f\xbb",':ear_tone2:'=>"\xf0\x9f\x91\x82\xf0\x9f\x8f\xbc",':ear_tone3:'=>"\xf0\x9f\x91\x82\xf0\x9f\x8f\xbd",':ear_tone4:'=>"\xf0\x9f\x91\x82\xf0\x9f\x8f\xbe",':ear_tone5:'=>"\xf0\x9f\x91\x82\xf0\x9f\x8f\xbf",':earth_africa:'=>"\xf0\x9f\x8c\x8d",':earth_americas:'=>"\xf0\x9f\x8c\x8e",':earth_asia:'=>"\xf0\x9f\x8c\x8f",':ecuador:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xa8",':egg:'=>"\xf0\x9f\xa5\x9a",':eggplant:'=>"\xf0\x9f\x8d\x86",':egypt:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xac",':eight:'=>"8\xe2\x83\xa3",':eight_pointed_black_star:'=>"\xe2\x9c\xb4\xef\xb8\x8f",':eight_spoked_asterisk:'=>"\xe2\x9c\xb3\xef\xb8\x8f",':eject:'=>"\xe2\x8f\x8f\xef\xb8\x8f",':el_salvador:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xbb",':electric_plug:'=>"\xf0\x9f\x94\x8c",':elephant:'=>"\xf0\x9f\x90\x98",':elf:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbf",':elf_tone1:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbb",':elf_tone2:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbc",':elf_tone3:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbd",':elf_tone4:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbe",':elf_tone5:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbf",':email:'=>"\xe2\x9c\x89\xef\xb8\x8f",':end:'=>"\xf0\x9f\x94\x9a",':england:'=>"\xf0\x9f\x8f\xb4\xf3\xa0\x81\xa7\xf3\xa0\x81\xa2\xf3\xa0\x81\xa5\xf3\xa0\x81\xae\xf3\xa0\x81\xa7\xf3\xa0\x81\xbf",':envelope:'=>"\xe2\x9c\x89\xef\xb8\x8f",':envelope_with_arrow:'=>"\xf0\x9f\x93\xa9",':equatorial_guinea:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb6",':eritrea:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xb7",':es:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xb8",':estonia:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xaa",':ethiopia:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xb9",':eu:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xba",':euro:'=>"\xf0\x9f\x92\xb6",':european_castle:'=>"\xf0\x9f\x8f\xb0",':european_post_office:'=>"\xf0\x9f\x8f\xa4",':european_union:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xba",':evergreen_tree:'=>"\xf0\x9f\x8c\xb2",':exclamation:'=>"\xe2\x9d\x97\xef\xb8\x8f",':exploding_head:'=>"\xf0\x9f\xa4\xaf",':expressionless:'=>"\xf0\x9f\x98\x91",':eye:'=>"\xf0\x9f\x91\x81",':eye_in_speech_bubble:'=>"\xf0\x9f\x91\x81\xe2\x80\x8d\xf0\x9f\x97\xa8",':eye_speech_bubble:'=>"\xf0\x9f\x91\x81\xe2\x80\x8d\xf0\x9f\x97\xa8",':eyeglasses:'=>"\xf0\x9f\x91\x93",':eyes:'=>"\xf0\x9f\x91\x80",':face_vomiting:'=>"\xf0\x9f\xa4\xae",':face_with_hand_over_mouth:'=>"\xf0\x9f\xa4\xad",':face_with_head_bandage:'=>"\xf0\x9f\xa4\x95",':face_with_monocle:'=>"\xf0\x9f\xa7\x90",':face_with_raised_eyebrow:'=>"\xf0\x9f\xa4\xa8",':face_with_symbols_over_mouth:'=>"\xf0\x9f\xa4\xac",':face_with_thermometer:'=>"\xf0\x9f\xa4\x92",':facepunch:'=>"\xf0\x9f\x91\x8a",':factory:'=>"\xf0\x9f\x8f\xad",':fairy:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbf",':fairy_tone1:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbb",':fairy_tone2:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbc",':fairy_tone3:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbd",':fairy_tone4:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbe",':fairy_tone5:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbf",':falkland_islands:'=>"\xf0\x9f\x87\xab\xf0\x9f\x87\xb0",':fallen_leaf:'=>"\xf0\x9f\x8d\x82",':family:'=>"\xf0\x9f\x91\xaa",':family_man_boy:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_man_boy_boy:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa6\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_man_girl:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7",':family_man_girl_boy:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_man_girl_girl:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa7",':family_man_man_boy:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_man_man_boy_boy:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa6\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_man_man_girl:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7",':family_man_man_girl_boy:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_man_man_girl_girl:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa7",':family_man_woman_boy:'=>"\xf0\x9f\x91\xaa",':family_man_woman_boy_boy:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_man_woman_girl:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7",':family_man_woman_girl_boy:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_man_woman_girl_girl:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa7",':family_mmb:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_mmbb:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa6\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_mmg:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7",':family_mmgb:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_mmgg:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa7",':family_mwbb:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_mwg:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7",':family_mwgb:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_mwgg:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa7",':family_woman_boy:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_woman_boy_boy:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_woman_girl:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7",':family_woman_girl_boy:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_woman_girl_girl:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa7",':family_woman_woman_boy:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_woman_woman_boy_boy:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_woman_woman_girl:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7",':family_woman_woman_girl_boy:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_woman_woman_girl_girl:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa7",':family_wwb:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_wwbb:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_wwg:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7",':family_wwgb:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa6",':family_wwgg:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa7",':faroe_islands:'=>"\xf0\x9f\x87\xab\xf0\x9f\x87\xb4",':fast_forward:'=>"\xe2\x8f\xa9",':fax:'=>"\xf0\x9f\x93\xa0",':fearful:'=>"\xf0\x9f\x98\xa8",':feet:'=>"\xf0\x9f\x90\xbe",':female_detective:'=>"\xf0\x9f\x95\xb5\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':female_sign:'=>"\xe2\x99\x80\xef\xb8\x8f",':ferris_wheel:'=>"\xf0\x9f\x8e\xa1",':ferry:'=>"\xe2\x9b\xb4",':field_hockey:'=>"\xf0\x9f\x8f\x91",':fiji:'=>"\xf0\x9f\x87\xab\xf0\x9f\x87\xaf",':file_cabinet:'=>"\xf0\x9f\x97\x84",':file_folder:'=>"\xf0\x9f\x93\x81",':film_frames:'=>"\xf0\x9f\x8e\x9e\xef\xb8\x8f",':film_projector:'=>"\xf0\x9f\x93\xbd",':film_strip:'=>"\xf0\x9f\x8e\x9e",':fingers_crossed:'=>"\xf0\x9f\xa4\x9e",':fingers_crossed_tone1:'=>"\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbb",':fingers_crossed_tone2:'=>"\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbc",':fingers_crossed_tone3:'=>"\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbd",':fingers_crossed_tone4:'=>"\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbe",':fingers_crossed_tone5:'=>"\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbf",':finland:'=>"\xf0\x9f\x87\xab\xf0\x9f\x87\xae",':fire:'=>"\xf0\x9f\x94\xa5",':fire_engine:'=>"\xf0\x9f\x9a\x92",':fireworks:'=>"\xf0\x9f\x8e\x86",':first_place:'=>"\xf0\x9f\xa5\x87",':first_quarter_moon:'=>"\xf0\x9f\x8c\x93",':first_quarter_moon_with_face:'=>"\xf0\x9f\x8c\x9b",':fish:'=>"\xf0\x9f\x90\x9f",':fish_cake:'=>"\xf0\x9f\x8d\xa5",':fishing_pole_and_fish:'=>"\xf0\x9f\x8e\xa3",':fist:'=>"\xe2\x9c\x8a",':fist_left:'=>"\xf0\x9f\xa4\x9b",':fist_oncoming:'=>"\xf0\x9f\x91\x8a",':fist_raised:'=>"\xe2\x9c\x8a",':fist_right:'=>"\xf0\x9f\xa4\x9c",':fist_tone1:'=>"\xe2\x9c\x8a\xf0\x9f\x8f\xbb",':fist_tone2:'=>"\xe2\x9c\x8a\xf0\x9f\x8f\xbc",':fist_tone3:'=>"\xe2\x9c\x8a\xf0\x9f\x8f\xbd",':fist_tone4:'=>"\xe2\x9c\x8a\xf0\x9f\x8f\xbe",':fist_tone5:'=>"\xe2\x9c\x8a\xf0\x9f\x8f\xbf",':five:'=>"5\xe2\x83\xa3",':flag_ac:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xa8",':flag_ad:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xa9",':flag_ae:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xaa",':flag_af:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xab",':flag_ag:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xac",':flag_ai:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xae",':flag_al:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xb1",':flag_am:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xb2",':flag_ao:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xb4",':flag_aq:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xb6",':flag_ar:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xb7",':flag_as:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xb8",':flag_at:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xb9",':flag_au:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xba",':flag_aw:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xbc",':flag_ax:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xbd",':flag_az:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xbf",':flag_ba:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xa6",':flag_bb:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xa7",':flag_bd:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xa9",':flag_be:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xaa",':flag_bf:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xab",':flag_bg:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xac",':flag_bh:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xad",':flag_bi:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xae",':flag_bj:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xaf",':flag_bl:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb1",':flag_black:'=>"\xf0\x9f\x8f\xb4",':flag_bm:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb2",':flag_bn:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb3",':flag_bo:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb4",':flag_bq:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb6",':flag_br:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb7",':flag_bs:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb8",':flag_bt:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb9",':flag_bv:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xbb",':flag_bw:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xbc",':flag_by:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xbe",':flag_bz:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xbf",':flag_ca:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xa6",':flag_cc:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xa8",':flag_cd:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xa9",':flag_cf:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xab",':flag_cg:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xac",':flag_ch:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xad",':flag_ci:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xae",':flag_ck:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xb0",':flag_cl:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xb1",':flag_cm:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xb2",':flag_cn:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xb3",':flag_co:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xb4",':flag_cp:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xb5",':flag_cr:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xb7",':flag_cu:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xba",':flag_cv:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xbb",':flag_cw:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xbc",':flag_cx:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xbd",':flag_cy:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xbe",':flag_cz:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xbf",':flag_de:'=>"\xf0\x9f\x87\xa9\xf0\x9f\x87\xaa",':flag_dg:'=>"\xf0\x9f\x87\xa9\xf0\x9f\x87\xac",':flag_dj:'=>"\xf0\x9f\x87\xa9\xf0\x9f\x87\xaf",':flag_dk:'=>"\xf0\x9f\x87\xa9\xf0\x9f\x87\xb0",':flag_dm:'=>"\xf0\x9f\x87\xa9\xf0\x9f\x87\xb2",':flag_do:'=>"\xf0\x9f\x87\xa9\xf0\x9f\x87\xb4",':flag_dz:'=>"\xf0\x9f\x87\xa9\xf0\x9f\x87\xbf",':flag_ea:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xa6",':flag_ec:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xa8",':flag_ee:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xaa",':flag_eg:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xac",':flag_eh:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xad",':flag_er:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xb7",':flag_es:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xb8",':flag_et:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xb9",':flag_eu:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xba",':flag_fi:'=>"\xf0\x9f\x87\xab\xf0\x9f\x87\xae",':flag_fj:'=>"\xf0\x9f\x87\xab\xf0\x9f\x87\xaf",':flag_fk:'=>"\xf0\x9f\x87\xab\xf0\x9f\x87\xb0",':flag_fm:'=>"\xf0\x9f\x87\xab\xf0\x9f\x87\xb2",':flag_fo:'=>"\xf0\x9f\x87\xab\xf0\x9f\x87\xb4",':flag_fr:'=>"\xf0\x9f\x87\xab\xf0\x9f\x87\xb7",':flag_ga:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xa6",':flag_gb:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xa7",':flag_gd:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xa9",':flag_ge:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xaa",':flag_gf:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xab",':flag_gg:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xac",':flag_gh:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xad",':flag_gi:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xae",':flag_gl:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb1",':flag_gm:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb2",':flag_gn:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb3",':flag_gp:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb5",':flag_gq:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb6",':flag_gr:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb7",':flag_gs:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb8",':flag_gt:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb9",':flag_gu:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xba",':flag_gw:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xbc",':flag_gy:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xbe",':flag_hk:'=>"\xf0\x9f\x87\xad\xf0\x9f\x87\xb0",':flag_hm:'=>"\xf0\x9f\x87\xad\xf0\x9f\x87\xb2",':flag_hn:'=>"\xf0\x9f\x87\xad\xf0\x9f\x87\xb3",':flag_hr:'=>"\xf0\x9f\x87\xad\xf0\x9f\x87\xb7",':flag_ht:'=>"\xf0\x9f\x87\xad\xf0\x9f\x87\xb9",':flag_hu:'=>"\xf0\x9f\x87\xad\xf0\x9f\x87\xba",':flag_ic:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xa8",':flag_id:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xa9",':flag_ie:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xaa",':flag_il:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb1",':flag_im:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb2",':flag_in:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb3",':flag_io:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb4",':flag_iq:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb6",':flag_ir:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb7",':flag_is:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb8",':flag_it:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb9",':flag_je:'=>"\xf0\x9f\x87\xaf\xf0\x9f\x87\xaa",':flag_jm:'=>"\xf0\x9f\x87\xaf\xf0\x9f\x87\xb2",':flag_jo:'=>"\xf0\x9f\x87\xaf\xf0\x9f\x87\xb4",':flag_jp:'=>"\xf0\x9f\x87\xaf\xf0\x9f\x87\xb5",':flag_ke:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xaa",':flag_kg:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xac",':flag_kh:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xad",':flag_ki:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xae",':flag_km:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xb2",':flag_kn:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xb3",':flag_kp:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xb5",':flag_kr:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xb7",':flag_kw:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xbc",':flag_ky:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xbe",':flag_kz:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xbf",':flag_la:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xa6",':flag_lb:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xa7",':flag_lc:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xa8",':flag_li:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xae",':flag_lk:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xb0",':flag_lr:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xb7",':flag_ls:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xb8",':flag_lt:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xb9",':flag_lu:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xba",':flag_lv:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xbb",':flag_ly:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xbe",':flag_ma:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xa6",':flag_mc:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xa8",':flag_md:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xa9",':flag_me:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xaa",':flag_mf:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xab",':flag_mg:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xac",':flag_mh:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xad",':flag_mk:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb0",':flag_ml:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb1",':flag_mm:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb2",':flag_mn:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb3",':flag_mo:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb4",':flag_mp:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb5",':flag_mq:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb6",':flag_mr:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb7",':flag_ms:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb8",':flag_mt:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb9",':flag_mu:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xba",':flag_mv:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xbb",':flag_mw:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xbc",':flag_mx:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xbd",':flag_my:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xbe",':flag_mz:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xbf",':flag_na:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xa6",':flag_nc:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xa8",':flag_ne:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xaa",':flag_nf:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xab",':flag_ng:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xac",':flag_ni:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xae",':flag_nl:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xb1",':flag_no:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xb4",':flag_np:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xb5",':flag_nr:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xb7",':flag_nu:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xba",':flag_nz:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xbf",':flag_om:'=>"\xf0\x9f\x87\xb4\xf0\x9f\x87\xb2",':flag_pa:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xa6",':flag_pe:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xaa",':flag_pf:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xab",':flag_pg:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xac",':flag_ph:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xad",':flag_pk:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xb0",':flag_pl:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xb1",':flag_pm:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xb2",':flag_pn:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xb3",':flag_pr:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xb7",':flag_ps:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xb8",':flag_pt:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xb9",':flag_pw:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xbc",':flag_py:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xbe",':flag_qa:'=>"\xf0\x9f\x87\xb6\xf0\x9f\x87\xa6",':flag_re:'=>"\xf0\x9f\x87\xb7\xf0\x9f\x87\xaa",':flag_ro:'=>"\xf0\x9f\x87\xb7\xf0\x9f\x87\xb4",':flag_rs:'=>"\xf0\x9f\x87\xb7\xf0\x9f\x87\xb8",':flag_ru:'=>"\xf0\x9f\x87\xb7\xf0\x9f\x87\xba",':flag_rw:'=>"\xf0\x9f\x87\xb7\xf0\x9f\x87\xbc",':flag_sa:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xa6",':flag_sb:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xa7",':flag_sc:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xa8",':flag_sd:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xa9",':flag_se:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xaa",':flag_sg:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xac",':flag_sh:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xad",':flag_si:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xae",':flag_sj:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xaf",':flag_sk:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb0",':flag_sl:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb1",':flag_sm:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb2",':flag_sn:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb3",':flag_so:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb4",':flag_sr:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb7",':flag_ss:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb8",':flag_st:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb9",':flag_sv:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xbb",':flag_sx:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xbd",':flag_sy:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xbe",':flag_sz:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xbf",':flag_ta:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xa6",':flag_tc:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xa8",':flag_td:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xa9",':flag_tf:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xab",':flag_tg:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xac",':flag_th:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xad",':flag_tj:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xaf",':flag_tk:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xb0",':flag_tl:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xb1",':flag_tm:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xb2",':flag_tn:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xb3",':flag_to:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xb4",':flag_tr:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xb7",':flag_tt:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xb9",':flag_tv:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xbb",':flag_tw:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xbc",':flag_tz:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xbf",':flag_ua:'=>"\xf0\x9f\x87\xba\xf0\x9f\x87\xa6",':flag_ug:'=>"\xf0\x9f\x87\xba\xf0\x9f\x87\xac",':flag_um:'=>"\xf0\x9f\x87\xba\xf0\x9f\x87\xb2",':flag_us:'=>"\xf0\x9f\x87\xba\xf0\x9f\x87\xb8",':flag_uy:'=>"\xf0\x9f\x87\xba\xf0\x9f\x87\xbe",':flag_uz:'=>"\xf0\x9f\x87\xba\xf0\x9f\x87\xbf",':flag_va:'=>"\xf0\x9f\x87\xbb\xf0\x9f\x87\xa6",':flag_vc:'=>"\xf0\x9f\x87\xbb\xf0\x9f\x87\xa8",':flag_ve:'=>"\xf0\x9f\x87\xbb\xf0\x9f\x87\xaa",':flag_vg:'=>"\xf0\x9f\x87\xbb\xf0\x9f\x87\xac",':flag_vi:'=>"\xf0\x9f\x87\xbb\xf0\x9f\x87\xae",':flag_vn:'=>"\xf0\x9f\x87\xbb\xf0\x9f\x87\xb3",':flag_vu:'=>"\xf0\x9f\x87\xbb\xf0\x9f\x87\xba",':flag_wf:'=>"\xf0\x9f\x87\xbc\xf0\x9f\x87\xab",':flag_white:'=>"\xf0\x9f\x8f\xb3\xef\xb8\x8f",':flag_ws:'=>"\xf0\x9f\x87\xbc\xf0\x9f\x87\xb8",':flag_xk:'=>"\xf0\x9f\x87\xbd\xf0\x9f\x87\xb0",':flag_ye:'=>"\xf0\x9f\x87\xbe\xf0\x9f\x87\xaa",':flag_yt:'=>"\xf0\x9f\x87\xbe\xf0\x9f\x87\xb9",':flag_za:'=>"\xf0\x9f\x87\xbf\xf0\x9f\x87\xa6",':flag_zm:'=>"\xf0\x9f\x87\xbf\xf0\x9f\x87\xb2",':flag_zw:'=>"\xf0\x9f\x87\xbf\xf0\x9f\x87\xbc",':flags:'=>"\xf0\x9f\x8e\x8f",':flashlight:'=>"\xf0\x9f\x94\xa6",':fleur-de-lis:'=>"\xe2\x9a\x9c\xef\xb8\x8f",':fleur_de_lis:'=>"\xe2\x9a\x9c\xef\xb8\x8f",':flight_arrival:'=>"\xf0\x9f\x9b\xac",':flight_departure:'=>"\xf0\x9f\x9b\xab",':flipper:'=>"\xf0\x9f\x90\xac",':floppy_disk:'=>"\xf0\x9f\x92\xbe",':flower_playing_cards:'=>"\xf0\x9f\x8e\xb4",':flushed:'=>"\xf0\x9f\x98\xb3",':flying_saucer:'=>"\xf0\x9f\x9b\xb8",':fog:'=>"\xf0\x9f\x8c\xab",':foggy:'=>"\xf0\x9f\x8c\x81",':football:'=>"\xf0\x9f\x8f\x88",':footprints:'=>"\xf0\x9f\x91\xa3",':fork_and_knife:'=>"\xf0\x9f\x8d\xb4",':fork_knife_plate:'=>"\xf0\x9f\x8d\xbd\xef\xb8\x8f",':fortune_cookie:'=>"\xf0\x9f\xa5\xa0",':fountain:'=>"\xe2\x9b\xb2\xef\xb8\x8f",':fountain_pen:'=>"\xf0\x9f\x96\x8b",':four:'=>"4\xe2\x83\xa3",':four_leaf_clover:'=>"\xf0\x9f\x8d\x80",':fox:'=>"\xf0\x9f\xa6\x8a",':fox_face:'=>"\xf0\x9f\xa6\x8a",':fr:'=>"\xf0\x9f\x87\xab\xf0\x9f\x87\xb7",':frame_photo:'=>"\xf0\x9f\x96\xbc\xef\xb8\x8f",':framed_picture:'=>"\xf0\x9f\x96\xbc",':free:'=>"\xf0\x9f\x86\x93",':french_bread:'=>"\xf0\x9f\xa5\x96",':french_guiana:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xab",':french_polynesia:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xab",':french_southern_territories:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xab",':fried_egg:'=>"\xf0\x9f\x8d\xb3",':fried_shrimp:'=>"\xf0\x9f\x8d\xa4",':fries:'=>"\xf0\x9f\x8d\x9f",':frog:'=>"\xf0\x9f\x90\xb8",':frowning:'=>"\xf0\x9f\x98\xa6",':frowning2:'=>"\xe2\x98\xb9\xef\xb8\x8f",':frowning_face:'=>"\xe2\x98\xb9\xef\xb8\x8f",':frowning_man:'=>"\xf0\x9f\x99\x8d\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':frowning_woman:'=>"\xf0\x9f\x99\x8d",':fu:'=>"\xf0\x9f\x96\x95",':fuelpump:'=>"\xe2\x9b\xbd\xef\xb8\x8f",':full_moon:'=>"\xf0\x9f\x8c\x95",':full_moon_with_face:'=>"\xf0\x9f\x8c\x9d",':funeral_urn:'=>"\xe2\x9a\xb1\xef\xb8\x8f",':gabon:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xa6",':gambia:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb2",':game_die:'=>"\xf0\x9f\x8e\xb2",':gb:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xa7",':gear:'=>"\xe2\x9a\x99\xef\xb8\x8f",':gem:'=>"\xf0\x9f\x92\x8e",':gemini:'=>"\xe2\x99\x8a\xef\xb8\x8f",':genie:'=>"\xf0\x9f\xa7\x9e",':georgia:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xaa",':ghana:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xad",':ghost:'=>"\xf0\x9f\x91\xbb",':gibraltar:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xae",':gift:'=>"\xf0\x9f\x8e\x81",':gift_heart:'=>"\xf0\x9f\x92\x9d",':giraffe:'=>"\xf0\x9f\xa6\x92",':girl:'=>"\xf0\x9f\x91\xa7",':girl_tone1:'=>"\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbb",':girl_tone2:'=>"\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbc",':girl_tone3:'=>"\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbd",':girl_tone4:'=>"\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbe",':girl_tone5:'=>"\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbf",':globe_with_meridians:'=>"\xf0\x9f\x8c\x90",':gloves:'=>"\xf0\x9f\xa7\xa4",':goal:'=>"\xf0\x9f\xa5\x85",':goal_net:'=>"\xf0\x9f\xa5\x85",':goat:'=>"\xf0\x9f\x90\x90",':golf:'=>"\xe2\x9b\xb3\xef\xb8\x8f",':golfing_man:'=>"\xf0\x9f\x8f\x8c",':golfing_woman:'=>"\xf0\x9f\x8f\x8c\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':gorilla:'=>"\xf0\x9f\xa6\x8d",':grapes:'=>"\xf0\x9f\x8d\x87",':greece:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb7",':green_apple:'=>"\xf0\x9f\x8d\x8f",':green_book:'=>"\xf0\x9f\x93\x97",':green_heart:'=>"\xf0\x9f\x92\x9a",':green_salad:'=>"\xf0\x9f\xa5\x97",':greenland:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb1",':grenada:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xa9",':grey_exclamation:'=>"\xe2\x9d\x95",':grey_question:'=>"\xe2\x9d\x94",':grimacing:'=>"\xf0\x9f\x98\xac",':grin:'=>"\xf0\x9f\x98\x81",':grinning:'=>"\xf0\x9f\x98\x80",':guadeloupe:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb5",':guam:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xba",':guard:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbf",':guard_tone1:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbb",':guard_tone2:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbc",':guard_tone3:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbd",':guard_tone4:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbe",':guard_tone5:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbf",':guardsman:'=>"\xf0\x9f\x92\x82",':guardswoman:'=>"\xf0\x9f\x92\x82\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':guatemala:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb9",':guernsey:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xac",':guinea:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb3",':guinea_bissau:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xbc",':guitar:'=>"\xf0\x9f\x8e\xb8",':gun:'=>"\xf0\x9f\x94\xab",':guyana:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xbe",':haircut:'=>"\xf0\x9f\x92\x87",':haircut_man:'=>"\xf0\x9f\x92\x87\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':haircut_woman:'=>"\xf0\x9f\x92\x87",':haiti:'=>"\xf0\x9f\x87\xad\xf0\x9f\x87\xb9",':hamburger:'=>"\xf0\x9f\x8d\x94",':hammer:'=>"\xf0\x9f\x94\xa8",':hammer_and_pick:'=>"\xe2\x9a\x92",':hammer_and_wrench:'=>"\xf0\x9f\x9b\xa0",':hammer_pick:'=>"\xe2\x9a\x92\xef\xb8\x8f",':hamster:'=>"\xf0\x9f\x90\xb9",':hand:'=>"\xe2\x9c\x8b",':hand_splayed:'=>"\xf0\x9f\x96\x90\xef\xb8\x8f",':hand_splayed_tone1:'=>"\xf0\x9f\x96\x90\xf0\x9f\x8f\xbb",':hand_splayed_tone2:'=>"\xf0\x9f\x96\x90\xf0\x9f\x8f\xbc",':hand_splayed_tone3:'=>"\xf0\x9f\x96\x90\xf0\x9f\x8f\xbd",':hand_splayed_tone4:'=>"\xf0\x9f\x96\x90\xf0\x9f\x8f\xbe",':hand_splayed_tone5:'=>"\xf0\x9f\x96\x90\xf0\x9f\x8f\xbf",':handbag:'=>"\xf0\x9f\x91\x9c",':handshake:'=>"\xf0\x9f\xa4\x9d",':hankey:'=>"\xf0\x9f\x92\xa9",':hash:'=>"#\xe2\x83\xa3",':hatched_chick:'=>"\xf0\x9f\x90\xa5",':hatching_chick:'=>"\xf0\x9f\x90\xa3",':head_bandage:'=>"\xf0\x9f\xa4\x95",':headphones:'=>"\xf0\x9f\x8e\xa7",':hear_no_evil:'=>"\xf0\x9f\x99\x89",':heart:'=>"\xe2\x9d\xa4\xef\xb8\x8f",':heart_decoration:'=>"\xf0\x9f\x92\x9f",':heart_exclamation:'=>"\xe2\x9d\xa3\xef\xb8\x8f",':heart_eyes:'=>"\xf0\x9f\x98\x8d",':heart_eyes_cat:'=>"\xf0\x9f\x98\xbb",':heartbeat:'=>"\xf0\x9f\x92\x93",':heartpulse:'=>"\xf0\x9f\x92\x97",':hearts:'=>"\xe2\x99\xa5\xef\xb8\x8f",':heavy_check_mark:'=>"\xe2\x9c\x94\xef\xb8\x8f",':heavy_division_sign:'=>"\xe2\x9e\x97",':heavy_dollar_sign:'=>"\xf0\x9f\x92\xb2",':heavy_exclamation_mark:'=>"\xe2\x9d\x97\xef\xb8\x8f",':heavy_heart_exclamation:'=>"\xe2\x9d\xa3\xef\xb8\x8f",':heavy_minus_sign:'=>"\xe2\x9e\x96",':heavy_multiplication_x:'=>"\xe2\x9c\x96\xef\xb8\x8f",':heavy_plus_sign:'=>"\xe2\x9e\x95",':hedgehog:'=>"\xf0\x9f\xa6\x94",':helicopter:'=>"\xf0\x9f\x9a\x81",':helmet_with_cross:'=>"\xe2\x9b\x91\xef\xb8\x8f",':herb:'=>"\xf0\x9f\x8c\xbf",':hibiscus:'=>"\xf0\x9f\x8c\xba",':high_brightness:'=>"\xf0\x9f\x94\x86",':high_heel:'=>"\xf0\x9f\x91\xa0",':hocho:'=>"\xf0\x9f\x94\xaa",':hockey:'=>"\xf0\x9f\x8f\x92",':hole:'=>"\xf0\x9f\x95\xb3",':homes:'=>"\xf0\x9f\x8f\x98\xef\xb8\x8f",':honduras:'=>"\xf0\x9f\x87\xad\xf0\x9f\x87\xb3",':honey_pot:'=>"\xf0\x9f\x8d\xaf",':honeybee:'=>"\xf0\x9f\x90\x9d",':hong_kong:'=>"\xf0\x9f\x87\xad\xf0\x9f\x87\xb0",':horse:'=>"\xf0\x9f\x90\xb4",':horse_racing:'=>"\xf0\x9f\x8f\x87",':horse_racing_tone1:'=>"\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbb",':horse_racing_tone2:'=>"\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbc",':horse_racing_tone3:'=>"\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbd",':horse_racing_tone4:'=>"\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbe",':horse_racing_tone5:'=>"\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbf",':hospital:'=>"\xf0\x9f\x8f\xa5",':hot_pepper:'=>"\xf0\x9f\x8c\xb6",':hotdog:'=>"\xf0\x9f\x8c\xad",':hotel:'=>"\xf0\x9f\x8f\xa8",':hotsprings:'=>"\xe2\x99\xa8\xef\xb8\x8f",':hourglass:'=>"\xe2\x8c\x9b\xef\xb8\x8f",':hourglass_flowing_sand:'=>"\xe2\x8f\xb3",':house:'=>"\xf0\x9f\x8f\xa0",':house_abandoned:'=>"\xf0\x9f\x8f\x9a\xef\xb8\x8f",':house_with_garden:'=>"\xf0\x9f\x8f\xa1",':houses:'=>"\xf0\x9f\x8f\x98",':hugging:'=>"\xf0\x9f\xa4\x97",':hugs:'=>"\xf0\x9f\xa4\x97",':hungary:'=>"\xf0\x9f\x87\xad\xf0\x9f\x87\xba",':hushed:'=>"\xf0\x9f\x98\xaf",':ice_cream:'=>"\xf0\x9f\x8d\xa8",':ice_hockey:'=>"\xf0\x9f\x8f\x92",':ice_skate:'=>"\xe2\x9b\xb8",':icecream:'=>"\xf0\x9f\x8d\xa6",':iceland:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb8",':id:'=>"\xf0\x9f\x86\x94",':ideograph_advantage:'=>"\xf0\x9f\x89\x90",':imp:'=>"\xf0\x9f\x91\xbf",':inbox_tray:'=>"\xf0\x9f\x93\xa5",':incoming_envelope:'=>"\xf0\x9f\x93\xa8",':india:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb3",':indonesia:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xa9",':information_desk_person:'=>"\xf0\x9f\x92\x81",':information_source:'=>"\xe2\x84\xb9\xef\xb8\x8f",':innocent:'=>"\xf0\x9f\x98\x87",':interrobang:'=>"\xe2\x81\x89\xef\xb8\x8f",':iphone:'=>"\xf0\x9f\x93\xb1",':iran:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb7",':iraq:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb6",':ireland:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xaa",':island:'=>"\xf0\x9f\x8f\x9d\xef\xb8\x8f",':isle_of_man:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb2",':israel:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb1",':it:'=>"\xf0\x9f\x87\xae\xf0\x9f\x87\xb9",':izakaya_lantern:'=>"\xf0\x9f\x8f\xae",':jack_o_lantern:'=>"\xf0\x9f\x8e\x83",':jamaica:'=>"\xf0\x9f\x87\xaf\xf0\x9f\x87\xb2",':japan:'=>"\xf0\x9f\x97\xbe",':japanese_castle:'=>"\xf0\x9f\x8f\xaf",':japanese_goblin:'=>"\xf0\x9f\x91\xba",':japanese_ogre:'=>"\xf0\x9f\x91\xb9",':jeans:'=>"\xf0\x9f\x91\x96",':jersey:'=>"\xf0\x9f\x87\xaf\xf0\x9f\x87\xaa",':jordan:'=>"\xf0\x9f\x87\xaf\xf0\x9f\x87\xb4",':joy:'=>"\xf0\x9f\x98\x82",':joy_cat:'=>"\xf0\x9f\x98\xb9",':joystick:'=>"\xf0\x9f\x95\xb9",':jp:'=>"\xf0\x9f\x87\xaf\xf0\x9f\x87\xb5",':kaaba:'=>"\xf0\x9f\x95\x8b",':kazakhstan:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xbf",':kenya:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xaa",':key:'=>"\xf0\x9f\x94\x91",':key2:'=>"\xf0\x9f\x97\x9d\xef\xb8\x8f",':keyboard:'=>"\xe2\x8c\xa8\xef\xb8\x8f",':keycap_ten:'=>"\xf0\x9f\x94\x9f",':kick_scooter:'=>"\xf0\x9f\x9b\xb4",':kimono:'=>"\xf0\x9f\x91\x98",':kiribati:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xae",':kiss:'=>"\xf0\x9f\x92\x8b",':kiss_mm:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x92\x8b\xe2\x80\x8d\xf0\x9f\x91\xa8",':kiss_woman_man:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x92\x8b\xe2\x80\x8d\xf0\x9f\x91\xa8",':kiss_ww:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x92\x8b\xe2\x80\x8d\xf0\x9f\x91\xa9",':kissing:'=>"\xf0\x9f\x98\x97",':kissing_cat:'=>"\xf0\x9f\x98\xbd",':kissing_closed_eyes:'=>"\xf0\x9f\x98\x9a",':kissing_heart:'=>"\xf0\x9f\x98\x98",':kissing_smiling_eyes:'=>"\xf0\x9f\x98\x99",':kiwi:'=>"\xf0\x9f\xa5\x9d",':kiwi_fruit:'=>"\xf0\x9f\xa5\x9d",':knife:'=>"\xf0\x9f\x94\xaa",':koala:'=>"\xf0\x9f\x90\xa8",':koko:'=>"\xf0\x9f\x88\x81",':kosovo:'=>"\xf0\x9f\x87\xbd\xf0\x9f\x87\xb0",':kr:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xb7",':kuwait:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xbc",':kyrgyzstan:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xac",':label:'=>"\xf0\x9f\x8f\xb7",':lantern:'=>"\xf0\x9f\x8f\xae",':laos:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xa6",':large_blue_circle:'=>"\xf0\x9f\x94\xb5",':large_blue_diamond:'=>"\xf0\x9f\x94\xb7",':large_orange_diamond:'=>"\xf0\x9f\x94\xb6",':last_quarter_moon:'=>"\xf0\x9f\x8c\x97",':last_quarter_moon_with_face:'=>"\xf0\x9f\x8c\x9c",':latin_cross:'=>"\xe2\x9c\x9d\xef\xb8\x8f",':latvia:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xbb",':laughing:'=>"\xf0\x9f\x98\x86",':leaves:'=>"\xf0\x9f\x8d\x83",':lebanon:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xa7",':ledger:'=>"\xf0\x9f\x93\x92",':left_facing_fist:'=>"\xf0\x9f\xa4\x9b",':left_facing_fist_tone1:'=>"\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbb",':left_facing_fist_tone2:'=>"\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbc",':left_facing_fist_tone3:'=>"\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbd",':left_facing_fist_tone4:'=>"\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbe",':left_facing_fist_tone5:'=>"\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbf",':left_luggage:'=>"\xf0\x9f\x9b\x85",':left_right_arrow:'=>"\xe2\x86\x94\xef\xb8\x8f",':leftwards_arrow_with_hook:'=>"\xe2\x86\xa9\xef\xb8\x8f",':lemon:'=>"\xf0\x9f\x8d\x8b",':leo:'=>"\xe2\x99\x8c\xef\xb8\x8f",':leopard:'=>"\xf0\x9f\x90\x86",':lesotho:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xb8",':level_slider:'=>"\xf0\x9f\x8e\x9a",':levitate:'=>"\xf0\x9f\x95\xb4",':liberia:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xb7",':libra:'=>"\xe2\x99\x8e\xef\xb8\x8f",':libya:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xbe",':liechtenstein:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xae",':light_rail:'=>"\xf0\x9f\x9a\x88",':link:'=>"\xf0\x9f\x94\x97",':lion:'=>"\xf0\x9f\xa6\x81",':lion_face:'=>"\xf0\x9f\xa6\x81",':lips:'=>"\xf0\x9f\x91\x84",':lipstick:'=>"\xf0\x9f\x92\x84",':lithuania:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xb9",':lizard:'=>"\xf0\x9f\xa6\x8e",':lock:'=>"\xf0\x9f\x94\x92",':lock_with_ink_pen:'=>"\xf0\x9f\x94\x8f",':lollipop:'=>"\xf0\x9f\x8d\xad",':loop:'=>"\xe2\x9e\xbf",':loud_sound:'=>"\xf0\x9f\x94\x8a",':loudspeaker:'=>"\xf0\x9f\x93\xa2",':love_hotel:'=>"\xf0\x9f\x8f\xa9",':love_letter:'=>"\xf0\x9f\x92\x8c",':love_you_gesture:'=>"\xf0\x9f\xa4\x9f",':love_you_gesture_tone1:'=>"\xf0\x9f\xa4\x9f\xf0\x9f\x8f\xbb",':love_you_gesture_tone2:'=>"\xf0\x9f\xa4\x9f\xf0\x9f\x8f\xbc",':love_you_gesture_tone3:'=>"\xf0\x9f\xa4\x9f\xf0\x9f\x8f\xbd",':love_you_gesture_tone4:'=>"\xf0\x9f\xa4\x9f\xf0\x9f\x8f\xbe",':love_you_gesture_tone5:'=>"\xf0\x9f\xa4\x9f\xf0\x9f\x8f\xbf",':low_brightness:'=>"\xf0\x9f\x94\x85",':luxembourg:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xba",':lying_face:'=>"\xf0\x9f\xa4\xa5",':m:'=>"\xe2\x93\x82\xef\xb8\x8f",':macau:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb4",':macedonia:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb0",':madagascar:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xac",':mag:'=>"\xf0\x9f\x94\x8d",':mag_right:'=>"\xf0\x9f\x94\x8e",':mage:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbf",':mage_tone1:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbb",':mage_tone2:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbc",':mage_tone3:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbd",':mage_tone4:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbe",':mage_tone5:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbf",':mahjong:'=>"\xf0\x9f\x80\x84\xef\xb8\x8f",':mailbox:'=>"\xf0\x9f\x93\xab",':mailbox_closed:'=>"\xf0\x9f\x93\xaa",':mailbox_with_mail:'=>"\xf0\x9f\x93\xac",':mailbox_with_no_mail:'=>"\xf0\x9f\x93\xad",':malawi:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xbc",':malaysia:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xbe",':maldives:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xbb",':male_detective:'=>"\xf0\x9f\x95\xb5",':male_sign:'=>"\xe2\x99\x82\xef\xb8\x8f",':mali:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb1",':malta:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb9",':man:'=>"\xf0\x9f\x91\xa8",':man_artist:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8e\xa8",':man_artist_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\xa8",':man_artist_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\xa8",':man_artist_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\xa8",':man_artist_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\xa8",':man_artist_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\xa8",':man_astronaut:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x9a\x80",':man_astronaut_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x9a\x80",':man_astronaut_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x9a\x80",':man_astronaut_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x9a\x80",':man_astronaut_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x9a\x80",':man_astronaut_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x9a\x80",':man_biking:'=>"\xf0\x9f\x9a\xb4\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_biking_tone1:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_biking_tone2:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_biking_tone3:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_biking_tone4:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_biking_tone5:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_bouncing_ball:'=>"\xe2\x9b\xb9\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_bouncing_ball_tone1:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_bouncing_ball_tone2:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_bouncing_ball_tone3:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_bouncing_ball_tone4:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_bouncing_ball_tone5:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_bowing:'=>"\xf0\x9f\x99\x87\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_bowing_tone1:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_bowing_tone2:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_bowing_tone3:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_bowing_tone4:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_bowing_tone5:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_cartwheeling:'=>"\xf0\x9f\xa4\xb8\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_cartwheeling_tone1:'=>"\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_cartwheeling_tone2:'=>"\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_cartwheeling_tone3:'=>"\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_cartwheeling_tone4:'=>"\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_cartwheeling_tone5:'=>"\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_climbing:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_climbing_tone1:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_climbing_tone2:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_climbing_tone3:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_climbing_tone4:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_climbing_tone5:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_construction_worker:'=>"\xf0\x9f\x91\xb7\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_construction_worker_tone1:'=>"\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_construction_worker_tone2:'=>"\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_construction_worker_tone3:'=>"\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_construction_worker_tone4:'=>"\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_construction_worker_tone5:'=>"\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_cook:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8d\xb3",':man_cook_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8d\xb3",':man_cook_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8d\xb3",':man_cook_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8d\xb3",':man_cook_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8d\xb3",':man_cook_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8d\xb3",':man_dancing:'=>"\xf0\x9f\x95\xba",':man_dancing_tone1:'=>"\xf0\x9f\x95\xba\xf0\x9f\x8f\xbb",':man_dancing_tone2:'=>"\xf0\x9f\x95\xba\xf0\x9f\x8f\xbc",':man_dancing_tone3:'=>"\xf0\x9f\x95\xba\xf0\x9f\x8f\xbd",':man_dancing_tone4:'=>"\xf0\x9f\x95\xba\xf0\x9f\x8f\xbe",':man_dancing_tone5:'=>"\xf0\x9f\x95\xba\xf0\x9f\x8f\xbf",':man_detective:'=>"\xf0\x9f\x95\xb5\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_detective_tone1:'=>"\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_detective_tone2:'=>"\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_detective_tone3:'=>"\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_detective_tone4:'=>"\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_detective_tone5:'=>"\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_elf:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_elf_tone1:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_elf_tone2:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_elf_tone3:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_elf_tone4:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_elf_tone5:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_facepalming:'=>"\xf0\x9f\xa4\xa6\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_facepalming_tone1:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_facepalming_tone2:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_facepalming_tone3:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_facepalming_tone4:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_facepalming_tone5:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_factory_worker:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8f\xad",':man_factory_worker_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8f\xad",':man_factory_worker_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8f\xad",':man_factory_worker_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8f\xad",':man_factory_worker_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8f\xad",':man_factory_worker_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8f\xad",':man_fairy:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_fairy_tone1:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_fairy_tone2:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_fairy_tone3:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_fairy_tone4:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_fairy_tone5:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_farmer:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8c\xbe",':man_farmer_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8c\xbe",':man_farmer_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8c\xbe",':man_farmer_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8c\xbe",':man_farmer_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8c\xbe",':man_farmer_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8c\xbe",':man_firefighter:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x9a\x92",':man_firefighter_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x9a\x92",':man_firefighter_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x9a\x92",':man_firefighter_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x9a\x92",':man_firefighter_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x9a\x92",':man_firefighter_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x9a\x92",':man_frowning:'=>"\xf0\x9f\x99\x8d\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_frowning_tone1:'=>"\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_frowning_tone2:'=>"\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_frowning_tone3:'=>"\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_frowning_tone4:'=>"\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_frowning_tone5:'=>"\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_genie:'=>"\xf0\x9f\xa7\x9e\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_gesturing_no:'=>"\xf0\x9f\x99\x85\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_gesturing_no_tone1:'=>"\xf0\x9f\x99\x85\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_gesturing_no_tone2:'=>"\xf0\x9f\x99\x85\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_gesturing_no_tone3:'=>"\xf0\x9f\x99\x85\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_gesturing_no_tone4:'=>"\xf0\x9f\x99\x85\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_gesturing_no_tone5:'=>"\xf0\x9f\x99\x85\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_gesturing_ok:'=>"\xf0\x9f\x99\x86\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_gesturing_ok_tone1:'=>"\xf0\x9f\x99\x86\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_gesturing_ok_tone2:'=>"\xf0\x9f\x99\x86\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_gesturing_ok_tone3:'=>"\xf0\x9f\x99\x86\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_gesturing_ok_tone4:'=>"\xf0\x9f\x99\x86\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_gesturing_ok_tone5:'=>"\xf0\x9f\x99\x86\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_getting_face_massage:'=>"\xf0\x9f\x92\x86\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_getting_face_massage_tone1:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_getting_face_massage_tone2:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_getting_face_massage_tone3:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_getting_face_massage_tone4:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_getting_face_massage_tone5:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_getting_haircut:'=>"\xf0\x9f\x92\x87\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_getting_haircut_tone1:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_getting_haircut_tone2:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_getting_haircut_tone3:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_getting_haircut_tone4:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_getting_haircut_tone5:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_golfing:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_golfing_tone1:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_golfing_tone2:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_golfing_tone3:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_golfing_tone4:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_golfing_tone5:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_guard:'=>"\xf0\x9f\x92\x82\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_guard_tone1:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_guard_tone2:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_guard_tone3:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_guard_tone4:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_guard_tone5:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_health_worker:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9a\x95\xef\xb8\x8f",':man_health_worker_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x9a\x95\xef\xb8\x8f",':man_health_worker_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x9a\x95\xef\xb8\x8f",':man_health_worker_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x9a\x95\xef\xb8\x8f",':man_health_worker_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x9a\x95\xef\xb8\x8f",':man_health_worker_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x9a\x95\xef\xb8\x8f",':man_in_business_suit_levitating_tone1:'=>"\xf0\x9f\x95\xb4\xf0\x9f\x8f\xbb",':man_in_business_suit_levitating_tone2:'=>"\xf0\x9f\x95\xb4\xf0\x9f\x8f\xbc",':man_in_business_suit_levitating_tone3:'=>"\xf0\x9f\x95\xb4\xf0\x9f\x8f\xbd",':man_in_business_suit_levitating_tone4:'=>"\xf0\x9f\x95\xb4\xf0\x9f\x8f\xbe",':man_in_business_suit_levitating_tone5:'=>"\xf0\x9f\x95\xb4\xf0\x9f\x8f\xbf",':man_in_lotus_position:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_in_lotus_position_tone1:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_in_lotus_position_tone2:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_in_lotus_position_tone3:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_in_lotus_position_tone4:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_in_lotus_position_tone5:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_in_steamy_room:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_in_steamy_room_tone1:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_in_steamy_room_tone2:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_in_steamy_room_tone3:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_in_steamy_room_tone4:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_in_steamy_room_tone5:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_in_tuxedo:'=>"\xf0\x9f\xa4\xb5",':man_in_tuxedo_tone1:'=>"\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbb",':man_in_tuxedo_tone2:'=>"\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbc",':man_in_tuxedo_tone3:'=>"\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbd",':man_in_tuxedo_tone4:'=>"\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbe",':man_in_tuxedo_tone5:'=>"\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbf",':man_judge:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9a\x96\xef\xb8\x8f",':man_judge_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x9a\x96\xef\xb8\x8f",':man_judge_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x9a\x96\xef\xb8\x8f",':man_judge_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x9a\x96\xef\xb8\x8f",':man_judge_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x9a\x96\xef\xb8\x8f",':man_judge_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x9a\x96\xef\xb8\x8f",':man_juggling:'=>"\xf0\x9f\xa4\xb9\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_juggling_tone1:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_juggling_tone2:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_juggling_tone3:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_juggling_tone4:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_juggling_tone5:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_lifting_weights:'=>"\xf0\x9f\x8f\x8b\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_lifting_weights_tone1:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_lifting_weights_tone2:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_lifting_weights_tone3:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_lifting_weights_tone4:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_lifting_weights_tone5:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_mage:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_mage_tone1:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_mage_tone2:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_mage_tone3:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_mage_tone4:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_mage_tone5:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_mechanic:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x94\xa7",':man_mechanic_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x94\xa7",':man_mechanic_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x94\xa7",':man_mechanic_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x94\xa7",':man_mechanic_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x94\xa7",':man_mechanic_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x94\xa7",':man_mountain_biking:'=>"\xf0\x9f\x9a\xb5\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_mountain_biking_tone1:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_mountain_biking_tone2:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_mountain_biking_tone3:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_mountain_biking_tone4:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_mountain_biking_tone5:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_office_worker:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x92\xbc",':man_office_worker_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x92\xbc",':man_office_worker_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x92\xbc",':man_office_worker_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x92\xbc",':man_office_worker_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x92\xbc",':man_office_worker_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x92\xbc",':man_pilot:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9c\x88\xef\xb8\x8f",':man_pilot_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x9c\x88\xef\xb8\x8f",':man_pilot_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x9c\x88\xef\xb8\x8f",':man_pilot_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x9c\x88\xef\xb8\x8f",':man_pilot_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x9c\x88\xef\xb8\x8f",':man_pilot_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x9c\x88\xef\xb8\x8f",':man_playing_handball:'=>"\xf0\x9f\xa4\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_playing_handball_tone1:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_playing_handball_tone2:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_playing_handball_tone3:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_playing_handball_tone4:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_playing_handball_tone5:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_playing_water_polo:'=>"\xf0\x9f\xa4\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_playing_water_polo_tone1:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_playing_water_polo_tone2:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_playing_water_polo_tone3:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_playing_water_polo_tone4:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_playing_water_polo_tone5:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_police_officer:'=>"\xf0\x9f\x91\xae\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_police_officer_tone1:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_police_officer_tone2:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_police_officer_tone3:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_police_officer_tone4:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_police_officer_tone5:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_pouting:'=>"\xf0\x9f\x99\x8e\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_pouting_tone1:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_pouting_tone2:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_pouting_tone3:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_pouting_tone4:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_pouting_tone5:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_raising_hand:'=>"\xf0\x9f\x99\x8b\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_raising_hand_tone1:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_raising_hand_tone2:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_raising_hand_tone3:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_raising_hand_tone4:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_raising_hand_tone5:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_rowing_boat:'=>"\xf0\x9f\x9a\xa3\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_rowing_boat_tone1:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_rowing_boat_tone2:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_rowing_boat_tone3:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_rowing_boat_tone4:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_rowing_boat_tone5:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_running:'=>"\xf0\x9f\x8f\x83\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_running_tone1:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_running_tone2:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_running_tone3:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_running_tone4:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_running_tone5:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_scientist:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x94\xac",':man_scientist_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x94\xac",':man_scientist_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x94\xac",':man_scientist_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x94\xac",':man_scientist_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x94\xac",':man_scientist_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x94\xac",':man_shrugging:'=>"\xf0\x9f\xa4\xb7\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_shrugging_tone1:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_shrugging_tone2:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_shrugging_tone3:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_shrugging_tone4:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_shrugging_tone5:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_singer:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8e\xa4",':man_singer_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\xa4",':man_singer_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\xa4",':man_singer_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\xa4",':man_singer_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\xa4",':man_singer_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\xa4",':man_student:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8e\x93",':man_student_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\x93",':man_student_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\x93",':man_student_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\x93",':man_student_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\x93",':man_student_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\x93",':man_surfing:'=>"\xf0\x9f\x8f\x84\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_surfing_tone1:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_surfing_tone2:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_surfing_tone3:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_surfing_tone4:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_surfing_tone5:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_swimming:'=>"\xf0\x9f\x8f\x8a\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_swimming_tone1:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_swimming_tone2:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_swimming_tone3:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_swimming_tone4:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_swimming_tone5:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_teacher:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8f\xab",':man_teacher_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8f\xab",':man_teacher_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8f\xab",':man_teacher_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8f\xab",':man_teacher_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8f\xab",':man_teacher_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8f\xab",':man_technologist:'=>"\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x92\xbb",':man_technologist_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x92\xbb",':man_technologist_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x92\xbb",':man_technologist_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x92\xbb",':man_technologist_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x92\xbb",':man_technologist_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x92\xbb",':man_tipping_hand:'=>"\xf0\x9f\x92\x81\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_tipping_hand_tone1:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_tipping_hand_tone2:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_tipping_hand_tone3:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_tipping_hand_tone4:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_tipping_hand_tone5:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_tone1:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb",':man_tone2:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc",':man_tone3:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd",':man_tone4:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe",':man_tone5:'=>"\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf",':man_vampire:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_vampire_tone1:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_vampire_tone2:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_vampire_tone3:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_vampire_tone4:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_vampire_tone5:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_walking:'=>"\xf0\x9f\x9a\xb6\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_walking_tone1:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_walking_tone2:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_walking_tone3:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_walking_tone4:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_walking_tone5:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_wearing_turban:'=>"\xf0\x9f\x91\xb3\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_wearing_turban_tone1:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_wearing_turban_tone2:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_wearing_turban_tone3:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_wearing_turban_tone4:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_wearing_turban_tone5:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':man_with_chinese_cap:'=>"\xf0\x9f\x91\xb2",':man_with_chinese_cap_tone1:'=>"\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbb",':man_with_chinese_cap_tone2:'=>"\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbc",':man_with_chinese_cap_tone3:'=>"\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbd",':man_with_chinese_cap_tone4:'=>"\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbe",':man_with_chinese_cap_tone5:'=>"\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbf",':man_with_gua_pi_mao:'=>"\xf0\x9f\x91\xb2",':man_with_turban:'=>"\xf0\x9f\x91\xb3",':man_zombie:'=>"\xf0\x9f\xa7\x9f\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':mandarin:'=>"\xf0\x9f\x8d\x8a",':mans_shoe:'=>"\xf0\x9f\x91\x9e",':mantelpiece_clock:'=>"\xf0\x9f\x95\xb0",':map:'=>"\xf0\x9f\x97\xba\xef\xb8\x8f",':maple_leaf:'=>"\xf0\x9f\x8d\x81",':marshall_islands:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xad",':martial_arts_uniform:'=>"\xf0\x9f\xa5\x8b",':martinique:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb6",':mask:'=>"\xf0\x9f\x98\xb7",':massage:'=>"\xf0\x9f\x92\x86",':massage_man:'=>"\xf0\x9f\x92\x86\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':massage_woman:'=>"\xf0\x9f\x92\x86",':mauritania:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb7",':mauritius:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xba",':mayotte:'=>"\xf0\x9f\x87\xbe\xf0\x9f\x87\xb9",':meat_on_bone:'=>"\xf0\x9f\x8d\x96",':medal:'=>"\xf0\x9f\x8f\x85",':medal_military:'=>"\xf0\x9f\x8e\x96",':medal_sports:'=>"\xf0\x9f\x8f\x85",':medical_symbol:'=>"\xe2\x9a\x95\xef\xb8\x8f",':mega:'=>"\xf0\x9f\x93\xa3",':melon:'=>"\xf0\x9f\x8d\x88",':memo:'=>"\xf0\x9f\x93\x9d",':men_with_bunny_ears_partying:'=>"\xf0\x9f\x91\xaf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':men_wrestling:'=>"\xf0\x9f\xa4\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':menorah:'=>"\xf0\x9f\x95\x8e",':mens:'=>"\xf0\x9f\x9a\xb9",':mermaid:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':mermaid_tone1:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':mermaid_tone2:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':mermaid_tone3:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':mermaid_tone4:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':mermaid_tone5:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':merman:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':merman_tone1:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':merman_tone2:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':merman_tone3:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':merman_tone4:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':merman_tone5:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':merperson:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbf",':merperson_tone1:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbb",':merperson_tone2:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbc",':merperson_tone3:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbd",':merperson_tone4:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbe",':merperson_tone5:'=>"\xf0\x9f\xa7\x9c\xf0\x9f\x8f\xbf",':metal:'=>"\xf0\x9f\xa4\x98",':metal_tone1:'=>"\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbb",':metal_tone2:'=>"\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbc",':metal_tone3:'=>"\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbd",':metal_tone4:'=>"\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbe",':metal_tone5:'=>"\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbf",':metro:'=>"\xf0\x9f\x9a\x87",':mexico:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xbd",':micronesia:'=>"\xf0\x9f\x87\xab\xf0\x9f\x87\xb2",':microphone:'=>"\xf0\x9f\x8e\xa4",':microphone2:'=>"\xf0\x9f\x8e\x99\xef\xb8\x8f",':microscope:'=>"\xf0\x9f\x94\xac",':middle_finger:'=>"\xf0\x9f\x96\x95",':middle_finger_tone1:'=>"\xf0\x9f\x96\x95\xf0\x9f\x8f\xbb",':middle_finger_tone2:'=>"\xf0\x9f\x96\x95\xf0\x9f\x8f\xbc",':middle_finger_tone3:'=>"\xf0\x9f\x96\x95\xf0\x9f\x8f\xbd",':middle_finger_tone4:'=>"\xf0\x9f\x96\x95\xf0\x9f\x8f\xbe",':middle_finger_tone5:'=>"\xf0\x9f\x96\x95\xf0\x9f\x8f\xbf",':military_medal:'=>"\xf0\x9f\x8e\x96\xef\xb8\x8f",':milk:'=>"\xf0\x9f\xa5\x9b",':milk_glass:'=>"\xf0\x9f\xa5\x9b",':milky_way:'=>"\xf0\x9f\x8c\x8c",':minibus:'=>"\xf0\x9f\x9a\x90",':minidisc:'=>"\xf0\x9f\x92\xbd",':mobile_phone_off:'=>"\xf0\x9f\x93\xb4",':moldova:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xa9",':monaco:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xa8",':money_mouth:'=>"\xf0\x9f\xa4\x91",':money_mouth_face:'=>"\xf0\x9f\xa4\x91",':money_with_wings:'=>"\xf0\x9f\x92\xb8",':moneybag:'=>"\xf0\x9f\x92\xb0",':mongolia:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb3",':monkey:'=>"\xf0\x9f\x90\x92",':monkey_face:'=>"\xf0\x9f\x90\xb5",':monorail:'=>"\xf0\x9f\x9a\x9d",':montenegro:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xaa",':montserrat:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb8",':moon:'=>"\xf0\x9f\x8c\x94",':morocco:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xa6",':mortar_board:'=>"\xf0\x9f\x8e\x93",':mosque:'=>"\xf0\x9f\x95\x8c",':motor_boat:'=>"\xf0\x9f\x9b\xa5",':motor_scooter:'=>"\xf0\x9f\x9b\xb5",':motorboat:'=>"\xf0\x9f\x9b\xa5\xef\xb8\x8f",':motorcycle:'=>"\xf0\x9f\x8f\x8d",':motorway:'=>"\xf0\x9f\x9b\xa3",':mount_fuji:'=>"\xf0\x9f\x97\xbb",':mountain:'=>"\xe2\x9b\xb0",':mountain_bicyclist:'=>"\xf0\x9f\x9a\xb5",':mountain_biking_man:'=>"\xf0\x9f\x9a\xb5",':mountain_biking_woman:'=>"\xf0\x9f\x9a\xb5\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':mountain_cableway:'=>"\xf0\x9f\x9a\xa0",':mountain_railway:'=>"\xf0\x9f\x9a\x9e",':mountain_snow:'=>"\xf0\x9f\x8f\x94",':mouse:'=>"\xf0\x9f\x90\xad",':mouse2:'=>"\xf0\x9f\x90\x81",':mouse_three_button:'=>"\xf0\x9f\x96\xb1\xef\xb8\x8f",':movie_camera:'=>"\xf0\x9f\x8e\xa5",':moyai:'=>"\xf0\x9f\x97\xbf",':mozambique:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xbf",':mrs_claus:'=>"\xf0\x9f\xa4\xb6",':mrs_claus_tone1:'=>"\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbb",':mrs_claus_tone2:'=>"\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbc",':mrs_claus_tone3:'=>"\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbd",':mrs_claus_tone4:'=>"\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbe",':mrs_claus_tone5:'=>"\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbf",':muscle:'=>"\xf0\x9f\x92\xaa",':muscle_tone1:'=>"\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbb",':muscle_tone2:'=>"\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbc",':muscle_tone3:'=>"\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbd",':muscle_tone4:'=>"\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbe",':muscle_tone5:'=>"\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbf",':mushroom:'=>"\xf0\x9f\x8d\x84",':musical_keyboard:'=>"\xf0\x9f\x8e\xb9",':musical_note:'=>"\xf0\x9f\x8e\xb5",':musical_score:'=>"\xf0\x9f\x8e\xbc",':mute:'=>"\xf0\x9f\x94\x87",':myanmar:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb2",':nail_care:'=>"\xf0\x9f\x92\x85",':nail_care_tone1:'=>"\xf0\x9f\x92\x85\xf0\x9f\x8f\xbb",':nail_care_tone2:'=>"\xf0\x9f\x92\x85\xf0\x9f\x8f\xbc",':nail_care_tone3:'=>"\xf0\x9f\x92\x85\xf0\x9f\x8f\xbd",':nail_care_tone4:'=>"\xf0\x9f\x92\x85\xf0\x9f\x8f\xbe",':nail_care_tone5:'=>"\xf0\x9f\x92\x85\xf0\x9f\x8f\xbf",':name_badge:'=>"\xf0\x9f\x93\x9b",':namibia:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xa6",':national_park:'=>"\xf0\x9f\x8f\x9e",':nauru:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xb7",':nauseated_face:'=>"\xf0\x9f\xa4\xa2",':necktie:'=>"\xf0\x9f\x91\x94",':negative_squared_cross_mark:'=>"\xe2\x9d\x8e",':nepal:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xb5",':nerd:'=>"\xf0\x9f\xa4\x93",':nerd_face:'=>"\xf0\x9f\xa4\x93",':netherlands:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xb1",':neutral_face:'=>"\xf0\x9f\x98\x90",':new:'=>"\xf0\x9f\x86\x95",':new_caledonia:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xa8",':new_moon:'=>"\xf0\x9f\x8c\x91",':new_moon_with_face:'=>"\xf0\x9f\x8c\x9a",':new_zealand:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xbf",':newspaper:'=>"\xf0\x9f\x93\xb0",':newspaper2:'=>"\xf0\x9f\x97\x9e\xef\xb8\x8f",':newspaper_roll:'=>"\xf0\x9f\x97\x9e",':next_track_button:'=>"\xe2\x8f\xad",':ng:'=>"\xf0\x9f\x86\x96",':ng_man:'=>"\xf0\x9f\x99\x85\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':ng_woman:'=>"\xf0\x9f\x99\x85",':nicaragua:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xae",':niger:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xaa",':nigeria:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xac",':night_with_stars:'=>"\xf0\x9f\x8c\x83",':nine:'=>"9\xe2\x83\xa3",':niue:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xba",':no_bell:'=>"\xf0\x9f\x94\x95",':no_bicycles:'=>"\xf0\x9f\x9a\xb3",':no_entry:'=>"\xe2\x9b\x94\xef\xb8\x8f",':no_entry_sign:'=>"\xf0\x9f\x9a\xab",':no_good:'=>"\xf0\x9f\x99\x85",':no_good_man:'=>"\xf0\x9f\x99\x85\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':no_good_woman:'=>"\xf0\x9f\x99\x85",':no_mobile_phones:'=>"\xf0\x9f\x93\xb5",':no_mouth:'=>"\xf0\x9f\x98\xb6",':no_pedestrians:'=>"\xf0\x9f\x9a\xb7",':no_smoking:'=>"\xf0\x9f\x9a\xad",':non-potable_water:'=>"\xf0\x9f\x9a\xb1",':norfolk_island:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xab",':north_korea:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xb5",':northern_mariana_islands:'=>"\xf0\x9f\x87\xb2\xf0\x9f\x87\xb5",':norway:'=>"\xf0\x9f\x87\xb3\xf0\x9f\x87\xb4",':nose:'=>"\xf0\x9f\x91\x83",':nose_tone1:'=>"\xf0\x9f\x91\x83\xf0\x9f\x8f\xbb",':nose_tone2:'=>"\xf0\x9f\x91\x83\xf0\x9f\x8f\xbc",':nose_tone3:'=>"\xf0\x9f\x91\x83\xf0\x9f\x8f\xbd",':nose_tone4:'=>"\xf0\x9f\x91\x83\xf0\x9f\x8f\xbe",':nose_tone5:'=>"\xf0\x9f\x91\x83\xf0\x9f\x8f\xbf",':notebook:'=>"\xf0\x9f\x93\x93",':notebook_with_decorative_cover:'=>"\xf0\x9f\x93\x94",':notepad_spiral:'=>"\xf0\x9f\x97\x92\xef\xb8\x8f",':notes:'=>"\xf0\x9f\x8e\xb6",':nut_and_bolt:'=>"\xf0\x9f\x94\xa9",':o:'=>"\xe2\xad\x95\xef\xb8\x8f",':o2:'=>"\xf0\x9f\x85\xbe\xef\xb8\x8f",':ocean:'=>"\xf0\x9f\x8c\x8a",':octagonal_sign:'=>"\xf0\x9f\x9b\x91",':octopus:'=>"\xf0\x9f\x90\x99",':oden:'=>"\xf0\x9f\x8d\xa2",':office:'=>"\xf0\x9f\x8f\xa2",':oil:'=>"\xf0\x9f\x9b\xa2\xef\xb8\x8f",':oil_drum:'=>"\xf0\x9f\x9b\xa2",':ok:'=>"\xf0\x9f\x86\x97",':ok_hand:'=>"\xf0\x9f\x91\x8c",':ok_hand_tone1:'=>"\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbb",':ok_hand_tone2:'=>"\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbc",':ok_hand_tone3:'=>"\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbd",':ok_hand_tone4:'=>"\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbe",':ok_hand_tone5:'=>"\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbf",':ok_man:'=>"\xf0\x9f\x99\x86\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':ok_woman:'=>"\xf0\x9f\x99\x86",':old_key:'=>"\xf0\x9f\x97\x9d",':older_adult:'=>"\xf0\x9f\xa7\x93\xf0\x9f\x8f\xbf",':older_adult_tone1:'=>"\xf0\x9f\xa7\x93\xf0\x9f\x8f\xbb",':older_adult_tone2:'=>"\xf0\x9f\xa7\x93\xf0\x9f\x8f\xbc",':older_adult_tone3:'=>"\xf0\x9f\xa7\x93\xf0\x9f\x8f\xbd",':older_adult_tone4:'=>"\xf0\x9f\xa7\x93\xf0\x9f\x8f\xbe",':older_adult_tone5:'=>"\xf0\x9f\xa7\x93\xf0\x9f\x8f\xbf",':older_man:'=>"\xf0\x9f\x91\xb4",':older_man_tone1:'=>"\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbb",':older_man_tone2:'=>"\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbc",':older_man_tone3:'=>"\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbd",':older_man_tone4:'=>"\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbe",':older_man_tone5:'=>"\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbf",':older_woman:'=>"\xf0\x9f\x91\xb5",':older_woman_tone1:'=>"\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbb",':older_woman_tone2:'=>"\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbc",':older_woman_tone3:'=>"\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbd",':older_woman_tone4:'=>"\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbe",':older_woman_tone5:'=>"\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbf",':om:'=>"\xf0\x9f\x95\x89",':om_symbol:'=>"\xf0\x9f\x95\x89\xef\xb8\x8f",':oman:'=>"\xf0\x9f\x87\xb4\xf0\x9f\x87\xb2",':on:'=>"\xf0\x9f\x94\x9b",':oncoming_automobile:'=>"\xf0\x9f\x9a\x98",':oncoming_bus:'=>"\xf0\x9f\x9a\x8d",':oncoming_police_car:'=>"\xf0\x9f\x9a\x94",':oncoming_taxi:'=>"\xf0\x9f\x9a\x96",':one:'=>"1\xe2\x83\xa3",':open_book:'=>"\xf0\x9f\x93\x96",':open_file_folder:'=>"\xf0\x9f\x93\x82",':open_hands:'=>"\xf0\x9f\x91\x90",':open_hands_tone1:'=>"\xf0\x9f\x91\x90\xf0\x9f\x8f\xbb",':open_hands_tone2:'=>"\xf0\x9f\x91\x90\xf0\x9f\x8f\xbc",':open_hands_tone3:'=>"\xf0\x9f\x91\x90\xf0\x9f\x8f\xbd",':open_hands_tone4:'=>"\xf0\x9f\x91\x90\xf0\x9f\x8f\xbe",':open_hands_tone5:'=>"\xf0\x9f\x91\x90\xf0\x9f\x8f\xbf",':open_mouth:'=>"\xf0\x9f\x98\xae",':open_umbrella:'=>"\xe2\x98\x82\xef\xb8\x8f",':ophiuchus:'=>"\xe2\x9b\x8e",':orange:'=>"\xf0\x9f\x8d\x8a",':orange_book:'=>"\xf0\x9f\x93\x99",':orange_heart:'=>"\xf0\x9f\xa7\xa1",':orthodox_cross:'=>"\xe2\x98\xa6\xef\xb8\x8f",':outbox_tray:'=>"\xf0\x9f\x93\xa4",':owl:'=>"\xf0\x9f\xa6\x89",':ox:'=>"\xf0\x9f\x90\x82",':package:'=>"\xf0\x9f\x93\xa6",':page_facing_up:'=>"\xf0\x9f\x93\x84",':page_with_curl:'=>"\xf0\x9f\x93\x83",':pager:'=>"\xf0\x9f\x93\x9f",':paintbrush:'=>"\xf0\x9f\x96\x8c",':pakistan:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xb0",':palau:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xbc",':palestinian_territories:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xb8",':palm_tree:'=>"\xf0\x9f\x8c\xb4",':palms_up_together:'=>"\xf0\x9f\xa4\xb2\xf0\x9f\x8f\xbf",':palms_up_together_tone1:'=>"\xf0\x9f\xa4\xb2\xf0\x9f\x8f\xbb",':palms_up_together_tone2:'=>"\xf0\x9f\xa4\xb2\xf0\x9f\x8f\xbc",':palms_up_together_tone3:'=>"\xf0\x9f\xa4\xb2\xf0\x9f\x8f\xbd",':palms_up_together_tone4:'=>"\xf0\x9f\xa4\xb2\xf0\x9f\x8f\xbe",':palms_up_together_tone5:'=>"\xf0\x9f\xa4\xb2\xf0\x9f\x8f\xbf",':panama:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xa6",':pancakes:'=>"\xf0\x9f\xa5\x9e",':panda_face:'=>"\xf0\x9f\x90\xbc",':paperclip:'=>"\xf0\x9f\x93\x8e",':paperclips:'=>"\xf0\x9f\x96\x87",':papua_new_guinea:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xac",':paraguay:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xbe",':parasol_on_ground:'=>"\xe2\x9b\xb1",':park:'=>"\xf0\x9f\x8f\x9e\xef\xb8\x8f",':parking:'=>"\xf0\x9f\x85\xbf\xef\xb8\x8f",':part_alternation_mark:'=>"\xe3\x80\xbd\xef\xb8\x8f",':partly_sunny:'=>"\xe2\x9b\x85\xef\xb8\x8f",':passenger_ship:'=>"\xf0\x9f\x9b\xb3",':passport_control:'=>"\xf0\x9f\x9b\x82",':pause_button:'=>"\xe2\x8f\xb8",':paw_prints:'=>"\xf0\x9f\x90\xbe",':peace:'=>"\xe2\x98\xae\xef\xb8\x8f",':peace_symbol:'=>"\xe2\x98\xae\xef\xb8\x8f",':peach:'=>"\xf0\x9f\x8d\x91",':peanuts:'=>"\xf0\x9f\xa5\x9c",':pear:'=>"\xf0\x9f\x8d\x90",':pen:'=>"\xf0\x9f\x96\x8a",':pen_ballpoint:'=>"\xf0\x9f\x96\x8a\xef\xb8\x8f",':pen_fountain:'=>"\xf0\x9f\x96\x8b\xef\xb8\x8f",':pencil:'=>"\xf0\x9f\x93\x9d",':pencil2:'=>"\xe2\x9c\x8f\xef\xb8\x8f",':penguin:'=>"\xf0\x9f\x90\xa7",':pensive:'=>"\xf0\x9f\x98\x94",':people_with_bunny_ears_partying:'=>"\xf0\x9f\x91\xaf",':people_wrestling:'=>"\xf0\x9f\xa4\xbc",':performing_arts:'=>"\xf0\x9f\x8e\xad",':persevere:'=>"\xf0\x9f\x98\xa3",':person_biking:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbf",':person_biking_tone1:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbb",':person_biking_tone2:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbc",':person_biking_tone3:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbd",':person_biking_tone4:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbe",':person_biking_tone5:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbf",':person_bouncing_ball:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbf",':person_bouncing_ball_tone1:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbb",':person_bouncing_ball_tone2:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbc",':person_bouncing_ball_tone3:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbd",':person_bouncing_ball_tone4:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbe",':person_bouncing_ball_tone5:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbf",':person_bowing:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbf",':person_bowing_tone1:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbb",':person_bowing_tone2:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbc",':person_bowing_tone3:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbd",':person_bowing_tone4:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbe",':person_bowing_tone5:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbf",':person_climbing:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbf",':person_climbing_tone1:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbb",':person_climbing_tone2:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbc",':person_climbing_tone3:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbd",':person_climbing_tone4:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbe",':person_climbing_tone5:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbf",':person_doing_cartwheel:'=>"\xf0\x9f\xa4\xb8",':person_doing_cartwheel_tone1:'=>"\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbb",':person_doing_cartwheel_tone2:'=>"\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbc",':person_doing_cartwheel_tone3:'=>"\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbd",':person_doing_cartwheel_tone4:'=>"\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbe",':person_doing_cartwheel_tone5:'=>"\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbf",':person_facepalming:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbf",':person_facepalming_tone1:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbb",':person_facepalming_tone2:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbc",':person_facepalming_tone3:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbd",':person_facepalming_tone4:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbe",':person_facepalming_tone5:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbf",':person_fencing:'=>"\xf0\x9f\xa4\xba",':person_frowning:'=>"\xf0\x9f\x99\x8d",':person_frowning_tone1:'=>"\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbb",':person_frowning_tone2:'=>"\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbc",':person_frowning_tone3:'=>"\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbd",':person_frowning_tone4:'=>"\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbe",':person_frowning_tone5:'=>"\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbf",':person_gesturing_no:'=>"\xf0\x9f\x99\x85",':person_gesturing_no_tone1:'=>"\xf0\x9f\x99\x85\xf0\x9f\x8f\xbb",':person_gesturing_no_tone2:'=>"\xf0\x9f\x99\x85\xf0\x9f\x8f\xbc",':person_gesturing_no_tone3:'=>"\xf0\x9f\x99\x85\xf0\x9f\x8f\xbd",':person_gesturing_no_tone4:'=>"\xf0\x9f\x99\x85\xf0\x9f\x8f\xbe",':person_gesturing_no_tone5:'=>"\xf0\x9f\x99\x85\xf0\x9f\x8f\xbf",':person_gesturing_ok:'=>"\xf0\x9f\x99\x86",':person_gesturing_ok_tone1:'=>"\xf0\x9f\x99\x86\xf0\x9f\x8f\xbb",':person_gesturing_ok_tone2:'=>"\xf0\x9f\x99\x86\xf0\x9f\x8f\xbc",':person_gesturing_ok_tone3:'=>"\xf0\x9f\x99\x86\xf0\x9f\x8f\xbd",':person_gesturing_ok_tone4:'=>"\xf0\x9f\x99\x86\xf0\x9f\x8f\xbe",':person_gesturing_ok_tone5:'=>"\xf0\x9f\x99\x86\xf0\x9f\x8f\xbf",':person_getting_haircut:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbf",':person_getting_haircut_tone1:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbb",':person_getting_haircut_tone2:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbc",':person_getting_haircut_tone3:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbd",':person_getting_haircut_tone4:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbe",':person_getting_haircut_tone5:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbf",':person_getting_massage:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbf",':person_getting_massage_tone1:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbb",':person_getting_massage_tone2:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbc",':person_getting_massage_tone3:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbd",':person_getting_massage_tone4:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbe",':person_getting_massage_tone5:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbf",':person_golfing:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbf",':person_golfing_tone1:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbb",':person_golfing_tone2:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbc",':person_golfing_tone3:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbd",':person_golfing_tone4:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbe",':person_golfing_tone5:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbf",':person_in_bed_tone1:'=>"\xf0\x9f\x9b\x8c\xf0\x9f\x8f\xbb",':person_in_bed_tone2:'=>"\xf0\x9f\x9b\x8c\xf0\x9f\x8f\xbc",':person_in_bed_tone3:'=>"\xf0\x9f\x9b\x8c\xf0\x9f\x8f\xbd",':person_in_bed_tone4:'=>"\xf0\x9f\x9b\x8c\xf0\x9f\x8f\xbe",':person_in_bed_tone5:'=>"\xf0\x9f\x9b\x8c\xf0\x9f\x8f\xbf",':person_in_lotus_position:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbf",':person_in_lotus_position_tone1:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbb",':person_in_lotus_position_tone2:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbc",':person_in_lotus_position_tone3:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbd",':person_in_lotus_position_tone4:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbe",':person_in_lotus_position_tone5:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbf",':person_in_steamy_room:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbf",':person_in_steamy_room_tone1:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbb",':person_in_steamy_room_tone2:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbc",':person_in_steamy_room_tone3:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbd",':person_in_steamy_room_tone4:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbe",':person_in_steamy_room_tone5:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbf",':person_juggling:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbf",':person_juggling_tone1:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbb",':person_juggling_tone2:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbc",':person_juggling_tone3:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbd",':person_juggling_tone4:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbe",':person_juggling_tone5:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbf",':person_lifting_weights:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbf",':person_lifting_weights_tone1:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbb",':person_lifting_weights_tone2:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbc",':person_lifting_weights_tone3:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbd",':person_lifting_weights_tone4:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbe",':person_lifting_weights_tone5:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbf",':person_mountain_biking:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbf",':person_mountain_biking_tone1:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbb",':person_mountain_biking_tone2:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbc",':person_mountain_biking_tone3:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbd",':person_mountain_biking_tone4:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbe",':person_mountain_biking_tone5:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbf",':person_playing_handball:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbf",':person_playing_handball_tone1:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbb",':person_playing_handball_tone2:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbc",':person_playing_handball_tone3:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbd",':person_playing_handball_tone4:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbe",':person_playing_handball_tone5:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbf",':person_playing_water_polo:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbf",':person_playing_water_polo_tone1:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbb",':person_playing_water_polo_tone2:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbc",':person_playing_water_polo_tone3:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbd",':person_playing_water_polo_tone4:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbe",':person_playing_water_polo_tone5:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbf",':person_pouting:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbf",':person_pouting_tone1:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbb",':person_pouting_tone2:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbc",':person_pouting_tone3:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbd",':person_pouting_tone4:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbe",':person_pouting_tone5:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbf",':person_raising_hand:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbf",':person_raising_hand_tone1:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbb",':person_raising_hand_tone2:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbc",':person_raising_hand_tone3:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbd",':person_raising_hand_tone4:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbe",':person_raising_hand_tone5:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbf",':person_rowing_boat:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbf",':person_rowing_boat_tone1:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbb",':person_rowing_boat_tone2:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbc",':person_rowing_boat_tone3:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbd",':person_rowing_boat_tone4:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbe",':person_rowing_boat_tone5:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbf",':person_running:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbf",':person_running_tone1:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbb",':person_running_tone2:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbc",':person_running_tone3:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbd",':person_running_tone4:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbe",':person_running_tone5:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbf",':person_shrugging:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbf",':person_shrugging_tone1:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbb",':person_shrugging_tone2:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbc",':person_shrugging_tone3:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbd",':person_shrugging_tone4:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbe",':person_shrugging_tone5:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbf",':person_surfing:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbf",':person_surfing_tone1:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbb",':person_surfing_tone2:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbc",':person_surfing_tone3:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbd",':person_surfing_tone4:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbe",':person_surfing_tone5:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbf",':person_swimming:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbf",':person_swimming_tone1:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbb",':person_swimming_tone2:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbc",':person_swimming_tone3:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbd",':person_swimming_tone4:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbe",':person_swimming_tone5:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbf",':person_tipping_hand:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbf",':person_tipping_hand_tone1:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbb",':person_tipping_hand_tone2:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbc",':person_tipping_hand_tone3:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbd",':person_tipping_hand_tone4:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbe",':person_tipping_hand_tone5:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbf",':person_walking:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbf",':person_walking_tone1:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbb",':person_walking_tone2:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbc",':person_walking_tone3:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbd",':person_walking_tone4:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbe",':person_walking_tone5:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbf",':person_wearing_turban:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbf",':person_wearing_turban_tone1:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbb",':person_wearing_turban_tone2:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbc",':person_wearing_turban_tone3:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbd",':person_wearing_turban_tone4:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbe",':person_wearing_turban_tone5:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbf",':person_with_blond_hair:'=>"\xf0\x9f\x91\xb1",':person_with_pouting_face:'=>"\xf0\x9f\x99\x8e",':peru:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xaa",':philippines:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xad",':phone:'=>"\xe2\x98\x8e\xef\xb8\x8f",':pick:'=>"\xe2\x9b\x8f",':pie:'=>"\xf0\x9f\xa5\xa7",':pig:'=>"\xf0\x9f\x90\xb7",':pig2:'=>"\xf0\x9f\x90\x96",':pig_nose:'=>"\xf0\x9f\x90\xbd",':pill:'=>"\xf0\x9f\x92\x8a",':pineapple:'=>"\xf0\x9f\x8d\x8d",':ping_pong:'=>"\xf0\x9f\x8f\x93",':pisces:'=>"\xe2\x99\x93\xef\xb8\x8f",':pitcairn_islands:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xb3",':pizza:'=>"\xf0\x9f\x8d\x95",':place_of_worship:'=>"\xf0\x9f\x9b\x90",':plate_with_cutlery:'=>"\xf0\x9f\x8d\xbd",':play_or_pause_button:'=>"\xe2\x8f\xaf",':play_pause:'=>"\xe2\x8f\xaf\xef\xb8\x8f",':point_down:'=>"\xf0\x9f\x91\x87",':point_down_tone1:'=>"\xf0\x9f\x91\x87\xf0\x9f\x8f\xbb",':point_down_tone2:'=>"\xf0\x9f\x91\x87\xf0\x9f\x8f\xbc",':point_down_tone3:'=>"\xf0\x9f\x91\x87\xf0\x9f\x8f\xbd",':point_down_tone4:'=>"\xf0\x9f\x91\x87\xf0\x9f\x8f\xbe",':point_down_tone5:'=>"\xf0\x9f\x91\x87\xf0\x9f\x8f\xbf",':point_left:'=>"\xf0\x9f\x91\x88",':point_left_tone1:'=>"\xf0\x9f\x91\x88\xf0\x9f\x8f\xbb",':point_left_tone2:'=>"\xf0\x9f\x91\x88\xf0\x9f\x8f\xbc",':point_left_tone3:'=>"\xf0\x9f\x91\x88\xf0\x9f\x8f\xbd",':point_left_tone4:'=>"\xf0\x9f\x91\x88\xf0\x9f\x8f\xbe",':point_left_tone5:'=>"\xf0\x9f\x91\x88\xf0\x9f\x8f\xbf",':point_right:'=>"\xf0\x9f\x91\x89",':point_right_tone1:'=>"\xf0\x9f\x91\x89\xf0\x9f\x8f\xbb",':point_right_tone2:'=>"\xf0\x9f\x91\x89\xf0\x9f\x8f\xbc",':point_right_tone3:'=>"\xf0\x9f\x91\x89\xf0\x9f\x8f\xbd",':point_right_tone4:'=>"\xf0\x9f\x91\x89\xf0\x9f\x8f\xbe",':point_right_tone5:'=>"\xf0\x9f\x91\x89\xf0\x9f\x8f\xbf",':point_up:'=>"\xe2\x98\x9d\xef\xb8\x8f",':point_up_2:'=>"\xf0\x9f\x91\x86",':point_up_2_tone1:'=>"\xf0\x9f\x91\x86\xf0\x9f\x8f\xbb",':point_up_2_tone2:'=>"\xf0\x9f\x91\x86\xf0\x9f\x8f\xbc",':point_up_2_tone3:'=>"\xf0\x9f\x91\x86\xf0\x9f\x8f\xbd",':point_up_2_tone4:'=>"\xf0\x9f\x91\x86\xf0\x9f\x8f\xbe",':point_up_2_tone5:'=>"\xf0\x9f\x91\x86\xf0\x9f\x8f\xbf",':point_up_tone1:'=>"\xe2\x98\x9d\xf0\x9f\x8f\xbb",':point_up_tone2:'=>"\xe2\x98\x9d\xf0\x9f\x8f\xbc",':point_up_tone3:'=>"\xe2\x98\x9d\xf0\x9f\x8f\xbd",':point_up_tone4:'=>"\xe2\x98\x9d\xf0\x9f\x8f\xbe",':point_up_tone5:'=>"\xe2\x98\x9d\xf0\x9f\x8f\xbf",':poland:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xb1",':police_car:'=>"\xf0\x9f\x9a\x93",':police_officer:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbf",':police_officer_tone1:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbb",':police_officer_tone2:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbc",':police_officer_tone3:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbd",':police_officer_tone4:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbe",':police_officer_tone5:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbf",':policeman:'=>"\xf0\x9f\x91\xae",':policewoman:'=>"\xf0\x9f\x91\xae\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':poodle:'=>"\xf0\x9f\x90\xa9",':poop:'=>"\xf0\x9f\x92\xa9",':popcorn:'=>"\xf0\x9f\x8d\xbf",':portugal:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xb9",':post_office:'=>"\xf0\x9f\x8f\xa3",':postal_horn:'=>"\xf0\x9f\x93\xaf",':postbox:'=>"\xf0\x9f\x93\xae",':potable_water:'=>"\xf0\x9f\x9a\xb0",':potato:'=>"\xf0\x9f\xa5\x94",':pouch:'=>"\xf0\x9f\x91\x9d",':poultry_leg:'=>"\xf0\x9f\x8d\x97",':pound:'=>"\xf0\x9f\x92\xb7",':pound_symbol:'=>"#",':pout:'=>"\xf0\x9f\x98\xa1",':pouting_cat:'=>"\xf0\x9f\x98\xbe",':pouting_man:'=>"\xf0\x9f\x99\x8e\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':pouting_woman:'=>"\xf0\x9f\x99\x8e",':pray:'=>"\xf0\x9f\x99\x8f",':pray_tone1:'=>"\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbb",':pray_tone2:'=>"\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbc",':pray_tone3:'=>"\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbd",':pray_tone4:'=>"\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbe",':pray_tone5:'=>"\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbf",':prayer_beads:'=>"\xf0\x9f\x93\xbf",':pregnant_woman:'=>"\xf0\x9f\xa4\xb0",':pregnant_woman_tone1:'=>"\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbb",':pregnant_woman_tone2:'=>"\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbc",':pregnant_woman_tone3:'=>"\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbd",':pregnant_woman_tone4:'=>"\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbe",':pregnant_woman_tone5:'=>"\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbf",':pretzel:'=>"\xf0\x9f\xa5\xa8",':previous_track_button:'=>"\xe2\x8f\xae",':prince:'=>"\xf0\x9f\xa4\xb4",':prince_tone1:'=>"\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbb",':prince_tone2:'=>"\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbc",':prince_tone3:'=>"\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbd",':prince_tone4:'=>"\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbe",':prince_tone5:'=>"\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbf",':princess:'=>"\xf0\x9f\x91\xb8",':princess_tone1:'=>"\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbb",':princess_tone2:'=>"\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbc",':princess_tone3:'=>"\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbd",':princess_tone4:'=>"\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbe",':princess_tone5:'=>"\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbf",':printer:'=>"\xf0\x9f\x96\xa8",':projector:'=>"\xf0\x9f\x93\xbd\xef\xb8\x8f",':puerto_rico:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xb7",':punch:'=>"\xf0\x9f\x91\x8a",':punch_tone1:'=>"\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbb",':punch_tone2:'=>"\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbc",':punch_tone3:'=>"\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbd",':punch_tone4:'=>"\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbe",':punch_tone5:'=>"\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbf",':purple_heart:'=>"\xf0\x9f\x92\x9c",':purse:'=>"\xf0\x9f\x91\x9b",':pushpin:'=>"\xf0\x9f\x93\x8c",':put_litter_in_its_place:'=>"\xf0\x9f\x9a\xae",':qatar:'=>"\xf0\x9f\x87\xb6\xf0\x9f\x87\xa6",':question:'=>"\xe2\x9d\x93",':rabbit:'=>"\xf0\x9f\x90\xb0",':rabbit2:'=>"\xf0\x9f\x90\x87",':race_car:'=>"\xf0\x9f\x8f\x8e\xef\xb8\x8f",':racehorse:'=>"\xf0\x9f\x90\x8e",':racing_car:'=>"\xf0\x9f\x8f\x8e",':radio:'=>"\xf0\x9f\x93\xbb",':radio_button:'=>"\xf0\x9f\x94\x98",':radioactive:'=>"\xe2\x98\xa2\xef\xb8\x8f",':rage:'=>"\xf0\x9f\x98\xa1",':railway_car:'=>"\xf0\x9f\x9a\x83",':railway_track:'=>"\xf0\x9f\x9b\xa4",':rainbow:'=>"\xf0\x9f\x8c\x88",':rainbow_flag:'=>"\xf0\x9f\x8f\xb3\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x8c\x88",':raised_back_of_hand:'=>"\xf0\x9f\xa4\x9a",':raised_back_of_hand_tone1:'=>"\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbb",':raised_back_of_hand_tone2:'=>"\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbc",':raised_back_of_hand_tone3:'=>"\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbd",':raised_back_of_hand_tone4:'=>"\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbe",':raised_back_of_hand_tone5:'=>"\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbf",':raised_hand:'=>"\xe2\x9c\x8b",':raised_hand_tone1:'=>"\xe2\x9c\x8b\xf0\x9f\x8f\xbb",':raised_hand_tone2:'=>"\xe2\x9c\x8b\xf0\x9f\x8f\xbc",':raised_hand_tone3:'=>"\xe2\x9c\x8b\xf0\x9f\x8f\xbd",':raised_hand_tone4:'=>"\xe2\x9c\x8b\xf0\x9f\x8f\xbe",':raised_hand_tone5:'=>"\xe2\x9c\x8b\xf0\x9f\x8f\xbf",':raised_hand_with_fingers_splayed:'=>"\xf0\x9f\x96\x90",':raised_hands:'=>"\xf0\x9f\x99\x8c",':raised_hands_tone1:'=>"\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbb",':raised_hands_tone2:'=>"\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbc",':raised_hands_tone3:'=>"\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbd",':raised_hands_tone4:'=>"\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbe",':raised_hands_tone5:'=>"\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbf",':raising_hand:'=>"\xf0\x9f\x99\x8b",':raising_hand_man:'=>"\xf0\x9f\x99\x8b\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':raising_hand_woman:'=>"\xf0\x9f\x99\x8b",':ram:'=>"\xf0\x9f\x90\x8f",':ramen:'=>"\xf0\x9f\x8d\x9c",':rat:'=>"\xf0\x9f\x90\x80",':record_button:'=>"\xe2\x8f\xba",':recycle:'=>"\xe2\x99\xbb\xef\xb8\x8f",':red_car:'=>"\xf0\x9f\x9a\x97",':red_circle:'=>"\xf0\x9f\x94\xb4",':regional_indicator_a:'=>"\xf0\x9f\x87\xa6",':regional_indicator_b:'=>"\xf0\x9f\x87\xa7",':regional_indicator_c:'=>"\xf0\x9f\x87\xa8",':regional_indicator_d:'=>"\xf0\x9f\x87\xa9",':regional_indicator_e:'=>"\xf0\x9f\x87\xaa",':regional_indicator_f:'=>"\xf0\x9f\x87\xab",':regional_indicator_g:'=>"\xf0\x9f\x87\xac",':regional_indicator_h:'=>"\xf0\x9f\x87\xad",':regional_indicator_i:'=>"\xf0\x9f\x87\xae",':regional_indicator_j:'=>"\xf0\x9f\x87\xaf",':regional_indicator_k:'=>"\xf0\x9f\x87\xb0",':regional_indicator_l:'=>"\xf0\x9f\x87\xb1",':regional_indicator_m:'=>"\xf0\x9f\x87\xb2",':regional_indicator_n:'=>"\xf0\x9f\x87\xb3",':regional_indicator_o:'=>"\xf0\x9f\x87\xb4",':regional_indicator_p:'=>"\xf0\x9f\x87\xb5",':regional_indicator_q:'=>"\xf0\x9f\x87\xb6",':regional_indicator_r:'=>"\xf0\x9f\x87\xb7",':regional_indicator_s:'=>"\xf0\x9f\x87\xb8",':regional_indicator_t:'=>"\xf0\x9f\x87\xb9",':regional_indicator_u:'=>"\xf0\x9f\x87\xba",':regional_indicator_v:'=>"\xf0\x9f\x87\xbb",':regional_indicator_w:'=>"\xf0\x9f\x87\xbc",':regional_indicator_x:'=>"\xf0\x9f\x87\xbd",':regional_indicator_y:'=>"\xf0\x9f\x87\xbe",':regional_indicator_z:'=>"\xf0\x9f\x87\xbf",':registered:'=>"\xc2\xae\xef\xb8\x8f",':relaxed:'=>"\xe2\x98\xba\xef\xb8\x8f",':relieved:'=>"\xf0\x9f\x98\x8c",':reminder_ribbon:'=>"\xf0\x9f\x8e\x97",':repeat:'=>"\xf0\x9f\x94\x81",':repeat_one:'=>"\xf0\x9f\x94\x82",':rescue_worker_helmet:'=>"\xe2\x9b\x91",':restroom:'=>"\xf0\x9f\x9a\xbb",':reunion:'=>"\xf0\x9f\x87\xb7\xf0\x9f\x87\xaa",':revolving_hearts:'=>"\xf0\x9f\x92\x9e",':rewind:'=>"\xe2\x8f\xaa",':rhino:'=>"\xf0\x9f\xa6\x8f",':rhinoceros:'=>"\xf0\x9f\xa6\x8f",':ribbon:'=>"\xf0\x9f\x8e\x80",':rice:'=>"\xf0\x9f\x8d\x9a",':rice_ball:'=>"\xf0\x9f\x8d\x99",':rice_cracker:'=>"\xf0\x9f\x8d\x98",':rice_scene:'=>"\xf0\x9f\x8e\x91",':right_anger_bubble:'=>"\xf0\x9f\x97\xaf",':right_facing_fist:'=>"\xf0\x9f\xa4\x9c",':right_facing_fist_tone1:'=>"\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbb",':right_facing_fist_tone2:'=>"\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbc",':right_facing_fist_tone3:'=>"\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbd",':right_facing_fist_tone4:'=>"\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbe",':right_facing_fist_tone5:'=>"\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbf",':ring:'=>"\xf0\x9f\x92\x8d",':robot:'=>"\xf0\x9f\xa4\x96",':rocket:'=>"\xf0\x9f\x9a\x80",':rofl:'=>"\xf0\x9f\xa4\xa3",':roll_eyes:'=>"\xf0\x9f\x99\x84",':roller_coaster:'=>"\xf0\x9f\x8e\xa2",':rolling_eyes:'=>"\xf0\x9f\x99\x84",':romania:'=>"\xf0\x9f\x87\xb7\xf0\x9f\x87\xb4",':rooster:'=>"\xf0\x9f\x90\x93",':rose:'=>"\xf0\x9f\x8c\xb9",':rosette:'=>"\xf0\x9f\x8f\xb5",':rotating_light:'=>"\xf0\x9f\x9a\xa8",':round_pushpin:'=>"\xf0\x9f\x93\x8d",':rowboat:'=>"\xf0\x9f\x9a\xa3",':rowing_man:'=>"\xf0\x9f\x9a\xa3",':rowing_woman:'=>"\xf0\x9f\x9a\xa3\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':ru:'=>"\xf0\x9f\x87\xb7\xf0\x9f\x87\xba",':rugby_football:'=>"\xf0\x9f\x8f\x89",':runner:'=>"\xf0\x9f\x8f\x83",':running:'=>"\xf0\x9f\x8f\x83",':running_man:'=>"\xf0\x9f\x8f\x83",':running_shirt_with_sash:'=>"\xf0\x9f\x8e\xbd",':running_woman:'=>"\xf0\x9f\x8f\x83\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':rwanda:'=>"\xf0\x9f\x87\xb7\xf0\x9f\x87\xbc",':sa:'=>"\xf0\x9f\x88\x82\xef\xb8\x8f",':sagittarius:'=>"\xe2\x99\x90\xef\xb8\x8f",':sailboat:'=>"\xe2\x9b\xb5\xef\xb8\x8f",':sake:'=>"\xf0\x9f\x8d\xb6",':salad:'=>"\xf0\x9f\xa5\x97",':samoa:'=>"\xf0\x9f\x87\xbc\xf0\x9f\x87\xb8",':san_marino:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb2",':sandal:'=>"\xf0\x9f\x91\xa1",':sandwich:'=>"\xf0\x9f\xa5\xaa",':santa:'=>"\xf0\x9f\x8e\x85",':santa_tone1:'=>"\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbb",':santa_tone2:'=>"\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbc",':santa_tone3:'=>"\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbd",':santa_tone4:'=>"\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbe",':santa_tone5:'=>"\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbf",':sao_tome_principe:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb9",':sassy_man:'=>"\xf0\x9f\x92\x81\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':sassy_woman:'=>"\xf0\x9f\x92\x81",':satellite:'=>"\xf0\x9f\x93\xa1",':satellite_orbital:'=>"\xf0\x9f\x9b\xb0\xef\xb8\x8f",':satisfied:'=>"\xf0\x9f\x98\x86",':saudi_arabia:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xa6",':sauropod:'=>"\xf0\x9f\xa6\x95",':saxophone:'=>"\xf0\x9f\x8e\xb7",':scales:'=>"\xe2\x9a\x96\xef\xb8\x8f",':scarf:'=>"\xf0\x9f\xa7\xa3",':school:'=>"\xf0\x9f\x8f\xab",':school_satchel:'=>"\xf0\x9f\x8e\x92",':scissors:'=>"\xe2\x9c\x82\xef\xb8\x8f",':scooter:'=>"\xf0\x9f\x9b\xb4",':scorpion:'=>"\xf0\x9f\xa6\x82",':scorpius:'=>"\xe2\x99\x8f\xef\xb8\x8f",':scotland:'=>"\xf0\x9f\x8f\xb4\xf3\xa0\x81\xa7\xf3\xa0\x81\xa2\xf3\xa0\x81\xb3\xf3\xa0\x81\xa3\xf3\xa0\x81\xb4\xf3\xa0\x81\xbf",':scream:'=>"\xf0\x9f\x98\xb1",':scream_cat:'=>"\xf0\x9f\x99\x80",':scroll:'=>"\xf0\x9f\x93\x9c",':seat:'=>"\xf0\x9f\x92\xba",':second_place:'=>"\xf0\x9f\xa5\x88",':secret:'=>"\xe3\x8a\x99\xef\xb8\x8f",':see_no_evil:'=>"\xf0\x9f\x99\x88",':seedling:'=>"\xf0\x9f\x8c\xb1",':selfie:'=>"\xf0\x9f\xa4\xb3",':selfie_tone1:'=>"\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbb",':selfie_tone2:'=>"\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbc",':selfie_tone3:'=>"\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbd",':selfie_tone4:'=>"\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbe",':selfie_tone5:'=>"\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbf",':senegal:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb3",':serbia:'=>"\xf0\x9f\x87\xb7\xf0\x9f\x87\xb8",':seven:'=>"7\xe2\x83\xa3",':seychelles:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xa8",':shallow_pan_of_food:'=>"\xf0\x9f\xa5\x98",':shamrock:'=>"\xe2\x98\x98\xef\xb8\x8f",':shark:'=>"\xf0\x9f\xa6\x88",':shaved_ice:'=>"\xf0\x9f\x8d\xa7",':sheep:'=>"\xf0\x9f\x90\x91",':shell:'=>"\xf0\x9f\x90\x9a",':shield:'=>"\xf0\x9f\x9b\xa1",':shinto_shrine:'=>"\xe2\x9b\xa9",':ship:'=>"\xf0\x9f\x9a\xa2",':shirt:'=>"\xf0\x9f\x91\x95",':shit:'=>"\xf0\x9f\x92\xa9",':shoe:'=>"\xf0\x9f\x91\x9e",':shopping:'=>"\xf0\x9f\x9b\x8d",':shopping_bags:'=>"\xf0\x9f\x9b\x8d\xef\xb8\x8f",':shopping_cart:'=>"\xf0\x9f\x9b\x92",':shower:'=>"\xf0\x9f\x9a\xbf",':shrimp:'=>"\xf0\x9f\xa6\x90",':shushing_face:'=>"\xf0\x9f\xa4\xab",':sierra_leone:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb1",':signal_strength:'=>"\xf0\x9f\x93\xb6",':singapore:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xac",':sint_maarten:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xbd",':six:'=>"6\xe2\x83\xa3",':six_pointed_star:'=>"\xf0\x9f\x94\xaf",':ski:'=>"\xf0\x9f\x8e\xbf",':skier:'=>"\xe2\x9b\xb7",':skull:'=>"\xf0\x9f\x92\x80",':skull_and_crossbones:'=>"\xe2\x98\xa0\xef\xb8\x8f",':skull_crossbones:'=>"\xe2\x98\xa0\xef\xb8\x8f",':sled:'=>"\xf0\x9f\x9b\xb7",':sleeping:'=>"\xf0\x9f\x98\xb4",':sleeping_accommodation:'=>"\xf0\x9f\x9b\x8c",':sleeping_bed:'=>"\xf0\x9f\x9b\x8c",':sleepy:'=>"\xf0\x9f\x98\xaa",':slight_frown:'=>"\xf0\x9f\x99\x81",':slight_smile:'=>"\xf0\x9f\x99\x82",':slightly_frowning_face:'=>"\xf0\x9f\x99\x81",':slightly_smiling_face:'=>"\xf0\x9f\x99\x82",':slot_machine:'=>"\xf0\x9f\x8e\xb0",':slovakia:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb0",':slovenia:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xae",':small_airplane:'=>"\xf0\x9f\x9b\xa9",':small_blue_diamond:'=>"\xf0\x9f\x94\xb9",':small_orange_diamond:'=>"\xf0\x9f\x94\xb8",':small_red_triangle:'=>"\xf0\x9f\x94\xba",':small_red_triangle_down:'=>"\xf0\x9f\x94\xbb",':smile:'=>"\xf0\x9f\x98\x84",':smile_cat:'=>"\xf0\x9f\x98\xb8",':smiley:'=>"\xf0\x9f\x98\x83",':smiley_cat:'=>"\xf0\x9f\x98\xba",':smiling_imp:'=>"\xf0\x9f\x98\x88",':smirk:'=>"\xf0\x9f\x98\x8f",':smirk_cat:'=>"\xf0\x9f\x98\xbc",':smoking:'=>"\xf0\x9f\x9a\xac",':snail:'=>"\xf0\x9f\x90\x8c",':snake:'=>"\xf0\x9f\x90\x8d",':sneezing_face:'=>"\xf0\x9f\xa4\xa7",':snowboarder:'=>"\xf0\x9f\x8f\x82",':snowboarder_tone1:'=>"\xf0\x9f\x8f\x82\xf0\x9f\x8f\xbb",':snowboarder_tone2:'=>"\xf0\x9f\x8f\x82\xf0\x9f\x8f\xbc",':snowboarder_tone3:'=>"\xf0\x9f\x8f\x82\xf0\x9f\x8f\xbd",':snowboarder_tone4:'=>"\xf0\x9f\x8f\x82\xf0\x9f\x8f\xbe",':snowboarder_tone5:'=>"\xf0\x9f\x8f\x82\xf0\x9f\x8f\xbf",':snowflake:'=>"\xe2\x9d\x84\xef\xb8\x8f",':snowman:'=>"\xe2\x9b\x84\xef\xb8\x8f",':snowman2:'=>"\xe2\x98\x83\xef\xb8\x8f",':snowman_with_snow:'=>"\xe2\x98\x83\xef\xb8\x8f",':sob:'=>"\xf0\x9f\x98\xad",':soccer:'=>"\xe2\x9a\xbd\xef\xb8\x8f",':socks:'=>"\xf0\x9f\xa7\xa6",':solomon_islands:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xa7",':somalia:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb4",':soon:'=>"\xf0\x9f\x94\x9c",':sos:'=>"\xf0\x9f\x86\x98",':sound:'=>"\xf0\x9f\x94\x89",':south_africa:'=>"\xf0\x9f\x87\xbf\xf0\x9f\x87\xa6",':south_georgia_south_sandwich_islands:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xb8",':south_sudan:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb8",':space_invader:'=>"\xf0\x9f\x91\xbe",':spades:'=>"\xe2\x99\xa0\xef\xb8\x8f",':spaghetti:'=>"\xf0\x9f\x8d\x9d",':sparkle:'=>"\xe2\x9d\x87\xef\xb8\x8f",':sparkler:'=>"\xf0\x9f\x8e\x87",':sparkles:'=>"\xe2\x9c\xa8",':sparkling_heart:'=>"\xf0\x9f\x92\x96",':speak_no_evil:'=>"\xf0\x9f\x99\x8a",':speaker:'=>"\xf0\x9f\x94\x88",':speaking_head:'=>"\xf0\x9f\x97\xa3",':speech_balloon:'=>"\xf0\x9f\x92\xac",':speech_left:'=>"\xf0\x9f\x97\xa8\xef\xb8\x8f",':speedboat:'=>"\xf0\x9f\x9a\xa4",':spider:'=>"\xf0\x9f\x95\xb7",':spider_web:'=>"\xf0\x9f\x95\xb8",':spiral_calendar:'=>"\xf0\x9f\x97\x93",':spiral_notepad:'=>"\xf0\x9f\x97\x92",':spoon:'=>"\xf0\x9f\xa5\x84",':squid:'=>"\xf0\x9f\xa6\x91",':sri_lanka:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xb0",':st_barthelemy:'=>"\xf0\x9f\x87\xa7\xf0\x9f\x87\xb1",':st_helena:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xad",':st_kitts_nevis:'=>"\xf0\x9f\x87\xb0\xf0\x9f\x87\xb3",':st_lucia:'=>"\xf0\x9f\x87\xb1\xf0\x9f\x87\xa8",':st_pierre_miquelon:'=>"\xf0\x9f\x87\xb5\xf0\x9f\x87\xb2",':st_vincent_grenadines:'=>"\xf0\x9f\x87\xbb\xf0\x9f\x87\xa8",':stadium:'=>"\xf0\x9f\x8f\x9f",':star:'=>"\xe2\xad\x90\xef\xb8\x8f",':star2:'=>"\xf0\x9f\x8c\x9f",':star_and_crescent:'=>"\xe2\x98\xaa\xef\xb8\x8f",':star_of_david:'=>"\xe2\x9c\xa1\xef\xb8\x8f",':star_struck:'=>"\xf0\x9f\xa4\xa9",':stars:'=>"\xf0\x9f\x8c\xa0",':station:'=>"\xf0\x9f\x9a\x89",':statue_of_liberty:'=>"\xf0\x9f\x97\xbd",':steam_locomotive:'=>"\xf0\x9f\x9a\x82",':stew:'=>"\xf0\x9f\x8d\xb2",':stop_button:'=>"\xe2\x8f\xb9",':stop_sign:'=>"\xf0\x9f\x9b\x91",':stopwatch:'=>"\xe2\x8f\xb1",':straight_ruler:'=>"\xf0\x9f\x93\x8f",':strawberry:'=>"\xf0\x9f\x8d\x93",':stuck_out_tongue:'=>"\xf0\x9f\x98\x9b",':stuck_out_tongue_closed_eyes:'=>"\xf0\x9f\x98\x9d",':stuck_out_tongue_winking_eye:'=>"\xf0\x9f\x98\x9c",':studio_microphone:'=>"\xf0\x9f\x8e\x99",':stuffed_flatbread:'=>"\xf0\x9f\xa5\x99",':sudan:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xa9",':sun_behind_large_cloud:'=>"\xf0\x9f\x8c\xa5",':sun_behind_rain_cloud:'=>"\xf0\x9f\x8c\xa6",':sun_behind_small_cloud:'=>"\xf0\x9f\x8c\xa4",':sun_with_face:'=>"\xf0\x9f\x8c\x9e",':sunflower:'=>"\xf0\x9f\x8c\xbb",':sunglasses:'=>"\xf0\x9f\x98\x8e",':sunny:'=>"\xe2\x98\x80\xef\xb8\x8f",':sunrise:'=>"\xf0\x9f\x8c\x85",':sunrise_over_mountains:'=>"\xf0\x9f\x8c\x84",':surfer:'=>"\xf0\x9f\x8f\x84",':surfing_man:'=>"\xf0\x9f\x8f\x84",':surfing_woman:'=>"\xf0\x9f\x8f\x84\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':suriname:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xb7",':sushi:'=>"\xf0\x9f\x8d\xa3",':suspension_railway:'=>"\xf0\x9f\x9a\x9f",':swaziland:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xbf",':sweat:'=>"\xf0\x9f\x98\x93",':sweat_drops:'=>"\xf0\x9f\x92\xa6",':sweat_smile:'=>"\xf0\x9f\x98\x85",':sweden:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xaa",':sweet_potato:'=>"\xf0\x9f\x8d\xa0",':swimmer:'=>"\xf0\x9f\x8f\x8a",':swimming_man:'=>"\xf0\x9f\x8f\x8a",':swimming_woman:'=>"\xf0\x9f\x8f\x8a\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':switzerland:'=>"\xf0\x9f\x87\xa8\xf0\x9f\x87\xad",':symbols:'=>"\xf0\x9f\x94\xa3",':synagogue:'=>"\xf0\x9f\x95\x8d",':syria:'=>"\xf0\x9f\x87\xb8\xf0\x9f\x87\xbe",':syringe:'=>"\xf0\x9f\x92\x89",':t_rex:'=>"\xf0\x9f\xa6\x96",':taco:'=>"\xf0\x9f\x8c\xae",':tada:'=>"\xf0\x9f\x8e\x89",':taiwan:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xbc",':tajikistan:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xaf",':takeout_box:'=>"\xf0\x9f\xa5\xa1",':tanabata_tree:'=>"\xf0\x9f\x8e\x8b",':tangerine:'=>"\xf0\x9f\x8d\x8a",':tanzania:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xbf",':taurus:'=>"\xe2\x99\x89\xef\xb8\x8f",':taxi:'=>"\xf0\x9f\x9a\x95",':tea:'=>"\xf0\x9f\x8d\xb5",':telephone:'=>"\xe2\x98\x8e\xef\xb8\x8f",':telephone_receiver:'=>"\xf0\x9f\x93\x9e",':telescope:'=>"\xf0\x9f\x94\xad",':tennis:'=>"\xf0\x9f\x8e\xbe",':tent:'=>"\xe2\x9b\xba\xef\xb8\x8f",':thailand:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xad",':thermometer:'=>"\xf0\x9f\x8c\xa1",':thermometer_face:'=>"\xf0\x9f\xa4\x92",':thinking:'=>"\xf0\x9f\xa4\x94",':third_place:'=>"\xf0\x9f\xa5\x89",':thought_balloon:'=>"\xf0\x9f\x92\xad",':three:'=>"3\xe2\x83\xa3",':thumbsdown:'=>"\xf0\x9f\x91\x8e",':thumbsdown_tone1:'=>"\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbb",':thumbsdown_tone2:'=>"\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbc",':thumbsdown_tone3:'=>"\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbd",':thumbsdown_tone4:'=>"\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbe",':thumbsdown_tone5:'=>"\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbf",':thumbsup:'=>"\xf0\x9f\x91\x8d",':thumbsup_tone1:'=>"\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbb",':thumbsup_tone2:'=>"\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbc",':thumbsup_tone3:'=>"\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbd",':thumbsup_tone4:'=>"\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbe",':thumbsup_tone5:'=>"\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbf",':thunder_cloud_rain:'=>"\xe2\x9b\x88\xef\xb8\x8f",':ticket:'=>"\xf0\x9f\x8e\xab",':tickets:'=>"\xf0\x9f\x8e\x9f",':tiger:'=>"\xf0\x9f\x90\xaf",':tiger2:'=>"\xf0\x9f\x90\x85",':timer:'=>"\xe2\x8f\xb2\xef\xb8\x8f",':timer_clock:'=>"\xe2\x8f\xb2",':timor_leste:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xb1",':tipping_hand_man:'=>"\xf0\x9f\x92\x81\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f",':tipping_hand_woman:'=>"\xf0\x9f\x92\x81",':tired_face:'=>"\xf0\x9f\x98\xab",':tm:'=>"\xe2\x84\xa2\xef\xb8\x8f",':togo:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xac",':toilet:'=>"\xf0\x9f\x9a\xbd",':tokelau:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xb0",':tokyo_tower:'=>"\xf0\x9f\x97\xbc",':tomato:'=>"\xf0\x9f\x8d\x85",':tone1:'=>"\xf0\x9f\x8f\xbb",':tone2:'=>"\xf0\x9f\x8f\xbc",':tone3:'=>"\xf0\x9f\x8f\xbd",':tone4:'=>"\xf0\x9f\x8f\xbe",':tone5:'=>"\xf0\x9f\x8f\xbf",':tonga:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xb4",':tongue:'=>"\xf0\x9f\x91\x85",':tools:'=>"\xf0\x9f\x9b\xa0\xef\xb8\x8f",':top:'=>"\xf0\x9f\x94\x9d",':tophat:'=>"\xf0\x9f\x8e\xa9",':tornado:'=>"\xf0\x9f\x8c\xaa",':tr:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xb7",':track_next:'=>"\xe2\x8f\xad\xef\xb8\x8f",':track_previous:'=>"\xe2\x8f\xae\xef\xb8\x8f",':trackball:'=>"\xf0\x9f\x96\xb2",':tractor:'=>"\xf0\x9f\x9a\x9c",':traffic_light:'=>"\xf0\x9f\x9a\xa5",':train:'=>"\xf0\x9f\x9a\x8b",':train2:'=>"\xf0\x9f\x9a\x86",':tram:'=>"\xf0\x9f\x9a\x8a",':triangular_flag_on_post:'=>"\xf0\x9f\x9a\xa9",':triangular_ruler:'=>"\xf0\x9f\x93\x90",':trident:'=>"\xf0\x9f\x94\xb1",':trinidad_tobago:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xb9",':triumph:'=>"\xf0\x9f\x98\xa4",':trolleybus:'=>"\xf0\x9f\x9a\x8e",':trophy:'=>"\xf0\x9f\x8f\x86",':tropical_drink:'=>"\xf0\x9f\x8d\xb9",':tropical_fish:'=>"\xf0\x9f\x90\xa0",':truck:'=>"\xf0\x9f\x9a\x9a",':trumpet:'=>"\xf0\x9f\x8e\xba",':tshirt:'=>"\xf0\x9f\x91\x95",':tulip:'=>"\xf0\x9f\x8c\xb7",':tumbler_glass:'=>"\xf0\x9f\xa5\x83",':tunisia:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xb3",':turkey:'=>"\xf0\x9f\xa6\x83",':turkmenistan:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xb2",':turks_caicos_islands:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xa8",':turtle:'=>"\xf0\x9f\x90\xa2",':tuvalu:'=>"\xf0\x9f\x87\xb9\xf0\x9f\x87\xbb",':tv:'=>"\xf0\x9f\x93\xba",':twisted_rightwards_arrows:'=>"\xf0\x9f\x94\x80",':two:'=>"2\xe2\x83\xa3",':two_hearts:'=>"\xf0\x9f\x92\x95",':two_men_holding_hands:'=>"\xf0\x9f\x91\xac",':two_women_holding_hands:'=>"\xf0\x9f\x91\xad",':u5272:'=>"\xf0\x9f\x88\xb9",':u5408:'=>"\xf0\x9f\x88\xb4",':u55b6:'=>"\xf0\x9f\x88\xba",':u6307:'=>"\xf0\x9f\x88\xaf\xef\xb8\x8f",':u6708:'=>"\xf0\x9f\x88\xb7\xef\xb8\x8f",':u6709:'=>"\xf0\x9f\x88\xb6",':u6e80:'=>"\xf0\x9f\x88\xb5",':u7121:'=>"\xf0\x9f\x88\x9a\xef\xb8\x8f",':u7533:'=>"\xf0\x9f\x88\xb8",':u7981:'=>"\xf0\x9f\x88\xb2",':u7a7a:'=>"\xf0\x9f\x88\xb3",':uganda:'=>"\xf0\x9f\x87\xba\xf0\x9f\x87\xac",':uk:'=>"\xf0\x9f\x87\xac\xf0\x9f\x87\xa7",':ukraine:'=>"\xf0\x9f\x87\xba\xf0\x9f\x87\xa6",':umbrella:'=>"\xe2\x98\x94\xef\xb8\x8f",':umbrella2:'=>"\xe2\x98\x82\xef\xb8\x8f",':unamused:'=>"\xf0\x9f\x98\x92",':underage:'=>"\xf0\x9f\x94\x9e",':unicorn:'=>"\xf0\x9f\xa6\x84",':united_arab_emirates:'=>"\xf0\x9f\x87\xa6\xf0\x9f\x87\xaa",':united_nations:'=>"\xf0\x9f\x87\xba\xf0\x9f\x87\xb3",':unlock:'=>"\xf0\x9f\x94\x93",':up:'=>"\xf0\x9f\x86\x99",':upside_down:'=>"\xf0\x9f\x99\x83",':upside_down_face:'=>"\xf0\x9f\x99\x83",':urn:'=>"\xe2\x9a\xb1\xef\xb8\x8f",':uruguay:'=>"\xf0\x9f\x87\xba\xf0\x9f\x87\xbe",':us:'=>"\xf0\x9f\x87\xba\xf0\x9f\x87\xb8",':us_virgin_islands:'=>"\xf0\x9f\x87\xbb\xf0\x9f\x87\xae",':uzbekistan:'=>"\xf0\x9f\x87\xba\xf0\x9f\x87\xbf",':v:'=>"\xe2\x9c\x8c\xef\xb8\x8f",':v_tone1:'=>"\xe2\x9c\x8c\xf0\x9f\x8f\xbb",':v_tone2:'=>"\xe2\x9c\x8c\xf0\x9f\x8f\xbc",':v_tone3:'=>"\xe2\x9c\x8c\xf0\x9f\x8f\xbd",':v_tone4:'=>"\xe2\x9c\x8c\xf0\x9f\x8f\xbe",':v_tone5:'=>"\xe2\x9c\x8c\xf0\x9f\x8f\xbf",':vampire:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbf",':vampire_tone1:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbb",':vampire_tone2:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbc",':vampire_tone3:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbd",':vampire_tone4:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbe",':vampire_tone5:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbf",':vanuatu:'=>"\xf0\x9f\x87\xbb\xf0\x9f\x87\xba",':vatican_city:'=>"\xf0\x9f\x87\xbb\xf0\x9f\x87\xa6",':venezuela:'=>"\xf0\x9f\x87\xbb\xf0\x9f\x87\xaa",':vertical_traffic_light:'=>"\xf0\x9f\x9a\xa6",':vhs:'=>"\xf0\x9f\x93\xbc",':vibration_mode:'=>"\xf0\x9f\x93\xb3",':video_camera:'=>"\xf0\x9f\x93\xb9",':video_game:'=>"\xf0\x9f\x8e\xae",':vietnam:'=>"\xf0\x9f\x87\xbb\xf0\x9f\x87\xb3",':violin:'=>"\xf0\x9f\x8e\xbb",':virgo:'=>"\xe2\x99\x8d\xef\xb8\x8f",':volcano:'=>"\xf0\x9f\x8c\x8b",':volleyball:'=>"\xf0\x9f\x8f\x90",':vs:'=>"\xf0\x9f\x86\x9a",':vulcan:'=>"\xf0\x9f\x96\x96",':vulcan_salute:'=>"\xf0\x9f\x96\x96",':vulcan_tone1:'=>"\xf0\x9f\x96\x96\xf0\x9f\x8f\xbb",':vulcan_tone2:'=>"\xf0\x9f\x96\x96\xf0\x9f\x8f\xbc",':vulcan_tone3:'=>"\xf0\x9f\x96\x96\xf0\x9f\x8f\xbd",':vulcan_tone4:'=>"\xf0\x9f\x96\x96\xf0\x9f\x8f\xbe",':vulcan_tone5:'=>"\xf0\x9f\x96\x96\xf0\x9f\x8f\xbf",':wales:'=>"\xf0\x9f\x8f\xb4\xf3\xa0\x81\xa7\xf3\xa0\x81\xa2\xf3\xa0\x81\xb7\xf3\xa0\x81\xac\xf3\xa0\x81\xb3\xf3\xa0\x81\xbf",':walking:'=>"\xf0\x9f\x9a\xb6",':walking_man:'=>"\xf0\x9f\x9a\xb6",':walking_woman:'=>"\xf0\x9f\x9a\xb6\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':wallis_futuna:'=>"\xf0\x9f\x87\xbc\xf0\x9f\x87\xab",':waning_crescent_moon:'=>"\xf0\x9f\x8c\x98",':waning_gibbous_moon:'=>"\xf0\x9f\x8c\x96",':warning:'=>"\xe2\x9a\xa0\xef\xb8\x8f",':wastebasket:'=>"\xf0\x9f\x97\x91",':watch:'=>"\xe2\x8c\x9a\xef\xb8\x8f",':water_buffalo:'=>"\xf0\x9f\x90\x83",':watermelon:'=>"\xf0\x9f\x8d\x89",':wave:'=>"\xf0\x9f\x91\x8b",':wave_tone1:'=>"\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbb",':wave_tone2:'=>"\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbc",':wave_tone3:'=>"\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbd",':wave_tone4:'=>"\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbe",':wave_tone5:'=>"\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbf",':wavy_dash:'=>"\xe3\x80\xb0\xef\xb8\x8f",':waxing_crescent_moon:'=>"\xf0\x9f\x8c\x92",':waxing_gibbous_moon:'=>"\xf0\x9f\x8c\x94",':wc:'=>"\xf0\x9f\x9a\xbe",':weary:'=>"\xf0\x9f\x98\xa9",':wedding:'=>"\xf0\x9f\x92\x92",':weight_lifting_man:'=>"\xf0\x9f\x8f\x8b",':weight_lifting_woman:'=>"\xf0\x9f\x8f\x8b\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':western_sahara:'=>"\xf0\x9f\x87\xaa\xf0\x9f\x87\xad",':whale:'=>"\xf0\x9f\x90\xb3",':whale2:'=>"\xf0\x9f\x90\x8b",':wheel_of_dharma:'=>"\xe2\x98\xb8\xef\xb8\x8f",':wheelchair:'=>"\xe2\x99\xbf\xef\xb8\x8f",':white_check_mark:'=>"\xe2\x9c\x85",':white_circle:'=>"\xe2\x9a\xaa\xef\xb8\x8f",':white_flag:'=>"\xf0\x9f\x8f\xb3\xef\xb8\x8f",':white_flower:'=>"\xf0\x9f\x92\xae",':white_large_square:'=>"\xe2\xac\x9c\xef\xb8\x8f",':white_medium_small_square:'=>"\xe2\x97\xbd\xef\xb8\x8f",':white_medium_square:'=>"\xe2\x97\xbb\xef\xb8\x8f",':white_small_square:'=>"\xe2\x96\xab\xef\xb8\x8f",':white_square_button:'=>"\xf0\x9f\x94\xb3",':white_sun_cloud:'=>"\xf0\x9f\x8c\xa5\xef\xb8\x8f",':white_sun_rain_cloud:'=>"\xf0\x9f\x8c\xa6\xef\xb8\x8f",':white_sun_small_cloud:'=>"\xf0\x9f\x8c\xa4\xef\xb8\x8f",':wilted_flower:'=>"\xf0\x9f\xa5\x80",':wilted_rose:'=>"\xf0\x9f\xa5\x80",':wind_blowing_face:'=>"\xf0\x9f\x8c\xac\xef\xb8\x8f",':wind_chime:'=>"\xf0\x9f\x8e\x90",':wind_face:'=>"\xf0\x9f\x8c\xac",':wine_glass:'=>"\xf0\x9f\x8d\xb7",':wink:'=>"\xf0\x9f\x98\x89",':wolf:'=>"\xf0\x9f\x90\xba",':woman:'=>"\xf0\x9f\x91\xa9",':woman_artist:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8e\xa8",':woman_artist_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\xa8",':woman_artist_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\xa8",':woman_artist_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\xa8",':woman_artist_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\xa8",':woman_artist_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\xa8",':woman_astronaut:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x9a\x80",':woman_astronaut_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x9a\x80",':woman_astronaut_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x9a\x80",':woman_astronaut_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x9a\x80",':woman_astronaut_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x9a\x80",':woman_astronaut_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x9a\x80",':woman_biking:'=>"\xf0\x9f\x9a\xb4\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_biking_tone1:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_biking_tone2:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_biking_tone3:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_biking_tone4:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_biking_tone5:'=>"\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_bouncing_ball:'=>"\xe2\x9b\xb9\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_bouncing_ball_tone1:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_bouncing_ball_tone2:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_bouncing_ball_tone3:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_bouncing_ball_tone4:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_bouncing_ball_tone5:'=>"\xe2\x9b\xb9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_bowing:'=>"\xf0\x9f\x99\x87\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_bowing_tone1:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_bowing_tone2:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_bowing_tone3:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_bowing_tone4:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_bowing_tone5:'=>"\xf0\x9f\x99\x87\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_cartwheeling:'=>"\xf0\x9f\xa4\xb8\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_cartwheeling_tone1:'=>"\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_cartwheeling_tone2:'=>"\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_cartwheeling_tone3:'=>"\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_cartwheeling_tone4:'=>"\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_cartwheeling_tone5:'=>"\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_climbing:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_climbing_tone1:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_climbing_tone2:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_climbing_tone3:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_climbing_tone4:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_climbing_tone5:'=>"\xf0\x9f\xa7\x97\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_construction_worker:'=>"\xf0\x9f\x91\xb7\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_construction_worker_tone1:'=>"\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_construction_worker_tone2:'=>"\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_construction_worker_tone3:'=>"\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_construction_worker_tone4:'=>"\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_construction_worker_tone5:'=>"\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_cook:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8d\xb3",':woman_cook_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8d\xb3",':woman_cook_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8d\xb3",':woman_cook_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8d\xb3",':woman_cook_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8d\xb3",':woman_cook_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8d\xb3",':woman_detective:'=>"\xf0\x9f\x95\xb5\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_detective_tone1:'=>"\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_detective_tone2:'=>"\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_detective_tone3:'=>"\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_detective_tone4:'=>"\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_detective_tone5:'=>"\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_elf:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_elf_tone1:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_elf_tone2:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_elf_tone3:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_elf_tone4:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_elf_tone5:'=>"\xf0\x9f\xa7\x9d\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_facepalming:'=>"\xf0\x9f\xa4\xa6\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_facepalming_tone1:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_facepalming_tone2:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_facepalming_tone3:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_facepalming_tone4:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_facepalming_tone5:'=>"\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_factory_worker:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8f\xad",':woman_factory_worker_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8f\xad",':woman_factory_worker_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8f\xad",':woman_factory_worker_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8f\xad",':woman_factory_worker_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8f\xad",':woman_factory_worker_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8f\xad",':woman_fairy:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_fairy_tone1:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_fairy_tone2:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_fairy_tone3:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_fairy_tone4:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_fairy_tone5:'=>"\xf0\x9f\xa7\x9a\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_farmer:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8c\xbe",':woman_farmer_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8c\xbe",':woman_farmer_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8c\xbe",':woman_farmer_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8c\xbe",':woman_farmer_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8c\xbe",':woman_farmer_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8c\xbe",':woman_firefighter:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x9a\x92",':woman_firefighter_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x9a\x92",':woman_firefighter_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x9a\x92",':woman_firefighter_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x9a\x92",':woman_firefighter_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x9a\x92",':woman_firefighter_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x9a\x92",':woman_frowning:'=>"\xf0\x9f\x99\x8d\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_frowning_tone1:'=>"\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_frowning_tone2:'=>"\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_frowning_tone3:'=>"\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_frowning_tone4:'=>"\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_frowning_tone5:'=>"\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_genie:'=>"\xf0\x9f\xa7\x9e\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_gesturing_no:'=>"\xf0\x9f\x99\x85\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_gesturing_no_tone1:'=>"\xf0\x9f\x99\x85\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_gesturing_no_tone2:'=>"\xf0\x9f\x99\x85\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_gesturing_no_tone3:'=>"\xf0\x9f\x99\x85\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_gesturing_no_tone4:'=>"\xf0\x9f\x99\x85\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_gesturing_no_tone5:'=>"\xf0\x9f\x99\x85\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_gesturing_ok:'=>"\xf0\x9f\x99\x86\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_gesturing_ok_tone1:'=>"\xf0\x9f\x99\x86\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_gesturing_ok_tone2:'=>"\xf0\x9f\x99\x86\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_gesturing_ok_tone3:'=>"\xf0\x9f\x99\x86\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_gesturing_ok_tone4:'=>"\xf0\x9f\x99\x86\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_gesturing_ok_tone5:'=>"\xf0\x9f\x99\x86\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_getting_face_massage:'=>"\xf0\x9f\x92\x86\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_getting_face_massage_tone1:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_getting_face_massage_tone2:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_getting_face_massage_tone3:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_getting_face_massage_tone4:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_getting_face_massage_tone5:'=>"\xf0\x9f\x92\x86\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_getting_haircut:'=>"\xf0\x9f\x92\x87\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_getting_haircut_tone1:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_getting_haircut_tone2:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_getting_haircut_tone3:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_getting_haircut_tone4:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_getting_haircut_tone5:'=>"\xf0\x9f\x92\x87\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_golfing:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_golfing_tone1:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_golfing_tone2:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_golfing_tone3:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_golfing_tone4:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_golfing_tone5:'=>"\xf0\x9f\x8f\x8c\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_guard:'=>"\xf0\x9f\x92\x82\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_guard_tone1:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_guard_tone2:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_guard_tone3:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_guard_tone4:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_guard_tone5:'=>"\xf0\x9f\x92\x82\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_health_worker:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9a\x95\xef\xb8\x8f",':woman_health_worker_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x9a\x95\xef\xb8\x8f",':woman_health_worker_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x9a\x95\xef\xb8\x8f",':woman_health_worker_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x9a\x95\xef\xb8\x8f",':woman_health_worker_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x9a\x95\xef\xb8\x8f",':woman_health_worker_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x9a\x95\xef\xb8\x8f",':woman_in_lotus_position:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_in_lotus_position_tone1:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_in_lotus_position_tone2:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_in_lotus_position_tone3:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_in_lotus_position_tone4:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_in_lotus_position_tone5:'=>"\xf0\x9f\xa7\x98\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_in_steamy_room:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_in_steamy_room_tone1:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_in_steamy_room_tone2:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_in_steamy_room_tone3:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_in_steamy_room_tone4:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_in_steamy_room_tone5:'=>"\xf0\x9f\xa7\x96\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_judge:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9a\x96\xef\xb8\x8f",':woman_judge_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x9a\x96\xef\xb8\x8f",':woman_judge_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x9a\x96\xef\xb8\x8f",':woman_judge_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x9a\x96\xef\xb8\x8f",':woman_judge_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x9a\x96\xef\xb8\x8f",':woman_judge_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x9a\x96\xef\xb8\x8f",':woman_juggling:'=>"\xf0\x9f\xa4\xb9\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_juggling_tone1:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_juggling_tone2:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_juggling_tone3:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_juggling_tone4:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_juggling_tone5:'=>"\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_lifting_weights:'=>"\xf0\x9f\x8f\x8b\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_lifting_weights_tone1:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_lifting_weights_tone2:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_lifting_weights_tone3:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_lifting_weights_tone4:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_lifting_weights_tone5:'=>"\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_mage:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_mage_tone1:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_mage_tone2:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_mage_tone3:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_mage_tone4:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_mage_tone5:'=>"\xf0\x9f\xa7\x99\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_mechanic:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x94\xa7",':woman_mechanic_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x94\xa7",':woman_mechanic_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x94\xa7",':woman_mechanic_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x94\xa7",':woman_mechanic_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x94\xa7",':woman_mechanic_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x94\xa7",':woman_mountain_biking:'=>"\xf0\x9f\x9a\xb5\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_mountain_biking_tone1:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_mountain_biking_tone2:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_mountain_biking_tone3:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_mountain_biking_tone4:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_mountain_biking_tone5:'=>"\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_office_worker:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x92\xbc",':woman_office_worker_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x92\xbc",':woman_office_worker_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x92\xbc",':woman_office_worker_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x92\xbc",':woman_office_worker_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x92\xbc",':woman_office_worker_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x92\xbc",':woman_pilot:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9c\x88\xef\xb8\x8f",':woman_pilot_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x9c\x88\xef\xb8\x8f",':woman_pilot_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x9c\x88\xef\xb8\x8f",':woman_pilot_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x9c\x88\xef\xb8\x8f",':woman_pilot_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x9c\x88\xef\xb8\x8f",':woman_pilot_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x9c\x88\xef\xb8\x8f",':woman_playing_handball:'=>"\xf0\x9f\xa4\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_playing_handball_tone1:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_playing_handball_tone2:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_playing_handball_tone3:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_playing_handball_tone4:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_playing_handball_tone5:'=>"\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_playing_water_polo:'=>"\xf0\x9f\xa4\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_playing_water_polo_tone1:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_playing_water_polo_tone2:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_playing_water_polo_tone3:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_playing_water_polo_tone4:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_playing_water_polo_tone5:'=>"\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_police_officer:'=>"\xf0\x9f\x91\xae\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_police_officer_tone1:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_police_officer_tone2:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_police_officer_tone3:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_police_officer_tone4:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_police_officer_tone5:'=>"\xf0\x9f\x91\xae\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_pouting:'=>"\xf0\x9f\x99\x8e\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_pouting_tone1:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_pouting_tone2:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_pouting_tone3:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_pouting_tone4:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_pouting_tone5:'=>"\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_raising_hand:'=>"\xf0\x9f\x99\x8b\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_raising_hand_tone1:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_raising_hand_tone2:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_raising_hand_tone3:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_raising_hand_tone4:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_raising_hand_tone5:'=>"\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_rowing_boat:'=>"\xf0\x9f\x9a\xa3\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_rowing_boat_tone1:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_rowing_boat_tone2:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_rowing_boat_tone3:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_rowing_boat_tone4:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_rowing_boat_tone5:'=>"\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_running:'=>"\xf0\x9f\x8f\x83\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_running_tone1:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_running_tone2:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_running_tone3:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_running_tone4:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_running_tone5:'=>"\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_scientist:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x94\xac",':woman_scientist_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x94\xac",':woman_scientist_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x94\xac",':woman_scientist_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x94\xac",':woman_scientist_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x94\xac",':woman_scientist_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x94\xac",':woman_shrugging:'=>"\xf0\x9f\xa4\xb7\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_shrugging_tone1:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_shrugging_tone2:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_shrugging_tone3:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_shrugging_tone4:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_shrugging_tone5:'=>"\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_singer:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8e\xa4",':woman_singer_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\xa4",':woman_singer_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\xa4",':woman_singer_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\xa4",':woman_singer_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\xa4",':woman_singer_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\xa4",':woman_student:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8e\x93",':woman_student_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8e\x93",':woman_student_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8e\x93",':woman_student_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8e\x93",':woman_student_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8e\x93",':woman_student_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8e\x93",':woman_surfing:'=>"\xf0\x9f\x8f\x84\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_surfing_tone1:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_surfing_tone2:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_surfing_tone3:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_surfing_tone4:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_surfing_tone5:'=>"\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_swimming:'=>"\xf0\x9f\x8f\x8a\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_swimming_tone1:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_swimming_tone2:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_swimming_tone3:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_swimming_tone4:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_swimming_tone5:'=>"\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_teacher:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8f\xab",':woman_teacher_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x8f\xab",':woman_teacher_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x8f\xab",':woman_teacher_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x8f\xab",':woman_teacher_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x8f\xab",':woman_teacher_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x8f\xab",':woman_technologist:'=>"\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x92\xbb",':woman_technologist_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb\xe2\x80\x8d\xf0\x9f\x92\xbb",':woman_technologist_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc\xe2\x80\x8d\xf0\x9f\x92\xbb",':woman_technologist_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd\xe2\x80\x8d\xf0\x9f\x92\xbb",':woman_technologist_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe\xe2\x80\x8d\xf0\x9f\x92\xbb",':woman_technologist_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf\xe2\x80\x8d\xf0\x9f\x92\xbb",':woman_tipping_hand:'=>"\xf0\x9f\x92\x81\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_tipping_hand_tone1:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_tipping_hand_tone2:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_tipping_hand_tone3:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_tipping_hand_tone4:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_tipping_hand_tone5:'=>"\xf0\x9f\x92\x81\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_tone1:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb",':woman_tone2:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc",':woman_tone3:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd",':woman_tone4:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe",':woman_tone5:'=>"\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf",':woman_vampire:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_vampire_tone1:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_vampire_tone2:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_vampire_tone3:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_vampire_tone4:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_vampire_tone5:'=>"\xf0\x9f\xa7\x9b\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_walking:'=>"\xf0\x9f\x9a\xb6\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_walking_tone1:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_walking_tone2:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_walking_tone3:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_walking_tone4:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_walking_tone5:'=>"\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_wearing_turban:'=>"\xf0\x9f\x91\xb3\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_wearing_turban_tone1:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbb\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_wearing_turban_tone2:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_wearing_turban_tone3:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_wearing_turban_tone4:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_wearing_turban_tone5:'=>"\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_with_headscarf:'=>"\xf0\x9f\xa7\x95\xf0\x9f\x8f\xbf",':woman_with_headscarf_tone1:'=>"\xf0\x9f\xa7\x95\xf0\x9f\x8f\xbb",':woman_with_headscarf_tone2:'=>"\xf0\x9f\xa7\x95\xf0\x9f\x8f\xbc",':woman_with_headscarf_tone3:'=>"\xf0\x9f\xa7\x95\xf0\x9f\x8f\xbd",':woman_with_headscarf_tone4:'=>"\xf0\x9f\xa7\x95\xf0\x9f\x8f\xbe",':woman_with_headscarf_tone5:'=>"\xf0\x9f\xa7\x95\xf0\x9f\x8f\xbf",':woman_with_turban:'=>"\xf0\x9f\x91\xb3\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':woman_zombie:'=>"\xf0\x9f\xa7\x9f\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':womans_clothes:'=>"\xf0\x9f\x91\x9a",':womans_hat:'=>"\xf0\x9f\x91\x92",':women_with_bunny_ears_partying:'=>"\xf0\x9f\x91\xaf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':women_wrestling:'=>"\xf0\x9f\xa4\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f",':womens:'=>"\xf0\x9f\x9a\xba",':world_map:'=>"\xf0\x9f\x97\xba",':worried:'=>"\xf0\x9f\x98\x9f",':wrench:'=>"\xf0\x9f\x94\xa7",':writing_hand:'=>"\xe2\x9c\x8d\xef\xb8\x8f",':writing_hand_tone1:'=>"\xe2\x9c\x8d\xf0\x9f\x8f\xbb",':writing_hand_tone2:'=>"\xe2\x9c\x8d\xf0\x9f\x8f\xbc",':writing_hand_tone3:'=>"\xe2\x9c\x8d\xf0\x9f\x8f\xbd",':writing_hand_tone4:'=>"\xe2\x9c\x8d\xf0\x9f\x8f\xbe",':writing_hand_tone5:'=>"\xe2\x9c\x8d\xf0\x9f\x8f\xbf",':x:'=>"\xe2\x9d\x8c",':yellow_heart:'=>"\xf0\x9f\x92\x9b",':yemen:'=>"\xf0\x9f\x87\xbe\xf0\x9f\x87\xaa",':yen:'=>"\xf0\x9f\x92\xb4",':yin_yang:'=>"\xe2\x98\xaf\xef\xb8\x8f",':yum:'=>"\xf0\x9f\x98\x8b",':zambia:'=>"\xf0\x9f\x87\xbf\xf0\x9f\x87\xb2",':zap:'=>"\xe2\x9a\xa1\xef\xb8\x8f",':zebra:'=>"\xf0\x9f\xa6\x93",':zero:'=>"0\xe2\x83\xa3",':zimbabwe:'=>"\xf0\x9f\x87\xbf\xf0\x9f\x87\xbc",':zipper_mouth:'=>"\xf0\x9f\xa4\x90",':zipper_mouth_face:'=>"\xf0\x9f\xa4\x90",':zombie:'=>"\xf0\x9f\xa7\x9f",':zzz:'=>"\xf0\x9f\x92\xa4",':100:'=>"\xf0\x9f\x92\xaf",':1234:'=>"\xf0\x9f\x94\xa2"];
	protected $tagName = 'EMOJI';
	protected function setUp()
	{
		if (isset($this->configurator->tags[$this->tagName]))
			return;
		$tag = $this->configurator->tags->add($this->tagName);
		foreach ([$this->attrName, 'tseq'] as $attrName)
			$tag->attributes->add($attrName)->filterChain->append(
				$this->configurator->attributeFilters['#identifier']
			);
		$tag->template = '<img alt="{.}" class="emoji" draggable="false" src="//cdn.jsdelivr.net/emojione/assets/4.5/png/64/{@seq}.png"/>';
	}
	public function addAlias($alias, $emoji)
	{
		$this->aliases[$alias] = $emoji;
	}
	public function removeAlias($alias)
	{
		unset($this->aliases[$alias]);
	}
	public function getAliases()
	{
		return $this->aliases;
	}
	public function asConfig()
	{
		$config  = ['attrName' => $this->attrName, 'tagName'  => $this->tagName];
		$config += $this->getAliasesConfig();
		return $config;
	}
	public function finalize()
	{
		$this->configurator->registeredVars['Emoji.aliases'] = new Dictionary($this->aliases);
	}
	public function getJSHints()
	{
		$custom     = $this->getCustomAliases();
		$quickMatch = ConfigHelper::generateQuickMatchFromList($custom);
		return [
			'EMOJI_HAS_CUSTOM_QUICKMATCH' => ($quickMatch !== \false),
			'EMOJI_HAS_CUSTOM_REGEXP'     => !empty($custom)
		];
	}
	protected function getAliasesConfig()
	{
		$config = [];
		$custom = $this->getCustomAliases();
		if (!empty($custom))
		{
			$regexp                 = '/' . RegexpBuilder::fromList($custom) . '/';
			$config['customRegexp'] = new Regexp($regexp, \true);
			$quickMatch = ConfigHelper::generateQuickMatchFromList($custom);
			if ($quickMatch !== \false)
				$config['customQuickMatch'] = $quickMatch;
		}
		return $config;
	}
	protected function getCustomAliases()
	{
		$custom = [];
		foreach ($this->aliases as $alias => $emoji)
			if (!\preg_match('(^:[-+_a-z0-9]+:$)D', $alias))
				$custom[] = $alias;
		return $custom;
	}
}