<?php

/*
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2017 The s9e Authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Plugins\MediaEmbed\Configurator\Collections;
class CachedDefinitionCollection extends SiteDefinitionCollection
{
	protected $items = [
		'abcnews'=>['example'=>'http://abcnews.go.com/WNN/video/dog-goes-wild-when-owner-leaves-22936610','extract'=>['!abcnews\\.go\\.com/(?:video/embed\\?id=|[^/]+/video/[^/]+-)(?\'id\'\\d+)!'],'homepage'=>'http://abcnews.go.com/','host'=>'abcnews.go.com','iframe'=>['src'=>'//abcnews.go.com/video/embed?id={@id}'],'name'=>'ABC News','scrape'=>[],'tags'=>['news']],
		'amazon'=>['example'=>['http://www.amazon.ca/gp/product/B00GQT1LNO/','http://www.amazon.co.jp/gp/product/B003AKZ6I8/','https://www.amazon.co.uk/dp/B00EO4NN5C/','http://www.amazon.com/dp/B002MUC0ZY','http://www.amazon.com/The-BeerBelly-200-001-80-Ounce-Belly/dp/B001RB2CXY/','https://www.amazon.com/gp/product/B00ST0KGCU/','http://www.amazon.de/Netgear-WN3100RP-100PES-Repeater-integrierte-Steckdose/dp/B00ET2LTE6/','https://www.amazon.es/Microsoft-Sculpt-Ergonomic-Desktop-L5V-00011/dp/B00FO10ZK0/','http://www.amazon.fr/Vans-Authentic-Baskets-mixte-adulte/dp/B005NIKPAY/','http://www.amazon.in/Vans-Unisex-Authentic-Midnight-Sneakers/dp/B01I3LNWQG/','https://www.amazon.it/Super-Maxi-Pot-de-Nutella/dp/B0090GJ8VM/','https://www.amazon.com/dp/B0018CDWLS/'],'extract'=>['#/(?:dp|gp/product)/(?\'id\'[A-Z0-9]+)#','#amazon\\.(?:co\\.)?(?\'tld\'ca|de|es|fr|in|it|jp|uk)#'],'homepage'=>'http://affiliate-program.amazon.com/','host'=>['amazon.ca','amazon.co.uk','amazon.co.jp','amazon.com','amazon.de','amazon.es','amazon.fr','amazon.in','amazon.it'],'iframe'=>['height'=>240,'src'=>'//<xsl:choose><xsl:when test="@tld=\'es\'or@tld=\'it\'">rcm-eu.amazon-adsystem.com/e/cm?lt1=_blank&amp;bc1=FFFFFF&amp;bg1=FFFFFF&amp;fc1=000000&amp;lc1=0000FF&amp;p=8&amp;l=as1&amp;f=ifr&amp;asins=<xsl:value-of select="@id"/>&amp;o=<xsl:choose><xsl:when test="@tld=\'es\'">30</xsl:when><xsl:otherwise>29</xsl:otherwise></xsl:choose>&amp;t=<xsl:choose><xsl:when test="@tld=\'es\'and$AMAZON_ASSOCIATE_TAG_ES"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_ES"/></xsl:when><xsl:when test="@tld=\'it\'and$AMAZON_ASSOCIATE_TAG_IT"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_IT"/></xsl:when><xsl:otherwise>_</xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise>ws-<xsl:choose><xsl:when test="@tld=\'in\'">in</xsl:when><xsl:when test="@tld=\'jp\'">fe</xsl:when><xsl:when test="@tld and contains(\'desfrituk\',@tld)">eu</xsl:when><xsl:otherwise>na</xsl:otherwise></xsl:choose>.amazon-adsystem.com/widgets/q?ServiceVersion=20070822&amp;OneJS=1&amp;Operation=GetAdHtml&amp;MarketPlace=<xsl:choose><xsl:when test="@tld"><xsl:value-of select="translate(@tld,\'acdefijknprstu\',\'ACDEFIJBNPRSTG\')"/></xsl:when><xsl:otherwise>US</xsl:otherwise></xsl:choose>&amp;ad_type=product_link&amp;tracking_id=<xsl:choose><xsl:when test="@tld=\'ca\'"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_CA"/></xsl:when><xsl:when test="@tld=\'de\'"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_DE"/></xsl:when><xsl:when test="@tld=\'fr\'"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_FR"/></xsl:when><xsl:when test="@tld=\'in\'"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_IN"/></xsl:when><xsl:when test="@tld=\'jp\'"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_JP"/></xsl:when><xsl:when test="@tld=\'uk\'"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_UK"/></xsl:when><xsl:when test="$AMAZON_ASSOCIATE_TAG"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG"/></xsl:when><xsl:otherwise>-20</xsl:otherwise></xsl:choose>&amp;marketplace=amazon&amp;region=<xsl:choose><xsl:when test="@tld"><xsl:value-of select="translate(@tld,\'acdefijknprstu\',\'ACDEFIJBNPRSTG\')"/></xsl:when><xsl:otherwise>US</xsl:otherwise></xsl:choose>&amp;asins=<xsl:value-of select="@id"/>&amp;show_border=true&amp;link_opens_in_new_window=true</xsl:otherwise></xsl:choose>','width'=>120],'name'=>'Amazon Product','parameters'=>['AMAZON_ASSOCIATE_TAG'=>['title'=>'Amazon Associate tag (.com)'],'AMAZON_ASSOCIATE_TAG_CA'=>['title'=>'Amazon Associate tag (.ca)'],'AMAZON_ASSOCIATE_TAG_DE'=>['title'=>'Amazon Associate tag (.de)'],'AMAZON_ASSOCIATE_TAG_ES'=>['title'=>'Amazon Associate tag (.es)'],'AMAZON_ASSOCIATE_TAG_FR'=>['title'=>'Amazon Associate tag (.fr)'],'AMAZON_ASSOCIATE_TAG_IN'=>['title'=>'Amazon Associate tag (.in)'],'AMAZON_ASSOCIATE_TAG_IT'=>['title'=>'Amazon Associate tag (.it)'],'AMAZON_ASSOCIATE_TAG_JP'=>['title'=>'Amazon Associate tag (.co.jp)'],'AMAZON_ASSOCIATE_TAG_UK'=>['title'=>'Amazon Associate tag (.co.uk)']],'scrape'=>[]],
		'audioboom'=>['example'=>['http://audioboo.fm/boos/2439994-deadline-day-update','http://audioboom.com/posts/2493448-robert-patrick'],'extract'=>['!audioboo(?:\\.f|m\\.co)m/(?:boo|post)s/(?\'id\'\\d+)!'],'homepage'=>'https://audioboom.com/','host'=>['audioboo.fm','audioboom.com'],'iframe'=>['height'=>150,'max-width'=>700,'src'=>'//audioboom.com/posts/{@id}/embed/v3','width'=>'100%'],'name'=>'audioBoom','scrape'=>[],'tags'=>['podcasts']],
		'audiomack'=>['choose'=>['otherwise'=>['iframe'=>['height'=>252,'max-width'=>900,'src'=>'https://www.audiomack.com/embed/song/{@id}','width'=>'100%']],'when'=>['iframe'=>['height'=>400,'max-width'=>900,'src'=>'https://www.audiomack.com/embed/album/{@id}','width'=>'100%'],'test'=>'@mode=\'album\'']],'example'=>['http://www.audiomack.com/song/your-music-fix/jammin-kungs-remix-1','http://www.audiomack.com/album/chance-the-rapper/acid-rap'],'extract'=>['!audiomack\\.com/(?\'mode\'album|song)/(?\'id\'[-\\w]+/[-\\w]+)!'],'homepage'=>'http://www.audiomack.com/','host'=>'audiomack.com','name'=>'Audiomack','scrape'=>[],'tags'=>['music']],
		'bandcamp'=>['example'=>['http://proleter.bandcamp.com/album/curses-from-past-times-ep','http://proleter.bandcamp.com/track/downtown-irony','http://therunons.bandcamp.com/track/still-feel'],'extract'=>[],'homepage'=>'http://bandcamp.com/','host'=>'bandcamp.com','iframe'=>['height'=>400,'src'=>'//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/<xsl:choose><xsl:when test="@album_id">album=<xsl:value-of select="@album_id"/><xsl:if test="@track_num">/t=<xsl:value-of select="@track_num"/></xsl:if></xsl:when><xsl:otherwise>track=<xsl:value-of select="@track_id"/></xsl:otherwise></xsl:choose>','width'=>400],'name'=>'Bandcamp','scrape'=>[['extract'=>['!/album=(?\'album_id\'\\d+)!'],'match'=>['!bandcamp\\.com/album/.!']],['extract'=>['!"album_id":(?\'album_id\'\\d+)!','!"track_num":(?\'track_num\'\\d+)!','!/track=(?\'track_id\'\\d+)!'],'match'=>['!bandcamp\\.com/track/.!']]],'tags'=>['music']],
		'bbcnews'=>['attributes'=>['id'=>['postFilter'=>'stripslashes']],'example'=>'http://www.bbc.com/news/science-environment-37854744','extract'=>[],'homepage'=>'http://www.bbc.com/news/video_and_audio/','host'=>'bbc.com','iframe'=>['src'=>'//www.bbc.com<xsl:choose><xsl:when test="starts-with(@playlist,\'/news/\')and contains(@playlist,\'A\')"><xsl:value-of select="substring-before(@playlist,\'A\')"/></xsl:when><xsl:otherwise>/news/<xsl:value-of select="@id"/></xsl:otherwise></xsl:choose>/embed'],'name'=>'BBC News','scrape'=>[['extract'=>['!bbc\\.com\\\\/news\\\\/(?\'id\'[-\\\\\\w/]+)\\\\/embed!'],'match'=>['!bbc\\.com/news/\\w!']]],'tags'=>['news']],
		'blab'=>['example'=>'https://blab.im/05b6ce88279f40798069bb6227a04fce','extract'=>['#blab\\.im/(?!about$|live$|replay$|scheduled$|search\\?)(?\'id\'[-\\w]+)#'],'homepage'=>'https://blab.im/','host'=>'blab.im','iframe'=>['height'=>400,'src'=>'https://blab.im/{@id}','width'=>400],'name'=>'Blab','scrape'=>[],'tags'=>['social']],
		'bleacherreport'=>['example'=>'http://bleacherreport.com/articles/2418813-steph-curry-salsas-after-teammate-leandro-barbosa-converts-difficult-layup','extract'=>[],'homepage'=>'http://bleacherreport.com/','host'=>'bleacherreport.com','iframe'=>['src'=>'//bleacherreport.com/video_embed?id={@id}'],'name'=>'Bleacher Report videos','scrape'=>[['extract'=>['!id="video-(?\'id\'[-\\w]+)!'],'match'=>['!/articles/.!']]],'tags'=>['sports']],
		'break'=>['example'=>'http://www.break.com/video/video-game-playing-frog-wants-more-2278131','extract'=>['!break\\.com/video/.*-(?\'id\'\\d+)$!'],'homepage'=>'http://www.break.com/','host'=>'break.com','iframe'=>['height'=>280,'src'=>'//break.com/embed/{@id}','width'=>464],'name'=>'Break','scrape'=>[],'tags'=>['entertainment']],
		'brightcove'=>['example'=>['http://link.brightcove.com/services/player/bcpid34762914001?bctid=66379363001','http://link.brightcove.com/services/player/bcpid3936710530001?bckey=AQ~~,AAAA3LlbZiE~,0uzoN5xJpHsvpxPw-K2_CalW5-PE-Ti2&bctid=4669818674001','http://bcove.me/rpuseykd'],'extract'=>[],'homepage'=>'https://www.brightcove.com/','host'=>['bcove.me','link.brightcove.com'],'iframe'=>['src'=>'https://link.brightcove.com/services/player/bcpid{@bcpid}?bckey={@bckey}&bctid={@bctid}&secureConnections=true&secureHTMLConnections=true&autoStart=false&height=100%25&width=100%25'],'name'=>'Brightcove','scrape'=>[['extract'=>['!meta name="twitter:player" content=".*?bcpid(?\'bcpid\'\\d+).*?bckey=(?\'bckey\'[-,~\\w]+).*?bctid=(?\'bctid\'\\d+)!'],'match'=>['!bcove\\.me/.!','!link\\.brightcove\\.com/services/player/!']]],'tags'=>['videos']],
		'cbsnews'=>['attributes'=>['id'=>['required'=>\false]],'choose'=>['otherwise'=>['flash'=>['flashvars'=>'si=254&contentValue={@id}','padding-height'=>40,'src'=>'//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf']],'when'=>['flash'=>['flashvars'=>'pType=embed&si=254&pid={@pid}','padding-height'=>38,'src'=>'//www.cbsnews.com/common/video/cbsnews_player.swf'],'test'=>'@pid']],'example'=>['http://www.cbsnews.com/video/watch/?id=50156501n','http://www.cbsnews.com/videos/is-the-us-stock-market-rigged'],'extract'=>['#cbsnews\\.com/video/watch/\\?id=(?\'id\'\\d+)#'],'homepage'=>'http://www.cbsnews.com/video/','host'=>'cbsnews.com','name'=>'CBS News Video','scrape'=>[['extract'=>['#"pid":"(?\'pid\'\\w+)"#'],'match'=>['#cbsnews\\.com/videos/(?!watch/)#']]],'tags'=>['news']],
		'cnbc'=>['example'=>'http://video.cnbc.com/gallery/?video=3000269279','extract'=>['!cnbc\\.com/gallery/\\?video=(?\'id\'\\d+)!'],'flash'=>['height'=>380,'src'=>'//plus.cnbc.com/rssvideosearch/action/player/id/{@id}/code/cnbcplayershare','width'=>400],'homepage'=>'http://www.cnbc.com/','host'=>'video.cnbc.com','name'=>'CNBC','scrape'=>[],'tags'=>['news']],
		'cnn'=>['example'=>['http://edition.cnn.com/videos/tv/2015/06/09/airplane-yoga-rachel-crane-ts-orig.cnn','http://us.cnn.com/video/data/2.0/video/bestoftv/2013/10/23/vo-nr-prince-george-christening-arrival.cnn.html'],'extract'=>['!cnn.com/videos/(?\'id\'.*\\.cnn)!','!cnn\\.com/video/data/2\\.0/video/(?\'id\'.*\\.cnn)!'],'homepage'=>'http://edition.cnn.com/video/','host'=>'cnn.com','iframe'=>['src'=>'//edition.cnn.com/video/api/embed.html#/video/{@id}'],'name'=>'CNN','scrape'=>[],'tags'=>['news']],
		'cnnmoney'=>['example'=>'http://money.cnn.com/video/technology/2014/05/20/t-twitch-vp-on-future.cnnmoney/','extract'=>['!money\\.cnn\\.com/video/(?\'id\'.*\\.cnnmoney)!'],'homepage'=>'http://money.cnn.com/video/','host'=>'money.cnn.com','iframe'=>['height'=>360,'src'=>'//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/{@id}&width=560&height=360','width'=>560],'name'=>'CNNMoney','scrape'=>[],'tags'=>['news']],
		'collegehumor'=>['example'=>'http://www.collegehumor.com/video/1181601/more-than-friends','extract'=>['!collegehumor\\.com/(?:video|embed)/(?\'id\'\\d+)!'],'homepage'=>'http://www.collegehumor.com/','host'=>'collegehumor.com','iframe'=>['height'=>369,'src'=>'//www.collegehumor.com/e/{@id}','width'=>600],'name'=>'CollegeHumor','scrape'=>[],'tags'=>['entertainment']],
		'comedycentral'=>['example'=>['http://www.cc.com/video-clips/uu5qz4/key-and-peele-dueling-hats','http://www.comedycentral.com/video-clips/uu5qz4/key-and-peele-dueling-hats','http://tosh.cc.com/video-clips/aet4lh/rc-car-crash'],'extract'=>[],'homepage'=>'http://www.comedycentral.com/funny-videos','host'=>['cc.com','comedycentral.com'],'iframe'=>['src'=>'//media.mtvnservices.com/embed/{@id}'],'name'=>'Comedy Central','scrape'=>[['extract'=>['!(?\'id\'mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)!'],'match'=>['!c(?:c|omedycentral)\\.com/(?:full-episode|video-clip)s/!']]],'tags'=>['entertainment']],
		'coub'=>['example'=>'http://coub.com/view/6veusoty','extract'=>['!coub\\.com/view/(?\'id\'\\w+)!'],'homepage'=>'http://coub.com/','host'=>'coub.com','iframe'=>['src'=>'//coub.com/embed/{@id}'],'name'=>'Coub','scrape'=>[],'tags'=>['videos']],
		'dailymotion'=>['example'=>['http://www.dailymotion.com/video/x222z1','http://www.dailymotion.com/user/Dailymotion/2#video=x222z1','http://games.dailymotion.com/live/x15gjhi'],'extract'=>['!dailymotion\\.com/(?:live/|swf/|user/[^#]+#video=|(?:related/\\d+/)?video/)(?\'id\'[A-Za-z0-9]+)!'],'homepage'=>'http://www.dailymotion.com/','host'=>'dailymotion.com','iframe'=>['src'=>'//www.dailymotion.com/embed/video/{@id}'],'name'=>'Dailymotion','oembed'=>['url'=>'http://www.dailymotion.com/services/oembed'],'scrape'=>[],'source'=>'http://www.dailymotion.com/doc/api/player.html','tags'=>['videos']],
		'democracynow'=>['example'=>['http://www.democracynow.org/2014/7/2/dn_at_almedalen_week_at_swedens','http://www.democracynow.org/blog/2015/3/13/part_2_bruce_schneier_on_the','http://www.democracynow.org/shows/2006/2/20','http://www.democracynow.org/2015/5/21/headlines','http://m.democracynow.org/stories/15236'],'extract'=>['!democracynow.org/(?:embed/)?(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)!'],'homepage'=>'http://www.democracynow.org/','host'=>'democracynow.org','iframe'=>['src'=>'//www.democracynow.org/embed/<xsl:choose><xsl:when test="contains(@id,\'/headlines\')">headlines/<xsl:value-of select="substring-before(@id,\'/headlines\')"/></xsl:when><xsl:when test="starts-with(@id,\'2\')">story/<xsl:value-of select="@id"/></xsl:when><xsl:when test="starts-with(@id,\'shows/\')">show/<xsl:value-of select="substring-after(@id,\'/\')"/></xsl:when><xsl:otherwise><xsl:value-of select="@id"/></xsl:otherwise></xsl:choose>'],'name'=>'Democracy Now!','scrape'=>[['extract'=>['!democracynow\\.org/(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)\' rel=\'canonical!'],'match'=>['!m\\.democracynow\\.org/stories/\\d!']]]],
		'dumpert'=>['example'=>'http://www.dumpert.nl/mediabase/6622577/4652b140/r_mi_gaillard_doet_halloween_prank.html','extract'=>['!dumpert\\.nl/mediabase/(?\'id\'\\d+[/_]\\w+)!'],'homepage'=>'http://www.dumpert.nl/','host'=>'dumpert.nl','iframe'=>['src'=>'//www.dumpert.nl/embed/{translate(@id,\'_\',\'/\')}/'],'name'=>'dumpert','scrape'=>[],'tags'=>['.nl','entertainment']],
		'eighttracks'=>['example'=>['http://8tracks.com/lovinq/headphones-in-world-out','http://8tracks.com/lovinq/4982023'],'extract'=>['!8tracks\\.com/[-\\w]+/(?\'id\'\\d+)(?=#|$)!'],'homepage'=>'http://8tracks.com/','host'=>'8tracks.com','iframe'=>['height'=>400,'src'=>'//8tracks.com/mixes/{@id}/player_v3_universal','width'=>400],'name'=>'8tracks','scrape'=>[['extract'=>['!eighttracks://mix/(?\'id\'\\d+)!'],'match'=>['!8tracks\\.com/[-\\w]+/[-\\w]+!']]],'tags'=>['music']],
		'espn'=>['example'=>['http://www.espn.com/video/clip?id=17474659','http://www.espn.com/espnw/video/13887284/kyrgios-angry-code-violation-almost-hitting-ref','http://broadband.espn.go.com/video/clip?id=17481969'],'extract'=>['#video/(?:clip(?:\\?id=|/_/id/))?(?\'id\'\\d+)#'],'homepage'=>'http://www.espn.com/','host'=>['espn.com','espn.go.com'],'iframe'=>['src'=>'//www.espn.com/core/video/iframe?id={@id}'],'name'=>'ESPN','scrape'=>[],'tags'=>['sports']],
		'facebook'=>['example'=>['https://www.facebook.com/FacebookDevelopers/posts/10151471074398553','https://www.facebook.com/video/video.php?v=10150451523596807','https://www.facebook.com/photo.php?fbid=10152476416772631','https://www.facebook.com/ign/videos/10153762113196633/','https://www.facebook.com/southamptonfc/videos/vb.220396037973624/1357764664236750/'],'extract'=>['@/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com/(?:[/\\w]+/permalink|(?!pages/|groups/).*?)(?:/|fbid=|\\?v=)(?\'id\'\\d+)(?=$|[/?&#])@','#/(?\'type\'video)s?/#'],'homepage'=>'http://www.facebook.com/','host'=>'facebook.com','iframe'=>['data-s9e-livepreview-ignore-attrs'=>'style','onload'=>'var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')','src'=>'https://s9e.github.io/iframe/facebook.min.html#{@type}{@id}'],'name'=>'Facebook','scrape'=>[],'tags'=>['social']],
		'flickr'=>['example'=>'https://www.flickr.com/photos/8757881@N04/2971804544/lightbox/','extract'=>['!flickr\\.com/photos/[^/]+/(?\'id\'\\d+)!'],'homepage'=>'https://www.flickr.com/','host'=>'flickr.com','iframe'=>['height'=>500,'src'=>'https://www.flickr.com/photos/_/{@id}/player/','width'=>500],'name'=>'Flickr','scrape'=>[],'tags'=>['images']],
		'foratv'=>['example'=>'http://fora.tv/2014/09/30/How_Google_Works','extract'=>[],'homepage'=>'http://fora.tv/','host'=>'fora.tv','iframe'=>['src'=>'//library.fora.tv/embed?id={@id}&type=c'],'name'=>'FORA.tv','scrape'=>[['extract'=>['!embed\\?id=(?\'id\'\\d+)!'],'match'=>['!fora\\.tv/\\d+/\\d+/\\d+/.!']]]],
		'foxnews'=>['example'=>'http://video.foxnews.com/v/3592758613001/reddit-helps-fund-homemade-hot-sauce-venture/','extract'=>['!video\\.foxnews\\.com/v/(?\'id\'\\d+)!'],'homepage'=>'http://www.foxnews.com/','host'=>'video.foxnews.com','iframe'=>['src'=>'//video.foxnews.com/v/video-embed.html?video_id={@id}'],'name'=>'Fox News','scrape'=>[],'tags'=>['news']],
		'funnyordie'=>['example'=>'http://www.funnyordie.com/videos/bf313bd8b4/murdock-with-keith-david','extract'=>['!funnyordie\\.com/videos/(?\'id\'[0-9a-f]+)!'],'homepage'=>'http://www.funnyordie.com/','host'=>'funnyordie.com','iframe'=>['src'=>'//www.funnyordie.com/embed/{@id}'],'name'=>'Funny or Die','scrape'=>[],'source'=>'http://support.funnyordie.com/discussions/problems/918-embed-user-videos-widget','tags'=>['entertainment']],
		'gamespot'=>['example'=>['http://www.gamespot.com/destiny/videos/destiny-the-moon-trailer-6415176/','http://www.gamespot.com/events/game-crib-tsm-snapdragon/gamecrib-extras-cooking-with-dan-dinh-6412922/','http://www.gamespot.com/videos/beat-the-pros-pax-prime-2013/2300-6414307/'],'extract'=>['!gamespot\\.com.*?/(?:events|videos)/.*?-(?\'id\'\\d+)/(?:[#?].*)?$!'],'homepage'=>'http://www.gamespot.com/','host'=>'gamespot.com','iframe'=>['height'=>400,'src'=>'//www.gamespot.com/videos/embed/{@id}/','width'=>640],'name'=>'Gamespot','scrape'=>[],'tags'=>['gaming']],
		'gametrailers'=>['example'=>'http://www.gametrailers.com/videos/view/pop-fiction/102300-Metal-Gear-Solid-3-Still-in-a-Dream','extract'=>[],'homepage'=>'http://www.gametrailers.com/','host'=>'gametrailers.com','iframe'=>['src'=>'//<xsl:choose><xsl:when test="starts-with(@id,\'mgid:\')">media.mtvnservices.com/embed/<xsl:value-of select="@id"/></xsl:when><xsl:otherwise>embed.gametrailers.com/embed/<xsl:value-of select="@id"/>?embed=1&amp;suppressBumper=1</xsl:otherwise></xsl:choose>'],'name'=>'GameTrailers','scrape'=>[['extract'=>['!embed/(?\'id\'\\d+)!'],'match'=>['!gametrailers\\.com/(?:full-episode|review|video)s/!']]],'tags'=>['gaming']],
		'getty'=>['attributes'=>['height'=>['defaultValue'=>360],'width'=>['defaultValue'=>640]],'example'=>['http://gty.im/3232182','http://www.gettyimages.com/detail/3232182','http://www.gettyimages.com/detail/news-photo/the-beatles-travel-by-coach-to-the-west-country-for-some-news-photo/3232182','http://www.gettyimages.co.uk/detail/3232182'],'extract'=>['!gty\\.im/(?\'id\'\\d+)!','!gettyimages\\.[.\\w]+/detail(?=/).*?/(?\'id\'\\d+)!','!#[-\\w]*picture-id(?\'id\'\\d+)$!'],'homepage'=>'http://www.gettyimages.com/','host'=>['gettyimages.be','gettyimages.cn','gettyimages.co.jp','gettyimages.co.uk','gettyimages.com','gettyimages.com.au','gettyimages.de','gettyimages.dk','gettyimages.es','gettyimages.fr','gettyimages.ie','gettyimages.it','gettyimages.nl','gettyimages.pt','gettyimages.se','gty.im'],'iframe'=>['height'=>'{@height}','padding-height'=>49,'src'=>'//embed.gettyimages.com/embed/{@id}?et={@et}&sig={@sig}','width'=>'{@width}'],'name'=>'Getty Images','scrape'=>[['extract'=>['!"height":[ "]*(?\'height\'\\d+)!','!"width":[ "]*(?\'width\'\\d+)!','!\\bid[=:][\'"]?(?\'et\'[-=\\w]+)!','!\\bsig[=:][\'"]?(?\'sig\'[-=\\w]+)!'],'match'=>['//'],'url'=>'http://embed.gettyimages.com/preview/{@id}']],'tags'=>['images']],
		'gfycat'=>['attributes'=>['height'=>['defaultValue'=>360],'width'=>['defaultValue'=>640]],'example'=>['http://gfycat.com/SereneIllfatedCapybara','http://giant.gfycat.com/SereneIllfatedCapybara.gif'],'extract'=>['!gfycat\\.com/(?:gifs/detail/)?(?\'id\'\\w+)!'],'homepage'=>'http://gfycat.com/','host'=>'gfycat.com','iframe'=>['height'=>'{@height}','src'=>'//gfycat.com/iframe/{@id}','width'=>'{@width}'],'name'=>'Gfycat','scrape'=>[['extract'=>['!<meta name="twitter:player:height" content="(?\'height\'\\d+)!','!video:height" content="(?\'height\'\\d+)!','!<meta name="twitter:player:width" content="(?\'width\'\\d+)!','!video:width" content="(?\'width\'\\d+)!'],'match'=>['//'],'url'=>'http://gfycat.com/iframe/{@id}']],'tags'=>['images']],
		'gifs'=>['attributes'=>['height'=>['defaultValue'=>360],'width'=>['defaultValue'=>640]],'example'=>['https://gifs.com/gif/zm4DLy','https://j.gifs.com/Y6YZoO.gif'],'extract'=>['!gifs\\.com/(?:gif/)?(?\'id\'\\w+)!'],'homepage'=>'https://gifs.com/','host'=>'gifs.com','iframe'=>['height'=>'{@height}','src'=>'//gifs.com/embed/{@id}','width'=>'{@width}'],'name'=>'Gifs.com','scrape'=>[['extract'=>['!meta property="og:image:width" content="(?\'width\'\\d+)!','!meta property="og:image:height" content="(?\'height\'\\d+)!'],'match'=>['//'],'url'=>'https://gifs.com/gif/{@id}']],'tags'=>['images']],
		'gist'=>['example'=>['https://gist.github.com/s9e/0ee8433f5a9a779d08ef','https://gist.github.com/6806305','https://gist.github.com/s9e/6806305/ad88d904b082c8211afa040162402015aacb8599'],'extract'=>['!gist\\.github\\.com/(?\'id\'(?:\\w+/)?[\\da-f]+(?:/[\\da-f]+)?)!'],'homepage'=>'https://gist.github.com/','host'=>'github.com','iframe'=>['data-s9e-livepreview-ignore-attrs'=>'style','height'=>180,'onload'=>'var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')','scrolling'=>'','src'=>'https://s9e.github.io/iframe/gist.min.html#{@id}','width'=>'100%'],'name'=>'GitHub Gist (via custom iframe)','scrape'=>[]],
		'globalnews'=>['example'=>'http://globalnews.ca/video/1647385/mark-channels-his-70s-look/','extract'=>['!globalnews\\.ca/video/(?\'id\'\\d+)!'],'homepage'=>'http://globalnews.ca/','host'=>'globalnews.ca','iframe'=>['height'=>377,'src'=>'//globalnews.ca/video/embed/{@id}/','width'=>560],'name'=>'Global News','scrape'=>[],'tags'=>['.ca','news']],
		'gofundme'=>['example'=>'http://www.gofundme.com/2p37ao','extract'=>['@gofundme\\.com/(?\'id\'\\w+)(?![^#?])@'],'flash'=>['flashvars'=>'page={@id}','height'=>338,'src'=>'//funds.gofundme.com/Widgetflex.swf','width'=>258],'homepage'=>'http://www.gofundme.com/','host'=>'gofundme.com','name'=>'GoFundMe','scrape'=>[],'tags'=>['fundraising']],
		'googledrive'=>['example'=>'https://drive.google.com/file/d/0B_4NRUjxLBejNjVmeG5MUzA3Q3M/view?usp=sharing','extract'=>['!drive\\.google\\.com/.*?(?:file/d/|id=)(?\'id\'[-\\w]+)!'],'homepage'=>'https://drive.google.com','host'=>'drive.google.com','iframe'=>['height'=>480,'src'=>'//drive.google.com/file/d/{@id}/preview','width'=>640],'name'=>'Google Drive','scrape'=>[],'tags'=>['documents','images','videos']],
		'googleplus'=>['attributes'=>['name'=>['postFilter'=>'urldecode']],'example'=>['https://plus.google.com/+TonyHawk/posts/C5TMsDZJWBd','https://plus.google.com/106189723444098348646/posts/V8AojCoTzxV'],'extract'=>['!//plus\\.google\\.com/(?:u/\\d+/)?(?:\\+(?\'name\'[^/]+)|(?\'oid\'\\d+))/posts/(?\'pid\'\\w+)!'],'homepage'=>'https://plus.google.com/','host'=>'plus.google.com','iframe'=>['data-s9e-livepreview-ignore-attrs'=>'style','height'=>240,'onload'=>'var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')','src'=>'https://s9e.github.io/iframe/googleplus.min.html#<xsl:choose><xsl:when test="@oid"><xsl:value-of select="@oid"/></xsl:when><xsl:otherwise>+<xsl:value-of select="@name"/></xsl:otherwise></xsl:choose>/posts/<xsl:value-of select="@pid"/>','width'=>450],'name'=>'Google+','scrape'=>[],'source'=>'https://developers.google.com/+/web/embedded-post/','tags'=>['social']],
		'googlesheets'=>['example'=>'https://docs.google.com/spreadsheets/d/1f988o68HDvk335xXllJD16vxLBuRcmm3vg6U9lVaYpA','extract'=>['@docs\\.google\\.com/spreadsheet(?:/ccc\\?key=|s/d/)(?!e/)(?\'id\'[-\\w]+)[^#]*(?:#gid=(?\'gid\'\\d+))?@'],'homepage'=>'http://www.google.com/sheets/about/','host'=>'docs.google.com','iframe'=>['height'=>500,'src'=>'https://docs.google.com/spreadsheets/d/{@id}/pubhtml?widget=true&headers=false#gid={@gid}','style'=>['resize'=>'vertical'],'width'=>'100%'],'name'=>'Google Sheets','scrape'=>[],'tags'=>['documents']],
		'healthguru'=>['example'=>'http://mental.healthguru.com/video/internet-addiction-signs-you-need-to-shut-down','extract'=>[],'homepage'=>'http://www.healthguru.com/','host'=>'healthguru.com','iframe'=>['src'=>'//www.healthguru.com/embed/{@id}'],'name'=>'Healthguru','scrape'=>[['extract'=>['!healthguru\\.com/embed/(?\'id\'\\w+)!'],'match'=>['!healthguru\\.com/(?:content/)?video/.!']]],'tags'=>['health']],
		'hudl'=>['example'=>['http://www.hudl.com/athlete/2067184/highlights/163744377','http://www.hudl.com/v/CVmja','http://www.hudl.com/video/3/323679/57719969842eb243e47883f8'],'extract'=>['!hudl\\.com/athlete/(?\'athlete\'\\d+)/highlights/(?\'highlight\'[\\da-f]+)!','!hudl\\.com/video/\\d+/(?\'athlete\'\\d+)/(?\'highlight\'[\\da-f]+)!'],'homepage'=>'http://www.hudl.com/','host'=>'hudl.com','iframe'=>['src'=>'//www.hudl.com/embed/athlete/{@athlete}/highlights/{@highlight}'],'name'=>'Hudl','scrape'=>[['extract'=>['!hudl\\.com/video/\\d+/(?\'athlete\'\\d+)/(?\'highlight\'[\\da-f]+)!'],'match'=>['!hudl\\.com/v/!']]],'tags'=>['sports']],
		'hulu'=>['example'=>'http://www.hulu.com/watch/484180','extract'=>[],'homepage'=>'http://www.hulu.com/','host'=>'hulu.com','iframe'=>['src'=>'https://secure.hulu.com/embed/{@id}'],'name'=>'Hulu','scrape'=>[['extract'=>['!eid=(?\'id\'[-\\w]+)!'],'match'=>['!hulu\\.com/watch/!']]]],
		'humortvnl'=>['example'=>'http://humortv.vara.nl/pa.346135.denzel-washington-bij-graham-norton.html','extract'=>['!humortv\\.vara\\.nl/\\w+\\.(?\'id\'[-.\\w]+)\\.html!'],'homepage'=>'http://humortv.vara.nl/pg.2.pg-home.html','host'=>'humortv.vara.nl','iframe'=>['src'=>'//humortv.vara.nl/embed.{@id}.html'],'name'=>'HumorTV','scrape'=>[],'tags'=>['.nl','entertainment']],
		'ign'=>['example'=>'http://www.ign.com/videos/2013/07/12/pokemon-x-version-pokemon-y-version-battle-trailer','extract'=>['!(?\'id\'https?://.*?ign\\.com/videos/.+)!i'],'homepage'=>'http://www.ign.com/videos/','host'=>'ign.com','iframe'=>['height'=>263,'src'=>'//widgets.ign.com/video/embed/content.html?url={@id}','width'=>468],'name'=>'IGN','scrape'=>[],'tags'=>['gaming']],
		'imdb'=>['example'=>['http://www.imdb.com/video/imdb/vi2482677785/','http://www.imdb.com/title/tt2294629/videoplayer/vi2482677785'],'extract'=>['!imdb\\.com/[/\\w]+/vi(?\'id\'\\d+)!'],'homepage'=>'http://www.imdb.com/','host'=>'imdb.com','iframe'=>['src'=>'//www.imdb.com/video/imdb/vi{@id}/imdb/embed?autoplay=false&width=640'],'name'=>'IMDb','scrape'=>[],'tags'=>['movies']],
		'imgur'=>['attributes'=>['type'=>['type'=>'alnum']],'example'=>['http://imgur.com/AsQ0K3P','http://imgur.com/a/9UGCL','http://imgur.com/gallery/9UGCL','http://i.imgur.com/u7Yo0Vy.gifv','http://i.imgur.com/UO1UrIx.mp4','https://imgur.com/t/current_events/0I30l'],'extract'=>['@imgur\\.com/(?!r/|user/)(?:gallery/|t/[^/]+/)?(?\'id\'(?:a/)?\\w+)(?!\\w|\\.(?:pn|jp)g)@'],'homepage'=>'http://imgur.com/','host'=>'imgur.com','iframe'=>['data-s9e-livepreview-ignore-attrs'=>'style','height'=>450,'onload'=>'var b=Math.random();window.addEventListener(\'message\',function(a){{a.data.id==b&&(style.height=a.data.height+\'px\',style.width=a.data.width+\'px\')}});contentWindow.postMessage(\'s9e:\'+b,\'https://s9e.github.io\')','src'=>'https://s9e.github.io/iframe/imgur.min.html#<xsl:if test="@type=\'album\'and not(starts-with(@id,\'a/\'))">a/</xsl:if><xsl:value-of select="@id"/>','width'=>568],'name'=>'Imgur','scrape'=>[['extract'=>['!image\\s*:\\s*.*?"is_(?\'type\'album)":true!','!<div id="(?\'type\'album)-!','!class="(?\'type\'album)-image!'],'match'=>['@imgur\\.com/(?:gallery/|t/[^/]+/)\\w@']]],'tags'=>['images']],
		'indiegogo'=>['example'=>'http://www.indiegogo.com/projects/gameheart-redesigned','extract'=>['!indiegogo\\.com/projects/(?\'id\'[-\\w]+)!'],'homepage'=>'http://www.indiegogo.com/','host'=>'indiegogo.com','iframe'=>['height'=>445,'src'=>'//www.indiegogo.com/project/{@id}/embedded','width'=>222],'name'=>'Indiegogo','scrape'=>[],'tags'=>['fundraising']],
		'instagram'=>['example'=>'http://instagram.com/p/gbGaIXBQbn/','extract'=>['!instagram\\.com/p/(?\'id\'[-\\w]+)!'],'homepage'=>'http://instagram.com/','host'=>'instagram.com','iframe'=>['data-s9e-livepreview-ignore-attrs'=>'style','height'=>640,'onload'=>'var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')','src'=>'https://s9e.github.io/iframe/instagram.min.html#{@id}','width'=>640],'name'=>'Instagram','scrape'=>[],'source'=>'http://help.instagram.com/513918941996087','tags'=>['social']],
		'internetarchive'=>['attributes'=>['height'=>['defaultValue'=>360],'width'=>['defaultValue'=>640]],'example'=>['https://archive.org/details/BillGate99','https://archive.org/details/DFTS2014-05-30'],'extract'=>[],'homepage'=>'https://archive.org/','host'=>'archive.org','iframe'=>['height'=>'{@height}','src'=>'https://archive.org/embed/{@id}','width'=>'{@width}'],'name'=>'Internet Archive','scrape'=>[['extract'=>['!meta property="twitter:player" content="https://archive.org/embed/(?\'id\'[^/"]+)!','!meta property="og:video:width" content="(?\'width\'\\d+)!','!meta property="og:video:height" content="(?\'height\'\\d+)!'],'match'=>['!archive\\.org/details/!']]]],
		'izlesene'=>['example'=>'http://www.izlesene.com/video/lily-allen-url-badman/7600704','extract'=>['!izlesene\\.com/video/[-\\w]+/(?\'id\'\\d+)!'],'homepage'=>'http://www.izlesene.com/','host'=>'izlesene.com','iframe'=>['src'=>'//www.izlesene.com/embedplayer/{@id}'],'name'=>'İzlesene','scrape'=>[],'tags'=>['.tr']],
		'jwplatform'=>['example'=>['http://content.jwplatform.com/players/X6tRZpKj-7Y21S9TB.html','http://content.jwplatform.com/previews/YfTSAegE-L0l35Tsd'],'extract'=>['!jwplatform\\.com/\\w+/(?\'id\'[-\\w]+)!'],'homepage'=>'https://www.jwplayer.com/products/jwplatform/','host'=>'jwplatform.com','iframe'=>['src'=>'//content.jwplatform.com/players/{@id}.html'],'name'=>'JW Platform','scrape'=>[],'tags'=>['videos']],
		'khl'=>['example'=>['http://video.khl.ru/events/233677','http://video.khl.ru/quotes/251237'],'extract'=>[],'homepage'=>'http://www.khl.ru/','host'=>'video.khl.ru','iframe'=>['src'=>'//video.khl.ru/iframe/feed/start/{@id}?type_id=18&width=560&height=315'],'name'=>'Kontinental Hockey League (КХЛ)','scrape'=>[['extract'=>['!/feed/start/(?\'id\'[/\\w]+)!'],'match'=>['!video\\.khl\\.ru/(?:event|quote)s/\\d!']]],'tags'=>['.ru','sports']],
		'kickstarter'=>['choose'=>['otherwise'=>['iframe'=>['height'=>420,'src'=>'//www.kickstarter.com/projects/{@id}/widget/card.html','width'=>220]],'when'=>['iframe'=>['height'=>360,'src'=>'//www.kickstarter.com/projects/{@id}/widget/video.html','width'=>480],'test'=>'@video']],'example'=>['http://www.kickstarter.com/projects/1869987317/wish-i-was-here-1','http://www.kickstarter.com/projects/1869987317/wish-i-was-here-1/widget/card.html','http://www.kickstarter.com/projects/1869987317/wish-i-was-here-1/widget/video.html'],'extract'=>['!kickstarter\\.com/projects/(?\'id\'[^/]+/[^/?]+)(?:/widget/(?:(?\'card\'card)|(?\'video\'video)))?!'],'homepage'=>'http://www.kickstarter.com/','host'=>'kickstarter.com','name'=>'Kickstarter','scrape'=>[],'tags'=>['fundraising']],
		'kissvideo'=>['example'=>'http://www.kissvideo.click/alton-towers-smiler-rollercoaster-crash_7789d8de8.html','extract'=>['!kissvideo\\.click/[^_]*_(?\'id\'[0-9a-f]+)!'],'homepage'=>'http://www.kissvideo.click/index.html','host'=>'kissvideo.click','iframe'=>['src'=>'//www.kissvideo.click/embed.php?vid={@id}'],'name'=>'Kiss Video','scrape'=>[],'tags'=>['videos']],
		'libsyn'=>['example'=>'http://bunkerbuddies.libsyn.com/interstellar-w-brandie-posey','extract'=>[],'homepage'=>'http://www.libsyn.com/','host'=>'libsyn.com','iframe'=>['height'=>45,'max-width'=>900,'src'=>'//html5-player.libsyn.com/embed/episode/id/{@id}/height/45/width/900/theme/standard/direction/no/autoplay/no/autonext/no/thumbnail/no/preload/no/no_addthis/no/','width'=>'100%'],'name'=>'Libsyn','scrape'=>[['extract'=>['!embed/episode/id/(?\'id\'\\d+)!'],'match'=>['@(?!\\.mp3)....$@']]],'tags'=>['podcasts']],
		'livecap'=>['example'=>['https://www.livecap.tv/s/esl_sc2/uZoEz6RR1eA','https://www.livecap.tv/t/riotgames/uLxUzBTBs7u'],'extract'=>['!livecap.tv/[st]/(?\'channel\'\\w+)/(?\'id\'\\w+)!'],'homepage'=>'https://www.livecap.tv/','host'=>'livecap.tv','iframe'=>['src'=>'https://www.livecap.tv/s/embed/{@channel}/{@id}'],'name'=>'LiveCap','scrape'=>[],'tags'=>['gaming']],
		'liveleak'=>['example'=>'http://www.liveleak.com/view?i=3dd_1366238099','extract'=>['!liveleak\\.com/view\\?i=(?\'id\'[a-f_0-9]+)!'],'homepage'=>'http://www.liveleak.com/','host'=>'liveleak.com','iframe'=>['src'=>'//www.liveleak.com/ll_embed?i={@id}'],'name'=>'LiveLeak','scrape'=>[],'tags'=>['videos']],
		'livestream'=>['example'=>['http://new.livestream.com/jbtvlive/musicmarathon','http://livestream.com/ccscsl/USChessChampionships/videos/83267610','http://livestre.am/58XNV'],'extract'=>['!livestream\\.com/accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!','!/videos/(?\'video_id\'\\d+)!','!original\\.livestream\\.com/(?\'channel\'\\w+)/video\\?clipId=(?\'clip_id\'[-\\w]+)!'],'homepage'=>'http://new.livestream.com/','host'=>['livestre.am','livestream.com'],'iframe'=>['src'=>'//<xsl:choose><xsl:when test="@clip_id">cdn.livestream.com/embed/<xsl:value-of select="@channel"/>?layout=4&amp;autoplay=false&amp;clip=<xsl:value-of select="@clip_id"/></xsl:when><xsl:otherwise>livestream.com/accounts/<xsl:value-of select="@account_id"/>/events/<xsl:value-of select="@event_id"/><xsl:if test="@video_id">/videos/<xsl:value-of select="@video_id"/></xsl:if>/player?autoPlay=false</xsl:otherwise></xsl:choose>'],'name'=>'Livestream','scrape'=>[['extract'=>['!accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!'],'match'=>['//']],['extract'=>['!//original\\.livestream\\.com/(?\'channel\'\\w+)/video/(?\'clip_id\'[-\\w]+)!'],'match'=>['!livestre.am!']]],'tags'=>['livestreaming','videos']],
		'mailru'=>['example'=>['https://my.mail.ru/corp/auto/video/testdrive/34.html','https://my.mail.ru/mail/alenka1957/video/1/7.html'],'extract'=>[],'homepage'=>'http://my.mail.ru/','host'=>'my.mail.ru','iframe'=>['src'=>'https://my.mail.ru/video/embed/{@id}'],'name'=>'Mail.Ru','scrape'=>[['extract'=>['!"itemId": ?"?(?\'id\'\\d+)!'],'match'=>['!my\\.mail\\.ru/\\w+/\\w+/video/\\w+/\\d!']]],'tags'=>['.ru']],
		'medium'=>['example'=>'https://medium.com/@donnydonny/team-internet-is-about-to-win-net-neutrality-and-they-didnt-need-googles-help-e7e2cf9b8a95','extract'=>['!medium\\.com/[^/]*/(?:[-\\w]+-)?(?\'id\'[\\da-f]+)!'],'homepage'=>'https://medium.com/','host'=>'medium.com','iframe'=>['data-s9e-livepreview-ignore-attrs'=>'style','height'=>400,'onload'=>'window.addEventListener(\'message\',function(a){{a=a.data.split(\'::\');\'m\'===a[0]&&0<src.indexOf(a[1])&&a[2]&&(style.height=a[2]+\'px\')}})','src'=>'https://api.medium.com/embed?type=story&path=%2F%2F{@id}&id={translate(@id,\'abcdef\',\'111111\')}','style'=>['border'=>'1px solid','border-color'=>'#eee #ddd #bbb','border-radius'=>'5px','box-shadow'=>'rgba(0,0,0,.15) 0 1px 3px'],'width'=>400],'name'=>'Medium','scrape'=>[],'tags'=>['blogging']],
		'metacafe'=>['example'=>'http://www.metacafe.com/watch/10785282/chocolate_treasure_chest_epic_meal_time/','extract'=>['!metacafe\\.com/watch/(?\'id\'\\d+)!'],'homepage'=>'http://www.metacafe.com/','host'=>'metacafe.com','iframe'=>['src'=>'//www.metacafe.com/embed/{@id}/'],'name'=>'Metacafe','scrape'=>[],'tags'=>['videos']],
		'mixcloud'=>['example'=>'http://www.mixcloud.com/OneTakeTapes/timsch-one-take-tapes-2/','extract'=>['@mixcloud\\.com/(?!categories|tag)(?\'id\'[-\\w]+/[^/&]+)/@'],'homepage'=>'http://www.mixcloud.com/','host'=>'mixcloud.com','iframe'=>['height'=>400,'src'=>'//www.mixcloud.com/widget/iframe/?feed=http%3A%2F%2Fwww.mixcloud.com%2F{@id}%2F&embed_type=widget_standard','width'=>400],'name'=>'Mixcloud','scrape'=>[],'tags'=>['music']],
		'mlb'=>['example'=>['http://m.mlb.com/video/v1205791883','http://m.mlb.com/video/topic/39049312/v1211631483/cubs-celebrate-world-series-with-historic-parade'],'extract'=>['#mlb\\.com/[\\w/]*/v(?\'id\'\\d+)#','#mlb\\.com/r/video\\?content_id=(?\'id\'\\d+)#'],'homepage'=>'http://mlb.com/video/','host'=>'mlb.com','iframe'=>['src'=>'//m.mlb.com/shared/video/embed/embed.html?content_id={@id}&width=640&height=360'],'name'=>'MLB','scrape'=>[],'tags'=>['sports']],
		'mrctv'=>['example'=>'http://dev.mrctv.org/videos/cnn-frets-about-tobacco-companies-color-coding-tricks','extract'=>[],'homepage'=>'http://www.mrctv.org/','host'=>'mrctv.org','iframe'=>['src'=>'https://www.mrctv.org/embed/{@id}'],'name'=>'MRCTV','scrape'=>[['extract'=>['!mrctv\\.org/embed/(?\'id\'\\d+)!'],'match'=>['!mrctv\\.org/videos/.!']]]],
		'msnbc'=>['example'=>['http://www.msnbc.com/ronan-farrow-daily/watch/thats-no-moon--300512323725','http://on.msnbc.com/1qkH62o'],'extract'=>[],'homepage'=>'http://www.msnbc.com/watch','host'=>'msnbc.com','iframe'=>['height'=>440,'src'=>'//player.theplatform.com/p/2E2eJC/EmbeddedOffSite?guid={@id}','width'=>635],'name'=>'MSNBC','scrape'=>[['extract'=>['@property="nv:videoId" content="(?\'id\'\\w+)@','@guid"?[=:]"?(?\'id\'\\w+)@'],'match'=>['@msnbc\\.com/[-\\w]+/watch/@','@on\\.msnbc\\.com/.@']]],'tags'=>['news']],
		'natgeochannel'=>['example'=>['http://channel.nationalgeographic.com/channel/brain-games/videos/jason-silva-on-intuition/','http://channel.nationalgeographic.com/wild/urban-jungle/videos/leopard-in-the-city/'],'extract'=>['@channel\\.nationalgeographic\\.com/(?\'id\'[-/\\w]+/videos/[-\\w]+)@'],'homepage'=>'http://channel.nationalgeographic.com/','host'=>'channel.nationalgeographic.com','iframe'=>['src'=>'//channel.nationalgeographic.com/{@id}/embed/'],'name'=>'National Geographic Channel','scrape'=>[]],
		'natgeovideo'=>['example'=>['http://video.nationalgeographic.com/tv/changing-earth','http://video.nationalgeographic.com/video/weirdest-superb-lyrebird'],'extract'=>[],'homepage'=>'http://video.nationalgeographic.com/','host'=>'video.nationalgeographic.com','iframe'=>['src'=>'//player.d.nationalgeographic.com/players/ngsvideo/share/?guid={@id}'],'name'=>'National Geographic Video','scrape'=>[['extract'=>['@guid="(?\'id\'[-\\w]+)"@'],'match'=>['@video\\.nationalgeographic\\.com/(?:tv|video)/\\w@']]],'tags'=>['documentaries']],
		'nbcnews'=>['example'=>'http://www.nbcnews.com/video/bob-dylan-awarded-nobel-prize-for-literature-785193027834','extract'=>['!nbcnews\\.com/(?:widget/video-embed/|video/[-\\w]+?-)(?\'id\'\\d+)!'],'homepage'=>'http://www.nbcnews.com/video/','host'=>'nbcnews.com','iframe'=>['src'=>'//www.nbcnews.com/widget/video-embed/{@id}'],'name'=>'NBC News','scrape'=>[],'tags'=>['news']],
		'nbcsports'=>['example'=>'http://www.nbcsports.com/video/countdown-rio-olympics-what-makes-perfect-performance','extract'=>[],'homepage'=>'http://www.nbcsports.com/video','host'=>'nbcsports.com','iframe'=>['src'=>'//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/{@id}?parentUrl='],'name'=>'NBC Sports','scrape'=>[['extract'=>['!select/media/(?\'id\'\\w+)!'],'match'=>['!nbcsports\\.com/video/.!']]],'tags'=>['sports']],
		'nhl'=>['example'=>'https://www.nhl.com/video/recap-min-2-ott-1-fot/t-277753022/c-46330703','extract'=>['#nhl\\.com/(?:\\w+/)?video(?:/(?![ct]-)[-\\w]+)?(?:/t-(?\'t\'\\d+))?(?:/c-(?\'c\'\\d+))?#'],'homepage'=>'https://www.nhl.com/video','host'=>'nhl.com','iframe'=>['src'=>'https://www.nhl.com/video/embed<xsl:if test="@t">/t-<xsl:value-of select="@t"/></xsl:if><xsl:if test="@c">/c-<xsl:value-of select="@c"/></xsl:if>?autostart=false'],'name'=>'NHL Videos and Highlights','scrape'=>[],'tags'=>['sports']],
		'npr'=>['example'=>['http://www.npr.org/blogs/goatsandsoda/2015/02/11/385396431/the-50-most-effective-ways-to-transform-the-developing-world','http://n.pr/1Qky1m5'],'extract'=>[],'homepage'=>'http://www.npr.org/','host'=>['npr.org','n.pr'],'iframe'=>['height'=>228,'max-width'=>800,'src'=>'//www.npr.org/player/embed/{@i}/{@m}','width'=>'100%'],'name'=>'NPR','scrape'=>[['extract'=>['!player/embed/(?\'i\'\\d+)/(?\'m\'\\d+)!'],'match'=>['!npr\\.org/[/\\w]+/\\d+!','!n\\.pr/\\w!']]],'tags'=>['podcasts']],
		'nytimes'=>['example'=>['http://www.nytimes.com/video/magazine/100000003166834/small-plates.html','http://www.nytimes.com/video/technology/personaltech/100000002907606/soylent-taste-test.html','http://www.nytimes.com/video/2012/12/17/business/100000001950744/how-wal-mart-conquered-teotihuacan.html','http://movies.nytimes.com/movie/131154/Crooklyn/trailers'],'extract'=>['!nytimes\\.com/video/[a-z]+/(?:[a-z]+/)?(?\'id\'\\d+)!','!nytimes\\.com/video/\\d+/\\d+/\\d+/[a-z]+/(?\'id\'\\d+)!'],'homepage'=>'http://www.nytimes.com/video/','host'=>'nytimes.com','iframe'=>['height'=>400,'src'=>'//graphics8.nytimes.com/video/players/offsite/index.html?videoId={@id}','width'=>585],'name'=>'The New York Times Video','scrape'=>[['extract'=>['!/video/movies/(?\'id\'\\d+)!'],'match'=>['!nytimes\\.com/movie(?:s/movie)?/(?\'playlist\'\\d+)/[-\\w]+/trailers!'],'url'=>'http://www.nytimes.com/svc/video/api/playlist/{@playlist}?externalId=true']],'tags'=>['movies','news']],
		'oddshot'=>['example'=>'https://oddshot.tv/s/-MrDaG','extract'=>['!oddshot.tv/s/(?\'id\'[-\\w]+)!'],'homepage'=>'http://oddshot.tv/','host'=>'oddshot.tv','iframe'=>['src'=>'https://oddshot.tv/s/{@id}/embed'],'name'=>'Oddshot','scrape'=>[],'tags'=>['gaming']],
		'orfium'=>['example'=>['https://www.orfium.com/album/24371/everybody-loves-kanye-totom/','https://www.orfium.com/live-set/614763/foof-no-lights-5-foof/','https://www.orfium.com/playlist/511651/electronic-live-sessions-creamtronic/','https://www.orfium.com/track/625367/the-ambience-of-the-goss-vistas/'],'extract'=>['@album/(?\'album_id\'\\d+)@','@playlist/(?\'playlist_id\'\\d+)@','@live-set/(?\'set_id\'\\d+)@','@track/(?\'track_id\'\\d+)@'],'homepage'=>'https://www.orfium.com/','host'=>'orfium.com','iframe'=>['height'=>'<xsl:choose><xsl:when test="@album_id">550</xsl:when><xsl:otherwise>275</xsl:otherwise></xsl:choose>','max-width'=>900,'src'=>'https://www.orfium.com/embedded/<xsl:choose><xsl:when test="@album_id">album/<xsl:value-of select="@album_id"/></xsl:when><xsl:when test="@playlist_id">playlist/<xsl:value-of select="@playlist_id"/></xsl:when><xsl:when test="@set_id">live-set/<xsl:value-of select="@set_id"/></xsl:when><xsl:otherwise>track/<xsl:value-of select="@track_id"/></xsl:otherwise></xsl:choose>','width'=>'100%'],'name'=>'Orfium','scrape'=>[],'tags'=>['music']],
		'pastebin'=>['example'=>'http://pastebin.com/9jEf44nc','extract'=>['@pastebin\\.com/(?!u/)(?:\\w+(?:\\.php\\?i=|/))?(?\'id\'\\w+)@'],'homepage'=>'http://pastebin.com/','host'=>'pastebin.com','iframe'=>['height'=>300,'scrolling'=>'','src'=>'//pastebin.com/embed_iframe.php?i={@id}','style'=>['resize'=>'vertical'],'width'=>'100%'],'name'=>'Pastebin','scrape'=>[]],
		'pinterest'=>['attributes'=>['id'=>['regexp'=>'@^(?:\\d+|[-\\w]+/[-\\w]+)$@']],'example'=>['https://www.pinterest.com/pin/99360735500167749/','https://www.pinterest.com/pinterest/official-news/'],'extract'=>['@pinterest.com/pin/(?\'id\'\\d+)@','@pinterest.com/(?!_/|discover/|explore/|news_hub/|pin/|search/)(?\'id\'[-\\w]+/[-\\w]+)@'],'homepage'=>'https://www.pinterest.com/','host'=>'pinterest.com','iframe'=>['data-s9e-livepreview-ignore-attrs'=>'style','height'=>360,'onload'=>'var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')','src'=>'https://s9e.github.io/iframe/pinterest.min.html#{@id}','width'=>'<xsl:choose><xsl:when test="contains(@id,\'/\')">730</xsl:when><xsl:otherwise>345</xsl:otherwise></xsl:choose>'],'name'=>'Pinterest','scrape'=>[],'source'=>'https://developers.pinterest.com/tools/widget-builder/','tags'=>['social']],
		'playstv'=>['example'=>['http://plays.tv/s/Kt4onQhyyVyz','http://plays.tv/video/565683db95f139f47e/full-length-version-radeon-software-crimson-edition-is-amds-revolutionary-new-graphics-software-that'],'extract'=>['!plays\\.tv/video/(?\'id\'\\w+)!'],'homepage'=>'http://plays.tv/','host'=>'plays.tv','iframe'=>['src'=>'//plays.tv/embeds/{@id}'],'name'=>'Plays.tv','scrape'=>[['extract'=>['!plays\\.tv/video/(?\'id\'\\w+)!'],'match'=>['!plays\\.tv/s/!']]],'tags'=>['gaming']],
		'podbean'=>['example'=>['http://dialhforheroclix.podbean.com/e/dial-h-for-heroclix-episode-46-all-ya-need-is-love/','http://www.podbean.com/media/share/pb-qtwub-4ee10c'],'extract'=>['!podbean\\.com/media/(?:player/|share/pb-)(?\'id\'[-\\w]+)!'],'homepage'=>'http://www.podbean.com/','host'=>'podbean.com','iframe'=>['height'=>100,'max-width'=>900,'src'=>'//www.podbean.com/media/player/{@id}','width'=>'100%'],'name'=>'Podbean','scrape'=>[['extract'=>['!podbean\\.com/media/player/(?\'id\'[-\\w]+)!'],'match'=>['!podbean\\.com/(?:media/shar)?e/!']]],'tags'=>['podcasts']],
		'prezi'=>['example'=>'http://prezi.com/5ye8po_hmikp/10-most-common-rookie-presentation-mistakes/','extract'=>['#//prezi\\.com/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)/)(?\'id\'\\w+)/#'],'homepage'=>'http://prezi.com/','host'=>'prezi.com','iframe'=>['height'=>400,'src'=>'//prezi.com/embed/{@id}/','width'=>550],'name'=>'Prezi','scrape'=>[],'tags'=>['presentations']],
		'reddit'=>['example'=>['http://www.reddit.com/r/pics/comments/304rms/cats_reaction_to_seeing_the_ceiling_fan_move_for/','http://www.reddit.com/r/pics/comments/304rms/cats_reaction_to_seeing_the_ceiling_fan_move_for/cpp2kkl'],'extract'=>['!(?\'path\'/r/\\w+/comments/\\w+/(?:\\w+/\\w+)?)!'],'homepage'=>'http://www.reddit.com/','host'=>'reddit.com','iframe'=>['data-s9e-livepreview-ignore-attrs'=>'style','height'=>165,'onload'=>'var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')','src'=>'https://s9e.github.io/iframe/reddit.min.html#{@path}','width'=>800],'name'=>'Reddit threads and comments','scrape'=>[],'source'=>'https://www.reddit.com/wiki/embeds','tags'=>['social']],
		'rutube'=>['example'=>['http://rutube.ru/video/b920dc58f1397f1761a226baae4d2f3b/','http://rutube.ru/tracks/4118278.html?v=8b490a46447720d4ad74616f5de2affd'],'extract'=>['!rutube\\.ru/tracks/(?\'id\'\\d+)!'],'homepage'=>'http://rutube.ru/','host'=>'rutube.ru','iframe'=>['height'=>405,'src'=>'//rutube.ru/play/embed/{@id}','width'=>720],'name'=>'Rutube','scrape'=>[['extract'=>['!rutube\\.ru/play/embed/(?\'id\'\\d+)!'],'match'=>['!rutube\\.ru/video/[0-9a-f]{32}!']]],'tags'=>['.ru']],
		'scribd'=>['example'=>'http://www.scribd.com/doc/237147661/Calculus-2-Test-1-Review?in_collection=5291376','extract'=>['!scribd\\.com/(?:mobile/)?doc(?:ument)?/(?\'id\'\\d+)!'],'homepage'=>'http://www.scribd.com/','host'=>'scribd.com','iframe'=>['height'=>500,'src'=>'https://www.scribd.com/embeds/{@id}/content?view_mode=scroll&show_recommendations=false','style'=>['resize'=>'vertical'],'width'=>'100%'],'name'=>'Scribd','scrape'=>[],'tags'=>['documents','presentations']],
		'slideshare'=>['example'=>'http://www.slideshare.net/Slideshare/how-23431564','extract'=>['!slideshare\\.net/[^/]+/[-\\w]+-(?\'id\'\\d{6,})$!'],'homepage'=>'http://www.slideshare.net/','host'=>'slideshare.net','iframe'=>['height'=>356,'src'=>'//www.slideshare.net/slideshow/embed_code/{@id}','width'=>427],'name'=>'SlideShare','scrape'=>[['extract'=>['!"presentationId":(?\'id\'\\d+)!'],'match'=>['!slideshare\\.net/[^/]+/\\w!']]],'source'=>'http://help.slideshare.com/forums/67665-Embedding-Sharing','tags'=>['presentations']],
		'soundcloud'=>['example'=>['http://api.soundcloud.com/tracks/98282116','https://soundcloud.com/andrewbird/three-white-horses','https://soundcloud.com/tenaciousd/sets/rize-of-the-fenix/'],'extract'=>['@https?://(?:api\\.)?soundcloud\\.com/(?!pages/)(?\'id\'[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)@i','@api\\.soundcloud\\.com/playlists/(?\'playlist_id\'\\d+)@','@api\\.soundcloud\\.com/tracks/(?\'track_id\'\\d+)(?:\\?secret_token=(?\'secret_token\'[-\\w]+))?@','@soundcloud\\.com/(?!playlists|tracks)[-\\w]+/[-\\w]+/(?=s-)(?\'secret_token\'[-\\w]+)@'],'homepage'=>'https://soundcloud.com/','host'=>'soundcloud.com','iframe'=>['height'=>'<xsl:choose><xsl:when test="@playlist_id or contains(@id,\'/sets/\')">450</xsl:when><xsl:otherwise>166</xsl:otherwise></xsl:choose>','max-width'=>900,'src'=>'https://w.soundcloud.com/player/?url=<xsl:choose><xsl:when test="@playlist_id">https%3A//api.soundcloud.com/playlists/<xsl:value-of select="@playlist_id"/></xsl:when><xsl:when test="@track_id">https%3A//api.soundcloud.com/tracks/<xsl:value-of select="@track_id"/>&amp;secret_token=<xsl:value-of select="@secret_token"/></xsl:when><xsl:otherwise><xsl:if test="not(contains(@id,\'://\'))">https%3A//soundcloud.com/</xsl:if><xsl:value-of select="@id"/></xsl:otherwise></xsl:choose>','width'=>'100%'],'name'=>'SoundCloud','scrape'=>[['extract'=>['@soundcloud:tracks:(?\'track_id\'\\d+)@'],'match'=>['@soundcloud\\.com/(?!playlists/\\d|tracks/\\d)[-\\w]+/[-\\w]@']],['extract'=>['@soundcloud://playlists:(?\'playlist_id\'\\d+)@'],'match'=>['@soundcloud\\.com/\\w+/sets/@']]],'source'=>'https://soundcloud.com/pages/widgets','tags'=>['music']],
		'sportsnet'=>['example'=>'http://www.sportsnet.ca/soccer/west-ham-2-hull-2/','extract'=>[],'homepage'=>'http://www.sportsnet.ca/','host'=>'sportsnet.ca','iframe'=>['src'=>'https://images.rogersdigitalmedia.com/video_service.php?videoId={@id}&playerKey=AQ~~,AAAAAGWRwLc~,cRCmKE8Utf7OFWP38XQcokFZ80fR-u_y&autoStart=false&width=100%25&height=100%25'],'name'=>'Sportsnet','scrape'=>[['extract'=>['/vid(?:eoId)?=(?\'id\'\\d+)/','/param name="@videoPlayer" value="(?\'id\'\\d+)"/'],'match'=>['//']]],'tags'=>['.ca','sports']],
		'spotify'=>['example'=>['spotify:track:5JunxkcjfCYcY7xJ29tLai','spotify:trackset:PREFEREDTITLE:5Z7ygHQo02SUrFmcgpwsKW,1x6ACsKV4UdWS2FMuPFUiT,4bi73jCM02fMpkI11Lqmfe','http://open.spotify.com/user/ozmoetr/playlist/4yRrCWNhWOqWZx5lmFqZvt','https://play.spotify.com/album/5OSzFvFAYuRh93WDNCTLEz'],'extract'=>['!(?\'uri\'spotify:(?:album|artist|user|track(?:set)?):[-,:\\w]+)!','!(?:open|play)\\.spotify\\.com/(?\'path\'(?:album|artist|track|user)/[-/\\w]+)!'],'homepage'=>'https://www.spotify.com/','host'=>['open.spotify.com','play.spotify.com'],'iframe'=>['height'=>480,'src'=>'https://embed.spotify.com/?view=coverart&amp;uri=<xsl:choose><xsl:when test="@uri"><xsl:value-of select="@uri"/></xsl:when><xsl:otherwise>spotify:<xsl:value-of select="translate(@path,\'/\',\':\')"/></xsl:otherwise></xsl:choose>','width'=>400],'name'=>'Spotify','scheme'=>'spotify','scrape'=>[],'source'=>['https://developer.spotify.com/technologies/widgets/spotify-play-button/','http://news.spotify.com/2008/01/14/linking-to-spotify/'],'tags'=>['music']],
		'steamstore'=>['example'=>'http://store.steampowered.com/app/250520/','extract'=>['!store.steampowered.com/app/(?\'id\'\\d+)!'],'homepage'=>'http://store.steampowered.com/','host'=>'store.steampowered.com','iframe'=>['height'=>190,'max-width'=>900,'src'=>'//store.steampowered.com/widget/{@id}','width'=>'100%'],'name'=>'Steam store','scrape'=>[],'tags'=>['gaming']],
		'stitcher'=>['example'=>'http://www.stitcher.com/podcast/twit/tech-news-today/e/twitter-shares-fall-18-percent-after-earnings-leak-on-twitter-37808629','extract'=>[],'homepage'=>'http://www.stitcher.com/','host'=>'stitcher.com','iframe'=>['height'=>150,'max-width'=>900,'src'=>'//app.stitcher.com/splayer/f/{@fid}/{@eid}','width'=>'100%'],'name'=>'Stitcher','scrape'=>[['extract'=>['!data-eid="(?\'eid\'\\d+)!','!data-fid="(?\'fid\'\\d+)!'],'match'=>['!/podcast/!']]],'tags'=>['podcasts']],
		'strawpoll'=>['example'=>'http://strawpoll.me/738091','extract'=>['!strawpoll\\.me/(?\'id\'\\d+)!'],'homepage'=>'http://strawpoll.me/','host'=>'strawpoll.me','iframe'=>['scrolling'=>'','src'=>'//www.strawpoll.me/embed_1/{@id}'],'name'=>'Straw Poll','scrape'=>[]],
		'streamable'=>['example'=>'http://streamable.com/e4d','extract'=>['!streamable\\.com/(?\'id\'\\w+)!'],'homepage'=>'http://streamable.com/','host'=>'streamable.com','iframe'=>['src'=>'//streamable.com/e/{@id}'],'name'=>'Streamable','scrape'=>[],'tags'=>['videos']],
		'teamcoco'=>['example'=>['http://teamcoco.com/video/serious-jibber-jabber-a-scott-berg-full-episode','http://teamcoco.com/video/73784/historian-a-scott-berg-serious-jibber-jabber-with-conan-obrien'],'extract'=>['!teamcoco\\.com/video/(?\'id\'\\d+)!'],'homepage'=>'http://teamcoco.com/','host'=>'teamcoco.com','iframe'=>['height'=>415,'src'=>'//teamcoco.com/embed/v/{@id}','width'=>640],'name'=>'Team Coco','scrape'=>[['extract'=>['!"id":(?\'id\'\\d+)!'],'match'=>['!teamcoco\\.com/video/.!']]],'tags'=>['entertainment']],
		'ted'=>['example'=>['http://www.ted.com/talks/eli_pariser_beware_online_filter_bubbles.html','http://embed.ted.com/playlists/26/our_digital_lives.html'],'extract'=>['#ted\\.com/(?\'id\'(?:talk|playlist)s/[-\\w]+(?:\\.html)?)(?![-\\w]|/transcript)#i'],'homepage'=>'http://www.ted.com/','host'=>'ted.com','iframe'=>['src'=>'//embed.ted.com/<xsl:value-of select="@id"/><xsl:if test="not(contains(@id,\'.html\'))">.html</xsl:if>'],'name'=>'TED Talks','scrape'=>[],'source'=>'http://blog.ted.com/2011/04/01/now-you-can-embed-tedtalks-with-subtitles-enabled/','tags'=>['presentations']],
		'theatlantic'=>['example'=>'http://www.theatlantic.com/video/index/358928/computer-vision-syndrome-and-you/','extract'=>['!theatlantic\\.com/video/index/(?\'id\'\\d+)!'],'homepage'=>'http://www.theatlantic.com/video/','host'=>'theatlantic.com','iframe'=>['src'=>'//www.theatlantic.com/video/iframe/{@id}/'],'name'=>'The Atlantic Video','scrape'=>[],'tags'=>['news']],
		'theguardian'=>['example'=>'http://www.theguardian.com/world/video/2016/apr/07/tokyos-hedgehog-cafe-encourages-you-to-embrace-prickly-pets-video','extract'=>['!theguardian\\.com/(?\'id\'\\w+/video/[-/\\w]+)!'],'homepage'=>'http://www.theguardian.com/video','host'=>'theguardian.com','iframe'=>['src'=>'//embed.theguardian.com/embed/video/{@id}'],'name'=>'The Guardian','scrape'=>[],'tags'=>['news']],
		'theonion'=>['example'=>['http://www.theonion.com/video/nation-successfully-completes-mothers-day-by-918-a,35998/','http://www.theonion.com/video/the-onion-reviews-avengers-age-of-ultron-38524'],'extract'=>['!theonion\\.com/video/[-\\w]+[-,](?\'id\'\\d+)!'],'homepage'=>'http://www.theonion.com/video/','host'=>'theonion.com','iframe'=>['src'=>'//www.theonion.com/video_embed/?id={@id}'],'name'=>'The Onion','scrape'=>[],'tags'=>['entertainment']],
		'tinypic'=>['example'=>['http://tinypic.com/player.php?v=29x86j9&s=8','http://tinypic.com/r/29x86j9/8'],'extract'=>['!tinypic\\.com/player\\.php\\?v=(?\'id\'\\w+)&s=(?\'s\'\\d+)!','!tinypic\\.com/r/(?\'id\'\\w+)/(?\'s\'\\d+)!'],'flash'=>['padding-height'=>30,'src'=>'//tinypic.com/player.swf?file={@id}&s={@s}'],'homepage'=>'http://tinypic.com/','host'=>'tinypic.com','name'=>'TinyPic videos','scrape'=>[['extract'=>['!file=(?\'id\'\\w+)&amp;s=(?\'s\'\\d+)!'],'match'=>['!tinypic\\.com/(?:m|usermedia)/!']]],'tags'=>['images']],
		'tmz'=>['example'=>'http://www.tmz.com/videos/0_2pr9x3rb/','extract'=>['@tmz\\.com/videos/(?\'id\'\\w+)@'],'homepage'=>'http://www.tmz.com/videos','host'=>'tmz.com','iframe'=>['src'=>'//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/{@id}'],'name'=>'TMZ','scrape'=>[],'tags'=>['gossip']],
		'traileraddict'=>['example'=>'http://www.traileraddict.com/the-amazing-spider-man-2/super-bowl-tv-spot','extract'=>[],'homepage'=>'http://www.traileraddict.com/','host'=>'traileraddict.com','iframe'=>['src'=>'//v.traileraddict.com/{@id}'],'name'=>'Trailer Addict','scrape'=>[['extract'=>['@v\\.traileraddict\\.com/(?\'id\'\\d+)@'],'match'=>['@traileraddict\\.com/(?!tags/)[^/]+/.@']]],'tags'=>['movies']],
		'tumblr'=>['example'=>'http://mrbenvey.tumblr.com/post/104191225637','extract'=>['!(?\'name\'[-\\w]+)\\.tumblr\\.com/post/(?\'id\'\\d+)!'],'homepage'=>'https://www.tumblr.com/','host'=>'tumblr.com','iframe'=>['data-s9e-livepreview-ignore-attrs'=>'style','height'=>180,'onload'=>'var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')','src'=>'https://s9e.github.io/iframe/tumblr.min.html#{@key}/{@id}','width'=>520],'name'=>'Tumblr','scrape'=>[['extract'=>['!did=\\\\u0022(?\'did\'[-\\w]+)!','!embed\\\\/post\\\\/(?\'key\'[-\\w]+)!'],'match'=>['!\\w\\.tumblr\\.com/post/\\d!'],'url'=>'http://www.tumblr.com/oembed/1.0?url=http://{@name}.tumblr.com/post/{@id}']],'tags'=>['social']],
		'twitch'=>['example'=>['http://www.twitch.tv/twitch','http://www.twitch.tv/twitch/v/29415830?t=17m17s','https://clips.twitch.tv/twitch/HorribleWoodpeckerHassanChop'],'extract'=>['#twitch\\.tv/(?:videos|\\w+/v)/(?\'video_id\'\\d+)?#','#www\\.twitch\\.tv/(?!videos/)(?\'channel\'\\w+)#','#t=(?\'t\'(?:(?:\\d+h)?\\d+m)?\\d+s)#','#clips\\.twitch\\.tv/(?:(?\'channel\'\\w+)/)?(?\'clip_id\'\\w+)#'],'homepage'=>'http://www.twitch.tv/','host'=>'twitch.tv','iframe'=>['src'=>'//<xsl:choose><xsl:when test="@clip_id">clips.twitch.tv/embed?autoplay=false&amp;clip=<xsl:if test="@channel"><xsl:value-of select="@channel"/>/</xsl:if><xsl:value-of select="@clip_id"/></xsl:when><xsl:otherwise>player.twitch.tv/?autoplay=false&amp;<xsl:choose><xsl:when test="@video_id">video=v<xsl:value-of select="@video_id"/></xsl:when><xsl:otherwise>channel=<xsl:value-of select="@channel"/></xsl:otherwise></xsl:choose><xsl:if test="@t">&amp;time=<xsl:value-of select="@t"/></xsl:if></xsl:otherwise></xsl:choose>'],'name'=>'Twitch','scrape'=>[],'source'=>'https://github.com/justintv/Twitch-API/blob/master/embed-video.md','tags'=>['gaming','livestreaming']],
		'twitter'=>['example'=>['https://twitter.com/IJasonAlexander/statuses/526635414338023424','https://mobile.twitter.com/DerekTVShow/status/463372588690202624','https://twitter.com/#!/IJasonAlexander/status/526635414338023424'],'extract'=>['@twitter\\.com/(?:#!/)?\\w+/status(?:es)?/(?\'id\'\\d+)@'],'homepage'=>'https://twitter.com/','host'=>'twitter.com','iframe'=>['data-s9e-livepreview-ignore-attrs'=>'style','height'=>186,'onload'=>'var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')','src'=>'https://s9e.github.io/iframe/twitter.min.html#{@id}','style'=>['background'=>'url(https://abs.twimg.com/favicons/favicon.ico) no-repeat 50% 50%'],'width'=>500],'name'=>'Twitter','scrape'=>[],'tags'=>['social']],
		'ustream'=>['choose'=>['otherwise'=>['iframe'=>['src'=>'//www.ustream.tv/embed/{@cid}?html5ui']],'when'=>['iframe'=>['src'=>'//www.ustream.tv/embed/recorded/{@vid}?html5ui'],'test'=>'@vid']],'example'=>['http://www.ustream.tv/channel/ps4-ustream-gameplay','http://www.ustream.tv/baja1000tv','http://www.ustream.tv/recorded/40688256'],'extract'=>['!ustream\\.tv/recorded/(?\'vid\'\\d+)!'],'homepage'=>'http://www.ustream.tv/','host'=>'ustream.tv','name'=>'Ustream','scrape'=>[['extract'=>['!embed/(?\'cid\'\\d+)!'],'match'=>['#ustream\\.tv/(?!explore/|platform/|recorded/|search\\?|upcoming$|user/)(?:channel/)?[-\\w]+#']]],'tags'=>['gaming']],
		'vbox7'=>['example'=>'http://vbox7.com/play:3975300ec6','extract'=>['!vbox7\\.com/play:(?\'id\'[\\da-f]+)!'],'homepage'=>'http://vbox7.com/','host'=>'vbox7.com','iframe'=>['src'=>'//vbox7.com/emb/external.php?vid={@id}'],'name'=>'VBOX7','scrape'=>[],'tags'=>['.bg']],
		'veoh'=>['example'=>'http://www.veoh.com/watch/v6335577TeB8kyNR','extract'=>['!veoh\\.com/(?:m/watch\\.php\\?v=|watch/)v(?\'id\'\\w+)!'],'flash'=>['padding-height'=>40,'src'=>'//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&permalinkId=v{@id}&player=videodetailsembedded&videoAutoPlay=0&id=anonymous'],'homepage'=>'http://www.veoh.com/','host'=>'veoh.com','name'=>'Veoh','scrape'=>[],'tags'=>['videos']],
		'vevo'=>['example'=>['http://www.vevo.com/watch/USUV71400682','http://www.vevo.com/watch/eminem/the-monster-explicit/USUV71302925'],'extract'=>['!vevo\\.com/watch/([-/\\w]+/)?(?\'id\'[A-Z0-9]+)!'],'homepage'=>'http://vevo.com/','host'=>'vevo.com','iframe'=>['height'=>324,'src'=>'//cache.vevo.com/m/html/embed.html?video={@id}','width'=>575],'name'=>'VEVO','scrape'=>[],'tags'=>['music']],
		'viagame'=>['example'=>'http://www.viagame.com/channels/hearthstone-championship/405177','extract'=>['!viagame\\.com/channels/[^/]+/(?\'id\'\\d+)!'],'homepage'=>'http://www.viagame.com/','host'=>'viagame.com','iframe'=>['height'=>392,'src'=>'//www.viagame.com/embed/{@id}','width'=>640],'name'=>'Viagame','scrape'=>[],'tags'=>['gaming']],
		'videodetective'=>['example'=>'http://www.videodetective.com/movies/zootopia/658596','extract'=>['!videodetective\\.com/\\w+/[-\\w]+/(?:trailer/P0*)?(?\'id\'\\d+)!'],'homepage'=>'http://www.videodetective.com/','host'=>'videodetective.com','iframe'=>['src'=>'//www.videodetective.com/embed/video/?options=false&autostart=false&playlist=none&publishedid={@id}'],'name'=>'Video Detective','scrape'=>[]],
		'videomega'=>['example'=>'http://videomega.tv/?ref=aPRKXgQdaD','extract'=>['!videomega\\.tv/\\?ref=(?\'id\'\\w+)!'],'homepage'=>'http://videomega.tv/','host'=>'videomega.tv','iframe'=>['src'=>'//videomega.tv/iframe.php?ref={@id}'],'name'=>'Videomega','scrape'=>[],'tags'=>['videos']],
		'vidme'=>['example'=>'https://vid.me/6AZf1','extract'=>[],'homepage'=>'https://vid.me','host'=>'vid.me','iframe'=>['src'=>'https://vid.me/e/{@id}'],'name'=>'vidme','scrape'=>[['extract'=>['#vid\\.me/e/(?\'id\'\\w+)#','#oembed.*?url=https://vid\\.me/(?!e/)(?\'id\'\\w+)#'],'match'=>['//']]],'tags'=>['videos']],
		'vimeo'=>['example'=>['http://vimeo.com/67207222','http://vimeo.com/channels/staffpicks/67207222'],'extract'=>['!vimeo\\.com/(?:channels/[^/]+/|video/)?(?\'id\'\\d+)!'],'homepage'=>'http://vimeo.com/','host'=>'vimeo.com','iframe'=>['src'=>'//player.vimeo.com/video/{@id}'],'name'=>'Vimeo','scrape'=>[],'source'=>'http://developer.vimeo.com/player/embedding','tags'=>['videos']],
		'vine'=>['example'=>'https://vine.co/v/bYwPIluIipH','extract'=>['!vine\\.co/v/(?\'id\'[^/]+)!'],'homepage'=>'https://vine.co/','host'=>'vine.co','iframe'=>['height'=>480,'src'=>'https://vine.co/v/{@id}/embed/simple?audio=1','width'=>480],'name'=>'Vine','scrape'=>[],'tags'=>['social','videos']],
		'vk'=>['example'=>['http://vkontakte.ru/video-7016284_163645555','http://vk.com/video226156999_168963041','http://vk.com/newmusicvideos?z=video-13895667_161988074','http://vk.com/video_ext.php?oid=121599878&id=165723901&hash=e06b0878046e1d32'],'extract'=>['!vk(?:\\.com|ontakte\\.ru)/(?:[\\w.]+\\?z=)?video(?\'oid\'-?\\d+)_(?\'vid\'\\d+)!','!vk(?:\\.com|ontakte\\.ru)/video_ext\\.php\\?oid=(?\'oid\'-?\\d+)&id=(?\'vid\'\\d+)&hash=(?\'hash\'[0-9a-f]+)!'],'homepage'=>'https://vk.com/','host'=>['vk.com','vkontakte.ru'],'iframe'=>['height'=>360,'src'=>'//vk.com/video_ext.php?oid={@oid}&id={@vid}&hash={@hash}&hd=1','width'=>607],'name'=>'VK','scrape'=>[['extract'=>['!embed_hash=(?\'hash\'[0-9a-f]+)!'],'match'=>['!vk.*?video-?\\d+_\\d+!'],'url'=>'http://vk.com/video{@oid}_{@vid}']],'tags'=>['.ru']],
		'vocaroo'=>['example'=>'http://vocaroo.com/i/s0dRy3rZ47bf','extract'=>['!vocaroo\\.com/i/(?\'id\'\\w+)!'],'flash'=>['height'=>44,'src'=>'//vocaroo.com/player.swf?playMediaID={@id}&autoplay=0','width'=>148],'homepage'=>'http://vocaroo.com/','host'=>'vocaroo.com','name'=>'Vocaroo','scrape'=>[]],
		'vox'=>['example'=>'http://www.vox.com/2015/7/21/9005857/ant-man-marvel-apology-review#ooid=ltbzJkdTpKpE-O6hOfD3YJew3t3MppXb','extract'=>['!vox.com/.*#ooid=(?\'id\'[-\\w]+)!'],'homepage'=>'http://www.vox.com/','host'=>'vox.com','iframe'=>['src'=>'//player.ooyala.com/iframe.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&ec={@id}'],'name'=>'Vox','scrape'=>[]],
		'washingtonpost'=>['example'=>['https://www.washingtonpost.com/video/c/video/df229384-9216-11e6-bc00-1a9756d4111b','https://www.washingtonpost.com/video/world/aurora-display-lights-up-the-night-sky-over-finland/2016/10/14/df229384-9216-11e6-bc00-1a9756d4111b_video.html'],'extract'=>['#washingtonpost\\.com/video/c/\\w+/(?\'id\'[-0-9a-f]+)#','#washingtonpost\\.com/video/[-/\\w]+/(?\'id\'[-0-9a-f]+)_video\\.html#'],'homepage'=>'https://www.washingtonpost.com/video/','host'=>'washingtonpost.com','iframe'=>['src'=>'//www.washingtonpost.com/video/c/embed/{@id}'],'name'=>'Washington Post Video','scrape'=>[],'tags'=>['news']],
		'wshh'=>['example'=>['http://www.worldstarhiphop.com/videos/video.php?v=wshhZ8F22UtJ8sLHdja0','http://m.worldstarhiphop.com/video.php?v=wshh2SXFFe7W14DqQx61','http://www.worldstarhiphop.com/featured/71630'],'extract'=>['!worldstarhiphop\\.com/featured/(?\'id\'\\d+)!'],'homepage'=>'http://www.worldstarhiphop.com/','host'=>'worldstarhiphop.com','iframe'=>['src'=>'//www.worldstarhiphop.com/embed/{@id}'],'name'=>'WorldStarHipHop','scrape'=>[['extract'=>['!v: ?"?(?\'id\'\\d+)!'],'match'=>['!worldstarhiphop\\.com/(?:\\w+/)?video\\.php\\?v=\\w+!']]],'tags'=>['videos']],
		'wsj'=>['example'=>['http://www.wsj.com/video/nba-players-primp-with-pedicures/9E476D54-6A60-4F3F-ABC1-411014552DE6.html','http://live.wsj.com/#!09FB2B3B-583E-4284-99D8-FEF6C23BE4E2','http://live.wsj.com/video/seahawks-qb-russell-wilson-on-super-bowl-win/9B3DF790-9D20-442C-B564-51524B06FD26.html'],'extract'=>['@wsj\\.com/[^#]*#!(?\'id\'[-0-9A-F]{36})@','@wsj\\.com/video/[^/]+/(?\'id\'[-0-9A-F]{36})@'],'homepage'=>'http://www.wsj.com/video/','host'=>'wsj.com','iframe'=>['height'=>288,'src'=>'//video-api.wsj.com/api-video/player/iframe.html?guid={@id}','width'=>512],'name'=>'The Wall Street Journal Online','scrape'=>[['extract'=>['@guid=(?\'id\'[-0-9A-F]{36})@'],'match'=>['@on\\.wsj\\.com/\\w@']]],'tags'=>['news']],
		'xboxclips'=>['example'=>'http://xboxclips.com/dizturbd/e3a2d685-3e9f-454f-89bf-54ddea8f29b3','extract'=>['@xboxclips\\.com/(?\'user\'[^/]+)/(?!screenshots/)(?\'id\'[-0-9a-f]+)@'],'homepage'=>'http://xboxclips.com/','host'=>'xboxclips.com','iframe'=>['src'=>'//xboxclips.com/{@user}/{@id}/embed'],'name'=>'XboxClips','scrape'=>[],'tags'=>['gaming']],
		'xboxdvr'=>['example'=>'http://xboxdvr.com/gamer/LOXITANE/video/12463958','extract'=>['!xboxdvr\\.com/gamer/(?\'user\'[^/]+)/video/(?\'id\'\\d+)!'],'homepage'=>'http://xboxdvr.com/','host'=>'xboxdvr.com','iframe'=>['src'=>'//xboxdvr.com/gamer/{@user}/video/{@id}/embed'],'name'=>'Xbox DVR','scrape'=>[],'tags'=>['gaming']],
		'yahooscreen'=>['example'=>['https://screen.yahoo.com/mr-short-term-memory-000000263.html','https://screen.yahoo.com/dana-carvey-snl-skits/church-chat-satan-000000502.html'],'extract'=>['!screen\\.yahoo\\.com/(?:[-\\w]+/)?(?\'id\'[-\\w]+)\\.html!'],'homepage'=>'https://screen.yahoo.com/','host'=>'screen.yahoo.com','iframe'=>['src'=>'https://screen.yahoo.com/{@id}.html?format=embed'],'name'=>'Yahoo! Screen','scrape'=>[],'tags'=>['movies']],
		'youku'=>['example'=>'http://v.youku.com/v_show/id_XNzQwNjcxNDM2.html','extract'=>['!youku\\.com/v(?:_show|ideo)/id_(?\'id\'\\w+)!'],'homepage'=>'http://www.youku.com/','host'=>'youku.com','iframe'=>['padding-height'=>40,'src'=>'https://players.youku.com/embed/{@id}'],'name'=>'Youku','scrape'=>[],'tags'=>['.cn']],
		'youtube'=>['attributes'=>['t'=>['type'=>'timestamp']],'example'=>['http://www.youtube.com/watch?v=-cEzsCAzTak','http://youtu.be/-cEzsCAzTak','http://www.youtube.com/watch?feature=player_detailpage&v=jofNR_WkoCE#t=40','http://www.youtube.com/watch?v=pC35x6iIPmo&list=PLOU2XLYxmsIIxJrlMIY5vYXAFcO5g83gA'],'extract'=>['!youtube\\.com/(?:watch.*?v=|v/|attribution_link.*?v%3D)(?\'id\'[-\\w]+)!','!youtu\\.be/(?\'id\'[-\\w]+)!','@[#&?]t=(?\'t\'\\d[\\dhms]*)@','!&list=(?\'list\'[-\\w]+)!'],'homepage'=>'http://www.youtube.com/','host'=>['youtube.com','youtu.be'],'iframe'=>['src'=>'https://www.youtube.com/embed/<xsl:value-of select="@id"/><xsl:if test="@list">?list=<xsl:value-of select="@list"/></xsl:if><xsl:if test="@t"><xsl:choose><xsl:when test="@list">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose>start=<xsl:value-of select="@t"/></xsl:if>','style'=>['background'=>'url(https://i.ytimg.com/vi/{@id}/hqdefault.jpg) 50% 50% / cover']],'name'=>'YouTube','scrape'=>[['extract'=>['!/vi/(?\'id\'[-\\w]+)!'],'match'=>['!/shared\\?ci=!']]],'source'=>'http://support.google.com/youtube/bin/answer.py?hl=en&answer=171780','tags'=>['livestreaming','videos']],
		'zippyshare'=>['example'=>'http://www17.zippyshare.com/v/EtPLaXGE/file.html','extract'=>[],'flash'=>['flashvars'=>'file={@file}&server={@server}&autostart=false','height'=>80,'max-width'=>900,'src'=>'//api.zippyshare.com/api/player.swf','width'=>'100%'],'homepage'=>'http://www.zippyshare.com/','host'=>'zippyshare.com','name'=>'Zippyshare audio files','scrape'=>[['extract'=>['!file=(?\'file\'\\w+)&amp;server=(?\'server\'\\d+)!'],'match'=>['!/v/!']]],'tags'=>['file sharing']]
	];
}