dnl $Id: php4.cxx 10099 2007-11-10 21:10:17Z wsfulton $
dnl ***********************************************************************
dnl ** THIS config.m4 is provided for PHPIZE and PHP's consumption NOT
dnl ** for any part of the rest of the zorba_api build system
dnl ***********************************************************************

PHP_ARG_WITH(zorba_api, for zorba_api support,
[  --with-zorba_api[=DIR]             Include zorba_api support.])

dnl THESE TESTS try and find the library and header files
dnl your new php module needs. YOU MAY NEED TO EDIT THEM
dnl as written they assume your header files are all in the same place

dnl ** are we looking for zorba_api_lib.h or something else?
HNAMES="zorba/zorba.h"

dnl ** Are we looking for libzorba_api.a or libzorba_api.so or something else?
LIBNAMES="zorba"

dnl IF YOU KNOW one of the symbols in the library and you
dnl specify it below then we can have a link test to see if it works
LIBSYMBOL=""

if test "$PHP_ZORBA_API" != "no"; then

  PHP_SUBST(ZORBA_API_SHARED_LIBADD)

  for LIBNAME in $LIBNAMES ; do
    LIBDIR=""
    for i in $PHP_ZORBA_API $PHP_ZORBA_API/lib /usr/lib /usr/local/lib ; do
      if test -r $i/lib$LIBNAME.a -o -r $i/lib$LIBNAME.so ; then
        LIBDIR="$i"
        break
      fi
    done

    dnl ** and $LIBDIR should be the library path
    if test "$LIBNAME" != "" -a -z "$LIBDIR" ; then
      AC_MSG_RESULT(Library files $LIBNAME not found)
      AC_MSG_ERROR(Is the zorba_api distribution installed properly?)
    else
      AC_MSG_RESULT(Library files $LIBNAME found in $LIBDIR)
      PHP_ADD_LIBRARY_WITH_PATH($LIBNAME, $LIBDIR, ZORBA_API_SHARED_LIBADD)
    fi
  done

  for HNAME in $HNAMES ; do
    INCDIR=""
    for i in $PHP_ZORBA_API $PHP_ZORBA_API/include $PHP_ZORBA_API/includes $PHP_ZORBA_API/inc $PHP_ZORBA_API/incs /usr/local/include /usr/include; do
      if test "$HNAME" != "" -a -r $i/$HNAME ; then
        INCDIR="$i"
        break
      fi
    done

    dnl ** Now $INCDIR should be the include file path
    if test "$HNAME" != "" -a -z "$INCDIR" ; then
      AC_MSG_RESULT(Include files $HNAME not found)
      AC_MSG_ERROR(Is the zorba_api distribution installed properly?)
    else
      AC_MSG_RESULT(Include files $HNAME found in $INCDIR)
      PHP_ADD_INCLUDE($INCDIR)
    fi

  done

  # As this is a C++ module..
  PHP_REQUIRE_CXX
  AC_CHECK_LIB(stdc++, cin)
  if test "$LIBSYMBOL" != "" ; then
    old_LIBS="$LIBS"
    LIBS="$LIBS -L$TEST_DIR/lib -lm -ldl"
    AC_CHECK_LIB($LIBNAME, $LIBSYMBOL, [AC_DEFINE(HAVE_TESTLIB,1,  [ ])],
    [AC_MSG_ERROR(wrong test lib version or lib not found)])
    LIBS="$old_LIBS"
  fi

  AC_DEFINE(HAVE_ZORBA_API, 1, [ ])
dnl  AC_DEFINE_UNQUOTED(PHP_ZORBA_API_DIR, "$ZORBA_API_DIR", [ ])
  PHP_EXTENSION(zorba_api, $ext_shared)
fi
