/**
 * Generated by build-library.php, Please DO NOT modify!
 */

/* $Id: b2d3486c3bca310c730de8575e71b27d2d0ee30d */

static const char* swoole_library_source_constants =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "define('SWOOLE_LIBRARY', true);\n"
    "\n"
    "!defined('CURLOPT_HEADEROPT') && define('CURLOPT_HEADEROPT', 229);\n"
    "!defined('CURLOPT_PROXYHEADER') && define('CURLOPT_PROXYHEADER', 10228);\n";

static const char* swoole_library_source_std_exec =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "function swoole_exec(string $command, &$output = null, &$returnVar = null)\n"
    "{\n"
    "    $result = Swoole\\Coroutine::exec($command);\n"
    "    if ($result) {\n"
    "        $outputList = explode(PHP_EOL, $result['output']);\n"
    "        foreach ($outputList as &$value) {\n"
    "            $value = rtrim($value);\n"
    "        }\n"
    "        if (($endLine = end($outputList)) === '') {\n"
    "            array_pop($outputList);\n"
    "            $endLine = end($outputList);\n"
    "        }\n"
    "        if ($output) {\n"
    "            $output = array_merge($output, $outputList);\n"
    "        } else {\n"
    "            $output = $outputList;\n"
    "        }\n"
    "        $returnVar = $result['code'];\n"
    "        return $endLine;\n"
    "    }\n"
    "    return false;\n"
    "}\n"
    "\n"
    "function swoole_shell_exec(string $cmd)\n"
    "{\n"
    "    $result = Swoole\\Coroutine::exec($cmd);\n"
    "    if ($result && $result['output'] !== '') {\n"
    "        return $result['output'];\n"
    "    }\n"
    "    return null;\n"
    "}\n";

static const char* swoole_library_source_core_constant =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "class Constant\n"
    "{\n"
    "    public const EVENT_RECEIVE = 'receive';\n"
    "\n"
    "    public const EVENT_CONNECT = 'connect';\n"
    "\n"
    "    public const EVENT_CLOSE = 'close';\n"
    "\n"
    "    public const EVENT_PACKET = 'packet';\n"
    "\n"
    "    public const EVENT_REQUEST = 'request';\n"
    "\n"
    "    public const EVENT_MESSAGE = 'message';\n"
    "\n"
    "    public const EVENT_OPEN = 'open';\n"
    "\n"
    "    public const EVENT_HANDSHAKE = 'handshake';\n"
    "\n"
    "    public const EVENT_TASK = 'task';\n"
    "\n"
    "    public const EVENT_FINISH = 'finish';\n"
    "\n"
    "    public const EVENT_START = 'start';\n"
    "\n"
    "    public const EVENT_SHUTDOWN = 'shutdown';\n"
    "\n"
    "    public const EVENT_WORKER_START = 'workerStart';\n"
    "\n"
    "    public const EVENT_WORKER_EXIT = 'workerExit';\n"
    "\n"
    "    public const EVENT_WORKER_ERROR = 'workerError';\n"
    "\n"
    "    public const EVENT_WORKER_STOP = 'workerStop';\n"
    "\n"
    "    public const EVENT_PIPE_MESSAGE = 'pipeMessage';\n"
    "\n"
    "    public const EVENT_MANAGER_START = 'managerStart';\n"
    "\n"
    "    public const EVENT_MANAGER_STOP = 'managerStop';\n"
    "\n"
    "    public const EVENT_ERROR = 'error';\n"
    "\n"
    "    /* {{{ OPTION */\n"
    "    public const OPTION_DEBUG_MODE = 'debug_mode';\n"
    "\n"
    "    public const OPTION_TRACE_FLAGS = 'trace_flags';\n"
    "\n"
    "    public const OPTION_LOG_FILE = 'log_file';\n"
    "\n"
    "    public const OPTION_LOG_LEVEL = 'log_level';\n"
    "\n"
    "    public const OPTION_LOG_DATE_FORMAT = 'log_date_format';\n"
    "\n"
    "    public const OPTION_LOG_DATE_WITH_MICROSECONDS = 'log_date_with_microseconds';\n"
    "\n"
    "    public const OPTION_LOG_ROTATION = 'log_rotation';\n"
    "\n"
    "    public const OPTION_DISPLAY_ERRORS = 'display_errors';\n"
    "\n"
    "    public const OPTION_DNS_SERVER = 'dns_server';\n"
    "\n"
    "    public const OPTION_SOCKET_DNS_TIMEOUT = 'socket_dns_timeout';\n"
    "\n"
    "    public const OPTION_SOCKET_CONNECT_TIMEOUT = 'socket_connect_timeout';\n"
    "\n"
    "    public const OPTION_SOCKET_WRITE_TIMEOUT = 'socket_write_timeout';\n"
    "\n"
    "    public const OPTION_SOCKET_SEND_TIMEOUT = 'socket_send_timeout';\n"
    "\n"
    "    public const OPTION_SOCKET_READ_TIMEOUT = 'socket_read_timeout';\n"
    "\n"
    "    public const OPTION_SOCKET_RECV_TIMEOUT = 'socket_recv_timeout';\n"
    "\n"
    "    public const OPTION_SOCKET_BUFFER_SIZE = 'socket_buffer_size';\n"
    "\n"
    "    public const OPTION_SOCKET_TIMEOUT = 'socket_timeout';\n"
    "\n"
    "    public const OPTION_AIO_CORE_WORKER_NUM = 'aio_core_worker_num';\n"
    "\n"
    "    public const OPTION_AIO_WORKER_NUM = 'aio_worker_num';\n"
    "\n"
    "    public const OPTION_AIO_MAX_WAIT_TIME = 'aio_max_wait_time';\n"
    "\n"
    "    public const OPTION_AIO_MAX_IDLE_TIME = 'aio_max_idle_time';\n"
    "\n"
    "    public const OPTION_ENABLE_SIGNALFD = 'enable_signalfd';\n"
    "\n"
    "    public const OPTION_WAIT_SIGNAL = 'wait_signal';\n"
    "\n"
    "    public const OPTION_DNS_CACHE_REFRESH_TIME = 'dns_cache_refresh_time';\n"
    "\n"
    "    public const OPTION_THREAD_NUM = 'thread_num';\n"
    "\n"
    "    public const OPTION_MIN_THREAD_NUM = 'min_thread_num';\n"
    "\n"
    "    public const OPTION_MAX_THREAD_NUM = 'max_thread_num';\n"
    "\n"
    "    public const OPTION_SOCKET_DONTWAIT = 'socket_dontwait';\n"
    "\n"
    "    public const OPTION_DNS_LOOKUP_RANDOM = 'dns_lookup_random';\n"
    "\n"
    "    public const OPTION_USE_ASYNC_RESOLVER = 'use_async_resolver';\n"
    "\n"
    "    public const OPTION_ENABLE_COROUTINE = 'enable_coroutine';\n"
    "\n"
    "    public const OPTION_SSL_PROTOCOLS = 'ssl_protocols';\n"
    "\n"
    "    public const OPTION_SSL_COMPRESS = 'ssl_compress';\n"
    "\n"
    "    public const OPTION_SSL_CERT_FILE = 'ssl_cert_file';\n"
    "\n"
    "    public const OPTION_SSL_KEY_FILE = 'ssl_key_file';\n"
    "\n"
    "    public const OPTION_SSL_PASSPHRASE = 'ssl_passphrase';\n"
    "\n"
    "    public const OPTION_SSL_HOST_NAME = 'ssl_host_name';\n"
    "\n"
    "    public const OPTION_SSL_VERIFY_PEER = 'ssl_verify_peer';\n"
    "\n"
    "    public const OPTION_SSL_ALLOW_SELF_SIGNED = 'ssl_allow_self_signed';\n"
    "\n"
    "    public const OPTION_SSL_CAFILE = 'ssl_cafile';\n"
    "\n"
    "    public const OPTION_SSL_CAPATH = 'ssl_capath';\n"
    "\n"
    "    public const OPTION_SSL_VERIFY_DEPTH = 'ssl_verify_depth';\n"
    "\n"
    "    public const OPTION_OPEN_EOF_CHECK = 'open_eof_check';\n"
    "\n"
    "    public const OPTION_OPEN_EOF_SPLIT = 'open_eof_split';\n"
    "\n"
    "    public const OPTION_PACKAGE_EOF = 'package_eof';\n"
    "\n"
    "    public const OPTION_OPEN_MQTT_PROTOCOL = 'open_mqtt_protocol';\n"
    "\n"
    "    public const OPTION_OPEN_LENGTH_CHECK = 'open_length_check';\n"
    "\n"
    "    public const OPTION_PACKAGE_LENGTH_TYPE = 'package_length_type';\n"
    "\n"
    "    public const OPTION_PACKAGE_LENGTH_OFFSET = 'package_length_offset';\n"
    "\n"
    "    public const OPTION_PACKAGE_BODY_OFFSET = 'package_body_offset';\n"
    "\n"
    "    public const OPTION_PACKAGE_LENGTH_FUNC = 'package_length_func';\n"
    "\n"
    "    public const OPTION_PACKAGE_MAX_LENGTH = 'package_max_length';\n"
    "\n"
    "    public const OPTION_BUFFER_HIGH_WATERMARK = 'buffer_high_watermark';\n"
    "\n"
    "    public const OPTION_BUFFER_LOW_WATERMARK = 'buffer_low_watermark';\n"
    "\n"
    "    public const OPTION_BIND_PORT = 'bind_port';\n"
    "\n"
    "    public const OPTION_BIND_ADDRESS = 'bind_address';\n"
    "\n"
    "    public const OPTION_OPEN_TCP_NODELAY = 'open_tcp_nodelay';\n"
    "\n"
    "    public const OPTION_SOCKS5_HOST = 'socks5_host';\n"
    "\n"
    "    public const OPTION_SOCKS5_PORT = 'socks5_port';\n"
    "\n"
    "    public const OPTION_SOCKS5_USERNAME = 'socks5_username';\n"
    "\n"
    "    public const OPTION_SOCKS5_PASSWORD = 'socks5_password';\n"
    "\n"
    "    public const OPTION_HTTP_PROXY_HOST = 'http_proxy_host';\n"
    "\n"
    "    public const OPTION_HTTP_PROXY_PORT = 'http_proxy_port';\n"
    "\n"
    "    public const OPTION_HTTP_PROXY_USERNAME = 'http_proxy_username';\n"
    "\n"
    "    public const OPTION_HTTP_PROXY_USER = 'http_proxy_user';\n"
    "\n"
    "    public const OPTION_HTTP_PROXY_PASSWORD = 'http_proxy_password';\n"
    "\n"
    "    public const OPTION_TIMEOUT = 'timeout';\n"
    "\n"
    "    public const OPTION_CONNECT_TIMEOUT = 'connect_timeout';\n"
    "\n"
    "    public const OPTION_READ_TIMEOUT = 'read_timeout';\n"
    "\n"
    "    public const OPTION_WRITE_TIMEOUT = 'write_timeout';\n"
    "\n"
    "    public const OPTION_SSL_DISABLE_COMPRESSION = 'ssl_disable_compression';\n"
    "\n"
    "    public const OPTION_MAX_CORO_NUM = 'max_coro_num';\n"
    "\n"
    "    public const OPTION_MAX_COROUTINE = 'max_coroutine';\n"
    "\n"
    "    public const OPTION_ENABLE_DEADLOCK_CHECK = 'enable_deadlock_check';\n"
    "\n"
    "    public const OPTION_HOOK_FLAGS = 'hook_flags';\n"
    "\n"
    "    public const OPTION_ENABLE_PREEMPTIVE_SCHEDULER = 'enable_preemptive_scheduler';\n"
    "\n"
    "    public const OPTION_C_STACK_SIZE = 'c_stack_size';\n"
    "\n"
    "    public const OPTION_STACK_SIZE = 'stack_size';\n"
    "\n"
    "    public const OPTION_DNS_CACHE_EXPIRE = 'dns_cache_expire';\n"
    "\n"
    "    public const OPTION_DNS_CACHE_CAPACITY = 'dns_cache_capacity';\n"
    "\n"
    "    public const OPTION_RECONNECT = 'reconnect';\n"
    "\n"
    "    public const OPTION_DEFER = 'defer';\n"
    "\n"
    "    public const OPTION_LOWERCASE_HEADER = 'lowercase_header';\n"
    "\n"
    "    public const OPTION_KEEP_ALIVE = 'keep_alive';\n"
    "\n"
    "    public const OPTION_WEBSOCKET_MASK = 'websocket_mask';\n"
    "\n"
    "    public const OPTION_WEBSOCKET_COMPRESSION = 'websocket_compression';\n"
    "\n"
    "    public const OPTION_HTTP_PARSE_COOKIE = 'http_parse_cookie';\n"
    "\n"
    "    public const OPTION_HTTP_PARSE_POST = 'http_parse_post';\n"
    "\n"
    "    public const OPTION_HTTP_PARSE_FILES = 'http_parse_files';\n"
    "\n"
    "    public const OPTION_HTTP_COMPRESSION = 'http_compression';\n"
    "\n"
    "    public const OPTION_HTTP_COMPRESSION_LEVEL = 'http_compression_level';\n"
    "\n"
    "    public const OPTION_HTTP_GZIP_LEVEL = 'http_gzip_level';\n"
    "\n"
    "    public const OPTION_COMPRESSION_MIN_LENGTH = 'compression_min_length';\n"
    "\n"
    "    public const OPTION_UPLOAD_TMP_DIR = 'upload_tmp_dir';\n"
    "\n"
    "    public const OPTION_HOST = 'host';\n"
    "\n"
    "    public const OPTION_PORT = 'port';\n"
    "\n"
    "    public const OPTION_SSL = 'ssl';\n"
    "\n"
    "    public const OPTION_USER = 'user';\n"
    "\n"
    "    public const OPTION_PASSWORD = 'password';\n"
    "\n"
    "    public const OPTION_DATABASE = 'database';\n"
    "\n"
    "    public const OPTION_CHARSET = 'charset';\n"
    "\n"
    "    public const OPTION_STRICT_TYPE = 'strict_type';\n"
    "\n"
    "    public const OPTION_FETCH_MODE = 'fetch_mode';\n"
    "\n"
    "    public const OPTION_SERIALIZE = 'serialize';\n"
    "\n"
    "    public const OPTION_COMPATIBILITY_MODE = 'compatibility_mode';\n"
    "\n"
    "    public const OPTION_CHROOT = 'chroot';\n"
    "\n"
    "    public const OPTION_GROUP = 'group';\n"
    "\n"
    "    public const OPTION_DAEMONIZE = 'daemonize';\n"
    "\n"
    "    public const OPTION_PID_FILE = 'pid_file';\n"
    "\n"
    "    public const OPTION_REACTOR_NUM = 'reactor_num';\n"
    "\n"
    "    public const OPTION_SINGLE_THREAD = 'single_thread';\n"
    "\n"
    "    public const OPTION_WORKER_NUM = 'worker_num';\n"
    "\n"
    "    public const OPTION_MAX_WAIT_TIME = 'max_wait_time';\n"
    "\n"
    "    public const OPTION_MAX_QUEUED_BYTES = 'max_queued_bytes';\n"
    "\n"
    "    public const OPTION_SEND_TIMEOUT = 'send_timeout';\n"
    "\n"
    "    public const OPTION_DISPATCH_MODE = 'dispatch_mode';\n"
    "\n"
    "    public const OPTION_SEND_YIELD = 'send_yield';\n"
    "\n"
    "    public const OPTION_DISPATCH_FUNC = 'dispatch_func';\n"
    "\n"
    "    public const OPTION_DISCARD_TIMEOUT_REQUEST = 'discard_timeout_request';\n"
    "\n"
    "    public const OPTION_ENABLE_UNSAFE_EVENT = 'enable_unsafe_event';\n"
    "\n"
    "    public const OPTION_ENABLE_DELAY_RECEIVE = 'enable_delay_receive';\n"
    "\n"
    "    public const OPTION_ENABLE_REUSE_PORT = 'enable_reuse_port';\n"
    "\n"
    "    public const OPTION_TASK_USE_OBJECT = 'task_use_object';\n"
    "\n"
    "    public const OPTION_TASK_OBJECT = 'task_object';\n"
    "\n"
    "    public const OPTION_EVENT_OBJECT = 'event_object';\n"
    "\n"
    "    public const OPTION_TASK_ENABLE_COROUTINE = 'task_enable_coroutine';\n"
    "\n"
    "    public const OPTION_TASK_WORKER_NUM = 'task_worker_num';\n"
    "\n"
    "    public const OPTION_TASK_IPC_MODE = 'task_ipc_mode';\n"
    "\n"
    "    public const OPTION_TASK_TMPDIR = 'task_tmpdir';\n"
    "\n"
    "    public const OPTION_TASK_MAX_REQUEST = 'task_max_request';\n"
    "\n"
    "    public const OPTION_TASK_MAX_REQUEST_GRACE = 'task_max_request_grace';\n"
    "\n"
    "    public const OPTION_MAX_CONNECTION = 'max_connection';\n"
    "\n"
    "    public const OPTION_MAX_CONN = 'max_conn';\n"
    "\n"
    "    public const OPTION_START_SESSION_ID = 'start_session_id';\n"
    "\n"
    "    public const OPTION_HEARTBEAT_CHECK_INTERVAL = 'heartbeat_check_interval';\n"
    "\n"
    "    public const OPTION_HEARTBEAT_IDLE_TIME = 'heartbeat_idle_time';\n"
    "\n"
    "    public const OPTION_MAX_REQUEST = 'max_request';\n"
    "\n"
    "    public const OPTION_MAX_REQUEST_GRACE = 'max_request_grace';\n"
    "\n"
    "    public const OPTION_RELOAD_ASYNC = 'reload_async';\n"
    "\n"
    "    public const OPTION_OPEN_CPU_AFFINITY = 'open_cpu_affinity';\n"
    "\n"
    "    public const OPTION_CPU_AFFINITY_IGNORE = 'cpu_affinity_ignore';\n"
    "\n"
    "    public const OPTION_ENABLE_STATIC_HANDLER = 'enable_static_handler';\n"
    "\n"
    "    public const OPTION_DOCUMENT_ROOT = 'document_root';\n"
    "\n"
    "    public const OPTION_HTTP_AUTOINDEX = 'http_autoindex';\n"
    "\n"
    "    public const OPTION_HTTP_INDEX_FILES = 'http_index_files';\n"
    "\n"
    "    public const OPTION_STATIC_HANDLER_LOCATIONS = 'static_handler_locations';\n"
    "\n"
    "    public const OPTION_INPUT_BUFFER_SIZE = 'input_buffer_size';\n"
    "\n"
    "    public const OPTION_BUFFER_INPUT_SIZE = 'buffer_input_size';\n"
    "\n"
    "    public const OPTION_OUTPUT_BUFFER_SIZE = 'output_buffer_size';\n"
    "\n"
    "    public const OPTION_BUFFER_OUTPUT_SIZE = 'buffer_output_size';\n"
    "\n"
    "    public const OPTION_MESSAGE_QUEUE_KEY = 'message_queue_key';\n"
    "\n"
    "    public const OPTION_BACKLOG = 'backlog';\n"
    "\n"
    "    public const OPTION_KERNEL_SOCKET_RECV_BUFFER_SIZE = 'kernel_socket_recv_buffer_size';\n"
    "\n"
    "    public const OPTION_KERNEL_SOCKET_SEND_BUFFER_SIZE = 'kernel_socket_send_buffer_size';\n"
    "\n"
    "    public const OPTION_TCP_DEFER_ACCEPT = 'tcp_defer_accept';\n"
    "\n"
    "    public const OPTION_OPEN_TCP_KEEPALIVE = 'open_tcp_keepalive';\n"
    "\n"
    "    public const OPTION_OPEN_HTTP_PROTOCOL = 'open_http_protocol';\n"
    "\n"
    "    public const OPTION_OPEN_WEBSOCKET_PROTOCOL = 'open_websocket_protocol';\n"
    "\n"
    "    public const OPTION_WEBSOCKET_SUBPROTOCOL = 'websocket_subprotocol';\n"
    "\n"
    "    public const OPTION_OPEN_WEBSOCKET_CLOSE_FRAME = 'open_websocket_close_frame';\n"
    "\n"
    "    public const OPTION_OPEN_WEBSOCKET_PING_FRAME = 'open_websocket_ping_frame';\n"
    "\n"
    "    public const OPTION_OPEN_WEBSOCKET_PONG_FRAME = 'open_websocket_pong_frame';\n"
    "\n"
    "    public const OPTION_OPEN_HTTP2_PROTOCOL = 'open_http2_protocol';\n"
    "\n"
    "    public const OPTION_OPEN_REDIS_PROTOCOL = 'open_redis_protocol';\n"
    "\n"
    "    public const OPTION_MAX_IDLE_TIME = 'max_idle_time';\n"
    "\n"
    "    public const OPTION_TCP_KEEPIDLE = 'tcp_keepidle';\n"
    "\n"
    "    public const OPTION_TCP_KEEPINTERVAL = 'tcp_keepinterval';\n"
    "\n"
    "    public const OPTION_TCP_KEEPCOUNT = 'tcp_keepcount';\n"
    "\n"
    "    public const OPTION_TCP_USER_TIMEOUT = 'tcp_user_timeout';\n"
    "\n"
    "    public const OPTION_TCP_FASTOPEN = 'tcp_fastopen';\n"
    "\n"
    "    public const OPTION_PACKAGE_BODY_START = 'package_body_start';\n"
    "\n"
    "    public const OPTION_SSL_CLIENT_CERT_FILE = 'ssl_client_cert_file';\n"
    "\n"
    "    public const OPTION_SSL_PREFER_SERVER_CIPHERS = 'ssl_prefer_server_ciphers';\n"
    "\n"
    "    public const OPTION_SSL_CIPHERS = 'ssl_ciphers';\n"
    "\n"
    "    public const OPTION_SSL_ECDH_CURVE = 'ssl_ecdh_curve';\n"
    "\n"
    "    public const OPTION_SSL_DHPARAM = 'ssl_dhparam';\n"
    "\n"
    "    public const OPTION_SSL_SNI_CERTS = 'ssl_sni_certs';\n"
    "\n"
    "    public const OPTION_OPEN_SSL = 'open_ssl';\n"
    "\n"
    "    public const OPTION_OPEN_FASTCGI_PROTOCOL = 'open_fastcgi_protocol';\n"
    "\n"
    "    /* }}} OPTION */\n"
    "}\n";

static const char* swoole_library_source_core_string_object =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "class StringObject\n"
    "{\n"
    "    /**\n"
    "     * @var string\n"
    "     */\n"
    "    protected $string;\n"
    "\n"
    "    /**\n"
    "     * StringObject constructor.\n"
    "     */\n"
    "    public function __construct(string $string = '')\n"
    "    {\n"
    "        $this->string = $string;\n"
    "    }\n"
    "\n"
    "    public function __toString(): string\n"
    "    {\n"
    "        return $this->string;\n"
    "    }\n"
    "\n"
    "    public function length(): int\n"
    "    {\n"
    "        return strlen($this->string);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function indexOf(string $needle, int $offset = 0)\n"
    "    {\n"
    "        return strpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function lastIndexOf(string $needle, int $offset = 0)\n"
    "    {\n"
    "        return strrpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function pos(string $needle, int $offset = 0)\n"
    "    {\n"
    "        return strpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function rpos(string $needle, int $offset = 0)\n"
    "    {\n"
    "        return strrpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function ipos(string $needle)\n"
    "    {\n"
    "        return stripos($this->string, $needle);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function lower(): self\n"
    "    {\n"
    "        return new static(strtolower($this->string));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function upper(): self\n"
    "    {\n"
    "        return new static(strtoupper($this->string));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function trim(): self\n"
    "    {\n"
    "        return new static(trim($this->string));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function ltrim(): self\n"
    "    {\n"
    "        return new static(ltrim($this->string));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function rtrim(): self\n"
    "    {\n"
    "        return new static(rtrim($this->string));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function substr(int $offset, ?int $length = null)\n"
    "    {\n"
    "        return new static(substr($this->string, ...func_get_args()));\n"
    "    }\n"
    "\n"
    "    public function repeat(int $n): StringObject\n"
    "    {\n"
    "        return new static(str_repeat($this->string, $n));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $str\n"
    "     */\n"
    "    public function append($str): StringObject\n"
    "    {\n"
    "        if (is_string($str)) {\n"
    "            $this->string .= $str;\n"
    "        } else {\n"
    "            $this->string .= strval($str);\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param null|int $count\n"
    "     * @return static\n"
    "     */\n"
    "    public function replace(string $search, string $replace, &$count = null)\n"
    "    {\n"
    "        return new static(str_replace($search, $replace, $this->string, $count));\n"
    "    }\n"
    "\n"
    "    public function startsWith(string $needle): bool\n"
    "    {\n"
    "        return strpos($this->string, $needle) === 0;\n"
    "    }\n"
    "\n"
    "    public function endsWith(string $needle): bool\n"
    "    {\n"
    "        return strrpos($this->string, $needle) === (strlen($this->string) - strlen($needle));\n"
    "    }\n"
    "\n"
    "    public function equals($str, bool $strict = false): bool\n"
    "    {\n"
    "        if ($str instanceof StringObject) {\n"
    "            $str = strval($str);\n"
    "        }\n"
    "        if ($strict) {\n"
    "            return $this->string === $str;\n"
    "        }\n"
    "        return $this->string == $str;\n"
    "    }\n"
    "\n"
    "    public function contains(string $subString): bool\n"
    "    {\n"
    "        return strpos($this->string, $subString) !== false;\n"
    "    }\n"
    "\n"
    "    public function split(string $delimiter, int $limit = PHP_INT_MAX): ArrayObject\n"
    "    {\n"
    "        return static::detectArrayType(explode($delimiter, $this->string, $limit));\n"
    "    }\n"
    "\n"
    "    public function char(int $index): string\n"
    "    {\n"
    "        if ($index > strlen($this->string)) {\n"
    "            return '';\n"
    "        }\n"
    "        return $this->string[$index];\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function chunkSplit(int $chunkLength = 76, string $chunkEnd = '')\n"
    "    {\n"
    "        return new static(chunk_split($this->string, ...func_get_args()));\n"
    "    }\n"
    "\n"
    "    public function chunk(int $splitLength = 1): ArrayObject\n"
    "    {\n"
    "        return static::detectArrayType(str_split($this->string, ...func_get_args()));\n"
    "    }\n"
    "\n"
    "    public function toString(): string\n"
    "    {\n"
    "        return $this->string;\n"
    "    }\n"
    "\n"
    "    protected static function detectArrayType(array $value): ArrayObject\n"
    "    {\n"
    "        return new ArrayObject($value);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_multibyte_string_object =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "class MultibyteStringObject extends StringObject\n"
    "{\n"
    "    public function length(): int\n"
    "    {\n"
    "        return mb_strlen($this->string);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function indexOf(string $needle, int $offset = 0, ?string $encoding = null)\n"
    "    {\n"
    "        return mb_strpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function lastIndexOf(string $needle, int $offset = 0, ?string $encoding = null)\n"
    "    {\n"
    "        return mb_strrpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function pos(string $needle, int $offset = 0, ?string $encoding = null)\n"
    "    {\n"
    "        return mb_strpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function rpos(string $needle, int $offset = 0, ?string $encoding = null)\n"
    "    {\n"
    "        return mb_strrpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function ipos(string $needle, ?string $encoding = null)\n"
    "    {\n"
    "        return mb_stripos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function substr(int $offset, ?int $length = null, ?string $encoding = null)\n"
    "    {\n"
    "        return new static(mb_substr($this->string, ...func_get_args()));\n"
    "    }\n"
    "\n"
    "    public function chunk(int $splitLength = 1, ?int $limit = null): ArrayObject\n"
    "    {\n"
    "        return static::detectArrayType(mb_split($this->string, ...func_get_args()));\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_exception_array_key_not_exists =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Exception;\n"
    "\n"
    "class ArrayKeyNotExists extends \\RuntimeException\n"
    "{\n"
    "}\n";

static const char* swoole_library_source_core_array_object =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "use ArrayAccess;\n"
    "use Countable;\n"
    "use Iterator;\n"
    "use RuntimeException;\n"
    "use Serializable;\n"
    "use Swoole\\Exception\\ArrayKeyNotExists;\n"
    "\n"
    "class ArrayObject implements ArrayAccess, Serializable, Countable, Iterator\n"
    "{\n"
    "    /**\n"
    "     * @var array\n"
    "     */\n"
    "    protected $array;\n"
    "\n"
    "    /**\n"
    "     * ArrayObject constructor.\n"
    "     */\n"
    "    public function __construct(array $array = [])\n"
    "    {\n"
    "        $this->array = $array;\n"
    "    }\n"
    "\n"
    "    public function __toArray(): array\n"
    "    {\n"
    "        return $this->array;\n"
    "    }\n"
    "\n"
    "    public function toArray(): array\n"
    "    {\n"
    "        return $this->array;\n"
    "    }\n"
    "\n"
    "    public function isEmpty(): bool\n"
    "    {\n"
    "        return empty($this->array);\n"
    "    }\n"
    "\n"
    "    public function count(): int\n"
    "    {\n"
    "        return count($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function current()\n"
    "    {\n"
    "        return current($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function key()\n"
    "    {\n"
    "        return key($this->array);\n"
    "    }\n"
    "\n"
    "    public function valid(): bool\n"
    "    {\n"
    "        return array_key_exists($this->key(), $this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function rewind()\n"
    "    {\n"
    "        return reset($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function next()\n"
    "    {\n"
    "        return next($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     * @return ArrayObject|StringObject\n"
    "     */\n"
    "    public function get($key)\n"
    "    {\n"
    "        if (!$this->exists($key)) {\n"
    "            throw new ArrayKeyNotExists($key);\n"
    "        }\n"
    "        return static::detectType($this->array[$key]);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function last()\n"
    "    {\n"
    "        $key = array_key_last($this->array);\n"
    "        if ($key === null) {\n"
    "            return null;\n"
    "        }\n"
    "        return $this->get($key);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return null|int|string\n"
    "     */\n"
    "    public function firstKey()\n"
    "    {\n"
    "        return array_key_first($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return null|int|string\n"
    "     */\n"
    "    public function lastKey()\n"
    "    {\n"
    "        return array_key_last($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function first()\n"
    "    {\n"
    "        $key = array_key_first($this->array);\n"
    "        if ($key === null) {\n"
    "            return null;\n"
    "        }\n"
    "        return $this->get($key);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     * @param mixed $value\n"
    "     * @return $this\n"
    "     */\n"
    "    public function set($key, $value): self\n"
    "    {\n"
    "        $this->array[$key] = $value;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     * @return $this\n"
    "     */\n"
    "    public function delete($key): self\n"
    "    {\n"
    "        unset($this->array[$key]);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return $this\n"
    "     */\n"
    "    public function remove($value, bool $strict = true, bool $loop = false): self\n"
    "    {\n"
    "        do {\n"
    "            $key = $this->search($value, $strict);\n"
    "            if ($key === false) {\n"
    "                break;\n"
    "            }\n"
    "            unset($this->array[$key]);\n"
    "        } while ($loop);\n"
    "\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function clear(): self\n"
    "    {\n"
    "        $this->array = [];\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     * @return null|mixed\n"
    "     */\n"
    "    public function offsetGet($key)\n"
    "    {\n"
    "        if (!array_key_exists($key, $this->array)) {\n"
    "            return null;\n"
    "        }\n"
    "        return $this->array[$key];\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     * @param mixed $value\n"
    "     */\n"
    "    public function offsetSet($key, $value): void\n"
    "    {\n"
    "        $this->array[$key] = $value;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     */\n"
    "    public function offsetUnset($key): void\n"
    "    {\n"
    "        unset($this->array[$key]);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     * @return bool\n"
    "     */\n"
    "    public function offsetExists($key)\n"
    "    {\n"
    "        return isset($this->array[$key]);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     */\n"
    "    public function exists($key): bool\n"
    "    {\n"
    "        return array_key_exists($key, $this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     */\n"
    "    public function contains($value, bool $strict = true): bool\n"
    "    {\n"
    "        return in_array($value, $this->array, $strict);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function indexOf($value, bool $strict = true)\n"
    "    {\n"
    "        return $this->search($value, $strict);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function lastIndexOf($value, bool $strict = true)\n"
    "    {\n"
    "        $array = $this->array;\n"
    "        for (end($array); ($currentKey = key($array)) !== null; prev($array)) {\n"
    "            $currentValue = current($array);\n"
    "            if ($currentValue == $value) {\n"
    "                if ($strict && $currentValue !== $value) {\n"
    "                    continue;\n"
    "                }\n"
    "                break;\n"
    "            }\n"
    "        }\n"
    "        return $currentKey;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $needle\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function search($needle, bool $strict = true)\n"
    "    {\n"
    "        return array_search($needle, $this->array, $strict);\n"
    "    }\n"
    "\n"
    "    public function join(string $glue = ''): StringObject\n"
    "    {\n"
    "        return static::detectStringType(implode($glue, $this->array));\n"
    "    }\n"
    "\n"
    "    public function serialize(): StringObject\n"
    "    {\n"
    "        return static::detectStringType(serialize($this->array));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param string $string\n"
    "     * @return $this\n"
    "     */\n"
    "    public function unserialize($string): self\n"
    "    {\n"
    "        $this->array = (array) unserialize((string) $string);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return float|int\n"
    "     */\n"
    "    public function sum()\n"
    "    {\n"
    "        return array_sum($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return float|int\n"
    "     */\n"
    "    public function product()\n"
    "    {\n"
    "        return array_product($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return int\n"
    "     */\n"
    "    public function push($value)\n"
    "    {\n"
    "        return $this->pushBack($value);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return int\n"
    "     */\n"
    "    public function pushFront($value)\n"
    "    {\n"
    "        return array_unshift($this->array, $value);\n"
    "    }\n"
    "\n"
    "    public function append(...$values): ArrayObject\n"
    "    {\n"
    "        array_push($this->array, ...$values);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return int\n"
    "     */\n"
    "    public function pushBack($value)\n"
    "    {\n"
    "        return array_push($this->array, $value);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return $this\n"
    "     */\n"
    "    public function insert(int $offset, $value): self\n"
    "    {\n"
    "        if (is_array($value) || is_object($value) || is_null($value)) {\n"
    "            $value = [$value];\n"
    "        }\n"
    "        array_splice($this->array, $offset, 0, $value);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function pop()\n"
    "    {\n"
    "        return $this->popBack();\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function popFront()\n"
    "    {\n"
    "        return array_shift($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function popBack()\n"
    "    {\n"
    "        return array_pop($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $offset\n"
    "     * @param int $length\n"
    "     * @return static\n"
    "     */\n"
    "    public function slice($offset, int $length = null, bool $preserve_keys = false): self\n"
    "    {\n"
    "        return new static(array_slice($this->array, ...func_get_args()));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return ArrayObject|mixed|StringObject\n"
    "     */\n"
    "    public function randomGet()\n"
    "    {\n"
    "        return static::detectType($this->array[array_rand($this->array, 1)]);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function each(callable $fn): self\n"
    "    {\n"
    "        if (array_walk($this->array, $fn) === false) {\n"
    "            throw new RuntimeException('array_walk() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param array $args\n"
    "     * @return static\n"
    "     */\n"
    "    public function map(callable $fn, ...$args): self\n"
    "    {\n"
    "        return new static(array_map($fn, $this->array, ...$args));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param null $initial\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function reduce(callable $fn, $initial = null)\n"
    "    {\n"
    "        return array_reduce($this->array, $fn, $initial);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param array $args\n"
    "     * @return static\n"
    "     */\n"
    "    public function keys(...$args): self\n"
    "    {\n"
    "        return new static(array_keys($this->array, ...$args));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function values(): self\n"
    "    {\n"
    "        return new static(array_values($this->array));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $column_key\n"
    "     * @param mixed $index\n"
    "     * @return static\n"
    "     */\n"
    "    public function column($column_key, $index = null): self\n"
    "    {\n"
    "        return new static(array_column($this->array, $column_key, $index));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function unique(int $sort_flags = SORT_STRING): self\n"
    "    {\n"
    "        return new static(array_unique($this->array, $sort_flags));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function reverse(bool $preserve_keys = false): self\n"
    "    {\n"
    "        return new static(array_reverse($this->array, $preserve_keys));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function chunk(int $size, bool $preserve_keys = false): self\n"
    "    {\n"
    "        return new static(array_chunk($this->array, $size, $preserve_keys));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Swap keys and values in an array.\n"
    "     * @return static\n"
    "     */\n"
    "    public function flip(): self\n"
    "    {\n"
    "        return new static(array_flip($this->array));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function filter(callable $fn, int $flag = 0): self\n"
    "    {\n"
    "        return new static(array_filter($this->array, $fn, $flag));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * | Function name     | Sorts by | Maintains key association   | Order of sort               | Related functions |\n"
    "     * | :---------------- | :------- | :-------------------------- | :-------------------------- | :---------------- |\n"
    "     * | array_multisort() | value    | associative yes, numeric no | first array or sort options  | array_walk()      |\n"
    "     * | asort()           | value    | yes                         | low to high                 | arsort()          |\n"
    "     * | arsort()          | value    | yes                         | high to low                 | asort()           |\n"
    "     * | krsort()          | key      | yes                         | high to low                 | ksort()           |\n"
    "     * | ksort()           | key      | yes                         | low to high                 | asort()           |\n"
    "     * | natcasesort()     | value    | yes                         | natural, case insensitive   | natsort()         |\n"
    "     * | natsort()         | value    | yes                         | natural                     | natcasesort()     |\n"
    "     * | rsort()           | value    | no                          | high to low                 | sort()            |\n"
    "     * | shuffle()          | value    | no                          | random                      | array_rand()      |\n"
    "     * | sort()            | value    | no                          | low to high                 | rsort()           |\n"
    "     * | uasort()          | value    | yes                         | user defined                 | uksort()          |\n"
    "     * | uksort()          | key      | yes                         | user defined                 | uasort()          |\n"
    "     * | usort()           | value    | no                          | user defined                 | uasort()          |\n"
    "     */\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function asort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (asort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('asort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function arsort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (arsort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('arsort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function krsort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (krsort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('krsort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function ksort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (ksort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('ksort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function natcasesort(): self\n"
    "    {\n"
    "        if (natcasesort($this->array) !== true) {\n"
    "            throw new RuntimeException('natcasesort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function natsort(): self\n"
    "    {\n"
    "        if (natsort($this->array) !== true) {\n"
    "            throw new RuntimeException('natsort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function rsort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (rsort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('rsort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function shuffle(): self\n"
    "    {\n"
    "        if (shuffle($this->array) !== true) {\n"
    "            throw new RuntimeException('shuffle() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function sort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (sort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('sort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function uasort(callable $value_compare_func): self\n"
    "    {\n"
    "        if (uasort($this->array, $value_compare_func) !== true) {\n"
    "            throw new RuntimeException('uasort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function uksort(callable $value_compare_func): self\n"
    "    {\n"
    "        if (uksort($this->array, $value_compare_func) !== true) {\n"
    "            throw new RuntimeException('uksort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function usort(callable $value_compare_func): self\n"
    "    {\n"
    "        if (usort($this->array, $value_compare_func) !== true) {\n"
    "            throw new RuntimeException('usort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return ArrayObject|mixed|StringObject\n"
    "     */\n"
    "    protected static function detectType($value)\n"
    "    {\n"
    "        if (is_string($value)) {\n"
    "            return static::detectStringType($value);\n"
    "        }\n"
    "        if (is_array($value)) {\n"
    "            return static::detectArrayType($value);\n"
    "        }\n"
    "        return $value;\n"
    "    }\n"
    "\n"
    "    protected static function detectStringType(string $value): StringObject\n"
    "    {\n"
    "        return new StringObject($value);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    protected static function detectArrayType(array $value): self\n"
    "    {\n"
    "        return new static($value);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_object_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "use TypeError;\n"
    "\n"
    "class ObjectProxy\n"
    "{\n"
    "    /** @var object */\n"
    "    protected $__object;\n"
    "\n"
    "    public function __construct($object)\n"
    "    {\n"
    "        if (!is_object($object)) {\n"
    "            throw new TypeError('Non-object given');\n"
    "        }\n"
    "        $this->__object = $object;\n"
    "    }\n"
    "\n"
    "    public function __getObject()\n"
    "    {\n"
    "        return $this->__object;\n"
    "    }\n"
    "\n"
    "    public function __get(string $name)\n"
    "    {\n"
    "        return $this->__object->{$name};\n"
    "    }\n"
    "\n"
    "    public function __set(string $name, $value): void\n"
    "    {\n"
    "        $this->__object->{$name} = $value;\n"
    "    }\n"
    "\n"
    "    public function __isset($name)\n"
    "    {\n"
    "        return isset($this->__object->{$name});\n"
    "    }\n"
    "\n"
    "    public function __unset(string $name): void\n"
    "    {\n"
    "        unset($this->__object->{$name});\n"
    "    }\n"
    "\n"
    "    public function __call(string $name, array $arguments)\n"
    "    {\n"
    "        return $this->__object->{$name}(...$arguments);\n"
    "    }\n"
    "\n"
    "    public function __invoke(...$arguments)\n"
    "    {\n"
    "        /** @var mixed $object */\n"
    "        $object = $this->__object;\n"
    "        return $object(...$arguments);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_wait_group =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine;\n"
    "\n"
    "use BadMethodCallException;\n"
    "use InvalidArgumentException;\n"
    "\n"
    "class WaitGroup\n"
    "{\n"
    "    protected $chan;\n"
    "\n"
    "    protected $count = 0;\n"
    "\n"
    "    protected $waiting = false;\n"
    "\n"
    "    public function __construct(int $delta = 0)\n"
    "    {\n"
    "        $this->chan = new Channel(1);\n"
    "        if ($delta > 0) {\n"
    "            $this->add($delta);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function add(int $delta = 1): void\n"
    "    {\n"
    "        if ($this->waiting) {\n"
    "            throw new BadMethodCallException('WaitGroup misuse: add called concurrently with wait');\n"
    "        }\n"
    "        $count = $this->count + $delta;\n"
    "        if ($count < 0) {\n"
    "            throw new InvalidArgumentException('WaitGroup misuse: negative counter');\n"
    "        }\n"
    "        $this->count = $count;\n"
    "    }\n"
    "\n"
    "    public function done(): void\n"
    "    {\n"
    "        $count = $this->count - 1;\n"
    "        if ($count < 0) {\n"
    "            throw new BadMethodCallException('WaitGroup misuse: negative counter');\n"
    "        }\n"
    "        $this->count = $count;\n"
    "        if ($count === 0 && $this->waiting) {\n"
    "            $this->chan->push(true);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function wait(float $timeout = -1): bool\n"
    "    {\n"
    "        if ($this->waiting) {\n"
    "            throw new BadMethodCallException('WaitGroup misuse: reused before previous wait has returned');\n"
    "        }\n"
    "        if ($this->count > 0) {\n"
    "            $this->waiting = true;\n"
    "            $done = $this->chan->pop($timeout);\n"
    "            $this->waiting = false;\n"
    "            return $done;\n"
    "        }\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    public function count(): int\n"
    "    {\n"
    "        return $this->count;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_server =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine;\n"
    "\n"
    "use Swoole\\Coroutine;\n"
    "use Swoole\\Coroutine\\Server\\Connection;\n"
    "use Swoole\\Exception;\n"
    "\n"
    "/* compatibility constant */\n"
    "define('SWOOLE_COROUTINE_SOCKET_HAVE_SSL_HANDSHAKE', method_exists(Socket::class, 'sslHandshake'));\n"
    "\n"
    "class Server\n"
    "{\n"
    "    /** @var string */\n"
    "    public $host = '';\n"
    "\n"
    "    /** @var int */\n"
    "    public $port = 0;\n"
    "\n"
    "    /** @var int */\n"
    "    public $type = AF_INET;\n"
    "\n"
    "    /** @var int */\n"
    "    public $fd = -1;\n"
    "\n"
    "    /** @var int */\n"
    "    public $errCode = 0;\n"
    "\n"
    "    /** @var array */\n"
    "    public $setting = [];\n"
    "\n"
    "    /** @var bool */\n"
    "    protected $running = false;\n"
    "\n"
    "    /** @var null|callable */\n"
    "    protected $fn;\n"
    "\n"
    "    /** @var Socket */\n"
    "    protected $socket;\n"
    "\n"
    "    /**\n"
    "     * Server constructor.\n"
    "     * @throws Exception\n"
    "     */\n"
    "    public function __construct(string $host, int $port = 0, bool $ssl = false, bool $reuse_port = false)\n"
    "    {\n"
    "        $_host = swoole_string($host);\n"
    "        if ($_host->contains('::')) {\n"
    "            $this->type = AF_INET6;\n"
    "        } elseif ($_host->startsWith('unix:/')) {\n"
    "            $host = $_host->substr(5)->__toString();\n"
    "            $this->type = AF_UNIX;\n"
    "        } else {\n"
    "            $this->type = AF_INET;\n"
    "        }\n"
    "        $this->host = $host;\n"
    "\n"
    "        $socket = new Socket($this->type, SOCK_STREAM, 0);\n"
    "        if ($reuse_port and defined('SO_REUSEPORT')) {\n"
    "            $socket->setOption(SOL_SOCKET, SO_REUSEPORT, true);\n"
    "        }\n"
    "        if (!$socket->bind($this->host, $port)) {\n"
    "            throw new Exception(\"bind({$this->host}:{$port}) failed\", $socket->errCode);\n"
    "        }\n"
    "        if (!$socket->listen()) {\n"
    "            throw new Exception('listen() failed', $socket->errCode);\n"
    "        }\n"
    "        $this->port = $socket->getsockname()['port'] ?? 0;\n"
    "        $this->fd = $socket->fd;\n"
    "        $this->socket = $socket;\n"
    "        $this->setting['open_ssl'] = $ssl;\n"
    "    }\n"
    "\n"
    "    public function set(array $setting): void\n"
    "    {\n"
    "        $this->setting = array_merge($this->setting, $setting);\n"
    "    }\n"
    "\n"
    "    public function handle(callable $fn): void\n"
    "    {\n"
    "        $this->fn = $fn;\n"
    "    }\n"
    "\n"
    "    public function shutdown(): bool\n"
    "    {\n"
    "        $this->running = false;\n"
    "        return $this->socket->cancel();\n"
    "    }\n"
    "\n"
    "    public function start(): bool\n"
    "    {\n"
    "        $this->running = true;\n"
    "        if ($this->fn === null) {\n"
    "            $this->errCode = SOCKET_EINVAL;\n"
    "            return false;\n"
    "        }\n"
    "        $socket = $this->socket;\n"
    "        if (!$socket->setProtocol($this->setting)) {\n"
    "            $this->errCode = SOCKET_EINVAL;\n"
    "            return false;\n"
    "        }\n"
    "\n"
    "        while ($this->running) {\n"
    "            /** @var Socket $conn */\n"
    "            $conn = null;\n"
    "            $conn = $socket->accept();\n"
    "            if ($conn) {\n"
    "                $conn->setProtocol($this->setting);\n"
    "                if (SWOOLE_COROUTINE_SOCKET_HAVE_SSL_HANDSHAKE && $this->setting['open_ssl'] ?? false) {\n"
    "                    $fn = static function ($fn, $connection) {\n"
    "                        /* @var $connection Connection */\n"
    "                        if (!$connection->exportSocket()->sslHandshake()) {\n"
    "                            return;\n"
    "                        }\n"
    "                        $fn($connection);\n"
    "                    };\n"
    "                    $arguments = [$this->fn, new Connection($conn)];\n"
    "                } else {\n"
    "                    $fn = $this->fn;\n"
    "                    $arguments = [new Connection($conn)];\n"
    "                }\n"
    "                if (Coroutine::create($fn, ...$arguments) < 0) {\n"
    "                    goto _wait;\n"
    "                }\n"
    "            } else {\n"
    "                if ($socket->errCode == SOCKET_EMFILE or $socket->errCode == SOCKET_ENFILE) {\n"
    "                    _wait:\n"
    "                    Coroutine::sleep(1);\n"
    "                    continue;\n"
    "                }\n"
    "                if ($socket->errCode == SOCKET_ETIMEDOUT) {\n"
    "                    continue;\n"
    "                }\n"
    "                if ($socket->errCode == SOCKET_ECANCELED) {\n"
    "                    break;\n"
    "                }\n"
    "                trigger_error(\"accept failed, Error: {$socket->errMsg}[{$socket->errCode}]\", E_USER_WARNING);\n"
    "                break;\n"
    "            }\n"
    "        }\n"
    "\n"
    "        return true;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_server_connection =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine\\Server;\n"
    "\n"
    "use Swoole\\Coroutine\\Socket;\n"
    "\n"
    "class Connection\n"
    "{\n"
    "    protected $socket;\n"
    "\n"
    "    public function __construct(Socket $conn)\n"
    "    {\n"
    "        $this->socket = $conn;\n"
    "    }\n"
    "\n"
    "    public function recv(float $timeout = 0)\n"
    "    {\n"
    "        return $this->socket->recvPacket($timeout);\n"
    "    }\n"
    "\n"
    "    public function send(string $data)\n"
    "    {\n"
    "        return $this->socket->sendAll($data);\n"
    "    }\n"
    "\n"
    "    public function close(): bool\n"
    "    {\n"
    "        return $this->socket->close();\n"
    "    }\n"
    "\n"
    "    public function exportSocket(): Socket\n"
    "    {\n"
    "        return $this->socket;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_barrier =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine;\n"
    "\n"
    "use Swoole\\Coroutine;\n"
    "use Swoole\\Exception;\n"
    "use Swoole\\Timer;\n"
    "\n"
    "class Barrier\n"
    "{\n"
    "    private $cid = -1;\n"
    "\n"
    "    private $timer = -1;\n"
    "\n"
    "    private static $cancel_list = [];\n"
    "\n"
    "    public function __destruct()\n"
    "    {\n"
    "        if ($this->timer !== -1) {\n"
    "            Timer::clear($this->timer);\n"
    "            if (isset(self::$cancel_list[$this->cid])) {\n"
    "                unset(self::$cancel_list[$this->cid]);\n"
    "                return;\n"
    "            }\n"
    "        }\n"
    "        if ($this->cid !== -1 && $this->cid !== Coroutine::getCid()) {\n"
    "            Coroutine::resume($this->cid);\n"
    "        } else {\n"
    "            self::$cancel_list[$this->cid] = true;\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public static function make()\n"
    "    {\n"
    "        return new static();\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @throws Exception\n"
    "     */\n"
    "    public static function wait(Barrier &$barrier, float $timeout = -1)\n"
    "    {\n"
    "        if ($barrier->cid !== -1) {\n"
    "            throw new Exception('The barrier is waiting, cannot wait again.');\n"
    "        }\n"
    "        $cid = Coroutine::getCid();\n"
    "        $barrier->cid = $cid;\n"
    "        if ($timeout > 0 && ($timeout_ms = (int) ($timeout * 1000)) > 0) {\n"
    "            $barrier->timer = Timer::after($timeout_ms, function () use ($cid) {\n"
    "                self::$cancel_list[$cid] = true;\n"
    "                Coroutine::resume($cid);\n"
    "            });\n"
    "        }\n"
    "        $barrier = null;\n"
    "        if (!isset(self::$cancel_list[$cid])) {\n"
    "            Coroutine::yield();\n"
    "        } else {\n"
    "            unset(self::$cancel_list[$cid]);\n"
    "        }\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_http_functions =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine\\Http;\n"
    "\n"
    "use Swoole\\Coroutine\\Http\\Client\\Exception;\n"
    "\n"
    "/**\n"
    " * @param mixed $data\n"
    " * @throws Exception\n"
    " * @return mixed\n"
    " */\n"
    "function request(string $url, string $method, $data = null, array $options = null, array $headers = null, array $cookies = null)\n"
    "{\n"
    "    $info = parse_url($url);\n"
    "    if ($info['scheme'] == 'http') {\n"
    "        $client = new Client($info['host'], swoole_array_default_value($info, 'port', 80), false);\n"
    "    } elseif ($info['scheme'] == 'https') {\n"
    "        $client = new Client($info['host'], swoole_array_default_value($info, 'port', 443), true);\n"
    "    } else {\n"
    "        throw new Exception('unknown scheme \"' . $info['scheme'] . '\"');\n"
    "    }\n"
    "    $client->setMethod($method);\n"
    "    if ($data) {\n"
    "        $client->setData($data);\n"
    "    }\n"
    "    if (is_array($options)) {\n"
    "        $client->set($options);\n"
    "    }\n"
    "    if (is_array($headers)) {\n"
    "        $client->setHeaders($headers);\n"
    "    }\n"
    "    if (is_array($cookies)) {\n"
    "        $client->setCookies($cookies);\n"
    "    }\n"
    "    $request_url = swoole_array_default_value($info, 'path', '/');\n"
    "    if (!empty($info['query'])) {\n"
    "        $request_url .= '?' . $info['query'];\n"
    "    }\n"
    "    if ($client->execute($request_url)) {\n"
    "        return $client;\n"
    "    }\n"
    "    return false;\n"
    "}\n"
    "\n"
    "/**\n"
    " * @param mixed $data\n"
    " * @throws Exception\n"
    " * @return Client|false|mixed\n"
    " */\n"
    "function post(string $url, $data, array $options = null, array $headers = null, array $cookies = null)\n"
    "{\n"
    "    return request($url, 'POST', $data, $options, $headers, $cookies);\n"
    "}\n"
    "\n"
    "/**\n"
    " * @throws Exception\n"
    " * @return Client|false|mixed\n"
    " */\n"
    "function get(string $url, array $options = null, array $headers = null, array $cookies = null)\n"
    "{\n"
    "    return request($url, 'GET', null, $options, $headers, $cookies);\n"
    "}\n";

static const char* swoole_library_source_core_connection_pool =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "use RuntimeException;\n"
    "use Swoole\\Coroutine\\Channel;\n"
    "use Throwable;\n"
    "\n"
    "class ConnectionPool\n"
    "{\n"
    "    public const DEFAULT_SIZE = 64;\n"
    "\n"
    "    /** @var Channel */\n"
    "    protected $pool;\n"
    "\n"
    "    /** @var callable */\n"
    "    protected $constructor;\n"
    "\n"
    "    /** @var int */\n"
    "    protected $size;\n"
    "\n"
    "    /** @var int */\n"
    "    protected $num;\n"
    "\n"
    "    /** @var null|string */\n"
    "    protected $proxy;\n"
    "\n"
    "    public function __construct(callable $constructor, int $size = self::DEFAULT_SIZE, ?string $proxy = null)\n"
    "    {\n"
    "        $this->pool = new Channel($this->size = $size);\n"
    "        $this->constructor = $constructor;\n"
    "        $this->num = 0;\n"
    "        $this->proxy = $proxy;\n"
    "    }\n"
    "\n"
    "    public function fill(): void\n"
    "    {\n"
    "        while ($this->size > $this->num) {\n"
    "            $this->make();\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function get()\n"
    "    {\n"
    "        if ($this->pool === null) {\n"
    "            throw new RuntimeException('Pool has been closed');\n"
    "        }\n"
    "        if ($this->pool->isEmpty() && $this->num < $this->size) {\n"
    "            $this->make();\n"
    "        }\n"
    "        return $this->pool->pop();\n"
    "    }\n"
    "\n"
    "    public function put($connection): void\n"
    "    {\n"
    "        if ($this->pool === null) {\n"
    "            return;\n"
    "        }\n"
    "        if ($connection !== null) {\n"
    "            $this->pool->push($connection);\n"
    "        } else {\n"
    "            /* connection broken */\n"
    "            $this->num -= 1;\n"
    "            $this->make();\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function close(): void\n"
    "    {\n"
    "        $this->pool->close();\n"
    "        $this->pool = null;\n"
    "        $this->num = 0;\n"
    "    }\n"
    "\n"
    "    protected function make(): void\n"
    "    {\n"
    "        $this->num++;\n"
    "        try {\n"
    "            if ($this->proxy) {\n"
    "                $connection = new $this->proxy($this->constructor);\n"
    "            } else {\n"
    "                $constructor = $this->constructor;\n"
    "                $connection = $constructor();\n"
    "            }\n"
    "        } catch (Throwable $throwable) {\n"
    "            $this->num--;\n"
    "            throw $throwable;\n"
    "        }\n"
    "        $this->put($connection);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_object_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use Error;\n"
    "\n"
    "class ObjectProxy extends \\Swoole\\ObjectProxy\n"
    "{\n"
    "    public function __clone()\n"
    "    {\n"
    "        throw new Error('Trying to clone an uncloneable database proxy object');\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_mysqli_config =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "class MysqliConfig\n"
    "{\n"
    "    /** @var string */\n"
    "    protected $host = '127.0.0.1';\n"
    "\n"
    "    /** @var int */\n"
    "    protected $port = 3306;\n"
    "\n"
    "    /** @var null|string */\n"
    "    protected $unixSocket = '';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $dbname = 'test';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $charset = 'utf8mb4';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $username = 'root';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $password = 'root';\n"
    "\n"
    "    /** @var array */\n"
    "    protected $options = [];\n"
    "\n"
    "    public function getHost(): string\n"
    "    {\n"
    "        return $this->host;\n"
    "    }\n"
    "\n"
    "    public function withHost($host): self\n"
    "    {\n"
    "        $this->host = $host;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getPort(): int\n"
    "    {\n"
    "        return $this->port;\n"
    "    }\n"
    "\n"
    "    public function getUnixSocket(): string\n"
    "    {\n"
    "        return $this->unixSocket;\n"
    "    }\n"
    "\n"
    "    public function withUnixSocket(?string $unixSocket): self\n"
    "    {\n"
    "        $this->unixSocket = $unixSocket;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withPort(int $port): self\n"
    "    {\n"
    "        $this->port = $port;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getDbname(): string\n"
    "    {\n"
    "        return $this->dbname;\n"
    "    }\n"
    "\n"
    "    public function withDbname(string $dbname): self\n"
    "    {\n"
    "        $this->dbname = $dbname;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getCharset(): string\n"
    "    {\n"
    "        return $this->charset;\n"
    "    }\n"
    "\n"
    "    public function withCharset(string $charset): self\n"
    "    {\n"
    "        $this->charset = $charset;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getUsername(): string\n"
    "    {\n"
    "        return $this->username;\n"
    "    }\n"
    "\n"
    "    public function withUsername(string $username): self\n"
    "    {\n"
    "        $this->username = $username;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getPassword(): string\n"
    "    {\n"
    "        return $this->password;\n"
    "    }\n"
    "\n"
    "    public function withPassword(string $password): self\n"
    "    {\n"
    "        $this->password = $password;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getOptions(): array\n"
    "    {\n"
    "        return $this->options;\n"
    "    }\n"
    "\n"
    "    public function withOptions(array $options): self\n"
    "    {\n"
    "        $this->options = $options;\n"
    "        return $this;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_mysqli_exception =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use Exception;\n"
    "\n"
    "class MysqliException extends Exception\n"
    "{\n"
    "}\n";

static const char* swoole_library_source_core_database_mysqli_pool =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use mysqli;\n"
    "use Swoole\\ConnectionPool;\n"
    "\n"
    "/**\n"
    " * @method mysqli|MysqliProxy get()\n"
    " * @method void put(mysqli|MysqliProxy $connection)\n"
    " */\n"
    "class MysqliPool extends ConnectionPool\n"
    "{\n"
    "    /** @var MysqliConfig */\n"
    "    protected $config;\n"
    "\n"
    "    public function __construct(MysqliConfig $config, int $size = self::DEFAULT_SIZE)\n"
    "    {\n"
    "        $this->config = $config;\n"
    "        parent::__construct(function () {\n"
    "            $mysqli = new mysqli();\n"
    "            foreach ($this->config->getOptions() as $option => $value) {\n"
    "                $mysqli->set_opt($option, $value);\n"
    "            }\n"
    "            $mysqli->real_connect(\n"
    "                $this->config->getHost(),\n"
    "                $this->config->getUsername(),\n"
    "                $this->config->getPassword(),\n"
    "                $this->config->getDbname(),\n"
    "                $this->config->getPort(),\n"
    "                $this->config->getUnixSocket()\n"
    "            );\n"
    "            if ($mysqli->connect_errno) {\n"
    "                throw new MysqliException($mysqli->connect_error, $mysqli->connect_errno);\n"
    "            }\n"
    "            return $mysqli;\n"
    "        }, $size, MysqliProxy::class);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_mysqli_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use mysqli;\n"
    "\n"
    "class MysqliProxy extends ObjectProxy\n"
    "{\n"
    "    public const IO_METHOD_REGEX = '/^autocommit|begin_transaction|change_user|close|commit|kill|multi_query|ping|prepare|query|real_connect|real_query|reap_async_query|refresh|release_savepoint|rollback|savepoint|select_db|send_query|set_charset|ssl_set$/i';\n"
    "\n"
    "    public const IO_ERRORS = [\n"
    "        2002, // MYSQLND_CR_CONNECTION_ERROR\n"
    "        2006, // MYSQLND_CR_SERVER_GONE_ERROR\n"
    "        2013, // MYSQLND_CR_SERVER_LOST\n"
    "    ];\n"
    "\n"
    "    /** @var mysqli */\n"
    "    protected $__object;\n"
    "\n"
    "    /** @var string */\n"
    "    protected $charsetContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $setOptContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $changeUserContext;\n"
    "\n"
    "    /** @var callable */\n"
    "    protected $constructor;\n"
    "\n"
    "    /** @var int */\n"
    "    protected $round = 0;\n"
    "\n"
    "    public function __construct(callable $constructor)\n"
    "    {\n"
    "        parent::__construct($constructor());\n"
    "        $this->constructor = $constructor;\n"
    "    }\n"
    "\n"
    "    public function __call(string $name, array $arguments)\n"
    "    {\n"
    "        for ($n = 3; $n--;) {\n"
    "            $ret = @$this->__object->{$name}(...$arguments);\n"
    "            if ($ret === false) {\n"
    "                /* non-IO method */\n"
    "                if (!preg_match(static::IO_METHOD_REGEX, $name)) {\n"
    "                    break;\n"
    "                }\n"
    "                /* no more chances or non-IO failures */\n"
    "                if (!in_array($this->__object->errno, static::IO_ERRORS, true) || ($n === 0)) {\n"
    "                    throw new MysqliException($this->__object->error, $this->__object->errno);\n"
    "                }\n"
    "                $this->reconnect();\n"
    "                continue;\n"
    "            }\n"
    "            if (strcasecmp($name, 'prepare') === 0) {\n"
    "                $ret = new MysqliStatementProxy($ret, $arguments[0], $this);\n"
    "            } elseif (strcasecmp($name, 'stmt_init') === 0) {\n"
    "                $ret = new MysqliStatementProxy($ret, null, $this);\n"
    "            }\n"
    "            break;\n"
    "        }\n"
    "        /* @noinspection PhpUndefinedVariableInspection */\n"
    "        return $ret;\n"
    "    }\n"
    "\n"
    "    public function getRound(): int\n"
    "    {\n"
    "        return $this->round;\n"
    "    }\n"
    "\n"
    "    public function reconnect(): void\n"
    "    {\n"
    "        $constructor = $this->constructor;\n"
    "        parent::__construct($constructor());\n"
    "        $this->round++;\n"
    "        /* restore context */\n"
    "        if ($this->charsetContext) {\n"
    "            $this->__object->set_charset($this->charsetContext);\n"
    "        }\n"
    "        if ($this->setOptContext) {\n"
    "            foreach ($this->setOptContext as $opt => $val) {\n"
    "                $this->__object->set_opt($opt, $val);\n"
    "            }\n"
    "        }\n"
    "        if ($this->changeUserContext) {\n"
    "            $this->__object->change_user(...$this->changeUserContext);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function options(int $option, $value): bool\n"
    "    {\n"
    "        $this->setOptContext[$option] = $value;\n"
    "        return $this->__object->options($option, $value);\n"
    "    }\n"
    "\n"
    "    public function set_opt(int $option, $value): bool\n"
    "    {\n"
    "        return $this->options($option, $value);\n"
    "    }\n"
    "\n"
    "    public function set_charset(string $charset): bool\n"
    "    {\n"
    "        $this->charsetContext = $charset;\n"
    "        return $this->__object->set_charset($charset);\n"
    "    }\n"
    "\n"
    "    public function change_user(string $user, string $password, string $database): bool\n"
    "    {\n"
    "        $this->changeUserContext = [$user, $password, $database];\n"
    "        return $this->__object->change_user($user, $password, $database);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_mysqli_statement_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use mysqli;\n"
    "use mysqli_stmt;\n"
    "\n"
    "class MysqliStatementProxy extends ObjectProxy\n"
    "{\n"
    "    public const IO_METHOD_REGEX = '/^close|execute|fetch|prepare$/i';\n"
    "\n"
    "    /** @var mysqli_stmt */\n"
    "    protected $__object;\n"
    "\n"
    "    /** @var null|string */\n"
    "    protected $queryString;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $attrSetContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $bindParamContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $bindResultContext;\n"
    "\n"
    "    /** @var Mysqli|MysqliProxy */\n"
    "    protected $parent;\n"
    "\n"
    "    /** @var int */\n"
    "    protected $parentRound;\n"
    "\n"
    "    public function __construct(mysqli_stmt $object, ?string $queryString, MysqliProxy $parent)\n"
    "    {\n"
    "        parent::__construct($object);\n"
    "        $this->queryString = $queryString;\n"
    "        $this->parent = $parent;\n"
    "        $this->parentRound = $parent->getRound();\n"
    "    }\n"
    "\n"
    "    public function __call(string $name, array $arguments)\n"
    "    {\n"
    "        for ($n = 3; $n--;) {\n"
    "            $ret = @$this->__object->{$name}(...$arguments);\n"
    "            if ($ret === false) {\n"
    "                /* non-IO method */\n"
    "                if (!preg_match(static::IO_METHOD_REGEX, $name)) {\n"
    "                    break;\n"
    "                }\n"
    "                /* no more chances or non-IO failures or in transaction */\n"
    "                if (!in_array($this->__object->errno, $this->parent::IO_ERRORS, true) || ($n === 0)) {\n"
    "                    throw new MysqliException($this->__object->error, $this->__object->errno);\n"
    "                }\n"
    "                if ($this->parent->getRound() === $this->parentRound) {\n"
    "                    /* if not equal, parent has reconnected */\n"
    "                    $this->parent->reconnect();\n"
    "                }\n"
    "                $parent = $this->parent->__getObject();\n"
    "                $this->__object = $this->queryString ? @$parent->prepare($this->queryString) : @$parent->stmt_init();\n"
    "                if ($this->__object === false) {\n"
    "                    throw new MysqliException($parent->error, $parent->errno);\n"
    "                }\n"
    "                if ($this->bindParamContext) {\n"
    "                    $this->__object->bind_param($this->bindParamContext[0], ...$this->bindParamContext[1]);\n"
    "                }\n"
    "                if ($this->bindResultContext) {\n"
    "                    $this->__object->bind_result($this->bindResultContext);\n"
    "                }\n"
    "                if ($this->attrSetContext) {\n"
    "                    foreach ($this->attrSetContext as $attr => $value) {\n"
    "                        $this->__object->attr_set($attr, $value);\n"
    "                    }\n"
    "                }\n"
    "                continue;\n"
    "            }\n"
    "            if (strcasecmp($name, 'prepare') === 0) {\n"
    "                $this->queryString = $arguments[0];\n"
    "            }\n"
    "            break;\n"
    "        }\n"
    "        /* @noinspection PhpUndefinedVariableInspection */\n"
    "        return $ret;\n"
    "    }\n"
    "\n"
    "    public function attr_set($attr, $mode): bool\n"
    "    {\n"
    "        $this->attrSetContext[$attr] = $mode;\n"
    "        return $this->__object->attr_set($attr, $mode);\n"
    "    }\n"
    "\n"
    "    public function bind_param($types, &...$arguments): bool\n"
    "    {\n"
    "        $this->bindParamContext = [$types, $arguments];\n"
    "        return $this->__object->bind_param($types, ...$arguments);\n"
    "    }\n"
    "\n"
    "    public function bind_result(&...$arguments): bool\n"
    "    {\n"
    "        $this->bindResultContext = $arguments;\n"
    "        return $this->__object->bind_result(...$arguments);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_pdo_config =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "class PDOConfig\n"
    "{\n"
    "    public const DRIVER_MYSQL = 'mysql';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $driver = self::DRIVER_MYSQL;\n"
    "\n"
    "    /** @var string */\n"
    "    protected $host = '127.0.0.1';\n"
    "\n"
    "    /** @var int */\n"
    "    protected $port = 3306;\n"
    "\n"
    "    /** @var null|string */\n"
    "    protected $unixSocket;\n"
    "\n"
    "    /** @var string */\n"
    "    protected $dbname = 'test';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $charset = 'utf8mb4';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $username = 'root';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $password = 'root';\n"
    "\n"
    "    /** @var array */\n"
    "    protected $options = [];\n"
    "\n"
    "    public function getDriver(): string\n"
    "    {\n"
    "        return $this->driver;\n"
    "    }\n"
    "\n"
    "    public function withDriver(string $driver): self\n"
    "    {\n"
    "        $this->driver = $driver;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getHost(): string\n"
    "    {\n"
    "        return $this->host;\n"
    "    }\n"
    "\n"
    "    public function withHost($host): self\n"
    "    {\n"
    "        $this->host = $host;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getPort(): int\n"
    "    {\n"
    "        return $this->port;\n"
    "    }\n"
    "\n"
    "    public function hasUnixSocket(): bool\n"
    "    {\n"
    "        return isset($this->unixSocket);\n"
    "    }\n"
    "\n"
    "    public function getUnixSocket(): string\n"
    "    {\n"
    "        return $this->unixSocket;\n"
    "    }\n"
    "\n"
    "    public function withUnixSocket(?string $unixSocket): self\n"
    "    {\n"
    "        $this->unixSocket = $unixSocket;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withPort(int $port): self\n"
    "    {\n"
    "        $this->port = $port;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getDbname(): string\n"
    "    {\n"
    "        return $this->dbname;\n"
    "    }\n"
    "\n"
    "    public function withDbname(string $dbname): self\n"
    "    {\n"
    "        $this->dbname = $dbname;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getCharset(): string\n"
    "    {\n"
    "        return $this->charset;\n"
    "    }\n"
    "\n"
    "    public function withCharset(string $charset): self\n"
    "    {\n"
    "        $this->charset = $charset;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getUsername(): string\n"
    "    {\n"
    "        return $this->username;\n"
    "    }\n"
    "\n"
    "    public function withUsername(string $username): self\n"
    "    {\n"
    "        $this->username = $username;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getPassword(): string\n"
    "    {\n"
    "        return $this->password;\n"
    "    }\n"
    "\n"
    "    public function withPassword(string $password): self\n"
    "    {\n"
    "        $this->password = $password;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getOptions(): array\n"
    "    {\n"
    "        return $this->options;\n"
    "    }\n"
    "\n"
    "    public function withOptions(array $options): self\n"
    "    {\n"
    "        $this->options = $options;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the list of available drivers\n"
    "     *\n"
    "     * @return string[]\n"
    "     */\n"
    "    public static function getAvailableDrivers()\n"
    "    {\n"
    "        return [\n"
    "            self::DRIVER_MYSQL,\n"
    "        ];\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_pdo_pool =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use PDO;\n"
    "use Swoole\\ConnectionPool;\n"
    "\n"
    "/**\n"
    " * @method PDO|PDOProxy get()\n"
    " * @method void put(PDO|PDOProxy $connection)\n"
    " */\n"
    "class PDOPool extends ConnectionPool\n"
    "{\n"
    "    /** @var int */\n"
    "    protected $size = 64;\n"
    "\n"
    "    /** @var PDOConfig */\n"
    "    protected $config;\n"
    "\n"
    "    public function __construct(PDOConfig $config, int $size = self::DEFAULT_SIZE)\n"
    "    {\n"
    "        $this->config = $config;\n"
    "        parent::__construct(function () {\n"
    "            return new PDO(\n"
    "                \"{$this->config->getDriver()}:\" .\n"
    "                (\n"
    "                    $this->config->hasUnixSocket() ?\n"
    "                    \"unix_socket={$this->config->getUnixSocket()};\" :\n"
    "                    \"host={$this->config->getHost()};\" . \"port={$this->config->getPort()};\"\n"
    "                ) .\n"
    "                \"dbname={$this->config->getDbname()};\" .\n"
    "                \"charset={$this->config->getCharset()}\",\n"
    "                $this->config->getUsername(),\n"
    "                $this->config->getPassword(),\n"
    "                $this->config->getOptions()\n"
    "            );\n"
    "        }, $size, PDOProxy::class);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_pdo_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use PDO;\n"
    "use PDOException;\n"
    "\n"
    "class PDOProxy extends ObjectProxy\n"
    "{\n"
    "    public const IO_METHOD_REGEX = '/^query|prepare|exec|beginTransaction|commit|rollback$/i';\n"
    "\n"
    "    public const IO_ERRORS = [\n"
    "        2002, // MYSQLND_CR_CONNECTION_ERROR\n"
    "        2006, // MYSQLND_CR_SERVER_GONE_ERROR\n"
    "        2013, // MYSQLND_CR_SERVER_LOST\n"
    "    ];\n"
    "\n"
    "    /** @var PDO */\n"
    "    protected $__object;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $setAttributeContext;\n"
    "\n"
    "    /** @var callable */\n"
    "    protected $constructor;\n"
    "\n"
    "    /** @var int */\n"
    "    protected $round = 0;\n"
    "\n"
    "    public function __construct(callable $constructor)\n"
    "    {\n"
    "        parent::__construct($constructor());\n"
    "        $this->__object->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_SILENT);\n"
    "        $this->constructor = $constructor;\n"
    "    }\n"
    "\n"
    "    public function __call(string $name, array $arguments)\n"
    "    {\n"
    "        for ($n = 3; $n--;) {\n"
    "            $ret = @$this->__object->{$name}(...$arguments);\n"
    "            if ($ret === false) {\n"
    "                /* non-IO method */\n"
    "                if (!preg_match(static::IO_METHOD_REGEX, $name)) {\n"
    "                    break;\n"
    "                }\n"
    "                $errorInfo = $this->__object->errorInfo();\n"
    "                /* no more chances or non-IO failures */\n"
    "                if (\n"
    "                    !in_array($errorInfo[1], static::IO_ERRORS, true)\n"
    "                    || $n === 0\n"
    "                    || $this->__object->inTransaction()\n"
    "                ) {\n"
    "                    /* '00000' means “no error.”, as specified by ANSI SQL and ODBC. */\n"
    "                    if (!empty($errorInfo) && $errorInfo[0] !== '00000') {\n"
    "                        $exception = new PDOException($errorInfo[2], $errorInfo[1]);\n"
    "                        $exception->errorInfo = $errorInfo;\n"
    "                        throw $exception;\n"
    "                    }\n"
    "                    /* no error info, just return false */\n"
    "                    break;\n"
    "                }\n"
    "                $this->reconnect();\n"
    "                continue;\n"
    "            }\n"
    "            if ((strcasecmp($name, 'prepare') === 0) || (strcasecmp($name, 'query') === 0)) {\n"
    "                $ret = new PDOStatementProxy($ret, $this);\n"
    "            }\n"
    "            break;\n"
    "        }\n"
    "        /* @noinspection PhpUndefinedVariableInspection */\n"
    "        return $ret;\n"
    "    }\n"
    "\n"
    "    public function getRound(): int\n"
    "    {\n"
    "        return $this->round;\n"
    "    }\n"
    "\n"
    "    public function reconnect(): void\n"
    "    {\n"
    "        $constructor = $this->constructor;\n"
    "        parent::__construct($constructor());\n"
    "        $this->round++;\n"
    "        /* restore context */\n"
    "        if ($this->setAttributeContext) {\n"
    "            foreach ($this->setAttributeContext as $attribute => $value) {\n"
    "                $this->__object->setAttribute($attribute, $value);\n"
    "            }\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function setAttribute(int $attribute, $value): bool\n"
    "    {\n"
    "        $this->setAttributeContext[$attribute] = $value;\n"
    "        return $this->__object->setAttribute($attribute, $value);\n"
    "    }\n"
    "\n"
    "    public function inTransaction(): bool\n"
    "    {\n"
    "        return $this->__object->inTransaction();\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_pdo_statement_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use PDO;\n"
    "use PDOException;\n"
    "use PDOStatement;\n"
    "\n"
    "class PDOStatementProxy extends ObjectProxy\n"
    "{\n"
    "    /** @var PDOStatement */\n"
    "    protected $__object;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $setAttributeContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $setFetchModeContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $bindParamContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $bindColumnContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $bindValueContext;\n"
    "\n"
    "    /** @var PDO|PDOProxy */\n"
    "    protected $parent;\n"
    "\n"
    "    /** @var int */\n"
    "    protected $parentRound;\n"
    "\n"
    "    public function __construct(PDOStatement $object, PDOProxy $parent)\n"
    "    {\n"
    "        parent::__construct($object);\n"
    "        $this->parent = $parent;\n"
    "        $this->parentRound = $parent->getRound();\n"
    "    }\n"
    "\n"
    "    public function __call(string $name, array $arguments)\n"
    "    {\n"
    "        for ($n = 3; $n--;) {\n"
    "            $ret = @$this->__object->{$name}(...$arguments);\n"
    "            if ($ret === false) {\n"
    "                /* no IO */\n"
    "                if (strtolower($name) !== 'execute') {\n"
    "                    break;\n"
    "                }\n"
    "                /* no more chances or non-IO failures or in transaction */\n"
    "                if (\n"
    "                    !in_array($this->__object->errorInfo()[1], $this->parent::IO_ERRORS, true)\n"
    "                    || $n === 0\n"
    "                    || $this->parent->inTransaction()\n"
    "                ) {\n"
    "                    $errorInfo = $this->__object->errorInfo();\n"
    "\n"
    "                    /* '00000' means “no error.”, as specified by ANSI SQL and ODBC. */\n"
    "                    if (!empty($errorInfo) && $errorInfo[0] !== '00000') {\n"
    "                        $exception = new PDOException($errorInfo[2], $errorInfo[1]);\n"
    "                        $exception->errorInfo = $errorInfo;\n"
    "                        throw $exception;\n"
    "                    }\n"
    "                    /* no error info, just return false */\n"
    "                    break;\n"
    "                }\n"
    "                if ($this->parent->getRound() === $this->parentRound) {\n"
    "                    /* if not equal, parent has reconnected */\n"
    "                    $this->parent->reconnect();\n"
    "                }\n"
    "                $parent = $this->parent->__getObject();\n"
    "                $this->__object = $parent->prepare($this->__object->queryString);\n"
    "                if ($this->__object === false) {\n"
    "                    $errorInfo = $parent->errorInfo();\n"
    "                    $exception = new PDOException($errorInfo[2], $errorInfo[1]);\n"
    "                    $exception->errorInfo = $errorInfo;\n"
    "                    throw $exception;\n"
    "                }\n"
    "                if ($this->setAttributeContext) {\n"
    "                    foreach ($this->setAttributeContext as $attribute => $value) {\n"
    "                        $this->__object->setAttribute($attribute, $value);\n"
    "                    }\n"
    "                }\n"
    "                if ($this->setFetchModeContext) {\n"
    "                    $this->__object->setFetchMode(...$this->setFetchModeContext);\n"
    "                }\n"
    "                if ($this->bindParamContext) {\n"
    "                    foreach ($this->bindParamContext as $param => $item) {\n"
    "                        $this->__object->bindParam($param, ...$item);\n"
    "                    }\n"
    "                }\n"
    "                if ($this->bindColumnContext) {\n"
    "                    foreach ($this->bindColumnContext as $column => $item) {\n"
    "                        $this->__object->bindColumn($column, ...$item);\n"
    "                    }\n"
    "                }\n"
    "                if ($this->bindValueContext) {\n"
    "                    foreach ($this->bindValueContext as $value => $item) {\n"
    "                        $this->__object->bindParam($value, ...$item);\n"
    "                    }\n"
    "                }\n"
    "                continue;\n"
    "            }\n"
    "            break;\n"
    "        }\n"
    "        /* @noinspection PhpUndefinedVariableInspection */\n"
    "        return $ret;\n"
    "    }\n"
    "\n"
    "    public function setAttribute(int $attribute, $value): bool\n"
    "    {\n"
    "        $this->setAttributeContext[$attribute] = $value;\n"
    "        return $this->__object->setAttribute($attribute, $value);\n"
    "    }\n"
    "\n"
    "    public function setFetchMode(int $mode, $classNameObject = null, array $ctorarfg = []): bool\n"
    "    {\n"
    "        $this->setFetchModeContext = [$mode, $classNameObject, $ctorarfg];\n"
    "        if (!isset($classNameObject)) {\n"
    "            return $this->__object->setFetchMode($mode);\n"
    "        }\n"
    "        return $this->__object->setFetchMode($mode, $classNameObject, $ctorarfg);\n"
    "    }\n"
    "\n"
    "    public function bindParam($parameter, &$variable, $data_type = PDO::PARAM_STR, $length = null, $driver_options = null): bool\n"
    "    {\n"
    "        $this->bindParamContext[$parameter] = [$variable, $data_type, $length, $driver_options];\n"
    "        return $this->__object->bindParam($parameter, $variable, $data_type, $length, $driver_options);\n"
    "    }\n"
    "\n"
    "    public function bindColumn($column, &$param, $type = null, $maxlen = null, $driverdata = null): bool\n"
    "    {\n"
    "        $this->bindColumnContext[$column] = [$param, $type, $maxlen, $driverdata];\n"
    "        return $this->__object->bindColumn($column, $param, $type, $maxlen, $driverdata);\n"
    "    }\n"
    "\n"
    "    public function bindValue($parameter, $value, $data_type = PDO::PARAM_STR): bool\n"
    "    {\n"
    "        $this->bindValueContext[$parameter] = [$value, $data_type];\n"
    "        return $this->__object->bindValue($parameter, $value, $data_type);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_redis_config =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "class RedisConfig\n"
    "{\n"
    "    /** @var string */\n"
    "    protected $host = '127.0.0.1';\n"
    "\n"
    "    /** @var int */\n"
    "    protected $port = 6379;\n"
    "\n"
    "    /** @var float */\n"
    "    protected $timeout = 0.0;\n"
    "\n"
    "    /** @var string */\n"
    "    protected $reserved = '';\n"
    "\n"
    "    /** @var int */\n"
    "    protected $retry_interval = 0;\n"
    "\n"
    "    /** @var float */\n"
    "    protected $read_timeout = 0.0;\n"
    "\n"
    "    /** @var string */\n"
    "    protected $auth = '';\n"
    "\n"
    "    /** @var int */\n"
    "    protected $dbIndex = 0;\n"
    "\n"
    "    public function getHost()\n"
    "    {\n"
    "        return $this->host;\n"
    "    }\n"
    "\n"
    "    public function withHost($host): self\n"
    "    {\n"
    "        $this->host = $host;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getPort(): int\n"
    "    {\n"
    "        return $this->port;\n"
    "    }\n"
    "\n"
    "    public function withPort(int $port): self\n"
    "    {\n"
    "        $this->port = $port;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getTimeout(): float\n"
    "    {\n"
    "        return $this->timeout;\n"
    "    }\n"
    "\n"
    "    public function withTimeout(float $timeout): self\n"
    "    {\n"
    "        $this->timeout = $timeout;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getReserved(): string\n"
    "    {\n"
    "        return $this->reserved;\n"
    "    }\n"
    "\n"
    "    public function withReserved(string $reserved): self\n"
    "    {\n"
    "        $this->reserved = $reserved;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getRetryInterval(): int\n"
    "    {\n"
    "        return $this->retry_interval;\n"
    "    }\n"
    "\n"
    "    public function withRetryInterval(int $retry_interval): self\n"
    "    {\n"
    "        $this->retry_interval = $retry_interval;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getReadTimeout(): float\n"
    "    {\n"
    "        return $this->read_timeout;\n"
    "    }\n"
    "\n"
    "    public function withReadTimeout(float $read_timeout): self\n"
    "    {\n"
    "        $this->read_timeout = $read_timeout;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getAuth(): string\n"
    "    {\n"
    "        return $this->auth;\n"
    "    }\n"
    "\n"
    "    public function withAuth(string $auth): self\n"
    "    {\n"
    "        $this->auth = $auth;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getDbIndex(): int\n"
    "    {\n"
    "        return $this->dbIndex;\n"
    "    }\n"
    "\n"
    "    public function withDbIndex(int $dbIndex): self\n"
    "    {\n"
    "        $this->dbIndex = $dbIndex;\n"
    "        return $this;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_redis_pool =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use Redis;\n"
    "use Swoole\\ConnectionPool;\n"
    "\n"
    "/**\n"
    " * @method Redis get()\n"
    " * @method void put(Redis $connection)\n"
    " */\n"
    "class RedisPool extends ConnectionPool\n"
    "{\n"
    "    /** @var RedisConfig */\n"
    "    protected $config;\n"
    "\n"
    "    public function __construct(RedisConfig $config, int $size = self::DEFAULT_SIZE)\n"
    "    {\n"
    "        $this->config = $config;\n"
    "        parent::__construct(function () {\n"
    "            $redis = new Redis();\n"
    "            /* Compatible with different versions of Redis extension as much as possible */\n"
    "            $arguments = [\n"
    "                $this->config->getHost(),\n"
    "                $this->config->getPort(),\n"
    "            ];\n"
    "            if ($this->config->getTimeout() !== 0.0) {\n"
    "                $arguments[] = $this->config->getTimeout();\n"
    "            }\n"
    "            if ($this->config->getRetryInterval() !== 0) {\n"
    "                /* reserved should always be NULL */\n"
    "                $arguments[] = null;\n"
    "                $arguments[] = $this->config->getRetryInterval();\n"
    "            }\n"
    "            if ($this->config->getReadTimeout() !== 0.0) {\n"
    "                $arguments[] = $this->config->getReadTimeout();\n"
    "            }\n"
    "            $redis->connect(...$arguments);\n"
    "            if ($this->config->getAuth()) {\n"
    "                $redis->auth($this->config->getAuth());\n"
    "            }\n"
    "            if ($this->config->getDbIndex() !== 0) {\n"
    "                $redis->select($this->config->getDbIndex());\n"
    "            }\n"
    "            return $redis;\n"
    "        }, $size);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_http_status =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Http;\n"
    "\n"
    "abstract class Status\n"
    "{\n"
    "    public const CONTINUE = 100;\n"
    "\n"
    "    public const SWITCHING_PROTOCOLS = 101;\n"
    "\n"
    "    public const PROCESSING = 102;\n"
    "\n"
    "    public const OK = 200;\n"
    "\n"
    "    public const CREATED = 201;\n"
    "\n"
    "    public const ACCEPTED = 202;\n"
    "\n"
    "    public const NON_AUTHORITATIVE_INFORMATION = 203;\n"
    "\n"
    "    public const NO_CONTENT = 204;\n"
    "\n"
    "    public const RESET_CONTENT = 205;\n"
    "\n"
    "    public const PARTIAL_CONTENT = 206;\n"
    "\n"
    "    public const MULTI_STATUS = 207;\n"
    "\n"
    "    public const ALREADY_REPORTED = 208;\n"
    "\n"
    "    public const IM_USED = 226;\n"
    "\n"
    "    public const MULTIPLE_CHOICES = 300;\n"
    "\n"
    "    public const MOVED_PERMANENTLY = 301;\n"
    "\n"
    "    public const FOUND = 302;\n"
    "\n"
    "    public const SEE_OTHER = 303;\n"
    "\n"
    "    public const NOT_MODIFIED = 304;\n"
    "\n"
    "    public const USE_PROXY = 305;\n"
    "\n"
    "    public const SWITCH_PROXY = 306;\n"
    "\n"
    "    public const TEMPORARY_REDIRECT = 307;\n"
    "\n"
    "    public const PERMANENT_REDIRECT = 308;\n"
    "\n"
    "    public const BAD_REQUEST = 400;\n"
    "\n"
    "    public const UNAUTHORIZED = 401;\n"
    "\n"
    "    public const PAYMENT_REQUIRED = 402;\n"
    "\n"
    "    public const FORBIDDEN = 403;\n"
    "\n"
    "    public const NOT_FOUND = 404;\n"
    "\n"
    "    public const METHOD_NOT_ALLOWED = 405;\n"
    "\n"
    "    public const NOT_ACCEPTABLE = 406;\n"
    "\n"
    "    public const PROXY_AUTHENTICATION_REQUIRED = 407;\n"
    "\n"
    "    public const REQUEST_TIME_OUT = 408;\n"
    "\n"
    "    public const CONFLICT = 409;\n"
    "\n"
    "    public const GONE = 410;\n"
    "\n"
    "    public const LENGTH_REQUIRED = 411;\n"
    "\n"
    "    public const PRECONDITION_FAILED = 412;\n"
    "\n"
    "    public const REQUEST_ENTITY_TOO_LARGE = 413;\n"
    "\n"
    "    public const REQUEST_URI_TOO_LARGE = 414;\n"
    "\n"
    "    public const UNSUPPORTED_MEDIA_TYPE = 415;\n"
    "\n"
    "    public const REQUESTED_RANGE_NOT_SATISFIABLE = 416;\n"
    "\n"
    "    public const EXPECTATION_FAILED = 417;\n"
    "\n"
    "    public const MISDIRECTED_REQUEST = 421;\n"
    "\n"
    "    public const UNPROCESSABLE_ENTITY = 422;\n"
    "\n"
    "    public const LOCKED = 423;\n"
    "\n"
    "    public const FAILED_DEPENDENCY = 424;\n"
    "\n"
    "    public const UNORDERED_COLLECTION = 425;\n"
    "\n"
    "    public const UPGRADE_REQUIRED = 426;\n"
    "\n"
    "    public const PRECONDITION_REQUIRED = 428;\n"
    "\n"
    "    public const TOO_MANY_REQUESTS = 429;\n"
    "\n"
    "    public const REQUEST_HEADER_FIELDS_TOO_LARGE = 431;\n"
    "\n"
    "    public const UNAVAILABLE_FOR_LEGAL_REASONS = 451;\n"
    "\n"
    "    public const INTERNAL_SERVER_ERROR = 500;\n"
    "\n"
    "    public const NOT_IMPLEMENTED = 501;\n"
    "\n"
    "    public const BAD_GATEWAY = 502;\n"
    "\n"
    "    public const SERVICE_UNAVAILABLE = 503;\n"
    "\n"
    "    public const GATEWAY_TIME_OUT = 504;\n"
    "\n"
    "    public const HTTP_VERSION_NOT_SUPPORTED = 505;\n"
    "\n"
    "    public const VARIANT_ALSO_NEGOTIATES = 506;\n"
    "\n"
    "    public const INSUFFICIENT_STORAGE = 507;\n"
    "\n"
    "    public const LOOP_DETECTED = 508;\n"
    "\n"
    "    public const NOT_EXTENDED = 510;\n"
    "\n"
    "    public const NETWORK_AUTHENTICATION_REQUIRED = 511;\n"
    "\n"
    "    protected static $reasonPhrases = [\n"
    "        self::CONTINUE => 'Continue',\n"
    "        self::SWITCHING_PROTOCOLS => 'Switching Protocols',\n"
    "        self::PROCESSING => 'Processing',\n"
    "        self::OK => 'OK',\n"
    "        self::CREATED => 'Created',\n"
    "        self::ACCEPTED => 'Accepted',\n"
    "        self::NON_AUTHORITATIVE_INFORMATION => 'Non-Authoritative Information',\n"
    "        self::NO_CONTENT => 'No Content',\n"
    "        self::RESET_CONTENT => 'Reset Content',\n"
    "        self::PARTIAL_CONTENT => 'Partial Content',\n"
    "        self::MULTI_STATUS => 'Multi-status',\n"
    "        self::ALREADY_REPORTED => 'Already Reported',\n"
    "        self::IM_USED => 'IM Used',\n"
    "        self::MULTIPLE_CHOICES => 'Multiple Choices',\n"
    "        self::MOVED_PERMANENTLY => 'Moved Permanently',\n"
    "        self::FOUND => 'Found',\n"
    "        self::SEE_OTHER => 'See Other',\n"
    "        self::NOT_MODIFIED => 'Not Modified',\n"
    "        self::USE_PROXY => 'Use Proxy',\n"
    "        self::SWITCH_PROXY => 'Switch Proxy',\n"
    "        self::TEMPORARY_REDIRECT => 'Temporary Redirect',\n"
    "        self::PERMANENT_REDIRECT => 'Permanent Redirect',\n"
    "        self::BAD_REQUEST => 'Bad Request',\n"
    "        self::UNAUTHORIZED => 'Unauthorized',\n"
    "        self::PAYMENT_REQUIRED => 'Payment Required',\n"
    "        self::FORBIDDEN => 'Forbidden',\n"
    "        self::NOT_FOUND => 'Not Found',\n"
    "        self::METHOD_NOT_ALLOWED => 'Method Not Allowed',\n"
    "        self::NOT_ACCEPTABLE => 'Not Acceptable',\n"
    "        self::PROXY_AUTHENTICATION_REQUIRED => 'Proxy Authentication Required',\n"
    "        self::REQUEST_TIME_OUT => 'Request Time-out',\n"
    "        self::CONFLICT => 'Conflict',\n"
    "        self::GONE => 'Gone',\n"
    "        self::LENGTH_REQUIRED => 'Length Required',\n"
    "        self::PRECONDITION_FAILED => 'Precondition Failed',\n"
    "        self::REQUEST_ENTITY_TOO_LARGE => 'Request Entity Too Large',\n"
    "        self::REQUEST_URI_TOO_LARGE => 'Request-URI Too Large',\n"
    "        self::UNSUPPORTED_MEDIA_TYPE => 'Unsupported Media Type',\n"
    "        self::REQUESTED_RANGE_NOT_SATISFIABLE => 'Requested range not satisfiable',\n"
    "        self::EXPECTATION_FAILED => 'Expectation Failed',\n"
    "        self::MISDIRECTED_REQUEST => 'Unprocessable Entity',\n"
    "        self::UNPROCESSABLE_ENTITY => 'Unprocessable Entity',\n"
    "        self::LOCKED => 'Locked',\n"
    "        self::FAILED_DEPENDENCY => 'Failed Dependency',\n"
    "        self::UNORDERED_COLLECTION => 'Unordered Collection',\n"
    "        self::UPGRADE_REQUIRED => 'Upgrade Required',\n"
    "        self::PRECONDITION_REQUIRED => 'Precondition Required',\n"
    "        self::TOO_MANY_REQUESTS => 'Too Many Requests',\n"
    "        self::REQUEST_HEADER_FIELDS_TOO_LARGE => 'Request Header Fields Too Large',\n"
    "        self::UNAVAILABLE_FOR_LEGAL_REASONS => 'Unavailable For Legal Reasons',\n"
    "        self::INTERNAL_SERVER_ERROR => 'Internal Server Error',\n"
    "        self::NOT_IMPLEMENTED => 'Not Implemented',\n"
    "        self::BAD_GATEWAY => 'Bad Gateway',\n"
    "        self::SERVICE_UNAVAILABLE => 'Service Unavailable',\n"
    "        self::GATEWAY_TIME_OUT => 'Gateway Time-out',\n"
    "        self::HTTP_VERSION_NOT_SUPPORTED => 'HTTP Version not supported',\n"
    "        self::VARIANT_ALSO_NEGOTIATES => 'Variant Also Negotiates',\n"
    "        self::INSUFFICIENT_STORAGE => 'Insufficient Storage',\n"
    "        self::LOOP_DETECTED => 'Loop Detected',\n"
    "        self::NOT_EXTENDED => 'Not Extended',\n"
    "        self::NETWORK_AUTHENTICATION_REQUIRED => 'Network Authentication Required',\n"
    "    ];\n"
    "\n"
    "    public static function getReasonPhrases(): array\n"
    "    {\n"
    "        return static::$reasonPhrases;\n"
    "    }\n"
    "\n"
    "    public static function getReasonPhrase(int $value): string\n"
    "    {\n"
    "        return static::$reasonPhrases[$value] ?? 'Unknown';\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_curl_exception =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Curl;\n"
    "\n"
    "use Swoole;\n"
    "\n"
    "class Exception extends Swoole\\Exception\n"
    "{\n"
    "}\n";

static const char* swoole_library_source_core_curl_handler =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "/* @noinspection PhpComposerExtensionStubsInspection, PhpDuplicateSwitchCaseBodyInspection, PhpInconsistentReturnPointsInspection */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Curl;\n"
    "\n"
    "use CURLFile;\n"
    "use ReflectionClass;\n"
    "use Swoole;\n"
    "use Swoole\\Constant;\n"
    "use Swoole\\Coroutine\\Http\\Client;\n"
    "use Swoole\\Curl\\Exception as CurlException;\n"
    "use Swoole\\Http\\Status;\n"
    "\n"
    "final class Handler\n"
    "{\n"
    "    /**\n"
    "     * @var Client\n"
    "     */\n"
    "    private $client;\n"
    "\n"
    "    private $info = [\n"
    "        'url' => '',\n"
    "        'content_type' => '',\n"
    "        'http_code' => 0,\n"
    "        'header_size' => 0,\n"
    "        'request_size' => 0,\n"
    "        'filetime' => -1,\n"
    "        'ssl_verify_result' => 0,\n"
    "        'redirect_count' => 0,\n"
    "        'total_time' => 5.3E-5,\n"
    "        'namelookup_time' => 0.0,\n"
    "        'connect_time' => 0.0,\n"
    "        'pretransfer_time' => 0.0,\n"
    "        'size_upload' => 0.0,\n"
    "        'size_download' => 0.0,\n"
    "        'speed_download' => 0.0,\n"
    "        'speed_upload' => 0.0,\n"
    "        'download_content_length' => -1.0,\n"
    "        'upload_content_length' => -1.0,\n"
    "        'starttransfer_time' => 0.0,\n"
    "        'redirect_time' => 0.0,\n"
    "        'redirect_url' => '',\n"
    "        'primary_ip' => '',\n"
    "        'certinfo' => [],\n"
    "        'primary_port' => 0,\n"
    "        'local_ip' => '',\n"
    "        'local_port' => 0,\n"
    "        'http_version' => 0,\n"
    "        'protocol' => 0,\n"
    "        'ssl_verifyresult' => 0,\n"
    "        'scheme' => '',\n"
    "    ];\n"
    "\n"
    "    private $withHeaderOut = false;\n"
    "\n"
    "    private $withFileTime = false;\n"
    "\n"
    "    private $urlInfo;\n"
    "\n"
    "    private $postData;\n"
    "\n"
    "    private $infile;\n"
    "\n"
    "    private $infileSize = PHP_INT_MAX;\n"
    "\n"
    "    private $outputStream;\n"
    "\n"
    "    private $proxyType;\n"
    "\n"
    "    private $proxy;\n"
    "\n"
    "    private $proxyPort = 1080;\n"
    "\n"
    "    private $proxyUsername;\n"
    "\n"
    "    private $proxyPassword;\n"
    "\n"
    "    private $clientOptions = [];\n"
    "\n"
    "    private $followLocation = false;\n"
    "\n"
    "    private $autoReferer = false;\n"
    "\n"
    "    private $maxRedirects;\n"
    "\n"
    "    private $withHeader = false;\n"
    "\n"
    "    private $nobody = false;\n"
    "\n"
    "    /** @var callable */\n"
    "    private $headerFunction;\n"
    "\n"
    "    /** @var callable */\n"
    "    private $readFunction;\n"
    "\n"
    "    /** @var callable */\n"
    "    private $writeFunction;\n"
    "\n"
    "    /** @var callable */\n"
    "    private $progressFunction;\n"
    "\n"
    "    private $returnTransfer = false;\n"
    "\n"
    "    private $method = '';\n"
    "\n"
    "    private $headers = [];\n"
    "\n"
    "    private $headerMap = [];\n"
    "\n"
    "    private $transfer;\n"
    "\n"
    "    private $errCode = 0;\n"
    "\n"
    "    private $errMsg = '';\n"
    "\n"
    "    private $failOnError = false;\n"
    "\n"
    "    private $closed = false;\n"
    "\n"
    "    private $cookieJar = '';\n"
    "\n"
    "    public function __construct(string $url = '')\n"
    "    {\n"
    "        if ($url) {\n"
    "            $this->setUrl($url);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function __toString()\n"
    "    {\n"
    "        $id = spl_object_id($this);\n"
    "        return \"Object({$id}) of type (curl)\";\n"
    "    }\n"
    "\n"
    "    /* ====== Public APIs ====== */\n"
    "\n"
    "    public function isAvailable(): bool\n"
    "    {\n"
    "        if ($this->closed) {\n"
    "            trigger_error('supplied resource is not a valid cURL handle resource', E_USER_WARNING);\n"
    "            return false;\n"
    "        }\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    public function setOpt(int $opt, $value): bool\n"
    "    {\n"
    "        return $this->isAvailable() and $this->setOption($opt, $value);\n"
    "    }\n"
    "\n"
    "    public function exec()\n"
    "    {\n"
    "        if (!$this->isAvailable()) {\n"
    "            return false;\n"
    "        }\n"
    "        return $this->execute();\n"
    "    }\n"
    "\n"
    "    public function getInfo()\n"
    "    {\n"
    "        return $this->isAvailable() ? $this->info : false;\n"
    "    }\n"
    "\n"
    "    public function errno()\n"
    "    {\n"
    "        return $this->isAvailable() ? $this->errCode : false;\n"
    "    }\n"
    "\n"
    "    public function error()\n"
    "    {\n"
    "        return $this->isAvailable() ? $this->errMsg : false;\n"
    "    }\n"
    "\n"
    "    public function reset()\n"
    "    {\n"
    "        if (!$this->isAvailable()) {\n"
    "            return false;\n"
    "        }\n"
    "        foreach ((new ReflectionClass(static::class))->getDefaultProperties() as $name => $value) {\n"
    "            $this->{$name} = $value;\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function getContent()\n"
    "    {\n"
    "        if (!$this->isAvailable()) {\n"
    "            return false;\n"
    "        }\n"
    "        return $this->transfer;\n"
    "    }\n"
    "\n"
    "    public function close()\n"
    "    {\n"
    "        if (!$this->isAvailable()) {\n"
    "            return false;\n"
    "        }\n"
    "        foreach ($this as &$property) {\n"
    "            $property = null;\n"
    "        }\n"
    "        $this->closed = true;\n"
    "    }\n"
    "\n"
    "    private function create(?array $urlInfo = null): void\n"
    "    {\n"
    "        if ($urlInfo === null) {\n"
    "            $urlInfo = $this->urlInfo;\n"
    "        }\n"
    "        $this->client = new Client($urlInfo['host'], $urlInfo['port'], $urlInfo['scheme'] === 'https');\n"
    "    }\n"
    "\n"
    "    private function getUrl(): string\n"
    "    {\n"
    "        if (empty($this->urlInfo['path'])) {\n"
    "            $url = '/';\n"
    "        } else {\n"
    "            $url = $this->urlInfo['path'];\n"
    "        }\n"
    "        if (!empty($this->urlInfo['query'])) {\n"
    "            $url .= '?' . $this->urlInfo['query'];\n"
    "        }\n"
    "        if (!empty($this->urlInfo['fragment'])) {\n"
    "            $url .= '#' . $this->urlInfo['fragment'];\n"
    "        }\n"
    "        return $url;\n"
    "    }\n"
    "\n"
    "    private function setUrl(string $url, bool $setInfo = true): bool\n"
    "    {\n"
    "        if (strlen($url) === 0) {\n"
    "            $this->setError(CURLE_URL_MALFORMAT, 'No URL set!');\n"
    "            return false;\n"
    "        }\n"
    "        if (strpos($url, '://') === false) {\n"
    "            $url = 'http://' . $url;\n"
    "        }\n"
    "        if ($setInfo) {\n"
    "            $urlInfo = parse_url($url);\n"
    "            if (!is_array($urlInfo)) {\n"
    "                $this->setError(CURLE_URL_MALFORMAT, \"URL[{$url}] using bad/illegal format\");\n"
    "                return false;\n"
    "            }\n"
    "            if (!$this->setUrlInfo($urlInfo)) {\n"
    "                return false;\n"
    "            }\n"
    "        }\n"
    "        $this->info['url'] = $url;\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    private function setUrlInfo(array $urlInfo): bool\n"
    "    {\n"
    "        if (empty($urlInfo['scheme'])) {\n"
    "            $urlInfo['scheme'] = 'http';\n"
    "        }\n"
    "        $scheme = $urlInfo['scheme'];\n"
    "        if ($scheme !== 'http' and $scheme !== 'https') {\n"
    "            $this->setError(CURLE_UNSUPPORTED_PROTOCOL, \"Protocol \\\"{$scheme}\\\" not supported or disabled in libcurl\");\n"
    "            return false;\n"
    "        }\n"
    "        $host = $urlInfo['host'];\n"
    "        if ($this->info['primary_port'] !== 0) {\n"
    "            /* keep same with cURL, primary_port has the highest priority */\n"
    "            $urlInfo['port'] = $this->info['primary_port'];\n"
    "        } elseif (empty($urlInfo['port'])) {\n"
    "            $urlInfo['port'] = $scheme === 'https' ? 443 : 80;\n"
    "        } else {\n"
    "            $urlInfo['port'] = intval($urlInfo['port']);\n"
    "        }\n"
    "        $port = $urlInfo['port'];\n"
    "        if ($this->client) {\n"
    "            $oldUrlInfo = $this->urlInfo;\n"
    "            if (($host !== $oldUrlInfo['host']) || ($port !== $oldUrlInfo['port']) || ($scheme !== $oldUrlInfo['scheme'])) {\n"
    "                /* target changed */\n"
    "                $this->create($urlInfo);\n"
    "            }\n"
    "        }\n"
    "        $this->urlInfo = $urlInfo;\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    private function setPort(int $port): void\n"
    "    {\n"
    "        $this->info['primary_port'] = $port;\n"
    "        if (!isset($this->urlInfo['port']) || $this->urlInfo['port'] !== $port) {\n"
    "            $this->urlInfo['port'] = $port;\n"
    "            if ($this->client) {\n"
    "                /* target changed */\n"
    "                $this->create();\n"
    "            }\n"
    "        }\n"
    "    }\n"
    "\n"
    "    private function setError($code, $msg = ''): void\n"
    "    {\n"
    "        $this->errCode = $code;\n"
    "        $this->errMsg = $msg ? $msg : curl_strerror($code);\n"
    "    }\n"
    "\n"
    "    private function hasHeader(string $headerName): bool\n"
    "    {\n"
    "        return isset($this->headerMap[strtolower($headerName)]);\n"
    "    }\n"
    "\n"
    "    private function setHeader(string $headerName, string $value): void\n"
    "    {\n"
    "        $lowerCaseHeaderName = strtolower($headerName);\n"
    "\n"
    "        if (isset($this->headerMap[$lowerCaseHeaderName])) {\n"
    "            unset($this->headers[$this->headerMap[$lowerCaseHeaderName]]);\n"
    "        }\n"
    "\n"
    "        if ($value !== '') {\n"
    "            $this->headers[$headerName] = $value;\n"
    "            $this->headerMap[$lowerCaseHeaderName] = $headerName;\n"
    "        } else {\n"
    "            // remove empty headers (keep same with raw cURL)\n"
    "            unset($this->headerMap[$lowerCaseHeaderName]);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @throws Swoole\\Curl\\Exception\n"
    "     */\n"
    "    private function setOption(int $opt, $value): bool\n"
    "    {\n"
    "        switch ($opt) {\n"
    "            // case CURLOPT_STDERR:\n"
    "            // case CURLOPT_WRITEHEADER:\n"
    "            case CURLOPT_FILE:\n"
    "            case CURLOPT_INFILE:\n"
    "                if (!is_resource($value)) {\n"
    "                    trigger_error('swoole_curl_setopt(): supplied argument is not a valid File-Handle resource', E_USER_WARNING);\n"
    "                    return false;\n"
    "                }\n"
    "                break;\n"
    "        }\n"
    "\n"
    "        switch ($opt) {\n"
    "            /*\n"
    "             * Basic\n"
    "             */\n"
    "            case CURLOPT_URL:\n"
    "                return $this->setUrl((string) $value);\n"
    "            case CURLOPT_PORT:\n"
    "                $this->setPort((int) $value);\n"
    "                break;\n"
    "            case CURLOPT_FORBID_REUSE:\n"
    "                $this->clientOptions[Constant::OPTION_KEEP_ALIVE] = !$value;\n"
    "                break;\n"
    "            case CURLOPT_RETURNTRANSFER:\n"
    "                $this->returnTransfer = $value;\n"
    "                $this->transfer = '';\n"
    "                break;\n"
    "            case CURLOPT_ENCODING:\n"
    "                if (empty($value)) {\n"
    "                    if (defined('SWOOLE_HAVE_ZLIB')) {\n"
    "                        $value = 'gzip, deflate';\n"
    "                    }\n"
    "                    if (defined('SWOOLE_HAVE_BROTLI')) {\n"
    "                        if (!empty($value)) {\n"
    "                            $value = 'br, ' . $value;\n"
    "                        } else {\n"
    "                            $value = 'br';\n"
    "                        }\n"
    "                    }\n"
    "                    if (empty($value)) {\n"
    "                        break;\n"
    "                    }\n"
    "                }\n"
    "                $this->setHeader('Accept-Encoding', $value);\n"
    "                break;\n"
    "            case CURLOPT_PROXYTYPE:\n"
    "                if ($value !== CURLPROXY_HTTP and $value !== CURLPROXY_SOCKS5) {\n"
    "                    throw new Swoole\\Curl\\Exception(\n"
    "                        'swoole_curl_setopt(): Only support following CURLOPT_PROXYTYPE values: CURLPROXY_HTTP, CURLPROXY_SOCKS5'\n"
    "                    );\n"
    "                }\n"
    "                $this->proxyType = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXY:\n"
    "                $this->proxy = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXYPORT:\n"
    "                $this->proxyPort = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXYUSERNAME:\n"
    "                $this->proxyUsername = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXYPASSWORD:\n"
    "                $this->proxyPassword = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXYUSERPWD:\n"
    "                $usernamePassword = explode(':', $value);\n"
    "                $this->proxyUsername = urldecode($usernamePassword[0]);\n"
    "                $this->proxyPassword = urldecode($usernamePassword[1] ?? null);\n"
    "                break;\n"
    "            case CURLOPT_PROXYAUTH:\n"
    "                /* ignored temporarily */\n"
    "                break;\n"
    "            case CURLOPT_NOBODY:\n"
    "                $this->nobody = boolval($value);\n"
    "                $this->method = 'HEAD';\n"
    "                break;\n"
    "            case CURLOPT_IPRESOLVE:\n"
    "                if ($value !== CURL_IPRESOLVE_WHATEVER and $value !== CURL_IPRESOLVE_V4) {\n"
    "                    throw new Swoole\\Curl\\Exception(\n"
    "                        'swoole_curl_setopt(): Only support following CURLOPT_IPRESOLVE values: CURL_IPRESOLVE_WHATEVER, CURL_IPRESOLVE_V4'\n"
    "                    );\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_TCP_NODELAY:\n"
    "                $this->clientOptions[Constant::OPTION_OPEN_TCP_NODELAY] = boolval($value);\n"
    "                break;\n"
    "            /*\n"
    "             * Ignore options\n"
    "             */\n"
    "            case CURLOPT_VERBOSE:\n"
    "                // trigger_error('swoole_curl_setopt(): CURLOPT_VERBOSE is not supported', E_USER_WARNING);\n"
    "            case CURLOPT_SSLVERSION:\n"
    "            case CURLOPT_NOSIGNAL:\n"
    "            case CURLOPT_FRESH_CONNECT:\n"
    "            /*\n"
    "             * From PHP 5.1.3, this option has no effect: the raw output will always be returned when CURLOPT_RETURNTRANSFER is used.\n"
    "             */\n"
    "            case CURLOPT_BINARYTRANSFER: /* TODO */\n"
    "            case CURLOPT_DNS_USE_GLOBAL_CACHE:\n"
    "            case CURLOPT_DNS_CACHE_TIMEOUT:\n"
    "            case CURLOPT_STDERR:\n"
    "            case CURLOPT_WRITEHEADER:\n"
    "            case CURLOPT_BUFFERSIZE:\n"
    "            case CURLOPT_SSLCERTTYPE:\n"
    "            case CURLOPT_SSLKEYTYPE:\n"
    "            case CURLOPT_NOPROXY:\n"
    "            case CURLOPT_CERTINFO:\n"
    "            case CURLOPT_HEADEROPT:\n"
    "            case CURLOPT_PROXYHEADER:\n"
    "                break;\n"
    "            /*\n"
    "             * SSL\n"
    "             */\n"
    "            case CURLOPT_SSL_VERIFYHOST:\n"
    "                break;\n"
    "            case CURLOPT_SSL_VERIFYPEER:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_VERIFY_PEER] = $value;\n"
    "                break;\n"
    "            case CURLOPT_SSLCERT:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_CERT_FILE] = $value;\n"
    "                break;\n"
    "            case CURLOPT_SSLKEY:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_KEY_FILE] = $value;\n"
    "                break;\n"
    "            case CURLOPT_CAINFO:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_CAFILE] = $value;\n"
    "                break;\n"
    "            case CURLOPT_CAPATH:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_CAPATH] = $value;\n"
    "                break;\n"
    "            case CURLOPT_KEYPASSWD:\n"
    "            case CURLOPT_SSLCERTPASSWD:\n"
    "            case CURLOPT_SSLKEYPASSWD:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_PASSPHRASE] = $value;\n"
    "                break;\n"
    "            /*\n"
    "             * Http POST\n"
    "             */\n"
    "            case CURLOPT_POST:\n"
    "                $this->method = 'POST';\n"
    "                break;\n"
    "            case CURLOPT_POSTFIELDS:\n"
    "                $this->postData = $value;\n"
    "                if (!$this->method) {\n"
    "                    $this->method = 'POST';\n"
    "                }\n"
    "                break;\n"
    "            /*\n"
    "             * Upload\n"
    "             */\n"
    "            case CURLOPT_SAFE_UPLOAD:\n"
    "                if (!$value) {\n"
    "                    trigger_error('swoole_curl_setopt(): Disabling safe uploads is no longer supported', E_USER_WARNING);\n"
    "                    return false;\n"
    "                }\n"
    "                break;\n"
    "            /*\n"
    "             * Http Header\n"
    "             */\n"
    "            case CURLOPT_HTTPHEADER:\n"
    "                if (!is_array($value) and !is_iterable($value)) {\n"
    "                    trigger_error('swoole_curl_setopt(): You must pass either an object or an array with the CURLOPT_HTTPHEADER argument', E_USER_WARNING);\n"
    "                    return false;\n"
    "                }\n"
    "                foreach ($value as $header) {\n"
    "                    $header = explode(':', $header, 2);\n"
    "                    $headerName = $header[0];\n"
    "                    $headerValue = trim($header[1] ?? '');\n"
    "                    $this->setHeader($headerName, $headerValue);\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_REFERER:\n"
    "                $this->setHeader('Referer', $value);\n"
    "                break;\n"
    "            case CURLINFO_HEADER_OUT:\n"
    "                $this->withHeaderOut = boolval($value);\n"
    "                break;\n"
    "            case CURLOPT_FILETIME:\n"
    "                $this->withFileTime = boolval($value);\n"
    "                break;\n"
    "            case CURLOPT_USERAGENT:\n"
    "                $this->setHeader('User-Agent', $value);\n"
    "                break;\n"
    "            case CURLOPT_CUSTOMREQUEST:\n"
    "                $this->method = (string) $value;\n"
    "                break;\n"
    "            case CURLOPT_PROTOCOLS:\n"
    "                if (($value & ~(CURLPROTO_HTTP | CURLPROTO_HTTPS)) != 0) {\n"
    "                    throw new CurlException(\"swoole_curl_setopt(): CURLOPT_PROTOCOLS[{$value}] is not supported\");\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_REDIR_PROTOCOLS:\n"
    "                if (($value & ~(CURLPROTO_HTTP | CURLPROTO_HTTPS)) != 0) {\n"
    "                    throw new CurlException(\"swoole_curl_setopt(): CURLOPT_REDIR_PROTOCOLS[{$value}] is not supported\");\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_HTTP_VERSION:\n"
    "                if ($value != CURL_HTTP_VERSION_1_1) {\n"
    "                    trigger_error(\"swoole_curl_setopt(): CURLOPT_HTTP_VERSION[{$value}] is not supported\", E_USER_WARNING);\n"
    "                    return false;\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_FAILONERROR:\n"
    "                $this->failOnError = $value;\n"
    "                break;\n"
    "            /*\n"
    "             * Http Cookie\n"
    "             */\n"
    "            case CURLOPT_COOKIE:\n"
    "                $this->setHeader('Cookie', $value);\n"
    "                break;\n"
    "            case CURLOPT_COOKIEJAR:\n"
    "                $this->cookieJar = (string) $value;\n"
    "                break;\n"
    "            case CURLOPT_COOKIEFILE:\n"
    "                if (is_file((string) $value)) {\n"
    "                    $this->setHeader('Cookie', file_get_contents($value));\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_CONNECTTIMEOUT:\n"
    "                $this->clientOptions[Constant::OPTION_CONNECT_TIMEOUT] = $value;\n"
    "                break;\n"
    "            case CURLOPT_CONNECTTIMEOUT_MS:\n"
    "                $this->clientOptions[Constant::OPTION_CONNECT_TIMEOUT] = $value / 1000;\n"
    "                break;\n"
    "            case CURLOPT_TIMEOUT:\n"
    "                $this->clientOptions[Constant::OPTION_TIMEOUT] = $value;\n"
    "                break;\n"
    "            case CURLOPT_TIMEOUT_MS:\n"
    "                $this->clientOptions[Constant::OPTION_TIMEOUT] = $value / 1000;\n"
    "                break;\n"
    "            case CURLOPT_FILE:\n"
    "                $this->outputStream = $value;\n"
    "                break;\n"
    "            case CURLOPT_HEADER:\n"
    "                $this->withHeader = $value;\n"
    "                break;\n"
    "            case CURLOPT_HEADERFUNCTION:\n"
    "                $this->headerFunction = $value;\n"
    "                break;\n"
    "            case CURLOPT_READFUNCTION:\n"
    "                $this->readFunction = $value;\n"
    "                break;\n"
    "            case CURLOPT_WRITEFUNCTION:\n"
    "                $this->writeFunction = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROGRESSFUNCTION:\n"
    "                $this->progressFunction = $value;\n"
    "                break;\n"
    "            case CURLOPT_HTTPAUTH:\n"
    "                if (!($value & CURLAUTH_BASIC)) {\n"
    "                    trigger_error(\"swoole_curl_setopt(): CURLOPT_HTTPAUTH[{$value}] is not supported\", E_USER_WARNING);\n"
    "                    return false;\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_USERPWD:\n"
    "                $this->setHeader('Authorization', 'Basic ' . base64_encode($value));\n"
    "                break;\n"
    "            case CURLOPT_FOLLOWLOCATION:\n"
    "                $this->followLocation = $value;\n"
    "                break;\n"
    "            case CURLOPT_AUTOREFERER:\n"
    "                $this->autoReferer = $value;\n"
    "                break;\n"
    "            case CURLOPT_MAXREDIRS:\n"
    "                $this->maxRedirects = $value;\n"
    "                break;\n"
    "            case CURLOPT_PUT:\n"
    "            case CURLOPT_UPLOAD:\n"
    "                /* after libcurl 7.12, CURLOPT_PUT is replaced by CURLOPT_UPLOAD */\n"
    "                $this->method = 'PUT';\n"
    "                break;\n"
    "            case CURLOPT_INFILE:\n"
    "                $this->infile = $value;\n"
    "                break;\n"
    "            case CURLOPT_INFILESIZE:\n"
    "                $this->infileSize = $value;\n"
    "                break;\n"
    "            case CURLOPT_HTTPGET:\n"
    "                /* Since GET is the default, this is only necessary if the request method has been changed. */\n"
    "                $this->method = 'GET';\n"
    "                break;\n"
    "            default:\n"
    "                throw new Swoole\\Curl\\Exception(\"swoole_curl_setopt(): option[{$opt}] is not supported\");\n"
    "        }\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    private function execute()\n"
    "    {\n"
    "        $this->info['redirect_count'] = $this->info['starttransfer_time'] = 0;\n"
    "        $this->info['redirect_url'] = '';\n"
    "        $timeBegin = microtime(true);\n"
    "        /*\n"
    "         * Socket\n"
    "         */\n"
    "        if (!$this->urlInfo) {\n"
    "            $this->setError(CURLE_URL_MALFORMAT, 'No URL set or URL using bad/illegal format');\n"
    "            return false;\n"
    "        }\n"
    "        if (!$this->client) {\n"
    "            $this->create();\n"
    "        }\n"
    "        do {\n"
    "            $client = $this->client;\n"
    "            /*\n"
    "             * Http Proxy\n"
    "             */\n"
    "            if ($this->proxy) {\n"
    "                $parse = parse_url($this->proxy);\n"
    "                $proxy = $parse['host'] ?? $parse['path'];\n"
    "                $proxyPort = $parse['port'] ?? $this->proxyPort;\n"
    "                $proxyUsername = $parse['user'] ?? $this->proxyUsername;\n"
    "                $proxyPassword = $parse['pass'] ?? $this->proxyPassword;\n"
    "                $proxyType = $parse['scheme'] ?? $this->proxyType;\n"
    "                if (is_string($proxyType)) {\n"
    "                    if ($proxyType === 'socks5') {\n"
    "                        $proxyType = CURLPROXY_SOCKS5;\n"
    "                    } else {\n"
    "                        $proxyType = CURLPROXY_HTTP;\n"
    "                    }\n"
    "                }\n"
    "\n"
    "                if (!filter_var($proxy, FILTER_VALIDATE_IP)) {\n"
    "                    $ip = Swoole\\Coroutine::gethostbyname($proxy, AF_INET, $this->clientOptions['connect_timeout'] ?? -1);\n"
    "                    if (!$ip) {\n"
    "                        $this->setError(CURLE_COULDNT_RESOLVE_PROXY, 'Could not resolve proxy: ' . $proxy);\n"
    "                        return false;\n"
    "                    }\n"
    "                    $this->proxy = $proxy = $ip;\n"
    "                }\n"
    "                switch ($proxyType) {\n"
    "                    case CURLPROXY_HTTP:\n"
    "                        $proxyOptions = [\n"
    "                            'http_proxy_host' => $proxy,\n"
    "                            'http_proxy_port' => $proxyPort,\n"
    "                            'http_proxy_username' => $proxyUsername,\n"
    "                            'http_proxy_password' => $proxyPassword,\n"
    "                        ];\n"
    "                        break;\n"
    "                    case CURLPROXY_SOCKS5:\n"
    "                        $proxyOptions = [\n"
    "                            'socks5_host' => $proxy,\n"
    "                            'socks5_port' => $proxyPort,\n"
    "                            'socks5_username' => $proxyUsername,\n"
    "                            'socks5_password' => $proxyPassword,\n"
    "                        ];\n"
    "                        break;\n"
    "                    default:\n"
    "                        throw new CurlException(\"Unexpected proxy type [{$proxyType}]\");\n"
    "                }\n"
    "            }\n"
    "            /*\n"
    "             * Client Options\n"
    "             */\n"
    "            $client->set(\n"
    "                $this->clientOptions +\n"
    "                ($proxyOptions ?? [])\n"
    "            );\n"
    "            /*\n"
    "             * Method\n"
    "             */\n"
    "            if ($this->method) {\n"
    "                $client->setMethod($this->method);\n"
    "            }\n"
    "            /*\n"
    "             * Data\n"
    "             */\n"
    "            if ($this->infile) {\n"
    "                // Infile\n"
    "                // Notice: we make its priority higher than postData but raw cURL will send both of them\n"
    "                $data = '';\n"
    "                while (true) {\n"
    "                    $nLength = $this->infileSize - strlen($data);\n"
    "                    if ($nLength === 0) {\n"
    "                        break;\n"
    "                    }\n"
    "                    if (feof($this->infile)) {\n"
    "                        break;\n"
    "                    }\n"
    "                    $data .= fread($this->infile, $nLength);\n"
    "                }\n"
    "                $client->setData($data);\n"
    "                // Notice: although we reset it, raw cURL never do this\n"
    "                $this->infile = null;\n"
    "                $this->infileSize = PHP_INT_MAX;\n"
    "            } else {\n"
    "                // POST data\n"
    "                if ($this->postData) {\n"
    "                    if (is_string($this->postData)) {\n"
    "                        if (!$this->hasHeader('content-type')) {\n"
    "                            $this->setHeader('Content-Type', 'application/x-www-form-urlencoded');\n"
    "                        }\n"
    "                    } elseif (is_array($this->postData)) {\n"
    "                        foreach ($this->postData as $k => $v) {\n"
    "                            if ($v instanceof CURLFile) {\n"
    "                                $client->addFile($v->getFilename(), $k, $v->getMimeType() ?: 'application/octet-stream', $v->getPostFilename());\n"
    "                                unset($this->postData[$k]);\n"
    "                            }\n"
    "                        }\n"
    "                    }\n"
    "                }\n"
    "                $client->setData($this->postData);\n"
    "            }\n"
    "            /*\n"
    "             * Headers\n"
    "             */\n"
    "            // Notice: setHeaders must be placed last, because headers may be changed by other parts\n"
    "            // As much as possible to ensure that Host is the first header.\n"
    "            // See: http://tools.ietf.org/html/rfc7230#section-5.4\n"
    "            $client->setHeaders($this->headers);\n"
    "            /**\n"
    "             * Execute.\n"
    "             */\n"
    "            $executeResult = $client->execute($this->getUrl());\n"
    "            if (!$executeResult) {\n"
    "                $errCode = $client->errCode;\n"
    "                if ($errCode == SWOOLE_ERROR_DNSLOOKUP_RESOLVE_FAILED or $errCode == SWOOLE_ERROR_DNSLOOKUP_RESOLVE_TIMEOUT) {\n"
    "                    $this->setError(CURLE_COULDNT_RESOLVE_HOST, 'Could not resolve host: ' . $client->host);\n"
    "                } else {\n"
    "                    $this->setError($errCode, $client->errMsg);\n"
    "                }\n"
    "                $this->info['total_time'] = microtime(true) - $timeBegin;\n"
    "                return false;\n"
    "            }\n"
    "            if ($client->statusCode >= 300 and $client->statusCode < 400 and isset($client->headers['location'])) {\n"
    "                $redirectParsedUrl = $this->getRedirectUrl($client->headers['location']);\n"
    "                $redirectUrl = static::unparseUrl($redirectParsedUrl);\n"
    "                if ($this->followLocation and ($this->maxRedirects === null or $this->info['redirect_count'] < $this->maxRedirects)) {\n"
    "                    if ($this->info['redirect_count'] === 0) {\n"
    "                        $this->info['starttransfer_time'] = microtime(true) - $timeBegin;\n"
    "                        $redirectBeginTime = microtime(true);\n"
    "                    }\n"
    "                    // force GET\n"
    "                    if (in_array($client->statusCode, [Status::MOVED_PERMANENTLY, Status::FOUND, Status::SEE_OTHER])) {\n"
    "                        $this->method = 'GET';\n"
    "                    }\n"
    "                    if ($this->autoReferer) {\n"
    "                        $this->setHeader('Referer', $this->info['url']);\n"
    "                    }\n"
    "                    $this->setUrl($redirectUrl, false);\n"
    "                    $this->setUrlInfo($redirectParsedUrl);\n"
    "                    $this->info['redirect_count']++;\n"
    "                } else {\n"
    "                    $this->info['redirect_url'] = $redirectUrl;\n"
    "                    break;\n"
    "                }\n"
    "            } elseif ($this->failOnError && $client->statusCode >= 400) {\n"
    "                $this->setError(CURLE_HTTP_RETURNED_ERROR, \"The requested URL returned error: {$client->statusCode} \" . Status::getReasonPhrase($client->statusCode));\n"
    "                return false;\n"
    "            } else {\n"
    "                break;\n"
    "            }\n"
    "        } while (true);\n"
    "        $this->info['total_time'] = microtime(true) - $timeBegin;\n"
    "        $this->info['http_code'] = $client->statusCode;\n"
    "        $this->info['content_type'] = $client->headers['content-type'] ?? '';\n"
    "        $this->info['size_download'] = $this->info['download_content_length'] = strlen($client->body);\n"
    "        $this->info['speed_download'] = 1 / $this->info['total_time'] * $this->info['size_download'];\n"
    "        if (isset($redirectBeginTime)) {\n"
    "            $this->info['redirect_time'] = microtime(true) - $redirectBeginTime;\n"
    "        }\n"
    "\n"
    "        $headerContent = '';\n"
    "        if ($client->headers) {\n"
    "            $cb = $this->headerFunction;\n"
    "            if ($client->statusCode > 0) {\n"
    "                $row = \"HTTP/1.1 {$client->statusCode} \" . Status::getReasonPhrase($client->statusCode) . \"\\r\\n\";\n"
    "                if ($cb) {\n"
    "                    $cb($this, $row);\n"
    "                }\n"
    "                $headerContent .= $row;\n"
    "            }\n"
    "            foreach ($client->headers as $k => $v) {\n"
    "                $row = \"{$k}: {$v}\\r\\n\";\n"
    "                if ($cb) {\n"
    "                    $cb($this, $row);\n"
    "                }\n"
    "                $headerContent .= $row;\n"
    "            }\n"
    "            $headerContent .= \"\\r\\n\";\n"
    "            $this->info['header_size'] = strlen($headerContent);\n"
    "            if ($cb) {\n"
    "                $cb($this, '');\n"
    "            }\n"
    "        } else {\n"
    "            $this->info['header_size'] = 0;\n"
    "        }\n"
    "\n"
    "        if ($client->body and $this->readFunction) {\n"
    "            $cb = $this->readFunction;\n"
    "            $cb($this, $this->outputStream, strlen($client->body));\n"
    "        }\n"
    "\n"
    "        if ($this->withHeader) {\n"
    "            $transfer = $headerContent . $client->body;\n"
    "        } else {\n"
    "            $transfer = $client->body;\n"
    "        }\n"
    "\n"
    "        if ($this->withHeaderOut) {\n"
    "            $headerOutContent = $client->getHeaderOut();\n"
    "            $this->info['request_header'] = $headerOutContent ? $headerOutContent . \"\\r\\n\\r\\n\" : '';\n"
    "        }\n"
    "        if ($this->withFileTime) {\n"
    "            if (isset($client->headers['last-modified'])) {\n"
    "                $this->info['filetime'] = strtotime($client->headers['last-modified']);\n"
    "            } else {\n"
    "                $this->info['filetime'] = -1;\n"
    "            }\n"
    "        }\n"
    "\n"
    "        if ($this->cookieJar && $this->cookieJar !== '') {\n"
    "            if ($this->cookieJar === '-') {\n"
    "                foreach ((array) $client->set_cookie_headers as $cookie) {\n"
    "                    echo $cookie . PHP_EOL;\n"
    "                }\n"
    "            } else {\n"
    "                $cookies = '';\n"
    "                foreach ((array) $client->set_cookie_headers as $cookie) {\n"
    "                    $cookies .= \"{$cookie};\";\n"
    "                }\n"
    "                file_put_contents($this->cookieJar, $cookies);\n"
    "            }\n"
    "        }\n"
    "\n"
    "        if ($this->writeFunction) {\n"
    "            if (!is_callable($this->writeFunction)) {\n"
    "                trigger_error('curl_exec(): Could not call the CURLOPT_WRITEFUNCTION', E_USER_WARNING);\n"
    "                $this->setError(CURLE_WRITE_ERROR, 'Failure writing output to destination');\n"
    "                return false;\n"
    "            }\n"
    "            call_user_func($this->writeFunction, $this, $transfer);\n"
    "            return true;\n"
    "        }\n"
    "\n"
    "        if ($this->returnTransfer) {\n"
    "            return $this->transfer = $transfer;\n"
    "        }\n"
    "        if ($this->outputStream) {\n"
    "            return fwrite($this->outputStream, $transfer) === strlen($transfer);\n"
    "        }\n"
    "        echo $transfer;\n"
    "\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    /* ====== Redirect helper ====== */\n"
    "\n"
    "    private static function unparseUrl(array $parsedUrl): string\n"
    "    {\n"
    "        $scheme = ($parsedUrl['scheme'] ?? 'http') . '://';\n"
    "        $host = $parsedUrl['host'] ?? '';\n"
    "        $port = isset($parsedUrl['port']) ? ':' . $parsedUrl['port'] : '';\n"
    "        $user = $parsedUrl['user'] ?? '';\n"
    "        $pass = isset($parsedUrl['pass']) ? ':' . $parsedUrl['pass'] : '';\n"
    "        $pass = ($user or $pass) ? \"{$pass}@\" : '';\n"
    "        $path = $parsedUrl['path'] ?? '';\n"
    "        $query = (isset($parsedUrl['query']) and $parsedUrl['query'] !== '') ? '?' . $parsedUrl['query'] : '';\n"
    "        $fragment = isset($parsedUrl['fragment']) ? '#' . $parsedUrl['fragment'] : '';\n"
    "        return $scheme . $user . $pass . $host . $port . $path . $query . $fragment;\n"
    "    }\n"
    "\n"
    "    private function getRedirectUrl(string $location): array\n"
    "    {\n"
    "        $uri = parse_url($location);\n"
    "        if (isset($uri['host'])) {\n"
    "            $redirectUri = $uri;\n"
    "        } else {\n"
    "            if (!isset($location[0])) {\n"
    "                return [];\n"
    "            }\n"
    "            $redirectUri = $this->urlInfo;\n"
    "            $redirectUri['query'] = '';\n"
    "            if ($location[0] === '/') {\n"
    "                $redirectUri['path'] = $location;\n"
    "            } else {\n"
    "                $path = dirname($redirectUri['path'] ?? '');\n"
    "                if ($path === '.') {\n"
    "                    $path = '/';\n"
    "                }\n"
    "                if (isset($location[1]) and substr($location, 0, 2) === './') {\n"
    "                    $location = substr($location, 2);\n"
    "                }\n"
    "                $redirectUri['path'] = $path . $location;\n"
    "            }\n"
    "            if (is_array($uri)) {\n"
    "                foreach ($uri as $k => $v) {\n"
    "                    if (!in_array($k, ['path', 'query'])) {\n"
    "                        $redirectUri[$k] = $v;\n"
    "                    }\n"
    "                }\n"
    "            }\n"
    "        }\n"
    "        return $redirectUri;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "/**\n"
    " * FastCGI constants.\n"
    " */\n"
    "class FastCGI\n"
    "{\n"
    "    /**\n"
    "     * Number of bytes in a FCGI_Header.  Future versions of the protocol\n"
    "     * will not reduce this number.\n"
    "     */\n"
    "    public const HEADER_LEN = 8;\n"
    "\n"
    "    /**\n"
    "     * Format of FCGI_HEADER for unpacking in PHP\n"
    "     */\n"
    "    public const HEADER_FORMAT = 'Cversion/Ctype/nrequestId/ncontentLength/CpaddingLength/Creserved';\n"
    "\n"
    "    /**\n"
    "     * Max content length of a record\n"
    "     */\n"
    "    public const MAX_CONTENT_LENGTH = 65535;\n"
    "\n"
    "    /**\n"
    "     * Value for version component of FCGI_Header\n"
    "     */\n"
    "    public const VERSION_1 = 1;\n"
    "\n"
    "    /**\n"
    "     * Values for type component of FCGI_Header\n"
    "     */\n"
    "    public const BEGIN_REQUEST = 1;\n"
    "\n"
    "    public const ABORT_REQUEST = 2;\n"
    "\n"
    "    public const END_REQUEST = 3;\n"
    "\n"
    "    public const PARAMS = 4;\n"
    "\n"
    "    public const STDIN = 5;\n"
    "\n"
    "    public const STDOUT = 6;\n"
    "\n"
    "    public const STDERR = 7;\n"
    "\n"
    "    public const DATA = 8;\n"
    "\n"
    "    public const GET_VALUES = 9;\n"
    "\n"
    "    public const GET_VALUES_RESULT = 10;\n"
    "\n"
    "    public const UNKNOWN_TYPE = 11;\n"
    "\n"
    "    /**\n"
    "     * Value for requestId component of FCGI_Header\n"
    "     */\n"
    "    public const DEFAULT_REQUEST_ID = 1;\n"
    "\n"
    "    /**\n"
    "     * Mask for flags component of FCGI_BeginRequestBody\n"
    "     */\n"
    "    public const KEEP_CONN = 1;\n"
    "\n"
    "    /**\n"
    "     * Values for role component of FCGI_BeginRequestBody\n"
    "     */\n"
    "    public const RESPONDER = 1;\n"
    "\n"
    "    public const AUTHORIZER = 2;\n"
    "\n"
    "    public const FILTER = 3;\n"
    "\n"
    "    /**\n"
    "     * Values for protocolStatus component of FCGI_EndRequestBody\n"
    "     */\n"
    "    public const REQUEST_COMPLETE = 0;\n"
    "\n"
    "    public const CANT_MPX_CONN = 1;\n"
    "\n"
    "    public const OVERLOADED = 2;\n"
    "\n"
    "    public const UNKNOWN_ROLE = 3;\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "\n"
    "/**\n"
    " * FastCGI record.\n"
    " */\n"
    "class Record\n"
    "{\n"
    "    /**\n"
    "     * Identifies the FastCGI protocol version.\n"
    "     *\n"
    "     * @var int\n"
    "     */\n"
    "    protected $version = FastCGI::VERSION_1;\n"
    "\n"
    "    /**\n"
    "     * Identifies the FastCGI record type, i.e. the general function that the record performs.\n"
    "     *\n"
    "     * @var int\n"
    "     */\n"
    "    protected $type = FastCGI::UNKNOWN_TYPE;\n"
    "\n"
    "    /**\n"
    "     * Identifies the FastCGI request to which the record belongs.\n"
    "     *\n"
    "     * @var int\n"
    "     */\n"
    "    protected $requestId = FastCGI::DEFAULT_REQUEST_ID;\n"
    "\n"
    "    /**\n"
    "     * Reserved byte for future proposes\n"
    "     *\n"
    "     * @var int\n"
    "     */\n"
    "    protected $reserved = 0;\n"
    "\n"
    "    /**\n"
    "     * The number of bytes in the contentData component of the record.\n"
    "     *\n"
    "     * @var int\n"
    "     */\n"
    "    private $contentLength = 0;\n"
    "\n"
    "    /**\n"
    "     * The number of bytes in the paddingData component of the record.\n"
    "     *\n"
    "     * @var int\n"
    "     */\n"
    "    private $paddingLength = 0;\n"
    "\n"
    "    /**\n"
    "     * Binary data, between 0 and 65535 bytes of data, interpreted according to the record type.\n"
    "     *\n"
    "     * @var string\n"
    "     */\n"
    "    private $contentData = '';\n"
    "\n"
    "    /**\n"
    "     * Padding data, between 0 and 255 bytes of data, which are ignored.\n"
    "     *\n"
    "     * @var string\n"
    "     */\n"
    "    private $paddingData = '';\n"
    "\n"
    "    /**\n"
    "     * Returns the binary message representation of record\n"
    "     */\n"
    "    final public function __toString(): string\n"
    "    {\n"
    "        $headerPacket = pack(\n"
    "            'CCnnCC',\n"
    "            $this->version,\n"
    "            $this->type,\n"
    "            $this->requestId,\n"
    "            $this->contentLength,\n"
    "            $this->paddingLength,\n"
    "            $this->reserved\n"
    "        );\n"
    "\n"
    "        $payloadPacket = $this->packPayload();\n"
    "        $paddingPacket = pack(\"a{$this->paddingLength}\", $this->paddingData);\n"
    "\n"
    "        return $headerPacket . $payloadPacket . $paddingPacket;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Unpacks the message from the binary data buffer\n"
    "     *\n"
    "     * @param string $data Binary buffer with raw data\n"
    "     *\n"
    "     * @return static\n"
    "     */\n"
    "    final public static function unpack(string $data): self\n"
    "    {\n"
    "        $self = new static();\n"
    "        [\n"
    "            $self->version,\n"
    "            $self->type,\n"
    "            $self->requestId,\n"
    "            $self->contentLength,\n"
    "            $self->paddingLength,\n"
    "            $self->reserved\n"
    "        ] = array_values(unpack(FastCGI::HEADER_FORMAT, $data));\n"
    "\n"
    "        $payload = substr($data, FastCGI::HEADER_LEN);\n"
    "        self::unpackPayload($self, $payload);\n"
    "        if (get_called_class() !== __CLASS__ && $self->contentLength > 0) {\n"
    "            static::unpackPayload($self, $payload);\n"
    "        }\n"
    "\n"
    "        return $self;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Sets the content data and adjusts the length fields\n"
    "     *\n"
    "     * @return static\n"
    "     */\n"
    "    public function setContentData(string $data): self\n"
    "    {\n"
    "        $this->contentLength = strlen($data);\n"
    "        if ($this->contentLength > FastCGI::MAX_CONTENT_LENGTH) {\n"
    "            $this->contentLength = FastCGI::MAX_CONTENT_LENGTH;\n"
    "            $this->contentData = substr($data, 0, FastCGI::MAX_CONTENT_LENGTH);\n"
    "        } else {\n"
    "            $this->contentData = $data;\n"
    "        }\n"
    "        $extraLength = $this->contentLength % 8;\n"
    "        $this->paddingLength = $extraLength ? (8 - $extraLength) : 0;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the context data from the record\n"
    "     */\n"
    "    public function getContentData(): string\n"
    "    {\n"
    "        return $this->contentData;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the version of record\n"
    "     */\n"
    "    public function getVersion(): int\n"
    "    {\n"
    "        return $this->version;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns record type\n"
    "     */\n"
    "    public function getType(): int\n"
    "    {\n"
    "        return $this->type;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns request ID\n"
    "     */\n"
    "    public function getRequestId(): int\n"
    "    {\n"
    "        return $this->requestId;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Sets request ID\n"
    "     *\n"
    "     * There should be only one unique ID for all active requests,\n"
    "     * use random number or preferably resetting auto-increment.\n"
    "     *\n"
    "     * @return static\n"
    "     */\n"
    "    public function setRequestId(int $requestId): self\n"
    "    {\n"
    "        $this->requestId = $requestId;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the size of content length\n"
    "     */\n"
    "    final public function getContentLength(): int\n"
    "    {\n"
    "        return $this->contentLength;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the size of padding length\n"
    "     */\n"
    "    final public function getPaddingLength(): int\n"
    "    {\n"
    "        return $this->paddingLength;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Method to unpack the payload for the record.\n"
    "     *\n"
    "     * NB: Default implementation will be always called\n"
    "     *\n"
    "     * @param static $self Instance of current frame\n"
    "     * @param string $data Binary data\n"
    "     */\n"
    "    protected static function unpackPayload($self, string $data): void\n"
    "    {\n"
    "        [\n"
    "            $self->contentData,\n"
    "            $self->paddingData\n"
    "        ] = array_values(\n"
    "            unpack(\"a{$self->contentLength}contentData/a{$self->paddingLength}paddingData\", $data)\n"
    "        );\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Implementation of packing the payload\n"
    "     */\n"
    "    protected function packPayload(): string\n"
    "    {\n"
    "        return pack(\"a{$this->contentLength}\", $this->contentData);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_params =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * Params request record\n"
    " */\n"
    "class Params extends Record\n"
    "{\n"
    "    /**\n"
    "     * List of params\n"
    "     *\n"
    "     * @var array\n"
    "     */\n"
    "    protected $values = [];\n"
    "\n"
    "    /**\n"
    "     * Constructs a param request\n"
    "     */\n"
    "    public function __construct(array $values = [])\n"
    "    {\n"
    "        $this->type = FastCGI::PARAMS;\n"
    "        $this->values = $values;\n"
    "        $this->setContentData($this->packPayload());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns an associative list of parameters\n"
    "     */\n"
    "    public function getValues(): array\n"
    "    {\n"
    "        return $this->values;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * {@inheritdoc}\n"
    "     * @param static $self\n"
    "     */\n"
    "    protected static function unpackPayload($self, string $data): void\n"
    "    {\n"
    "        $currentOffset = 0;\n"
    "        do {\n"
    "            [$nameLengthHigh] = array_values(unpack('CnameLengthHigh', $data));\n"
    "            $isLongName = ($nameLengthHigh >> 7 == 1);\n"
    "            $valueOffset = $isLongName ? 4 : 1;\n"
    "\n"
    "            [$valueLengthHigh] = array_values(unpack('CvalueLengthHigh', substr($data, $valueOffset)));\n"
    "            $isLongValue = ($valueLengthHigh >> 7 == 1);\n"
    "            $dataOffset = $valueOffset + ($isLongValue ? 4 : 1);\n"
    "\n"
    "            $formatParts = [\n"
    "                $isLongName ? 'NnameLength' : 'CnameLength',\n"
    "                $isLongValue ? 'NvalueLength' : 'CvalueLength',\n"
    "            ];\n"
    "            $format = join('/', $formatParts);\n"
    "            [$nameLength, $valueLength] = array_values(unpack($format, $data));\n"
    "\n"
    "            // Clear top bit for long record\n"
    "            $nameLength &= ($isLongName ? 0x7fffffff : 0x7f);\n"
    "            $valueLength &= ($isLongValue ? 0x7fffffff : 0x7f);\n"
    "\n"
    "            [$nameData, $valueData] = array_values(\n"
    "                unpack(\n"
    "                    \"a{$nameLength}nameData/a{$valueLength}valueData\",\n"
    "                    substr($data, $dataOffset)\n"
    "                )\n"
    "            );\n"
    "\n"
    "            $self->values[$nameData] = $valueData;\n"
    "\n"
    "            $keyValueLength = $dataOffset + $nameLength + $valueLength;\n"
    "            $data = substr($data, $keyValueLength);\n"
    "            $currentOffset += $keyValueLength;\n"
    "        } while ($currentOffset < $self->getContentLength());\n"
    "    }\n"
    "\n"
    "    /** {@inheritdoc} */\n"
    "    protected function packPayload(): string\n"
    "    {\n"
    "        $payload = '';\n"
    "        foreach ($this->values as $nameData => $valueData) {\n"
    "            if ($valueData === null) {\n"
    "                continue;\n"
    "            }\n"
    "            $nameLength = strlen($nameData);\n"
    "            $valueLength = strlen((string) $valueData);\n"
    "            $isLongName = $nameLength > 127;\n"
    "            $isLongValue = $valueLength > 127;\n"
    "            $formatParts = [\n"
    "                $isLongName ? 'N' : 'C',\n"
    "                $isLongValue ? 'N' : 'C',\n"
    "                \"a{$nameLength}\",\n"
    "                \"a{$valueLength}\",\n"
    "            ];\n"
    "            $format = join('', $formatParts);\n"
    "\n"
    "            $payload .= pack(\n"
    "                $format,\n"
    "                $isLongName ? ($nameLength | 0x80000000) : $nameLength,\n"
    "                $isLongValue ? ($valueLength | 0x80000000) : $valueLength,\n"
    "                $nameData,\n"
    "                $valueData\n"
    "            );\n"
    "        }\n"
    "\n"
    "        return $payload;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_abort_request =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * The Web server sends a FCGI_ABORT_REQUEST record to abort a request\n"
    " */\n"
    "class AbortRequest extends Record\n"
    "{\n"
    "    public function __construct(int $requestId = 0)\n"
    "    {\n"
    "        $this->type = FastCGI::ABORT_REQUEST;\n"
    "        $this->setRequestId($requestId);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_begin_request =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * The Web server sends a FCGI_BEGIN_REQUEST record to start a request.\n"
    " */\n"
    "class BeginRequest extends Record\n"
    "{\n"
    "    /**\n"
    "     * The role component sets the role the Web server expects the application to play.\n"
    "     * The currently-defined roles are:\n"
    "     *   FCGI_RESPONDER\n"
    "     *   FCGI_AUTHORIZER\n"
    "     *   FCGI_FILTER\n"
    "     *\n"
    "     * @var int\n"
    "     */\n"
    "    protected $role = FastCGI::UNKNOWN_ROLE;\n"
    "\n"
    "    /**\n"
    "     * The flags component contains a bit that controls connection shutdown.\n"
    "     *\n"
    "     * flags & FCGI_KEEP_CONN:\n"
    "     *   If zero, the application closes the connection after responding to this request.\n"
    "     *   If not zero, the application does not close the connection after responding to this request;\n"
    "     *   the Web server retains responsibility for the connection.\n"
    "     *\n"
    "     * @var int\n"
    "     */\n"
    "    protected $flags;\n"
    "\n"
    "    /**\n"
    "     * Reserved data, 5 bytes maximum\n"
    "     *\n"
    "     * @var string\n"
    "     */\n"
    "    protected $reserved1;\n"
    "\n"
    "    public function __construct(int $role = FastCGI::UNKNOWN_ROLE, int $flags = 0, string $reserved = '')\n"
    "    {\n"
    "        $this->type = FastCGI::BEGIN_REQUEST;\n"
    "        $this->role = $role;\n"
    "        $this->flags = $flags;\n"
    "        $this->reserved1 = $reserved;\n"
    "        $this->setContentData($this->packPayload());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the role\n"
    "     *\n"
    "     * The role component sets the role the Web server expects the application to play.\n"
    "     * The currently-defined roles are:\n"
    "     *   FCGI_RESPONDER\n"
    "     *   FCGI_AUTHORIZER\n"
    "     *   FCGI_FILTER\n"
    "     */\n"
    "    public function getRole(): int\n"
    "    {\n"
    "        return $this->role;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the flags\n"
    "     *\n"
    "     * The flags component contains a bit that controls connection shutdown.\n"
    "     *\n"
    "     * flags & FCGI_KEEP_CONN:\n"
    "     *   If zero, the application closes the connection after responding to this request.\n"
    "     *   If not zero, the application does not close the connection after responding to this request;\n"
    "     *   the Web server retains responsibility for the connection.\n"
    "     */\n"
    "    public function getFlags(): int\n"
    "    {\n"
    "        return $this->flags;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * {@inheritdoc}\n"
    "     * @param static $self\n"
    "     */\n"
    "    protected static function unpackPayload($self, string $data): void\n"
    "    {\n"
    "        [\n"
    "            $self->role,\n"
    "            $self->flags,\n"
    "            $self->reserved1\n"
    "        ] = array_values(unpack('nrole/Cflags/a5reserved', $data));\n"
    "    }\n"
    "\n"
    "    /** {@inheritdoc} */\n"
    "    protected function packPayload(): string\n"
    "    {\n"
    "        return pack(\n"
    "            'nCa5',\n"
    "            $this->role,\n"
    "            $this->flags,\n"
    "            $this->reserved1\n"
    "        );\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_data =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * Data binary stream\n"
    " *\n"
    " * FCGI_DATA is a second stream record type used to send additional data to the application.\n"
    " */\n"
    "class Data extends Record\n"
    "{\n"
    "    public function __construct(string $contentData = '')\n"
    "    {\n"
    "        $this->type = FastCGI::DATA;\n"
    "        $this->setContentData($contentData);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_end_request =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * The application sends a FCGI_END_REQUEST record to terminate a request, either because the application\n"
    " * has processed the request or because the application has rejected the request.\n"
    " */\n"
    "class EndRequest extends Record\n"
    "{\n"
    "    /**\n"
    "     * The appStatus component is an application-level status code. Each role documents its usage of appStatus.\n"
    "     *\n"
    "     * @var int\n"
    "     */\n"
    "    protected $appStatus = 0;\n"
    "\n"
    "    /**\n"
    "     * The protocolStatus component is a protocol-level status code.\n"
    "     *\n"
    "     * The possible protocolStatus values are:\n"
    "     *   FCGI_REQUEST_COMPLETE: normal end of request.\n"
    "     *   FCGI_CANT_MPX_CONN: rejecting a new request.\n"
    "     *      This happens when a Web server sends concurrent requests over one connection to an application that is\n"
    "     *      designed to process one request at a time per connection.\n"
    "     *   FCGI_OVERLOADED: rejecting a new request.\n"
    "     *      This happens when the application runs out of some resource, e.g. database connections.\n"
    "     *   FCGI_UNKNOWN_ROLE: rejecting a new request.\n"
    "     *      This happens when the Web server has specified a role that is unknown to the application.\n"
    "     *\n"
    "     * @var int\n"
    "     */\n"
    "    protected $protocolStatus = FastCGI::REQUEST_COMPLETE;\n"
    "\n"
    "    /**\n"
    "     * Reserved data, 3 bytes maximum\n"
    "     *\n"
    "     * @var string\n"
    "     */\n"
    "    protected $reserved1;\n"
    "\n"
    "    public function __construct(\n"
    "        int $protocolStatus = FastCGI::REQUEST_COMPLETE,\n"
    "        int $appStatus = 0,\n"
    "        string $reserved = ''\n"
    "    ) {\n"
    "        $this->type = FastCGI::END_REQUEST;\n"
    "        $this->protocolStatus = $protocolStatus;\n"
    "        $this->appStatus = $appStatus;\n"
    "        $this->reserved1 = $reserved;\n"
    "        $this->setContentData($this->packPayload());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns app status\n"
    "     *\n"
    "     * The appStatus component is an application-level status code. Each role documents its usage of appStatus.\n"
    "     */\n"
    "    public function getAppStatus(): int\n"
    "    {\n"
    "        return $this->appStatus;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the protocol status\n"
    "     *\n"
    "     * The possible protocolStatus values are:\n"
    "     *   FCGI_REQUEST_COMPLETE: normal end of request.\n"
    "     *   FCGI_CANT_MPX_CONN: rejecting a new request.\n"
    "     *      This happens when a Web server sends concurrent requests over one connection to an application that is\n"
    "     *      designed to process one request at a time per connection.\n"
    "     *   FCGI_OVERLOADED: rejecting a new request.\n"
    "     *      This happens when the application runs out of some resource, e.g. database connections.\n"
    "     *   FCGI_UNKNOWN_ROLE: rejecting a new request.\n"
    "     *      This happens when the Web server has specified a role that is unknown to the application.\n"
    "     */\n"
    "    public function getProtocolStatus(): int\n"
    "    {\n"
    "        return $this->protocolStatus;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * {@inheritdoc}\n"
    "     * @param static $self\n"
    "     */\n"
    "    protected static function unpackPayload($self, string $data): void\n"
    "    {\n"
    "        [\n"
    "            $self->appStatus,\n"
    "            $self->protocolStatus,\n"
    "            $self->reserved1\n"
    "        ] = array_values(unpack('NappStatus/CprotocolStatus/a3reserved', $data));\n"
    "    }\n"
    "\n"
    "    /** {@inheritdoc} */\n"
    "    protected function packPayload(): string\n"
    "    {\n"
    "        return pack(\n"
    "            'NCa3',\n"
    "            $this->appStatus,\n"
    "            $this->protocolStatus,\n"
    "            $this->reserved1\n"
    "        );\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_get_values =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "\n"
    "/**\n"
    " * GetValues API\n"
    " *\n"
    " * The Web server can query specific variables within the application.\n"
    " * The server will typically perform a query on application startup in order to to automate certain aspects of\n"
    " * system configuration.\n"
    " *\n"
    " * The application responds by sending a record {FCGI_GET_VALUES_RESULT, 0, ...} with the values supplied.\n"
    " * If the application doesn't understand a variable name that was included in the query, it omits that name from\n"
    " * the response.\n"
    " *\n"
    " * FCGI_GET_VALUES is designed to allow an open-ended set of variables.\n"
    " *\n"
    " * The initial set provides information to help the server perform application and connection management:\n"
    " *   FCGI_MAX_CONNS:  The maximum number of concurrent transport connections this application will accept,\n"
    " *                    e.g. \"1\" or \"10\".\n"
    " *   FCGI_MAX_REQS:   The maximum number of concurrent requests this application will accept, e.g. \"1\" or \"50\".\n"
    " *   FCGI_MPXS_CONNS: \"0\" if this application does not multiplex connections (i.e. handle concurrent requests\n"
    " *                    over each connection), \"1\" otherwise.\n"
    " */\n"
    "class GetValues extends Params\n"
    "{\n"
    "    /**\n"
    "     * Constructs a request\n"
    "     *\n"
    "     * @param array $keys List of keys to receive\n"
    "     */\n"
    "    public function __construct(array $keys = [])\n"
    "    {\n"
    "        parent::__construct(array_fill_keys($keys, ''));\n"
    "        $this->type = FastCGI::GET_VALUES;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_get_values_result =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "\n"
    "/**\n"
    " * GetValues API\n"
    " *\n"
    " * The Web server can query specific variables within the application.\n"
    " * The server will typically perform a query on application startup in order to to automate certain aspects of\n"
    " * system configuration.\n"
    " *\n"
    " * The application responds by sending a record {FCGI_GET_VALUES_RESULT, 0, ...} with the values supplied.\n"
    " * If the application doesn't understand a variable name that was included in the query, it omits that name from\n"
    " * the response.\n"
    " *\n"
    " * FCGI_GET_VALUES is designed to allow an open-ended set of variables.\n"
    " *\n"
    " * The initial set provides information to help the server perform application and connection management:\n"
    " *   FCGI_MAX_CONNS:  The maximum number of concurrent transport connections this application will accept,\n"
    " *                    e.g. \"1\" or \"10\".\n"
    " *   FCGI_MAX_REQS:   The maximum number of concurrent requests this application will accept, e.g. \"1\" or \"50\".\n"
    " *   FCGI_MPXS_CONNS: \"0\" if this application does not multiplex connections (i.e. handle concurrent requests\n"
    " *                    over each connection), \"1\" otherwise.\n"
    " */\n"
    "class GetValuesResult extends Params\n"
    "{\n"
    "    /**\n"
    "     * Constructs a param request\n"
    "     */\n"
    "    public function __construct(array $values = [])\n"
    "    {\n"
    "        parent::__construct($values);\n"
    "        $this->type = FastCGI::GET_VALUES_RESULT;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_stdin =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * Stdin binary stream\n"
    " *\n"
    " * FCGI_STDIN is a stream record type used in sending arbitrary data from the Web server to the application\n"
    " */\n"
    "class Stdin extends Record\n"
    "{\n"
    "    public function __construct(string $contentData = '')\n"
    "    {\n"
    "        $this->type = FastCGI::STDIN;\n"
    "        $this->setContentData($contentData);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_stdout =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * Stdout binary stream\n"
    " *\n"
    " * FCGI_STDOUT is a stream record for sending arbitrary data from the application to the Web server\n"
    " */\n"
    "class Stdout extends Record\n"
    "{\n"
    "    public function __construct(string $contentData = '')\n"
    "    {\n"
    "        $this->type = FastCGI::STDOUT;\n"
    "        $this->setContentData($contentData);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_stderr =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * Stderr binary stream\n"
    " *\n"
    " * FCGI_STDERR is a stream record for sending arbitrary data from the application to the Web server\n"
    " */\n"
    "class Stderr extends Record\n"
    "{\n"
    "    public function __construct(string $contentData = '')\n"
    "    {\n"
    "        $this->type = FastCGI::STDERR;\n"
    "        $this->setContentData($contentData);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_record_unknown_type =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI\\Record;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record;\n"
    "\n"
    "/**\n"
    " * Record for unknown queries\n"
    " *\n"
    " * The set of management record types is likely to grow in future versions of this protocol.\n"
    " * To provide for this evolution, the protocol includes the FCGI_UNKNOWN_TYPE management record.\n"
    " * When an application receives a management record whose type T it does not understand, the application responds\n"
    " * with {FCGI_UNKNOWN_TYPE, 0, {T}}.\n"
    " */\n"
    "class UnknownType extends Record\n"
    "{\n"
    "    /**\n"
    "     * Type of the unrecognized management record.\n"
    "     *\n"
    "     * @var int\n"
    "     */\n"
    "    protected $type1;\n"
    "\n"
    "    /**\n"
    "     * Reserved data, 7 bytes maximum\n"
    "     *\n"
    "     * @var string\n"
    "     */\n"
    "    protected $reserved1;\n"
    "\n"
    "    public function __construct(int $type = 0, string $reserved = '')\n"
    "    {\n"
    "        $this->type = FastCGI::UNKNOWN_TYPE;\n"
    "        $this->type1 = $type;\n"
    "        $this->reserved1 = $reserved;\n"
    "        $this->setContentData($this->packPayload());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the unrecognized type\n"
    "     */\n"
    "    public function getUnrecognizedType(): int\n"
    "    {\n"
    "        return $this->type1;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * {@inheritdoc}\n"
    "     * @param static $self\n"
    "     */\n"
    "    public static function unpackPayload($self, string $data): void\n"
    "    {\n"
    "        [$self->type1, $self->reserved1] = array_values(unpack('Ctype/a7reserved', $data));\n"
    "    }\n"
    "\n"
    "    /** {@inheritdoc} */\n"
    "    protected function packPayload(): string\n"
    "    {\n"
    "        return pack(\n"
    "            'Ca7',\n"
    "            $this->type1,\n"
    "            $this->reserved1\n"
    "        );\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_frame_parser =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI;\n"
    "\n"
    "use DomainException;\n"
    "use RuntimeException;\n"
    "use Swoole\\FastCGI;\n"
    "\n"
    "/**\n"
    " * Utility class to simplify parsing of FastCGI protocol data.\n"
    " */\n"
    "class FrameParser\n"
    "{\n"
    "    /**\n"
    "     * Mapping of constants to the classes\n"
    "     *\n"
    "     * @var array\n"
    "     */\n"
    "    protected static $classMapping = [\n"
    "        FastCGI::BEGIN_REQUEST => FastCGI\\Record\\BeginRequest::class,\n"
    "        FastCGI::ABORT_REQUEST => FastCGI\\Record\\AbortRequest::class,\n"
    "        FastCGI::END_REQUEST => FastCGI\\Record\\EndRequest::class,\n"
    "        FastCGI::PARAMS => FastCGI\\Record\\Params::class,\n"
    "        FastCGI::STDIN => FastCGI\\Record\\Stdin::class,\n"
    "        FastCGI::STDOUT => FastCGI\\Record\\Stdout::class,\n"
    "        FastCGI::STDERR => FastCGI\\Record\\Stderr::class,\n"
    "        FastCGI::DATA => FastCGI\\Record\\Data::class,\n"
    "        FastCGI::GET_VALUES => FastCGI\\Record\\GetValues::class,\n"
    "        FastCGI::GET_VALUES_RESULT => FastCGI\\Record\\GetValuesResult::class,\n"
    "        FastCGI::UNKNOWN_TYPE => FastCGI\\Record\\UnknownType::class,\n"
    "    ];\n"
    "\n"
    "    /**\n"
    "     * Checks if the buffer contains a valid frame to parse\n"
    "     *\n"
    "     * @param string $buffer Binary buffer\n"
    "     */\n"
    "    public static function hasFrame(string $buffer): bool\n"
    "    {\n"
    "        $bufferLength = strlen($buffer);\n"
    "        if ($bufferLength < FastCGI::HEADER_LEN) {\n"
    "            return false;\n"
    "        }\n"
    "\n"
    "        $fastInfo = unpack(FastCGI::HEADER_FORMAT, $buffer);\n"
    "        if ($bufferLength < FastCGI::HEADER_LEN + $fastInfo['contentLength'] + $fastInfo['paddingLength']) {\n"
    "            return false;\n"
    "        }\n"
    "\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Parses a frame from the binary buffer\n"
    "     *\n"
    "     * @param string $buffer Binary buffer\n"
    "     *\n"
    "     * @return Record One of the corresponding FastCGI record\n"
    "     */\n"
    "    public static function parseFrame(string &$buffer): Record\n"
    "    {\n"
    "        $bufferLength = strlen($buffer);\n"
    "        if ($bufferLength < FastCGI::HEADER_LEN) {\n"
    "            throw new RuntimeException('Not enough data in the buffer to parse');\n"
    "        }\n"
    "        $recordHeader = unpack(FastCGI::HEADER_FORMAT, $buffer);\n"
    "        $recordType = $recordHeader['type'];\n"
    "        if (!isset(self::$classMapping[$recordType])) {\n"
    "            throw new DomainException(\"Invalid FastCGI record type {$recordType} received\");\n"
    "        }\n"
    "\n"
    "        /** @var Record $className */\n"
    "        $className = self::$classMapping[$recordType];\n"
    "        $record = $className::unpack($buffer);\n"
    "\n"
    "        $offset = FastCGI::HEADER_LEN + $record->getContentLength() + $record->getPaddingLength();\n"
    "        $buffer = substr($buffer, $offset);\n"
    "\n"
    "        return $record;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_message =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI;\n"
    "\n"
    "class Message\n"
    "{\n"
    "    /** @var array */\n"
    "    protected $params = [];\n"
    "\n"
    "    /** @var string */\n"
    "    protected $body = '';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $error = '';\n"
    "\n"
    "    public function getParam(string $name): ?string\n"
    "    {\n"
    "        return $this->params[$name] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withParam(string $name, string $value): self\n"
    "    {\n"
    "        $this->params[$name] = $value;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutParam(string $name): self\n"
    "    {\n"
    "        unset($this->params[$name]);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getParams(): array\n"
    "    {\n"
    "        return $this->params;\n"
    "    }\n"
    "\n"
    "    public function withParams(array $params): self\n"
    "    {\n"
    "        $this->params = $params;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withAddedParams(array $params): self\n"
    "    {\n"
    "        $this->params = $params + $this->params;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getBody(): string\n"
    "    {\n"
    "        return $this->body;\n"
    "    }\n"
    "\n"
    "    public function withBody($body): self\n"
    "    {\n"
    "        $this->body = (string) $body;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getError(): string\n"
    "    {\n"
    "        return $this->error;\n"
    "    }\n"
    "\n"
    "    public function withError(string $error): self\n"
    "    {\n"
    "        $this->error = $error;\n"
    "        return $this;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_request =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI;\n"
    "\n"
    "use Swoole\\FastCGI;\n"
    "use Swoole\\FastCGI\\Record\\BeginRequest;\n"
    "use Swoole\\FastCGI\\Record\\Params;\n"
    "use Swoole\\FastCGI\\Record\\Stdin;\n"
    "\n"
    "class Request extends Message\n"
    "{\n"
    "    protected $keepConn = false;\n"
    "\n"
    "    public function __toString(): string\n"
    "    {\n"
    "        $body = $this->getBody();\n"
    "        $beginRequestFrame = new BeginRequest(FastCGI::RESPONDER, ($this->keepConn ? FastCGI::KEEP_CONN : 0));\n"
    "        $paramsFrame = new Params($this->getParams());\n"
    "        $paramsEofFrame = new Params();\n"
    "        if (empty($body)) {\n"
    "            $message = \"{$beginRequestFrame}{$paramsFrame}{$paramsEofFrame}}\";\n"
    "        } else {\n"
    "            $stdinList = [];\n"
    "            while (true) {\n"
    "                $stdinList[] = $stdin = new Stdin($body);\n"
    "                $stdinLength = $stdin->getContentLength();\n"
    "                if ($stdinLength === strlen($body)) {\n"
    "                    break;\n"
    "                }\n"
    "                $body = substr($body, $stdinLength);\n"
    "            }\n"
    "            $stdinList[] = new Stdin();\n"
    "            $stdin = implode($stdinList);\n"
    "            $message = \"{$beginRequestFrame}{$paramsFrame}{$paramsEofFrame}{$stdin}}\";\n"
    "        }\n"
    "        return $message;\n"
    "    }\n"
    "\n"
    "    public function getKeepConn(): bool\n"
    "    {\n"
    "        return $this->keepConn;\n"
    "    }\n"
    "\n"
    "    public function withKeepConn(bool $keepConn): self\n"
    "    {\n"
    "        $this->keepConn = $keepConn;\n"
    "        return $this;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_response =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI;\n"
    "\n"
    "use InvalidArgumentException;\n"
    "use Swoole\\FastCGI\\Record\\EndRequest;\n"
    "use Swoole\\FastCGI\\Record\\Stderr;\n"
    "use Swoole\\FastCGI\\Record\\Stdout;\n"
    "\n"
    "class Response extends Message\n"
    "{\n"
    "    public function __construct(array $records = [])\n"
    "    {\n"
    "        if (!static::verify($records)) {\n"
    "            throw new InvalidArgumentException('Bad records');\n"
    "        }\n"
    "        $body = '';\n"
    "        $error = '';\n"
    "        foreach ($records as $record) {\n"
    "            if ($record instanceof Stdout) {\n"
    "                if ($record->getContentLength() > 0) {\n"
    "                    $body .= $record->getContentData();\n"
    "                }\n"
    "            } elseif ($record instanceof Stderr) {\n"
    "                if ($record->getContentLength() > 0) {\n"
    "                    $error .= $record->getContentData();\n"
    "                }\n"
    "            }\n"
    "        }\n"
    "        $this->withBody($body)->withError($error);\n"
    "    }\n"
    "\n"
    "    public static function verify(array $records): bool\n"
    "    {\n"
    "        return !empty($records) && $records[count($records) - 1] instanceof EndRequest;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_http_request =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI;\n"
    "\n"
    "use InvalidArgumentException;\n"
    "\n"
    "class HttpRequest extends Request\n"
    "{\n"
    "    protected $params = [\n"
    "        'REQUEST_SCHEME' => 'http',\n"
    "        'REQUEST_METHOD' => 'GET',\n"
    "        'DOCUMENT_ROOT' => '',\n"
    "        'SCRIPT_FILENAME' => '',\n"
    "        'SCRIPT_NAME' => '',\n"
    "        'DOCUMENT_URI' => '/',\n"
    "        'REQUEST_URI' => '/',\n"
    "        'QUERY_STRING' => '',\n"
    "        'CONTENT_TYPE' => 'text/plain',\n"
    "        'CONTENT_LENGTH' => '0',\n"
    "        'GATEWAY_INTERFACE' => 'CGI/1.1',\n"
    "        'SERVER_PROTOCOL' => 'HTTP/1.1',\n"
    "        'SERVER_SOFTWARE' => 'swoole/' . SWOOLE_VERSION,\n"
    "        'REMOTE_ADDR' => 'unknown',\n"
    "        'REMOTE_PORT' => '0',\n"
    "        'SERVER_ADDR' => 'unknown',\n"
    "        'SERVER_PORT' => '0',\n"
    "        'SERVER_NAME' => 'Swoole',\n"
    "        'REDIRECT_STATUS' => '200',\n"
    "    ];\n"
    "\n"
    "    public function getScheme(): ?string\n"
    "    {\n"
    "        return $this->params['REQUEST_SCHEME'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withScheme(string $scheme): self\n"
    "    {\n"
    "        $this->params['REQUEST_SCHEME'] = $scheme;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutScheme(): void\n"
    "    {\n"
    "        unset($this->params['REQUEST_SCHEME']);\n"
    "    }\n"
    "\n"
    "    public function getMethod(): ?string\n"
    "    {\n"
    "        return $this->params['REQUEST_METHOD'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withMethod(string $method): self\n"
    "    {\n"
    "        $this->params['REQUEST_METHOD'] = $method;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutMethod(): void\n"
    "    {\n"
    "        unset($this->params['REQUEST_METHOD']);\n"
    "    }\n"
    "\n"
    "    public function getDocumentRoot(): ?string\n"
    "    {\n"
    "        return $this->params['DOCUMENT_ROOT'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withDocumentRoot(string $documentRoot): self\n"
    "    {\n"
    "        $this->params['DOCUMENT_ROOT'] = $documentRoot;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutDocumentRoot(): void\n"
    "    {\n"
    "        unset($this->params['DOCUMENT_ROOT']);\n"
    "    }\n"
    "\n"
    "    public function getScriptFilename(): ?string\n"
    "    {\n"
    "        return $this->params['SCRIPT_FILENAME'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withScriptFilename(string $scriptFilename): self\n"
    "    {\n"
    "        $this->params['SCRIPT_FILENAME'] = $scriptFilename;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutScriptFilename(): void\n"
    "    {\n"
    "        unset($this->params['SCRIPT_FILENAME']);\n"
    "    }\n"
    "\n"
    "    public function getScriptName(): ?string\n"
    "    {\n"
    "        return $this->params['SCRIPT_NAME'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withScriptName(string $scriptName): self\n"
    "    {\n"
    "        $this->params['SCRIPT_NAME'] = $scriptName;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutScriptName(): void\n"
    "    {\n"
    "        unset($this->params['SCRIPT_NAME']);\n"
    "    }\n"
    "\n"
    "    public function withUri(string $uri): self\n"
    "    {\n"
    "        $info = parse_url($uri);\n"
    "        return $this->withRequestUri($uri)\n"
    "            ->withDocumentUri($info['path'] ?? '')\n"
    "            ->withQueryString($info['query'] ?? '');\n"
    "    }\n"
    "\n"
    "    public function getDocumentUri(): ?string\n"
    "    {\n"
    "        return $this->params['DOCUMENT_URI'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withDocumentUri(string $documentUri): self\n"
    "    {\n"
    "        $this->params['DOCUMENT_URI'] = $documentUri;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutDocumentUri(): void\n"
    "    {\n"
    "        unset($this->params['DOCUMENT_URI']);\n"
    "    }\n"
    "\n"
    "    public function getRequestUri(): ?string\n"
    "    {\n"
    "        return $this->params['REQUEST_URI'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withRequestUri(string $requestUri): self\n"
    "    {\n"
    "        $this->params['REQUEST_URI'] = $requestUri;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutRequestUri(): void\n"
    "    {\n"
    "        unset($this->params['REQUEST_URI']);\n"
    "    }\n"
    "\n"
    "    public function withQuery($query): self\n"
    "    {\n"
    "        if (is_array($query)) {\n"
    "            $query = http_build_query($query);\n"
    "        }\n"
    "        return $this->withQueryString($query);\n"
    "    }\n"
    "\n"
    "    public function getQueryString(): ?string\n"
    "    {\n"
    "        return $this->params['QUERY_STRING'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withQueryString(string $queryString): self\n"
    "    {\n"
    "        $this->params['QUERY_STRING'] = $queryString;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutQueryString(): void\n"
    "    {\n"
    "        unset($this->params['QUERY_STRING']);\n"
    "    }\n"
    "\n"
    "    public function getContentType(): ?string\n"
    "    {\n"
    "        return $this->params['CONTENT_TYPE'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withContentType(string $contentType): self\n"
    "    {\n"
    "        $this->params['CONTENT_TYPE'] = $contentType;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutContentType(): void\n"
    "    {\n"
    "        unset($this->params['CONTENT_TYPE']);\n"
    "    }\n"
    "\n"
    "    public function getContentLength(): ?int\n"
    "    {\n"
    "        return isset($this->params['CONTENT_LENGTH']) ? (int) $this->params['CONTENT_LENGTH'] : null;\n"
    "    }\n"
    "\n"
    "    public function withContentLength(int $contentLength): self\n"
    "    {\n"
    "        $this->params['CONTENT_LENGTH'] = (string) $contentLength;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutContentLength(): void\n"
    "    {\n"
    "        unset($this->params['CONTENT_LENGTH']);\n"
    "    }\n"
    "\n"
    "    public function getGatewayInterface(): ?string\n"
    "    {\n"
    "        return $this->params['GATEWAY_INTERFACE'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withGatewayInterface(string $gatewayInterface): self\n"
    "    {\n"
    "        $this->params['GATEWAY_INTERFACE'] = $gatewayInterface;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutGatewayInterface(): void\n"
    "    {\n"
    "        unset($this->params['GATEWAY_INTERFACE']);\n"
    "    }\n"
    "\n"
    "    public function getServerProtocol(): ?string\n"
    "    {\n"
    "        return $this->params['SERVER_PROTOCOL'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withServerProtocol(string $serverProtocol): self\n"
    "    {\n"
    "        $this->params['SERVER_PROTOCOL'] = $serverProtocol;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutServerProtocol(): void\n"
    "    {\n"
    "        unset($this->params['SERVER_PROTOCOL']);\n"
    "    }\n"
    "\n"
    "    public function withProtocolVersion(string $protocolVersion): self\n"
    "    {\n"
    "        if (!is_numeric($protocolVersion)) {\n"
    "            throw new InvalidArgumentException('Protocol version must be numeric');\n"
    "        }\n"
    "        $this->params['SERVER_PROTOCOL'] = \"HTTP/{$protocolVersion}\";\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getServerSoftware(): ?string\n"
    "    {\n"
    "        return $this->params['SERVER_SOFTWARE'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withServerSoftware(string $serverSoftware): self\n"
    "    {\n"
    "        $this->params['SERVER_SOFTWARE'] = $serverSoftware;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutServerSoftware(): void\n"
    "    {\n"
    "        unset($this->params['SERVER_SOFTWARE']);\n"
    "    }\n"
    "\n"
    "    public function getRemoteAddr(): ?string\n"
    "    {\n"
    "        return $this->params['REMOTE_ADDR'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withRemoteAddr(string $remoteAddr): self\n"
    "    {\n"
    "        $this->params['REMOTE_ADDR'] = $remoteAddr;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutRemoteAddr(): void\n"
    "    {\n"
    "        unset($this->params['REMOTE_ADDR']);\n"
    "    }\n"
    "\n"
    "    public function getRemotePort(): ?int\n"
    "    {\n"
    "        return isset($this->params['REMOTE_PORT']) ? (int) $this->params['REMOTE_PORT'] : null;\n"
    "    }\n"
    "\n"
    "    public function withRemotePort(int $remotePort): self\n"
    "    {\n"
    "        $this->params['REMOTE_PORT'] = (string) $remotePort;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutRemotePort(): void\n"
    "    {\n"
    "        unset($this->params['REMOTE_PORT']);\n"
    "    }\n"
    "\n"
    "    public function getServerAddr(): ?string\n"
    "    {\n"
    "        return $this->params['SERVER_ADDR'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withServerAddr(string $serverAddr): self\n"
    "    {\n"
    "        $this->params['SERVER_ADDR'] = $serverAddr;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutServerAddr(): void\n"
    "    {\n"
    "        unset($this->params['SERVER_ADDR']);\n"
    "    }\n"
    "\n"
    "    public function getServerPort(): ?int\n"
    "    {\n"
    "        return isset($this->params['SERVER_PORT']) ? (int) $this->params['SERVER_PORT'] : null;\n"
    "    }\n"
    "\n"
    "    public function withServerPort(int $serverPort): self\n"
    "    {\n"
    "        $this->params['SERVER_PORT'] = (string) $serverPort;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutServerPort(): void\n"
    "    {\n"
    "        unset($this->params['SERVER_PORT']);\n"
    "    }\n"
    "\n"
    "    public function getServerName(): ?string\n"
    "    {\n"
    "        return $this->params['SERVER_NAME'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withServerName(string $serverName): self\n"
    "    {\n"
    "        $this->params['SERVER_NAME'] = $serverName;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutServerName(): void\n"
    "    {\n"
    "        unset($this->params['SERVER_NAME']);\n"
    "    }\n"
    "\n"
    "    public function getRedirectStatus(): ?string\n"
    "    {\n"
    "        return $this->params['REDIRECT_STATUS'] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withRedirectStatus(string $redirectStatus): self\n"
    "    {\n"
    "        $this->params['REDIRECT_STATUS'] = $redirectStatus;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutRedirectStatus(): void\n"
    "    {\n"
    "        unset($this->params['REDIRECT_STATUS']);\n"
    "    }\n"
    "\n"
    "    public function getHeader(string $name): ?string\n"
    "    {\n"
    "        return $this->params[static::convertHeaderNameToParamName($name)] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withHeader(string $name, string $value): self\n"
    "    {\n"
    "        $this->params[static::convertHeaderNameToParamName($name)] = $value;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutHeader(string $name): void\n"
    "    {\n"
    "        unset($this->params[static::convertHeaderNameToParamName($name)]);\n"
    "    }\n"
    "\n"
    "    public function getHeaders(): array\n"
    "    {\n"
    "        $headers = [];\n"
    "        foreach ($this->params as $name => $value) {\n"
    "            if (strpos($name, 'HTTP_') === 0) {\n"
    "                $headers[static::convertParamNameToHeaderName($name)] = $value;\n"
    "            }\n"
    "        }\n"
    "        return $headers;\n"
    "    }\n"
    "\n"
    "    public function withHeaders(array $headers): self\n"
    "    {\n"
    "        foreach ($headers as $name => $value) {\n"
    "            $this->withHeader($name, $value);\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /** @return $this */\n"
    "    public function withBody($body): Message\n"
    "    {\n"
    "        if (is_array($body)) {\n"
    "            $body = http_build_query($body);\n"
    "            $this->withContentType('application/x-www-form-urlencoded');\n"
    "        }\n"
    "        parent::withBody($body);\n"
    "        return $this->withContentLength(strlen($body));\n"
    "    }\n"
    "\n"
    "    protected static function convertHeaderNameToParamName(string $name)\n"
    "    {\n"
    "        return 'HTTP_' . str_replace('-', '_', strtoupper($name));\n"
    "    }\n"
    "\n"
    "    protected static function convertParamNameToHeaderName(string $name)\n"
    "    {\n"
    "        return ucwords(str_replace('_', '-', substr($name, strlen('HTTP_'))), '-');\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_fast_cgi_http_response =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\FastCGI;\n"
    "\n"
    "use Swoole\\Http\\Status;\n"
    "\n"
    "class HttpResponse extends Response\n"
    "{\n"
    "    /** @var int */\n"
    "    protected $statusCode;\n"
    "\n"
    "    /** @var string */\n"
    "    protected $reasonPhrase;\n"
    "\n"
    "    /** @var array */\n"
    "    protected $headers = [];\n"
    "\n"
    "    /** @var array */\n"
    "    protected $headersMap = [];\n"
    "\n"
    "    /** @var array */\n"
    "    protected $setCookieHeaderLines = [];\n"
    "\n"
    "    public function __construct(array $records = [])\n"
    "    {\n"
    "        parent::__construct($records);\n"
    "        $body = (string) $this->getBody();\n"
    "        if (strlen($body) === 0) {\n"
    "            return;\n"
    "        }\n"
    "        $array = explode(\"\\r\\n\\r\\n\", $body, 2); // An array that contains the HTTP headers and the body.\n"
    "        if (count($array) != 2) {\n"
    "            $this->withStatusCode(Status::BAD_GATEWAY)->withReasonPhrase('Invalid FastCGI Response')->withError($body);\n"
    "            return;\n"
    "        }\n"
    "        $headers = explode(\"\\r\\n\", $array[0]);\n"
    "        $body = $array[1];\n"
    "        foreach ($headers as $header) {\n"
    "            $array = explode(':', $header, 2); // An array that contains the name and the value of an HTTP header.\n"
    "            if (count($array) != 2) {\n"
    "                continue; // Invalid HTTP header? Ignore it!\n"
    "            }\n"
    "            $name = trim($array[0]);\n"
    "            $value = trim($array[1]);\n"
    "            if (strcasecmp($name, 'Status') === 0) {\n"
    "                $array = explode(' ', $value, 2); // An array that contains the status code (and the reason phrase).\n"
    "                $statusCode = $array[0];\n"
    "                $reasonPhrase = $array[1] ?? null;\n"
    "            } elseif (strcasecmp($name, 'Set-Cookie') === 0) {\n"
    "                $this->withSetCookieHeaderLine($value);\n"
    "            } else {\n"
    "                $this->withHeader($name, $value);\n"
    "            }\n"
    "        }\n"
    "        $statusCode = (int) ($statusCode ?? Status::OK);\n"
    "        $reasonPhrase = (string) ($reasonPhrase ?? Status::getReasonPhrase($statusCode));\n"
    "        $this->withStatusCode($statusCode)->withReasonPhrase($reasonPhrase);\n"
    "        $this->withBody($body);\n"
    "    }\n"
    "\n"
    "    public function getStatusCode(): int\n"
    "    {\n"
    "        return $this->statusCode;\n"
    "    }\n"
    "\n"
    "    public function withStatusCode(int $statusCode): self\n"
    "    {\n"
    "        $this->statusCode = $statusCode;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getReasonPhrase(): string\n"
    "    {\n"
    "        return $this->reasonPhrase;\n"
    "    }\n"
    "\n"
    "    public function withReasonPhrase(string $reasonPhrase): self\n"
    "    {\n"
    "        $this->reasonPhrase = $reasonPhrase;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getHeader(string $name): ?string\n"
    "    {\n"
    "        $name = $this->headersMap[strtolower($name)] ?? null;\n"
    "        return $name ? $this->headers[$name] : null;\n"
    "    }\n"
    "\n"
    "    public function getHeaders(): array\n"
    "    {\n"
    "        return $this->headers;\n"
    "    }\n"
    "\n"
    "    public function withHeader(string $name, string $value): self\n"
    "    {\n"
    "        $this->headers[$name] = $value;\n"
    "        $this->headersMap[strtolower($name)] = $name;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withHeaders(array $headers): self\n"
    "    {\n"
    "        foreach ($headers as $name => $value) {\n"
    "            $this->withHeader($name, $value);\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getSetCookieHeaderLines(): array\n"
    "    {\n"
    "        return $this->setCookieHeaderLines;\n"
    "    }\n"
    "\n"
    "    public function withSetCookieHeaderLine(string $value): self\n"
    "    {\n"
    "        $this->setCookieHeaderLines[] = $value;\n"
    "        return $this;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_fast_cgi_client =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine\\FastCGI;\n"
    "\n"
    "use InvalidArgumentException;\n"
    "use Swoole\\Coroutine\\FastCGI\\Client\\Exception;\n"
    "use Swoole\\Coroutine\\Socket;\n"
    "use Swoole\\FastCGI\\FrameParser;\n"
    "use Swoole\\FastCGI\\HttpRequest;\n"
    "use Swoole\\FastCGI\\HttpResponse;\n"
    "use Swoole\\FastCGI\\Record\\EndRequest;\n"
    "use Swoole\\FastCGI\\Request;\n"
    "use Swoole\\FastCGI\\Response;\n"
    "\n"
    "class Client\n"
    "{\n"
    "    /** @var int */\n"
    "    protected $af;\n"
    "\n"
    "    /** @var string */\n"
    "    protected $host;\n"
    "\n"
    "    /** @var int */\n"
    "    protected $port;\n"
    "\n"
    "    /** @var bool */\n"
    "    protected $ssl;\n"
    "\n"
    "    /** @var Socket */\n"
    "    protected $socket;\n"
    "\n"
    "    public function __construct(string $host, int $port = 0, bool $ssl = false)\n"
    "    {\n"
    "        if (stripos($host, 'unix:/') === 0) {\n"
    "            $this->af = AF_UNIX;\n"
    "            $host = '/' . ltrim(substr($host, strlen('unix:/')), '/');\n"
    "            $port = 0;\n"
    "        } elseif (strpos($host, ':') !== false) {\n"
    "            $this->af = AF_INET6;\n"
    "        } else {\n"
    "            $this->af = AF_INET;\n"
    "        }\n"
    "        $this->host = $host;\n"
    "        $this->port = $port;\n"
    "        $this->ssl = $ssl;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @throws Exception\n"
    "     * @return HttpResponse|Response\n"
    "     */\n"
    "    public function execute(Request $request, float $timeout = -1): Response\n"
    "    {\n"
    "        if (!$this->socket) {\n"
    "            $this->socket = $socket = new Socket($this->af, SOCK_STREAM, IPPROTO_IP);\n"
    "            $socket->setProtocol([\n"
    "                'open_ssl' => $this->ssl,\n"
    "                'open_fastcgi_protocol' => true,\n"
    "            ]);\n"
    "            if (!$socket->connect($this->host, $this->port, $timeout)) {\n"
    "                $this->ioException();\n"
    "            }\n"
    "        } else {\n"
    "            $socket = $this->socket;\n"
    "        }\n"
    "        $sendData = (string) $request;\n"
    "        if ($socket->sendAll($sendData) !== strlen($sendData)) {\n"
    "            $this->ioException();\n"
    "        }\n"
    "        $records = [];\n"
    "        while (true) {\n"
    "            if (SWOOLE_VERSION_ID < 40500) {\n"
    "                $recvData = '';\n"
    "                while (true) {\n"
    "                    $tmp = $socket->recv(8192, $timeout);\n"
    "                    if (!$tmp) {\n"
    "                        if ($tmp === '') {\n"
    "                            $this->ioException(SOCKET_ECONNRESET);\n"
    "                        }\n"
    "                        $this->ioException();\n"
    "                    }\n"
    "                    $recvData .= $tmp;\n"
    "                    if (FrameParser::hasFrame($recvData)) {\n"
    "                        break;\n"
    "                    }\n"
    "                }\n"
    "            } else {\n"
    "                $recvData = $socket->recvPacket($timeout);\n"
    "                if (!$recvData) {\n"
    "                    if ($recvData === '') {\n"
    "                        $this->ioException(SOCKET_ECONNRESET);\n"
    "                    }\n"
    "                    $this->ioException();\n"
    "                }\n"
    "                if (!FrameParser::hasFrame($recvData)) {\n"
    "                    $this->ioException(SOCKET_EPROTO);\n"
    "                }\n"
    "            }\n"
    "            do {\n"
    "                $records[] = $record = FrameParser::parseFrame($recvData);\n"
    "            } while (strlen($recvData) !== 0);\n"
    "            if ($record instanceof EndRequest) {\n"
    "                if (!$request->getKeepConn()) {\n"
    "                    $this->socket->close();\n"
    "                    $this->socket = null;\n"
    "                }\n"
    "                switch (true) {\n"
    "                    case $request instanceof HttpRequest:\n"
    "                        return new HttpResponse($records);\n"
    "                    default:\n"
    "                        return new Response($records);\n"
    "                }\n"
    "            }\n"
    "        }\n"
    "        /* never here */\n"
    "        exit(1);\n"
    "    }\n"
    "\n"
    "    public static function parseUrl(string $url): array\n"
    "    {\n"
    "        $url = parse_url($url);\n"
    "        $host = $url['host'] ?? '';\n"
    "        $port = $url['port'] ?? 0;\n"
    "        if (empty($host)) {\n"
    "            $host = $url['path'] ?? '';\n"
    "            if (empty($host)) {\n"
    "                throw new InvalidArgumentException('Invalid url');\n"
    "            }\n"
    "            $host = \"unix:/{$host}\";\n"
    "        }\n"
    "        return [$host, $port];\n"
    "    }\n"
    "\n"
    "    public static function call(string $url, string $path, $data = '', float $timeout = -1): string\n"
    "    {\n"
    "        $client = new Client(...static::parseUrl($url));\n"
    "        $pathInfo = parse_url($path);\n"
    "        $path = $pathInfo['path'] ?? '';\n"
    "        $root = dirname($path);\n"
    "        $scriptName = '/' . basename($path);\n"
    "        $documentUri = $scriptName;\n"
    "        $query = $pathInfo['query'] ?? '';\n"
    "        $requestUri = $query ? \"{$documentUri}?{$query}\" : $documentUri;\n"
    "        $request = new HttpRequest();\n"
    "        $request->withDocumentRoot($root)\n"
    "            ->withScriptFilename($path)\n"
    "            ->withScriptName($documentUri)\n"
    "            ->withDocumentUri($documentUri)\n"
    "            ->withRequestUri($requestUri)\n"
    "            ->withQueryString($query)\n"
    "            ->withBody($data)\n"
    "            ->withMethod($request->getContentLength() === 0 ? 'GET' : 'POST');\n"
    "        $response = $client->execute($request, $timeout);\n"
    "        return $response->getBody();\n"
    "    }\n"
    "\n"
    "    protected function ioException(?int $errno = null): void\n"
    "    {\n"
    "        $socket = $this->socket;\n"
    "        if ($errno !== null) {\n"
    "            $socket->errCode = $errno;\n"
    "            $socket->errMsg = swoole_strerror($errno);\n"
    "        }\n"
    "        $socket->close();\n"
    "        $this->socket = null;\n"
    "        throw new Exception($socket->errMsg, $socket->errCode);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_fast_cgi_client_exception =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine\\FastCGI\\Client;\n"
    "\n"
    "class Exception extends \\Swoole\\Exception\n"
    "{\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_fast_cgi_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine\\FastCGI;\n"
    "\n"
    "use InvalidArgumentException;\n"
    "use Swoole\\FastCGI\\HttpRequest;\n"
    "use Swoole\\FastCGI\\HttpResponse;\n"
    "use Swoole\\Http;\n"
    "\n"
    "class Proxy\n"
    "{\n"
    "    /* @var string */\n"
    "    protected $host;\n"
    "\n"
    "    /* @var int */\n"
    "    protected $port;\n"
    "\n"
    "    /* @var float */\n"
    "    protected $timeout = -1;\n"
    "\n"
    "    /* @var string */\n"
    "    protected $documentRoot;\n"
    "\n"
    "    /* @var bool */\n"
    "    protected $https = false;\n"
    "\n"
    "    /* @var string */\n"
    "    protected $index = 'index.php';\n"
    "\n"
    "    /* @var array */\n"
    "    protected $params = [];\n"
    "\n"
    "    /* @var null|callable */\n"
    "    protected $staticFileFilter;\n"
    "\n"
    "    public function __construct(string $url, string $documentRoot = '/')\n"
    "    {\n"
    "        [$this->host, $this->port] = Client::parseUrl($url);\n"
    "        $this->documentRoot = $documentRoot;\n"
    "        $this->staticFileFilter = [$this, 'staticFileFiltrate'];\n"
    "    }\n"
    "\n"
    "    public function withTimeout(float $timeout): self\n"
    "    {\n"
    "        $this->timeout = $timeout;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withHttps(bool $https): self\n"
    "    {\n"
    "        $this->https = $https;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withIndex(string $index): self\n"
    "    {\n"
    "        $this->index = $index;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getParam(string $name): ?string\n"
    "    {\n"
    "        return $this->params[$name] ?? null;\n"
    "    }\n"
    "\n"
    "    public function withParam(string $name, string $value): self\n"
    "    {\n"
    "        $this->params[$name] = $value;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withoutParam(string $name): self\n"
    "    {\n"
    "        unset($this->params[$name]);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getParams(): array\n"
    "    {\n"
    "        return $this->params;\n"
    "    }\n"
    "\n"
    "    public function withParams(array $params): self\n"
    "    {\n"
    "        $this->params = $params;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withAddedParams(array $params): self\n"
    "    {\n"
    "        $this->params = $params + $this->params;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withStaticFileFilter(?callable $filter): self\n"
    "    {\n"
    "        $this->staticFileFilter = $filter;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function translateRequest($userRequest): HttpRequest\n"
    "    {\n"
    "        $request = new HttpRequest();\n"
    "        if ($userRequest instanceof \\Swoole\\Http\\Request) {\n"
    "            $server = $userRequest->server;\n"
    "            $headers = $userRequest->header;\n"
    "            $pathInfo = $userRequest->server['path_info'];\n"
    "            $pathInfo = '/' . (ltrim($pathInfo, '/'));\n"
    "            if (strlen($this->index) !== 0) {\n"
    "                $extension = pathinfo($pathInfo, PATHINFO_EXTENSION);\n"
    "                if (empty($extension)) {\n"
    "                    $pathInfo = rtrim($pathInfo, '/') . '/' . $this->index;\n"
    "                }\n"
    "            }\n"
    "            $requestUri = $scriptName = $documentUri = $server['request_uri'];\n"
    "            $queryString = $server['query_string'] ?? '';\n"
    "            if (strlen($queryString) !== 0) {\n"
    "                $requestUri .= \"?{$server['query_string']}\";\n"
    "            }\n"
    "            $request\n"
    "                ->withDocumentRoot($this->documentRoot)\n"
    "                ->withScriptFilename($this->documentRoot . $pathInfo)\n"
    "                ->withScriptName($scriptName)\n"
    "                ->withDocumentUri($documentUri)\n"
    "                ->withServerProtocol($server['server_protocol'])\n"
    "                ->withServerAddr('127.0.0.1')\n"
    "                ->withServerPort($server['server_port'])\n"
    "                ->withRemoteAddr($server['remote_addr'])\n"
    "                ->withRemotePort($server['remote_port'])\n"
    "                ->withMethod($server['request_method'])\n"
    "                ->withRequestUri($requestUri)\n"
    "                ->withQueryString($queryString)\n"
    "                ->withContentType($headers['content-type'] ?? '')\n"
    "                ->withContentLength((int) ($headers['content-length'] ?? 0))\n"
    "                ->withHeaders($headers)\n"
    "                ->withBody($userRequest->rawContent())\n"
    "                ->withAddedParams($this->params);\n"
    "            if ($this->https) {\n"
    "                $request->withParam('HTTPS', '1');\n"
    "            }\n"
    "        } else {\n"
    "            throw new InvalidArgumentException('Not supported on ' . get_class($userRequest));\n"
    "        }\n"
    "        return $request;\n"
    "    }\n"
    "\n"
    "    public function translateResponse(HttpResponse $response, $userResponse): void\n"
    "    {\n"
    "        if ($userResponse instanceof \\Swoole\\Http\\Response) {\n"
    "            $userResponse->status($response->getStatusCode(), $response->getReasonPhrase());\n"
    "            $userResponse->header = $response->getHeaders();\n"
    "            $userResponse->cookie = $response->getSetCookieHeaderLines();\n"
    "            $userResponse->end($response->getBody());\n"
    "        } else {\n"
    "            throw new InvalidArgumentException('Not supported on ' . get_class($userResponse));\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function pass($userRequest, $userResponse): void\n"
    "    {\n"
    "        if (!($userRequest instanceof HttpRequest)) {\n"
    "            $request = $this->translateRequest($userRequest);\n"
    "        } else {\n"
    "            $request = $userRequest;\n"
    "        }\n"
    "        unset($userRequest);\n"
    "        if ($this->staticFileFilter) {\n"
    "            $filter = $this->staticFileFilter;\n"
    "            if ($filter($request, $userResponse)) {\n"
    "                return;\n"
    "            }\n"
    "        }\n"
    "        $client = new Client($this->host, $this->port);\n"
    "        $response = $client->execute($request, $this->timeout);\n"
    "        $this->translateResponse($response, $userResponse);\n"
    "    }\n"
    "\n"
    "    /* @return bool ['hit' => true, 'miss' => false] */\n"
    "    public function staticFileFiltrate(HttpRequest $request, $userResponse): bool\n"
    "    {\n"
    "        if ($userResponse instanceof \\Swoole\\Http\\Response) {\n"
    "            $extension = pathinfo($request->getScriptFilename(), PATHINFO_EXTENSION);\n"
    "            if ($extension !== 'php') {\n"
    "                $realPath = realpath($request->getScriptFilename());\n"
    "                if (!$realPath || strpos($realPath, $this->documentRoot) !== 0 || !is_file($realPath)) {\n"
    "                    $userResponse->status(Http\\Status::NOT_FOUND);\n"
    "                } else {\n"
    "                    $userResponse->sendfile($realPath);\n"
    "                }\n"
    "                return true;\n"
    "            }\n"
    "            return false;\n"
    "        }\n"
    "        throw new InvalidArgumentException('Not supported on ' . get_class($userResponse));\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_process_manager =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Process;\n"
    "\n"
    "use Swoole\\Constant;\n"
    "use function Swoole\\Coroutine\\run;\n"
    "\n"
    "class Manager\n"
    "{\n"
    "    /**\n"
    "     * @var Pool\n"
    "     */\n"
    "    protected $pool;\n"
    "\n"
    "    /**\n"
    "     * @var int\n"
    "     */\n"
    "    protected $ipcType = SWOOLE_IPC_NONE;\n"
    "\n"
    "    /**\n"
    "     * @var int\n"
    "     */\n"
    "    protected $msgQueueKey = 0;\n"
    "\n"
    "    /**\n"
    "     * @var array\n"
    "     */\n"
    "    protected $startFuncMap = [];\n"
    "\n"
    "    public function __construct(int $ipcType = SWOOLE_IPC_NONE, int $msgQueueKey = 0)\n"
    "    {\n"
    "        $this->setIPCType($ipcType)->setMsgQueueKey($msgQueueKey);\n"
    "    }\n"
    "\n"
    "    public function add(callable $func, bool $enableCoroutine = false): self\n"
    "    {\n"
    "        $this->addBatch(1, $func, $enableCoroutine);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function addBatch(int $workerNum, callable $func, bool $enableCoroutine = false): self\n"
    "    {\n"
    "        for ($i = 0; $i < $workerNum; $i++) {\n"
    "            $this->startFuncMap[] = [$func, $enableCoroutine];\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function start(): void\n"
    "    {\n"
    "        $this->pool = new Pool(count($this->startFuncMap), $this->ipcType, $this->msgQueueKey, false);\n"
    "\n"
    "        $this->pool->on(Constant::EVENT_WORKER_START, function (Pool $pool, int $workerId) {\n"
    "            [$func, $enableCoroutine] = $this->startFuncMap[$workerId];\n"
    "            if ($enableCoroutine) {\n"
    "                run($func, $pool, $workerId);\n"
    "            } else {\n"
    "                $func($pool, $workerId);\n"
    "            }\n"
    "        });\n"
    "\n"
    "        $this->pool->start();\n"
    "    }\n"
    "\n"
    "    public function setIPCType(int $ipcType): self\n"
    "    {\n"
    "        $this->ipcType = $ipcType;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getIPCType(): int\n"
    "    {\n"
    "        return $this->ipcType;\n"
    "    }\n"
    "\n"
    "    public function setMsgQueueKey(int $msgQueueKey): self\n"
    "    {\n"
    "        $this->msgQueueKey = $msgQueueKey;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getMsgQueueKey(): int\n"
    "    {\n"
    "        return $this->msgQueueKey;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_server_helper =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Server;\n"
    "\n"
    "use Swoole\\Server;\n"
    "use Swoole\\Timer;\n"
    "\n"
    "class Helper\n"
    "{\n"
    "    const STATS_TIMER_INTERVAL_TIME = 1000;\n"
    "\n"
    "    const GLOBAL_OPTIONS = [\n"
    "        'debug_mode' => true,\n"
    "        'trace_flags' => true,\n"
    "        'log_file' => true,\n"
    "        'log_level' => true,\n"
    "        'log_date_format' => true,\n"
    "        'log_date_with_microseconds' => true,\n"
    "        'log_rotation' => true,\n"
    "        'display_errors' => true,\n"
    "        'dns_server' => true,\n"
    "        'socket_dns_timeout' => true,\n"
    "        'socket_connect_timeout' => true,\n"
    "        'socket_write_timeout' => true,\n"
    "        'socket_send_timeout' => true,\n"
    "        'socket_read_timeout' => true,\n"
    "        'socket_recv_timeout' => true,\n"
    "        'socket_buffer_size' => true,\n"
    "        'socket_timeout' => true,\n"
    "    ];\n"
    "\n"
    "    const SERVER_OPTIONS = [\n"
    "        'chroot' => true,\n"
    "        'user' => true,\n"
    "        'group' => true,\n"
    "        'daemonize' => true,\n"
    "        'pid_file' => true,\n"
    "        'reactor_num' => true,\n"
    "        'single_thread' => true,\n"
    "        'worker_num' => true,\n"
    "        'max_wait_time' => true,\n"
    "        'max_queued_bytes' => true,\n"
    "        'enable_coroutine' => true,\n"
    "        'max_coro_num' => true,\n"
    "        'max_coroutine' => true,\n"
    "        'hook_flags' => true,\n"
    "        'send_timeout' => true,\n"
    "        'dispatch_mode' => true,\n"
    "        'send_yield' => true,\n"
    "        'dispatch_func' => true,\n"
    "        'discard_timeout_request' => true,\n"
    "        'enable_unsafe_event' => true,\n"
    "        'enable_delay_receive' => true,\n"
    "        'enable_reuse_port' => true,\n"
    "        'task_use_object' => true,\n"
    "        'task_object' => true,\n"
    "        'event_object' => true,\n"
    "        'task_enable_coroutine' => true,\n"
    "        'task_worker_num' => true,\n"
    "        'task_ipc_mode' => true,\n"
    "        'task_tmpdir' => true,\n"
    "        'task_max_request' => true,\n"
    "        'task_max_request_grace' => true,\n"
    "        'max_connection' => true,\n"
    "        'max_conn' => true,\n"
    "        'start_session_id' => true,\n"
    "        'heartbeat_check_interval' => true,\n"
    "        'heartbeat_idle_time' => true,\n"
    "        'max_request' => true,\n"
    "        'max_request_grace' => true,\n"
    "        'reload_async' => true,\n"
    "        'open_cpu_affinity' => true,\n"
    "        'cpu_affinity_ignore' => true,\n"
    "        'http_parse_cookie' => true,\n"
    "        'http_parse_post' => true,\n"
    "        'http_parse_files' => true,\n"
    "        'http_compression' => true,\n"
    "        'http_compression_level' => true,\n"
    "        'compression_min_length' => true,\n"
    "        'http_gzip_level' => true,\n"
    "        'websocket_compression' => true,\n"
    "        'upload_tmp_dir' => true,\n"
    "        'enable_static_handler' => true,\n"
    "        'document_root' => true,\n"
    "        'http_autoindex' => true,\n"
    "        'http_index_files' => true,\n"
    "        'static_handler_locations' => true,\n"
    "        'input_buffer_size' => true,\n"
    "        'buffer_input_size' => true,\n"
    "        'output_buffer_size' => true,\n"
    "        'buffer_output_size' => true,\n"
    "        'message_queue_key' => true,\n"
    "    ];\n"
    "\n"
    "    const PORT_OPTIONS = [\n"
    "        'ssl_cert_file' => true,\n"
    "        'ssl_key_file' => true,\n"
    "        'backlog' => true,\n"
    "        'socket_buffer_size' => true,\n"
    "        'kernel_socket_recv_buffer_size' => true,\n"
    "        'kernel_socket_send_buffer_size' => true,\n"
    "        'buffer_high_watermark' => true,\n"
    "        'buffer_low_watermark' => true,\n"
    "        'open_tcp_nodelay' => true,\n"
    "        'tcp_defer_accept' => true,\n"
    "        'open_tcp_keepalive' => true,\n"
    "        'open_eof_check' => true,\n"
    "        'open_eof_split' => true,\n"
    "        'package_eof' => true,\n"
    "        'open_http_protocol' => true,\n"
    "        'open_websocket_protocol' => true,\n"
    "        'websocket_subprotocol' => true,\n"
    "        'open_websocket_close_frame' => true,\n"
    "        'open_websocket_ping_frame' => true,\n"
    "        'open_websocket_pong_frame' => true,\n"
    "        'open_http2_protocol' => true,\n"
    "        'open_mqtt_protocol' => true,\n"
    "        'open_redis_protocol' => true,\n"
    "        'max_idle_time' => true,\n"
    "        'tcp_keepidle' => true,\n"
    "        'tcp_keepinterval' => true,\n"
    "        'tcp_keepcount' => true,\n"
    "        'tcp_user_timeout' => true,\n"
    "        'tcp_fastopen' => true,\n"
    "        'open_length_check' => true,\n"
    "        'package_length_type' => true,\n"
    "        'package_length_offset' => true,\n"
    "        'package_body_offset' => true,\n"
    "        'package_body_start' => true,\n"
    "        'package_length_func' => true,\n"
    "        'package_max_length' => true,\n"
    "        'ssl_compress' => true,\n"
    "        'ssl_protocols' => true,\n"
    "        'ssl_verify_peer' => true,\n"
    "        'ssl_allow_self_signed' => true,\n"
    "        'ssl_client_cert_file' => true,\n"
    "        'ssl_verify_depth' => true,\n"
    "        'ssl_prefer_server_ciphers' => true,\n"
    "        'ssl_ciphers' => true,\n"
    "        'ssl_ecdh_curve' => true,\n"
    "        'ssl_dhparam' => true,\n"
    "        'ssl_sni_certs' => true,\n"
    "    ];\n"
    "\n"
    "    const HELPER_OPTIONS = [\n"
    "        'stats_file' => true,\n"
    "    ];\n"
    "\n"
    "    public static function checkOptions(array $input_options)\n"
    "    {\n"
    "        $const_options = self::GLOBAL_OPTIONS + self::SERVER_OPTIONS + self::PORT_OPTIONS + self::HELPER_OPTIONS;\n"
    "\n"
    "        foreach ($input_options as $k => $v) {\n"
    "            if (!array_key_exists(strtolower($k), $const_options)) {\n"
    "                //TODO throw exception\n"
    "                trigger_error(\"unsupported option [{$k}]\", E_USER_WARNING);\n"
    "                debug_print_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS);\n"
    "            }\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public static function onWorkerStart(Server $server, int $workerId)\n"
    "    {\n"
    "        if (!empty($server->setting['stats_file']) and $workerId == 0) {\n"
    "            $server->stats_timer = Timer::tick(self::STATS_TIMER_INTERVAL_TIME, function () use ($server) {\n"
    "                $stats = $server->stats();\n"
    "                $lines = [];\n"
    "                foreach ($stats as $k => $v) {\n"
    "                    $lines[] = \"{$k}: {$v}\";\n"
    "                }\n"
    "                $out = implode(\"\\n\", $lines);\n"
    "                file_put_contents($server->setting['stats_file'], $out);\n"
    "            });\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public static function onWorkerExit(Server $server, int $workerId)\n"
    "    {\n"
    "        if ($server->stats_timer) {\n"
    "            Timer::clear($server->stats_timer);\n"
    "            $server->stats_timer = null;\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public static function onWorkerStop(Server $server, int $workerId)\n"
    "    {\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_functions =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine;\n"
    "\n"
    "use Swoole\\Coroutine;\n"
    "\n"
    "function run(callable $fn, ...$args)\n"
    "{\n"
    "    $s = new Scheduler();\n"
    "    $options = Coroutine::getOptions();\n"
    "    if (!isset($options['hook_flags'])) {\n"
    "        $s->set(['hook_flags' => SWOOLE_HOOK_ALL]);\n"
    "    }\n"
    "    $s->add($fn, ...$args);\n"
    "    return $s->start();\n"
    "}\n"
    "\n"
    "function go(callable $fn, ...$args)\n"
    "{\n"
    "    Coroutine::create($fn, ...$args);\n"
    "}\n"
    "\n"
    "function defer(callable $fn)\n"
    "{\n"
    "    Coroutine::defer($fn);\n"
    "}\n"
    "\n"
    "function batch(array $tasks, float $timeout = -1): array\n"
    "{\n"
    "    $wg = new WaitGroup(count($tasks));\n"
    "    foreach ($tasks as $id => $task) {\n"
    "        Coroutine::create(function () use ($wg, &$tasks, $id, $task) {\n"
    "            $tasks[$id] = null;\n"
    "            $tasks[$id] = $task();\n"
    "            $wg->done();\n"
    "        });\n"
    "    }\n"
    "    $wg->wait($timeout);\n"
    "    return $tasks;\n"
    "}\n"
    "\n"
    "function parallel(int $n, callable $fn): void\n"
    "{\n"
    "    $count = $n;\n"
    "    $wg = new WaitGroup($n);\n"
    "    while ($count--) {\n"
    "        Coroutine::create(function () use ($fn, $wg) {\n"
    "            $fn();\n"
    "            $wg->done();\n"
    "        });\n"
    "    }\n"
    "    $wg->wait();\n"
    "}\n"
    "\n"
    "function map(array $list, callable $fn, float $timeout = -1): array\n"
    "{\n"
    "    $wg = new WaitGroup(count($list));\n"
    "    foreach ($list as $id => $elem) {\n"
    "        Coroutine::create(function () use ($wg, &$list, $id, $elem, $fn): void {\n"
    "            $list[$id] = null;\n"
    "            $list[$id] = $fn($elem);\n"
    "            $wg->done();\n"
    "        });\n"
    "    }\n"
    "    $wg->wait($timeout);\n"
    "    return $list;\n"
    "}\n"
    "\n"
    "function deadlock_check()\n"
    "{\n"
    "    $all_coroutines = Coroutine::listCoroutines();\n"
    "    $count = Coroutine::stats()['coroutine_num'];\n"
    "    echo \"\\n===================================================================\",\n"
    "    \"\\n [FATAL ERROR]: all coroutines (count: {$count}) are asleep - deadlock!\",\n"
    "    \"\\n===================================================================\\n\";\n"
    "\n"
    "    $options = Coroutine::getOptions();\n"
    "    if (empty($options['deadlock_check_disable_trace'])) {\n"
    "        $index = 0;\n"
    "        $limit = empty($options['deadlock_check_limit']) ? 32 : intval($options['deadlock_check_limit']);\n"
    "        $depth = empty($options['deadlock_check_depth']) ? 32 : intval($options['deadlock_check_depth']);\n"
    "        foreach ($all_coroutines as $cid) {\n"
    "            echo \"\\n [Coroutine-{$cid}]\";\n"
    "            echo \"\\n--------------------------------------------------------------------\\n\";\n"
    "            echo Coroutine::printBackTrace($cid, DEBUG_BACKTRACE_IGNORE_ARGS, $depth);\n"
    "            echo \"\\n\";\n"
    "            $index++;\n"
    "            //limit the number of maximum outputs\n"
    "            if ($index >= $limit) {\n"
    "                break;\n"
    "            }\n"
    "        }\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_ext_curl =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "/* @noinspection PhpComposerExtensionStubsInspection */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "function swoole_curl_init(string $url = ''): Swoole\\Curl\\Handler\n"
    "{\n"
    "    return new Swoole\\Curl\\Handler($url);\n"
    "}\n"
    "\n"
    "function swoole_curl_setopt(Swoole\\Curl\\Handler $obj, int $opt, $value): bool\n"
    "{\n"
    "    return $obj->setOpt($opt, $value);\n"
    "}\n"
    "\n"
    "function swoole_curl_setopt_array(Swoole\\Curl\\Handler $obj, $array): bool\n"
    "{\n"
    "    foreach ($array as $k => $v) {\n"
    "        if ($obj->setOpt($k, $v) !== true) {\n"
    "            return false;\n"
    "        }\n"
    "    }\n"
    "    return true;\n"
    "}\n"
    "\n"
    "function swoole_curl_exec(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->exec();\n"
    "}\n"
    "\n"
    "function swoole_curl_getinfo(Swoole\\Curl\\Handler $obj, int $opt = 0)\n"
    "{\n"
    "    $info = $obj->getInfo();\n"
    "    if (is_array($info) and $opt) {\n"
    "        switch ($opt) {\n"
    "            case CURLINFO_EFFECTIVE_URL:\n"
    "                return $info['url'];\n"
    "            case CURLINFO_HTTP_CODE:\n"
    "                return $info['http_code'];\n"
    "            case CURLINFO_CONTENT_TYPE:\n"
    "                return $info['content_type'];\n"
    "            case CURLINFO_REDIRECT_COUNT:\n"
    "                return $info['redirect_count'];\n"
    "            case CURLINFO_REDIRECT_URL:\n"
    "                return $info['redirect_url'];\n"
    "            case CURLINFO_TOTAL_TIME:\n"
    "                return $info['total_time'];\n"
    "            case CURLINFO_STARTTRANSFER_TIME:\n"
    "                return $info['starttransfer_time'];\n"
    "            case CURLINFO_SIZE_DOWNLOAD:\n"
    "                return $info['size_download'];\n"
    "            case CURLINFO_SPEED_DOWNLOAD:\n"
    "                return $info['speed_download'];\n"
    "            case CURLINFO_REDIRECT_TIME:\n"
    "                return $info['redirect_time'];\n"
    "            case CURLINFO_HEADER_SIZE:\n"
    "                return $info['header_size'];\n"
    "            default:\n"
    "                return null;\n"
    "        }\n"
    "    }\n"
    "    return $info;\n"
    "}\n"
    "\n"
    "function swoole_curl_errno(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->errno();\n"
    "}\n"
    "\n"
    "function swoole_curl_error(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->error();\n"
    "}\n"
    "\n"
    "function swoole_curl_reset(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->reset();\n"
    "}\n"
    "\n"
    "function swoole_curl_close(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->close();\n"
    "}\n"
    "\n"
    "function swoole_curl_multi_getcontent(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->getContent();\n"
    "}\n";

static const char* swoole_library_source_ext_sockets =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "use Swoole\\Coroutine\\Socket;\n"
    "\n"
    "function swoole_socket_create(int $domain, int $type, int $protocol)\n"
    "{\n"
    "    return new Socket($domain, $type, $protocol);\n"
    "}\n"
    "\n"
    "function swoole_socket_connect(Socket $socket, string $address, int $port = 0)\n"
    "{\n"
    "    return $socket->connect($address, $port);\n"
    "}\n"
    "\n"
    "function swoole_socket_read(Socket $socket, int $length, int $type = PHP_BINARY_READ)\n"
    "{\n"
    "    if ($type != PHP_BINARY_READ) {\n"
    "        return $socket->recvLine($length);\n"
    "    }\n"
    "    return $socket->recv($length);\n"
    "}\n"
    "\n"
    "function swoole_socket_write(Socket $socket, string $buffer, int $length = 0): int\n"
    "{\n"
    "    if ($length > 0 and $length < strlen($buffer)) {\n"
    "        $buffer = substr($buffer, 0, $length);\n"
    "    }\n"
    "    return $socket->send($buffer);\n"
    "}\n"
    "\n"
    "function swoole_socket_send(Socket $socket, string $buffer, int $length, int $flags): int\n"
    "{\n"
    "    if ($flags != 0) {\n"
    "        throw new RuntimeException(\"\\$flags[{$flags}] is not supported\");\n"
    "    }\n"
    "    return swoole_socket_write($socket, $buffer, $length);\n"
    "}\n"
    "\n"
    "function swoole_socket_recv(Socket $socket, &$buffer, int $length, int $flags)\n"
    "{\n"
    "    if ($flags & MSG_OOB) {\n"
    "        throw new RuntimeException('$flags[MSG_OOB] is not supported');\n"
    "    }\n"
    "    if ($flags & MSG_PEEK) {\n"
    "        $buffer = $socket->peek($length);\n"
    "    }\n"
    "    $timeout = $flags & MSG_DONTWAIT ? 0.001 : 0;\n"
    "    if ($flags & MSG_WAITALL) {\n"
    "        $buffer = $socket->recvAll($length, $timeout);\n"
    "    } else {\n"
    "        $buffer = $socket->recv($length, $timeout);\n"
    "    }\n"
    "    if ($buffer === false) {\n"
    "        return false;\n"
    "    }\n"
    "    return strlen($buffer);\n"
    "}\n"
    "\n"
    "function swoole_socket_sendto(Socket $socket, string $buffer, int $length, int $flags, string $addr, int $port = 0)\n"
    "{\n"
    "    if ($flags != 0) {\n"
    "        throw new RuntimeException(\"\\$flags[{$flags}] is not supported\");\n"
    "    }\n"
    "    if ($socket->type != SOCK_DGRAM) {\n"
    "        throw new RuntimeException('only supports dgram type socket');\n"
    "    }\n"
    "    if ($length > 0 and $length < strlen($buffer)) {\n"
    "        $buffer = substr($buffer, 0, $length);\n"
    "    }\n"
    "    return $socket->sendto($addr, $port, $buffer);\n"
    "}\n"
    "\n"
    "function swoole_socket_recvfrom(Socket $socket, &$buffer, int $length, int $flags, &$name, &$port)\n"
    "{\n"
    "    if ($flags != 0) {\n"
    "        throw new RuntimeException(\"\\$flags[{$flags}] is not supported\");\n"
    "    }\n"
    "    if ($socket->type != SOCK_DGRAM) {\n"
    "        throw new RuntimeException('only supports dgram type socket');\n"
    "    }\n"
    "    $data = $socket->recvfrom($peer);\n"
    "    if ($data === false) {\n"
    "        return false;\n"
    "    }\n"
    "    $name = $peer['address'];\n"
    "    if (func_num_args() == 6) {\n"
    "        $port = $peer['port'];\n"
    "    }\n"
    "    if ($length < strlen($data)) {\n"
    "        $buffer = substr($data, 0, $length);\n"
    "    } else {\n"
    "        $buffer = $data;\n"
    "    }\n"
    "    return 100;\n"
    "}\n"
    "\n"
    "function swoole_socket_bind(Socket $socket, string $address, int $port = 0): bool\n"
    "{\n"
    "    return $socket->bind($address, $port);\n"
    "}\n"
    "\n"
    "function swoole_socket_listen(Socket $socket, int $backlog = 0): bool\n"
    "{\n"
    "    return $socket->listen($backlog);\n"
    "}\n"
    "\n"
    "function swoole_socket_create_listen(int $port, int $backlog = 128)\n"
    "{\n"
    "    $socket = new Socket(AF_INET, SOCK_STREAM, SOL_TCP);\n"
    "    if (!$socket->bind('0.0.0.0', $port)) {\n"
    "        return false;\n"
    "    }\n"
    "    if (!$socket->listen($backlog)) {\n"
    "        return false;\n"
    "    }\n"
    "    return $socket;\n"
    "}\n"
    "\n"
    "function swoole_socket_accept(Socket $socket)\n"
    "{\n"
    "    return $socket->accept();\n"
    "}\n"
    "\n"
    "function swoole_socket_getpeername(Socket $socket, &$address, &$port = null)\n"
    "{\n"
    "    $info = $socket->getpeername();\n"
    "    if (!$info) {\n"
    "        return false;\n"
    "    }\n"
    "    $address = $info['address'];\n"
    "    if (func_num_args() == 3) {\n"
    "        $port = $info['port'];\n"
    "    }\n"
    "    return true;\n"
    "}\n"
    "\n"
    "function swoole_socket_getsockname(Socket $socket, &$address, &$port = null)\n"
    "{\n"
    "    $info = $socket->getsockname();\n"
    "    if (!$info) {\n"
    "        return false;\n"
    "    }\n"
    "    $address = $info['address'];\n"
    "    if (func_num_args() == 3) {\n"
    "        $port = $info['port'];\n"
    "    }\n"
    "    return true;\n"
    "}\n"
    "\n"
    "function swoole_socket_set_option(Socket $socket, int $level, int $optname, $optval): bool\n"
    "{\n"
    "    return $socket->setOption($level, $optname, $optval);\n"
    "}\n"
    "\n"
    "function swoole_socket_setopt(Socket $socket, int $level, int $optname, $optval): bool\n"
    "{\n"
    "    return $socket->setOption($level, $optname, $optval);\n"
    "}\n"
    "\n"
    "function swoole_socket_get_option(Socket $socket, int $level, int $optname)\n"
    "{\n"
    "    return $socket->getOption($level, $optname);\n"
    "}\n"
    "\n"
    "function swoole_socket_getopt(Socket $socket, int $level, int $optname)\n"
    "{\n"
    "    return $socket->getOption($level, $optname);\n"
    "}\n"
    "\n"
    "function swoole_socket_shutdown(Socket $socket, int $how = 2)\n"
    "{\n"
    "    $socket->shutdown($how);\n"
    "}\n"
    "\n"
    "function swoole_socket_close(Socket $socket)\n"
    "{\n"
    "    $socket->close();\n"
    "}\n"
    "\n"
    "function swoole_socket_clear_error(Socket $socket = null)\n"
    "{\n"
    "    if ($socket) {\n"
    "        $socket->errCode = 0;\n"
    "    }\n"
    "    swoole_clear_error();\n"
    "}\n"
    "\n"
    "function swoole_socket_last_error(Socket $socket = null): int\n"
    "{\n"
    "    if ($socket) {\n"
    "        return $socket->errCode;\n"
    "    }\n"
    "    return swoole_last_error();\n"
    "}\n"
    "\n"
    "function swoole_socket_set_block(Socket $socket)\n"
    "{\n"
    "    if (isset($socket->__ext_sockets_nonblock) and $socket->__ext_sockets_nonblock) {\n"
    "        $socket->setOption(SOL_SOCKET, SO_RCVTIMEO, $socket->__ext_sockets_timeout);\n"
    "    }\n"
    "    $socket->__ext_sockets_nonblock = false;\n"
    "    return true;\n"
    "}\n"
    "\n"
    "function swoole_socket_set_nonblock(Socket $socket)\n"
    "{\n"
    "    if (isset($socket->__ext_sockets_nonblock) and $socket->__ext_sockets_nonblock) {\n"
    "        return true;\n"
    "    }\n"
    "    $socket->__ext_sockets_nonblock = true;\n"
    "    $socket->__ext_sockets_timeout = $socket->getOption(SOL_SOCKET, SO_RCVTIMEO);\n"
    "    $socket->setOption(SOL_SOCKET, SO_RCVTIMEO, ['sec' => 0, 'usec' => 1000]);\n"
    "    return true;\n"
    "}\n";

static const char* swoole_library_source_functions =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "if (PHP_VERSION_ID < 70200) {\n"
    "    throw new RuntimeException('require PHP version 7.2 or later');\n"
    "}\n"
    "\n"
    "if (SWOOLE_USE_SHORTNAME) {\n"
    "    function _string(string $string = ''): Swoole\\StringObject\n"
    "    {\n"
    "        return new Swoole\\StringObject($string);\n"
    "    }\n"
    "\n"
    "    function _mbstring(string $string = ''): Swoole\\MultibyteStringObject\n"
    "    {\n"
    "        return new Swoole\\MultibyteStringObject($string);\n"
    "    }\n"
    "\n"
    "    function _array(array $array = []): Swoole\\ArrayObject\n"
    "    {\n"
    "        return new Swoole\\ArrayObject($array);\n"
    "    }\n"
    "}\n"
    "\n"
    "function swoole_string(string $string = ''): Swoole\\StringObject\n"
    "{\n"
    "    return new Swoole\\StringObject($string);\n"
    "}\n"
    "\n"
    "function swoole_mbstring(string $string = ''): Swoole\\MultibyteStringObject\n"
    "{\n"
    "    return new Swoole\\MultibyteStringObject($string);\n"
    "}\n"
    "\n"
    "function swoole_array(array $array = []): Swoole\\ArrayObject\n"
    "{\n"
    "    return new Swoole\\ArrayObject($array);\n"
    "}\n"
    "\n"
    "function swoole_table(int $size, string $fields): Swoole\\Table\n"
    "{\n"
    "    $_fields = swoole_string($fields)->trim()->split(',');\n"
    "\n"
    "    $table = new Swoole\\Table($size, 0.25);\n"
    "\n"
    "    foreach ($_fields as $f) {\n"
    "        $_f = swoole_string($f)->trim()->split(':');\n"
    "        $name = $_f->get(0)->trim()->toString();\n"
    "        $type = $_f->get(1)->trim();\n"
    "\n"
    "        switch ($type) {\n"
    "        case 'i':\n"
    "        case 'int':\n"
    "            $table->column($name, Swoole\\Table::TYPE_INT);\n"
    "            break;\n"
    "        case 'f':\n"
    "        case 'float':\n"
    "            $table->column($name, Swoole\\Table::TYPE_FLOAT);\n"
    "            break;\n"
    "        case 's':\n"
    "        case 'string':\n"
    "            if ($_f->count() < 3) {\n"
    "                throw new RuntimeException('need to give string length');\n"
    "            }\n"
    "            $length = intval($_f->get(2)->trim()->toString());\n"
    "            if ($length <= 0) {\n"
    "                throw new RuntimeException(\"invalid string length[{$length}]\");\n"
    "            }\n"
    "            $table->column($name, Swoole\\Table::TYPE_STRING, $length);\n"
    "            break;\n"
    "        default:\n"
    "            throw new RuntimeException(\"unknown field type[{$type}]\");\n"
    "            break;\n"
    "        }\n"
    "    }\n"
    "\n"
    "    if (!$table->create()) {\n"
    "        throw new RuntimeException('failed to create table');\n"
    "    }\n"
    "\n"
    "    return $table;\n"
    "}\n"
    "\n"
    "function swoole_array_list(...$arrray): Swoole\\ArrayObject\n"
    "{\n"
    "    return new Swoole\\ArrayObject($arrray);\n"
    "}\n"
    "\n"
    "function swoole_array_default_value(array $array, $key, $default_value = null)\n"
    "{\n"
    "    return array_key_exists($key, $array) ? $array[$key] : $default_value;\n"
    "}\n"
    "\n"
    "if (!function_exists('array_key_last')) {\n"
    "    function array_key_last(array $array)\n"
    "    {\n"
    "        if (!empty($array)) {\n"
    "            return key(array_slice($array, -1, 1, true));\n"
    "        }\n"
    "        return null;\n"
    "    }\n"
    "}\n"
    "\n"
    "if (!function_exists('array_key_first')) {\n"
    "    function array_key_first(array $array)\n"
    "    {\n"
    "        foreach ($array as $key => $unused) {\n"
    "            return $key;\n"
    "        }\n"
    "        return null;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_alias =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "if (SWOOLE_USE_SHORTNAME) {\n"
    "    class_alias(Swoole\\Coroutine\\WaitGroup::class, Co\\WaitGroup::class, true);\n"
    "    class_alias(Swoole\\Coroutine\\Server::class, Co\\Server::class, true);\n"
    "    class_alias(Swoole\\Coroutine\\Server\\Connection::class, Co\\Server\\Connection::class, true);\n"
    "    class_alias(Swoole\\Coroutine\\FastCGI\\Client::class, Co\\FastCGI\\Client::class, true);\n"
    "    class_alias(Swoole\\Coroutine\\FastCGI\\Client\\Exception::class, Co\\FastCGI\\Client\\Exception::class, true);\n"
    "    class_alias(Swoole\\Coroutine\\FastCGI\\Proxy::class, Co\\FastCGI\\Proxy::class, true);\n"
    "}\n"
    "\n"
    "class_alias(Swoole\\Process\\Manager::class, Swoole\\Process\\ProcessManager::class, true);\n";

static const char* swoole_library_source_alias_ns =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Co;\n"
    "\n"
    "use Swoole\\Coroutine;\n"
    "\n"
    "if (SWOOLE_USE_SHORTNAME) {\n"
    "    function run(callable $fn, ...$args)\n"
    "    {\n"
    "        return \\Swoole\\Coroutine\\run($fn, ...$args);\n"
    "    }\n"
    "\n"
    "    function go(callable $fn, ...$args)\n"
    "    {\n"
    "        return Coroutine::create($fn, ...$args);\n"
    "    }\n"
    "\n"
    "    function defer(callable $fn)\n"
    "    {\n"
    "        Coroutine::defer($fn);\n"
    "    }\n"
    "}\n";

void php_swoole_load_library()
{
    zend::eval(swoole_library_source_constants, "@swoole-src/library/constants.php");
    zend::eval(swoole_library_source_std_exec, "@swoole-src/library/std/exec.php");
    zend::eval(swoole_library_source_core_constant, "@swoole-src/library/core/Constant.php");
    zend::eval(swoole_library_source_core_string_object, "@swoole-src/library/core/StringObject.php");
    zend::eval(swoole_library_source_core_multibyte_string_object, "@swoole-src/library/core/MultibyteStringObject.php");
    zend::eval(swoole_library_source_core_exception_array_key_not_exists, "@swoole-src/library/core/Exception/ArrayKeyNotExists.php");
    zend::eval(swoole_library_source_core_array_object, "@swoole-src/library/core/ArrayObject.php");
    zend::eval(swoole_library_source_core_object_proxy, "@swoole-src/library/core/ObjectProxy.php");
    zend::eval(swoole_library_source_core_coroutine_wait_group, "@swoole-src/library/core/Coroutine/WaitGroup.php");
    zend::eval(swoole_library_source_core_coroutine_server, "@swoole-src/library/core/Coroutine/Server.php");
    zend::eval(swoole_library_source_core_coroutine_server_connection, "@swoole-src/library/core/Coroutine/Server/Connection.php");
    zend::eval(swoole_library_source_core_coroutine_barrier, "@swoole-src/library/core/Coroutine/Barrier.php");
    zend::eval(swoole_library_source_core_coroutine_http_functions, "@swoole-src/library/core/Coroutine/Http/functions.php");
    zend::eval(swoole_library_source_core_connection_pool, "@swoole-src/library/core/ConnectionPool.php");
    zend::eval(swoole_library_source_core_database_object_proxy, "@swoole-src/library/core/Database/ObjectProxy.php");
    zend::eval(swoole_library_source_core_database_mysqli_config, "@swoole-src/library/core/Database/MysqliConfig.php");
    zend::eval(swoole_library_source_core_database_mysqli_exception, "@swoole-src/library/core/Database/MysqliException.php");
    zend::eval(swoole_library_source_core_database_mysqli_pool, "@swoole-src/library/core/Database/MysqliPool.php");
    zend::eval(swoole_library_source_core_database_mysqli_proxy, "@swoole-src/library/core/Database/MysqliProxy.php");
    zend::eval(swoole_library_source_core_database_mysqli_statement_proxy, "@swoole-src/library/core/Database/MysqliStatementProxy.php");
    zend::eval(swoole_library_source_core_database_pdo_config, "@swoole-src/library/core/Database/PDOConfig.php");
    zend::eval(swoole_library_source_core_database_pdo_pool, "@swoole-src/library/core/Database/PDOPool.php");
    zend::eval(swoole_library_source_core_database_pdo_proxy, "@swoole-src/library/core/Database/PDOProxy.php");
    zend::eval(swoole_library_source_core_database_pdo_statement_proxy, "@swoole-src/library/core/Database/PDOStatementProxy.php");
    zend::eval(swoole_library_source_core_database_redis_config, "@swoole-src/library/core/Database/RedisConfig.php");
    zend::eval(swoole_library_source_core_database_redis_pool, "@swoole-src/library/core/Database/RedisPool.php");
    zend::eval(swoole_library_source_core_http_status, "@swoole-src/library/core/Http/Status.php");
    zend::eval(swoole_library_source_core_curl_exception, "@swoole-src/library/core/Curl/Exception.php");
    zend::eval(swoole_library_source_core_curl_handler, "@swoole-src/library/core/Curl/Handler.php");
    zend::eval(swoole_library_source_core_fast_cgi, "@swoole-src/library/core/FastCGI.php");
    zend::eval(swoole_library_source_core_fast_cgi_record, "@swoole-src/library/core/FastCGI/Record.php");
    zend::eval(swoole_library_source_core_fast_cgi_record_params, "@swoole-src/library/core/FastCGI/Record/Params.php");
    zend::eval(swoole_library_source_core_fast_cgi_record_abort_request, "@swoole-src/library/core/FastCGI/Record/AbortRequest.php");
    zend::eval(swoole_library_source_core_fast_cgi_record_begin_request, "@swoole-src/library/core/FastCGI/Record/BeginRequest.php");
    zend::eval(swoole_library_source_core_fast_cgi_record_data, "@swoole-src/library/core/FastCGI/Record/Data.php");
    zend::eval(swoole_library_source_core_fast_cgi_record_end_request, "@swoole-src/library/core/FastCGI/Record/EndRequest.php");
    zend::eval(swoole_library_source_core_fast_cgi_record_get_values, "@swoole-src/library/core/FastCGI/Record/GetValues.php");
    zend::eval(swoole_library_source_core_fast_cgi_record_get_values_result, "@swoole-src/library/core/FastCGI/Record/GetValuesResult.php");
    zend::eval(swoole_library_source_core_fast_cgi_record_stdin, "@swoole-src/library/core/FastCGI/Record/Stdin.php");
    zend::eval(swoole_library_source_core_fast_cgi_record_stdout, "@swoole-src/library/core/FastCGI/Record/Stdout.php");
    zend::eval(swoole_library_source_core_fast_cgi_record_stderr, "@swoole-src/library/core/FastCGI/Record/Stderr.php");
    zend::eval(swoole_library_source_core_fast_cgi_record_unknown_type, "@swoole-src/library/core/FastCGI/Record/UnknownType.php");
    zend::eval(swoole_library_source_core_fast_cgi_frame_parser, "@swoole-src/library/core/FastCGI/FrameParser.php");
    zend::eval(swoole_library_source_core_fast_cgi_message, "@swoole-src/library/core/FastCGI/Message.php");
    zend::eval(swoole_library_source_core_fast_cgi_request, "@swoole-src/library/core/FastCGI/Request.php");
    zend::eval(swoole_library_source_core_fast_cgi_response, "@swoole-src/library/core/FastCGI/Response.php");
    zend::eval(swoole_library_source_core_fast_cgi_http_request, "@swoole-src/library/core/FastCGI/HttpRequest.php");
    zend::eval(swoole_library_source_core_fast_cgi_http_response, "@swoole-src/library/core/FastCGI/HttpResponse.php");
    zend::eval(swoole_library_source_core_coroutine_fast_cgi_client, "@swoole-src/library/core/Coroutine/FastCGI/Client.php");
    zend::eval(swoole_library_source_core_coroutine_fast_cgi_client_exception, "@swoole-src/library/core/Coroutine/FastCGI/Client/Exception.php");
    zend::eval(swoole_library_source_core_coroutine_fast_cgi_proxy, "@swoole-src/library/core/Coroutine/FastCGI/Proxy.php");
    zend::eval(swoole_library_source_core_process_manager, "@swoole-src/library/core/Process/Manager.php");
    zend::eval(swoole_library_source_core_server_helper, "@swoole-src/library/core/Server/Helper.php");
    zend::eval(swoole_library_source_core_coroutine_functions, "@swoole-src/library/core/Coroutine/functions.php");
    zend::eval(swoole_library_source_ext_curl, "@swoole-src/library/ext/curl.php");
    zend::eval(swoole_library_source_ext_sockets, "@swoole-src/library/ext/sockets.php");
    zend::eval(swoole_library_source_functions, "@swoole-src/library/functions.php");
    zend::eval(swoole_library_source_alias, "@swoole-src/library/alias.php");
    zend::eval(swoole_library_source_alias_ns, "@swoole-src/library/alias_ns.php");
}
