--TEST--
swoole_redis_coro: redis client get options
--SKIPIF--
<?php require __DIR__ . '/../include/skipif.inc'; ?>
--FILE--
<?php
require __DIR__ . '/../include/bootstrap.php';
Co::set([
    'connect_timeout' => 1,
    'socket_timeout' => -1
]);
$redis = new Swoole\Coroutine\Redis();
var_dump($redis->getOptions());
$redis->setOptions([
    'connect_timeout' => 0.001,
    'timeout' => 0.001,
    'serialize' => true,
    'reconnect' => 3
]);
var_dump($redis->getOptions());
?>
--EXPECT--
array(4) {
  ["connect_timeout"]=>
  float(1)
  ["timeout"]=>
  float(-1)
  ["serialize"]=>
  bool(false)
  ["reconnect"]=>
  int(1)
}
array(4) {
  ["connect_timeout"]=>
  float(0.001)
  ["timeout"]=>
  float(0.001)
  ["serialize"]=>
  bool(true)
  ["reconnect"]=>
  int(3)
}
